Object.entries || (Object.entries = function(e) {
  var i = [];
  for (k in e)
    typeof k == "string" && e.propertyIsEnumerable(k) && i.push([k, e[k]]);
  return i;
});
(function() {
  if (typeof navigator != "undefined" && navigator.userAgent) {
    var p = function(r, s) {
      s = s || {
        bubbles: !1,
        cancelable: !1,
        detail: void 0
      };
      var l = document.createEvent("CustomEvent");
      return l.initCustomEvent(r, s.bubbles, s.cancelable, s.detail), l;
    }, e = navigator.userAgent.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
    /trident|msie/i.test(e[1]) && (p.prototype = window.Event.prototype, window.CustomEvent = p, window.Event = p);
  }
})();
(function(p) {
  p && p.prototype && p.prototype.firstElementChild === void 0 && Object.defineProperty(p.prototype, "firstElementChild", {
    get: function() {
      for (var i, r = this.childNodes, s = 0; i = r[s++]; )
        if (i.nodeType === 1)
          return i;
      return null;
    }
  });
})(typeof window != "undefined" ? window.Node || window.Element : null);
var ot = /* @__PURE__ */ ((p) => (p[p.SILENT = 0] = "SILENT", p[p.ERROR = 1] = "ERROR", p[p.NORMAL = 2] = "NORMAL", p[p.VERBOSE = 3] = "VERBOSE", p))(ot || {}), Ne = /* @__PURE__ */ ((p) => (p[p.CRITICAL = 0] = "CRITICAL", p[p.ERROR = 1] = "ERROR", p[p.INFO = 2] = "INFO", p[p.TABLE = 3] = "TABLE", p[p.WARN = 4] = "WARN", p))(Ne || {});
let _t = ot.SILENT;
const Di = "[OIS_DEBUG]", Zs = {
  [ot.ERROR]: [Ne.CRITICAL, Ne.ERROR],
  [ot.NORMAL]: [Ne.INFO, Ne.TABLE, Ne.WARN],
  [ot.SILENT]: [],
  [ot.VERBOSE]: [Ne.CRITICAL, Ne.ERROR, Ne.INFO, Ne.TABLE, Ne.WARN]
};
function Zt() {
}
class c {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    _t = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return _t;
  }
  /**
   * Checks whether a specific log type should be logged based on the logging level.
   * @internal
   * @param {LOGTYPE} type - The type of log (e.g., 'CRITICAL', 'INFO', 'ERROR', 'TABLE', or 'WARN').
   * @param {LOGLEVEL} level - The current logging level.
   * @returns {boolean} - `true` if the log type should be logged, otherwise `false`.
   */
  static shouldLog(e, i) {
    return i !== ot.SILENT && Zs[i].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(Ne.CRITICAL, _t) ? console.error : Zt).bind(console, Di),
      info: (this.shouldLog(Ne.INFO, _t) ? console.info : Zt).bind(console, Di),
      error: (this.shouldLog(Ne.ERROR, _t) ? console.error : Zt).bind(console, Di),
      table: (this.shouldLog(Ne.TABLE, _t) ? console.table : Zt).bind(console),
      warn: (this.shouldLog(Ne.WARN, _t) ? console.warn : Zt).bind(console, Di)
    };
  }
}
const eo = "4.0";
class to {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, i) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return eo;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, i = !0, r = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, i) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var he = /* @__PURE__ */ ((p) => (p.LINEAR = "linear", p.NON_LINEAR = "nonlinear", p))(he || {});
class z {
  /**
   * Converts a time duration string into the equivalent time in seconds.
   *
   * @param {string} durationString - The time duration string in the format 'HH:MM:SS' to be converted.
   * @returns {number|null} The time duration in seconds or null if the input is invalid.
   */
  static convertTimeStringToSeconds(e) {
    const i = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(i) ? null : i / 1e3;
  }
  /**
   * Returns the most nested child within an Element (NodeTree) that matches the specified selector,
   * or group of selectors. If no matches are found, `null is returned.
   * (identically to the `Element` method `querySelector()`)
   *
   * @param {Element} baseElement - A DOM object that is scanned for an element that matches the specified selectors.
   * @param {string} selectors - A `DOMString` containing one or more selectors to match.
   * This string must be a valid CSS selector string.
   *
   * @returns {HTMLElement|null} - An HTMLElement object representing the element that matches
   * the specified set of CSS selectors, or null is returned if there are no matches.
   */
  static getMostNestedElement(e, i) {
    const r = Array.from(e.querySelectorAll(i));
    let s = -1, l = null;
    return r.forEach((h) => {
      let A = 0, g = h;
      for (; g.parentNode !== e; )
        A++, g = g.parentNode;
      A > s && (s = A, l = h);
    }), l;
  }
  /**
   * Creates a new Array with unique elements in it.
   *
   * @param {Array} array - The array to be cleaned of duplicates.
   * @param {string} uniqueValue - The property to search for duplicates in the array.
   * @returns {Array} - An array with unique elements defined by uniqueValue.
   */
  static getUnique(e, i) {
    const r = e.map((l) => l[i]);
    return e.filter((l, h) => !r.includes(l[i], h + 1));
  }
  /**
   * This function trims a string and returns it, unless the string is empty, null, or contains only the value 'null'.
   *
   * @param {string} resultString - The string to be checked.
   * @returns {string|null} The trimmed string or null if the string is empty, null, or 'null'.
   */
  static trim(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
}
class io {
  constructor(e) {
    this.adSourceXML = e, this.adSource = this.adSourceXML.querySelector("AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? z.trim(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : z.trim(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const Lt = class Lt {
  constructor(e, i = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = i, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return he.NON_LINEAR;
      default:
        return he.LINEAR;
    }
  }
  /**
   * @internal
   */
  queryElements(e) {
    return Array.from(this.adBreakXML.querySelectorAll(e));
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = this.adBreakXML.querySelector(":scope > AdSource");
    return e ? new io(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[Lt.POSITION[this.breakPosition]] && this.publisherSpecs[Lt.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[Lt.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = z.convertTimeStringToSeconds(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  /**
   * Returns one of the following values:
   * - 1 for pre-roll
   * - 2 for mid-roll
   * - 3 for post-roll
   * - 4 for standalone  (in accordance with OM for Web, overlays are considered to be standalone)
   * - 0 for none of the above/other
   * @returns {number} The break position number according to IAB VAST BREAKPOSITION macro values
   */
  /** @internal */
  getBreakPosition() {
    return this.type === he.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || z.convertTimeStringToSeconds(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  /**
   * @returns {Array} list of all found VMAP Extensions
   */
  /** @internal */
  getExtensions() {
    return this.queryElements(":scope > Extensions > Extension").map(
      (e) => ({
        extensionXML: e,
        type: e.getAttribute("type") || ""
      })
    );
  }
  /**
   * @returns {Object} list of tracking objects by event name
   */
  /** @internal */
  getTrackers() {
    const e = {};
    return this.queryElements(":scope > TrackingEvents > Tracking").forEach(
      (i) => {
        const r = i.getAttribute("event"), s = i.textContent.trim();
        s && (e[r] = e[r] || [], e[r].push({ url: s }));
      }
    ), e;
  }
  /** @internal */
  getSeparationClips() {
    return this.publisherSpecs[Lt.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = this.adBreakXML.querySelector("ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
Lt.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let ni = Lt;
class ro {
  constructor(e, i) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, i);
  }
  createAdSlotList(e, i) {
    let s = [...(e.documentElement || e).querySelectorAll(":scope > *")];
    this.adSlotList = s.map((A) => new ni(A, i));
    let l = {}, h = [];
    if (this.adSlotList.forEach((A, g) => {
      A.breakPosition === 2 && A.timeOffset !== null && (l[A.timeOffset] = (l[A.timeOffset] || 0) + 1, l[A.timeOffset] > 1 && (A.multiMidroll = !0, h.length === 0 && (this.adSlotList[g - 1].multiMidroll = !0, this.adSlotList[g - 1].adBreakXML.setAttribute(
        "type",
        this.adSlotList[g - 1].adSource.type
      ), this.adSlotList[g - 1].adBreakXML.setAttributeNS(
        null,
        "allowMultipleAds",
        this.adSlotList[g].adSource.allowMultipleAds.toString()
      ), h.push(this.adSlotList[g - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[g].multiMidroll = !0, A.adBreakXML.setAttribute("type", this.adSlotList[g].adSource.type), A.adBreakXML.setAttributeNS(
        null,
        "allowMultipleAds",
        this.adSlotList[g].adSource.allowMultipleAds.toString()
      ), h.push(A.adBreakXML.cloneNode(!0))));
    }), this.midrollHasSameTimeOffset) {
      let A = [];
      for (let S = 0; S < h.length; S++)
        if (h[S].getAttribute("type").includes("adtaguri")) {
          let L = document.createElementNS(null, "Ad");
          L.setAttribute("sequence", (S + 1).toString());
          let Q = document.createElementNS(null, "Wrapper");
          Q.setAttributeNS(
            null,
            "fallbackOnNoAd",
            h[S].getAttribute("allowMultipleAds")
          );
          let te = document.createElementNS(null, "VASTAdTagURI");
          te.textContent = h[S].querySelector("AdTagURI").textContent.trim(), Q.appendChild(te), L.appendChild(Q), A.push(L);
        } else
          h[S].querySelector("Ad").setAttribute("sequence", (S + 1).toString()), A.push(h[S].querySelector("Ad"));
      let g = null;
      for (let S = 0; S < this.adSlotList.length; S++) {
        if (!this.adSlotList[S].multiMidroll)
          continue;
        if (this.adSlotList[S].adBreakXML.hasAttribute("type") && this.adSlotList[S].adBreakXML.getAttribute("type").includes("adtaguri") && (g = document.createElementNS(null, "VASTAdData")), this.adSlotList[S].adBreakXML.querySelector("Ad") || g) {
          if (g) {
            this.adSlotList[S].adBreakXML.querySelector("AdTagURI").remove();
            let Q = this.adSlotList[S].adBreakXML.querySelector("AdSource");
            const te = document.createElementNS(null, "VAST");
            A.forEach((de) => {
              te.appendChild(de);
            }), g.appendChild(te), Q.appendChild(g);
          } else {
            this.adSlotList[S].adBreakXML.querySelector("Ad").remove();
            const Q = this.adSlotList[S].adBreakXML.querySelector("VAST");
            A.forEach((te) => {
              Q.appendChild(te);
            });
          }
          this.adSlotList[S].multiMidroll = !1, this.adSlotList[S] = new ni(this.adSlotList[S].adBreakXML, this.adSlotList[S].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((S) => {
        if (!S.multiMidroll)
          return S;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((i) => !i.hasError && i.adSource).shift();
  }
}
class yt {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, i) {
    const r = this.listeners[e] || (this.listeners[e] = []);
    return r.includes(i) || r.push(i), () => {
      this.removeEventListener(e, i);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const i = this.listeners[e];
    if (!i)
      return;
    const r = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let s = 0; s < i.length; s++)
      i[s].call(this, r);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, i) {
    const r = this.listeners[e];
    return r && r.indexOf(i) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, i) {
    const r = this.listeners[e];
    if (r) {
      const s = r.indexOf(i);
      s !== -1 && r.splice(s, 1);
    }
  }
}
const x = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let sr = null, or = null, Bt = 0, _n = null, ar = null;
const We = class We {
  constructor(e, i) {
    this.enrichment = i, this.reasonData = null, e && e.homad && (_n = e), this.enrichment.set("BLOCKED", Bt, "blocked");
  }
  get isActive() {
    return Bt === 1;
  }
  get vendorAPI() {
    return ar;
  }
  setVendorAPI(e) {
    !ar && e && (ar = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    or = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    sr = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, i) {
    if (c.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !_n.homad.enabled) {
      let l = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      i(l);
      return;
    }
    if (!this.vendorAPI) {
      c.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, i);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let l = new Error("AdReinsertionModel: Fallback not activated.");
      l = x.SESSION.AD_REINSERTION_DECLINED, i(l);
      return;
    }
    if (!or) {
      i("HOMAD corroboration callback not set.");
      return;
    }
    let r = this.reasonData.reason, s = this.reasonData;
    or(r, s).then(() => {
      Bt !== We.STATUS.IS_BLOCKED ? sr ? sr(r).then((l) => {
        c.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          We.STATUS.IS_BLOCKED,
          "blocked"
        ), Bt = We.STATUS.IS_BLOCKED, e();
      }).catch((l) => {
        c.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), i("AdReinsertion request declined by publisher.", l);
      }) : (c.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        We.STATUS.IS_BLOCKED,
        "blocked"
      ), Bt = We.STATUS.IS_BLOCKED, e()) : (c.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (l) => {
      this.disable(), i("AdReinsertion request declined by HOMAD.", l);
    });
  }
  disable() {
    Bt = 0, this.enrichment.set("BLOCKED", We.STATUS.IS_OPEN, "blocked");
  }
};
We.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, We.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, We.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, We.EventDispatcher = new yt();
let ce = We;
class xe {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: xe.screenHeight(),
      width: xe.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return xe.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !xe.isIF() || xe.isFIF();
  }
}
function no() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function Mi(p) {
  return encodeURIComponent(p).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function so() {
  const p = /* @__PURE__ */ new Date(), e = p.toISOString();
  let i = p.getTimezoneOffset() / 60, r = i < 0 ? "-" : "+" + ("0" + Math.abs(i)).slice(-2);
  return e.replace("Z", r);
}
function oo(p, e, i) {
  if (p.indexOf(e) === -1)
    return p;
  {
    const r = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let s = /\d+/.test(p) ? parseInt(p.match(/\|(\d+)]/)[1], 10) : 0;
    return p.replace(
      r,
      s === 0 ? Mi(i) : Mi(i).substring(0, s)
    );
  }
}
function Pi(p) {
  let e = !Number.isFinite(p) || p < 0 ? 0 : p;
  const i = /* @__PURE__ */ new Date(0);
  return i.setSeconds(e), i.toISOString().substring(11, 19) + ".000";
}
function Bn() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (p) => {
    let e = Math.random() * 16 | 0;
    return (p === "x" ? e : e & 3 | 8).toString(16);
  });
}
class St {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], xe.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], no), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", Pi), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", xe.userAgent(), "deviceua"), this.set("DOMAIN", xe.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", xe.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", Pi), this.set("OS", xe.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.5.6", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      xe.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", xe.screenHeight(), "screenheight"), this.set("SCREENWIDTH", xe.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", so), this.set("TRANSACTIONID", Bn(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((i) => i.idRegistry + " " + i.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  /** @internal */
  getPlayerDimension(e) {
    var r;
    return ((r = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : r[e]) || 0;
  }
  /** @internal */
  getResolution(e) {
    const i = parseInt((e == null ? void 0 : e.width) || "0", 10), r = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${i},${r}`;
  }
  /** @internal */
  getMacros(e = !1) {
    let i = {};
    return this.macroMap.forEach((r, s) => {
      const l = e ? `[${s}]` : s;
      i[l] = this.get(s, !0);
    }), i;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, i, r, s) {
    let l = this.macroMap.get(e) || {}, h = r || l.macroList;
    return l.value = i, h ? Array.isArray(h) ? l.macroList = h : l.macroList = [h] : l.macroList = [e.toLowerCase()], s && (l.transform = s), this.macroMap.set(e, l), this;
  }
  get(e, i = !1) {
    if (!e)
      return null;
    let r = this.macroMap.get(e + "");
    if (!r)
      return null;
    let s = r.value;
    return r.transform && (s = r.transform(s)), i ? Array.isArray(s) ? s.map((l) => Mi(String(l))).join(",") : Mi(String(s)) : s;
  }
  setFromObject(e) {
    e && Object.keys(e).forEach((i) => {
      let r = e[i];
      switch (typeof r) {
        case "string":
        case "object":
          r = r.length === 0 ? "-1" : r;
          break;
      }
      this.set(i.toUpperCase(), r, "");
    });
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    if (!e)
      return e + "";
    let i = e + "";
    return this.macroMap.forEach((r, s) => {
      let l = this.get(s, !0) + "";
      r.macroList.map((h) => {
        i = this.replaceMacroWithValue(i, h, l);
      });
    }), i;
  }
  replaceMacroWithValue(e, i, r) {
    let s = e.replace(this.getRegExp(i), r);
    return oo(s, "[" + i, r);
  }
  getRegExp(e) {
    let i = "[\\[](" + e + ")[\\]]";
    return new RegExp(i, "gi");
  }
}
class wi {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new wi().xdrRequest();
  }
  get(e, i, r) {
    if (this.xdrRequest()) {
      let s = new XMLHttpRequest();
      s.open("GET", e), s.timeout = i.timeout || 0, s.withCredentials = i.withCredentials !== !1, s.onload = () => {
        let l = new DOMParser().parseFromString(s.responseText, "text/xml");
        r(null, l);
      }, s.onerror = () => {
        r(new Error("Error loading the XML document"));
      }, s.send();
    } else
      r(new Error("XDomainRequest is not supported"));
  }
}
class ao {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, i, r) {
    let s = !1;
    const l = i.timeouts.adRequest * 1e3, h = setTimeout(() => {
      s = !0;
      let L = new Error("ImageURLHandler: Tracking request timeout.");
      L.code = x.WARNING.TRACKER_TIMEOUT.code, L.description = x.WARNING.TRACKER_TIMEOUT.message, L.type = "AdWarning", r(L);
    }, l);
    let A = new Image();
    A.src = "";
    const g = () => {
      clearTimeout(h), !s && r(null);
    }, S = (L) => {
      g();
    };
    return A.onerror = S, A.onload = g, A.src = e, A;
  }
}
function Tr(p) {
  if (typeof p != "string")
    return p;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(p, "text/xml");
  else if (ActiveXObject) {
    let i = new ActiveXObject("Microsoft.XMLDOM");
    i.loadXML(p), e = i;
  }
  return e;
}
const lr = " Response contains neither 'responseXML' nor 'responseText'", Re = class Re {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Re().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, i, r) {
    let s, l = r.timeouts.adRequest * 1e3, A = setTimeout(() => {
      s.onreadystatechange = s.onerror = () => {
        c.debug.info(Re.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let g = new Error(Re.NAME + ": Request timeout");
      g.code = x.WRAPPER.TIMEOUT.code;
      let S = r.timeouts ? r.timeouts.errorMessage : null;
      g.message = S || x.WRAPPER.TIMEOUT.message, r.adReinsertion.setReinsertionReason({
        reason: r.isWrapper ? ce.REASON.WRAPPER_CHAIN_TIMEOUT : ce.REASON.XHR_TIMEOUT,
        xhr: s,
        xhrError: g
      }), i(g, null);
    }, l);
    try {
      s = this.xhrRequest(), s.withCredentials = r.withCredentials !== !1, s.overrideMimeType && s.overrideMimeType("text/xml"), s.onreadystatechange = () => {
        if (s.readyState === 1) {
          s.send();
          return;
        }
        if (s.readyState === 4)
          if (clearTimeout(A), s.status === 200) {
            let g = s.responseXML;
            if (!g && s.responseText && (g = Tr(s.responseText)), !g) {
              c.debug.info(Re.NAME + lr);
              let S = new Error(Re.NAME + lr);
              S.code = r.isWrapper ? x.WRAPPER.NO_RESPONSE.code : x.XML.INVALID_XML.code, S.message = "XHR Response Error:" + lr, r.adReinsertion.setReinsertionReason({
                reason: ce.REASON.XHR_ERROR,
                xhr: s,
                xhrError: S
              }), i(S, null);
              return;
            }
            i(null, g);
          } else {
            s.onreadystatechange = s.onerror = () => {
              c.debug.info(Re.NAME + "Ignoring XHR state changes after status error", s.readyState, s.status, e);
            };
            let g = new Error(Re.NAME + s.statusText);
            g.code = r.isWrapper ? x.WRAPPER.TIMEOUT.code : x.XML.INVALID_XML.code, g.message = `XHR Status Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
              reason: ce.REASON.XHR_UNEXPECTED_STATUS,
              xhr: s,
              xhrError: g
            }), i(g, null);
          }
      }, s.open("GET", e), s.onerror = () => {
        clearTimeout(A), c.debug.info(Re.NAME + ": XHR Error.", s.readyState, s.status, e);
        let g = new Error(Re.NAME + s.statusText);
        g.code = x.WRAPPER.TIMEOUT.code, g.message = `XHR Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
          reason: ce.REASON.XHR_UNEXPECTED_STATUS,
          xhr: s,
          xhrError: g
        }), i(g, null);
      };
    } catch (g) {
      clearTimeout(A);
      let S = new Error(`${Re.NAME}: Request error.`);
      S.code = x.WRAPPER.TIMEOUT.code, S.message = `XHR Request Error: ${g}`, r.adReinsertion.setReinsertionReason({
        reason: ce.REASON.XHR_ERROR,
        xhr: null,
        xhrError: S
      }), i(S, null);
    }
  }
  get(e, i, r) {
    c.debug.info(`${Re.NAME}: XHR get with timeout ${r.timeouts.adRequest} sec: ${e}`), r.issuer && r.issuer === Re.ISSUER.TRACKING ? ao.getAsImage(e, r, i) : this.getAsXHR(e, i, r);
  }
};
Re.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, Re.NAME = "XHRURLHandler";
let ut = Re;
ut.DEFAULT_TIMEOUT = 4;
function xi(p, e) {
  if (p.indexOf("//") === 0) {
    let i = location.protocol;
    return (i === "about:" || i === "file:") && (i = "https:"), i + p;
  }
  return p.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + p : p;
}
const si = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class Rr {
  constructor() {
    this.issuer = ut.ISSUER.TAG;
  }
  get(e, i, r) {
    if (!i)
      return null;
    let s = r, l = e;
    s || (s = si, s.enrichment = new St()), s.issuer = this.issuer, s.enrichment = s.enrichment || new St(), l = s.enrichment.apply(l), l && l.indexOf("//") === 0 && (l = xi(l, ""));
    let h = s.urlhandler;
    if (s.response) {
      let A = s.response;
      i(null, Tr(A));
    } else return h && h.supported() ? new h().get(l, i, s) : ut.supported() ? new ut().get(l, i, s) : wi.supported() ? new wi().get(l, i, s) : i();
    return null;
  }
}
const ti = class ti extends Rr {
  constructor() {
    super(), this.issuer = ut.ISSUER.TRACKING;
  }
  track(e, i, r) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, i, r) : c.debug.info(ti.NAME + "track - without trackers:", e);
  }
  getMultiple(e, i, r) {
    e.forEach((s) => {
      s.requested = !0, s.url && super.get(s.url, (i || this.onResponse).bind(this, s), r);
    });
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, i) {
    i && c.debug.warn(ti.NAME + "onResponse failed:", i.name, i, e);
  }
};
ti.NAME = "TrackingUrlHandler::";
let oi = ti;
const f = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup"
}, qt = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, bt = class bt {
  constructor(e, i, r) {
    this.player = i, this.config = r, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, bt.ERROR_CODE_MAP[x.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, bt.ERROR_CODE_MAP[x.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, i = {}) {
    e.requested = !0, c.debug.info(
      Ie.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = i;
    const r = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let s = {};
    return s.adBreakPosition = e.breakPosition, s.type = e.type, s[r] = e.adSource.source, s = Object.assign(s, e.separationClips), this.currentAdBreak.enrichment = new St(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new ce(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((l, h) => {
      this.adSlotAPI.initAdSlot(s, i).then(() => {
        c.debug.info(
          Ie.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), l(e);
      }).catch((A) => {
        c.debug.warn(Ie.NAME + "initAdSlot - Could not init ad slot", A), h(A);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    c.debug.info(
      Ie.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_START, () => {
        this.trackEvent(qt.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent(qt.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(f.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          bt.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent(qt.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(f.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent(qt.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), c.debug.info(
      Ie.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      Ie.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    ), this.eventHandlers.forEach((e) => {
      e();
    }), this.eventHandlers = [];
  }
  /** @internal */
  trackEvent(e) {
    let i = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(i);
  }
  /** @internal */
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(
        Ie.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const i = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new oi().track(e, (r, s) => {
      s && c.debug.warn(Ie.NAME + "callTrackers - failed:", s, r);
    }, i);
  }
};
bt.ERROR_CODE_MAP = {}, bt.NAME = "AdBreakCtrl::";
let hr = bt;
const $e = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, dr = "Content - Scan for AdBreaks to play", pe = class pe extends yt {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, i) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = i, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((r) => {
      if (r.timeOffset === "end")
        return r;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(f.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(f.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(f.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, c.debug.info(
      pe.NAME + "before" + dr + "."
    ), super.dispatchEvent(f.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      c.debug.info(
        pe.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(f.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), c.debug.info(
      pe.NAME + "start" + dr + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, c.debug.info(
      pe.NAME + "after" + dr + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset && (this.isSeeking = !1, this.postroll = null, this.adPlaylist.forEach((s) => {
      s.timeOffset !== "end" && (s.requested = !0);
    }), this.requestAdBreak(e)), this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let i = this.find(e), r = i.shift();
    return i.forEach((s) => {
      s.requested = !0;
    }), r && this.playableAdBreaks.length && (r.requested = !0), new Promise((s, l) => {
      r && !r.requested ? (this.adBreakController = new hr(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(r, this.player.getEnvironmentVars(r.type)).then((h) => {
        c.debug.info(
          pe.NAME + "requestAdBreak - Initialized AdBreak",
          h.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(h), s();
      }).catch((h) => {
        c.debug.warn(
          pe.NAME + "requestAdBreak - Failed to initialize ",
          r.timeOffset,
          h
        ), l(h);
      })) : l(
        pe.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      pe.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), c.debug.info(pe.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const i = e;
    return this.adPlaylist.filter((r) => {
      if (r.requested)
        return !1;
      let s = i;
      return r.prefetchOffset > 0 && (s += r.prefetchOffset), this.isExecutableAdBreak(r, s);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, i, r = pe.PROCESS.REQUEST) {
    function s(h, A) {
      var S;
      const g = h - A;
      return (S = e.publisherSpecs) != null && S.strictOffsets ? g >= 0 && g <= pe.STRICT_OFFSET_THRESHOLD : g >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const h = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return s(i, h);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && r === pe.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && r === pe.PROCESS.REQUEST)
      return i - this.contentDuration >= 0;
    const l = z.convertTimeStringToSeconds(e.timeOffset);
    return l !== null && s(i, l);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const r = this.player.getContentCurrentTime() + e.repeatAfter;
    let s = e.adBreakXML.cloneNode(!0);
    s.setAttribute("timeOffset", Pi(r)), this.adPlaylist.push(new ni(s, e.publisherSpecs)), c.debug.info(
      pe.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), i = 0, r = 0;
    this.addPlayerEventListener($e.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const s = this.player.getContentCurrentTime(), l = s - i, h = (Date.now() - e) / 1e3;
      l > h + 0.075 || l > 2 ? (this.isSeeking = !0, r = 0) : r >= pe.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), r = Math.min(
        r + 1,
        pe.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), i = s, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener($e.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), c.debug.info(
      pe.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      pe.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    ), this.eventHandlers.forEach((e) => {
      e();
    }), this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventHandlers.push(r), r;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
};
pe.NAME = "AdPlaylistCtrl::", pe.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, pe.STRICT_OFFSET_THRESHOLD = 2, pe.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let Ie = pe;
const lo = "HomadXHRUrlHandler", Dn = ": Response contains neither 'responseXML' nor 'responseText'", Ht = class Ht {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Ht().xhrRequest();
  }
  /**
   * @internal
   * @param url
   * @param options
   * @param callback - Method that expects two parameters `xhrError` and `responseXML` (in that order!)
   *
   */
  getAsXHR(e, i, r) {
    function s(g) {
      i(g, null);
    }
    function l(g) {
      if (r.issuer && r.issuer === ut.ISSUER.TRACKING) {
        i(null, null);
        return;
      }
      let S = g.responseXML;
      if (!S && g.responseText && (S = Tr(g.responseText)), !S) {
        let L = new Error(lo + Dn);
        L.code = x.XML.INVALID_XML.code, L.description = "HOMAD Response Error" + Dn, i(L, null);
        return;
      }
      i(null, S);
    }
    if (!r.adReinsertion) {
      let g = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      g.code = x.WRAPPER.TIMEOUT.code, g.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", s(g);
      return;
    }
    const h = r.adReinsertion.vendorAPI.stuffAdTag(e);
    let A = r.adReinsertion.vendorAPI.getUrlRequest(h);
    A.data.homad_macros = JSON.stringify(r.enrichment.getIABMacroList()), c.debug.info(
      Ht.NAME + "getAsXHR - Provide VAST Macro List" + A.data.homad_macros
    ), r.adReinsertion.vendorAPI.loadFile(A, (g) => {
      l(g);
    }, (g) => {
      let S, L = "HOMADUtils XHR";
      g.timedOut ? (S = new Error("HomadUtilsURLHandler: Request timeout."), S.code = x.WRAPPER.TIMEOUT.code, S.description = `${L} Timeout Error ${r.timeouts.errorMessage || x.WRAPPER.TIMEOUT.message}`) : (S = new Error("HomadUtilsURLHandler: " + g.statusText), S.code = x.XML.INVALID_XML.code, S.description = `${L} Status Error (${g.status}): ${g.statusText}`), s(S);
    }, !1, !1, !1, r.timeouts.adRequest * 1e3);
  }
  get(e, i, r = {}) {
    r.timeouts || (r.timeouts = si.timeouts), c.debug.info(`${Ht.NAME}: Get with timeout ${r.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, i, r);
  }
};
Ht.NAME = "HomadUrlHandler::";
let Vi = Ht;
function qn(p) {
  return window.location.protocol === "https:" && !p.startsWith("http://") || window.location.protocol !== "https:";
}
function Xe(p, e) {
  let i = document.createElement("ParserError");
  i.setAttribute("code", e.code.toString()), i.setAttribute("message", e.message), p.appendChild(i);
}
const ii = class ii {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, i) {
    this.callbackLoadingDone = i, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, i) {
    if (c.debug.info(ii.NAME + "requestURL", e), this.callbackLoadingDone = i, this.isInsecureURL(e)) {
      let r = document.createDocumentFragment();
      return Xe(r, x.SESSION.MIXED_CONTENT), this.returnVMAP(r);
    }
    return this.loadURL(e).then((r) => {
      this.returnVMAP(r);
    });
  }
  returnVMAP(e) {
    let i = e, r = document.createDocumentFragment();
    e.querySelectorAll("VMAP").length > 0 && e.querySelectorAll("AdBreak").length === 0 && (Xe(r, x.VMAP.NO_ADBREAKS), i = r), e.querySelectorAll("VMAP").length === 0 && e.querySelectorAll("ParserError").length === 0 && (Xe(r, x.VMAP.DOCUMENT_ERROR), i = r), this.callbackLoadingDone(i);
  }
  /** @internal */
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((i) => {
      new Rr().get(e, (r, s) => {
        if (!r && s && s.querySelector("parsererror")) {
          let l = document.createDocumentFragment();
          Xe(l, x.VMAP.EXTRACTION_ERROR), i(l);
        }
        if (r && !s) {
          let l = document.createDocumentFragment();
          c.debug.warn(ii.NAME + "loadURL - XHR Request Error", r), Xe(l, r), i(l);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  /** @internal */
  isInsecureURL(e) {
    return this.blockInsecureURL && !qn(e);
  }
};
ii.NAME = "VMAPReqService::";
let cr = ii;
function Hn(p) {
  if (!p || typeof p != "object")
    return !1;
  try {
    return p.self === p;
  } catch (e) {
    return !0;
  }
}
function Xt(p, ...e) {
  for (const i of e)
    if (i)
      for (const r in i)
        Object.prototype.hasOwnProperty.call(i, r) && i[r] !== null && (Hn(i[r]) ? p[r] = i[r] : typeof p[r] == "object" && typeof i[r] == "object" ? p[r] = Xt(p[r], i[r]) : p[r] = i[r]);
  return p;
}
function Wn() {
  return this.error || null;
}
function rt(p) {
  this.error = {
    code: p.code,
    message: p.message,
    timestamp: Date.now()
  };
}
let Ln = null;
const _r = class _r extends yt {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, i) {
    super(), this.player = e, this.config = i.config, c.debug.info(Ie.NAME + "Create AdPlaylistAPI with", i.config), this.environmentVars = i.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = i, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, i = {}) {
    this.environmentVars = Object.assign(this.environmentVars, i), c.debug.info(Ie.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = Xt(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let r = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const s = this.adSlotAPI.setupEnrichmentAndTCF();
    Ln = new ce(this.config.adReinsertion, s);
    const l = {
      adReinsertion: Ln,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: s,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: Xt({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((h, A) => {
      r = this.addEventListener(f.ON_AD_PLAYLIST_LOAD_ERROR, () => A(this.errorAPI)), this.addEventListener(f.ON_AD_PLAYLIST_LOADED, () => (r(), this.adPlaylistController = new Ie(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), h("ok")));
      let g = new cr(
        l
      );
      e.tag ? g.requestURL(e.tag, this.onXMLLoadDone.bind(this, l)) : g.requestXML(l.response, this.onXMLLoadDone.bind(this, l));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  /**
   * @internal
   */
  onXMLLoadDone(e, i) {
    this.rawVMAPXML = i, this.adPlaylist = new ro(i, this.vmapSetup);
    let r = this.adPlaylist.getAdPlaylist();
    c.debug.info(Ie.NAME + "onXMLLoadDone and vmap parsed.", i), c.debug.table(r);
    const s = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const l = i.querySelector("ParserError"), h = l ? {
          code: parseInt(l.getAttribute("code"), 10),
          message: l.getAttribute("message")
        } : this.error = x.VMAP.NO_ADBREAKS;
        rt.call(this, h), super.dispatchEvent(f.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(f.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      c.debug.info(
        Ie.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), c.debug.info(
            Ie.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = Vi, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            s();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (l) => {
          c.debug.info(Ie.NAME + "enable - AdReinsertion remains disabled.", l), rt.call(this, l), s();
        }
      );
      return;
    }
    s();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    return super.dispatchEvent(f.ON_AD_PLAYLIST_START), Object.keys(f).forEach((e) => {
      this.adPlaylistController.addEventListener(f[e], (i) => {
        super.dispatchEvent(i.type);
      });
    }), new Promise((e, i) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (r) => {
          i(r);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return Wn.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
_r.NAME = "AdPlaylAPI::";
let pr = _r;
var fe = /* @__PURE__ */ ((p) => (p.CLOSER = "closer", p.DIVIDER = "divider", p.OPENER = "opener", p.COMMERCIAL = "commercial", p.SPONSORED = "sponsored", p))(fe || {});
class uo {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  /**
   * Does collect and summarize the duration of all commercial ads.
   * The result can change at runtime after receiving real duration values for a specific ad
   * @returns {void}
   */
  /** @internal */
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let i = this.adSlotManifest[e];
      !i.isLinear || i.variant !== fe.COMMERCIAL || this.totalCommercialsDurationArray.push(i.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, i) => e + i) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, i) => e + i)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, i) => e + i);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const le = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, it = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, st = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, ze = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, ri = class ri extends c {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.eventsThatRequireResponse = [
      le.CLICK_THRU,
      le.GET_MEDIA_STATE,
      le.READY,
      le.REPORT_TRACKING,
      le.REQUEST_CHANGE_AD_DURATION,
      le.REQUEST_FULL_SCREEN,
      le.REQUEST_PAUSE,
      le.REQUEST_PLAY,
      le.REQUEST_RESIZE,
      le.REQUEST_SKIP,
      le.REQUEST_STOP,
      le.REQUEST_VIDEO_LOCATION,
      le.REQUEST_VOLUME,
      st.AD_SKIPPED,
      st.AD_STOPPED,
      st.FATAL_ERROR,
      st.INIT,
      st.START_CREATIVE,
      ze.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, i) {
    const r = this.nextMessageId++, s = e === ze.CREATE_SESSION ? e : "SIMID:" + e, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: s,
      timestamp: Date.now(),
      args: i
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((h, A) => {
      this.addResolveRejectListener(r, h, A), this.target.postMessage(JSON.stringify(l), "*");
    }) : new Promise((h, A) => {
      this.target.postMessage(JSON.stringify(l), "*"), h();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, i) {
    this.listeners[e] ? this.listeners[e].push(i) : this.listeners[e] = [i];
  }
  /**
   * Sets up a listener for resolve/reject messages.
   * @internal
   */
  addResolveRejectListener(e, i, r) {
    const s = (l) => {
      const h = l.type, A = l.args.value;
      h === "resolve" && i(A), h === "reject" && r(A);
    };
    this.resolutionListeners[e] = s.bind(this);
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let i;
    try {
      i = JSON.parse(e.data);
    } catch (g) {
      return;
    }
    const r = i.sessionId, s = i.type, l = this.sessionId === "" && s === ze.CREATE_SESSION, h = this.sessionId === r;
    if (!(!(l || h) || s === null)) {
      if (Object.values(ze).includes(s))
        this.handleProtocolMessage(i);
      else if (s.startsWith("SIMID:")) {
        const g = s.substring(6), S = this.listeners[g];
        S && S.forEach((L) => {
          L(i);
        });
      }
    }
  }
  /**
   * Handles incoming messages specifically for the protocol
   * @param {!Object} data Data passed back from the message
   * @internal
   */
  handleProtocolMessage(e) {
    const i = e.type;
    switch (i) {
      case ze.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {});
        const r = this.listeners[i];
        r && r.forEach((A) => {
          A(e);
        });
        break;
      case ze.RESOLVE:
      // intentional fallthrough
      case ze.REJECT:
        const l = e.args.messageId, h = this.resolutionListeners[l];
        h && (h(e), delete this.resolutionListeners[l]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: ze.RESOLVE,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: ze.REJECT,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      c.debug.info(ri.NAME + "createSession resolve");
    }, i = () => {
      c.debug.info(ri.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(ze.CREATE_SESSION, {}).then(
      e,
      i
    );
  }
  /**
   * Sets the session ID, this should only be used on session creation.
   * @internal
   */
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let i = "", r;
    for (r = 0; r < 16; r++)
      i += (r === 4 || r === 6 || r === 8 || r === 10 ? "-" : "") + e[r].toString(16);
    this.sessionId = i;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
ri.NAME = "SIMIDPtl::";
let fr = ri;
function vt(p, e) {
  let i = document.createElement(p);
  return Object.keys(e || {}).forEach((r) => {
    i.setAttribute(r, e[r]);
  }), i;
}
const Li = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, bn = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Dt = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, ei = 0, ur = -2, ho = !0, we = class we {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new fr(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = ei, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((i) => {
      this.resolveSessionCreatedPromise = i;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = ei, this.nonLinearDimensions = null, this.initializationPromise = new Promise((i, r) => {
      this.resolveInitializationPromise = i, this.rejectInitializationPromise = r;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      c.debug.info(
        we.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = vt("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  /**
   * Sets up an iframe for holding the simid element.
   *
   * @return {!Element} The iframe where the simid element lives.
   * @internal
   */
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    return c.debug.info(we.NAME + "createSimidIframe with", this.creativeAsset), e.src = this.creativeAsset.fileURL, e.style.display = "none", this.container.appendChild(e), this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  /**
   * Listens to all relevant messages from the SIMID add.
   * @internal
   */
  addListeners() {
    this.simidProtocol.addListener(ze.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(le.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(le.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(le.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(le.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(le.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(le.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(le.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      le.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(le.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(le.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(le.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(le.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(le.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  /**
   * Resolves the session created promise.
   * @internal
   */
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  /**
   * Destroys the existing simid iframe.
   * @internal
   */
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, i);
    this.videoTrackingEvents.clear();
  }
  /**
   * Returns the full dimensions of an element within the player div.
   * @internal
   * @return {!Object}
   */
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  /**
   * Checks whether the input dimensions are valid and fit in the player window.
   * @internal
   * @param {!Object} dimensions A dimension that contains x, y, width & height fields.
   * @return {boolean}
   */
  isValidDimensions(e) {
    const i = this.playerFacade.getPlayerSize().boundingRect, r = parseInt(e.y, 10) + parseInt(e.height, 10) <= i.height, s = parseInt(e.x, 10) + parseInt(e.width, 10) <= i.width;
    return r && s;
  }
  /**
   * Returns the specified dimensions of the non-linear creative.
   * @internal
   * @return {!Object}
   */
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  /**
   * Validates and displays the non-linear creative.
   * @internal
   */
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      c.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  /**
   * Changes the simid iframe dimensions to the given dimensions.
   * @internal
   * @param {!Object} resizeDimensions A dimension that contains an x,y,width & height fields.
   */
  setIFrameDimensions(e) {
    c.debug.info(we.NAME + "resize", e), this.IFrame.style.height = e.height, this.IFrame.style.width = e.width, this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(f.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, i) {
    this.simidProtocol.reject(e, i);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const i = {
        errorCode: Li.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), c.debug.info(i.message);
    } else {
      const i = this.getFullDimensions();
      this.setIFrameDimensions(i), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const i = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const r = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, r), c.debug.info(r.message);
    } else if (this.isValidDimensions(i))
      this.setIFrameDimensions(i), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const r = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.info(r.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let i = "onRequestResize - error:";
    if (this.isLinearAd) {
      const r = {
        errorCode: Li.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, r), c.debug.error(we.NAME + i, r.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const r = {
        errorCode: Li.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.error(we.NAME + i, r.message);
    }
  }
  /**
   * Initializes the SIMID creative with all data it needs.
   * @internal
   */
  sendInitMessage() {
    const e = this.getFullDimensions(), i = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), r = {
      videoDimensions: e,
      creativeDimensions: i,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, s = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (s.duration = this.currentAd.duration);
    const l = {
      environmentData: r,
      creativeData: s
    };
    this.simidProtocol.sendMessage(st.INIT, l).then((A) => {
      this.resolveInitializationPromise(A), c.debug.info(we.NAME + "session created");
    }).catch((A) => {
      this.rejectInitializationPromise(A);
    });
  }
  /**
   * Called once the creative responds positively to being initialized.
   * @internal
   */
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(f.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), c.debug.info(we.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(st.START_CREATIVE);
  }
  /**
   * Pauses content video and plays linear ad.
   * @internal
   */
  /**
   * Called if the creative responds with reject after the player
   * initializes the ad.
   * @param {!Object} data
   * @internal
   */
  onAdInitializedFailed(e) {
    this.setError(x.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(f.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), c.debug.error(we.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  /** @internal */
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  /** @internal */
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  /**
   * Disables or enables stop, skip, and fatal error buttons
   *  depending on if the ad is showing.
   * @internal
   * @param {boolean} controlState If buttons should be disabled or enabled
   */
  setCreativeControlsState(e) {
    document.querySelectorAll(".ad_request").forEach((r) => {
      r.disabled = e;
    });
  }
  /**
   * Tracks the events on the ad video element specified by the simid spec
   * @internal
   */
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        it.ERROR,
        {
          error: x.SIMID.GENERAL_ERROR.code,
          message: x.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = x.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(it.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(it.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(it.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(it.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(it.SEEKING);
    }), this.videoTrackingEvents.set($e.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        it.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        it.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Dt.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        it.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, i);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Dt.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(st.AD_STOPPED).then(() => {
      c.debug.info(we.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(st.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(f.ON_AD_SKIPPED), this.loadedSource = null;
  }
  /**
   * Removes the simid ad entirely and resumes video playback.
   * @internal
   */
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(ho), this.adSlotController.dispatchEvent(f.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    c.debug.info(we.NAME + "onReqFullScreen", e);
    let i;
    this.IFrame && (i = this.IFrame.mozRequestFullScreen || this.IFrame.msRequestFullscreen || this.IFrame.requestFullscreen || this.IFrame.webkitRequestFullscreen);
    let r = i == null ? void 0 : i();
    r ? r.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const i = {
          errorCode: bn.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, i);
      });
    } else {
      const i = {
        errorCode: Li.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, i);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Dt.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Dt.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const i = e.args.trackingUrls;
    c.debug.info(we.NAME + "onReportTracking -  Creative has asked the player to send a ping."), c.debug.table(i);
  }
  /**
   * Called when video playback is complete.
   * @internal
   */
  videoComplete() {
    if (this.simidProtocol.sendMessage(it.ENDED), this.requestedDuration === ei && this.stopAd(Dt.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== ei && this.requestedDuration !== ur) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Dt.CREATIVE_INITIATED);
      }, e);
    }
  }
  /**
   * Called when creative requests a change in duration of ad.
   * @internal
   */
  onReqChangeAdDuration(e) {
    const i = e.args.duration;
    if (i !== ur && i < 0) {
      const r = {
        errorCode: bn.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, r);
    } else
      this.requestedDuration = i, this.compareAdAndReqDurations(), this.resolve(e);
  }
  /**
   * Compares the duration of the ad with the requested change duration.
   * If request duration is the same as the ad duration, ad ends as normal.
   * If request duration is unlimited, ad stays on screen until user closes ad.
   * If request duration is shorter, the ad stops early.
   * @internal
   */
  compareAdAndReqDurations() {
    this.requestedDuration === ei || this.requestedDuration === ur || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (c.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Dt.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const i = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, i);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const i = {
      message: e
    };
    this.simidProtocol.sendMessage(st.LOG, i);
  }
};
we.NAME = "SIMIDPly::";
let mr = we;
function Mn(p) {
  return p.height >= 0 ? p.y + p.height : p.y;
}
function Pn(p) {
  return p.width >= 0 ? p.x : p.x + p.width;
}
function wn(p) {
  return p.width >= 0 ? p.x + p.width : p.x;
}
function xn(p) {
  return p.height >= 0 ? p.y : p.y + p.height;
}
function co(p, e) {
  let i = 0, r = {
    bottom: Math.min(Mn(p), Mn(e)),
    height: 0,
    left: Math.max(Pn(p), Pn(e)),
    right: Math.min(wn(p), wn(e)),
    top: Math.max(xn(p), xn(e)),
    width: 0
  };
  r.width = r.right - r.left, r.height = r.bottom - r.top;
  let s = p.width * p.height, l = r.width * r.height;
  return l > 0 && (i = l / s), i;
}
class po {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   * @param {Object} playerFacade to get rectangle over size function from player and viewport
   */
  constructor(e, i) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.playerFacade = i, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners(), Object.keys(f).forEach((e) => {
      let i = this.adSlotController.addEventListener(f[e], this.handleAdEvent.bind(this));
      this.removeEventHandlers.push(i);
    });
  }
  removeEventListeners() {
    this.removeEventHandlers.forEach((e) => {
      e();
    }), this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case f.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case f.ON_AD_PLAYING:
      case f.ON_AD_STARTED:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case f.ON_AD_PLAYBACK_FINISHED:
      case f.ON_AD_SKIPPED:
      case f.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(f.ON_AD_NOT_VIEWABLE)), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.playerFacade.getPlayerSize(), i = this.playerFacade.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || i.boundingRect.height === 0 && i.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let r = co(e.boundingRect, i.boundingRect) * 100;
    r > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (c.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(f.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function fo(p, e, i) {
  return new Promise((r) => {
    let s = vt("iframe", {
      id: p,
      style: e
    });
    s.onload = () => {
      let l = vt("script", {
        type: "text/javascript"
      });
      l.innerHTML = "var inDapIF = true;", s.contentDocument.body.appendChild(l);
      let h = vt("style", {});
      h.innerHTML = "html,body{margin:0;}", s.contentDocument.body.appendChild(h), r(s);
    }, i.insertBefore(s, i.firstChild);
  });
}
const X = class X extends yt {
  // ms
  constructor(e, i) {
    super(), this.callbacks = null, this.currentAd = i, this.config = i.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = c.logLevel === ot.NORMAL || c.logLevel === ot.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = i.isLinear ? i.properCreative.selectedMediaFile : i.properCreative.variations[0], this.slot = vt("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), fo(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((r) => {
      this.friendlyIFrame = r, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = vt("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = vt("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = vt("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      c.debug.warn(X.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = x.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest, "");
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), c.debug.info(
      X.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (c.debug.info(X.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", i = parseInt(e.split(".")[0], 10);
      return c.debug.info(
        X.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        i
      ), c.debug.info(
        X.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), i <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), c.debug.info(
      X.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), c.debug.info(
      X.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    c.debug.info(X.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = x.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest, "");
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    c.debug.info(X.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = x.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness, "");
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, c.debug.info(X.NAME + "cleanup"), this.dispatchEvent(f.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    c.debug.info(X.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(f.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    c.debug.info(X.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    c.debug.info(X.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    c.debug.info(X.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, i, r) {
    c.debug.info(X.NAME + "resizeAd", e, i, r), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, i, r);
  }
  onStartAd() {
    c.debug.info(X.NAME + "onStartAd"), this.dispatchEvent(f.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression(e, i, r) {
    c.debug.info(X.NAME + "onAdImpression", e, i, r), this.dispatchEvent(f.ON_AD_IMPRESSION);
  }
  onAdVideoStart(e, i, r) {
    c.debug.info(X.NAME + "onAdVideoStart", e, i, r), this.dispatchEvent(f.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), X.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (c.debug.warn(X.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, X.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile(e, i, r) {
    c.debug.info(X.NAME + "onAdVideoFirstQuartile", e, i, r), this.dispatchEvent(f.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint(e, i, r) {
    c.debug.info(X.NAME + "onAdVideoMidpoint", e, i, r), this.dispatchEvent(f.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile(e, i, r) {
    c.debug.info(X.NAME + "onAdVideoThirdQuartile", e, i, r), this.dispatchEvent(f.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete(e, i, r) {
    c.debug.info(X.NAME + "onAdVideoComplete", e, i, r), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.currentAd.playbackComplete = !0, this.dispatchEvent(f.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange(e, i, r) {
    c.debug.info(X.NAME + "onAdDurationChange", e, i, r), this.getAllProperties();
  }
  onStopAd(e, i, r) {
    c.debug.info(X.NAME + "::onStopAd()", e, i, r), this.dispatchEvent(f.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, i, r) {
    c.debug.info(X.NAME + "onAdError", e, i, r), this.currentAd.error = this.currentAd.error === null ? x.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd(e, i, r) {
    this.dispatchEvent(f.ON_AD_SKIPPED), c.debug.info(X.NAME + "onSkipAd", e, i, r), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(f.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && c.debug.info(
      X.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(f.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange(e, i, r) {
    c.debug.info(X.NAME + "onAdExpandedChange", e, i, r);
  }
  onAdSkippableStateChange(e, i, r) {
    c.debug.info(X.NAME + "onAdSkippableStateChange", e, i, r), this.dispatchEvent(f.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(f.ON_AD_PROGRESS);
  }
  onAdVolumeChange(e, i, r) {
    c.debug.info(X.NAME + "onAdVolumeChange", e, i, r);
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, i = null, r = !1) {
    c.debug.info(X.NAME + "onAdClickThru - creative handles click", !r), r === !0 && (c.debug.info(X.NAME + "onAdClickThru - open landing page", e, i), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = r), this.dispatchEvent(f.ON_AD_CLICKED);
  }
  onAdInteraction(e, i, r) {
    c.debug.info(X.NAME + "onAdInteraction", e, i, r);
  }
  onAdUserAcceptInvitation(e, i, r) {
    c.debug.info(X.NAME + "onAdUserAcceptInvitation", e, i, r);
  }
  onAdUserMinimize(e, i, r) {
    c.debug.info(X.NAME + "onAdUserMinimize", e, i, r);
  }
  onAdUserClose(e, i, r) {
    c.debug.info(X.NAME + "onAdUserClose", e, i, r);
  }
  onAdPaused(e, i, r) {
    c.debug.info(X.NAME + "onAdPaused", e, i, r);
  }
  onAdPlaying(e, i, r) {
    c.debug.info(X.NAME + "onAdPlaying", e, i, r), this.dispatchEvent(f.ON_AD_PLAYING);
  }
  onAdLog(e, i, r) {
    c.debug.info(X.NAME + "onAdLog", e, i, r);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let i in e)
      e.hasOwnProperty(i) && e[i].indexOf("getAd") === 0 && c.debug.info(
        X.NAME + "--vpaidAd." + e[i] + "()",
        this.vpaidAd[e[i]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, i, r) => {
      i === 0 ? e.delta = 0 : e.delta = r[i].time - r[i - 1].time;
    }), c.debug.table(this.debugTiming));
  }
  //Debug -- End
};
X.NAME = "VPAIDBridge::", X.TIMEUPDATE_INTERVAL = 250;
let Ar = X;
const ai = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  VPAID: "application/javascript",
  SIMID: "text/html",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, Ue = class Ue extends yt {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {PlayerFacade} player
   */
  constructor(e, i, r, s) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = Ue.VIEW_MODE.NORMAL, this.environmentVars = r, this.eventCallbacks = [], this.eventKeys = Object.keys(f), this.eventTypes = Object.values(f), this.nonLinearView = null, this.player = s, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, i);
  }
  prepare(e, i) {
    this.manifest = e.slice(0), this.buffet = (i || []).slice(0), this.adSlotTimes = new uo(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource.fileURL), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(ai)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [fe.COMMERCIAL, fe.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new po(this, this.player));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    if (this.eventCallbacks.forEach((i) => {
      i();
    }), this.eventCallbacks = [], Object.keys(f).forEach((i) => {
      const r = this.addEventListener(f[i], (s) => {
        this.trackEvent(s.type);
      });
      this.eventCallbacks.push(r);
    }), this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let i = null;
      const r = new Promise((l) => {
        i = setTimeout(l, 250, null);
      }), s = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[s].length) {
        let l = this.currentAd.isLinear ? this.currentAd.properCreative[s] : this.currentAd.properCreative[s][0].resources;
        const h = this.currentAd.config.adSourceSelector(
          l
        ).then((A) => A === null || Object.keys(A).length === 0 ? null : A);
        Promise.race([r, h]).then((A) => {
          A === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = A : this.currentAd.properCreative.selectedResource = A, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(i), this.cancelAd();
    } else {
      this.updateAdSettings();
      const i = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, i);
    }
    const e = this.addEventListener(f.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, c.debug.info(Ue.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === fe.COMMERCIAL) {
        let i = e.duration;
        this.currentAd.isLinear || (i += this.currentAd.duration), c.debug.info(
          Ue.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          i
        ), this.adSlotTimes.setTotalCommercialsDuration(i), this.setTotalCommercialsDuration(), c.debug.info(Ue.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(Ue.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const i = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let r = this.currentAd;
    new oi().track(e, (s, l) => {
      l && (c.debug.warn(Ue.NAME + "callTrackers failed:", l, s), r.error = l.code ? l : x.WARNING.TRACKER_LOAD_FAILED, r.error.message = `${r.error.message}: ${JSON.stringify(s)}`, this.dispatchEvent(f.ON_AD_WARNING));
    }, i);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === he.NON_LINEAR) {
      this.currentAd.error = x.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(f.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = x.VAST.UNSUPPORTED_MIMETYPE), c.debug.info(Ue.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(f.ON_AD_CLICKED);
    let i = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (i && i.indexOf("//") === 0 && (i = xi(i, "")), !e) {
      const r = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(i, r);
    }
    return i;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let i = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(i);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(f.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, i) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let r = this.currentAd.adVerifications.filter((h) => h.vendor === e)[0];
      if (!r || !r.tracking.verificationNotExecuted)
        return;
      let s = r.tracking.verificationNotExecuted, l = parseInt(i, 10);
      i && isFinite(l) && l >= 1 && l <= 3 && this.currentAd.enrichment.set("REASON", l), s && s.length > 0 && this.callTrackers(s);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === fe.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      c.debug.info(Ue.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(f.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(f.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(f.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, i) {
    if (!this.currentAd.icons[e])
      return null;
    let r = this.currentAd.icons[e].clickTracker;
    this.callTrackers(r);
    let s = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!i) {
      const l = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(s, l);
    }
    return s;
  }
  onResizeAd(e, i) {
    this.currentAd && (i !== this.currentViewMode && (this.currentViewMode = i, i === Ue.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(f.ON_ENTER_FULLSCREEN), this.dispatchEvent(f.ON_PLAYER_EXPAND)) : (this.dispatchEvent(f.ON_EXIT_FULLSCREEN), this.dispatchEvent(f.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, i) : this.dispatchEvent(f.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === fe.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(f.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", Pi(e)), this.currentAd.variant === fe.COMMERCIAL) {
        const i = this.adDuration - this.currentAd.duration;
        if (i && Number.isFinite(i)) {
          let r = i;
          this.currentAd.isLinear || (r = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(r);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [fe.COMMERCIAL, fe.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((s) => {
          let l = s.offset;
          l.indexOf("%") > -1 && (l = parseInt(l, 10) / 100 * this.adDuration), e >= parseInt(l, 10) && !s.requested && this.dispatchEvent(f.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let i = [], r = [];
        e >= this.adDuration && i.push(f.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && i.push(f.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && i.push(f.ON_AD_MID_POINT), e >= this.adDuration / 4 && i.push(f.ON_AD_FIRST_QUARTILE), e && i.push(f.ON_AD_PLAYBACK_START), r.push(i[0]), this.currentAd.config.trackSkippedQuartiles && (r = i);
        for (let s = r.length - 1; s >= 0; s--)
          this.requestedTrackingEvents.filter((h) => h === r[s]).shift() || (this.dispatchEvent(r[s]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(r[s]));
      }
    }
  }
  trackEvent(e) {
    const i = this.eventKeys[this.eventTypes.indexOf(e)], r = qt[i], s = this.player.getAdCurrentTime(), l = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[r]) {
      let h = this.currentAd.trackingEvents[r];
      e === f.ON_AD_PROGRESS && (h = h.filter((A) => {
        let g = A.offset;
        return g.indexOf("%") > -1 && (g = parseInt(g, 10) / 100 * l), s >= parseInt(g, 10) && !A.requested;
      })), this.callTrackers(h);
    }
  }
  loadAdSIMID() {
    this.simidPlayer = new mr(this), this.simidPlayer.initializeAd();
  }
  loadAdVPAID() {
    this.vpaidPlayer = new Ar(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      f.ON_AD_CLICKED,
      f.ON_AD_LOADED,
      f.ON_AD_STARTED,
      f.ON_AD_IMPRESSION,
      f.ON_AD_PLAYING,
      f.ON_AD_PLAYBACK_START,
      f.ON_AD_FIRST_QUARTILE,
      f.ON_AD_MID_POINT,
      f.ON_AD_THIRD_QUARTILE,
      f.ON_AD_PLAYBACK_FINISHED,
      f.ON_AD_STOPPED,
      f.ON_AD_SKIPPED,
      f.ON_AD_ERROR,
      f.ON_AD_PROGRESS,
      f.ON_AD_SIZE_CHANGED,
      f.ON_AD_SKIPPABLE_STATE_CHANGE,
      f.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.vpaidEventHandler(i));
      }
    ) : [
      f.ON_AD_LINEARITY_CHANGE,
      f.ON_AD_SKIPPED,
      f.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.nonLinearVpaidEventHandler(i));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case f.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (c.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case f.ON_AD_SKIPPED:
        case f.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let i;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case f.ON_AD_LOADED:
      //onStartAd
      case f.ON_AD_STARTED:
      //onStartAd
      case f.ON_AD_IMPRESSION:
      case f.ON_AD_PLAYING:
      //onAdPlaying()
      case f.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case f.ON_AD_FIRST_QUARTILE:
      case f.ON_AD_MID_POINT:
      case f.ON_AD_THIRD_QUARTILE:
      case f.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case f.ON_AD_CLICKED:
        i = !this.currentAd.handleClickThrough, this.onClickThrough(i);
        break;
      case f.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case f.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case f.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case f.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case f.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case f.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case f.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    c.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
Ue.NAME = "AdSloCtrl::", Ue.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let Er = Ue;
function ye() {
  return ye = Object.assign ? Object.assign.bind() : function(p) {
    for (var e = 1; e < arguments.length; e++) {
      var i = arguments[e];
      for (var r in i) ({}).hasOwnProperty.call(i, r) && (p[r] = i[r]);
    }
    return p;
  }, ye.apply(null, arguments);
}
function J(p) {
  "@babel/helpers - typeof";
  return J = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(e) {
    return typeof e;
  } : function(e) {
    return e && typeof Symbol == "function" && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;
  }, J(p);
}
var Et = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : {};
function mo(p) {
  return p && p.__esModule && Object.prototype.hasOwnProperty.call(p, "default") ? p.default : p;
}
var Xn = {};
(function(p) {
  (function(e, i, r) {
    if (J(r) === "object" && typeof r.nodeName != "string")
      i(e, r);
    else {
      var s = function(L) {
        for (var Q in L)
          L.hasOwnProperty(Q) && (L[Q] = s(L[Q]));
        return Object.freeze(L);
      }, r = {}, l = ["1.5.6-iab144"], h = "default";
      h && l.push(h), i(e, r);
      for (var A in r)
        r.hasOwnProperty(A) && (Object.getOwnPropertyDescriptor(e, A) == null && Object.defineProperty(e, A, {
          value: {}
        }), l.forEach(function(S) {
          if (Object.getOwnPropertyDescriptor(e[A], S) == null) {
            var L = s(r[A]);
            Object.defineProperty(e[A], S, {
              get: function() {
                return L;
              },
              enumerable: !0
            });
          }
        }));
    }
  })(Et, function(e, i) {
    var r = r || {};
    r.scope = {}, r.createTemplateTagFirstArg = function(a) {
      return a.raw = a;
    }, r.createTemplateTagFirstArgWithRaw = function(a, u) {
      return a.raw = u, a;
    }, r.arrayIteratorImpl = function(a) {
      var u = 0;
      return function() {
        return u < a.length ? {
          done: !1,
          value: a[u++]
        } : {
          done: !0
        };
      };
    }, r.arrayIterator = function(a) {
      return {
        next: r.arrayIteratorImpl(a)
      };
    }, r.makeIterator = function(a) {
      var u = typeof Symbol != "undefined" && Symbol.iterator && a[Symbol.iterator];
      if (u)
        return u.call(a);
      if (typeof a.length == "number")
        return r.arrayIterator(a);
      throw Error(String(a) + " is not an iterable or ArrayLike");
    }, r.arrayFromIterator = function(a) {
      for (var u, E = []; !(u = a.next()).done; )
        E.push(u.value);
      return E;
    }, r.arrayFromIterable = function(a) {
      return a instanceof Array ? a : r.arrayFromIterator(r.makeIterator(a));
    }, r.ASSUME_ES5 = !1, r.ASSUME_NO_NATIVE_MAP = !1, r.ASSUME_NO_NATIVE_SET = !1, r.SIMPLE_FROUND_POLYFILL = !1, r.ISOLATE_POLYFILLS = !1, r.FORCE_POLYFILL_PROMISE = !1, r.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION = !1, r.objectCreate = r.ASSUME_ES5 || typeof Object.create == "function" ? Object.create : function(a) {
      var u = function() {
      };
      return u.prototype = a, new u();
    }, r.defineProperty = r.ASSUME_ES5 || typeof Object.defineProperties == "function" ? Object.defineProperty : function(a, u, E) {
      return a == Array.prototype || a == Object.prototype || (a[u] = E.value), a;
    }, r.getGlobal = function(a) {
      a = [(typeof globalThis == "undefined" ? "undefined" : J(globalThis)) == "object" && globalThis, a, (typeof window == "undefined" ? "undefined" : J(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : J(self)) == "object" && self, J(Et) == "object" && Et];
      for (var u = 0; u < a.length; ++u) {
        var E = a[u];
        if (E && E.Math == Math)
          return E;
      }
      throw Error("Cannot find global object");
    }, r.global = r.getGlobal(this), r.IS_SYMBOL_NATIVE = typeof Symbol == "function" && J(Symbol("x")) === "symbol", r.TRUST_ES6_POLYFILLS = !r.ISOLATE_POLYFILLS || r.IS_SYMBOL_NATIVE, r.polyfills = {}, r.propertyToPolyfillSymbol = {}, r.POLYFILL_PREFIX = "$jscp$", r.polyfill = function(a, u, E, y) {
      u && (r.ISOLATE_POLYFILLS ? r.polyfillIsolated(a, u, E, y) : r.polyfillUnisolated(a, u, E, y));
    }, r.polyfillUnisolated = function(a, u, E, y) {
      for (E = r.global, a = a.split("."), y = 0; y < a.length - 1; y++) {
        var C = a[y];
        if (!(C in E))
          return;
        E = E[C];
      }
      a = a[a.length - 1], y = E[a], u = u(y), u != y && u != null && r.defineProperty(E, a, {
        configurable: !0,
        writable: !0,
        value: u
      });
    }, r.polyfillIsolated = function(a, u, E, y) {
      var C = a.split(".");
      a = C.length === 1, y = C[0], y = !a && y in r.polyfills ? r.polyfills : r.global;
      for (var re = 0; re < C.length - 1; re++) {
        var ne = C[re];
        if (!(ne in y))
          return;
        y = y[ne];
      }
      C = C[C.length - 1], E = r.IS_SYMBOL_NATIVE && E === "es6" ? y[C] : null, u = u(E), u != null && (a ? r.defineProperty(r.polyfills, C, {
        configurable: !0,
        writable: !0,
        value: u
      }) : u !== E && (r.propertyToPolyfillSymbol[C] === void 0 && (E = 1e9 * Math.random() >>> 0, r.propertyToPolyfillSymbol[C] = r.IS_SYMBOL_NATIVE ? r.global.Symbol(C) : r.POLYFILL_PREFIX + E + "$" + C), r.defineProperty(y, r.propertyToPolyfillSymbol[C], {
        configurable: !0,
        writable: !0,
        value: u
      })));
    }, r.getConstructImplementation = function() {
      function a() {
        function E() {
        }
        return Reflect.construct(E, [], function() {
        }), new E() instanceof E;
      }
      if (r.TRUST_ES6_POLYFILLS && typeof Reflect != "undefined" && Reflect.construct) {
        if (a())
          return Reflect.construct;
        var u = Reflect.construct;
        return function(E, y, C) {
          return E = u(E, y), C && Reflect.setPrototypeOf(E, C.prototype), E;
        };
      }
      return function(E, y, C) {
        return C === void 0 && (C = E), C = r.objectCreate(C.prototype || Object.prototype), Function.prototype.apply.call(E, C, y) || C;
      };
    }, r.construct = {
      valueOf: r.getConstructImplementation
    }.valueOf(), r.underscoreProtoCanBeSet = function() {
      var a = {
        a: !0
      }, u = {};
      try {
        return u.__proto__ = a, u.a;
      } catch (E) {
      }
      return !1;
    }, r.setPrototypeOf = r.TRUST_ES6_POLYFILLS && typeof Object.setPrototypeOf == "function" ? Object.setPrototypeOf : r.underscoreProtoCanBeSet() ? function(a, u) {
      if (a.__proto__ = u, a.__proto__ !== u)
        throw new TypeError(a + " is not extensible");
      return a;
    } : null, r.inherits = function(a, u) {
      if (a.prototype = r.objectCreate(u.prototype), a.prototype.constructor = a, r.setPrototypeOf) {
        var E = r.setPrototypeOf;
        E(a, u);
      } else
        for (E in u)
          if (E != "prototype")
            if (Object.defineProperties) {
              var y = Object.getOwnPropertyDescriptor(u, E);
              y && Object.defineProperty(a, E, y);
            } else
              a[E] = u[E];
      a.superClass_ = u.prototype;
    }, r.getRestArguments = function() {
      for (var a = Number(this), u = [], E = a; E < arguments.length; E++)
        u[E - a] = arguments[E];
      return u;
    }, r.polyfill("Reflect", function(a) {
      return a || {};
    }, "es6", "es3"), r.polyfill("Reflect.construct", function(a) {
      return r.construct;
    }, "es6", "es3"), r.polyfill("Reflect.setPrototypeOf", function(a) {
      if (a)
        return a;
      if (r.setPrototypeOf) {
        var u = r.setPrototypeOf;
        return function(E, y) {
          try {
            return u(E, y), !0;
          } catch (C) {
            return !1;
          }
        };
      }
      return null;
    }, "es6", "es5"), r.initSymbol = function() {
    }, r.polyfill("Symbol", function(a) {
      if (a)
        return a;
      var u = function(ne, Je) {
        this.$jscomp$symbol$id_ = ne, r.defineProperty(this, "description", {
          configurable: !0,
          writable: !0,
          value: Je
        });
      };
      u.prototype.toString = function() {
        return this.$jscomp$symbol$id_;
      };
      var E = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", y = 0, C = function(ne) {
        if (this instanceof C)
          throw new TypeError("Symbol is not a constructor");
        return new u(E + (ne || "") + "_" + y++, ne);
      };
      return C;
    }, "es6", "es3"), r.polyfill("Symbol.iterator", function(a) {
      if (a)
        return a;
      a = Symbol("Symbol.iterator");
      for (var u = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), E = 0; E < u.length; E++) {
        var y = r.global[u[E]];
        typeof y == "function" && typeof y.prototype[a] != "function" && r.defineProperty(y.prototype, a, {
          configurable: !0,
          writable: !0,
          value: function() {
            return r.iteratorPrototype(r.arrayIteratorImpl(this));
          }
        });
      }
      return a;
    }, "es6", "es3"), r.iteratorPrototype = function(a) {
      return a = {
        next: a
      }, a[Symbol.iterator] = function() {
        return this;
      }, a;
    }, r.iteratorFromArray = function(a, u) {
      a instanceof String && (a += "");
      var E = 0, y = !1, C = {
        next: function() {
          if (!y && E < a.length) {
            var ne = E++;
            return {
              value: u(ne, a[ne]),
              done: !1
            };
          }
          return y = !0, {
            done: !0,
            value: void 0
          };
        }
      };
      return C[Symbol.iterator] = function() {
        return C;
      }, C;
    }, r.polyfill("Array.prototype.keys", function(a) {
      return a || function() {
        return r.iteratorFromArray(this, function(u) {
          return u;
        });
      };
    }, "es6", "es3"), r.owns = function(a, u) {
      return Object.prototype.hasOwnProperty.call(a, u);
    }, r.polyfill("Object.values", function(a) {
      return a || function(u) {
        var E = [], y;
        for (y in u)
          r.owns(u, y) && E.push(u[y]);
        return E;
      };
    }, "es8", "es3"), r.checkEs6ConformanceViaProxy = function() {
      try {
        var a = {}, u = Object.create(new r.global.Proxy(a, {
          get: function(y, C, re) {
            return y == a && C == "q" && re == u;
          }
        }));
        return u.q === !0;
      } catch (E) {
        return !1;
      }
    }, r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS = !1, r.ES6_CONFORMANCE = r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS && r.checkEs6ConformanceViaProxy(), r.polyfill("WeakMap", function(a) {
      function u() {
        if (!a || !Object.seal)
          return !1;
        try {
          var M = Object.seal({}), U = Object.seal({}), j = new a([[M, 2], [U, 3]]);
          return j.get(M) != 2 || j.get(U) != 3 ? !1 : (j.delete(M), j.set(U, 4), !j.has(M) && j.get(U) == 4);
        } catch (Ze) {
          return !1;
        }
      }
      function E() {
      }
      function y(M) {
        var U = J(M);
        return U === "object" && M !== null || U === "function";
      }
      function C(M) {
        if (!r.owns(M, ne)) {
          var U = new E();
          r.defineProperty(M, ne, {
            value: U
          });
        }
      }
      function re(M) {
        if (!r.ISOLATE_POLYFILLS) {
          var U = Object[M];
          U && (Object[M] = function(j) {
            return j instanceof E ? j : (Object.isExtensible(j) && C(j), U(j));
          });
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var ne = "$jscomp_hidden_" + Math.random();
      re("freeze"), re("preventExtensions"), re("seal");
      var Je = 0, H = function(U) {
        if (this.id_ = (Je += Math.random() + 1).toString(), U) {
          U = r.makeIterator(U);
          for (var j; !(j = U.next()).done; )
            j = j.value, this.set(j[0], j[1]);
        }
      };
      return H.prototype.set = function(M, U) {
        if (!y(M))
          throw Error("Invalid WeakMap key");
        if (C(M), !r.owns(M, ne))
          throw Error("WeakMap key fail: " + M);
        return M[ne][this.id_] = U, this;
      }, H.prototype.get = function(M) {
        return y(M) && r.owns(M, ne) ? M[ne][this.id_] : void 0;
      }, H.prototype.has = function(M) {
        return y(M) && r.owns(M, ne) && r.owns(M[ne], this.id_);
      }, H.prototype.delete = function(M) {
        return y(M) && r.owns(M, ne) && r.owns(M[ne], this.id_) ? delete M[ne][this.id_] : !1;
      }, H;
    }, "es6", "es3"), r.MapEntry = function() {
    }, r.polyfill("Map", function(a) {
      function u() {
        if (r.ASSUME_NO_NATIVE_MAP || !a || typeof a != "function" || !a.prototype.entries || typeof Object.seal != "function")
          return !1;
        try {
          var H = Object.seal({
            x: 4
          }), M = new a(r.makeIterator([[H, "s"]]));
          if (M.get(H) != "s" || M.size != 1 || M.get({
            x: 4
          }) || M.set({
            x: 4
          }, "t") != M || M.size != 2)
            return !1;
          var U = M.entries(), j = U.next();
          return j.done || j.value[0] != H || j.value[1] != "s" ? !1 : (j = U.next(), !(j.done || j.value[0].x != 4 || j.value[1] != "t" || !U.next().done));
        } catch (Ze) {
          return !1;
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var E = /* @__PURE__ */ new WeakMap(), y = function(M) {
        if (this.data_ = {}, this.head_ = ne(), this.size = 0, M) {
          M = r.makeIterator(M);
          for (var U; !(U = M.next()).done; )
            U = U.value, this.set(U[0], U[1]);
        }
      };
      y.prototype.set = function(H, M) {
        H = H === 0 ? 0 : H;
        var U = C(this, H);
        return U.list || (U.list = this.data_[U.id] = []), U.entry ? U.entry.value = M : (U.entry = {
          next: this.head_,
          previous: this.head_.previous,
          head: this.head_,
          key: H,
          value: M
        }, U.list.push(U.entry), this.head_.previous.next = U.entry, this.head_.previous = U.entry, this.size++), this;
      }, y.prototype.delete = function(H) {
        return H = C(this, H), H.entry && H.list ? (H.list.splice(H.index, 1), H.list.length || delete this.data_[H.id], H.entry.previous.next = H.entry.next, H.entry.next.previous = H.entry.previous, H.entry.head = null, this.size--, !0) : !1;
      }, y.prototype.clear = function() {
        this.data_ = {}, this.head_ = this.head_.previous = ne(), this.size = 0;
      }, y.prototype.has = function(H) {
        return !!C(this, H).entry;
      }, y.prototype.get = function(H) {
        return (H = C(this, H).entry) && H.value;
      }, y.prototype.entries = function() {
        return re(this, function(H) {
          return [H.key, H.value];
        });
      }, y.prototype.keys = function() {
        return re(this, function(H) {
          return H.key;
        });
      }, y.prototype.values = function() {
        return re(this, function(H) {
          return H.value;
        });
      }, y.prototype.forEach = function(H, M) {
        for (var U = this.entries(), j; !(j = U.next()).done; )
          j = j.value, H.call(M, j[1], j[0], this);
      }, y.prototype[Symbol.iterator] = y.prototype.entries;
      var C = function(M, U) {
        var j = U && J(U);
        j == "object" || j == "function" ? E.has(U) ? j = E.get(U) : (j = "" + ++Je, E.set(U, j)) : j = "p_" + U;
        var Ze = M.data_[j];
        if (Ze && r.owns(M.data_, j))
          for (M = 0; M < Ze.length; M++) {
            var Tt = Ze[M];
            if (U !== U && Tt.key !== Tt.key || U === Tt.key)
              return {
                id: j,
                list: Ze,
                index: M,
                entry: Tt
              };
          }
        return {
          id: j,
          list: Ze,
          index: -1,
          entry: void 0
        };
      }, re = function(M, U) {
        var j = M.head_;
        return r.iteratorPrototype(function() {
          if (j) {
            for (; j.head != M.head_; )
              j = j.previous;
            for (; j.next != j.head; )
              return j = j.next, {
                done: !1,
                value: U(j)
              };
            j = null;
          }
          return {
            done: !0,
            value: void 0
          };
        });
      }, ne = function() {
        var M = {};
        return M.previous = M.next = M.head = M;
      }, Je = 0;
      return y;
    }, "es6", "es3");
    var s = "omid_message_guid", l = "omid_message_method", h = "omid_message_version", A = "omid_message_args", g = function(u, E, y, C) {
      this.guid = u, this.method = E, this.version = y, this.args = C;
    };
    g.isValidSerializedMessage = function(a) {
      return !!a && a[s] !== void 0 && a[l] !== void 0 && a[h] !== void 0 && typeof a[s] == "string" && typeof a[l] == "string" && typeof a[h] == "string" && (a[A] === void 0 || a[A] !== void 0);
    }, g.deserialize = function(a) {
      return new g(a[s], a[l], a[h], a[A]);
    }, g.prototype.serialize = function() {
      var a = {};
      return a = (a[s] = this.guid, a[l] = this.method, a[h] = this.version, a), this.args !== void 0 && (a[A] = this.args), a;
    };
    var S = {
      AdEventType: {
        SESSION_START: "sessionStart",
        SESSION_FINISH: "sessionFinish"
      },
      MediaEventType: {
        LOADED: "loaded",
        START: "start",
        FIRST_QUARTILE: "firstQuartile",
        MIDPOINT: "midpoint",
        THIRD_QUARTILE: "thirdQuartile",
        COMPLETE: "complete",
        PAUSE: "pause",
        RESUME: "resume",
        BUFFER_START: "bufferStart",
        BUFFER_FINISH: "bufferFinish",
        SKIPPED: "skipped",
        VOLUME_CHANGE: "volumeChange",
        PLAYER_STATE_CHANGE: "playerStateChange",
        AD_USER_INTERACTION: "adUserInteraction"
      },
      ImpressionType: {
        DEFINED_BY_JAVASCRIPT: "definedByJavaScript"
      },
      ErrorType: {
        GENERIC: "generic"
      },
      AccessMode: {
        FULL: "full"
      },
      Environment: {
        APP: "app",
        WEB: "web"
      },
      CreativeType: {
        DEFINED_BY_JAVASCRIPT: "definedByJavaScript"
      },
      CommunicationType: {
        NONE: "NONE",
        DIRECT: "DIRECT",
        POST_MESSAGE: "POST_MESSAGE"
      },
      MessageMethod: {
        IDENTIFY_SERVICE_WINDOW: "identifyServiceWindow"
      }
    }, L = function(u) {
      this.to = u, this.communicationType_ = S.CommunicationType.NONE;
    };
    L.prototype.sendMessage = function(a, u) {
    }, L.prototype.handleMessage = function(a, u) {
      this.onMessage && this.onMessage(a, u);
    }, L.prototype.serialize = function(a) {
      return JSON.stringify(a);
    }, L.prototype.deserialize = function(a) {
      return JSON.parse(a);
    }, L.prototype.isDirectCommunication = function() {
      return this.communicationType_ === S.CommunicationType.DIRECT;
    }, L.prototype.isCrossOrigin = function() {
    };
    function Q(a, u) {
      if (!u)
        throw Error("Value for " + a + " is undefined, null or blank.");
      if (typeof u != "string" && !(u instanceof String))
        throw Error("Value for " + a + " is not a string.");
      if (u.trim() === "")
        throw Error("Value for " + a + " is empty string.");
    }
    function te(a, u) {
      if (u == null)
        throw Error("Value for " + a + " is undefined or null");
    }
    function de(a, u) {
      if (u == null)
        throw Error(a + " must not be null or undefined.");
      if (typeof u != "number" || isNaN(u))
        throw Error("Value for " + a + " is not a number");
    }
    function ge(a, u, E, y) {
      if (de(a, u), u < E || u > y)
        throw Error("Value for " + a + " is outside the range [" + E + "," + y + "]");
    }
    function Y() {
      return typeof i == "undefined" ? null : i;
    }
    function N(a, u) {
      return a && (a[u] || (a[u] = {}));
    }
    function O(a, u, E) {
      (E = E === void 0 ? Y() : E) && (a = a.split("."), a.slice(0, a.length - 1).reduce(N, E)[a[a.length - 1]] = u);
    }
    var b = function(u, E) {
      Q("Partner.name", u), Q("Partner.version", E), this.name = u, this.version = E;
    };
    O("OmidSessionClient.Partner", b);
    var G = function(u, E, y, C) {
      C = C === void 0 ? S.AccessMode.FULL : C, Q("VerificationScriptResource.resourceUrl", u), this.resourceUrl = u, this.vendorKey = E, this.verificationParameters = y, this.accessMode = C;
    };
    G.prototype.toJSON = function() {
      return {
        accessMode: this.accessMode,
        resourceUrl: this.resourceUrl,
        vendorKey: this.vendorKey,
        verificationParameters: this.verificationParameters
      };
    }, O("OmidSessionClient.VerificationScriptResource", G);
    var K = function(u, E) {
      Q("UniversalAdId.value", u), Q("UniversalAdId.idRegistry", E), this.value = u, this.idRegistry = E;
    };
    K.prototype.toSerialisedValue = function() {
      return this.value + "; " + this.idRegistry;
    }, O("OmidSessionClient.UniversalAdId", K);
    var Z = function(u, E, y, C, re) {
      y = y === void 0 ? null : y, C = C === void 0 ? null : C, re = re === void 0 ? null : re, te("Context.partner", u), this.partner = u, this.verificationScriptResources = E, this.videoElement = this.slotElement = null, this.contentUrl = y, this.customReferenceData = C, this.underEvaluation = !1, this.serviceWindow = null, this.universalAdId = re;
    };
    Z.prototype.setVideoElement = function(a) {
      te("Context.videoElement", a), this.videoElement = a;
    }, Z.prototype.setSlotElement = function(a) {
      te("Context.slotElement", a), this.slotElement = a;
    }, Z.prototype.setServiceWindow = function(a) {
      te("Context.serviceWindow", a), this.serviceWindow = a;
    }, O("OmidSessionClient.Context", Z);
    var F = {};
    function D() {
      if (typeof e != "undefined" && e)
        return e;
      if (typeof Et != "undefined" && Et)
        return Et;
      if (typeof window != "undefined" && window)
        return window;
      if (typeof globalThis != "undefined" && globalThis)
        return globalThis;
      var a = Function("return this")();
      if (a)
        return a;
      throw Error("Could not determine global object context.");
    }
    F.omidGlobal = D();
    var R = {
      ROOT: "omidSessionInterface",
      AD_EVENTS: "adEvents",
      MEDIA_EVENTS: "mediaEvents"
    }, w = {
      sessionError: "reportError"
    }, $ = Object.keys(S.MediaEventType).map(function(a) {
      return S.MediaEventType[a];
    }), ee = ["impressionOccurred"], Ce = function(u) {
      u = u === void 0 ? F.omidGlobal : u, this.interfaceRoot_ = u[R.ROOT];
    };
    Ce.prototype.isSupported = function() {
      return this.interfaceRoot_ != null;
    }, Ce.prototype.sendMessage = function(a, u, E) {
      if (a == "registerSessionObserver" && (E = [u]), w[a] && (a = w[a]), u = this.interfaceRoot_, 0 <= ee.indexOf(a) && (u = u[R.AD_EVENTS]), 0 <= $.indexOf(a) && (u = u[R.MEDIA_EVENTS]), u = u[a], !u)
        throw Error("Unrecognized method name: " + a + ".");
      u.apply(null, r.arrayFromIterable(E));
    };
    function _e() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(a) {
        var u = 16 * Math.random() | 0;
        return a = a === "y" ? (u & 3 | 8).toString(16) : u.toString(16), a;
      });
    }
    function ht() {
      var a = r.getRestArguments.apply(0, arguments);
      Pt(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(r.arrayFromIterable(a))))();
      }, function() {
        return console.error.apply(console, r.arrayFromIterable(a));
      });
    }
    function Pt(a, u) {
      typeof jasmine != "undefined" && jasmine ? a() : typeof console != "undefined" && console && console.error && u();
    }
    var Ye = {
      Version: "1.5.6-iab144"
    }, at = 3;
    function je(a) {
      return /\d+\.\d+\.\d+(-.*)?/.test(a);
    }
    function It(a, u) {
      a = a.split("-")[0].split("."), u = u.split("-")[0].split(".");
      for (var E = 0; E < at; E++) {
        var y = parseInt(a[E], 10), C = parseInt(u[E], 10);
        if (y > C)
          break;
        if (y < C)
          return !1;
      }
      return !0;
    }
    var Qe = "1.0.3";
    function ct(a, u) {
      return je(a) && It(a, Qe) ? u : JSON.stringify(u);
    }
    function lt(a, u) {
      return je(a) && It(a, Qe) ? u || [] : u && typeof u == "string" ? JSON.parse(u) : [];
    }
    var Be = {
      SESSION_SERVICE: "SessionService."
    };
    function wt(a) {
      return ve(a, Be.SESSION_SERVICE);
    }
    function ve(a, u) {
      return u + a;
    }
    function pt(a) {
      return a != null && typeof a.top != "undefined" && a.top != null;
    }
    function Ve(a) {
      if (a === F.omidGlobal)
        return !1;
      try {
        if (typeof a.location.hostname == "undefined")
          return !0;
        Oe(a);
      } catch (u) {
        return !0;
      }
      return !1;
    }
    function Oe(a) {
      return a.x === "" || a.x !== "";
    }
    function De(a) {
      return typeof a == "undefined" && typeof window != "undefined" && window && (a = window), pt(a) ? a : F.omidGlobal;
    }
    function qe(a) {
      return pt(a) ? a.top : F.omidGlobal;
    }
    var V = function(u) {
      L.call(this, u), this.communicationType_ = S.CommunicationType.DIRECT, this.handleExportedMessage = V.prototype.handleExportedMessage.bind(this);
    };
    r.inherits(V, L), V.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.handleExportedMessage(a.serialize(), this);
    }, V.prototype.handleExportedMessage = function(a, u) {
      g.isValidSerializedMessage(a) && this.handleMessage(g.deserialize(a), u);
    }, V.prototype.isCrossOrigin = function() {
      return !1;
    };
    var B = function(u, E) {
      E = E === void 0 ? F.omidGlobal : E, L.call(this, E);
      var y = this;
      this.communicationType_ = S.CommunicationType.POST_MESSAGE, u.addEventListener("message", function(C) {
        if (J(C.data) === "object") {
          var re = C.data;
          g.isValidSerializedMessage(re) && (re = g.deserialize(re), C.source && y.handleMessage(re, C.source));
        }
      });
    };
    r.inherits(B, L), B.isCompatibleContext = function(a) {
      return !!(a && a.addEventListener && a.postMessage);
    }, B.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.postMessage(a.serialize(), "*");
    }, B.prototype.isCrossOrigin = function() {
      return this.to ? Ve(this.to) : !0;
    };
    var W = {
      OMID_PRESENT_FRAME_NAME: "omid_v1_present",
      OMID_PRESENT_FRAME_NAME_WEB: "omid_v1_present_web",
      OMID_PRESENT_FRAME_NAME_APP: "omid_v1_present_app",
      getEnvironmentIframeName: function(u) {
        var E = {};
        return (E[S.Environment.APP] = W.OMID_PRESENT_FRAME_NAME_APP, E[S.Environment.WEB] = W.OMID_PRESENT_FRAME_NAME_WEB, E)[u];
      }
    };
    function me(a, u) {
      try {
        return a.frames && !!a.frames[u];
      } catch (E) {
        return !1;
      }
    }
    W.isOmidPresent = function(a) {
      return [W.OMID_PRESENT_FRAME_NAME, W.OMID_PRESENT_FRAME_NAME_WEB, W.OMID_PRESENT_FRAME_NAME_APP].some(function(u) {
        return me(a, u);
      });
    }, W.getOmidEnvironment = function(a) {
      for (var u = r.makeIterator(Object.values(S.Environment)), E = u.next(); !E.done; E = u.next()) {
        E = E.value;
        var y = W.getEnvironmentIframeName(E);
        if (me(a, y))
          return E;
      }
      return null;
    };
    function oe(a, u) {
      a.document.write('<iframe style="display:none" id="' + (u + '" name="' + u + '" sandbox></iframe>'));
    }
    W.declareOmidPresence = function(a, u) {
      a.frames && a.document && ![W.OMID_PRESENT_FRAME_NAME, W.OMID_PRESENT_FRAME_NAME_WEB, W.OMID_PRESENT_FRAME_NAME_APP].some(function(E) {
        return !!a.frames[E];
      }) && (a.document.body == null && W.isMutationObserverAvailable_(a) ? W.registerMutationObserver_(a, u) : (u = W.getEnvironmentIframeName(u), a.document.body ? (W.appendPresenceIframe_(a, W.OMID_PRESENT_FRAME_NAME), W.appendPresenceIframe_(a, u)) : (oe(a, W.OMID_PRESENT_FRAME_NAME), oe(a, u))));
    }, W.appendPresenceIframe_ = function(a, u) {
      var E = a.document.createElement("iframe");
      E.id = u, E.name = u, E.style.display = "none", E.sandbox = "", a.document.body.appendChild(E);
    }, W.isMutationObserverAvailable_ = function(a) {
      return "MutationObserver" in a;
    }, W.registerMutationObserver_ = function(a, u) {
      var E = new MutationObserver(function(y) {
        y.forEach(function(C) {
          C.addedNodes[0].nodeName === "BODY" && (C = W.getEnvironmentIframeName(u), W.appendPresenceIframe_(a, W.OMID_PRESENT_FRAME_NAME), W.appendPresenceIframe_(a, C), E.disconnect());
        });
      });
      E.observe(a.document.documentElement, {
        childList: !0
      });
    };
    var ft = ["omid", "v1_SessionServiceCommunication"];
    function Ot(a, u) {
      return u.reduce(function(E, y) {
        return E && E[y];
      }, a);
    }
    function di(a, u, E, y) {
      if (!Ve(u))
        try {
          var C = Ot(u, E);
          if (C)
            return new V(C);
        } catch (re) {
        }
      return y(u) ? new B(a, u) : null;
    }
    function He(a, u, E, y) {
      u = r.makeIterator(u);
      for (var C = u.next(); !C.done; C = u.next())
        if (C = di(a, C.value, E, y))
          return C;
      return null;
    }
    function ui(a, u, E) {
      E = E === void 0 ? W.isOmidPresent : E;
      var y = [a, qe(a)];
      return u && y.unshift(u), He(a, y, ft, E);
    }
    var ie = function(u, E, y) {
      te("AdSession.context", u), this.adSessionId_ = _e(), this.context_ = u, this.impressionOccurred_ = !1;
      var C = this.context_.serviceWindow || void 0;
      this.communication_ = E || ui(De(), C), this.sessionInterface_ = y || new Ce(), this.isSessionRunning_ = this.hasMediaEvents_ = this.hasAdEvents_ = !1, this.impressionType_ = this.creativeType_ = null, this.creativeLoaded_ = !1, this.callbackMap_ = {}, this.communication_ && (this.communication_.onMessage = this.handleInternalMessage_.bind(this)), this.setClientInfo_(), this.injectVerificationScripts_(u.verificationScriptResources), this.sendSlotElement_(u.slotElement), this.sendVideoElement_(u.videoElement), this.sendContentUrl_(u.contentUrl), this.watchSessionEvents_();
    };
    ie.prototype.getAdSessionId = function() {
      return this.adSessionId_;
    }, ie.prototype.setCreativeType = function(a) {
      if (a === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined with value " + S.CreativeType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.creativeType_ && this.creativeType_ !== S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined");
      if (this.creativeType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setCreativeType", a, this.adSessionId_), this.creativeType_ = a;
    }, ie.prototype.setImpressionType = function(a) {
      if (a === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined with value " + S.ImpressionType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.impressionType_ && this.impressionType_ !== S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined");
      if (this.impressionType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setImpressionType", a, this.adSessionId_), this.impressionType_ = a;
    }, ie.prototype.isSupported = function() {
      return !!this.communication_ || this.sessionInterface_.isSupported();
    }, ie.prototype.isSendingElementsSupported_ = function() {
      return this.communication_ ? this.communication_.isDirectCommunication() : this.sessionInterface_.isSupported();
    }, ie.prototype.registerSessionObserver = function(a) {
      this.sendMessage("registerSessionObserver", a, this.adSessionId_);
    }, ie.prototype.start = function() {
      var a = {
        customReferenceData: this.context_.customReferenceData,
        underEvaluation: this.context_.underEvaluation
      };
      this.context_.universalAdId && (a.universalAdId = this.context_.universalAdId.toSerialisedValue()), this.sendOneWayMessage("startSession", a, this.adSessionId_);
    }, ie.prototype.finish = function() {
      this.sendOneWayMessage("finishSession", this.adSessionId_);
    }, ie.prototype.error = function(a, u) {
      this.sendOneWayMessage("sessionError", a, u, this.adSessionId_);
    }, ie.prototype.registerAdEvents = function() {
      if (this.hasAdEvents_)
        throw Error("AdEvents already registered.");
      this.hasAdEvents_ = !0, this.sendOneWayMessage("registerAdEvents", this.adSessionId_);
    }, ie.prototype.registerMediaEvents = function() {
      if (this.hasMediaEvents_)
        throw Error("MediaEvents already registered.");
      this.hasMediaEvents_ = !0, this.sendOneWayMessage("registerMediaEvents", this.adSessionId_);
    }, ie.prototype.sendOneWayMessage = function(a) {
      var u = r.getRestArguments.apply(1, arguments);
      this.sendMessage.apply(this, [a, null].concat(r.arrayFromIterable(u)));
    }, ie.prototype.sendMessage = function(a, u) {
      var E = r.getRestArguments.apply(2, arguments);
      this.communication_ ? this.sendInternalMessage_(a, u, E) : this.sessionInterface_.isSupported() && this.sendInterfaceMessage_(a, u, E);
    }, ie.prototype.sendInternalMessage_ = function(a, u, E) {
      var y = _e();
      u && (this.callbackMap_[y] = u), a = new g(y, wt(a), Ye.Version, ct(Ye.Version, E)), this.communication_.sendMessage(a);
    }, ie.prototype.handleInternalMessage_ = function(a, u) {
      u = a.method;
      var E = a.guid;
      if (a = a.args, u === "response" && this.callbackMap_[E]) {
        var y = lt(Ye.Version, a);
        this.callbackMap_[E].apply(this, y);
      }
      u === "error" && window.console && ht(a);
    }, ie.prototype.sendInterfaceMessage_ = function(a, u, E) {
      try {
        this.sessionInterface_.sendMessage(a, u, E);
      } catch (y) {
        ht("Failed to communicate with SessionInterface with error:"), ht(y);
      }
    }, ie.prototype.assertSessionRunning = function() {
      if (!this.isSessionRunning_)
        throw Error("Session not started.");
    }, ie.prototype.impressionOccurred = function() {
      if (this.creativeType_ === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.impressionOccurred_ = !0;
    }, ie.prototype.creativeLoaded = function() {
      if (this.creativeType_ === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.creativeLoaded_ = !0;
    }, ie.prototype.setClientInfo_ = function() {
      this.sendOneWayMessage("setClientInfo", Ye.Version, this.context_.partner.name, this.context_.partner.version, this.adSessionId_);
    }, ie.prototype.injectVerificationScripts_ = function(a) {
      a && (a = a.map(function(u) {
        return u.toJSON();
      }), this.sendOneWayMessage("injectVerificationScriptResources", a, this.adSessionId_));
    }, ie.prototype.sendSlotElement_ = function(a) {
      this.sendElement_(a, "setSlotElement");
    }, ie.prototype.sendVideoElement_ = function(a) {
      this.sendElement_(a, "setVideoElement");
    }, ie.prototype.sendElement_ = function(a, u) {
      a && (this.isSendingElementsSupported_() ? this.sendOneWayMessage(u, a, this.adSessionId_) : this.error(S.ErrorType.GENERIC, "Session Client " + u + " called when communication is cross-origin"));
    }, ie.prototype.sendContentUrl_ = function(a) {
      a && this.sendOneWayMessage("setContentUrl", a, this.adSessionId_);
    }, ie.prototype.setElementBounds = function(a) {
      te("AdSession.elementBounds", a), this.sendOneWayMessage("setElementBounds", a, this.adSessionId_);
    }, ie.prototype.watchSessionEvents_ = function() {
      var a = this;
      this.registerSessionObserver(function(u) {
        u.type === S.AdEventType.SESSION_START && (a.isSessionRunning_ = !0, a.creativeType_ = u.data.creativeType, a.impressionType_ = u.data.impressionType), u.type === S.AdEventType.SESSION_FINISH && (a.isSessionRunning_ = !1);
      });
    }, O("OmidSessionClient.AdSession", ie);
    var Yt = function(u, E, y, C) {
      this.isSkippable = u, this.skipOffset = E, this.isAutoPlay = y, this.position = C;
    };
    Yt.prototype.toJSON = function() {
      return {
        isSkippable: this.isSkippable,
        skipOffset: this.skipOffset,
        isAutoPlay: this.isAutoPlay,
        position: this.position
      };
    };
    var Gt = function(u) {
      te("AdEvents.adSession", u), this.adSessionId_ = u.getAdSessionId();
      try {
        u.registerAdEvents(), this.adSession = u;
      } catch (E) {
        throw Error("AdSession already has an ad events instance registered");
      }
    };
    Gt.prototype.impressionOccurred = function() {
      this.adSession.assertSessionRunning(), this.adSession.impressionOccurred(), this.adSession.sendOneWayMessage("impressionOccurred", this.adSessionId_);
    }, Gt.prototype.loaded = function(a) {
      a = a === void 0 ? null : a, this.adSession.creativeLoaded(), a = a ? a.toJSON() : null, this.adSession.sendOneWayMessage("loaded", a, this.adSessionId_);
    }, O("OmidSessionClient.AdEvents", Gt);
    var Se = function(u) {
      te("MediaEvents.adSession", u), this.adSessionId_ = u.getAdSessionId();
      try {
        u.registerMediaEvents(), this.adSession = u;
      } catch (E) {
        throw Error("AdSession already has a media events instance registered");
      }
    };
    Se.prototype.start = function(a, u) {
      de("MediaEvents.start.duration", a), ge("MediaEvents.start.mediaPlayerVolume", u, 0, 1), this.adSession.sendOneWayMessage("start", a, u, this.adSessionId_);
    }, Se.prototype.firstQuartile = function() {
      this.adSession.sendOneWayMessage("firstQuartile", this.adSessionId_);
    }, Se.prototype.midpoint = function() {
      this.adSession.sendOneWayMessage("midpoint", this.adSessionId_);
    }, Se.prototype.thirdQuartile = function() {
      this.adSession.sendOneWayMessage("thirdQuartile", this.adSessionId_);
    }, Se.prototype.complete = function() {
      this.adSession.sendOneWayMessage("complete", this.adSessionId_);
    }, Se.prototype.pause = function() {
      this.adSession.sendOneWayMessage("pause", this.adSessionId_);
    }, Se.prototype.resume = function() {
      this.adSession.sendOneWayMessage("resume", this.adSessionId_);
    }, Se.prototype.bufferStart = function() {
      this.adSession.sendOneWayMessage("bufferStart", this.adSessionId_);
    }, Se.prototype.bufferFinish = function() {
      this.adSession.sendOneWayMessage("bufferFinish", this.adSessionId_);
    }, Se.prototype.skipped = function() {
      this.adSession.sendOneWayMessage("skipped", this.adSessionId_);
    }, Se.prototype.volumeChange = function(a) {
      ge("MediaEvents.volumeChange.mediaPlayerVolume", a, 0, 1), this.adSession.sendOneWayMessage("volumeChange", a, this.adSessionId_);
    }, Se.prototype.playerStateChange = function(a) {
      te("MediaEvents.playerStateChange.playerState", a), this.adSession.sendOneWayMessage("playerStateChange", a, this.adSessionId_);
    }, Se.prototype.adUserInteraction = function(a) {
      te("MediaEvents.adUserInteraction.interactionType", a), this.adSession.sendOneWayMessage("adUserInteraction", a, this.adSessionId_);
    }, O("OmidSessionClient.MediaEvents", Se);
    var hi = function(u, E) {
      Q("OmidVersion.semanticVersion", u), Q("OmidVersion.apiLevel", E);
    };
    O("OmidSessionClient.OmidVersion", hi);
    function ci(a) {
      var u = De();
      new B(u).onMessage = function(E, y) {
        E.method === S.MessageMethod.IDENTIFY_SERVICE_WINDOW && a(y);
      };
    }
    O("OmidSessionClient.listenForServiceWindow", ci), O("OmidSessionClient.VastProperties", Yt);
    var ke = {
      VerificationVendorId: {
        OTHER: 1,
        MOAT: 2,
        DOUBLEVERIFY: 3,
        INTEGRAL_AD_SCIENCE: 4,
        PIXELATE: 5,
        NIELSEN: 6,
        COMSCORE: 7,
        MEETRICS: 8,
        GOOGLE: 9,
        HUMAN: 10
      }
    };
    function pi(a) {
      for (var u = r.makeIterator(xt.keys()), E = u.next(); !E.done; E = u.next()) {
        E = E.value;
        for (var y = r.makeIterator(xt.get(E)), C = y.next(); !C.done; C = y.next())
          if (C.value.test(a))
            return E;
      }
      return ke.VerificationVendorId.OTHER;
    }
    var xt = /* @__PURE__ */ new Map([[ke.VerificationVendorId.DOUBLEVERIFY, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.doubleverify\.com\/.*$/, /^(https?:\/\/|\/\/)?c\.[\w\-]+\.com\/vfw\/dv\/.*$/, /^(https?:\/\/|\/\/)?(www\.)?[\w]+\.tv\/r\/s\/d\/.*$/, /^(https?:\/\/|\/\/)?(\w\.?)+\.dv\.tech\/.*$/]], [ke.VerificationVendorId.INTEGRAL_AD_SCIENCE, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.adsafeprotected\.com\/.*$/]], [ke.VerificationVendorId.PIXELATE, [/^https?:\/\/(q|cdn)\.adrta\.com\/s\/.*\/(aa|aanf)\.js.*$/, /^https:\/\/cdn\.rta247\.com\/s\/.*\/(aa|aanf)\.js.*$/]], [ke.VerificationVendorId.NIELSEN, []], [ke.VerificationVendorId.COMSCORE, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.voicefive\.com\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.measuread\.com\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.scorecardresearch\.com\/.*$/]], [ke.VerificationVendorId.MEETRICS, [/^(https?:\/\/|\/\/)?s418\.mxcdn\.net\/bb-serve\/omid-meetrics.*\.js$/]], [ke.VerificationVendorId.GOOGLE, [/^(https?:\/\/|\/\/)?pagead2\.googlesyndication\.com\/.*$/, /^(https?:\/\/|\/\/)?www\.googletagservices\.com\/.*$/]], [ke.VerificationVendorId.HUMAN, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.script\.ac\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\/(2|ag|static)\/[a-zA-Z0-9.]*\/analytics.js.*$/]]]);
    O("OmidSessionClient.verificationVendorIdForScriptUrl", pi), O("OmidSessionClient.VerificationVendorId", ke.VerificationVendorId), ke.verificationVendorIdForScriptUrl = pi;
  }, p);
})(Xn);
const Ao = /* @__PURE__ */ mo(Xn), bi = {
  ERROR_RESOURCE_REJECTED: 1,
  // or OM disabled by publisher
  ERROR_VERIFICATION_NOT_SUPPORTED: 2
}, ae = class ae {
  // TODO: Possible to make a currentAdRuntime interface?
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, i) {
    if (this.ad = e, this.adSlotDelivery = i, this.sessionClient = Ao.OmidSessionClient, this.removeEventHandlers = [], this.video = i.player.getPlayerElement(), !this.sessionClient) {
      c.debug.warn(ae.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = i.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      c.debug.info(
        ae.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (c.debug.info(
      ae.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), c.debug.table(this.verifications), this.internalOmidConfig.disabled) {
      c.debug.warn(
        ae.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
      ), this.verifications.forEach((r) => {
        this.trackError(
          r.tracking.verificationNotExecuted,
          bi.ERROR_RESOURCE_REJECTED
        );
      });
      return;
    }
    if (this.internalOmidConfig.playerHandles) {
      c.debug.info(ae.NAME + "playerHandles is true");
      return;
    }
    if (e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      c.debug.info(
        ae.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      ae.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  /**
   * Filters ad verifications based on the vendor whitelist.
   *
   * @param {Array} adVerifications - An array of ad verifications to be filtered.
   * @param {Array} vendorAllowList - An array of allowed vendors.
   * @return {Array} The filtered ad verifications.
   */
  /** @internal */
  filterVerifications(e, i) {
    return !e || e.length === 0 ? e : e.filter((r) => {
      const s = !i || i.length === 0 || i.includes(r.vendor);
      if (!s)
        return this.trackError(r.tracking.verificationNotExecuted, bi.ERROR_RESOURCE_REJECTED), !1;
      if (i)
        return !0;
      const l = r.javascriptResource ? r.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !i && !l ? (s && this.trackError(
        r.tracking.verificationNotExecuted,
        bi.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  /** @internal */
  initOMIDJS() {
    if (this.adSession = this.createAdSession(), this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? ae.IMPRESSION_TYPE.RENDER : ae.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), c.debug.info(ae.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return c.debug.error(ae.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((i) => {
        this.trackError(
          i.tracking.verificationNotExecuted,
          bi.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const e = () => {
      const i = this.createVastProperties();
      this.adEvents.loaded(i), this.video.removeEventListener("canplaythrough", e);
    };
    return this.video.addEventListener("canplaythrough", e), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  /** @internal */
  createAdSession() {
    let e = new this.sessionClient.Partner(ae.PARTNER_NAME, ae.PARTNER_VERSION), i = this.verifications.map((s) => (c.debug.info(
      ae.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      xi(s.javascriptResource.url, s.javascriptResource.url),
      "vendor:",
      s.vendor,
      "verification params:",
      s.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      xi(s.javascriptResource.url, s.javascriptResource.url),
      s.vendor,
      s.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), r = new this.sessionClient.Context(e, i, this.CONTENT_URL);
    return r.underEvaluation = !0, r.setVideoElement(this.video), r.setServiceWindow(this.OMSDK_SERVICE_WINDOW), r.supportsLoadedEvent = !0, new this.sessionClient.AdSession(r);
  }
  addEventListeners() {
    this.removeEventListeners(), Object.keys(f).forEach((e) => {
      let i = this.adSlotDelivery.adSlotController.addEventListener(
        f[e],
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    });
  }
  /** @internal */
  removeEventListeners() {
    this.removeEventHandlers.forEach((e) => {
      e();
    }), this.removeEventHandlers = [];
  }
  /** @internal */
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case f.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), c.debug.info(ae.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case f.ON_AD_SKIPPED:
      case f.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          c.debug.info(ae.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  /** @internal */
  forwardEventToOMSDK(e) {
    let i = "forwardEventToOMSDK";
    if (c.debug.info(ae.NAME + i, e), !this.adEvents) {
      c.debug.warn(ae.NAME + i + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let r;
    switch (e) {
      case f.ON_AD_STARTED:
        r = this.createVastProperties(), this.adEvents.start(r);
        break;
      case f.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case f.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case f.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case f.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case f.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case f.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case f.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case f.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case f.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case f.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case f.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case f.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case f.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case f.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case f.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  /** @internal */
  trackError(e, i) {
    c.debug.info(
      ae.NAME + "trackError - errorReason",
      i,
      "errorTracker",
      e
    ), this.ad.enrichment.set("REASON", i, "reason");
    const r = {
      adReinsertion: this.ad.adReinsertion,
      enrichment: this.ad.enrichment,
      timeouts: this.ad.config.timeouts,
      urlhandler: this.ad.config.urlhandler
    };
    new oi().track(e, null, r);
  }
};
ae.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, ae.PARTNER_NAME = "Smartcliptv", ae.PARTNER_VERSION = "7.5.6", ae.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], ae.NAME = "OMID::";
let gr = ae;
const gt = class gt extends yt {
  constructor(e, i) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = i, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((i) => {
      this.render(), i();
    });
  }
  /** @internal */
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  /**
   * Defines the container that surrounds the advertiser's asset, depending on the resource type.
   * - the ad has to appear in the upper centered position
   * - the container holds tracking and interaction data
   * @internal
   * @returns {void}
   */
  /** @internal */
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  /** @internal */
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case "StaticResource":
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let i = document.createElement(e);
    for (let r in this.ad.attributes)
      this.ad.attributes[r] && i.setAttribute(r, this.ad.attributes[r]);
    i.style.pointerEvents = "auto", i.onload = this.onStartAd.bind(this), e === "iframe" ? (i.style.border = "0", i.setAttribute("scrolling", "no"), i.setAttribute("margin", "0"), i.setAttribute("allowtransparency", "true")) : (i.style.cursor = "pointer", i.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(i), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    this.cleanupTimer.forEach((e) => {
      clearTimeout(e);
    }), this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    c.debug.info(gt.NAME + "pause"), this.cleanupTimer.forEach((e) => {
      clearTimeout(e);
    }), this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    c.debug.info(gt.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    c.debug.info(gt.NAME + "play - remove ad in", e, "seconds.");
    const i = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(i);
  }
  onStartAd() {
    c.debug.info(gt.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(f.ON_AD_LOADED), this.dispatchEvent(f.ON_AD_STARTED), this.dispatchEvent(f.ON_AD_IMPRESSION), this.dispatchEvent(f.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    c.debug.info(gt.NAME + "onStopAd"), this.dispatchEvent(f.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(f.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
gt.NAME = "NonLinear::";
let vr = gt;
const nt = class nt extends yt {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, i, r) {
    super(), this.adSlotController = r, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = i;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, i) {
    return this.adSlotController.addEventListener(e, i);
  }
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventCallbacks.push(r), () => this.player.removeEventListener(e, i);
  }
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        c.debug.info(
          nt.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const r = () => {
          this.currentAd.replaced ? (i(), this.deliverNextAd()) : (S(), this.cleanAndDeliveryNextAd());
        }, s = () => {
          this.saveStartVolumeVPAID();
        }, l = () => {
          this.adSlotController.applyBuffetAd();
        }, h = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_AD_STARTED,
          s
        ), A = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_AD_ERROR,
          l
        ), g = this.getRemoveHandlerForAdSlotControllerEvent(
          f.ON_VPAID_CLEANUP,
          r
        ), S = () => {
          h(), A(), g();
        };
      }
    }, i = this.getRemoveHandlerForAdSlotControllerEvent(
      f.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, i) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, i);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener($e.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener($e.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(f.ON_AD_PAUSED);
    }), this.addPlayerEventListener($e.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(f.ON_AD_PLAYING);
    }), this.addPlayerEventListener($e.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(f.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(f.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(f.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(f.ON_AD_START, this.saveStartVolume), super.addEventListener(f.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener($e.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(f.ON_AD_STOPPED), c.debug.info(nt.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener($e.ON_ERROR, () => {
      c.debug.info(
        nt.NAME + "on - Player sent error event"
      );
    });
  }
  /** @internal */
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  /** @internal */
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => (this.adSlotHasStarted && (this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(f.ON_AD_SLOT_STOPPED)), this.eventCallbacks.forEach((i) => {
      i();
    }), this.eventCallbacks = []), e()));
  }
  deliverNextAd() {
    var r;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), c.debug.info(nt.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function i() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(f.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const s = e.currentAd.config.trackImpressionOnStart ? f.ON_AD_PLAYBACK_START : f.ON_AD_STARTED;
        e.removeImpressionOnStartHandler = e.addEventListener(s, () => {
          e.adSlotController.dispatchEvent(f.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(f.ON_AD_CREATIVE_VIEW);
        });
        let l = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(l);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(f.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (r = e.currentAd) != null && r.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : i();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  /** @internal */
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((i) => i.type === "companion" && i.hasCompanionResources);
    e && e.length > 0 && this.dispatchEvent(f.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(f.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(f.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(f.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.config.adVerification.disabled || new gr(this.currentAd, this), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0 && this.dispatchEvent(f.ON_VERIFICATION_DETECTED);
  }
  /** @internal */
  activateHOMAD(e, i) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: i,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR)), ce.EventDispatcher.dispatchEvent(f.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let i = "Load MediaFile ", r = e.fileURL, s = !1;
      clearTimeout(this.loadPendingTimeout);
      let l = (h) => {
        s = !0, c.debug.error("VideoProxy load timeout.", h), this.currentAd.error = x.VAST.TIMEOUT, this.deliverOrHOMAD(ce.REASON.MEDIAFILE_TIMEOUT, r);
      };
      this.loadPendingTimeout = setTimeout(
        l.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), c.debug.info(nt.NAME + i + "from URI", r), this.player.load(r, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !s && (c.debug.info(nt.NAME + i + "success."), this.adSlotController.dispatchEvent(f.ON_AD_LOADED), this.dispatchEvent(f.ON_AD_STARTED));
      }, (h) => {
        if (clearTimeout(this.loadPendingTimeout), s)
          return;
        c.debug.error(nt.NAME + i + "failed", h);
        const A = {
          [x.VAST.GENERAL_ERROR.code]: x.VAST.GENERAL_ERROR,
          [x.VAST.FILE_NOT_FOUND.code]: x.VAST.FILE_NOT_FOUND,
          [x.VAST.UNSUPPORTED_MIMETYPE.code]: x.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = A[h] || x.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(ce.REASON.MEDIAFILE_LOAD_ERROR, r);
      });
    } else {
      let i, r = !1, s = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener($e.ON_LOADED_DATA, () => {
          this.dispatchEvent(f.ON_AD_STARTED), this.dispatchEvent(f.ON_AD_IMPRESSION), this.dispatchEvent(f.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener($e.ON_ENDED, () => {
          this.dispatchEvent(f.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(f.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((l) => {
        r = !0, c.debug.error(s + " timeout.", l), this.currentAd.error = x.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.deliverOrHOMAD(ce.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (c.debug.info(
        s + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), i = this.adSlotController.environmentVars.adContainer) : (c.debug.warn(s + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), i = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new vr(this, i), [
        f.ON_AD_STARTED,
        f.ON_AD_IMPRESSION,
        f.ON_AD_CREATIVE_VIEW,
        f.ON_AD_NONLINEAR_STOPPED,
        f.ON_AD_STOPPED
      ].map((l) => {
        const h = this.adSlotController.nonLinearView.addEventListener(
          l,
          (A) => {
            this.dispatchEvent(A.type), A.type === f.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(h);
      }), this.addPlayerEventListener($e.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener($e.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && c.debug.info(s + "Request complete");
      }, (l) => {
        clearTimeout(this.loadPendingTimeout), !r && (c.debug.error("loadAd - VideoProxy load failed", l), this.currentAd.error = x.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(f.ON_AD_ERROR), this.deliverOrHOMAD(ce.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
nt.NAME = "AdSloDel::";
let Sr = nt;
class Nr {
  getResources() {
    return this.resources;
  }
  constructor(e, i) {
    var r, s, l, h;
    this.adParameters = ((s = (r = i.querySelector("AdParameters")) == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null, this.apiFramework = i.getAttribute("apiFramework") || null, this.clickThroughURL = ((h = (l = i.querySelector(e + "ClickThrough")) == null ? void 0 : l.textContent) == null ? void 0 : h.trim()) || null, this.clickTracker = this.getClickTracker(e, i), this.resources = this.parseResources(i);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let i = [], r = e.querySelectorAll(
      "HTMLResource, IFrameResource, StaticResource"
    );
    for (let s = 0; s < r.length; s++)
      i.push({
        creativeType: r[s].getAttribute("creativeType"),
        resource: z.trim(r[s].textContent || ""),
        type: r[s].nodeName
      });
    return i;
  }
  getClickTracker(e, i) {
    let r = [];
    return [].slice.call(i.querySelectorAll(e + "ClickTracking")).forEach((s) => {
      r.push({
        url: z.trim(s.textContent),
        id: s.getAttribute("id")
      });
    }), r;
  }
}
class Eo extends Nr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.adSlotId = r.getAttribute("adSlotId") || "", this.altText = z.trim(((s = r.querySelector("AltText")) == null ? void 0 : s.textContent) || ""), this.assetHeight = r.getAttribute("assetHeight") || "", this.assetWidth = r.getAttribute("assetWidth") || "", this.companionXML = r, this.creativeViewTracker = i, this.expandedHeight = r.getAttribute("expandedHeight") || "", this.expandedWidth = r.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = r.getAttribute("height"), this.id = r.getAttribute("id") || Bn(), this.pxratio = r.getAttribute("pxratio") || "1", this.renderingMode = r.getAttribute("renderingMode") || "default", this.width = r.getAttribute("width");
  }
}
function Ee(p, e) {
  const i = (p == null ? void 0 : p.getAttribute(e)) || -1;
  let r = -1;
  return typeof i == "string" && (r = parseInt(i, 10)), isNaN(i) ? -1 : r;
}
class go extends Nr {
  constructor(e, i, r) {
    var s;
    super(e, r), this.altText = z.trim(((s = r.querySelector("AltText")) == null ? void 0 : s.textContent) || ""), this.creativeViewTracker = i, this.duration = Ee(r, "duration"), this.hasCreative = super.getResources().length > 0, this.height = z.trim(r.getAttribute("height")), this.hoverText = r.getAttribute("hoverText") || null, this.offset = z.convertTimeStringToSeconds(r.getAttribute("offset")), this.program = r.getAttribute("program") || "unknown", this.pxratio = Ee(r, "pxratio"), this.width = r.getAttribute("width"), this.xPosition = r.getAttribute("xPosition"), this.yPosition = r.getAttribute("yPosition");
  }
}
class vo extends Nr {
  constructor(e, i, r) {
    const s = Ee(r, "expandedHeight"), l = Ee(r, "expandedWidth"), h = Ee(r, "height"), A = r.getAttribute("id"), g = r.getAttribute("maintainAspectRatio") !== "false", S = z.convertTimeStringToSeconds(
      r.getAttribute("minSuggestedDuration")
    ), L = r.getAttribute("scalable") !== "false", Q = Ee(r, "width");
    super(e, r), this.creativeTrackers = i, this.displayDuration = null, this.expandedHeight = s, this.expandedWidth = l, this.height = h, this.id = A, this.maintainAspectRatio = g, this.minSuggestedDuration = S != null ? S : -1, this.scalable = L, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = Q;
  }
}
var li = ((p) => (p.COMPANION = "companion", p[p.LINEAR = he.LINEAR] = "LINEAR", p[p.NON_LINEAR = he.NON_LINEAR] = "NON_LINEAR", p))(li || {});
class So {
  constructor(e) {
    this.adXML = e, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, i = this.companion, r = e.mediaFiles.interactive, s = this.nonLinearCreative, l = e.mediaFiles.streaming, h = e.mediaFiles.vpaid, A = [];
    return A = A.concat(
      ...h,
      ...l,
      ...r,
      ...s,
      ...i
    ), A;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  /** @internal */
  getLinear() {
    let e = this.adXML.querySelector("InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), i = e.querySelector("MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(i),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getVPAIDCreatives(e) {
    var l;
    let i = [], r = e.querySelectorAll('MediaFile[apiFramework="VPAID"]'), s = e.querySelector("AdParameters");
    for (let h = 0; h < r.length; h++)
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: "VPAID",
        bitrate: Ee(r[h], "bitrate"),
        fileURL: z.trim(r[h].textContent),
        height: Ee(r[h], "height"),
        linearity: he.LINEAR,
        mimeType: r[h].getAttribute("type"),
        width: Ee(r[h], "width")
      });
    return i;
  }
  getStreamingCreatives(e) {
    let i = [], r = e.querySelectorAll('MediaFile:not([apiFramework="VPAID"])');
    for (let s = 0; s < r.length; s++)
      i.push({
        apiFramework: r[s].getAttribute("apiFramework"),
        bitrate: Ee(r[s], "bitrate"),
        fileURL: z.trim(r[s].textContent),
        height: Ee(r[s], "height"),
        linearity: he.LINEAR,
        mimeType: r[s].getAttribute("type"),
        width: Ee(r[s], "width")
      });
    return i;
  }
  getInteractiveCreatives(e) {
    var l;
    const i = [], r = e.querySelectorAll("InteractiveCreativeFile"), s = e.querySelector("AdParameters");
    for (let h = 0; h < r.length; h++) {
      const A = r[h], g = A.getAttribute("variableDuration");
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: A.getAttribute("apiFramework"),
        delivery: A.getAttribute("delivery"),
        fileURL: z.trim(A.textContent),
        linearity: he.LINEAR,
        mimeType: A.getAttribute("type"),
        variableDuration: g ? !!g.match("true") : !1
      });
    }
    return i;
  }
  getClosedCaptionCreatives(e) {
    let i = [], r = e.querySelector("ClosedCaptionFiles");
    if (r) {
      let s = r.querySelectorAll("ClosedCaptionFile");
      for (let l = 0; l < s.length; l++)
        i.push({
          fileURL: s[l].textContent,
          // en, en-US, zh-TW
          language: s[l].getAttribute("language"),
          linearity: he.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: s[l].getAttribute("type")
        });
    }
    return i;
  }
  getCreativeViewTrackers(e, i) {
    const r = [];
    return [...e.querySelectorAll(i)].forEach((s) => {
      r.push({
        url: z.trim(s.textContent)
      });
    }), r;
  }
  getIndustryIcons() {
    const e = {};
    let i = this.adXML.querySelectorAll("Creatives > Creative > Linear Icon");
    for (let r = 0; r < i.length; r++) {
      const s = i[r].getAttribute("program") || "unknown", l = this.getCreativeViewTrackers(i[r], "IconViewTracking"), h = new go("Icon", l, i[r]);
      e[s] = h;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  /** @internal */
  getNonLinear() {
    let e = this.adXML.querySelectorAll("InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    c.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let i = e.querySelectorAll("NonLinear"), r = [{
      type: li.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let s = 0; s < i.length; s++) {
      const l = new vo(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        i[s]
      );
      r[s].variations.push(l);
    }
    return r;
  }
  get companion() {
    const e = this.adXML.querySelectorAll("Creatives > Creative > CompanionAds");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      i[r] = {
        hasCompanionResources: !1,
        required: null,
        type: li.COMPANION,
        variations: []
      };
      const s = e[r].querySelectorAll("Companion");
      for (let l = 0; l < s.length; l++)
        if (s[l].hasChildNodes()) {
          const h = this.getCreativeViewTrackers(
            s[l],
            "Tracking[event=creativeView]"
          );
          let A = new Eo(
            "Companion",
            h,
            s[l]
          );
          i[r].hasCompanionResources = A.resources.length > 0, i[r].required = e[r].getAttribute("required"), i[r].variations.push(A);
        }
    }
    return i.reverse();
  }
  /**
   * @returns {Object} Object with tracker arrays for all specified tracking events
   */
  /** @internal */
  getTrackers(e) {
    const i = {}, r = Array.from(this.adXML.querySelectorAll("ClickTracking, " + e));
    for (let s = 0; s < r.length; s++) {
      const l = r[s], h = l.nodeName.charAt(0).toLowerCase() + l.nodeName.slice(1), A = l.getAttribute("event") || h, g = l.getAttribute("offset"), S = {
        offset: "",
        url: z.trim(l.textContent)
      };
      if (A === qt.ON_AD_PROGRESS && g) {
        const L = z.convertTimeStringToSeconds(g);
        S.offset = typeof L == "number" ? L.toString() : g;
      }
      i[A] = i[A] || [], i[A].push(S);
    }
    return i;
  }
}
class yo extends c {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(), this.adXML = e, this.rawXML = i instanceof Document ? i.documentElement : i, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((i, r) => {
      const s = Number(Object.keys(i));
      return Number(Object.keys(r)) - s;
    }).map((i) => Object.values(i)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let i = 0, r = e.parentElement;
    for (; r; )
      i++, r = r.parentElement;
    return { [i]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    let e = [];
    const i = this.adXML.querySelectorAll("Ad > Wrapper");
    let r = [];
    return i.forEach((l) => {
      let h = l.querySelectorAll("Wrapper > Creatives > Creative");
      h.length > 0 ? h.forEach((A) => {
        r.push(A);
      }) : e.push(l);
    }), r.length > 0 && r.forEach((l) => {
      e.push(l);
    }), this.adXML.querySelectorAll("InLine > Creatives > Creative").forEach((l) => {
      e.push(l);
    }), e;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    this.wrappers.length > 0 ? e = this.getWrapperAndInLineCreative() : this.adXML.querySelectorAll("Creative").forEach((h) => {
      e.push(h);
    });
    let i = [];
    e.forEach((l) => {
      i.push(this.getNodeDepth(l));
    });
    const r = this.getElementsSortedByDepth(i);
    let s = [];
    return r.forEach((l) => {
      const h = l.getAttributeNames().find((A) => A.toLowerCase() === "adid");
      s.push(l.getAttribute(h) || null);
    }), s;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (z.getMostNestedElement(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = this.adXML.querySelector("InLine Advertiser");
    return z.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = this.adXML.querySelectorAll("AdVerifications > Verification");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      const s = e[r], l = s.getAttribute("vendor") || "", h = s.querySelector("JavaScriptResource"), A = this.getNodeContentsAsText(
        s.querySelector("VerificationParameters") || document.createElement("div")
      ), g = this.getTrackerNodesAsURLArray(
        s.querySelector("TrackingEvents") || document.createElement("div")
      );
      if (l && l.length > 0 && h) {
        const S = {
          javascriptResource: {
            url: z.trim(this.getNodeContentsAsText(h)),
            apiFramework: h.getAttribute("apiFramework") || "",
            browserOptional: h.getAttribute("browserOptional") === "true" || !1
          },
          tracking: g,
          vendor: l,
          verificationParameters: A
        };
        i.push(S);
      }
    }
    return i.length > 0 ? z.getUnique(i, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = z.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new So(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = this.adXML.querySelector("InLine Description");
    return z.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = z.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = z.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    this.wrappers.length > 0 && this.adXML.querySelectorAll("Ad > Wrapper").forEach((l) => {
      const h = l.parentElement.getAttribute("id");
      e.push(h);
    });
    let i = null, r = z.getMostNestedElement(this.adXML, "Ad");
    return r && r.hasAttribute("id") && (i = r.id), e.length > 0 ? (e.push(i), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    this.wrappers.length > 0 ? e = this.getWrapperAndInLineCreative() : this.adXML.querySelectorAll("Creative").forEach((h) => {
      e.push(h);
    });
    let i = [];
    e.forEach((l) => {
      i.push(this.getNodeDepth(l));
    });
    let r = [];
    return this.getElementsSortedByDepth(i).forEach((l) => {
      r.push(l.getAttribute("id") || null);
    }), r;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = this.adXML.querySelector("InLine AdServingId");
    return z.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = this.adXML.querySelector("InLine Pricing") || z.getMostNestedElement(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = this.adXML.querySelector("InLine Survey");
    return z.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = this.adXML.querySelector("InLine AdSystem");
    return z.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = this.adXML.querySelector("InLine AdTitle");
    return z.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(Ee(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(Ee(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: Ee(this.rawXML, "_loadEnd") - Ee(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const i = this.adXML.querySelectorAll("VASTAdTagURI");
    for (let r = 0; r < i.length; r++)
      e.push({
        loadStart: new Date(Ee(i[r], "_loadStart")).toISOString(),
        loadEnd: new Date(Ee(i[r], "_loadEnd")).toISOString(),
        loadTime: Ee(i[r], "_loadEnd") - Ee(i[r], "_loadStart"),
        url: z.trim(i[r].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = this.adXML.querySelectorAll("Creative UniversalAdId"), i = e[e.length - 1];
    return i ? this.extractUniversalAdIdInfo(i) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const i = this.adXML.querySelectorAll("Creative UniversalAdId");
    for (let r = 0; r < i.length; r++)
      e.push(this.extractUniversalAdIdInfo(i[r]));
    return e;
  }
  /**
   * Returns all VAST Extensions (no CreativeExtensions)
   *
   * @internal
   * @returns {Array} Extensions
   */
  /** @internal */
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const i = this.adXML.querySelectorAll("Extensions > Extension");
      for (let r = 0; r < i.length; r++)
        e.push({
          extensionXML: i[r],
          type: i[r].getAttribute("type")
        });
    }
    return e;
  }
  /** @internal */
  getNodeContentsAsText(e) {
    var i;
    return ((i = e == null ? void 0 : e.textContent) == null ? void 0 : i.trim()) || "";
  }
  /** @internal */
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || z.trim(
        e.getAttribute("idValue") || "unknown"
      )
    };
  }
  /**
   * Note: TrackingEvents moved to the creative level
   * @internal
   * @returns {Object} Object with tracker arrays for error, impression and viewableImpression
   */
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const i = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && i.push(this.adXML), i.forEach((r) => {
        const s = r.nodeName.charAt(0).toLowerCase() + r.nodeName.slice(1), l = this.getNodeContentsAsText(r);
        l && l.length > 0 && (e[s] = e[s] || [], e[s].push({
          url: l
        }));
      });
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} Object with tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const i = {};
    return e && Array.from(e.querySelectorAll("Tracking")).forEach((r) => {
      const s = this.getNodeContentsAsText(r), l = r.getAttribute("event");
      s && s.length > 0 && l !== null && (i[l] || (i[l] = []), i[l].push({
        url: s
      }));
    }), i;
  }
}
class Mt extends yo {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(e, i), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = this.adXML.querySelectorAll("Creative Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      z.getMostNestedElement(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  /** @internal */
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return fe.SPONSORED;
      default:
        return fe.COMMERCIAL;
    }
  }
  /** @internal */
  parseSkipOffsetToNumber() {
    var i;
    const e = z.convertTimeStringToSeconds(
      ((i = this.adXML.querySelector("InLine Linear")) == null ? void 0 : i.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  /**
   * @internal
   * @param {Node} variantElement - The XML node that has the variant information for this ad.
   * @returns {string} variant - The normalized name based on the `AD_VARIANT` name.
   */
  /** @internal */
  getVariant(e) {
    if (e === null)
      return fe.COMMERCIAL;
    let i = fe.COMMERCIAL;
    return e.nodeName === "AdInfo" && (i = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (i = this.mapStringToVariant(e.textContent.trim())), i;
  }
  /** @internal */
  getDuration() {
    var i, r;
    const e = ((r = (i = z.getMostNestedElement(this.adXML, "Linear Duration")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || Mt.FALLBACK_LINEAR_DURATION;
    return z.convertTimeStringToSeconds(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  /** @internal */
  getError() {
    function e(r) {
      if (r.parentNode)
        return r.parentNode.querySelector(":scope > parsererror");
    }
    const i = this.adXML.querySelector("parsererror") || e(this.adXML);
    return i ? {
      code: Ee(i, "code"),
      message: i.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  /** @internal */
  flagCappedAds() {
    return this.adXML.querySelector("InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: x.WRAPPER.NO_RESPONSE.code,
      message: x.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  /** @internal */
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", i = z.getMostNestedElement(this.adXML, e);
    return z.trim((i == null ? void 0 : i.textContent) || "");
  }
}
Mt.FALLBACK_LINEAR_DURATION = "00:00:20";
class Io {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  /**
   * Handles the provided XML document to extract and create Ad instances.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  /** @internal */
  handleXMLDoc(e) {
    let i = e.querySelector("parsererror"), r = e.querySelectorAll(":root > *"), s;
    if (!(e.querySelector("html") && i)) {
      if (e.querySelector("html")) {
        s = document.createElement("VAST");
        const l = new Mt(s, e);
        this.adList.push(l);
        return;
      }
      if (e instanceof DocumentFragment && i) {
        s = document.createElement("VAST"), s.appendChild(i);
        const l = new Mt(s, e);
        this.adList.push(l);
      }
      for (let l = 0; l < r.length; l++) {
        const h = new Mt(r[l], e);
        this.adList.push(h);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function Oo(p, e) {
  const i = Object.values(ai);
  let r = [];
  const s = document.createElement("video"), l = document.createElement("audio");
  let h = i;
  return e && e.length > 0 && (r = e, h = e), h.filter((g) => !("canPlayType" in s) || g === "application/javascript" || s.canPlayType(g) !== "" || l.canPlayType(g) !== "" ? r.push(g) : !1), (r.length <= 0 || r.length === 1 && r[0] === "application/javascript") && (r = h), p.filter((g) => r.find((S) => g.mimeType === S));
}
class ki {
  static getProperCreative(e, i) {
    if (!e || e.length < 1)
      return null;
    let r = e.slice(0);
    return e[0].type === he.NON_LINEAR ? Ro.select(r, i) : To.select(r, i);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, i = []) {
    return e.filter((r) => r.isVPAID ? this.isFriendlyVendorHost(r.fileURL, i) : !0);
  }
  static isFriendlyVendorHost(e, i = []) {
    return !i || i && i.length === 0 ? !0 : i.some((r) => {
      if (!r.includes("."))
        return !1;
      try {
        const s = new URL(e).hostname;
        return new RegExp(`(^|\\.)${r.replace(".", "\\.")}$`).test(s);
      } catch (s) {
        return !1;
      }
    });
  }
}
class To {
  static select(e, i) {
    return e.forEach((s) => {
      s.selectedCreativeFile = null, s.selectedMediaFile = null;
      let l = s.mediaFiles || [];
      l.map((A) => {
        var g;
        !s.selectedCreativeFile && A.apiFramework && (A.isSIMID = (A.apiFramework + "").toUpperCase() === "SIMID", s.selectedCreativeFile = A.isSIMID ? A : null), (g = s.selectedCreativeFile) != null && g.isSIMID && (A.isSIMID = !0), A.isVPAID = (A.apiFramework + "").toUpperCase() === "VPAID";
      }), l = ki.removeUnwantedVPAIDVendors(
        l,
        i.desiredVPAIDVendors
      );
      let h = Oo(l, i.desiredMimeTypes);
      s.selectedMediaFile = this.selectMediaFile(
        h,
        i.desiredBitrate || 1e3,
        i.desiredMimeTypes || []
      );
    }), e.filter((s) => !!s.selectedMediaFile).shift();
  }
  /**
   * @param {Array} mediaFileList represents all available MediaFiles from an ad.
   * @param {number} bitrate indicates the desired bitrate in kilobits per second (kbps).
   * @param {Array} desiredMimeTypes represents the favorite mediaFiles in a certain order.
   * @returns {Array} Revised mediaFileList with favored desiredMimeType.
   */
  /** @internal */
  static selectMediaFile(e, i, r) {
    let s = e.filter((A) => A.isSIMID), l = e.filter((A) => A.isVPAID);
    if (s.length > 0)
      return s[0];
    if (l.length > 0)
      return l[0];
    let h = [];
    for (let A = 0; A < r.length; ) {
      if (A > 0 && h.length > 0) {
        e = h;
        break;
      }
      e.filter((g) => {
        g.mimeType === r[A] && h.push(g);
      }), A++;
    }
    return this.selectMediaFileByBitrate(e, i);
  }
  // mediafile returned has smaller or same bitrate as requested one
  /** @internal */
  static selectMediaFileByBitrate(e, i) {
    let r = e.filter((l) => !l.isVPAID).sort((l, h) => h.bitrate - l.bitrate), s = r.filter((l) => l.bitrate <= i);
    return s.length > 0 ? s.shift() : r.pop() || e.shift();
  }
}
class Ro {
  static select(e, i) {
    return e.forEach((s) => {
      const l = s.variations;
      l.map((h) => {
        h.selectedResource = null, (h.apiFramework + "").toUpperCase() === "VPAID" && (h.isVPAID = !0, h.resources = h.resources.filter((A) => ki.isFriendlyVendorHost(
          A.resource,
          i.desiredVPAIDVendors
        )));
      }), l.forEach((h) => {
        h.resources.length <= 0 ? h.hasCreative = !1 : h.selectedResource = h.resources[0];
      }), s.variations = l.filter((h) => !!h.selectedResource);
    }), e.filter((s) => s.variations.length > 0).shift();
  }
}
const Vn = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function No(p, e, i, r) {
  let s = p;
  const l = i, h = r, A = e, g = {
    DIVIDER: fe.DIVIDER,
    CLOSER: fe.CLOSER,
    OPENER: fe.OPENER
  };
  function S(de) {
    let ge = [], Y = {
      adParameters: null,
      creativeTrackers: {},
      duration: Mt.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: he.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let N in de)
      if (Object.prototype.hasOwnProperty.call(de, N) && Object.prototype.hasOwnProperty.call(Vn, N.toUpperCase())) {
        let O = de[N];
        if (typeof O == "string" && O.length > 0) {
          let b = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: O,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: Vn[N.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          Y.mediaFiles.push(b);
        }
      }
    return Y.supportedMediaFiles = Y.mediaFiles, ge.push(Y), ge;
  }
  function L() {
    Object.keys(g).forEach((de) => {
      if (l && Object.prototype.hasOwnProperty.call(l, g[de])) {
        const ge = l[g[de]];
        if (!A && !ge.forcePlay)
          return;
        let Y = {};
        Y.adTrackers = [], Y.creatives = S(ge), Y.id = Y.adId = g[de], Y.isLinear = !0, Y.variant = g[de], Y.properCreative = Y.creatives[0], Y.properCreative.selectedMediaFile = Y.properCreative.supportedMediaFiles[0], Y.config = h, Y.enrichment = new St(), Y.adReinsertion = new ce(h.adReinsertion, Y.enrichment), Y.expectedAdType = l.type, Y.isPaused = !0;
        let N = [];
        switch (g[de]) {
          case g.DIVIDER:
            if (s.forEach((O, b) => {
              b > 0 && O.variant !== s[b - 1].variant && N.push({
                offset: b,
                ad: Y
              });
            }), l[g[de]].forcePlay && N.length === 0) {
              s[0].variant === fe.SPONSORED ? s.unshift(Y) : s.push(Y);
              break;
            }
            N.forEach((O, b) => {
              const G = O.offset + b;
              s.splice(G, 0, O.ad);
            });
            break;
          case g.CLOSER:
            s.push(Y);
            break;
          case g.OPENER:
            s.unshift(Y);
            break;
        }
      }
    });
  }
  let Q = {
    totalCommercials: 0,
    totalClips: 0,
    totalPlayableClips: 0,
    totalPlayableCommercials: 0
  };
  function te() {
    let de = 0, ge = 0, Y = 0;
    const N = s.length;
    s.forEach((O, b) => {
      O.variant === fe.COMMERCIAL ? (O.currentCommercial = ge += 1, (O.fallbackOnNoAd || !O.fallbackOnNoAd) && O.hasError && (de += 1), O.currentPodSequencing = ge - de) : (O.fallbackOnNoAd || !O.fallbackOnNoAd) && O.hasError && (Y += 1), O.variant !== fe.COMMERCIAL && (O.currentCommercial = -1), O.sequence = b + 1, O.currentClip = b + 1;
    }), Q = {
      totalClips: N,
      totalPlayableClips: N - de - Y,
      totalCommercials: ge,
      totalPlayableCommercials: ge - de
    };
  }
  return L(), te(), { enrichedManifest: s, sequenceData: Q };
}
function kn(p) {
  let e = p;
  for (let i = 0; i < e.length; i++) {
    let s = e[i].extensions;
    s == null || s.forEach((l) => {
      typeof l.extensionXML == "string" && (l.extensionXML = new DOMParser().parseFromString(l.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
    });
  }
  return e;
}
class Co {
  constructor(e, i, r, s) {
    this.adBreak = s, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = i, this.environmentVars = r, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), kn(this.adSlotModelList), this.adSlotBuffetList = kn(this.adSlotBuffetList), c.debug.info(this.NAME + "adPod", this.adSlotModelList), c.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  /** @internal */
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((i) => i).sort(this.bySequence).reverse();
      for (let i = e.length - 1; i >= 0; i--) {
        const r = e[i];
        if (r.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let s = this.adSlotBuffetList.shift();
          s.sequence = r.sequence + 0.1, this.adSlotModelList.splice(r.sequence - 1, 0, s);
        }
      }
    }
  }
  /** @internal */
  decorateAdList() {
    this.adList.forEach((e) => {
      if (e.adBreakPosition = this.adBreak.adBreakPosition, e.config = this.config, e.enrichment = new St(), e.enrichment.setFromObject(e.publisherMacros), e.expectedAdType = this.adBreak.type, e.publisherMacros = this.environmentVars.vastMacros, e.adReinsertion = new ce(e.config.adReinsertion, e.enrichment), e.isPaused = !0, !e.hasError) {
        if (e.creatives.length < 1) {
          e.error = {}, e.error = x.WRAPPER.NO_RESPONSE;
          return;
        }
        if (e.expectedAdType === he.LINEAR && e.creativeClass.linearAsArray[0].mediaFiles.length === 0 || e.expectedAdType === he.NON_LINEAR && e.creativeClass.nonLinear.length === 0) {
          e.error = {}, e.error = x.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          return;
        }
        e.expectedAdType === he.LINEAR ? (e.properCreative = ki.getProperCreative(
          e.creativeClass.linearAsArray,
          this.environmentVars
        ), e.properCreative && (e.closedCaptions = e.properCreative.captions, e.icons = e.properCreative.icons)) : e.properCreative = ki.getProperCreative(
          e.creativeClass.nonLinear,
          this.environmentVars
        ), e.properCreative || (e.error = {}, e.error = x.VAST.UNSUPPORTED_MIMETYPE);
      }
    });
  }
  /** @internal */
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = []);
  }
  /** @internal */
  extendWithSeparationClips() {
    if (this.adBreak.type !== he.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: i
    } = No(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = i;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  /** @internal */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError || i.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && e.adXML.querySelector(`ParserError[code="${x.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  /** @internal */
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  /** @internal */
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const i = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, r = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return i || r;
    });
  }
  // sort ads by ascending sequence number
  /** @internal */
  bySequence(e, i) {
    return e.sequence - i.sequence;
  }
}
const Dr = class Dr {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, i) {
    this.callbackOnDoneLoading = i, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, i) {
    this.callbackOnDoneLoading = i, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((r) => (this.saveInitialURLToTag(e, r), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), r), this.requestXML(r)));
  }
  /* c8 ignore stop */
  /** @internal */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let i = this.XMLDoc.querySelectorAll("VASTAdTagURI");
      if (this.XMLsToLoad = i.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let r = 0; r < this.XMLsToLoad; r++) {
        let l = (i[r].textContent || "").trim();
        this.walkDownAdWrappers(
          l,
          0,
          i[r].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((h) => {
          e(h);
        });
      }
    }
  }
  /** @internal */
  walkDownAdWrappers(e, i, r, s) {
    return new Promise((l, h) => {
      let A = r.querySelector("VASTAdTagURI");
      if (A.setAttribute("_loadStart", Date.now().toString()), A.setAttribute("_loadEnd", Date.now().toString()), Date.now() - s > this.wrapperChainTimeout)
        return Xe(r, x.WRAPPER.CHAIN_TIMEOUT), h(), e;
      if (i >= this.maxWrapperDepth)
        return Xe(
          r,
          x.WRAPPER.LIMIT_REACHED
        ), h(), e;
      if (this.isInsecureURL(e))
        return Xe(r, x.SESSION.MIXED_CONTENT), h(), e;
      if (this.hasSessionTimeoutError)
        return h(), e;
      let g, S;
      this.loadURL(e, !0).then((L) => {
        let Q = L.querySelector("VASTAdTagURI");
        g = ((Q || {}).textContent || "").trim(), g && (S = Q.parentNode), this.addContentToWrapperNode(r, L), A.setAttribute("_loadEnd", Date.now().toString()), l([g, S]);
      });
    }).then((l) => {
      let [h, A] = l;
      return h ? this.walkDownAdWrappers(h, i + 1, A, s) : e;
    });
  }
  /** @internal */
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  /** @internal */
  loadURL(e, i = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = i, new Promise((r) => {
      new Rr().get(e, (s, l) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let h = l || document.createDocumentFragment(), A = h.querySelector("Ad") || h.documentElement || h;
          this.hasSessionTimeoutError = !0, Xe(A, x.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: ce.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && l.querySelector("parsererror")) {
          let h = document.createDocumentFragment();
          Xe(h, x.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: ce.REASON.XML_PARSING_ERROR,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && l.documentElement.nodeName.toUpperCase() === "VAST") {
          const h = l.querySelector("VAST");
          if (h && h.querySelectorAll(":scope > *").length === 0) {
            let A = document.createDocumentFragment();
            Xe(A, x.WRAPPER.NO_RESPONSE), r(A);
          }
        }
        if (s && !l) {
          let h = document.createDocumentFragment();
          c.debug.warn(
            this.NAME + " XHR Request Error",
            s.code,
            s.description
          ), Xe(h, s), r(h);
        } else
          r(l);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  /** @internal */
  isInsecureURL(e) {
    return this.blockInsecureURL && !qn(e);
  }
  /* c8 ignore stop */
  /** @internal */
  setAttributeToTag(e, i, r) {
    if (r) {
      let s = r.querySelector("VAST");
      s && s.setAttribute(e, i);
    }
  }
  /** @internal */
  saveInitialURLToTag(e, i) {
    this.setAttributeToTag("_initialURL", e, i);
  }
  /** @internal */
  saveInitialTimestampToTag(e, i, r) {
    this.setAttributeToTag("_loadStart", e, r), this.setAttributeToTag("_loadEnd", i, r);
  }
  /** @internal */
  addContentToWrapperNode(e, i) {
    let r = document.createElement("_VASTAdTagURIContent");
    r.appendChild(i.firstElementChild), e.appendChild(r);
  }
};
Dr.EVENT = {
  PARSED: "AdTagService::parsed"
};
let yr = Dr;
class Fn {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function i(h, A) {
      const g = e[h];
      return !g || g.length <= 0 ? (c.debug.info(A), []) : g;
    }
    const r = (h, A) => {
      const g = e.creatives;
      if (g && g.length !== 0) {
        const S = g.find(
          (L) => L.type === h
        );
        if (S && S.variations && S.variations.length > 0)
          return S.variations;
      }
      return c.debug.info(A), [];
    };
    function s(h) {
      return h.charAt(0).toUpperCase() + h.slice(1);
    }
    const l = (h) => {
      var g, S;
      if (e.isLinear) {
        const L = e.properCreative && e.properCreative.selectedMediaFile;
        return L ? L[h] : -1;
      }
      const A = (S = (g = e.creativesArray) == null ? void 0 : g.nonLinearCreative[0]) == null ? void 0 : S.variations[0];
      if (A && e.isExpanded) {
        const L = `expanded${s(h)}`;
        return A[L] === -1 ? A[h] : A[L];
      }
      return A ? A[h] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return i("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return i("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return r(li.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function h(g, S) {
          return S === 0 || !g.parentElement ? g : h(g.parentElement, S - 1);
        }
        function A(g) {
          const S = h(g, 3), L = S.getAttributeNames().find((Q) => Q.toLowerCase() === "adid");
          return {
            adId: S.getAttribute(L) || null,
            id: S.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let g = null;
          if (e.isSIMID ? g = "InteractiveCreativeFile" : e.isVPAID ? g = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (g = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), g) {
            const S = e.adXML.querySelector(g);
            return A(S);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const g = e.properCreative.variations[0].selectedResource.type, S = e.properCreative.variations[0].selectedResource.creativeType, L = e.adXML.querySelector(
            `${g}[creativeType="${S}"]`
          );
          return A(L);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (c.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return i("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== "IFrameResource";
        } catch (h) {
          return !1;
        }
      },
      get height() {
        return l("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (c.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const h = e.properCreative;
        return h && h.length !== 0 ? h : (c.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return r(li.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Nulll is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return i("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(h) {
        e.volume = h;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return l("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return i("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class _o {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, i) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return i.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return i.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return i.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return i.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class Yn {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, i, r) {
    this.consentAPI = e, this.callback = i, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = r, this.NAME = "TCFAPI::", c.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, i) {
    this.consentAPI(e, this.version, (r) => {
      this.onConsentData(r, i);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, i) {
    this.consentDataInfo = e[i], this.gdprAppliesBoolean = e.gdprApplies, c.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class Do extends Yn {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class Lo extends Yn {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class bo {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const i = window.top;
      i && (this.tcfAPI = i.__tcfapi, this.cmpAPI = i.__cmp);
    } catch (i) {
      c.debug.warn(`${this.NAME}Ctor No window?`, i);
    }
    this.hasTCF() ? this.api = new Lo(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new Do(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : c.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    c.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function Cr(p) {
  if (typeof p != "object" || p === null)
    return p;
  const e = /* @__PURE__ */ Object.create(null);
  for (const i of Object.keys(p)) {
    const r = p[i];
    Hn(r) || (e[i] = Cr(p[i]));
  }
  return e;
}
function Mo(p) {
  const e = document.implementation.createDocument(null, "VAST", null);
  return e.documentElement.setAttribute("version", "3.0"), p.forEach((i) => {
    const r = e.createElement("Ad"), s = e.createElement("Wrapper"), l = e.createElement("VASTAdTagURI");
    l.appendChild(e.createTextNode(i)), s.appendChild(l), r.appendChild(s), e.documentElement.appendChild(r);
  }), e;
}
function Po(p) {
  let e = p;
  if (e.originConfig = Cr(p), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let i = e.urls[0];
    e.urls = [];
    for (let r = 0; r < e.repeat; r++)
      e.urls.push(i.replace("[count]", (r + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = Mo(e.urls)), e.requested = !1, e;
}
const Un = "AdBreakValidation";
function wo(p) {
  var s, l;
  if (!p || typeof p != "object" || Array.isArray(p) || Object.keys(p).length === 0)
    return c.debug.warn(Un + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof p.tag == "string" || Array.isArray(p.tag)) && p.tag.length > 0, i = ((l = (s = p.response) == null ? void 0 : s.length) != null ? l : 0) > 0, r = p[fe.CLOSER] || p[fe.DIVIDER] || p[fe.OPENER];
  return !e && !i && !r ? (c.debug.warn(Un + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function xo(p, e, i, r, s) {
  var l = l || {};
  (function(h) {
    var A = {
      globalConfig: p,
      clientConfig: e,
      clientAPIs: i,
      utilsReady: r,
      onFailure: s
    };
    (function() {
      function g(N) {
        N = [(typeof globalThis == "undefined" ? "undefined" : J(globalThis)) == "object" && globalThis, N, (typeof window == "undefined" ? "undefined" : J(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : J(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : J(global)) == "object" && global];
        for (var O = 0; O < N.length; ++O) {
          var b = N[O];
          if (b && b.Math == Math) return b;
        }
        throw Error("Cannot find global object");
      }
      var S = g(this);
      function L(N) {
        var O = 0;
        return function() {
          return O < N.length ? {
            done: !1,
            value: N[O++]
          } : {
            done: !0
          };
        };
      }
      var Q = typeof Object.defineProperties == "function" ? Object.defineProperty : function(N, O, b) {
        return N == Array.prototype || N == Object.prototype || (N[O] = b.value), N;
      };
      function te(N, O) {
        if (O) e: {
          var b = S;
          N = N.split(".");
          for (var G = 0; G < N.length - 1; G++) {
            var K = N[G];
            if (!(K in b)) break e;
            b = b[K];
          }
          N = N[N.length - 1], G = b[N], O = O(G), O != G && O != null && Q(b, N, {
            configurable: !0,
            writable: !0,
            value: O
          });
        }
      }
      te("Symbol", function(N) {
        function O(K) {
          if (this instanceof O) throw new TypeError("Symbol is not a constructor");
          return new b("jscomp_symbol_" + (K || "") + "_" + G++, K);
        }
        function b(K, Z) {
          this.j = K, Q(this, "description", {
            configurable: !0,
            writable: !0,
            value: Z
          });
        }
        if (N) return N;
        b.prototype.toString = function() {
          return this.j;
        };
        var G = 0;
        return O;
      }), te("Symbol.iterator", function(N) {
        if (N) return N;
        N = Symbol("Symbol.iterator");
        for (var O = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), b = 0; b < O.length; b++) {
          var G = S[O[b]];
          typeof G == "function" && typeof G.prototype[N] != "function" && Q(G.prototype, N, {
            configurable: !0,
            writable: !0,
            value: function() {
              return de(L(this));
            }
          });
        }
        return N;
      });
      function de(N) {
        return N = {
          next: N
        }, N[Symbol.iterator] = function() {
          return this;
        }, N;
      }
      function ge(N) {
        var O = typeof Symbol != "undefined" && Symbol.iterator && N[Symbol.iterator];
        return O ? O.call(N) : {
          next: L(N)
        };
      }
      function Y(N, O) {
        return Object.prototype.hasOwnProperty.call(N, O);
      }
      te("WeakMap", function(N) {
        function O(R) {
          if (this.h = (D += Math.random() + 1).toString(), R) {
            R = ge(R);
            for (var w; !(w = R.next()).done; ) w = w.value, this.set(w[0], w[1]);
          }
        }
        function b() {
        }
        function G(R) {
          var w = J(R);
          return w === "object" && R !== null || w === "function";
        }
        function K(R) {
          if (!Y(R, F)) {
            var w = new b();
            Q(R, F, {
              value: w
            });
          }
        }
        function Z(R) {
          var w = Object[R];
          w && (Object[R] = function($) {
            return $ instanceof b ? $ : (Object.isExtensible($) && K($), w($));
          });
        }
        if (function() {
          if (!N || !Object.seal) return !1;
          try {
            var R = Object.seal({}), w = Object.seal({}), $ = new N([[R, 2], [w, 3]]);
            return $.get(R) != 2 || $.get(w) != 3 ? !1 : ($.delete(R), $.set(w, 4), !$.has(R) && $.get(w) == 4);
          } catch (ee) {
            return !1;
          }
        }()) return N;
        var F = "$jscomp_hidden_" + Math.random();
        Z("freeze"), Z("preventExtensions"), Z("seal");
        var D = 0;
        return O.prototype.set = function(R, w) {
          if (!G(R)) throw Error("Invalid WeakMap key");
          if (K(R), !Y(R, F)) throw Error("WeakMap key fail: " + R);
          return R[F][this.h] = w, this;
        }, O.prototype.get = function(R) {
          return G(R) && Y(R, F) ? R[F][this.h] : void 0;
        }, O.prototype.has = function(R) {
          return G(R) && Y(R, F) && Y(R[F], this.h);
        }, O.prototype.delete = function(R) {
          return G(R) && Y(R, F) && Y(R[F], this.h) ? delete R[F][this.h] : !1;
        }, O;
      }), te("Map", function(N) {
        function O() {
          var D = {};
          return D.c = D.next = D.head = D;
        }
        function b(D, R) {
          var w = D.b;
          return de(function() {
            if (w) {
              for (; w.head != D.b; ) w = w.c;
              for (; w.next != w.head; ) return w = w.next, {
                done: !1,
                value: R(w)
              };
              w = null;
            }
            return {
              done: !0,
              value: void 0
            };
          });
        }
        function G(D, R) {
          var w = R && J(R);
          w == "object" || w == "function" ? Z.has(R) ? w = Z.get(R) : (w = "" + ++F, Z.set(R, w)) : w = "p_" + R;
          var $ = D.g[w];
          if ($ && Y(D.g, w)) for (D = 0; D < $.length; D++) {
            var ee = $[D];
            if (R !== R && ee.key !== ee.key || R === ee.key) return {
              id: w,
              list: $,
              index: D,
              a: ee
            };
          }
          return {
            id: w,
            list: $,
            index: -1,
            a: void 0
          };
        }
        function K(D) {
          if (this.g = {}, this.b = O(), this.size = 0, D) {
            D = ge(D);
            for (var R; !(R = D.next()).done; ) R = R.value, this.set(R[0], R[1]);
          }
        }
        if (function() {
          if (!N || typeof N != "function" || !N.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var D = Object.seal({
              x: 4
            }), R = new N(ge([[D, "s"]]));
            if (R.get(D) != "s" || R.size != 1 || R.get({
              x: 4
            }) || R.set({
              x: 4
            }, "t") != R || R.size != 2) return !1;
            var w = R.entries(), $ = w.next();
            return $.done || $.value[0] != D || $.value[1] != "s" ? !1 : ($ = w.next(), !($.done || $.value[0].x != 4 || $.value[1] != "t" || !w.next().done));
          } catch (ee) {
            return !1;
          }
        }()) return N;
        var Z = /* @__PURE__ */ new WeakMap();
        K.prototype.set = function(D, R) {
          D = D === 0 ? 0 : D;
          var w = G(this, D);
          return w.list || (w.list = this.g[w.id] = []), w.a ? w.a.value = R : (w.a = {
            next: this.b,
            c: this.b.c,
            head: this.b,
            key: D,
            value: R
          }, w.list.push(w.a), this.b.c.next = w.a, this.b.c = w.a, this.size++), this;
        }, K.prototype.delete = function(D) {
          return D = G(this, D), D.a && D.list ? (D.list.splice(D.index, 1), D.list.length || delete this.g[D.id], D.a.c.next = D.a.next, D.a.next.c = D.a.c, D.a.head = null, this.size--, !0) : !1;
        }, K.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = O(), this.size = 0;
        }, K.prototype.has = function(D) {
          return !!G(this, D).a;
        }, K.prototype.get = function(D) {
          return (D = G(this, D).a) && D.value;
        }, K.prototype.entries = function() {
          return b(this, function(D) {
            return [D.key, D.value];
          });
        }, K.prototype.keys = function() {
          return b(this, function(D) {
            return D.key;
          });
        }, K.prototype.values = function() {
          return b(this, function(D) {
            return D.value;
          });
        }, K.prototype.forEach = function(D, R) {
          for (var w = this.entries(), $; !($ = w.next()).done; ) $ = $.value, D.call(R, $[1], $[0], this);
        }, K.prototype[Symbol.iterator] = K.prototype.entries;
        var F = 0;
        return K;
      }), te("Object.is", function(N) {
        return N || function(O, b) {
          return O === b ? O !== 0 || 1 / O === 1 / b : O !== O && b !== b;
        };
      }), te("Array.prototype.includes", function(N) {
        return N || function(O, b) {
          var G = this;
          G instanceof String && (G = String(G));
          var K = G.length;
          for (b = b || 0, 0 > b && (b = Math.max(b + K, 0)); b < K; b++) {
            var Z = G[b];
            if (Z === O || Object.is(Z, O)) return !0;
          }
          return !1;
        };
      }), te("String.prototype.includes", function(N) {
        return N || function(O, b) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (O instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(O, b || 0) !== -1;
        };
      }), te("Array.from", function(N) {
        return N || function(O, b, G) {
          b = b != null ? b : function(D) {
            return D;
          };
          var K = [], Z = typeof Symbol != "undefined" && Symbol.iterator && O[Symbol.iterator];
          if (typeof Z == "function") {
            O = Z.call(O);
            for (var F = 0; !(Z = O.next()).done; ) K.push(b.call(G, Z.value, F++));
          } else for (Z = O.length, F = 0; F < Z; F++) K.push(b.call(G, O[F], F));
          return K;
        };
      }), function() {
        function N() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function O() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function b(F) {
          return F == "True" || F == "true" || F == 1 || F == "1" || F == 1;
        }
        function G() {
          var F = function() {
            var $ = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), ee = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), Ce = $.slice(0, $.length / 2).split("").reverse().join("");
            return $ = $.slice($.length / 2).split("").reverse().join(""), ee + Ce + ee + $ + ee;
          }(), D = function($) {
            var ee = 0, Ce;
            if ($.length == 0) return ee;
            var _e = 0;
            for (Ce = $.length; _e < Ce; _e++) ee = (ee << 5) - ee + $.charCodeAt(_e), ee |= 0;
            return Math.abs(ee);
          }(F).toString();
          D = (D + D.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), F = btoa(F).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var R = "", w = 0; w < D.length; w++) R += F.charAt(D[w]);
          return R || "zork";
        }
        function K(F, D) {
          return F = Math.round(Math.abs(F)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, F);
        }
        N.prototype.getItem = function(F) {
          return this.i[F] || this.client[F] || this.f[F];
        }, N.prototype.l = function(F) {
          this.f = F.embed, this.global = F.global, this.client = F.client, this.i = F.customer;
        };
        var Z = null;
        Z = new N(), function(F) {
          function D(V, B, W) {
            var me = {
              homad_url_prefix_alias: "",
              homad_track_key: "*" + encodeURIComponent(V) + "*",
              homad_track_value: "*" + encodeURIComponent(B.toString()) + "*"
            }, oe = W ? null : function() {
              D(V, B, !0);
            };
            W = W ? R(!0) : w(), je(W, null, oe, me);
          }
          function R(V) {
            return V = V ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + V.slice(V.length - 2).join(".") + "/[hash]/").replace("[hash]", O(K()));
          }
          function w() {
            if (Oe && Oe.server) {
              var V = Oe.server[Math.floor(Math.random() * Oe.server.length)] + "";
              return V.replace("[hash]", O(K()));
            }
            return R(!1);
          }
          function $() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(B) {
              try {
                B.pause();
              } catch (W) {
              }
              B.parentNode.removeChild(B);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(B) {
              B.parentNode.removeChild(B);
            }), window.self != window.top) for (var V = window.document; V.hasChildNodes(); ) V.removeChild(V.lastChild);
            qe.get("setTimeout")($, Math.round(1e3 + 100 * Math.random()));
          }
          function ee(V) {
            return Be && clearTimeout(Be), D("stats_embed_penalty", V), $(), !1;
          }
          function Ce() {
            Ve && Ve.enabled === !1 || Oe && Oe.enabled === !1 || De && De.enabled === !1 ? clearTimeout(Be) : ee("load_main");
          }
          function _e() {
            je(De.src.toString(), function(V) {
              De.src.toString() === V.responseURL ? (V = Qe(V.responseText), De.data = V, De.enabled = b(V.enabled), Ce()) : ee("redirect_customer");
            }, function() {
              De.data = {}, De.enabled = void 0, Ce();
            });
          }
          function ht() {
            var V = Oe.src;
            typeof V == "string" ? je(V.toString(), function(B) {
              V.toString() === B.responseURL ? (B = Qe(B.responseText), Oe.data = B, Oe.enabled = b(B.enabled), De.src = B.config, _e()) : ee("redirect_client");
            }, function() {
              Oe.data = {}, Oe.enabled = void 0, _e();
            }) : (Oe.data = typeof V == "function" ? V() : V, _e());
          }
          function Pt() {
            je(Ve.src.toString(), function(V) {
              Ve.src.toString() === V.responseURL ? (V = Qe(V.responseText), Ve.data = V, Ve.enabled = b(V.enabled), ht()) : ee("redirect_global");
            }, function() {
              Ve.data = {}, Ve.enabled = void 0, ht();
            });
          }
          function Ye(V) {
            clearTimeout(Be);
            var B = new V();
            B.init(Z.f.globalConfig, Z.f.clientConfig, !0, function() {
              Z.f.utilsReady(B);
            }, function() {
              ee("utils_init");
            }, Z.f);
          }
          function at(V) {
            var B = pt.shift();
            B ? !window[G()] || V ? It(B) : V || clearTimeout(Be) : Pt();
          }
          function je(V, B, W, me) {
            me = me === void 0 ? null : me;
            var oe = new XMLHttpRequest();
            if (oe.onreadystatechange = function() {
              B && oe.readyState == 4 && oe.status == 200 && B(oe), W && oe.readyState == 4 && oe.status != 200 && W(oe);
            }, me) {
              var ft = "", Ot;
              for (Ot in me) ft += "&" + Ot + "=" + encodeURIComponent(me[Ot]);
              ft = ft.substr(1), oe.open("POST", V, !0), oe.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), oe.send(ft);
            } else oe.open("GET", V, !0), oe.send();
          }
          function It(V) {
            var B = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("script") : qe.get("createElement")("script"), W;
            if (B.setAttribute("data-info", lt), B.src = V, B.onload = function(oe) {
              oe.currentTarget.getAttribute("id") === G() ? ct() ? (oe = W[lt.split("").reverse().join("")], Ye(oe)) : clearTimeout(Be) : pt.length ? at(!0) : ee("main_redirect");
            }, B.onerror = function() {
              at(!0);
            }, window[G()] || (window[G()] = K(5 + Math.round(5 * Math.random()))), ct()) {
              var me = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("iframe") : qe.get("createElement")("iframe");
              if (!me || me.nodeName.toLowerCase() !== "iframe" || !me.nodeType) return ee("utils_iframe");
              me.style.display = "none", me.onload = function() {
                if (W = me.contentWindow, W[lt] = F, me.contentWindow.document.body.appendChild(B) !== B) return ee("utils_script");
              }, document.body.appendChild(me);
            } else document.head.appendChild(B);
          }
          function Qe(V) {
            var B = qe.get("JSON");
            try {
              var W = B.parse(V);
            } catch (me) {
              W = {};
            }
            return W;
          }
          function ct() {
            return Z.f.utilsReady != null;
          }
          var lt = K(10 + Math.round(10 * Math.random()));
          window[lt] = F, Z = new N(), Z.l({
            embed: F
          }), Z.f.version = "20230601_1407";
          var Be = 0, wt = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], ve = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], pt = ct() ? ve : wt, Ve = {
            src: F.globalConfig,
            enabled: void 0,
            data: null
          }, Oe = {
            src: F.clientConfig,
            enabled: void 0,
            data: null
          }, De = {
            src: null,
            enabled: void 0,
            data: null
          }, qe = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var V = document.createElement("iframe");
              V.style.display = "none", document.body.appendChild(V);
              var B = V.contentWindow;
            } else document.head ? (V = document.createElement("iframe"), V.style.display = "none", document.head.appendChild(V), B = V.contentWindow) : B = window;
            qe.set("JSON", B.JSON), qe.set("createElement", B.document.createElement.bind(document)), qe.set("setTimeout", B.setTimeout.bind(window)), V && V.parentNode && V.parentNode.removeChild(V);
          })(), function() {
            Be = qe.get("setTimeout")(function() {
              ee("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), at();
        }(A);
      }();
    })();
  }).bind(l)(l);
}
let be = null, Pe = null;
const ue = class ue extends yt {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, i) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: he.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = be = i, this.environmentVars = {}, this.error = null, this.initialURLHandler = i.urlhandler ? i.urlhandler : ut, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(f.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = ce.EventDispatcher.addEventListener(
      f.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = be.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  /** @internal */
  initializeHOMAD(e) {
    const i = new St();
    i.setFromObject(this.environmentVars.vastMacros), i.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(ai)), Pe = new ce(this.config.adReinsertion, i);
    let r = (l) => {
      c.debug.info(ue.NAME + "initializeHOMAD - Utils ready.", l), c.debug.info(ue.NAME + "initializeHOMAD - Set vendor API.", l), Pe.setVendorAPI(l), Pe.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), Pe.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = l;
    }, s = (l) => {
      c.debug.warn(ue.NAME + "initializeHOMAD Penalty"), r = () => {
      }, Pe.vendorAPI ? (c.debug.warn("initializeHOMAD - Penalty during ad playback."), rt.call(this, x.SESSION.AD_REINSERTION_PENALTY)) : (c.debug.warn("initializeHOMAD - Error.", l), rt.call(this, x.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(f.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const l = e.adReinsertion.homad.setup;
      xo(
        l.globalConfig,
        l.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (h) => {
          r(h);
        },
        (h) => {
          s(h);
        }
      );
    }
  }
  /** @internal */
  forceHOMADActivation() {
    this.error && this.error.code === x.SETUP.AD_REINSERTION_PENALTY.code || (Pe.setReinsertionReason({
      reason: ce.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), Pe.enable(
      () => {
        c.debug.info(
          ue.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(f.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        c.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, i = {}) {
    this.adBreak = e, this.environmentVars = i, this.error = null;
    let r = null;
    return this.rejectSlotChanges ? (rt.call(this, x.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : wo(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = Xt(be.timeouts, i.timeouts), this.environmentVars.omidServiceWindow = i.omidServiceWindow || this.config.adVerification.serviceWindow, c.debug.info(ue.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((s, l) => {
      this.adBreak.type || (this.adBreak.type = he.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === he.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === he.NON_LINEAR && !this.environmentVars.adContainer && c.debug.warn(ue.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, r = super.addEventListener(f.ON_AD_MANIFEST_LOAD_ERROR, () => (c.debug.info(ue.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), l(this.error))), super.addEventListener(f.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), r && r(), this.rejectSlotChanges = !1, s("ok")));
      const h = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        c.debug.info(
          ue.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), rt.call(this, x.SESSION.TIMEOUT), this.dispatchEvent(f.ON_AD_MANIFEST_LOAD_ERROR);
      }, h * 1e3), this.parse(this.adBreak);
    })) : (rt.call(this, x.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, i) {
    let r = "HOMADUtils.corroborate - ", s = "Utils not ready.";
    return new Promise((l, h) => {
      if (!be.adReinsertion.homad.utils)
        throw c.debug.info(r + s), new Error(r + s);
      be.adReinsertion.homad.utils.corroborate(i).then(() => {
        c.debug.info(r + "resolved."), l();
      }).catch((A) => {
        c.debug.info(r + "rejected.", A), h(A);
      });
    });
  }
  /** @internal */
  onAdReinsertionActivation(e) {
    return new Promise((i, r) => {
      if (!be.adReinsertion.homad.setup.activationCallback)
        return i();
      let s = be.adReinsertion.homad.setup.activationCallback.bind(this), l = !1, h = setTimeout(() => (l = !0, i()), ce.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), A = "onAdReinsertionActivation ";
      try {
        s(e).then(() => {
          if (clearTimeout(h), c.debug.info(A + "approved."), !l)
            return i();
        }, (g) => {
          if (clearTimeout(h), c.debug.warn(A + "declined.", typeof g), g && g.stack && g.message)
            return Pe.disable(), i();
          if (!l)
            return Pe.disable(), r();
        });
      } catch (g) {
        return clearTimeout(h), c.debug.warn(A + "failed. Error in activationCallback:", g), l = !0, Pe.disable(), i();
      }
    });
  }
  /** @internal */
  setupEnrichmentAndTCF() {
    const e = new St();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(ai)), this.environmentVars.vastMacros.GDPRCONSENT || new bo(e), e;
  }
  /** @internal */
  restartAdSlot() {
    c.debug.info(ue.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), be.urlhandler = Vi, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : c.debug.warn(ue.NAME + "What to do next?");
    }).catch((e) => {
      c.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  /** @internal */
  parse(e) {
    const i = Po(e);
    c.debug.info(ue.NAME + "parse - Start parsing the ad slot", i);
    const r = this.setupEnrichmentAndTCF();
    Pe = new ce(this.config.adReinsertion, r);
    let s = JSON.parse(JSON.stringify(be.timeouts));
    const l = {
      adReinsertion: Pe,
      blockInsecureURL: be.blockInsecureURL,
      enrichment: r,
      maxWrapperDepth: be.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: i.response ? i.responseXML : null,
      timeouts: s,
      urlhandler: be.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: Xt({}, s),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let h = null, A = this.adBreak;
    if (typeof i == "object" && (A = i), A.urls.length === 1 && (h = A.urls[0], l.response = null), h || l.response) {
      let g = new yr(l);
      h ? g.requestURL(A.urls[0], this.onXMLLoadDone.bind(this, l)) : g.requestFinalXML(l.response, this.onXMLLoadDone.bind(this, l));
    } else
      c.debug.warn(
        ue.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], l);
  }
  /** @internal */
  onXMLLoadDone(e, i) {
    this.rawXMLDocument = i, this.rawAdSlotModel = new Io(i), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  /** @internal */
  handleParserResponse(e, i) {
    let r = i || {};
    if (!i) {
      let A = si;
      r.adReinsertion = new ce(A.adReinsertion, new St()), r.timeouts = A.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let s = new Co(
      e,
      be,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = s.adSlotModel, this.adSlotBuffet = s.adSlotBuffet, this.sequenceData = s.sequenceData;
    const l = s.hasSessionTimeoutError, h = () => {
      if (!s.hasValidAds || l) {
        rt.call(this, l ? x.SESSION.TIMEOUT : x.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(f.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new Er(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(f.ON_AD_MANIFEST_LOADED);
    };
    if (r.adReinsertion.reinsertionReason && !r.adReinsertion.isActive) {
      c.debug.info(
        ue.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        r.adReinsertion.reinsertionReason
      ), r.adReinsertion.enable(
        () => {
          r.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (A) => {
          c.debug.info(
            ue.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            A
          ), h();
        }
      );
      return;
    }
    h();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      c.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      c.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      c.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === he.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(f.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(f.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const i = Sr;
      this.slot = new i(this.currentAd, this.player, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(f.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const r = (s) => {
        this.dispatchEvent(s.type);
      };
      Object.values(f).forEach((s) => {
        this.slot.addEventListener(s, r), this.slot.adSlotController.addEventListener(s, r);
      }), this.slot.deliverNextAd();
    };
    this.adBreak.type === he.LINEAR ? (c.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((i) => {
      c.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      c.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  /** @internal */
  resetErrorWarning() {
    const e = [
      x.WARNING.TRACKER_LOAD_FAILED.code,
      x.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let i = 0; i < this.adSlotModelList.length; i++)
      e.indexOf(this.adSlotModelList[i].error.code) !== -1 && (this.adSlotModelList[i].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === he.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((i) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(ue.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(f.ON_AD_SLOT_COMPLETE), i())), this.slot.stop().then(() => {
        e();
      }, (r) => {
        c.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", r), e();
      });
    });
  }
  /** @internal */
  resetContent() {
    c.debug.info(ue.NAME + "Reset content.");
    let e = {
      code: x.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, i = !1, r = this.player.restoreContentState.bind(this.player), l = setTimeout(() => {
      i = !0, c.debug.error(ue.NAME + "resetContent - timeout"), rt.call(this, e), this.dispatchEvent(f.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    r().then(() => {
      i || (clearTimeout(l), c.debug.info(ue.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (h) => {
      i || (clearTimeout(l), c.debug.error(
        ue.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        h
      ), e.message = "SessionError: Reset content failed.", rt.call(this, e), this.dispatchEvent(f.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  /** @internal */
  closeAdSlot() {
    Pe && be.adReinsertion.homad.setup.enableSessionCoverage !== !0 && (Pe.disable(), be.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(ue.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, i) {
    this.slot && this.slot.adSlotController.onResizeAd(e, i);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  clickThrough(e = !1) {
    if (this.slot)
      try {
        if (new Fn(this.slot.adSlotController.currentAd.hasClickThrough))
          return this.slot.adSlotController.onClickThrough(e);
      } catch (i) {
      }
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, i = !1) {
    if (this.slot)
      return this.dispatchEvent(f.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, i);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {number} reason The reason code corresponding to the cause of the failure.
   */
  /** @internal */
  verificationNotExecuted(e, i) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, i);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    i && (this.dispatchEvent(f.ON_COMPANION_CREATIVE_VIEW), i.creativeViewTracker.length > 0 && (c.debug.table("Request companion creativeView trackers.", i.creativeViewTracker), this.slot.adSlotController.callTrackers(i.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, i = !0) {
    if (!this.slot)
      return;
    const r = this.ad.companions.filter((s) => s.id === e).shift();
    if (r) {
      this.dispatchEvent(f.ON_COMPANION_CLICKED), r.clickTracker.length > 0 && (c.debug.table("Request companion click trackers.", r.clickTracker), this.slot.adSlotController.callTrackers(r.clickTracker));
      let s = r.clickThroughURL;
      if (s) {
        let l = this.slot.currentAd.enrichment.apply(s);
        if (!i) {
          const h = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(l, h);
        }
        return l;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot.play();
  }
  dispatchEvent(e) {
    return c.debug.info(ue.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI | object} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new Fn(this.adSlotController.currentAd) : (c.debug.warn("There is no loaded ad."), {});
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot | object } Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new _o(this.adSlotController, this.sequenceData) : (c.debug.warn("There is no loaded ad."), {});
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return Wn.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
ue.NAME = "AdSAPI::", ue.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let Ir = ue;
const Wt = class Wt {
  constructor(e, i) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = i;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (c.debug.info(Wt.NAME + "AdSlotAPI ready"), this.adSlotAPI = new Ir(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (c.debug.info(Wt.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (c.debug.info(Wt.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new pr(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
Wt.NAME = "MainCtlr::";
let Or = Wt;
var Gn = /* @__PURE__ */ ((p) => (p.XHR = "xhr", p.JSONP = "jsonp", p))(Gn || {});
function Vo() {
  var p = window;
  (function(e) {
    var i;
    function r(t) {
      var n = 0;
      return function() {
        return n < t.length ? {
          done: !1,
          value: t[n++]
        } : {
          done: !0
        };
      };
    }
    function s(t) {
      var n = typeof Symbol != "undefined" && Symbol.iterator && t[Symbol.iterator];
      if (n) return n.call(t);
      if (typeof t.length == "number") return {
        next: r(t)
      };
      throw Error(String(t) + " is not an iterable or ArrayLike");
    }
    function l(t) {
      if (!(t instanceof Array)) {
        t = s(t);
        for (var n, o = []; !(n = t.next()).done; ) o.push(n.value);
        t = o;
      }
      return t;
    }
    var h = typeof Object.create == "function" ? Object.create : function(t) {
      function n() {
      }
      return n.prototype = t, new n();
    }, A = typeof Object.defineProperties == "function" ? Object.defineProperty : function(t, n, o) {
      return t == Array.prototype || t == Object.prototype || (t[n] = o.value), t;
    };
    function g(t) {
      t = [(typeof globalThis == "undefined" ? "undefined" : J(globalThis)) == "object" && globalThis, t, (typeof window == "undefined" ? "undefined" : J(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : J(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : J(global)) == "object" && global];
      for (var n = 0; n < t.length; ++n) {
        var o = t[n];
        if (o && o.Math == Math) return o;
      }
      throw Error("Cannot find global object");
    }
    var S = g(this);
    function L(t, n) {
      if (n) e: {
        var o = S;
        t = t.split(".");
        for (var d = 0; d < t.length - 1; d++) {
          var m = t[d];
          if (!(m in o)) break e;
          o = o[m];
        }
        t = t[t.length - 1], d = o[t], n = n(d), n != d && n != null && A(o, t, {
          configurable: !0,
          writable: !0,
          value: n
        });
      }
    }
    var Q;
    if (typeof Object.setPrototypeOf == "function") Q = Object.setPrototypeOf;
    else {
      var te;
      e: {
        var de = {
          a: !0
        }, ge = {};
        try {
          ge.__proto__ = de, te = ge.a;
          break e;
        } catch (t) {
        }
        te = !1;
      }
      Q = te ? function(t, n) {
        if (t.__proto__ = n, t.__proto__ !== n) throw new TypeError(t + " is not extensible");
        return t;
      } : null;
    }
    var Y = Q;
    function N(t, n) {
      if (t.prototype = h(n.prototype), t.prototype.constructor = t, Y) Y(t, n);
      else for (var o in n) if (o != "prototype") if (Object.defineProperties) {
        var d = Object.getOwnPropertyDescriptor(n, o);
        d && Object.defineProperty(t, o, d);
      } else t[o] = n[o];
      t.wa = n.prototype;
    }
    function O() {
      for (var t = Number(this), n = [], o = t; o < arguments.length; o++) n[o - t] = arguments[o];
      return n;
    }
    function b(t, n) {
      return Object.prototype.hasOwnProperty.call(t, n);
    }
    var G = typeof Object.assign == "function" ? Object.assign : function(t, n) {
      for (var o = 1; o < arguments.length; o++) {
        var d = arguments[o];
        if (d) for (var m in d) b(d, m) && (t[m] = d[m]);
      }
      return t;
    };
    L("Object.assign", function(t) {
      return t || G;
    }), L("Symbol", function(t) {
      function n(v) {
        if (this instanceof n) throw new TypeError("Symbol is not a constructor");
        return new o(d + (v || "") + "_" + m++, v);
      }
      function o(v, T) {
        this.g = v, A(this, "description", {
          configurable: !0,
          writable: !0,
          value: T
        });
      }
      if (t) return t;
      o.prototype.toString = function() {
        return this.g;
      };
      var d = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", m = 0;
      return n;
    }), L("Symbol.iterator", function(t) {
      if (t) return t;
      t = Symbol("Symbol.iterator");
      for (var n = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), o = 0; o < n.length; o++) {
        var d = S[n[o]];
        typeof d == "function" && typeof d.prototype[t] != "function" && A(d.prototype, t, {
          configurable: !0,
          writable: !0,
          value: function() {
            return K(r(this));
          }
        });
      }
      return t;
    });
    function K(t) {
      return t = {
        next: t
      }, t[Symbol.iterator] = function() {
        return this;
      }, t;
    }
    L("WeakMap", function(t) {
      function n(_) {
        if (this.g = (I += Math.random() + 1).toString(), _) {
          _ = s(_);
          for (var P; !(P = _.next()).done; ) P = P.value, this.set(P[0], P[1]);
        }
      }
      function o() {
      }
      function d(_) {
        var P = J(_);
        return P === "object" && _ !== null || P === "function";
      }
      function m(_) {
        if (!b(_, T)) {
          var P = new o();
          A(_, T, {
            value: P
          });
        }
      }
      function v(_) {
        var P = Object[_];
        P && (Object[_] = function(q) {
          return q instanceof o ? q : (Object.isExtensible(q) && m(q), P(q));
        });
      }
      if (function() {
        if (!t || !Object.seal) return !1;
        try {
          var _ = Object.seal({}), P = Object.seal({}), q = new t([[_, 2], [P, 3]]);
          return q.get(_) != 2 || q.get(P) != 3 ? !1 : (q.delete(_), q.set(P, 4), !q.has(_) && q.get(P) == 4);
        } catch (Ae) {
          return !1;
        }
      }()) return t;
      var T = "$jscomp_hidden_" + Math.random();
      v("freeze"), v("preventExtensions"), v("seal");
      var I = 0;
      return n.prototype.set = function(_, P) {
        if (!d(_)) throw Error("Invalid WeakMap key");
        if (m(_), !b(_, T)) throw Error("WeakMap key fail: " + _);
        return _[T][this.g] = P, this;
      }, n.prototype.get = function(_) {
        return d(_) && b(_, T) ? _[T][this.g] : void 0;
      }, n.prototype.has = function(_) {
        return d(_) && b(_, T) && b(_[T], this.g);
      }, n.prototype.delete = function(_) {
        return d(_) && b(_, T) && b(_[T], this.g) ? delete _[T][this.g] : !1;
      }, n;
    }), L("Map", function(t) {
      function n() {
        var I = {};
        return I.L = I.next = I.head = I;
      }
      function o(I, _) {
        var P = I.g;
        return K(function() {
          if (P) {
            for (; P.head != I.g; ) P = P.L;
            for (; P.next != P.head; ) return P = P.next, {
              done: !1,
              value: _(P)
            };
            P = null;
          }
          return {
            done: !0,
            value: void 0
          };
        });
      }
      function d(I, _) {
        var P = _ && J(_);
        P == "object" || P == "function" ? v.has(_) ? P = v.get(_) : (P = "" + ++T, v.set(_, P)) : P = "p_" + _;
        var q = I.h[P];
        if (q && b(I.h, P)) for (I = 0; I < q.length; I++) {
          var Ae = q[I];
          if (_ !== _ && Ae.key !== Ae.key || _ === Ae.key) return {
            id: P,
            list: q,
            index: I,
            A: Ae
          };
        }
        return {
          id: P,
          list: q,
          index: -1,
          A: void 0
        };
      }
      function m(I) {
        if (this.h = {}, this.g = n(), this.size = 0, I) {
          I = s(I);
          for (var _; !(_ = I.next()).done; ) _ = _.value, this.set(_[0], _[1]);
        }
      }
      if (function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var I = Object.seal({
            x: 4
          }), _ = new t(s([[I, "s"]]));
          if (_.get(I) != "s" || _.size != 1 || _.get({
            x: 4
          }) || _.set({
            x: 4
          }, "t") != _ || _.size != 2) return !1;
          var P = _.entries(), q = P.next();
          return q.done || q.value[0] != I || q.value[1] != "s" ? !1 : (q = P.next(), !(q.done || q.value[0].x != 4 || q.value[1] != "t" || !P.next().done));
        } catch (Ae) {
          return !1;
        }
      }()) return t;
      var v = /* @__PURE__ */ new WeakMap();
      m.prototype.set = function(I, _) {
        I = I === 0 ? 0 : I;
        var P = d(this, I);
        return P.list || (P.list = this.h[P.id] = []), P.A ? P.A.value = _ : (P.A = {
          next: this.g,
          L: this.g.L,
          head: this.g,
          key: I,
          value: _
        }, P.list.push(P.A), this.g.L.next = P.A, this.g.L = P.A, this.size++), this;
      }, m.prototype.delete = function(I) {
        return I = d(this, I), I.A && I.list ? (I.list.splice(I.index, 1), I.list.length || delete this.h[I.id], I.A.L.next = I.A.next, I.A.next.L = I.A.L, I.A.head = null, this.size--, !0) : !1;
      }, m.prototype.clear = function() {
        this.h = {}, this.g = this.g.L = n(), this.size = 0;
      }, m.prototype.has = function(I) {
        return !!d(this, I).A;
      }, m.prototype.get = function(I) {
        return (I = d(this, I).A) && I.value;
      }, m.prototype.entries = function() {
        return o(this, function(I) {
          return [I.key, I.value];
        });
      }, m.prototype.keys = function() {
        return o(this, function(I) {
          return I.key;
        });
      }, m.prototype.values = function() {
        return o(this, function(I) {
          return I.value;
        });
      }, m.prototype.forEach = function(I, _) {
        for (var P = this.entries(), q; !(q = P.next()).done; ) q = q.value, I.call(_, q[1], q[0], this);
      }, m.prototype[Symbol.iterator] = m.prototype.entries;
      var T = 0;
      return m;
    }), L("Object.values", function(t) {
      return t || function(n) {
        var o = [], d;
        for (d in n) b(n, d) && o.push(n[d]);
        return o;
      };
    });
    function Z(t, n) {
      t instanceof String && (t += "");
      var o = 0, d = !1, m = {
        next: function() {
          if (!d && o < t.length) {
            var T = o++;
            return {
              value: n(T, t[T]),
              done: !1
            };
          }
          return d = !0, {
            done: !0,
            value: void 0
          };
        }
      };
      return m[Symbol.iterator] = function() {
        return m;
      }, m;
    }
    L("Array.prototype.keys", function(t) {
      return t || function() {
        return Z(this, function(n) {
          return n;
        });
      };
    }), L("Set", function(t) {
      function n(o) {
        if (this.g = /* @__PURE__ */ new Map(), o) {
          o = s(o);
          for (var d; !(d = o.next()).done; ) this.add(d.value);
        }
        this.size = this.g.size;
      }
      return function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var o = Object.seal({
            x: 4
          }), d = new t(s([o]));
          if (!d.has(o) || d.size != 1 || d.add(o) != d || d.size != 1 || d.add({
            x: 4
          }) != d || d.size != 2) return !1;
          var m = d.entries(), v = m.next();
          return v.done || v.value[0] != o || v.value[1] != o ? !1 : (v = m.next(), v.done || v.value[0] == o || v.value[0].x != 4 || v.value[1] != v.value[0] ? !1 : m.next().done);
        } catch (T) {
          return !1;
        }
      }() ? t : (n.prototype.add = function(o) {
        return o = o === 0 ? 0 : o, this.g.set(o, o), this.size = this.g.size, this;
      }, n.prototype.delete = function(o) {
        return o = this.g.delete(o), this.size = this.g.size, o;
      }, n.prototype.clear = function() {
        this.g.clear(), this.size = 0;
      }, n.prototype.has = function(o) {
        return this.g.has(o);
      }, n.prototype.entries = function() {
        return this.g.entries();
      }, n.prototype.values = function() {
        return this.g.values();
      }, n.prototype.keys = n.prototype.values, n.prototype[Symbol.iterator] = n.prototype.values, n.prototype.forEach = function(o, d) {
        var m = this;
        this.g.forEach(function(v) {
          return o.call(d, v, v, m);
        });
      }, n);
    }), L("Object.is", function(t) {
      return t || function(n, o) {
        return n === o ? n !== 0 || 1 / n === 1 / o : n !== n && o !== o;
      };
    }), L("Array.prototype.includes", function(t) {
      return t || function(n, o) {
        var d = this;
        d instanceof String && (d = String(d));
        var m = d.length;
        for (o = o || 0, 0 > o && (o = Math.max(o + m, 0)); o < m; o++) {
          var v = d[o];
          if (v === n || Object.is(v, n)) return !0;
        }
        return !1;
      };
    }), L("String.prototype.includes", function(t) {
      return t || function(n, o) {
        if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
        if (n instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
        return this.indexOf(n, o || 0) !== -1;
      };
    }), L("Array.prototype.values", function(t) {
      return t || function() {
        return Z(this, function(n, o) {
          return o;
        });
      };
    });
    var F = {
      na: "loaded",
      ta: "start",
      ka: "firstQuartile",
      oa: "midpoint",
      ua: "thirdQuartile",
      ia: "complete",
      pa: "pause",
      ra: "resume",
      ha: "bufferStart",
      ga: "bufferFinish",
      sa: "skipped",
      va: "volumeChange",
      qa: "playerStateChange",
      fa: "adUserInteraction"
    }, D = {
      la: "full",
      ja: "domain",
      ma: "limited"
    };
    function R(t, n) {
      this.x = t.x != null ? t.x : t.left, this.y = t.y != null ? t.y : t.top, this.width = t.width, this.height = t.height, this.J = this.x + this.width, this.K = this.y + this.height, this.H = t.H || void 0, this.V = t.V || [], this.h = t.friendlyObstructionClass || void 0, this.i = t.friendlyObstructionPurpose || void 0, this.j = t.friendlyObstructionReason || void 0, this.P = t.P !== void 0 ? t.P === !0 : !0, this.m = t.hasWindowFocus !== void 0 ? t.hasWindowFocus === !0 : !0, this.D = t.D || void 0, this.aa = t.aa || void 0, this.W = t.W === "true" || t.W === !0 || !1, this.N = t.N || [], this.R = t.R || !1, this.g = n;
    }
    function w(t) {
      var n = {};
      return n.width = t.width, n.height = t.height, n;
    }
    function $(t) {
      var n = {};
      return ye({}, w(t), (n.x = t.x, n.y = t.y, n));
    }
    function ee(t) {
      var n = $(t), o = {};
      return ye({}, n, (o.endX = t.J, o.endY = t.K, o));
    }
    R.prototype.T = function(t) {
      if (t == null) return !1;
      t = $(t);
      var n = t.y, o = t.width, d = t.height;
      return this.x === t.x && this.y === n && this.width === o && this.height === d;
    };
    function Ce(t) {
      return t.width * t.height;
    }
    function _e(t) {
      return t.width === 0 || t.height === 0;
    }
    function ht(t, n) {
      t = $(t);
      for (var o = [], d = [], m = 0; m < n.length; m++) {
        var v = $(n[m]);
        v = Pt(t, v), Ye(o, v.x), Ye(o, v.J), Ye(d, v.y), Ye(d, v.K);
      }
      return o = o.sort(function(T, I) {
        return T - I;
      }), d = d.sort(function(T, I) {
        return T - I;
      }), {
        da: o,
        ea: d
      };
    }
    function Pt(t, n) {
      return {
        x: Math.max(t.x, n.x),
        y: Math.max(t.y, n.y),
        J: Math.min(t.x + t.width, n.x + n.width),
        K: Math.min(t.y + t.height, n.y + n.height)
      };
    }
    function Ye(t, n) {
      t.indexOf(n) === -1 && t.push(n);
    }
    function at() {
      this.h = this.g = this.i = this.l = void 0, this.u = 0, this.o = [], this.v = [], this.B = 0, this.s = [], this.j = [], this.m = [];
    }
    at.prototype.T = function(t) {
      return t == null ? !1 : JSON.stringify(je(this)) === JSON.stringify(je(t));
    };
    function je(t) {
      var n = [], o = [], d = {
        viewport: t.l,
        adView: {
          percentageInView: t.u,
          pixelsInView: t.B,
          reasons: t.m
        },
        declaredFriendlyObstructions: t.o.length
      };
      if (t.g !== void 0) {
        d.adView.geometry = $(t.g), d.adView.geometry.pixels = Ce(t.g), d.adView.onScreenGeometry = $(t.h), d.adView.onScreenGeometry.pixels = pt(t);
        for (var m = 0; m < t.j.length; m++) n.push($(t.j[m]));
        for (m = 0; m < t.v.length; m++) {
          var v = t.v[m], T = v, I = {};
          T.h && (I.obstructionClass = T.h), T.i && (I.obstructionPurpose = T.i), T.j && (I.obstructionReason = T.j), v = Pt(t.g, v), o.push(ye({}, {
            x: v.x,
            y: v.y,
            width: v.J - v.x,
            height: v.K - v.y
          }, I));
        }
        d.adView.onScreenGeometry.obstructions = n, d.adView.onScreenGeometry.friendlyObstructions = o;
      }
      return d;
    }
    function It(t, n) {
      n = w(n), t.l = {}, t.l.width = n.width, t.l.height = n.height, t.i = {}, t.i.x = 0, t.i.y = 0, t.i.width = n.width, t.i.height = n.height, t.i.endX = n.width, t.i.endY = n.height;
    }
    function Qe() {
      return {
        x: 0,
        y: 0,
        endX: 0,
        endY: 0,
        width: 0,
        height: 0
      };
    }
    function ct(t, n) {
      var o = {};
      return o.x = Math.max(t.x, n.x), o.y = Math.max(t.y, n.y), o.endX = Math.min(t.endX, n.endX), o.endY = Math.min(t.endY, n.endY), o.width = Math.max(0, o.endX - o.x), o.height = Math.max(0, o.endY - o.y), o;
    }
    function lt(t, n) {
      return 0.01 < n.width - t.width || 0.01 < n.height - t.height;
    }
    function Be(t) {
      if (t.m.indexOf("backgrounded") !== -1) t.u = 0, t.B = 0;
      else {
        var n = Ce(t.g);
        if (n !== 0) {
          var o = pt(t);
          t.u = Math.round(o / n * 100), t.B = o;
        }
      }
    }
    function wt(t, n) {
      if (_e(n) || !t.h) n = !1;
      else {
        var o = ee(t.h), d = o.y, m = o.endX;
        t = o.endY;
        var v = n.J;
        o = o.x, (v = v < o || 0.01 > Math.abs(v - o)) || (v = n.x, v = v > m || 0.01 > Math.abs(v - m)), (m = v) || (m = n.K, m = m < d || 0.01 > Math.abs(m - d)), (d = m) || (n = n.y, d = n > t || 0.01 > Math.abs(n - t)), n = !d;
      }
      return n;
    }
    function ve(t, n) {
      for (var o = !1, d = 0; d < t.m.length; d++) t.m[d] === n && (o = !0);
      o || t.m.push(n);
    }
    function pt(t) {
      var n = Math, o = n.max, d = Ce(t.h), m = t.j, v = 0;
      if (0 < m.length) {
        var T = ht(t.h, m);
        t = T.da, T = T.ea;
        for (var I = 0; I < t.length - 1; I++) for (var _ = (t[I] + (t[I] + 1)) / 2, P = t[I + 1] - t[I], q = 0; q < T.length - 1; q++) {
          for (var Ae = (T[q] + (T[q] + 1)) / 2, tt = T[q + 1] - T[q], dt = !1, Nt = 0; Nt < m.length; Nt++) {
            var Fe = $(m[Nt]);
            if (Fe.x < _ && Fe.x + Fe.width > _ && Fe.y < Ae && Fe.y + Fe.height > Ae) {
              dt = !0;
              break;
            }
          }
          dt && (v += Math.round(P) * Math.round(tt));
        }
      }
      return o.call(n, 0, d - v);
    }
    function Ve() {
    }
    function Oe() {
    }
    function De(t, n, o, d) {
      var m = n.R ? !0 : n.H === d;
      if (m) {
        o.g = n;
        var v = ee(o.g);
        t = ct(o.i, v);
        var T = o.g;
        T.D === "notAttached" || T.D === "noWindowFocus" || T.D === "noAdView" ? (ve(o, "notFound"), o.h = new R(Qe(), !1)) : (T = o.g, T.D === "viewInvisible" || T.D === "viewGone" || T.D === "viewNotVisible" || T.D === "viewAlphaZero" || T.D === "viewHidden" || o.g.D !== void 0 || _e(o.g) ? (ve(o, "hidden"), o.h = new R(Qe(), !1)) : (o.g.W && ve(o, "pictureInPicture"), o.g.m || (ve(o, "backgrounded"), ve(o, "noWindowFocus")), lt(t, v) && ve(o, "clipped"), o.h = new R(t, !1)));
      } else if (v = !0, n.g && (v = n.V.indexOf(d) !== -1 ? !1 : n.P === !1), v) {
        T = n.N;
        for (var I = 0; I < T.length; I++) v = o.g !== void 0, De(t, new R(T[I], v), o, d);
      }
      m || o.g === void 0 || (n.g ? n.V.indexOf(d) !== -1 ? o.o.push(n) : o.s.push(n) : (m = ee(n), d = ee(o.h), $(o.h), !_e(o.h) && n.P && (n = ct(d, m), lt(n, d) && (ve(o, "clipped"), o.h = new R(n, !1)))));
    }
    function qe() {
      this.g = /* @__PURE__ */ new Map(), this.h = null;
    }
    function V() {
      return B || (B = new qe()), B;
    }
    var B = null;
    function W(t, n) {
      this.y = this.x = 0, this.width = t, this.height = n;
    }
    function me() {
      this.H = null, this.i = {
        apiVersion: "1.0",
        accessMode: "limited",
        environment: "web",
        omidJsInfo: {
          omidImplementer: "omsdk",
          serviceVersion: "1.5.6-iab144"
        },
        adSessionType: "html",
        supports: ["clid", "vlid"]
      }, this.C = null, this.B = "foregrounded", this.s = this.j = "none", this.o = this.l = this.m = this.G = this.h = this.g = this.M = this.v = null, this.u = /* @__PURE__ */ new Map();
    }
    var oe = function() {
      if (typeof e != "undefined" && e) return e;
      if (typeof global != "undefined" && global) return global;
      if (typeof window != "undefined" && window) return window;
      if (typeof globalThis != "undefined" && globalThis) return globalThis;
      var t = Function("return this")();
      if (t) return t;
      throw Error("Could not determine global object context.");
    }();
    function ft(t) {
      if (t === oe) return !1;
      try {
        if (typeof t.location.hostname == "undefined") return !0;
      } catch (n) {
        return !0;
      }
      return !1;
    }
    function Ot() {
      var t = e;
      if (t == null || typeof t.top == "undefined" || t.top == null) return null;
      try {
        var n = t.top;
        return ft(n) ? null : n.location.href;
      } catch (o) {
        return null;
      }
    }
    function di(t, n) {
      this.g = t, this.h = n;
    }
    S.Object.defineProperties(di.prototype, {
      event: {
        configurable: !0,
        enumerable: !0,
        get: function() {
          return this.g;
        }
      },
      origin: {
        configurable: !0,
        enumerable: !0,
        get: function() {
          return this.h;
        }
      }
    });
    function He() {
      var t = O.apply(0, arguments);
      ie(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(l(t))))();
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function ui() {
      var t = O.apply(0, arguments);
      ie(function() {
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function ie(t, n) {
      typeof jasmine != "undefined" && jasmine ? t() : typeof console != "undefined" && console && console.error && n();
    }
    function Yt(t) {
      this.g = t, this.m = [], this.i = [], this.j = [], this.l = [], this.o = {};
    }
    function Gt(t, n) {
      if (t.g !== void 0 && t.g.H && ci(t, n) !== !1) {
        var o = n.event;
        t.j.filter(function(d) {
          return d.type === o.type;
        }).forEach(function(d) {
          t.h(d.I, o);
        });
      }
    }
    function Se(t, n) {
      t.m.push(n), Gt(t, n);
    }
    function hi(t, n, o) {
      t.g !== void 0 && t.g.H && t.m.filter(function(d) {
        return d.event.type === n && ci(t, d);
      }).map(function(d) {
        return d.event;
      }).forEach(function(d) {
        t.h(o.I, d);
      });
    }
    function ci(t, n) {
      var o = n.event.type, d = Object.values(F).indexOf(o) !== -1 && o !== "volumeChange";
      return o === "impression" || o === "loaded" && t.g.h ? n.origin === t.g.s : d ? n.origin === t.g.j : !0;
    }
    function ke(t, n, o) {
      Object.keys(F).forEach(function(d) {
        d = F[d];
        var m = {
          type: d,
          U: o,
          I: n
        };
        t.j.push(m), hi(t, d, m);
      });
    }
    function pi(t, n, o, d) {
      var m = {
        ba: o,
        U: d,
        I: n
      };
      t.l.push(m), t.i.forEach(function(v) {
        var T = j(v);
        v.event.type === "sessionStart" && u(t, T, m), t.h(m.I, T);
      });
    }
    function xt(t, n, o) {
      var d = U(t, "sessionError", "native", {
        errorType: n,
        message: o
      });
      t.i.push(d), t.l.forEach(function(m) {
        t.h(m.I, d.event);
      });
    }
    function a(t, n) {
      if (t.o = ye(t.o, n), n = t.g.i, n !== void 0) {
        n = ye({}, H(Je(t, M(t, {
          context: n
        }), !0)), {
          supportsLoadedEvent: !!t.g.h || t.g.g == "video"
        }), ye(n, {
          pageUrl: Ot(),
          contentUrl: t.g.C
        });
        var o = U(t, "sessionStart", "native", n);
        t.i.push(o), t.l.forEach(function(d) {
          var m = j(o);
          u(t, m, d), t.h(d.I, m);
        }, t), y(t);
      }
    }
    function u(t, n, o) {
      o.ba && (n.data.verificationParameters = t.o[o.ba]), o.U && (o = t.g.u.get(o.U)) && (n.data.verificationParameters = o.verificationParameters, n.data.context.accessMode = o.accessMode, o.accessMode === "full" && (t.g.l && (n.data.context.videoElement = t.g.l), t.g.m && (n.data.context.slotElement = t.g.m)));
    }
    function E(t) {
      var n = U(t, "sessionFinish", "native");
      t.i.push(n), t.l.forEach(function(o) {
        t.h(o.I, n.event);
      });
    }
    Yt.prototype.h = function(t) {
      var n = O.apply(1, arguments);
      try {
        t.apply(null, l(n));
      } catch (o) {
        ui(o);
      }
    };
    function y(t) {
      var n = t.m.filter(function(v) {
        return Object.values(F).indexOf(v.event.type) !== -1 && t.g.g == "video" && v.origin === t.g.j || v.event.type == "loaded" && t.g.g == "display" && v.origin === t.g.s;
      }).map(function(v) {
        return v.event;
      }), o = t.g.H || "", d = {};
      n = s(n);
      for (var m = n.next(); !m.done; d = {
        F: d.F
      }, m = n.next()) {
        if (d.F = m.value, d.F.adSessionId || (d.F.adSessionId = o), d.F.type == "loaded") {
          if (!t.g.h && t.g.g == "display") continue;
          d.F.data = Je(t, M(t, d.F.data));
        }
        t.j.filter(/* @__PURE__ */ function(v) {
          return function(T) {
            return T.type === v.F.type;
          };
        }(d)).forEach(/* @__PURE__ */ function(v) {
          return function(T) {
            return T.I(v.F);
          };
        }(d));
      }
    }
    function C(t, n) {
      e: {
        n = new Set(n), t = s(t.m.concat(t.i));
        for (var o = t.next(); !o.done; o = t.next()) if (o = o.value, n.has(o.event.type) && o.origin != "javascript") {
          n = !0;
          break e;
        }
        n = !1;
      }
      return n ? (He("Event owner cannot be registered after its events have already been published."), !1) : !0;
    }
    function re(t) {
      var n = t.g.s;
      return n != "none" && n != "javascript" ? (He("Impression event is owned by " + (t.g.s + ", not javascript.")), !1) : !0;
    }
    function ne(t) {
      var n = t.g.j;
      return n != "none" && n != "javascript" ? (He("Media events are owned by " + (t.g.j + ", not javascript.")), !1) : !0;
    }
    function Je(t, n, o) {
      return o = o === void 0 ? !1 : o, n = ye({}, n), t.g.g && ye(n, {
        mediaType: t.g.g
      }), t.g.h && (o || t.g.h !== "definedByJavaScript") && ye(n, {
        creativeType: t.g.h
      }), n;
    }
    function H(t) {
      var n = V().h;
      return n ? ye({}, t, {
        lastActivity: n
      }) : t;
    }
    function M(t, n) {
      return t.g.G ? ye({}, n, {
        impressionType: t.g.G
      }) : n;
    }
    function U(t, n, o, d) {
      return new di({
        adSessionId: t.g.H || "",
        timestamp: (/* @__PURE__ */ new Date()).getTime(),
        type: n,
        data: d
      }, o);
    }
    function j(t) {
      t = t.event;
      var n = t.data ? ye({}, t.data) : void 0;
      return t.type === "sessionStart" && (n.context = ye({}, n.context)), {
        adSessionId: t.adSessionId,
        timestamp: t.timestamp,
        type: t.type,
        data: n
      };
    }
    function Ze(t, n, o) {
      n !== "start" && n !== "volumeChange" || (o && o.deviceVolume) != null || (o.deviceVolume = t.g.v);
    }
    function Tt(t, n, o) {
      if (o && (n === "start" || n === "volumeChange")) {
        n = o.videoPlayerVolume;
        var d = o.mediaPlayerVolume;
        n != null ? (ye(o, {
          mediaPlayerVolume: n
        }), t.g.M = n) : d != null && (ye(o, {
          videoPlayerVolume: d
        }), t.g.M = d);
      }
    }
    function Kn(t, n) {
      this.h = t, this.g = n;
    }
    function Ui() {
      var t;
      this.g = t = t === void 0 ? e : t;
    }
    Ui.prototype.setInterval = function(t, n) {
      return fi(this, "setInterval")(t, n);
    }, Ui.prototype.clearInterval = function(t) {
      fi(this, "clearInterval")(t);
    };
    function zn(t, n) {
      fi(t, "clearTimeout")(n);
    }
    function fi(t, n) {
      return t.g && t.g[n] ? t.g[n] : $i(t, n);
    }
    function Qn(t, n, o, d) {
      if (t.g.document && t.g.document.body) {
        var m = t.g.document.createElement("img");
        m.width = 1, m.height = 1, m.style.display = "none", m.src = n, o && m.addEventListener("load", function() {
          return o();
        }), d && m.addEventListener("error", function() {
          return d();
        }), t.g.document.body.appendChild(m);
      } else $i(t, "sendUrl")(n, o, d);
    }
    function $i(t, n) {
      if (t.g && t.g.omidNative && t.g.omidNative[n]) return t.g.omidNative[n].bind(t.g.omidNative);
      throw Error('Native interface method "' + n + '" not found.');
    }
    function br(t) {
      return !(!t || !t.tagName || t.tagName.toLowerCase() !== "iframe");
    }
    function et(t, n, o, d, m) {
      this.j = t, this.ca = n, this.X = o, this.i = d, this.$ = m, this.h = null, this.g = this.m = this.M = void 0, this.Z = !0, this.o = void 0, mi(this);
    }
    function mi(t) {
      if (!t.h) {
        var n;
        e: {
          if ((n = t.j.document) && n.getElementsByClassName && (n = n.getElementsByClassName("omid-element"))) {
            if (n.length == 1) {
              n = n[0];
              break e;
            }
            1 < n.length && t.Z && (xt(t.X, "generic", "More than one element with 'omid-element' class name."), t.Z = !1);
          }
          n = null;
        }
        if (n && n.tagName && n.tagName.toLowerCase() === "video") t.i.l = n;
        else if (n && n.tagName) t.i.m = n;
        else return;
        Ai(t);
      }
    }
    function Ai(t) {
      t.i.l ? (t.h = t.i.l, t.s()) : t.i.m && (t.h = t.i.m, br(t.h) ? t.i.o && t.s() : t.s());
    }
    function Kt(t) {
      t.g && (br(t.h) ? t.i.o && (t.S(), Mr(t)) : (t.S(), Mr(t)));
    }
    et.prototype.v = function() {
      this.o && (this.j.document.removeEventListener("visibilitychange", this.o), this.o = void 0);
    }, et.prototype.s = function() {
      var t = this;
      this.o || (this.o = function() {
        t.i.B = t.j.document.hidden ? "backgrounded" : "foregrounded", Kt(t);
      }, this.j.document.addEventListener("visibilitychange", this.o), this.o());
    };
    function Mr(t) {
      if (t.M) {
        t.i.S = t.M, t = t.ca;
        var n = t.g.S, o = t.g.O;
        if (n && !n.T(o)) {
          o = je(n);
          var d = t.h;
          d.g.h != "audio" && Se(d, U(d, "geometryChange", "native", o)), t.g.O = n;
        }
      }
    }
    function Pr(t) {
      if (t.g && t.i.o) {
        var n = new R(t.i.o, !1), o = t.g.x;
        return t = t.g.y, n.x += o, n.y += t, n.J += o, n.K += t, n.P = !0, n;
      }
    }
    function Vt(t, n, o, d, m, v) {
      et.call(this, t, o, d, m, v), this.u = n, this.l = void 0;
    }
    N(Vt, et), Vt.prototype.v = function() {
      this.l !== void 0 && (this.$.clearInterval(this.l), this.l = void 0), et.prototype.v.call(this);
    }, Vt.prototype.s = function() {
      var t = this;
      et.prototype.s.call(this), this.h == null ? this.l = void 0 : this.l === void 0 && (this.l = this.$.setInterval(function() {
        return wr(t);
      }, 200), wr(this));
    }, Vt.prototype.S = function() {
      if (this.m) {
        var t = Pr(this);
        if (t) {
          this.g.R = !1, t.R = !0;
          for (var n = !1, o = 0; o < this.g.N.length; o++) if (this.g.N[o].R) {
            this.g.N[o] = t, n = !0;
            break;
          }
          n || this.g.N.push(t);
        } else this.g.R = !0;
        n = this.u, o = this.i.B;
        var d = this.i.H, m = this.O();
        t = new at();
        var v = new R(this.m, !1);
        if (It(t, v), De(n, v, t, d), m)
          if (v.aa) ve(t, "backgrounded"), ve(t, "noOutputDevice");
          else if (o === "backgrounded") ve(t, "backgrounded");
          else if (t.g !== void 0) {
            for (n = 0; n < t.o.length; n++) wt(t, t.o[n]) && t.v.push(t.o[n]);
            for (n = 0; n < t.s.length; n++) {
              if (o = wt(t, t.s[n])) {
                e: {
                  for (o = t.s[n], d = 0; d < t.j.length; d++) if (t.j[d].T(o)) {
                    o = !0;
                    break e;
                  }
                  o = !1;
                }
                o = !o;
              }
              o && (ve(t, "obstructed"), t.j.push(t.s[n]));
            }
            Be(t);
          } else ve(t, "notFound");
        else t.m = ["unmeasurable"], t.l = void 0, t.u = 0, t.j = [], t.g && (n = t.g, o = {}, n = new R((o.x = 0, o.y = 0, o.width = n.width, o.height = n.height, o), n.g), t.g = n), t.h = Qe();
        this.M = t;
      }
    }, Vt.prototype.O = function() {
      return xr(this);
    };
    function wr(t) {
      if (t.l !== void 0) {
        if (xr(t)) {
          var n = t.j.top;
          n = new R(new W(n.innerWidth, n.innerHeight), !1);
        } else n = new R(new W(0, 0), !1);
        var o = t.h.getBoundingClientRect();
        (o.x == null || isNaN(o.x)) && (o.x = o.left), (o.y == null || isNaN(o.y)) && (o.y = o.top), o = new R(o, !1), n.T(t.m) && o.T(t.g) || (t.g = o, t.g.P = !0, t.m = n, t.m.N.push(t.g), Kt(t));
      }
    }
    function xr(t) {
      try {
        var n = t.j.top;
        return 0 <= n.innerHeight && 0 <= n.innerWidth;
      } catch (o) {
      }
      return !1;
    }
    function kt(t, n, o, d, m, v) {
      et.call(this, t, o, d, m, v), this.C = this.u = this.B = this.l = void 0, this.Y = !1, this.G = void 0;
    }
    N(kt, et), kt.prototype.v = function() {
      this.l && this.l.disconnect(), Vr(this), et.prototype.v.call(this);
    }, kt.prototype.s = function() {
      if (et.prototype.s.call(this), this.h && (this.l || (this.l = Jn(this)), kr(this), Fr(this.h) && Zn(this), this.i.B === "backgrounded")) {
        var t = Ei(new W(0, 0));
        this.G = this.g = this.m = t, Kt(this);
      }
    }, kt.prototype.S = function() {
      if (this.g && this.G) {
        var t = Pr(this);
        if (t) {
          var n = t, o = this.G, d = Math.max(t.x, o.x), m = Math.max(t.y, o.y), v = Math.min(t.J, o.J);
          t = Math.min(t.K, o.K), v <= d || t <= m ? d = null : (o = {}, d = new R((o.x = d, o.y = m, o.width = Math.abs(v - d), o.height = Math.abs(t - m), o), !1)), d || (d = new R({
            x: 0,
            y: 0,
            width: 0,
            height: 0
          }, !1));
        } else n = this.g, d = this.G;
        m = new at(), this.m && It(m, this.m), (v = this.i.B == "backgrounded") && ve(m, "backgrounded"), m.g = n, m.h = d, Be(m), this.Y ? !v && _e(m.g) ? ve(m, "hidden") : v || m.u === 100 || ve(m, "clipped") : ve(m, "viewport"), this.M = m;
      }
    }, kt.prototype.O = function() {
      return !0;
    };
    function Vr(t) {
      t.B && (t.B.disconnect(), t.B = void 0), t.u && (t.u.disconnect(), t.u = void 0), t.C && ((0, t.j.removeEventListener)("resize", t.C), t.C = void 0);
    }
    function kr(t) {
      t.l && t.h && (t.l.unobserve(t.h), t.l.observe(t.h));
    }
    function Fr(t) {
      return t = t.getBoundingClientRect(), t.width == 0 || t.height == 0;
    }
    function Jn(t) {
      return new t.j.IntersectionObserver(function(n) {
        try {
          if (n.length) {
            for (var o, d = n[0], m = 1; m < n.length; m++) n[m].time > d.time && (d = n[m]);
            o = d, t.m = Ei(o.rootBounds), t.g = Ei(o.boundingClientRect), t.G = Ei(o.intersectionRect), t.Y = !!o.isIntersecting, Kt(t);
          }
        } catch (v) {
          t.v(), xt(t.X, "generic", "Problem handling IntersectionObserver callback: " + v.message);
        }
      }, {
        root: null,
        rootMargin: "0px",
        threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1]
      });
    }
    function Zn(t) {
      t.j.ResizeObserver ? t.B || (t.B = es(t, function() {
        return ji(t);
      }), t.B.observe(t.h)) : (t.C || (t.C = function() {
        return ji(t);
      }, (0, t.j.addEventListener)("resize", t.C)), t.u || (t.u = new MutationObserver(function() {
        return ji(t);
      }), t.u.observe(t.h, {
        childList: !1,
        attributes: !0,
        subtree: !1
      })));
    }
    function ji(t) {
      t.h && !Fr(t.h) && (kr(t), Vr(t));
    }
    function es(t, n) {
      return new t.j.ResizeObserver(n);
    }
    function Ei(t) {
      if (t && t.x !== null && t.y !== null && t.width !== null && t.height !== null) return new R(t, !1);
    }
    function Bi(t) {
      if (J(t) === "object" && J(t.webOSSystem) === "object") return t.webOSSystem;
    }
    function gi(t) {
      return J(Bi(t)) === "object";
    }
    function Ft(t) {
      if (J(t) === "object" && J(t.tizen) === "object") return t.tizen;
    }
    function Rt(t) {
      return J(Ft(t)) === "object";
    }
    function ts(t, n) {
      this.h = t, this.g = n;
    }
    function qi() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t) {
        var n = 16 * Math.random() | 0;
        return t === "y" ? (n & 3 | 8).toString(16) : n.toString(16);
      });
    }
    function is(t, n) {
      var o = o === void 0 ? oe : o;
      this.i = t, this.g = o, this.j = n, this.h = [];
    }
    function Ur(t) {
      if (!t.g || !t.g.document) throw Error("OMID Service Script is not running within a window.");
      var n = t.h;
      t.h = [], n.forEach(function(o) {
        try {
          var d = o.accessMode, m = typeof d == "string" && Object.values(D).indexOf(d) !== -1 ? o.accessMode : null, v = m ? m == "domain" ? "limited" : m : "limited";
          o.accessMode = v;
          e: {
            var T = o.resourceUrl, I = t.g.location.origin;
            try {
              var _ = new URL(T, I);
              break e;
            } catch (tt) {
            }
            try {
              _ = new URL(T);
              break e;
            } catch (tt) {
            }
            _ = null;
          }
          if (d = _) {
            var P = qi();
            rs(t, P, d, v);
            var q = o.vendorKey, Ae = o.verificationParameters;
            q = q === void 0 ? "" : q, Ae = Ae === void 0 ? "" : Ae, q && typeof q == "string" && q !== "" && Ae && typeof Ae == "string" && Ae !== "" && (t.i.o[q] = Ae), t.j.u.set(P, o);
          }
        } catch (tt) {
          ui("OMID verification script " + o.resourceUrl + " failed to load: " + tt);
        }
      });
    }
    function rs(t, n, o, d) {
      var m = t.g.document, v = m.createElement("iframe");
      if (v.id = "omid-verification-script-frame-" + n, v.style.display = "none", d == "full") {
        var T = function() {
          var _ = v.contentWindow;
          _.omidVerificationProperties = {
            serviceWindow: t.g,
            injectionSource: "web",
            injectionId: n
          }, _ = _.document;
          var P = _.createElement("script");
          P.src = o.href, _.head.appendChild(P), v.removeEventListener("load", T);
        };
        v.addEventListener("load", T);
      } else d == "limited" && (v.srcdoc = `<html><head>
<script type="text/javascript">window['omidVerificationProperties'] = {
'serviceWindow': window.parent,
'injectionSource': 'web',
'injectionId': '` + (n + `',
};<\/script>
<script type="text/javascript" src="`) + o.href + `"><\/script>
</head><body></body></html>`, v.sandbox = "allow-scripts");
      m.body.appendChild(v), V().g.set(n, v);
    }
    function Hi(t, n) {
      var o = window, d = this;
      if (gi(o)) if (o)
        if (o.WebOSServiceBridge) {
          this.i = t, this.h = n, this.g = new o.WebOSServiceBridge(), this.g.onservicecallback = function(m) {
            try {
              var v = JSON.parse(m);
              if (v && v.errorCode) d.error(m);
              else if (!v) d.error("No object recieved from webOS bridge");
              else if (!vi(d, m, v, "volumeStatus", "object")) {
                var T = v.volumeStatus;
                vi(d, m, T, "muteStatus", "boolean") || vi(d, m, T, "volume", "number") || vi(d, m, T, "maxVolume", "number") || (0 >= T.maxVolume ? d.error("Invalid max volume status.") : d.i(T.muteStatus ? 0 : T.volume / T.maxVolume));
              }
            } catch (I) {
              d.error(I);
            }
          };
          try {
            this.g.call("luna://com.webos.service.audio/master/getVolume", '{"subscribe":true}');
          } catch (m) {
            this.error(m);
          }
        } else this.h("No WebOSServiceBridge on windowContext");
      else this.h("No window context");
    }
    Hi.prototype.stop = function() {
      this.g && this.g.cancel && this.g.cancel(), this.g = null;
    }, Hi.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function vi(t, n, o, d, m) {
      return J(o[d]) === m ? !1 : (t.error('Unexpected formatting on message from webOS bridge: "' + n + '". Expected "' + d + '" to be of type "' + m + '" but was of type "' + J(o[d]) + '".'), !0);
    }
    function $r(t) {
      return Rt(t) ? J(Ft(t).tvinputdevice) === "object" : !1;
    }
    function Si(t, n) {
      var o = window, d = this;
      if (o)
        if (this.validate(o)) {
          this.h = n;
          var m = Ft(o).tvaudiocontrol;
          this.g = void 0, n = function() {
            var T = m.isMute() ? 0 : m.getVolume() / 100;
            (d.g === void 0 || d.g != T) && (d.g = T, t(d.g));
          }, n(), this.i = o.setInterval(n, 200), this.j = o;
        } else n("Invalid Tizen window context");
      else n("No window context");
    }
    Si.prototype.stop = function() {
      this.i !== void 0 && typeof this.j.clearInterval == "function" && this.j.clearInterval(this.i), this.h = this.g = this.i = void 0;
    }, Si.prototype.validate = function(t) {
      return Rt(t) && $r(t) && J(Ft(t).tvaudiocontrol) === "object" && typeof t.setInterval == "function" && typeof t.clearInterval == "function";
    }, Si.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function jr(t, n, o, d, m) {
      var v = this;
      this.g = t, this.i = n, this.h = o, this.l = d, this.o = m, this.m = !1, Wi(this, function(T) {
        if (T.type === "sessionStart") {
          v.m = !0;
          try {
            Ur(v.l);
          } catch (I) {
            He(I.message);
          }
        }
        T.type === "sessionFinish" && (v.m = !1);
      });
    }
    function Wi(t, n, o, d) {
      pi(t.i, n, o, d);
    }
    i = jr.prototype, i.setSlotElement = function(t) {
      t && t.tagName ? (this.g.m = t, this.h && Ai(this.h)) : He("setSlotElement called with a non-HTMLElement.  It will be ignored.");
    }, i.setElementBounds = function(t) {
      this.g.o = t, this.h && Ai(this.h), this.h && Kt(this.h);
    }, i.error = function(t, n) {
      xt(this.i, t, n);
    }, i.injectVerificationScriptResources = function(t) {
      var n = this.l;
      if (n.h.push.apply(n.h, l(t)), this.m) try {
        Ur(this.l);
      } catch (o) {
        He(o.message);
      }
    }, i.setCreativeType = function(t, n) {
      n = n === void 0 ? null : n, (!this.g.g || this.g.h) && (this.g.h = t, t == "video" || t == "audio" ? this.g.g = "video" : t == "htmlDisplay" || t == "nativeDisplay" ? this.g.g = "display" : t == "definedByJavaScript" && n && (this.g.g = n == "none" ? "display" : "video"));
    }, i.setImpressionType = function(t) {
      (!this.g.g || this.g.h) && (this.g.G = t);
    }, i.setClientInfo = function(t, n, o) {
      var d = this.g.i || {};
      return d.omidJsInfo = ye({}, d.omidJsInfo, {
        sessionClientVersion: t,
        partnerName: n,
        partnerVersion: o
      }), this.g.i = d, this.g.i.omidJsInfo.serviceVersion;
    };
    function ns(t) {
      if (Rt(window) || gi(window)) {
        var n = function(m) {
          if (t.g.v !== m && t.i.g.j !== "none" && typeof m == "number" && !isNaN(m)) {
            t.g.v = m;
            var v = t.o, T = v.g.M;
            T != null && (m = v.h, v = {
              mediaPlayerVolume: T,
              deviceVolume: v.g.v
            }, Ze(m, "volumeChange", v), Tt(m, "volumeChange", v), Se(m, U(m, "volumeChange", "native", v)));
          }
        }, o = function(m) {
          He(m);
        };
        gi(window) ? t.j = new Hi(n, o) : Rt(window) && (t.j = new Si(n, o));
      }
    }
    function Br(t, n) {
      if (!n) return t.g;
      for (var o = s(t.h.values()), d = o.next(); !d.done; d = o.next()) if (d = d.value, d.g.u.has(n)) return d;
      return t.g;
    }
    function Me(t, n) {
      return n == null ? t.g : t.h.get(n) || t.g;
    }
    function Xi(t) {
      var n = new me(), o = new Yt(n), d = new Ve(), m = new Oe(), v = new Kn(o, n);
      t = t.i;
      var T = e;
      return d = T ? T.IntersectionObserver && (T.MutationObserver || T.ResizeObserver) ? new kt(T, d, v, o, n, t) : new Vt(T, m, v, o, n, t) : null, new jr(n, o, d, new is(o, n), new ts(o, n));
    }
    function Ut(t, n, o, d) {
      this.h = t, this.method = n, this.version = o, this.g = d;
    }
    function qr(t) {
      return !!t && t.omid_message_guid !== void 0 && t.omid_message_method !== void 0 && t.omid_message_version !== void 0 && typeof t.omid_message_guid == "string" && typeof t.omid_message_method == "string" && typeof t.omid_message_version == "string" && (t.omid_message_args === void 0 || t.omid_message_args !== void 0);
    }
    function Hr(t) {
      return new Ut(t.omid_message_guid, t.omid_message_method, t.omid_message_version, t.omid_message_args);
    }
    function Wr(t) {
      var n = {};
      return n = (n.omid_message_guid = t.h, n.omid_message_method = t.method, n.omid_message_version = t.version, n), t.g !== void 0 && (n.omid_message_args = t.g), n;
    }
    function Xr(t) {
      this.i = t;
    }
    function $t(t) {
      this.i = t, this.handleExportedMessage = $t.prototype.j.bind(this);
    }
    N($t, Xr), $t.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.handleExportedMessage(Wr(t), this);
    }, $t.prototype.j = function(t, n) {
      qr(t) && this.g && this.g(Hr(t), n);
    };
    function yi(t) {
      return Yi(t, "SessionService.");
    }
    function Yi(t, n) {
      return (t = t.match(new RegExp("^" + n + "(.*)"))) && t[1];
    }
    function Gi(t, n) {
      this.h = t, this.i = n;
    }
    Gi.prototype.g = function(t) {
      var n = O.apply(1, arguments);
      e: switch (t) {
        case "registerSessionObserver":
          var o = n.slice(1);
          break e;
        default:
          o = n;
      }
      return this.h("SessionService." + t, this.j.bind(this, t, n), o);
    }, Gi.prototype.j = function(t, n, o) {
      switch (t) {
        case "registerSessionObserver":
          t = s(n).next().value, t(o);
      }
    };
    function se(t, n) {
      return t.g.bind(t, n);
    }
    function ss(t, n) {
      n = n === void 0 ? oe : n, n.omidSessionInterface == null && (t = {
        setSessionClientWindow: t.i,
        setClientInfo: se(t, "setClientInfo"),
        registerSessionObserver: se(t, "registerSessionObserver"),
        startAdSession: se(t, "startSession"),
        finishAdSession: se(t, "finishSession"),
        reportError: se(t, "sessionError"),
        registerAdEvents: se(t, "registerAdEvents"),
        registerMediaEvents: se(t, "registerMediaEvents"),
        injectVerificationScriptResources: se(t, "injectVerificationScriptResources"),
        setSlotElement: se(t, "setSlotElement"),
        setVideoElement: se(t, "setVideoElement"),
        setElementBounds: se(t, "setElementBounds"),
        setCreativeType: se(t, "setCreativeType"),
        setImpressionType: se(t, "setImpressionType"),
        setContentUrl: se(t, "setContentUrl"),
        adEvents: {
          impressionOccurred: se(t, "impressionOccurred"),
          loaded: se(t, "loaded")
        },
        mediaEvents: {
          start: se(t, "start"),
          firstQuartile: se(t, "firstQuartile"),
          midpoint: se(t, "midpoint"),
          thirdQuartile: se(t, "thirdQuartile"),
          complete: se(t, "complete"),
          pause: se(t, "pause"),
          resume: se(t, "resume"),
          bufferStart: se(t, "bufferStart"),
          bufferFinish: se(t, "bufferFinish"),
          skipped: se(t, "skipped"),
          volumeChange: se(t, "volumeChange"),
          playerStateChange: se(t, "playerStateChange"),
          adUserInteraction: se(t, "adUserInteraction")
        }
      }, t.mediaEvents.loaded = t.adEvents.loaded, t.videoEvents = t.mediaEvents, Object.freeze(t), Object.defineProperty(n, "omidSessionInterface", {
        value: t,
        writable: !1
      }));
    }
    function Ii(t, n) {
      this.i = n = n === void 0 ? oe : n;
      var o = this;
      t.addEventListener("message", function(d) {
        if (J(d.data) === "object") {
          var m = d.data;
          qr(m) && d.source && o.g && o.g(Hr(m), d.source);
        }
      });
    }
    N(Ii, Xr), Ii.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.postMessage(Wr(t), "*");
    };
    function Yr() {
      this.g = an;
    }
    i = Yr.prototype, i.registerSessionObserver = function(t, n) {
      Wi(Me(this.g, t), n);
    }, i.setSlotElement = function(t, n) {
      Me(this.g, t).setSlotElement(n);
    }, i.setElementBounds = function(t, n) {
      Me(this.g, t).setElementBounds(n);
    }, i.error = function(t, n, o) {
      Me(this.g, t).error(n, o);
    };
    function Te(t, n, o, d) {
      t = Me(t.g, n), o == "impression" ? re(t.i) && (o = t.i, d = (d = o.g.O) ? je(d) : null, d = Je(o, M(o, d)), Se(o, U(o, "impression", "javascript", d)), t.h && mi(t.h)) : (o == "loaded" ? (n = d, n = n === void 0 ? null : n, ne(t.i) && (d = t.i, d.g.h || d.g.g != "display") && (n = U(d, "loaded", "javascript", Je(d, M(d, n === void 0 ? null : n))), Se(d, n))) : ne(t.i) && (n = t.i, Ze(n, o, d), Tt(n, o, d), Se(n, U(n, o, "javascript", d))), ["loaded", "start"].indexOf(o) !== -1 && t.h && mi(t.h));
    }
    i.injectVerificationScriptResources = function(t, n) {
      Me(this.g, t).injectVerificationScriptResources(n);
    }, i.setCreativeType = function(t, n, o) {
      o = o === void 0 ? null : o, Me(this.g, t).setCreativeType(n, o);
    }, i.setImpressionType = function(t, n) {
      Me(this.g, t).setImpressionType(n);
    }, i.setClientInfo = function(t, n, o, d) {
      var m = this.g;
      if (t == null) t = m.g;
      else {
        var v = [].concat(l(m.h.values())).indexOf(m.g) !== -1 ? Xi(m) : m.g;
        m.h.set(t, v), t = v;
      }
      return t.setClientInfo(n, o, d);
    };
    function Gr(t) {
      t = t.split("-")[0].split(".");
      for (var n = ["1", "0", "3"], o = 0; 3 > o; o++) {
        var d = parseInt(t[o], 10), m = parseInt(n[o], 10);
        if (d > m) break;
        if (d < m) return !1;
      }
      return !0;
    }
    function Kr(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && Gr(t) ? n : JSON.stringify(n);
    }
    function zr(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && Gr(t) ? n || [] : n && typeof n == "string" ? JSON.parse(n) : [];
    }
    function Ki() {
      var t = hs, n = this, o = o === void 0 ? e : o;
      this.g = t, this.h = o, this.j = new $t(), this.h.omid = this.h.omid || {}, this.h.omid.v1_SessionServiceCommunication = this.j, this.i = o && o.addEventListener && o.postMessage ? new Ii(o) : null, this.m = null, this.j.g = this.l.bind(this), this.i && (this.i.g = this.o.bind(this)), this.s = new Gi(function(d, m, v) {
        try {
          Jr(n, d, m, v);
        } catch (T) {
          He(Zr(T));
        }
      }, function(d) {
        n.m = d;
        var m = qi();
        n.i.h(new Ut(m, "identifyServiceWindow", "1.5.6-iab144"), d);
      }), ss(this.s, this.h);
    }
    Ki.prototype.l = function(t, n) {
      yi(t.method) != null && Qr(this, t, n, this.j);
    }, Ki.prototype.o = function(t, n) {
      if (yi(t.method) != null) {
        if (!this.m || n !== this.m) return He("Unrecognized session client window. Cross-origin session clients must register via the setSessionClientWindow API. See https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/iframes.html#om-sdk-js-session-client"), !1;
        Qr(this, t, n, this.i);
      }
    };
    function Qr(t, n, o, d) {
      function m() {
        var _ = new Ut(v, "response", I, Kr(I, O.apply(0, arguments)));
        d.h(_, o);
      }
      var v = n.h, T = n.method, I = n.version;
      n = zr(I, n.g);
      try {
        Jr(t, T, m, n);
      } catch (_) {
        d.h(new Ut(v, "error", I, Zr(_)), o);
      }
    }
    function Jr(t, n, o, d) {
      if (yi(n) != null) switch (yi(n)) {
        case "registerAdEvents":
          var m = s(d).next().value, v = Me(t.g.g, m).i;
          C(v, ["impression"]) && re(v) && (v.g.s = "javascript");
          break;
        case "registerMediaEvents":
          var T = s(d).next().value, I = Me(t.g.g, T).i;
          C(I, Object.values(F)) && ne(I) && (I.g.j = "javascript");
          break;
        case "registerSessionObserver":
          var _ = s(d).next().value;
          t.g.registerSessionObserver(_, o);
          break;
        case "setSlotElement":
          var P = s(d), q = P.next().value, Ae = P.next().value;
          t.g.setSlotElement(Ae, q);
          break;
        case "setVideoElement":
          var tt = s(d), dt = tt.next().value, Nt = tt.next().value, Fe = Me(t.g.g, Nt);
          dt && dt.tagName && dt.tagName.toLowerCase() === "video" ? (Fe.g.l = dt, Fe.h && Ai(Fe.h)) : He("setVideoElement called with a non-HTMLVideoElement. It will be ignored.");
          break;
        case "setElementBounds":
          var Ti = s(d), Qi = Ti.next().value, Ji = Ti.next().value;
          t.g.setElementBounds(Ji, Qi);
          break;
        case "startSession":
          var zt = s(d), Ge = zt.next().value, Ri = zt.next().value, Ke = t.h;
          if (Ge != null && J(Ge) === "object") {
            var Qt = Ge.customReferenceData, Le = Ge.underEvaluation, ln = Ge.universalAdId;
            typeof Qt == "string" || (Qt = void 0), typeof Le == "boolean" || (Le = !1);
            var mt = {
              customReferenceData: Qt,
              underEvaluation: Le
            };
            if (typeof ln == "string" && (mt.universalAdId = ln), gi(Ke)) {
              var dn = Bi(Ke), Ni;
              J(dn) === "object" && (Ni = dn.identifier), mt.app = {
                appId: Ni && typeof Ni == "string" ? Ni : void 0
              };
              e: {
                var un = Bi(Ke);
                if (J(un) === "object") {
                  try {
                    var hn = JSON.parse(un.deviceInfo);
                  } catch (Js) {
                    var Zi = void 0;
                    break e;
                  }
                  Zi = {
                    deviceType: hn.modelName || "Unknown",
                    osVersion: hn.platformVersion || "Unknown",
                    os: "webOS"
                  };
                } else Zi = void 0;
              }
              mt.deviceInfo = Zi, mt.deviceCategory = "ctv";
            } else if (Rt(Ke)) {
              e: {
                if (Rt(Ke)) {
                  try {
                    var cn = Ft(Ke).application.getCurrentApplication().appInfo.id;
                  } catch (Js) {
                    var er = void 0;
                    break e;
                  }
                  if (typeof cn == "string") {
                    er = cn;
                    break e;
                  }
                }
                er = void 0;
              }
              if (mt.app = {
                appId: er
              }, Rt(Ke)) {
                var Ci = Ft(Ke).systeminfo;
                if (J(Ci) === "object" && typeof Ci.getCapability == "function")
                  var cs = Ci.getCapability("http://tizen.org/system/model_name"), ps = Ci.getCapability("http://tizen.org/feature/platform.version");
                var pn = {
                  deviceType: cs || "Unknown",
                  osVersion: ps || "Unknown",
                  os: "tizen"
                };
              } else pn = void 0;
              mt.deviceInfo = pn, $r(Ke) && (mt.deviceCategory = "ctv");
            }
            Ge = mt;
          } else Ge = null;
          if (Ge == null) break;
          var Ct = Ge, tr = tr === void 0 ? null : tr, At = Me(t.g.g, Ri), fn = At.g.i;
          fn.sessionOwner || (fn.sessionOwner = "javascript");
          var fs = Ri || qi();
          At.g.H = fs, Ct.canMeasureVisibility = At.h.O();
          var ir = At.g;
          Ct.contentUrl !== void 0 && (ir.C = Ct.contentUrl, Ct.contentUrl = void 0);
          var mn = ir.i || {};
          Ct.omidJsInfo = ye({}, mn.omidJsInfo || {}, Ct.omidJsInfo || {});
          var ms = ye({}, mn, Ct);
          ir.i = ms, a(At.i, tr), At.h && mi(At.h), ns(At);
          break;
        case "finishSession":
          var As = s(d).next().value, An = t.g, Jt = Me(An.g, As), En = An.g;
          En.g = Xi(En), E(Jt.i), Jt.h.v(), Jt.j && (Jt.j.stop(), Jt.j = null);
          break;
        case "impressionOccurred":
          var Es = s(d).next().value;
          Te(t.g, Es, "impression");
          break;
        case "loaded":
          var gn = s(d), jt = gn.next().value, vn = gn.next().value;
          if (jt) {
            var Sn = {
              skippable: jt.isSkippable,
              autoPlay: jt.isAutoPlay,
              position: jt.position
            };
            jt.isSkippable && (Sn.skipOffset = jt.skipOffset), Te(t.g, vn, "loaded", Sn);
          } else Te(t.g, vn, "loaded");
          break;
        case "start":
          var rr = s(d), gs = rr.next().value, vs = rr.next().value, Ss = rr.next().value;
          Te(t.g, Ss, "start", {
            duration: gs,
            mediaPlayerVolume: vs
          });
          break;
        case "firstQuartile":
          var ys = s(d).next().value;
          Te(t.g, ys, "firstQuartile");
          break;
        case "midpoint":
          var Is = s(d).next().value;
          Te(t.g, Is, "midpoint");
          break;
        case "thirdQuartile":
          var Os = s(d).next().value;
          Te(t.g, Os, "thirdQuartile");
          break;
        case "complete":
          var Ts = s(d).next().value;
          Te(t.g, Ts, "complete");
          break;
        case "pause":
          var Rs = s(d).next().value;
          Te(t.g, Rs, "pause");
          break;
        case "resume":
          var Ns = s(d).next().value;
          Te(t.g, Ns, "resume");
          break;
        case "bufferStart":
          var Cs = s(d).next().value;
          Te(t.g, Cs, "bufferStart");
          break;
        case "bufferFinish":
          var _s = s(d).next().value;
          Te(t.g, _s, "bufferFinish");
          break;
        case "skipped":
          var Ds = s(d).next().value;
          Te(t.g, Ds, "skipped");
          break;
        case "volumeChange":
          var yn = s(d), Ls = yn.next().value, bs = yn.next().value;
          Te(t.g, bs, "volumeChange", {
            mediaPlayerVolume: Ls
          });
          break;
        case "playerStateChange":
          var In = s(d), Ms = In.next().value, Ps = In.next().value;
          Te(t.g, Ps, "playerStateChange", {
            state: Ms
          });
          break;
        case "adUserInteraction":
          var On = s(d), ws = On.next().value, xs = On.next().value;
          Te(t.g, xs, "adUserInteraction", {
            interactionType: ws
          });
          break;
        case "setClientInfo":
          var _i = s(d), Vs = _i.next().value, ks = _i.next().value, Fs = _i.next().value, Us = _i.next().value, $s = t.g.setClientInfo(Us, Vs, ks, Fs);
          o($s);
          break;
        case "injectVerificationScriptResources":
          var Tn = s(d), js = Tn.next().value, Bs = Tn.next().value;
          t.g.injectVerificationScriptResources(Bs, js);
          break;
        case "setCreativeType":
          var Rn = s(d), qs = Rn.next().value, Hs = Rn.next().value;
          t.g.setCreativeType(Hs, qs);
          break;
        case "setImpressionType":
          var Nn = s(d), Ws = Nn.next().value, Xs = Nn.next().value;
          t.g.setImpressionType(Xs, Ws);
          break;
        case "setContentUrl":
          var Cn = s(d), Ys = Cn.next().value, Gs = Cn.next().value;
          Me(t.g.g, Gs).g.C = Ys;
          break;
        case "sessionError":
          var nr = s(d), Ks = nr.next().value, zs = nr.next().value, Qs = nr.next().value;
          t.g.error(Qs, Ks, zs);
      }
    }
    function Zr(t) {
      return `
        name: ` + t.name + `
        message: ` + t.message + `
        filename: ` + t.filename + `
        lineNumber: ` + t.lineNumber + `
        columnNumber: ` + t.columnNumber + `
        stack: ` + t.stack + `
        toString(): ` + t.toString();
    }
    function zi() {
      var t = an, n = on, o = this, d = d === void 0 ? oe : d;
      this.j = t, this.g = n, this.l = {}, this.m = {}, this.i = new $t(), d.omid = d.omid || {}, d.omid.v1_VerificationServiceCommunication = this.i, this.h = null, d && d.addEventListener && d.postMessage && (this.h = new Ii(d)), this.i.g = function(m, v) {
        tn(o, m, v, o.i);
      }, this.h && (this.h.g = function(m, v) {
        o.h && tn(o, m, v, o.h);
      });
    }
    function en(t) {
      t({
        adSessionId: "",
        timestamp: (/* @__PURE__ */ new Date()).getTime(),
        type: "sessionError",
        data: {
          errorType: "generic",
          message: "Registration to session events is only allowed for verification clients injected by the OM-SDK service itself. Please note that in a future release registration in this manner will be rejected."
        }
      });
    }
    function os(t, n, o, d) {
      t = Br(t.j, d), d !== void 0 && t.g.u.has(d) ? (t = t.i, n === "media" || n === "video" ? ke(t, o, d) : (o = {
        type: n,
        U: d,
        I: o
      }, t.j.push(o), hi(t, n, o))) : en(o);
    }
    function as(t, n, o, d) {
      t = Br(t.j, d), d !== void 0 && t.g.u.has(d) ? Wi(t, n, o, d) : en(n);
    }
    function ls(t, n, o, d) {
      Qn(t.g, n, o, d);
    }
    zi.prototype.setInterval = function(t, n) {
      return this.g.setInterval(t, n);
    }, zi.prototype.clearInterval = function(t) {
      this.g.clearInterval(t);
    };
    function ds(t, n, o, d) {
      $i(t.g, "downloadJavaScriptResource")(n, o, d);
    }
    function tn(t, n, o, d) {
      function m() {
        var Le = new Ut(v, "response", I, Kr(I, O.apply(0, arguments)));
        d.h(Le, o);
      }
      var v = n.h, T = n.method, I = n.version;
      if (n = zr(I, n.g), Yi(T, "VerificationService.") != null) {
        T = Yi(T, "VerificationService.");
        try {
          switch (T) {
            case "addEventListener":
              var _ = s(n), P = _.next().value, q = _.next().value || rn(o);
              os(t, P, m, q);
              break;
            case "addSessionListener":
              var Ae = s(n), tt = Ae.next().value, dt = Ae.next().value || rn(o);
              as(t, m, tt, dt);
              break;
            case "sendUrl":
              var Nt = s(n).next().value;
              ls(t, Nt, function() {
                return m(!0);
              }, function() {
                return m(!1);
              });
              break;
            case "setTimeout":
              var Fe = s(n), Ti = Fe.next().value, Qi = Fe.next().value;
              t.l[Ti] = fi(t.g, "setTimeout")(m, Qi);
              break;
            case "clearTimeout":
              var Ji = s(n).next().value;
              zn(t.g, t.l[Ji]);
              break;
            case "setInterval":
              var zt = s(n), Ge = zt.next().value, Ri = zt.next().value;
              t.m[Ge] = t.setInterval(m, Ri);
              break;
            case "clearInterval":
              var Ke = s(n).next().value;
              t.clearInterval(t.m[Ke]);
              break;
            case "injectJavaScriptResource":
              var Qt = s(n).next().value;
              ds(t, Qt, function(Le) {
                return m(!0, Le);
              }, function() {
                return m(!1);
              });
              break;
            case "getVersion":
              m("1.5.6-iab144");
          }
        } catch (Le) {
          d.h(new Ut(v, "error", I, `
              name: ` + Le.name + `
              message: ` + Le.message + `
              filename: ` + Le.filename + `
              lineNumber: ` + Le.lineNumber + `
              columnNumber: ` + Le.columnNumber + `
              stack: ` + Le.stack + `
              toString(): ` + Le.toString() + `
          `), o);
        }
      }
    }
    function rn(t) {
      for (var n = V().g, o = s(n.keys()), d = o.next(); !d.done; d = o.next()) {
        d = d.value;
        var m = n.get(d);
        if (m) {
          if (m.contentWindow === t) return d;
          try {
            if (m.contentWindow.Object.prototype.isPrototypeOf(t)) return d;
          } catch (v) {
          }
        }
      }
    }
    function nn(t) {
      var n = {};
      return (n.app = "omid_v1_present_app", n.web = "omid_v1_present_web", n)[t];
    }
    function sn(t, n) {
      t.document.write('<iframe style="display:none" id="' + (n + '" name="' + n + '" sandbox></iframe>'));
    }
    function Oi(t, n) {
      var o = t.document.createElement("iframe");
      o.id = n, o.name = n, o.style.display = "none", o.sandbox = "", t.document.body.appendChild(o);
    }
    function us(t, n) {
      var o = new MutationObserver(function(d) {
        d.forEach(function(m) {
          m.addedNodes[0].nodeName === "BODY" && (m = nn(n), Oi(t, "omid_v1_present"), Oi(t, m), o.disconnect());
        });
      });
      o.observe(t.document.documentElement, {
        childList: !0
      });
    }
    var on = new Ui(), an = new function() {
      this.i = on, this.h = /* @__PURE__ */ new Map(), this.g = Xi(this);
    }(), hs = new Yr();
    new zi(), new Ki(), function(t, n) {
      t.frames && t.document && !["omid_v1_present", "omid_v1_present_web", "omid_v1_present_app"].some(function(o) {
        return !!t.frames[o];
      }) && (t.document.body == null && "MutationObserver" in t ? us(t, n) : (n = nn(n), t.document.body ? (Oi(t, "omid_v1_present"), Oi(t, n)) : (sn(t, "omid_v1_present"), sn(t, n))));
    }(oe, "web");
  }).call(p, p);
}
const $n = "4.0", jn = ["4.0"], Lr = class Lr {
  constructor() {
    this.OmidServiceClient = Vo();
  }
  /** @internal */
  detectOMID(e) {
    const i = "omid_v1_present", r = window;
    let s = !1;
    try {
      const l = e.omidServiceWindow;
      s = l.frames ? !!l.frames[i] : !1;
    } catch (l) {
      c.debug.warn("detectOMID: Publisher-Service could not be recognized.", l);
    }
    s || (c.debug.info("detectOMID: Publisher-Service not present. Using internal service."), e.omidServiceWindow = r);
  }
  /**
   * Checks if the provided player facade has a valid handshake version.
   *
   * @internal
   * @param {Object} playerFacade - The player facade object with a handshakeVersion method.
   * @param {string} [facadeVersion=FACADE_VERSION] - The expected facade version.
   * @param {string[]} [supportedFacadeVersions=SUPPORTED_FACADE_VERSIONS] - An array of supported facade versions.
   * @returns {boolean} True if the handshake is valid, otherwise false.
   */
  /** @internal */
  hasValidHandshake(e, i = $n, r = jn) {
    if (!e.handshakeVersion)
      return !1;
    const s = e.handshakeVersion(i);
    return r.includes(s);
  }
  /**
   * Checks whether a `playerFacade` instance implements all expected functions and properties of `FacadeBase`.
   *
   * @internal
   * @param {PlayerFacade} playerFacade - The `playerFacade` instance to be checked.
   * @param {typeof FacadeBase} Facade - The class from which `playerFacade` is expected to implement.
   * @returns {boolean} - True if the implementation is correct, otherwise false.
   */
  /** @internal */
  hasValidFacadeImplementation(e, i = to) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new i())).filter((l) => !(l in e)).length <= 0;
  }
  /**
   * Establishes a connection between the core and the provided player facade to control the audio/video player.
   *
   * @internal
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @returns {void} This function does not return a value but sets the 'error' property on failure.
   */
  /** @internal */
  validate(e) {
    if (!e) {
      this.error = x.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = x.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = x.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, i) {
    let r = Xt(si, i);
    return new Promise((s, l) => {
      this.validate(e), this.detectOMID(r.adVerification);
      function h(A) {
        c.debug.critical("init - error", A), l(A);
      }
      Object.keys(this.initError).length > 0 ? h(this.initError) : s(new Or(r, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return Gn;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return he;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return fe;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return Cr(si);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return ai;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return f;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(f);
  }
  get LOGLEVEL() {
    return ot;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    c.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return c.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return c.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return $n;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return jn;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.5.6";
  }
};
Lr.NAME = "Core::";
let Fi = Lr;
const ko = new Fi();
typeof window != "undefined" && (window.smartclientcore = ko);
typeof exports == "object" && (exports = {
  smartclientcore: Fi
});
export {
  to as FacadeBase,
  ko as default
};
