Object.entries || (Object.entries = function(e) {
  var t = [];
  for (k in e)
    typeof k == "string" && e.propertyIsEnumerable(k) && t.push([k, e[k]]);
  return t;
});
(function() {
  if (typeof navigator != "undefined" && navigator.userAgent) {
    var l = function(i, r) {
      r = r || {
        bubbles: !1,
        cancelable: !1,
        detail: void 0
      };
      var s = document.createEvent("CustomEvent");
      return s.initCustomEvent(i, r.bubbles, r.cancelable, r.detail), s;
    }, e = navigator.userAgent.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
    /trident|msie/i.test(e[1]) && (l.prototype = window.Event.prototype, window.CustomEvent = l, window.Event = l);
  }
})();
(function(l) {
  l && l.prototype && l.prototype.firstElementChild === void 0 && Object.defineProperty(l.prototype, "firstElementChild", {
    get: function() {
      for (var t, i = this.childNodes, r = 0; t = i[r++]; )
        if (t.nodeType === 1)
          return t;
      return null;
    }
  });
})(typeof window != "undefined" ? window.Node || window.Element : null);
var he = /* @__PURE__ */ ((l) => (l[l.SILENT = 0] = "SILENT", l[l.ERROR = 1] = "ERROR", l[l.NORMAL = 2] = "NORMAL", l[l.VERBOSE = 3] = "VERBOSE", l))(he || {}), G = /* @__PURE__ */ ((l) => (l[l.CRITICAL = 0] = "CRITICAL", l[l.ERROR = 1] = "ERROR", l[l.INFO = 2] = "INFO", l[l.TABLE = 3] = "TABLE", l[l.WARN = 4] = "WARN", l))(G || {});
let Ne = he.SILENT;
const Ke = "[OIS_DEBUG]", ni = {
  [he.ERROR]: [G.CRITICAL, G.ERROR],
  [he.NORMAL]: [G.INFO, G.TABLE, G.WARN],
  [he.SILENT]: [],
  [he.VERBOSE]: [G.CRITICAL, G.ERROR, G.INFO, G.TABLE, G.WARN]
};
function Me() {
}
class a {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    Ne = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return Ne;
  }
  /**
   * Checks whether a specific log type should be logged based on the logging level.
   * @internal
   * @param {LOGTYPE} type - The type of log (e.g., 'CRITICAL', 'INFO', 'ERROR', 'TABLE', or 'WARN').
   * @param {LOGLEVEL} level - The current logging level.
   * @returns {boolean} - `true` if the log type should be logged, otherwise `false`.
   */
  static shouldLog(e, t) {
    return t !== he.SILENT && ni[t].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(G.CRITICAL, Ne) ? console.error : Me).bind(console, Ke),
      info: (this.shouldLog(G.INFO, Ne) ? console.info : Me).bind(console, Ke),
      error: (this.shouldLog(G.ERROR, Ne) ? console.error : Me).bind(console, Ke),
      table: (this.shouldLog(G.TABLE, Ne) ? console.table : Me).bind(console),
      warn: (this.shouldLog(G.WARN, Ne) ? console.warn : Me).bind(console, Ke)
    };
  }
}
const ai = "4.0";
class oi {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, t) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return ai;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, t = !0, i = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, t) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var w = /* @__PURE__ */ ((l) => (l.LINEAR = "linear", l.NON_LINEAR = "nonlinear", l))(w || {});
class O {
  /**
   * Converts a time duration string into the equivalent time in seconds.
   *
   * @param {string} durationString - The time duration string in the format 'HH:MM:SS' to be converted.
   * @returns {number|null} The time duration in seconds or null if the input is invalid.
   */
  static convertTimeStringToSeconds(e) {
    const t = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(t) ? null : t / 1e3;
  }
  /**
   * Returns the most nested child within an Element (NodeTree) that matches the specified selector,
   * or group of selectors. If no matches are found, `null is returned.
   * (identically to the `Element` method `querySelector()`)
   *
   * @param {Element} baseElement - A DOM object that is scanned for an element that matches the specified selectors.
   * @param {string} selectors - A `DOMString` containing one or more selectors to match.
   * This string must be a valid CSS selector string.
   *
   * @returns {HTMLElement|null} - An HTMLElement object representing the element that matches
   * the specified set of CSS selectors, or null is returned if there are no matches.
   */
  static getMostNestedElement(e, t) {
    const i = Array.from(e.querySelectorAll(t));
    let r = -1, s = null;
    return i.forEach((n) => {
      let d = 0, h = n;
      for (; h.parentNode !== e; )
        d++, h = h.parentNode;
      d > r && (r = d, s = n);
    }), s;
  }
  /**
   * Creates a new Array with unique elements in it.
   *
   * @param {Array} array - The array to be cleaned of duplicates.
   * @param {string} uniqueValue - The property to search for duplicates in the array.
   * @returns {Array} - An array with unique elements defined by uniqueValue.
   */
  static getUnique(e, t) {
    const i = e.map((s) => s[t]);
    return e.filter((s, n) => !i.includes(s[t], n + 1));
  }
  /**
   * This function trims a string and returns it, unless the string is empty, null, or contains only the value 'null'.
   *
   * @param {string} resultString - The string to be checked.
   * @returns {string|null} The trimmed string or null if the string is empty, null, or 'null'.
   */
  static trim(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
}
class li {
  constructor(e) {
    this.adSourceXML = e, this.adSource = this.adSourceXML.querySelector("AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? O.trim(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : O.trim(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const Oe = class Oe {
  constructor(e, t = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = t, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return w.NON_LINEAR;
      default:
        return w.LINEAR;
    }
  }
  /**
   * @internal
   */
  queryElements(e) {
    return Array.from(this.adBreakXML.querySelectorAll(e));
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = this.adBreakXML.querySelector(":scope > AdSource");
    return e ? new li(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[Oe.POSITION[this.breakPosition]] && this.publisherSpecs[Oe.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[Oe.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = O.convertTimeStringToSeconds(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  /**
   * Returns one of the following values:
   * - 1 for pre-roll
   * - 2 for mid-roll
   * - 3 for post-roll
   * - 4 for standalone  (in accordance with OM for Web, overlays are considered to be standalone)
   * - 0 for none of the above/other
   * @returns {number} The break position number according to IAB VAST BREAKPOSITION macro values
   */
  /** @internal */
  getBreakPosition() {
    return this.type === w.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || O.convertTimeStringToSeconds(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  /**
   * @returns {Array} list of all found VMAP Extensions
   */
  /** @internal */
  getExtensions() {
    return this.queryElements(":scope > Extensions > Extension").map(
      (e) => ({
        extensionXML: e,
        type: e.getAttribute("type") || ""
      })
    );
  }
  /**
   * @returns {Object} list of tracking objects by event name
   */
  /** @internal */
  getTrackers() {
    const e = {};
    return this.queryElements(":scope > TrackingEvents > Tracking").forEach(
      (t) => {
        const i = t.getAttribute("event"), r = t.textContent.trim();
        r && (e[i] = e[i] || [], e[i].push({ url: r }));
      }
    ), e;
  }
  /** @internal */
  getSeparationClips() {
    return this.publisherSpecs[Oe.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = this.adBreakXML.querySelector("ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
Oe.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let Fe = Oe;
class di {
  constructor(e, t) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, t);
  }
  createAdSlotList(e, t) {
    let r = [...(e.documentElement || e).querySelectorAll(":scope > *")];
    this.adSlotList = r.map((d) => new Fe(d, t));
    let s = {}, n = [];
    if (this.adSlotList.forEach((d, h) => {
      d.breakPosition === 2 && d.timeOffset !== null && (s[d.timeOffset] = (s[d.timeOffset] || 0) + 1, s[d.timeOffset] > 1 && (d.multiMidroll = !0, n.length === 0 && (this.adSlotList[h - 1].multiMidroll = !0, this.adSlotList[h - 1].adBreakXML.setAttribute(
        "type",
        this.adSlotList[h - 1].adSource.type
      ), this.adSlotList[h - 1].adBreakXML.setAttributeNS(
        null,
        "allowMultipleAds",
        this.adSlotList[h].adSource.allowMultipleAds.toString()
      ), n.push(this.adSlotList[h - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[h].multiMidroll = !0, d.adBreakXML.setAttribute("type", this.adSlotList[h].adSource.type), d.adBreakXML.setAttributeNS(
        null,
        "allowMultipleAds",
        this.adSlotList[h].adSource.allowMultipleAds.toString()
      ), n.push(d.adBreakXML.cloneNode(!0))));
    }), this.midrollHasSameTimeOffset) {
      let d = [];
      for (let u = 0; u < n.length; u++)
        if (n[u].getAttribute("type").includes("adtaguri")) {
          let N = document.createElementNS(null, "Ad");
          N.setAttribute("sequence", (u + 1).toString());
          let x = document.createElementNS(null, "Wrapper");
          x.setAttributeNS(
            null,
            "fallbackOnNoAd",
            n[u].getAttribute("allowMultipleAds")
          );
          let B = document.createElementNS(null, "VASTAdTagURI");
          B.textContent = n[u].querySelector("AdTagURI").textContent.trim(), x.appendChild(B), N.appendChild(x), d.push(N);
        } else
          n[u].querySelector("Ad").setAttribute("sequence", (u + 1).toString()), d.push(n[u].querySelector("Ad"));
      let h = null;
      for (let u = 0; u < this.adSlotList.length; u++) {
        if (!this.adSlotList[u].multiMidroll)
          continue;
        if (this.adSlotList[u].adBreakXML.hasAttribute("type") && this.adSlotList[u].adBreakXML.getAttribute("type").includes("adtaguri") && (h = document.createElementNS(null, "VASTAdData")), this.adSlotList[u].adBreakXML.querySelector("Ad") || h) {
          if (h) {
            this.adSlotList[u].adBreakXML.querySelector("AdTagURI").remove();
            let x = this.adSlotList[u].adBreakXML.querySelector("AdSource");
            const B = document.createElementNS(null, "VAST");
            d.forEach((H) => {
              B.appendChild(H);
            }), h.appendChild(B), x.appendChild(h);
          } else {
            this.adSlotList[u].adBreakXML.querySelector("Ad").remove();
            const x = this.adSlotList[u].adBreakXML.querySelector("VAST");
            d.forEach((B) => {
              x.appendChild(B);
            });
          }
          this.adSlotList[u].multiMidroll = !1, this.adSlotList[u] = new Fe(this.adSlotList[u].adBreakXML, this.adSlotList[u].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((u) => {
        if (!u.multiMidroll)
          return u;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((t) => !t.hasError && t.adSource).shift();
  }
}
class Se {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, t) {
    const i = this.listeners[e] || (this.listeners[e] = []);
    return i.includes(t) || i.push(t), () => {
      this.removeEventListener(e, t);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const t = this.listeners[e];
    if (!t)
      return;
    const i = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let r = 0; r < t.length; r++)
      t[r].call(this, i);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, t) {
    const i = this.listeners[e];
    return i && i.indexOf(t) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, t) {
    const i = this.listeners[e];
    if (i) {
      const r = i.indexOf(t);
      r !== -1 && i.splice(r, 1);
    }
  }
}
const f = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let at = null, ot = null, Le = 0, wt = null, lt = null;
const re = class re {
  constructor(e, t) {
    this.enrichment = t, this.reasonData = null, e && e.homad && (wt = e), this.enrichment.set("BLOCKED", Le, "blocked");
  }
  get isActive() {
    return Le === 1;
  }
  get vendorAPI() {
    return lt;
  }
  setVendorAPI(e) {
    !lt && e && (lt = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    ot = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    at = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, t) {
    if (a.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !wt.homad.enabled) {
      let s = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      t(s);
      return;
    }
    if (!this.vendorAPI) {
      a.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, t);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let s = new Error("AdReinsertionModel: Fallback not activated.");
      s = f.SESSION.AD_REINSERTION_DECLINED, t(s);
      return;
    }
    if (!ot) {
      t("HOMAD corroboration callback not set.");
      return;
    }
    let i = this.reasonData.reason, r = this.reasonData;
    ot(i, r).then(() => {
      Le !== re.STATUS.IS_BLOCKED ? at ? at(i).then((s) => {
        a.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          re.STATUS.IS_BLOCKED,
          "blocked"
        ), Le = re.STATUS.IS_BLOCKED, e();
      }).catch((s) => {
        a.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), t("AdReinsertion request declined by publisher.", s);
      }) : (a.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        re.STATUS.IS_BLOCKED,
        "blocked"
      ), Le = re.STATUS.IS_BLOCKED, e()) : (a.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (s) => {
      this.disable(), t("AdReinsertion request declined by HOMAD.", s);
    });
  }
  disable() {
    Le = 0, this.enrichment.set("BLOCKED", re.STATUS.IS_OPEN, "blocked");
  }
};
re.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, re.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, re.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, re.EventDispatcher = new Se();
let V = re;
class Z {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: Z.screenHeight(),
      width: Z.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return Z.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !Z.isIF() || Z.isFIF();
  }
}
function hi() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function ze(l) {
  return encodeURIComponent(l).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function ui() {
  const l = /* @__PURE__ */ new Date(), e = l.toISOString();
  let t = l.getTimezoneOffset() / 60, i = t < 0 ? "-" : "+" + ("0" + Math.abs(t)).slice(-2);
  return e.replace("Z", i);
}
function ci(l, e, t) {
  if (l.indexOf(e) === -1)
    return l;
  {
    const i = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let r = /\d+/.test(l) ? parseInt(l.match(/\|(\d+)]/)[1], 10) : 0;
    return l.replace(
      i,
      r === 0 ? ze(t) : ze(t).substring(0, r)
    );
  }
}
function Qe(l) {
  let e = !Number.isFinite(l) || l < 0 ? 0 : l;
  const t = /* @__PURE__ */ new Date(0);
  return t.setSeconds(e), t.toISOString().substring(11, 19) + ".000";
}
function Yt() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (l) => {
    let e = Math.random() * 16 | 0;
    return (l === "x" ? e : e & 3 | 8).toString(16);
  });
}
class ge {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], Z.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], hi), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", Qe), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", Z.userAgent(), "deviceua"), this.set("DOMAIN", Z.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", Z.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", Qe), this.set("OS", Z.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.5.6", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      Z.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", Z.screenHeight(), "screenheight"), this.set("SCREENWIDTH", Z.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", ui), this.set("TRANSACTIONID", Yt(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((t) => t.idRegistry + " " + t.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  /** @internal */
  getPlayerDimension(e) {
    var i;
    return ((i = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : i[e]) || 0;
  }
  /** @internal */
  getResolution(e) {
    const t = parseInt((e == null ? void 0 : e.width) || "0", 10), i = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${t},${i}`;
  }
  /** @internal */
  getMacros(e = !1) {
    let t = {};
    return this.macroMap.forEach((i, r) => {
      const s = e ? `[${r}]` : r;
      t[s] = this.get(r, !0);
    }), t;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, t, i, r) {
    let s = this.macroMap.get(e) || {}, n = i || s.macroList;
    return s.value = t, n ? Array.isArray(n) ? s.macroList = n : s.macroList = [n] : s.macroList = [e.toLowerCase()], r && (s.transform = r), this.macroMap.set(e, s), this;
  }
  get(e, t = !1) {
    if (!e)
      return null;
    let i = this.macroMap.get(e + "");
    if (!i)
      return null;
    let r = i.value;
    return i.transform && (r = i.transform(r)), t ? Array.isArray(r) ? r.map((s) => ze(String(s))).join(",") : ze(String(r)) : r;
  }
  setFromObject(e) {
    e && Object.keys(e).forEach((t) => {
      let i = e[t];
      switch (typeof i) {
        case "string":
        case "object":
          i = i.length === 0 ? "-1" : i;
          break;
      }
      this.set(t.toUpperCase(), i, "");
    });
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    if (!e)
      return e + "";
    let t = e + "";
    return this.macroMap.forEach((i, r) => {
      let s = this.get(r, !0) + "";
      i.macroList.map((n) => {
        t = this.replaceMacroWithValue(t, n, s);
      });
    }), t;
  }
  replaceMacroWithValue(e, t, i) {
    let r = e.replace(this.getRegExp(t), i);
    return ci(r, "[" + t, i);
  }
  getRegExp(e) {
    let t = "[\\[](" + e + ")[\\]]";
    return new RegExp(t, "gi");
  }
}
class $e {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new $e().xdrRequest();
  }
  get(e, t, i) {
    if (this.xdrRequest()) {
      let r = new XMLHttpRequest();
      r.open("GET", e), r.timeout = t.timeout || 0, r.withCredentials = t.withCredentials !== !1, r.onload = () => {
        let s = new DOMParser().parseFromString(r.responseText, "text/xml");
        i(null, s);
      }, r.onerror = () => {
        i(new Error("Error loading the XML document"));
      }, r.send();
    } else
      i(new Error("XDomainRequest is not supported"));
  }
}
class Ai {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, t, i) {
    let r = !1;
    const s = t.timeouts.adRequest * 1e3, n = setTimeout(() => {
      r = !0;
      let N = new Error("ImageURLHandler: Tracking request timeout.");
      N.code = f.WARNING.TRACKER_TIMEOUT.code, N.description = f.WARNING.TRACKER_TIMEOUT.message, N.type = "AdWarning", i(N);
    }, s);
    let d = new Image();
    d.src = "";
    const h = () => {
      clearTimeout(n), !r && i(null);
    }, u = (N) => {
      h();
    };
    return d.onerror = u, d.onload = h, d.src = e, d;
  }
}
function Ot(l) {
  if (typeof l != "string")
    return l;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(l, "text/xml");
  else if (ActiveXObject) {
    let t = new ActiveXObject("Microsoft.XMLDOM");
    t.loadXML(l), e = t;
  }
  return e;
}
const dt = " Response contains neither 'responseXML' nor 'responseText'", K = class K {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new K().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, t, i) {
    let r, s = i.timeouts.adRequest * 1e3, d = setTimeout(() => {
      r.onreadystatechange = r.onerror = () => {
        a.debug.info(K.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let h = new Error(K.NAME + ": Request timeout");
      h.code = f.WRAPPER.TIMEOUT.code;
      let u = i.timeouts ? i.timeouts.errorMessage : null;
      h.message = u || f.WRAPPER.TIMEOUT.message, i.adReinsertion.setReinsertionReason({
        reason: i.isWrapper ? V.REASON.WRAPPER_CHAIN_TIMEOUT : V.REASON.XHR_TIMEOUT,
        xhr: r,
        xhrError: h
      }), t(h, null);
    }, s);
    try {
      r = this.xhrRequest(), r.withCredentials = i.withCredentials !== !1, r.overrideMimeType && r.overrideMimeType("text/xml"), r.onreadystatechange = () => {
        if (r.readyState === 1) {
          r.send();
          return;
        }
        if (r.readyState === 4)
          if (clearTimeout(d), r.status === 200) {
            let h = r.responseXML;
            if (!h && r.responseText && (h = Ot(r.responseText)), !h) {
              a.debug.info(K.NAME + dt);
              let u = new Error(K.NAME + dt);
              u.code = i.isWrapper ? f.WRAPPER.NO_RESPONSE.code : f.XML.INVALID_XML.code, u.message = "XHR Response Error:" + dt, i.adReinsertion.setReinsertionReason({
                reason: V.REASON.XHR_ERROR,
                xhr: r,
                xhrError: u
              }), t(u, null);
              return;
            }
            t(null, h);
          } else {
            r.onreadystatechange = r.onerror = () => {
              a.debug.info(K.NAME + "Ignoring XHR state changes after status error", r.readyState, r.status, e);
            };
            let h = new Error(K.NAME + r.statusText);
            h.code = i.isWrapper ? f.WRAPPER.TIMEOUT.code : f.XML.INVALID_XML.code, h.message = `XHR Status Error (${r.status}): ${r.statusText}`, i.adReinsertion.setReinsertionReason({
              reason: V.REASON.XHR_UNEXPECTED_STATUS,
              xhr: r,
              xhrError: h
            }), t(h, null);
          }
      }, r.open("GET", e), r.onerror = () => {
        clearTimeout(d), a.debug.info(K.NAME + ": XHR Error.", r.readyState, r.status, e);
        let h = new Error(K.NAME + r.statusText);
        h.code = f.WRAPPER.TIMEOUT.code, h.message = `XHR Error (${r.status}): ${r.statusText}`, i.adReinsertion.setReinsertionReason({
          reason: V.REASON.XHR_UNEXPECTED_STATUS,
          xhr: r,
          xhrError: h
        }), t(h, null);
      };
    } catch (h) {
      clearTimeout(d);
      let u = new Error(`${K.NAME}: Request error.`);
      u.code = f.WRAPPER.TIMEOUT.code, u.message = `XHR Request Error: ${h}`, i.adReinsertion.setReinsertionReason({
        reason: V.REASON.XHR_ERROR,
        xhr: null,
        xhrError: u
      }), t(u, null);
    }
  }
  get(e, t, i) {
    a.debug.info(`${K.NAME}: XHR get with timeout ${i.timeouts.adRequest} sec: ${e}`), i.issuer && i.issuer === K.ISSUER.TRACKING ? Ai.getAsImage(e, i, t) : this.getAsXHR(e, t, i);
  }
};
K.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, K.NAME = "XHRURLHandler";
let ce = K;
ce.DEFAULT_TIMEOUT = 4;
function Je(l, e) {
  if (l.indexOf("//") === 0) {
    let t = location.protocol;
    return (t === "about:" || t === "file:") && (t = "https:"), t + l;
  }
  return l.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + l : l;
}
const xe = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class Ct {
  constructor() {
    this.issuer = ce.ISSUER.TAG;
  }
  get(e, t, i) {
    if (!t)
      return null;
    let r = i, s = e;
    r || (r = xe, r.enrichment = new ge()), r.issuer = this.issuer, r.enrichment = r.enrichment || new ge(), s = r.enrichment.apply(s), s && s.indexOf("//") === 0 && (s = Je(s, ""));
    let n = r.urlhandler;
    if (r.response) {
      let d = r.response;
      t(null, Ot(d));
    } else return n && n.supported() ? new n().get(s, t, r) : ce.supported() ? new ce().get(s, t, r) : $e.supported() ? new $e().get(s, t, r) : t();
    return null;
  }
}
const ke = class ke extends Ct {
  constructor() {
    super(), this.issuer = ce.ISSUER.TRACKING;
  }
  track(e, t, i) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, t, i) : a.debug.info(ke.NAME + "track - without trackers:", e);
  }
  getMultiple(e, t, i) {
    e.forEach((r) => {
      r.requested = !0, r.url && super.get(r.url, (t || this.onResponse).bind(this, r), i);
    });
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, t) {
    t && a.debug.warn(ke.NAME + "onResponse failed:", t.name, t, e);
  }
};
ke.NAME = "TrackingUrlHandler::";
let qe = ke;
const o = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup"
}, ye = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, Ce = class Ce {
  constructor(e, t, i) {
    this.player = t, this.config = i, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, Ce.ERROR_CODE_MAP[f.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, Ce.ERROR_CODE_MAP[f.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, t = {}) {
    e.requested = !0, a.debug.info(
      j.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = t;
    const i = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let r = {};
    return r.adBreakPosition = e.breakPosition, r.type = e.type, r[i] = e.adSource.source, r = Object.assign(r, e.separationClips), this.currentAdBreak.enrichment = new ge(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new V(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((s, n) => {
      this.adSlotAPI.initAdSlot(r, t).then(() => {
        a.debug.info(
          j.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), s(e);
      }).catch((d) => {
        a.debug.warn(j.NAME + "initAdSlot - Could not init ad slot", d), n(d);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    a.debug.info(
      j.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(o.ON_AD_SLOT_START, () => {
        this.trackEvent(ye.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(o.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent(ye.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(o.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(o.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Ce.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent(ye.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(o.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent(ye.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), a.debug.info(
      j.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    a.debug.info(
      j.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    ), this.eventHandlers.forEach((e) => {
      e();
    }), this.eventHandlers = [];
  }
  /** @internal */
  trackEvent(e) {
    let t = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(t);
  }
  /** @internal */
  callTrackers(e) {
    if (!e || e.length < 1) {
      a.debug.info(
        j.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const t = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new qe().track(e, (i, r) => {
      r && a.debug.warn(j.NAME + "callTrackers - failed:", r, i);
    }, t);
  }
};
Ce.ERROR_CODE_MAP = {}, Ce.NAME = "AdBreakCtrl::";
let ct = Ce;
const te = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, ht = "Content - Scan for AdBreaks to play", U = class U extends Se {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, t) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = t, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((i) => {
      if (i.timeOffset === "end")
        return i;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(o.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(o.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(o.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, a.debug.info(
      U.NAME + "before" + ht + "."
    ), super.dispatchEvent(o.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      a.debug.info(
        U.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(o.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), a.debug.info(
      U.NAME + "start" + ht + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, a.debug.info(
      U.NAME + "after" + ht + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset && (this.isSeeking = !1, this.postroll = null, this.adPlaylist.forEach((r) => {
      r.timeOffset !== "end" && (r.requested = !0);
    }), this.requestAdBreak(e)), this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let t = this.find(e), i = t.shift();
    return t.forEach((r) => {
      r.requested = !0;
    }), i && this.playableAdBreaks.length && (i.requested = !0), new Promise((r, s) => {
      i && !i.requested ? (this.adBreakController = new ct(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(i, this.player.getEnvironmentVars(i.type)).then((n) => {
        a.debug.info(
          U.NAME + "requestAdBreak - Initialized AdBreak",
          n.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(n), r();
      }).catch((n) => {
        a.debug.warn(
          U.NAME + "requestAdBreak - Failed to initialize ",
          i.timeOffset,
          n
        ), s(n);
      })) : s(
        U.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      U.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), a.debug.info(U.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const t = e;
    return this.adPlaylist.filter((i) => {
      if (i.requested)
        return !1;
      let r = t;
      return i.prefetchOffset > 0 && (r += i.prefetchOffset), this.isExecutableAdBreak(i, r);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, t, i = U.PROCESS.REQUEST) {
    function r(n, d) {
      var u;
      const h = n - d;
      return (u = e.publisherSpecs) != null && u.strictOffsets ? h >= 0 && h <= U.STRICT_OFFSET_THRESHOLD : h >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const n = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return r(t, n);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && i === U.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && i === U.PROCESS.REQUEST)
      return t - this.contentDuration >= 0;
    const s = O.convertTimeStringToSeconds(e.timeOffset);
    return s !== null && r(t, s);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const i = this.player.getContentCurrentTime() + e.repeatAfter;
    let r = e.adBreakXML.cloneNode(!0);
    r.setAttribute("timeOffset", Qe(i)), this.adPlaylist.push(new Fe(r, e.publisherSpecs)), a.debug.info(
      U.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), t = 0, i = 0;
    this.addPlayerEventListener(te.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const r = this.player.getContentCurrentTime(), s = r - t, n = (Date.now() - e) / 1e3;
      s > n + 0.075 || s > 2 ? (this.isSeeking = !0, i = 0) : i >= U.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), i = Math.min(
        i + 1,
        U.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), t = r, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener(te.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), a.debug.info(
      U.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    a.debug.info(
      U.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    ), this.eventHandlers.forEach((e) => {
      e();
    }), this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, t) {
    this.player.addEventListener(e, t);
    const i = () => this.removePlayerEventListener(e, t);
    return this.eventHandlers.push(i), i;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, t) {
    this.player.removeEventListener(e, t);
  }
};
U.NAME = "AdPlaylistCtrl::", U.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, U.STRICT_OFFSET_THRESHOLD = 2, U.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let j = U;
const Ei = "HomadXHRUrlHandler", kt = ": Response contains neither 'responseXML' nor 'responseText'", be = class be {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new be().xhrRequest();
  }
  /**
   * @internal
   * @param url
   * @param options
   * @param callback - Method that expects two parameters `xhrError` and `responseXML` (in that order!)
   *
   */
  getAsXHR(e, t, i) {
    function r(h) {
      t(h, null);
    }
    function s(h) {
      if (i.issuer && i.issuer === ce.ISSUER.TRACKING) {
        t(null, null);
        return;
      }
      let u = h.responseXML;
      if (!u && h.responseText && (u = Ot(h.responseText)), !u) {
        let N = new Error(Ei + kt);
        N.code = f.XML.INVALID_XML.code, N.description = "HOMAD Response Error" + kt, t(N, null);
        return;
      }
      t(null, u);
    }
    if (!i.adReinsertion) {
      let h = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      h.code = f.WRAPPER.TIMEOUT.code, h.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", r(h);
      return;
    }
    const n = i.adReinsertion.vendorAPI.stuffAdTag(e);
    let d = i.adReinsertion.vendorAPI.getUrlRequest(n);
    d.data.homad_macros = JSON.stringify(i.enrichment.getIABMacroList()), a.debug.info(
      be.NAME + "getAsXHR - Provide VAST Macro List" + d.data.homad_macros
    ), i.adReinsertion.vendorAPI.loadFile(d, (h) => {
      s(h);
    }, (h) => {
      let u, N = "HOMADUtils XHR";
      h.timedOut ? (u = new Error("HomadUtilsURLHandler: Request timeout."), u.code = f.WRAPPER.TIMEOUT.code, u.description = `${N} Timeout Error ${i.timeouts.errorMessage || f.WRAPPER.TIMEOUT.message}`) : (u = new Error("HomadUtilsURLHandler: " + h.statusText), u.code = f.XML.INVALID_XML.code, u.description = `${N} Status Error (${h.status}): ${h.statusText}`), r(u);
    }, !1, !1, !1, i.timeouts.adRequest * 1e3);
  }
  get(e, t, i = {}) {
    i.timeouts || (i.timeouts = xe.timeouts), a.debug.info(`${be.NAME}: Get with timeout ${i.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, t, i);
  }
};
be.NAME = "HomadUrlHandler::";
let Ze = be;
function zt(l) {
  return window.location.protocol === "https:" && !l.startsWith("http://") || window.location.protocol !== "https:";
}
function se(l, e) {
  let t = document.createElement("ParserError");
  t.setAttribute("code", e.code.toString()), t.setAttribute("message", e.message), l.appendChild(t);
}
const Ve = class Ve {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, t) {
    this.callbackLoadingDone = t, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, t) {
    if (a.debug.info(Ve.NAME + "requestURL", e), this.callbackLoadingDone = t, this.isInsecureURL(e)) {
      let i = document.createDocumentFragment();
      return se(i, f.SESSION.MIXED_CONTENT), this.returnVMAP(i);
    }
    return this.loadURL(e).then((i) => {
      this.returnVMAP(i);
    });
  }
  returnVMAP(e) {
    let t = e, i = document.createDocumentFragment();
    e.querySelectorAll("VMAP").length > 0 && e.querySelectorAll("AdBreak").length === 0 && (se(i, f.VMAP.NO_ADBREAKS), t = i), e.querySelectorAll("VMAP").length === 0 && e.querySelectorAll("ParserError").length === 0 && (se(i, f.VMAP.DOCUMENT_ERROR), t = i), this.callbackLoadingDone(t);
  }
  /** @internal */
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((t) => {
      new Ct().get(e, (i, r) => {
        if (!i && r && r.querySelector("parsererror")) {
          let s = document.createDocumentFragment();
          se(s, f.VMAP.EXTRACTION_ERROR), t(s);
        }
        if (i && !r) {
          let s = document.createDocumentFragment();
          a.debug.warn(Ve.NAME + "loadURL - XHR Request Error", i), se(s, i), t(s);
        } else
          t(r);
      }, this.urlHandlerOptions);
    });
  }
  /** @internal */
  isInsecureURL(e) {
    return this.blockInsecureURL && !zt(e);
  }
};
Ve.NAME = "VMAPReqService::";
let At = Ve;
function Qt(l) {
  if (!l || typeof l != "object")
    return !1;
  try {
    return l.self === l;
  } catch (e) {
    return !0;
  }
}
function _e(l, ...e) {
  for (const t of e)
    if (t)
      for (const i in t)
        Object.prototype.hasOwnProperty.call(t, i) && t[i] !== null && (Qt(t[i]) ? l[i] = t[i] : typeof l[i] == "object" && typeof t[i] == "object" ? l[i] = _e(l[i], t[i]) : l[i] = t[i]);
  return l;
}
function $t() {
  return this.error || null;
}
function oe(l) {
  this.error = {
    code: l.code,
    message: l.message,
    timestamp: Date.now()
  };
}
let Vt = null;
const yt = class yt extends Se {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, t) {
    super(), this.player = e, this.config = t.config, a.debug.info(j.NAME + "Create AdPlaylistAPI with", t.config), this.environmentVars = t.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = t, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, t = {}) {
    this.environmentVars = Object.assign(this.environmentVars, t), a.debug.info(j.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = _e(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let i = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const r = this.adSlotAPI.setupEnrichmentAndTCF();
    Vt = new V(this.config.adReinsertion, r);
    const s = {
      adReinsertion: Vt,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: r,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: _e({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((n, d) => {
      i = this.addEventListener(o.ON_AD_PLAYLIST_LOAD_ERROR, () => d(this.errorAPI)), this.addEventListener(o.ON_AD_PLAYLIST_LOADED, () => (i(), this.adPlaylistController = new j(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), n("ok")));
      let h = new At(
        s
      );
      e.tag ? h.requestURL(e.tag, this.onXMLLoadDone.bind(this, s)) : h.requestXML(s.response, this.onXMLLoadDone.bind(this, s));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  /**
   * @internal
   */
  onXMLLoadDone(e, t) {
    this.rawVMAPXML = t, this.adPlaylist = new di(t, this.vmapSetup);
    let i = this.adPlaylist.getAdPlaylist();
    a.debug.info(j.NAME + "onXMLLoadDone and vmap parsed.", t), a.debug.table(i);
    const r = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const s = t.querySelector("ParserError"), n = s ? {
          code: parseInt(s.getAttribute("code"), 10),
          message: s.getAttribute("message")
        } : this.error = f.VMAP.NO_ADBREAKS;
        oe.call(this, n), super.dispatchEvent(o.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(o.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      a.debug.info(
        j.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), a.debug.info(
            j.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = Ze, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            r();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (s) => {
          a.debug.info(j.NAME + "enable - AdReinsertion remains disabled.", s), oe.call(this, s), r();
        }
      );
      return;
    }
    r();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    return super.dispatchEvent(o.ON_AD_PLAYLIST_START), Object.keys(o).forEach((e) => {
      this.adPlaylistController.addEventListener(o[e], (t) => {
        super.dispatchEvent(t.type);
      });
    }), new Promise((e, t) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (i) => {
          t(i);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return $t.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
yt.NAME = "AdPlaylAPI::";
let Et = yt;
var F = /* @__PURE__ */ ((l) => (l.CLOSER = "closer", l.DIVIDER = "divider", l.OPENER = "opener", l.COMMERCIAL = "commercial", l.SPONSORED = "sponsored", l))(F || {});
class pi {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  /**
   * Does collect and summarize the duration of all commercial ads.
   * The result can change at runtime after receiving real duration values for a specific ad
   * @returns {void}
   */
  /** @internal */
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let t = this.adSlotManifest[e];
      !t.isLinear || t.variant !== F.COMMERCIAL || this.totalCommercialsDurationArray.push(t.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, t) => e + t) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, t) => e + t)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, t) => e + t);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const _ = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, ae = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, de = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, ne = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, Ue = class Ue extends a {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.eventsThatRequireResponse = [
      _.CLICK_THRU,
      _.GET_MEDIA_STATE,
      _.READY,
      _.REPORT_TRACKING,
      _.REQUEST_CHANGE_AD_DURATION,
      _.REQUEST_FULL_SCREEN,
      _.REQUEST_PAUSE,
      _.REQUEST_PLAY,
      _.REQUEST_RESIZE,
      _.REQUEST_SKIP,
      _.REQUEST_STOP,
      _.REQUEST_VIDEO_LOCATION,
      _.REQUEST_VOLUME,
      de.AD_SKIPPED,
      de.AD_STOPPED,
      de.FATAL_ERROR,
      de.INIT,
      de.START_CREATIVE,
      ne.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, t) {
    const i = this.nextMessageId++, r = e === ne.CREATE_SESSION ? e : "SIMID:" + e, s = {
      sessionId: this.sessionId,
      messageId: i,
      type: r,
      timestamp: Date.now(),
      args: t
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((n, d) => {
      this.addResolveRejectListener(i, n, d), this.target.postMessage(JSON.stringify(s), "*");
    }) : new Promise((n, d) => {
      this.target.postMessage(JSON.stringify(s), "*"), n();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, t) {
    this.listeners[e] ? this.listeners[e].push(t) : this.listeners[e] = [t];
  }
  /**
   * Sets up a listener for resolve/reject messages.
   * @internal
   */
  addResolveRejectListener(e, t, i) {
    const r = (s) => {
      const n = s.type, d = s.args.value;
      n === "resolve" && t(d), n === "reject" && i(d);
    };
    this.resolutionListeners[e] = r.bind(this);
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let t;
    try {
      t = JSON.parse(e.data);
    } catch (h) {
      return;
    }
    const i = t.sessionId, r = t.type, s = this.sessionId === "" && r === ne.CREATE_SESSION, n = this.sessionId === i;
    if (!(!(s || n) || r === null)) {
      if (Object.values(ne).includes(r))
        this.handleProtocolMessage(t);
      else if (r.startsWith("SIMID:")) {
        const h = r.substring(6), u = this.listeners[h];
        u && u.forEach((N) => {
          N(t);
        });
      }
    }
  }
  /**
   * Handles incoming messages specifically for the protocol
   * @param {!Object} data Data passed back from the message
   * @internal
   */
  handleProtocolMessage(e) {
    const t = e.type;
    switch (t) {
      case ne.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {});
        const i = this.listeners[t];
        i && i.forEach((d) => {
          d(e);
        });
        break;
      case ne.RESOLVE:
      // intentional fallthrough
      case ne.REJECT:
        const s = e.args.messageId, n = this.resolutionListeners[s];
        n && (n(e), delete this.resolutionListeners[s]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, t) {
    const i = this.nextMessageId++, r = {
      messageId: e.messageId,
      value: t
    }, s = {
      sessionId: this.sessionId,
      messageId: i,
      type: ne.RESOLVE,
      timestamp: Date.now(),
      args: r
    };
    this.target.postMessage(JSON.stringify(s), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, t) {
    const i = this.nextMessageId++, r = {
      messageId: e.messageId,
      value: t
    }, s = {
      sessionId: this.sessionId,
      messageId: i,
      type: ne.REJECT,
      timestamp: Date.now(),
      args: r
    };
    this.target.postMessage(JSON.stringify(s), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      a.debug.info(Ue.NAME + "createSession resolve");
    }, t = () => {
      a.debug.info(Ue.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(ne.CREATE_SESSION, {}).then(
      e,
      t
    );
  }
  /**
   * Sets the session ID, this should only be used on session creation.
   * @internal
   */
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let t = "", i;
    for (i = 0; i < 16; i++)
      t += (i === 4 || i === 6 || i === 8 || i === 10 ? "-" : "") + e[i].toString(16);
    this.sessionId = t;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
Ue.NAME = "SIMIDPtl::";
let pt = Ue;
function me(l, e) {
  let t = document.createElement(l);
  return Object.keys(e || {}).forEach((i) => {
    t.setAttribute(i, e[i]);
  }), t;
}
const Ge = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, Ut = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Ie = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, we = 0, ut = -2, fi = !0, J = class J {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new pt(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = we, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((t) => {
      this.resolveSessionCreatedPromise = t;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = we, this.nonLinearDimensions = null, this.initializationPromise = new Promise((t, i) => {
      this.resolveInitializationPromise = t, this.rejectInitializationPromise = i;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      a.debug.info(
        J.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = me("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  /**
   * Sets up an iframe for holding the simid element.
   *
   * @return {!Element} The iframe where the simid element lives.
   * @internal
   */
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    return a.debug.info(J.NAME + "createSimidIframe with", this.creativeAsset), e.src = this.creativeAsset.fileURL, e.style.display = "none", this.container.appendChild(e), this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  /**
   * Listens to all relevant messages from the SIMID add.
   * @internal
   */
  addListeners() {
    this.simidProtocol.addListener(ne.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(_.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(_.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(_.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(_.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(_.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(_.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(_.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      _.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(_.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(_.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(_.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(_.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(_.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  /**
   * Resolves the session created promise.
   * @internal
   */
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  /**
   * Destroys the existing simid iframe.
   * @internal
   */
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, t] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, t);
    this.videoTrackingEvents.clear();
  }
  /**
   * Returns the full dimensions of an element within the player div.
   * @internal
   * @return {!Object}
   */
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  /**
   * Checks whether the input dimensions are valid and fit in the player window.
   * @internal
   * @param {!Object} dimensions A dimension that contains x, y, width & height fields.
   * @return {boolean}
   */
  isValidDimensions(e) {
    const t = this.playerFacade.getPlayerSize().boundingRect, i = parseInt(e.y, 10) + parseInt(e.height, 10) <= t.height, r = parseInt(e.x, 10) + parseInt(e.width, 10) <= t.width;
    return i && r;
  }
  /**
   * Returns the specified dimensions of the non-linear creative.
   * @internal
   * @return {!Object}
   */
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  /**
   * Validates and displays the non-linear creative.
   * @internal
   */
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      a.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  /**
   * Changes the simid iframe dimensions to the given dimensions.
   * @internal
   * @param {!Object} resizeDimensions A dimension that contains an x,y,width & height fields.
   */
  setIFrameDimensions(e) {
    a.debug.info(J.NAME + "resize", e), this.IFrame.style.height = e.height, this.IFrame.style.width = e.width, this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(o.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, t) {
    this.simidProtocol.reject(e, t);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const t = {
        errorCode: Ge.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, t), a.debug.info(t.message);
    } else {
      const t = this.getFullDimensions();
      this.setIFrameDimensions(t), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const t = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const i = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, i), a.debug.info(i.message);
    } else if (this.isValidDimensions(t))
      this.setIFrameDimensions(t), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const i = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, i), a.debug.info(i.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let t = "onRequestResize - error:";
    if (this.isLinearAd) {
      const i = {
        errorCode: Ge.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), a.debug.error(J.NAME + t, i.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const i = {
        errorCode: Ge.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, i), a.debug.error(J.NAME + t, i.message);
    }
  }
  /**
   * Initializes the SIMID creative with all data it needs.
   * @internal
   */
  sendInitMessage() {
    const e = this.getFullDimensions(), t = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), i = {
      videoDimensions: e,
      creativeDimensions: t,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, r = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (r.duration = this.currentAd.duration);
    const s = {
      environmentData: i,
      creativeData: r
    };
    this.simidProtocol.sendMessage(de.INIT, s).then((d) => {
      this.resolveInitializationPromise(d), a.debug.info(J.NAME + "session created");
    }).catch((d) => {
      this.rejectInitializationPromise(d);
    });
  }
  /**
   * Called once the creative responds positively to being initialized.
   * @internal
   */
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(o.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), a.debug.info(J.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(de.START_CREATIVE);
  }
  /**
   * Pauses content video and plays linear ad.
   * @internal
   */
  /**
   * Called if the creative responds with reject after the player
   * initializes the ad.
   * @param {!Object} data
   * @internal
   */
  onAdInitializedFailed(e) {
    this.setError(f.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(o.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), a.debug.error(J.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  /** @internal */
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  /** @internal */
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  /**
   * Disables or enables stop, skip, and fatal error buttons
   *  depending on if the ad is showing.
   * @internal
   * @param {boolean} controlState If buttons should be disabled or enabled
   */
  setCreativeControlsState(e) {
    document.querySelectorAll(".ad_request").forEach((i) => {
      i.disabled = e;
    });
  }
  /**
   * Tracks the events on the ad video element specified by the simid spec
   * @internal
   */
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        ae.ERROR,
        {
          error: f.SIMID.GENERAL_ERROR.code,
          message: f.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = f.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(ae.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(ae.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(ae.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(ae.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(ae.SEEKING);
    }), this.videoTrackingEvents.set(te.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        ae.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        ae.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Ie.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        ae.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, t] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, t);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Ie.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(de.AD_STOPPED).then(() => {
      a.debug.info(J.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(de.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(o.ON_AD_SKIPPED), this.loadedSource = null;
  }
  /**
   * Removes the simid ad entirely and resumes video playback.
   * @internal
   */
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(fi), this.adSlotController.dispatchEvent(o.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    a.debug.info(J.NAME + "onReqFullScreen", e);
    let t;
    this.IFrame && (t = this.IFrame.mozRequestFullScreen || this.IFrame.msRequestFullscreen || this.IFrame.requestFullscreen || this.IFrame.webkitRequestFullscreen);
    let i = t == null ? void 0 : t();
    i ? i.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const t = {
          errorCode: Ut.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, t);
      });
    } else {
      const t = {
        errorCode: Ge.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, t);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Ie.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Ie.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const t = e.args.trackingUrls;
    a.debug.info(J.NAME + "onReportTracking -  Creative has asked the player to send a ping."), a.debug.table(t);
  }
  /**
   * Called when video playback is complete.
   * @internal
   */
  videoComplete() {
    if (this.simidProtocol.sendMessage(ae.ENDED), this.requestedDuration === we && this.stopAd(Ie.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== we && this.requestedDuration !== ut) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Ie.CREATIVE_INITIATED);
      }, e);
    }
  }
  /**
   * Called when creative requests a change in duration of ad.
   * @internal
   */
  onReqChangeAdDuration(e) {
    const t = e.args.duration;
    if (t !== ut && t < 0) {
      const i = {
        errorCode: Ut.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, i);
    } else
      this.requestedDuration = t, this.compareAdAndReqDurations(), this.resolve(e);
  }
  /**
   * Compares the duration of the ad with the requested change duration.
   * If request duration is the same as the ad duration, ad ends as normal.
   * If request duration is unlimited, ad stays on screen until user closes ad.
   * If request duration is shorter, the ad stops early.
   * @internal
   */
  compareAdAndReqDurations() {
    this.requestedDuration === we || this.requestedDuration === ut || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (a.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Ie.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const t = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, t);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const t = {
      message: e
    };
    this.simidProtocol.sendMessage(de.LOG, t);
  }
};
J.NAME = "SIMIDPly::";
let ft = J;
function Ft(l) {
  return l.height >= 0 ? l.y + l.height : l.y;
}
function xt(l) {
  return l.width >= 0 ? l.x : l.x + l.width;
}
function qt(l) {
  return l.width >= 0 ? l.x + l.width : l.x;
}
function Ht(l) {
  return l.height >= 0 ? l.y : l.y + l.height;
}
function mi(l, e) {
  let t = 0, i = {
    bottom: Math.min(Ft(l), Ft(e)),
    height: 0,
    left: Math.max(xt(l), xt(e)),
    right: Math.min(qt(l), qt(e)),
    top: Math.max(Ht(l), Ht(e)),
    width: 0
  };
  i.width = i.right - i.left, i.height = i.bottom - i.top;
  let r = l.width * l.height, s = i.width * i.height;
  return s > 0 && (t = s / r), t;
}
class gi {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   * @param {Object} playerFacade to get rectangle over size function from player and viewport
   */
  constructor(e, t) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.playerFacade = t, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners(), Object.keys(o).forEach((e) => {
      let t = this.adSlotController.addEventListener(o[e], this.handleAdEvent.bind(this));
      this.removeEventHandlers.push(t);
    });
  }
  removeEventListeners() {
    this.removeEventHandlers.forEach((e) => {
      e();
    }), this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case o.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case o.ON_AD_PLAYING:
      case o.ON_AD_STARTED:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case o.ON_AD_PLAYBACK_FINISHED:
      case o.ON_AD_SKIPPED:
      case o.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(o.ON_AD_NOT_VIEWABLE)), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.playerFacade.getPlayerSize(), t = this.playerFacade.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || t.boundingRect.height === 0 && t.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(o.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let i = mi(e.boundingRect, t.boundingRect) * 100;
    i > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: i
    }, this.adSlotController.dispatchEvent(o.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (a.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(o.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: i
    }, this.adSlotController.dispatchEvent(o.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function Si(l, e, t) {
  return new Promise((i) => {
    let r = me("iframe", {
      id: l,
      style: e
    });
    r.onload = () => {
      let s = me("script", {
        type: "text/javascript"
      });
      s.innerHTML = "var inDapIF = true;", r.contentDocument.body.appendChild(s);
      let n = me("style", {});
      n.innerHTML = "html,body{margin:0;}", r.contentDocument.body.appendChild(n), i(r);
    }, t.insertBefore(r, t.firstChild);
  });
}
const v = class v extends Se {
  // ms
  constructor(e, t) {
    super(), this.callbacks = null, this.currentAd = t, this.config = t.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = a.logLevel === he.NORMAL || a.logLevel === he.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = t.isLinear ? t.properCreative.selectedMediaFile : t.properCreative.variations[0], this.slot = me("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), Si(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((i) => {
      this.friendlyIFrame = i, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = me("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = me("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = me("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      a.debug.warn(v.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = f.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest, "");
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), a.debug.info(
      v.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (a.debug.info(v.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", t = parseInt(e.split(".")[0], 10);
      return a.debug.info(
        v.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        t
      ), a.debug.info(
        v.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), t <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), a.debug.info(
      v.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), a.debug.info(
      v.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    a.debug.info(v.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = f.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest, "");
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    a.debug.info(v.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = f.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness, "");
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, a.debug.info(v.NAME + "cleanup"), this.dispatchEvent(o.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    a.debug.info(v.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(o.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    a.debug.info(v.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    a.debug.info(v.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    a.debug.info(v.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, t, i) {
    a.debug.info(v.NAME + "resizeAd", e, t, i), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, t, i);
  }
  onStartAd() {
    a.debug.info(v.NAME + "onStartAd"), this.dispatchEvent(o.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression(e, t, i) {
    a.debug.info(v.NAME + "onAdImpression", e, t, i), this.dispatchEvent(o.ON_AD_IMPRESSION);
  }
  onAdVideoStart(e, t, i) {
    a.debug.info(v.NAME + "onAdVideoStart", e, t, i), this.dispatchEvent(o.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), v.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (a.debug.warn(v.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, v.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile(e, t, i) {
    a.debug.info(v.NAME + "onAdVideoFirstQuartile", e, t, i), this.dispatchEvent(o.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint(e, t, i) {
    a.debug.info(v.NAME + "onAdVideoMidpoint", e, t, i), this.dispatchEvent(o.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile(e, t, i) {
    a.debug.info(v.NAME + "onAdVideoThirdQuartile", e, t, i), this.dispatchEvent(o.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete(e, t, i) {
    a.debug.info(v.NAME + "onAdVideoComplete", e, t, i), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.currentAd.playbackComplete = !0, this.dispatchEvent(o.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange(e, t, i) {
    a.debug.info(v.NAME + "onAdDurationChange", e, t, i), this.getAllProperties();
  }
  onStopAd(e, t, i) {
    a.debug.info(v.NAME + "::onStopAd()", e, t, i), this.dispatchEvent(o.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, t, i) {
    a.debug.info(v.NAME + "onAdError", e, t, i), this.currentAd.error = this.currentAd.error === null ? f.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(o.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd(e, t, i) {
    this.dispatchEvent(o.ON_AD_SKIPPED), a.debug.info(v.NAME + "onSkipAd", e, t, i), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(o.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && a.debug.info(
      v.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(o.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange(e, t, i) {
    a.debug.info(v.NAME + "onAdExpandedChange", e, t, i);
  }
  onAdSkippableStateChange(e, t, i) {
    a.debug.info(v.NAME + "onAdSkippableStateChange", e, t, i), this.dispatchEvent(o.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(o.ON_AD_PROGRESS);
  }
  onAdVolumeChange(e, t, i) {
    a.debug.info(v.NAME + "onAdVolumeChange", e, t, i);
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, t = null, i = !1) {
    a.debug.info(v.NAME + "onAdClickThru - creative handles click", !i), i === !0 && (a.debug.info(v.NAME + "onAdClickThru - open landing page", e, t), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = i), this.dispatchEvent(o.ON_AD_CLICKED);
  }
  onAdInteraction(e, t, i) {
    a.debug.info(v.NAME + "onAdInteraction", e, t, i);
  }
  onAdUserAcceptInvitation(e, t, i) {
    a.debug.info(v.NAME + "onAdUserAcceptInvitation", e, t, i);
  }
  onAdUserMinimize(e, t, i) {
    a.debug.info(v.NAME + "onAdUserMinimize", e, t, i);
  }
  onAdUserClose(e, t, i) {
    a.debug.info(v.NAME + "onAdUserClose", e, t, i);
  }
  onAdPaused(e, t, i) {
    a.debug.info(v.NAME + "onAdPaused", e, t, i);
  }
  onAdPlaying(e, t, i) {
    a.debug.info(v.NAME + "onAdPlaying", e, t, i), this.dispatchEvent(o.ON_AD_PLAYING);
  }
  onAdLog(e, t, i) {
    a.debug.info(v.NAME + "onAdLog", e, t, i);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let t in e)
      e.hasOwnProperty(t) && e[t].indexOf("getAd") === 0 && a.debug.info(
        v.NAME + "--vpaidAd." + e[t] + "()",
        this.vpaidAd[e[t]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, t, i) => {
      t === 0 ? e.delta = 0 : e.delta = i[t].time - i[t - 1].time;
    }), a.debug.table(this.debugTiming));
  }
  //Debug -- End
};
v.NAME = "VPAIDBridge::", v.TIMEUPDATE_INTERVAL = 250;
let mt = v;
const He = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  VPAID: "application/javascript",
  SIMID: "text/html",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, ee = class ee extends Se {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {PlayerFacade} player
   */
  constructor(e, t, i, r) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = ee.VIEW_MODE.NORMAL, this.environmentVars = i, this.eventCallbacks = [], this.eventKeys = Object.keys(o), this.eventTypes = Object.values(o), this.nonLinearView = null, this.player = r, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, t);
  }
  prepare(e, t) {
    this.manifest = e.slice(0), this.buffet = (t || []).slice(0), this.adSlotTimes = new pi(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource.fileURL), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(He)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [F.COMMERCIAL, F.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new gi(this, this.player));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    if (this.eventCallbacks.forEach((t) => {
      t();
    }), this.eventCallbacks = [], Object.keys(o).forEach((t) => {
      const i = this.addEventListener(o[t], (r) => {
        this.trackEvent(r.type);
      });
      this.eventCallbacks.push(i);
    }), this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let t = null;
      const i = new Promise((s) => {
        t = setTimeout(s, 250, null);
      }), r = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[r].length) {
        let s = this.currentAd.isLinear ? this.currentAd.properCreative[r] : this.currentAd.properCreative[r][0].resources;
        const n = this.currentAd.config.adSourceSelector(
          s
        ).then((d) => d === null || Object.keys(d).length === 0 ? null : d);
        Promise.race([i, n]).then((d) => {
          d === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = d : this.currentAd.properCreative.selectedResource = d, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(t), this.cancelAd();
    } else {
      this.updateAdSettings();
      const t = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, t);
    }
    const e = this.addEventListener(o.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, a.debug.info(ee.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === F.COMMERCIAL) {
        let t = e.duration;
        this.currentAd.isLinear || (t += this.currentAd.duration), a.debug.info(
          ee.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          t
        ), this.adSlotTimes.setTotalCommercialsDuration(t), this.setTotalCommercialsDuration(), a.debug.info(ee.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      a.debug.info(ee.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const t = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let i = this.currentAd;
    new qe().track(e, (r, s) => {
      s && (a.debug.warn(ee.NAME + "callTrackers failed:", s, r), i.error = s.code ? s : f.WARNING.TRACKER_LOAD_FAILED, i.error.message = `${i.error.message}: ${JSON.stringify(r)}`, this.dispatchEvent(o.ON_AD_WARNING));
    }, t);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === w.NON_LINEAR) {
      this.currentAd.error = f.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(o.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = f.VAST.UNSUPPORTED_MIMETYPE), a.debug.info(ee.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(o.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(o.ON_AD_CLICKED);
    let t = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (t && t.indexOf("//") === 0 && (t = Je(t, "")), !e) {
      const i = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(t, i);
    }
    return t;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let t = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(t);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(o.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, t) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let i = this.currentAd.adVerifications.filter((n) => n.vendor === e)[0];
      if (!i || !i.tracking.verificationNotExecuted)
        return;
      let r = i.tracking.verificationNotExecuted, s = parseInt(t, 10);
      t && isFinite(s) && s >= 1 && s <= 3 && this.currentAd.enrichment.set("REASON", s), r && r.length > 0 && this.callTrackers(r);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === F.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      a.debug.info(ee.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(o.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(o.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(o.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, t) {
    if (!this.currentAd.icons[e])
      return null;
    let i = this.currentAd.icons[e].clickTracker;
    this.callTrackers(i);
    let r = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!t) {
      const s = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(r, s);
    }
    return r;
  }
  onResizeAd(e, t) {
    this.currentAd && (t !== this.currentViewMode && (this.currentViewMode = t, t === ee.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(o.ON_ENTER_FULLSCREEN), this.dispatchEvent(o.ON_PLAYER_EXPAND)) : (this.dispatchEvent(o.ON_EXIT_FULLSCREEN), this.dispatchEvent(o.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, t) : this.dispatchEvent(o.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === F.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(o.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", Qe(e)), this.currentAd.variant === F.COMMERCIAL) {
        const t = this.adDuration - this.currentAd.duration;
        if (t && Number.isFinite(t)) {
          let i = t;
          this.currentAd.isLinear || (i = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(i);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [F.COMMERCIAL, F.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((r) => {
          let s = r.offset;
          s.indexOf("%") > -1 && (s = parseInt(s, 10) / 100 * this.adDuration), e >= parseInt(s, 10) && !r.requested && this.dispatchEvent(o.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let t = [], i = [];
        e >= this.adDuration && t.push(o.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && t.push(o.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && t.push(o.ON_AD_MID_POINT), e >= this.adDuration / 4 && t.push(o.ON_AD_FIRST_QUARTILE), e && t.push(o.ON_AD_PLAYBACK_START), i.push(t[0]), this.currentAd.config.trackSkippedQuartiles && (i = t);
        for (let r = i.length - 1; r >= 0; r--)
          this.requestedTrackingEvents.filter((n) => n === i[r]).shift() || (this.dispatchEvent(i[r]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(i[r]));
      }
    }
  }
  trackEvent(e) {
    const t = this.eventKeys[this.eventTypes.indexOf(e)], i = ye[t], r = this.player.getAdCurrentTime(), s = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[i]) {
      let n = this.currentAd.trackingEvents[i];
      e === o.ON_AD_PROGRESS && (n = n.filter((d) => {
        let h = d.offset;
        return h.indexOf("%") > -1 && (h = parseInt(h, 10) / 100 * s), r >= parseInt(h, 10) && !d.requested;
      })), this.callTrackers(n);
    }
  }
  loadAdSIMID() {
    this.simidPlayer = new ft(this), this.simidPlayer.initializeAd();
  }
  loadAdVPAID() {
    this.vpaidPlayer = new mt(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      o.ON_AD_CLICKED,
      o.ON_AD_LOADED,
      o.ON_AD_STARTED,
      o.ON_AD_IMPRESSION,
      o.ON_AD_PLAYING,
      o.ON_AD_PLAYBACK_START,
      o.ON_AD_FIRST_QUARTILE,
      o.ON_AD_MID_POINT,
      o.ON_AD_THIRD_QUARTILE,
      o.ON_AD_PLAYBACK_FINISHED,
      o.ON_AD_STOPPED,
      o.ON_AD_SKIPPED,
      o.ON_AD_ERROR,
      o.ON_AD_PROGRESS,
      o.ON_AD_SIZE_CHANGED,
      o.ON_AD_SKIPPABLE_STATE_CHANGE,
      o.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (t) => this.vpaidEventHandler(t));
      }
    ) : [
      o.ON_AD_LINEARITY_CHANGE,
      o.ON_AD_SKIPPED,
      o.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (t) => this.nonLinearVpaidEventHandler(t));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case o.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (a.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case o.ON_AD_SKIPPED:
        case o.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let t;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case o.ON_AD_LOADED:
      //onStartAd
      case o.ON_AD_STARTED:
      //onStartAd
      case o.ON_AD_IMPRESSION:
      case o.ON_AD_PLAYING:
      //onAdPlaying()
      case o.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case o.ON_AD_FIRST_QUARTILE:
      case o.ON_AD_MID_POINT:
      case o.ON_AD_THIRD_QUARTILE:
      case o.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case o.ON_AD_CLICKED:
        t = !this.currentAd.handleClickThrough, this.onClickThrough(t);
        break;
      case o.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case o.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case o.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case o.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case o.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case o.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case o.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    a.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
ee.NAME = "AdSloCtrl::", ee.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let gt = ee;
const Ye = {
  ERROR_RESOURCE_REJECTED: 1,
  // or OM disabled by publisher
  ERROR_VERIFICATION_NOT_SUPPORTED: 2
}, P = class P {
  // TODO: Possible to make a currentAdRuntime interface?
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, t) {
    if (this.ad = e, this.adSlotDelivery = t, this.sessionClient = OmidSessionClient.OmidSessionClient, this.removeEventHandlers = [], this.video = t.player.getPlayerElement(), !this.sessionClient) {
      a.debug.warn(P.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = t.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      a.debug.info(
        P.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (a.debug.info(
      P.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), a.debug.table(this.verifications), this.internalOmidConfig.disabled) {
      a.debug.warn(
        P.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
      ), this.verifications.forEach((i) => {
        this.trackError(
          i.tracking.verificationNotExecuted,
          Ye.ERROR_RESOURCE_REJECTED
        );
      });
      return;
    }
    if (this.internalOmidConfig.playerHandles) {
      a.debug.info(P.NAME + "playerHandles is true");
      return;
    }
    if (e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      a.debug.info(
        P.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      P.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  /**
   * Filters ad verifications based on the vendor whitelist.
   *
   * @param {Array} adVerifications - An array of ad verifications to be filtered.
   * @param {Array} vendorAllowList - An array of allowed vendors.
   * @return {Array} The filtered ad verifications.
   */
  /** @internal */
  filterVerifications(e, t) {
    return !e || e.length === 0 ? e : e.filter((i) => {
      const r = !t || t.length === 0 || t.includes(i.vendor);
      if (!r)
        return this.trackError(i.tracking.verificationNotExecuted, Ye.ERROR_RESOURCE_REJECTED), !1;
      if (t)
        return !0;
      const s = i.javascriptResource ? i.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !t && !s ? (r && this.trackError(
        i.tracking.verificationNotExecuted,
        Ye.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  /** @internal */
  initOMIDJS() {
    if (this.adSession = this.createAdSession(), this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? P.IMPRESSION_TYPE.RENDER : P.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), a.debug.info(P.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return a.debug.error(P.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((t) => {
        this.trackError(
          t.tracking.verificationNotExecuted,
          Ye.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const e = () => {
      const t = this.createVastProperties();
      this.adEvents.loaded(t), this.video.removeEventListener("canplaythrough", e);
    };
    return this.video.addEventListener("canplaythrough", e), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  /** @internal */
  createAdSession() {
    let e = new this.sessionClient.Partner(P.PARTNER_NAME, P.PARTNER_VERSION), t = this.verifications.map((r) => (a.debug.info(
      P.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      Je(r.javascriptResource.url, r.javascriptResource.url),
      "vendor:",
      r.vendor,
      "verification params:",
      r.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      Je(r.javascriptResource.url, r.javascriptResource.url),
      r.vendor,
      r.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), i = new this.sessionClient.Context(e, t, this.CONTENT_URL);
    return i.underEvaluation = !0, i.setVideoElement(this.video), i.setServiceWindow(this.OMSDK_SERVICE_WINDOW), i.supportsLoadedEvent = !0, new this.sessionClient.AdSession(i);
  }
  addEventListeners() {
    this.removeEventListeners(), Object.keys(o).forEach((e) => {
      let t = this.adSlotDelivery.adSlotController.addEventListener(
        o[e],
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(t);
    });
  }
  /** @internal */
  removeEventListeners() {
    this.removeEventHandlers.forEach((e) => {
      e();
    }), this.removeEventHandlers = [];
  }
  /** @internal */
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case o.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), a.debug.info(P.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case o.ON_AD_SKIPPED:
      case o.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          a.debug.info(P.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  /** @internal */
  forwardEventToOMSDK(e) {
    let t = "forwardEventToOMSDK";
    if (a.debug.info(P.NAME + t, e), !this.adEvents) {
      a.debug.warn(P.NAME + t + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let i;
    switch (e) {
      case o.ON_AD_STARTED:
        i = this.createVastProperties(), this.adEvents.start(i);
        break;
      case o.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case o.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case o.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case o.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case o.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case o.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case o.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case o.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case o.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case o.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case o.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case o.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case o.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case o.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case o.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  /** @internal */
  trackError(e, t) {
    a.debug.info(
      P.NAME + "trackError - errorReason",
      t,
      "errorTracker",
      e
    ), this.ad.enrichment.set("REASON", t, "reason");
    const i = {
      adReinsertion: this.ad.adReinsertion,
      enrichment: this.ad.enrichment,
      timeouts: this.ad.config.timeouts,
      urlhandler: this.ad.config.urlhandler
    };
    new qe().track(e, null, i);
  }
};
P.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, P.PARTNER_NAME = "Smartcliptv", P.PARTNER_VERSION = "7.5.6", P.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], P.NAME = "OMID::";
let St = P;
const fe = class fe extends Se {
  constructor(e, t) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = t, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((t) => {
      this.render(), t();
    });
  }
  /** @internal */
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  /**
   * Defines the container that surrounds the advertiser's asset, depending on the resource type.
   * - the ad has to appear in the upper centered position
   * - the container holds tracking and interaction data
   * @internal
   * @returns {void}
   */
  /** @internal */
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  /** @internal */
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case "StaticResource":
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let t = document.createElement(e);
    for (let i in this.ad.attributes)
      this.ad.attributes[i] && t.setAttribute(i, this.ad.attributes[i]);
    t.style.pointerEvents = "auto", t.onload = this.onStartAd.bind(this), e === "iframe" ? (t.style.border = "0", t.setAttribute("scrolling", "no"), t.setAttribute("margin", "0"), t.setAttribute("allowtransparency", "true")) : (t.style.cursor = "pointer", t.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(t), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    this.cleanupTimer.forEach((e) => {
      clearTimeout(e);
    }), this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    a.debug.info(fe.NAME + "pause"), this.cleanupTimer.forEach((e) => {
      clearTimeout(e);
    }), this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    a.debug.info(fe.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    a.debug.info(fe.NAME + "play - remove ad in", e, "seconds.");
    const t = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(t);
  }
  onStartAd() {
    a.debug.info(fe.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(o.ON_AD_LOADED), this.dispatchEvent(o.ON_AD_STARTED), this.dispatchEvent(o.ON_AD_IMPRESSION), this.dispatchEvent(o.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    a.debug.info(fe.NAME + "onStopAd"), this.dispatchEvent(o.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(o.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
fe.NAME = "NonLinear::";
let Tt = fe;
const le = class le extends Se {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, t, i) {
    super(), this.adSlotController = i, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = t;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, t) {
    return this.adSlotController.addEventListener(e, t);
  }
  addPlayerEventListener(e, t) {
    this.player.addEventListener(e, t);
    const i = () => this.removePlayerEventListener(e, t);
    return this.eventCallbacks.push(i), () => this.player.removeEventListener(e, t);
  }
  removePlayerEventListener(e, t) {
    this.player.removeEventListener(e, t);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        a.debug.info(
          le.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const i = () => {
          this.currentAd.replaced ? (t(), this.deliverNextAd()) : (u(), this.cleanAndDeliveryNextAd());
        }, r = () => {
          this.saveStartVolumeVPAID();
        }, s = () => {
          this.adSlotController.applyBuffetAd();
        }, n = this.getRemoveHandlerForAdSlotControllerEvent(
          o.ON_AD_STARTED,
          r
        ), d = this.getRemoveHandlerForAdSlotControllerEvent(
          o.ON_AD_ERROR,
          s
        ), h = this.getRemoveHandlerForAdSlotControllerEvent(
          o.ON_VPAID_CLEANUP,
          i
        ), u = () => {
          n(), d(), h();
        };
      }
    }, t = this.getRemoveHandlerForAdSlotControllerEvent(
      o.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, t) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, t);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener(te.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener(te.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(o.ON_AD_PAUSED);
    }), this.addPlayerEventListener(te.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(o.ON_AD_PLAYING);
    }), this.addPlayerEventListener(te.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(o.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(o.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(o.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(o.ON_AD_START, this.saveStartVolume), super.addEventListener(o.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener(te.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(o.ON_AD_STOPPED), a.debug.info(le.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener(te.ON_ERROR, () => {
      a.debug.info(
        le.NAME + "on - Player sent error event"
      );
    });
  }
  /** @internal */
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  /** @internal */
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => (this.adSlotHasStarted && (this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(o.ON_AD_SLOT_STOPPED)), this.eventCallbacks.forEach((t) => {
      t();
    }), this.eventCallbacks = []), e()));
  }
  deliverNextAd() {
    var i;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), a.debug.info(le.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function t() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(o.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const r = e.currentAd.config.trackImpressionOnStart ? o.ON_AD_PLAYBACK_START : o.ON_AD_STARTED;
        e.removeImpressionOnStartHandler = e.addEventListener(r, () => {
          e.adSlotController.dispatchEvent(o.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(o.ON_AD_CREATIVE_VIEW);
        });
        let s = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(s);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(o.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (i = e.currentAd) != null && i.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : t();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  /** @internal */
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((t) => t.type === "companion" && t.hasCompanionResources);
    e && e.length > 0 && this.dispatchEvent(o.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(o.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(o.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(o.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.config.adVerification.disabled || new St(this.currentAd, this), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0 && this.dispatchEvent(o.ON_VERIFICATION_DETECTED);
  }
  /** @internal */
  activateHOMAD(e, t) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: t,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(o.ON_AD_ERROR)), V.EventDispatcher.dispatchEvent(o.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let t = "Load MediaFile ", i = e.fileURL, r = !1;
      clearTimeout(this.loadPendingTimeout);
      let s = (n) => {
        r = !0, a.debug.error("VideoProxy load timeout.", n), this.currentAd.error = f.VAST.TIMEOUT, this.deliverOrHOMAD(V.REASON.MEDIAFILE_TIMEOUT, i);
      };
      this.loadPendingTimeout = setTimeout(
        s.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), a.debug.info(le.NAME + t + "from URI", i), this.player.load(i, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && (a.debug.info(le.NAME + t + "success."), this.adSlotController.dispatchEvent(o.ON_AD_LOADED), this.dispatchEvent(o.ON_AD_STARTED));
      }, (n) => {
        if (clearTimeout(this.loadPendingTimeout), r)
          return;
        a.debug.error(le.NAME + t + "failed", n);
        const d = {
          [f.VAST.GENERAL_ERROR.code]: f.VAST.GENERAL_ERROR,
          [f.VAST.FILE_NOT_FOUND.code]: f.VAST.FILE_NOT_FOUND,
          [f.VAST.UNSUPPORTED_MIMETYPE.code]: f.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = d[n] || f.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(V.REASON.MEDIAFILE_LOAD_ERROR, i);
      });
    } else {
      let t, i = !1, r = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener(te.ON_LOADED_DATA, () => {
          this.dispatchEvent(o.ON_AD_STARTED), this.dispatchEvent(o.ON_AD_IMPRESSION), this.dispatchEvent(o.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener(te.ON_ENDED, () => {
          this.dispatchEvent(o.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(o.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((s) => {
        i = !0, a.debug.error(r + " timeout.", s), this.currentAd.error = f.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(o.ON_AD_ERROR), this.deliverOrHOMAD(V.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (a.debug.info(
        r + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), t = this.adSlotController.environmentVars.adContainer) : (a.debug.warn(r + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), t = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new Tt(this, t), [
        o.ON_AD_STARTED,
        o.ON_AD_IMPRESSION,
        o.ON_AD_CREATIVE_VIEW,
        o.ON_AD_NONLINEAR_STOPPED,
        o.ON_AD_STOPPED
      ].map((s) => {
        const n = this.adSlotController.nonLinearView.addEventListener(
          s,
          (d) => {
            this.dispatchEvent(d.type), d.type === o.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(n);
      }), this.addPlayerEventListener(te.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener(te.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !i && a.debug.info(r + "Request complete");
      }, (s) => {
        clearTimeout(this.loadPendingTimeout), !i && (a.debug.error("loadAd - VideoProxy load failed", s), this.currentAd.error = f.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(o.ON_AD_ERROR), this.deliverOrHOMAD(V.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
le.NAME = "AdSloDel::";
let vt = le;
class Dt {
  getResources() {
    return this.resources;
  }
  constructor(e, t) {
    var i, r, s, n;
    this.adParameters = ((r = (i = t.querySelector("AdParameters")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || null, this.apiFramework = t.getAttribute("apiFramework") || null, this.clickThroughURL = ((n = (s = t.querySelector(e + "ClickThrough")) == null ? void 0 : s.textContent) == null ? void 0 : n.trim()) || null, this.clickTracker = this.getClickTracker(e, t), this.resources = this.parseResources(t);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let t = [], i = e.querySelectorAll(
      "HTMLResource, IFrameResource, StaticResource"
    );
    for (let r = 0; r < i.length; r++)
      t.push({
        creativeType: i[r].getAttribute("creativeType"),
        resource: O.trim(i[r].textContent || ""),
        type: i[r].nodeName
      });
    return t;
  }
  getClickTracker(e, t) {
    let i = [];
    return [].slice.call(t.querySelectorAll(e + "ClickTracking")).forEach((r) => {
      i.push({
        url: O.trim(r.textContent),
        id: r.getAttribute("id")
      });
    }), i;
  }
}
class Ti extends Dt {
  constructor(e, t, i) {
    var r;
    super(e, i), this.adSlotId = i.getAttribute("adSlotId") || "", this.altText = O.trim(((r = i.querySelector("AltText")) == null ? void 0 : r.textContent) || ""), this.assetHeight = i.getAttribute("assetHeight") || "", this.assetWidth = i.getAttribute("assetWidth") || "", this.companionXML = i, this.creativeViewTracker = t, this.expandedHeight = i.getAttribute("expandedHeight") || "", this.expandedWidth = i.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = i.getAttribute("height"), this.id = i.getAttribute("id") || Yt(), this.pxratio = i.getAttribute("pxratio") || "1", this.renderingMode = i.getAttribute("renderingMode") || "default", this.width = i.getAttribute("width");
  }
}
function q(l, e) {
  const t = (l == null ? void 0 : l.getAttribute(e)) || -1;
  let i = -1;
  return typeof t == "string" && (i = parseInt(t, 10)), isNaN(t) ? -1 : i;
}
class vi extends Dt {
  constructor(e, t, i) {
    var r;
    super(e, i), this.altText = O.trim(((r = i.querySelector("AltText")) == null ? void 0 : r.textContent) || ""), this.creativeViewTracker = t, this.duration = q(i, "duration"), this.hasCreative = super.getResources().length > 0, this.height = O.trim(i.getAttribute("height")), this.hoverText = i.getAttribute("hoverText") || null, this.offset = O.convertTimeStringToSeconds(i.getAttribute("offset")), this.program = i.getAttribute("program") || "unknown", this.pxratio = q(i, "pxratio"), this.width = i.getAttribute("width"), this.xPosition = i.getAttribute("xPosition"), this.yPosition = i.getAttribute("yPosition");
  }
}
class Ri extends Dt {
  constructor(e, t, i) {
    const r = q(i, "expandedHeight"), s = q(i, "expandedWidth"), n = q(i, "height"), d = i.getAttribute("id"), h = i.getAttribute("maintainAspectRatio") !== "false", u = O.convertTimeStringToSeconds(
      i.getAttribute("minSuggestedDuration")
    ), N = i.getAttribute("scalable") !== "false", x = q(i, "width");
    super(e, i), this.creativeTrackers = t, this.displayDuration = null, this.expandedHeight = r, this.expandedWidth = s, this.height = n, this.id = d, this.maintainAspectRatio = h, this.minSuggestedDuration = u != null ? u : -1, this.scalable = N, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = x;
  }
}
var Be = ((l) => (l.COMPANION = "companion", l[l.LINEAR = w.LINEAR] = "LINEAR", l[l.NON_LINEAR = w.NON_LINEAR] = "NON_LINEAR", l))(Be || {});
class Ni {
  constructor(e) {
    this.adXML = e, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, t = this.companion, i = e.mediaFiles.interactive, r = this.nonLinearCreative, s = e.mediaFiles.streaming, n = e.mediaFiles.vpaid, d = [];
    return d = d.concat(
      ...n,
      ...s,
      ...i,
      ...r,
      ...t
    ), d;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  /** @internal */
  getLinear() {
    let e = this.adXML.querySelector("InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), t = e.querySelector("MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(t),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getVPAIDCreatives(e) {
    var s;
    let t = [], i = e.querySelectorAll('MediaFile[apiFramework="VPAID"]'), r = e.querySelector("AdParameters");
    for (let n = 0; n < i.length; n++)
      t.push({
        adParameters: ((s = r == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null,
        apiFramework: "VPAID",
        bitrate: q(i[n], "bitrate"),
        fileURL: O.trim(i[n].textContent),
        height: q(i[n], "height"),
        linearity: w.LINEAR,
        mimeType: i[n].getAttribute("type"),
        width: q(i[n], "width")
      });
    return t;
  }
  getStreamingCreatives(e) {
    let t = [], i = e.querySelectorAll('MediaFile:not([apiFramework="VPAID"])');
    for (let r = 0; r < i.length; r++)
      t.push({
        apiFramework: i[r].getAttribute("apiFramework"),
        bitrate: q(i[r], "bitrate"),
        fileURL: O.trim(i[r].textContent),
        height: q(i[r], "height"),
        linearity: w.LINEAR,
        mimeType: i[r].getAttribute("type"),
        width: q(i[r], "width")
      });
    return t;
  }
  getInteractiveCreatives(e) {
    var s;
    const t = [], i = e.querySelectorAll("InteractiveCreativeFile"), r = e.querySelector("AdParameters");
    for (let n = 0; n < i.length; n++) {
      const d = i[n], h = d.getAttribute("variableDuration");
      t.push({
        adParameters: ((s = r == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null,
        apiFramework: d.getAttribute("apiFramework"),
        delivery: d.getAttribute("delivery"),
        fileURL: O.trim(d.textContent),
        linearity: w.LINEAR,
        mimeType: d.getAttribute("type"),
        variableDuration: h ? !!h.match("true") : !1
      });
    }
    return t;
  }
  getClosedCaptionCreatives(e) {
    let t = [], i = e.querySelector("ClosedCaptionFiles");
    if (i) {
      let r = i.querySelectorAll("ClosedCaptionFile");
      for (let s = 0; s < r.length; s++)
        t.push({
          fileURL: r[s].textContent,
          // en, en-US, zh-TW
          language: r[s].getAttribute("language"),
          linearity: w.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: r[s].getAttribute("type")
        });
    }
    return t;
  }
  getCreativeViewTrackers(e, t) {
    const i = [];
    return [...e.querySelectorAll(t)].forEach((r) => {
      i.push({
        url: O.trim(r.textContent)
      });
    }), i;
  }
  getIndustryIcons() {
    const e = {};
    let t = this.adXML.querySelectorAll("Creatives > Creative > Linear Icon");
    for (let i = 0; i < t.length; i++) {
      const r = t[i].getAttribute("program") || "unknown", s = this.getCreativeViewTrackers(t[i], "IconViewTracking"), n = new vi("Icon", s, t[i]);
      e[r] = n;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  /** @internal */
  getNonLinear() {
    let e = this.adXML.querySelectorAll("InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    a.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let t = e.querySelectorAll("NonLinear"), i = [{
      type: Be.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let r = 0; r < t.length; r++) {
      const s = new Ri(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        t[r]
      );
      i[r].variations.push(s);
    }
    return i;
  }
  get companion() {
    const e = this.adXML.querySelectorAll("Creatives > Creative > CompanionAds");
    let t = [];
    for (let i = 0; i < e.length; i++) {
      t[i] = {
        hasCompanionResources: !1,
        required: null,
        type: Be.COMPANION,
        variations: []
      };
      const r = e[i].querySelectorAll("Companion");
      for (let s = 0; s < r.length; s++)
        if (r[s].hasChildNodes()) {
          const n = this.getCreativeViewTrackers(
            r[s],
            "Tracking[event=creativeView]"
          );
          let d = new Ti(
            "Companion",
            n,
            r[s]
          );
          t[i].hasCompanionResources = d.resources.length > 0, t[i].required = e[i].getAttribute("required"), t[i].variations.push(d);
        }
    }
    return t.reverse();
  }
  /**
   * @returns {Object} Object with tracker arrays for all specified tracking events
   */
  /** @internal */
  getTrackers(e) {
    const t = {}, i = Array.from(this.adXML.querySelectorAll("ClickTracking, " + e));
    for (let r = 0; r < i.length; r++) {
      const s = i[r], n = s.nodeName.charAt(0).toLowerCase() + s.nodeName.slice(1), d = s.getAttribute("event") || n, h = s.getAttribute("offset"), u = {
        offset: "",
        url: O.trim(s.textContent)
      };
      if (d === ye.ON_AD_PROGRESS && h) {
        const N = O.convertTimeStringToSeconds(h);
        u.offset = typeof N == "number" ? N.toString() : h;
      }
      t[d] = t[d] || [], t[d].push(u);
    }
    return t;
  }
}
class Ii extends a {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, t) {
    super(), this.adXML = e, this.rawXML = t instanceof Document ? t.documentElement : t, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((t, i) => {
      const r = Number(Object.keys(t));
      return Number(Object.keys(i)) - r;
    }).map((t) => Object.values(t)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let t = 0, i = e.parentElement;
    for (; i; )
      t++, i = i.parentElement;
    return { [t]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    let e = [];
    const t = this.adXML.querySelectorAll("Ad > Wrapper");
    let i = [];
    return t.forEach((s) => {
      let n = s.querySelectorAll("Wrapper > Creatives > Creative");
      n.length > 0 ? n.forEach((d) => {
        i.push(d);
      }) : e.push(s);
    }), i.length > 0 && i.forEach((s) => {
      e.push(s);
    }), this.adXML.querySelectorAll("InLine > Creatives > Creative").forEach((s) => {
      e.push(s);
    }), e;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    this.wrappers.length > 0 ? e = this.getWrapperAndInLineCreative() : this.adXML.querySelectorAll("Creative").forEach((n) => {
      e.push(n);
    });
    let t = [];
    e.forEach((s) => {
      t.push(this.getNodeDepth(s));
    });
    const i = this.getElementsSortedByDepth(t);
    let r = [];
    return i.forEach((s) => {
      const n = s.getAttributeNames().find((d) => d.toLowerCase() === "adid");
      r.push(s.getAttribute(n) || null);
    }), r;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (O.getMostNestedElement(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = this.adXML.querySelector("InLine Advertiser");
    return O.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = this.adXML.querySelectorAll("AdVerifications > Verification");
    let t = [];
    for (let i = 0; i < e.length; i++) {
      const r = e[i], s = r.getAttribute("vendor") || "", n = r.querySelector("JavaScriptResource"), d = this.getNodeContentsAsText(
        r.querySelector("VerificationParameters") || document.createElement("div")
      ), h = this.getTrackerNodesAsURLArray(
        r.querySelector("TrackingEvents") || document.createElement("div")
      );
      if (s && s.length > 0 && n) {
        const u = {
          javascriptResource: {
            url: O.trim(this.getNodeContentsAsText(n)),
            apiFramework: n.getAttribute("apiFramework") || "",
            browserOptional: n.getAttribute("browserOptional") === "true" || !1
          },
          tracking: h,
          vendor: s,
          verificationParameters: d
        };
        t.push(u);
      }
    }
    return t.length > 0 ? O.getUnique(t, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = O.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new Ni(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = this.adXML.querySelector("InLine Description");
    return O.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = O.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = O.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    this.wrappers.length > 0 && this.adXML.querySelectorAll("Ad > Wrapper").forEach((s) => {
      const n = s.parentElement.getAttribute("id");
      e.push(n);
    });
    let t = null, i = O.getMostNestedElement(this.adXML, "Ad");
    return i && i.hasAttribute("id") && (t = i.id), e.length > 0 ? (e.push(t), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    this.wrappers.length > 0 ? e = this.getWrapperAndInLineCreative() : this.adXML.querySelectorAll("Creative").forEach((n) => {
      e.push(n);
    });
    let t = [];
    e.forEach((s) => {
      t.push(this.getNodeDepth(s));
    });
    let i = [];
    return this.getElementsSortedByDepth(t).forEach((s) => {
      i.push(s.getAttribute("id") || null);
    }), i;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = this.adXML.querySelector("InLine AdServingId");
    return O.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = this.adXML.querySelector("InLine Pricing") || O.getMostNestedElement(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = this.adXML.querySelector("InLine Survey");
    return O.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = this.adXML.querySelector("InLine AdSystem");
    return O.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = this.adXML.querySelector("InLine AdTitle");
    return O.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(q(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(q(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: q(this.rawXML, "_loadEnd") - q(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const t = this.adXML.querySelectorAll("VASTAdTagURI");
    for (let i = 0; i < t.length; i++)
      e.push({
        loadStart: new Date(q(t[i], "_loadStart")).toISOString(),
        loadEnd: new Date(q(t[i], "_loadEnd")).toISOString(),
        loadTime: q(t[i], "_loadEnd") - q(t[i], "_loadStart"),
        url: O.trim(t[i].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = this.adXML.querySelectorAll("Creative UniversalAdId"), t = e[e.length - 1];
    return t ? this.extractUniversalAdIdInfo(t) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const t = this.adXML.querySelectorAll("Creative UniversalAdId");
    for (let i = 0; i < t.length; i++)
      e.push(this.extractUniversalAdIdInfo(t[i]));
    return e;
  }
  /**
   * Returns all VAST Extensions (no CreativeExtensions)
   *
   * @internal
   * @returns {Array} Extensions
   */
  /** @internal */
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const t = this.adXML.querySelectorAll("Extensions > Extension");
      for (let i = 0; i < t.length; i++)
        e.push({
          extensionXML: t[i],
          type: t[i].getAttribute("type")
        });
    }
    return e;
  }
  /** @internal */
  getNodeContentsAsText(e) {
    var t;
    return ((t = e == null ? void 0 : e.textContent) == null ? void 0 : t.trim()) || "";
  }
  /** @internal */
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || O.trim(
        e.getAttribute("idValue") || "unknown"
      )
    };
  }
  /**
   * Note: TrackingEvents moved to the creative level
   * @internal
   * @returns {Object} Object with tracker arrays for error, impression and viewableImpression
   */
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const t = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && t.push(this.adXML), t.forEach((i) => {
        const r = i.nodeName.charAt(0).toLowerCase() + i.nodeName.slice(1), s = this.getNodeContentsAsText(i);
        s && s.length > 0 && (e[r] = e[r] || [], e[r].push({
          url: s
        }));
      });
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} Object with tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const t = {};
    return e && Array.from(e.querySelectorAll("Tracking")).forEach((i) => {
      const r = this.getNodeContentsAsText(i), s = i.getAttribute("event");
      r && r.length > 0 && s !== null && (t[s] || (t[s] = []), t[s].push({
        url: r
      }));
    }), t;
  }
}
class De extends Ii {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, t) {
    super(e, t), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = this.adXML.querySelectorAll("Creative Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      O.getMostNestedElement(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  /** @internal */
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return F.SPONSORED;
      default:
        return F.COMMERCIAL;
    }
  }
  /** @internal */
  parseSkipOffsetToNumber() {
    var t;
    const e = O.convertTimeStringToSeconds(
      ((t = this.adXML.querySelector("InLine Linear")) == null ? void 0 : t.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  /**
   * @internal
   * @param {Node} variantElement - The XML node that has the variant information for this ad.
   * @returns {string} variant - The normalized name based on the `AD_VARIANT` name.
   */
  /** @internal */
  getVariant(e) {
    if (e === null)
      return F.COMMERCIAL;
    let t = F.COMMERCIAL;
    return e.nodeName === "AdInfo" && (t = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (t = this.mapStringToVariant(e.textContent.trim())), t;
  }
  /** @internal */
  getDuration() {
    var t, i;
    const e = ((i = (t = O.getMostNestedElement(this.adXML, "Linear Duration")) == null ? void 0 : t.textContent) == null ? void 0 : i.trim()) || De.FALLBACK_LINEAR_DURATION;
    return O.convertTimeStringToSeconds(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  /** @internal */
  getError() {
    function e(i) {
      if (i.parentNode)
        return i.parentNode.querySelector(":scope > parsererror");
    }
    const t = this.adXML.querySelector("parsererror") || e(this.adXML);
    return t ? {
      code: q(t, "code"),
      message: t.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  /** @internal */
  flagCappedAds() {
    return this.adXML.querySelector("InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: f.WRAPPER.NO_RESPONSE.code,
      message: f.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  /** @internal */
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", t = O.getMostNestedElement(this.adXML, e);
    return O.trim((t == null ? void 0 : t.textContent) || "");
  }
}
De.FALLBACK_LINEAR_DURATION = "00:00:20";
class Oi {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  /**
   * Handles the provided XML document to extract and create Ad instances.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  /** @internal */
  handleXMLDoc(e) {
    let t = e.querySelector("parsererror"), i = e.querySelectorAll(":root > *"), r;
    if (!(e.querySelector("html") && t)) {
      if (e.querySelector("html")) {
        r = document.createElement("VAST");
        const s = new De(r, e);
        this.adList.push(s);
        return;
      }
      if (e instanceof DocumentFragment && t) {
        r = document.createElement("VAST"), r.appendChild(t);
        const s = new De(r, e);
        this.adList.push(s);
      }
      for (let s = 0; s < i.length; s++) {
        const n = new De(i[s], e);
        this.adList.push(n);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function Ci(l, e) {
  const t = Object.values(He);
  let i = [];
  const r = document.createElement("video"), s = document.createElement("audio");
  let n = t;
  return e && e.length > 0 && (i = e, n = e), n.filter((h) => !("canPlayType" in r) || h === "application/javascript" || r.canPlayType(h) !== "" || s.canPlayType(h) !== "" ? i.push(h) : !1), (i.length <= 0 || i.length === 1 && i[0] === "application/javascript") && (i = n), l.filter((h) => i.find((u) => h.mimeType === u));
}
class et {
  static getProperCreative(e, t) {
    if (!e || e.length < 1)
      return null;
    let i = e.slice(0);
    return e[0].type === w.NON_LINEAR ? Li.select(i, t) : Di.select(i, t);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, t = []) {
    return e.filter((i) => i.isVPAID ? this.isFriendlyVendorHost(i.fileURL, t) : !0);
  }
  static isFriendlyVendorHost(e, t = []) {
    return !t || t && t.length === 0 ? !0 : t.some((i) => {
      if (!i.includes("."))
        return !1;
      try {
        const r = new URL(e).hostname;
        return new RegExp(`(^|\\.)${i.replace(".", "\\.")}$`).test(r);
      } catch (r) {
        return !1;
      }
    });
  }
}
class Di {
  static select(e, t) {
    return e.forEach((r) => {
      r.selectedCreativeFile = null, r.selectedMediaFile = null;
      let s = r.mediaFiles || [];
      s.map((d) => {
        var h;
        !r.selectedCreativeFile && d.apiFramework && (d.isSIMID = (d.apiFramework + "").toUpperCase() === "SIMID", r.selectedCreativeFile = d.isSIMID ? d : null), (h = r.selectedCreativeFile) != null && h.isSIMID && (d.isSIMID = !0), d.isVPAID = (d.apiFramework + "").toUpperCase() === "VPAID";
      }), s = et.removeUnwantedVPAIDVendors(
        s,
        t.desiredVPAIDVendors
      );
      let n = Ci(s, t.desiredMimeTypes);
      r.selectedMediaFile = this.selectMediaFile(
        n,
        t.desiredBitrate || 1e3,
        t.desiredMimeTypes || []
      );
    }), e.filter((r) => !!r.selectedMediaFile).shift();
  }
  /**
   * @param {Array} mediaFileList represents all available MediaFiles from an ad.
   * @param {number} bitrate indicates the desired bitrate in kilobits per second (kbps).
   * @param {Array} desiredMimeTypes represents the favorite mediaFiles in a certain order.
   * @returns {Array} Revised mediaFileList with favored desiredMimeType.
   */
  /** @internal */
  static selectMediaFile(e, t, i) {
    let r = e.filter((d) => d.isSIMID), s = e.filter((d) => d.isVPAID);
    if (r.length > 0)
      return r[0];
    if (s.length > 0)
      return s[0];
    let n = [];
    for (let d = 0; d < i.length; ) {
      if (d > 0 && n.length > 0) {
        e = n;
        break;
      }
      e.filter((h) => {
        h.mimeType === i[d] && n.push(h);
      }), d++;
    }
    return this.selectMediaFileByBitrate(e, t);
  }
  // mediafile returned has smaller or same bitrate as requested one
  /** @internal */
  static selectMediaFileByBitrate(e, t) {
    let i = e.filter((s) => !s.isVPAID).sort((s, n) => n.bitrate - s.bitrate), r = i.filter((s) => s.bitrate <= t);
    return r.length > 0 ? r.shift() : i.pop() || e.shift();
  }
}
class Li {
  static select(e, t) {
    return e.forEach((r) => {
      const s = r.variations;
      s.map((n) => {
        n.selectedResource = null, (n.apiFramework + "").toUpperCase() === "VPAID" && (n.isVPAID = !0, n.resources = n.resources.filter((d) => et.isFriendlyVendorHost(
          d.resource,
          t.desiredVPAIDVendors
        )));
      }), s.forEach((n) => {
        n.resources.length <= 0 ? n.hasCreative = !1 : n.selectedResource = n.resources[0];
      }), r.variations = s.filter((n) => !!n.selectedResource);
    }), e.filter((r) => r.variations.length > 0).shift();
  }
}
const Bt = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function yi(l, e, t, i) {
  let r = l;
  const s = t, n = i, d = e, h = {
    DIVIDER: F.DIVIDER,
    CLOSER: F.CLOSER,
    OPENER: F.OPENER
  };
  function u(H) {
    let Q = [], C = {
      adParameters: null,
      creativeTrackers: {},
      duration: De.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: w.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let c in H)
      if (Object.prototype.hasOwnProperty.call(H, c) && Object.prototype.hasOwnProperty.call(Bt, c.toUpperCase())) {
        let A = H[c];
        if (typeof A == "string" && A.length > 0) {
          let g = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: A,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: Bt[c.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          C.mediaFiles.push(g);
        }
      }
    return C.supportedMediaFiles = C.mediaFiles, Q.push(C), Q;
  }
  function N() {
    Object.keys(h).forEach((H) => {
      if (s && Object.prototype.hasOwnProperty.call(s, h[H])) {
        const Q = s[h[H]];
        if (!d && !Q.forcePlay)
          return;
        let C = {};
        C.adTrackers = [], C.creatives = u(Q), C.id = C.adId = h[H], C.isLinear = !0, C.variant = h[H], C.properCreative = C.creatives[0], C.properCreative.selectedMediaFile = C.properCreative.supportedMediaFiles[0], C.config = n, C.enrichment = new ge(), C.adReinsertion = new V(n.adReinsertion, C.enrichment), C.expectedAdType = s.type, C.isPaused = !0;
        let c = [];
        switch (h[H]) {
          case h.DIVIDER:
            if (r.forEach((A, g) => {
              g > 0 && A.variant !== r[g - 1].variant && c.push({
                offset: g,
                ad: C
              });
            }), s[h[H]].forcePlay && c.length === 0) {
              r[0].variant === F.SPONSORED ? r.unshift(C) : r.push(C);
              break;
            }
            c.forEach((A, g) => {
              const D = A.offset + g;
              r.splice(D, 0, A.ad);
            });
            break;
          case h.CLOSER:
            r.push(C);
            break;
          case h.OPENER:
            r.unshift(C);
            break;
        }
      }
    });
  }
  let x = {
    totalCommercials: 0,
    totalClips: 0,
    totalPlayableClips: 0,
    totalPlayableCommercials: 0
  };
  function B() {
    let H = 0, Q = 0, C = 0;
    const c = r.length;
    r.forEach((A, g) => {
      A.variant === F.COMMERCIAL ? (A.currentCommercial = Q += 1, (A.fallbackOnNoAd || !A.fallbackOnNoAd) && A.hasError && (H += 1), A.currentPodSequencing = Q - H) : (A.fallbackOnNoAd || !A.fallbackOnNoAd) && A.hasError && (C += 1), A.variant !== F.COMMERCIAL && (A.currentCommercial = -1), A.sequence = g + 1, A.currentClip = g + 1;
    }), x = {
      totalClips: c,
      totalPlayableClips: c - H - C,
      totalCommercials: Q,
      totalPlayableCommercials: Q - H
    };
  }
  return N(), B(), { enrichedManifest: r, sequenceData: x };
}
function Xt(l) {
  let e = l;
  for (let t = 0; t < e.length; t++) {
    let r = e[t].extensions;
    r == null || r.forEach((s) => {
      typeof s.extensionXML == "string" && (s.extensionXML = new DOMParser().parseFromString(s.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
    });
  }
  return e;
}
class bi {
  constructor(e, t, i, r) {
    this.adBreak = r, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = t, this.environmentVars = i, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), Xt(this.adSlotModelList), this.adSlotBuffetList = Xt(this.adSlotBuffetList), a.debug.info(this.NAME + "adPod", this.adSlotModelList), a.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  /** @internal */
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((t) => t).sort(this.bySequence).reverse();
      for (let t = e.length - 1; t >= 0; t--) {
        const i = e[t];
        if (i.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let r = this.adSlotBuffetList.shift();
          r.sequence = i.sequence + 0.1, this.adSlotModelList.splice(i.sequence - 1, 0, r);
        }
      }
    }
  }
  /** @internal */
  decorateAdList() {
    this.adList.forEach((e) => {
      if (e.adBreakPosition = this.adBreak.adBreakPosition, e.config = this.config, e.enrichment = new ge(), e.enrichment.setFromObject(e.publisherMacros), e.expectedAdType = this.adBreak.type, e.publisherMacros = this.environmentVars.vastMacros, e.adReinsertion = new V(e.config.adReinsertion, e.enrichment), e.isPaused = !0, !e.hasError) {
        if (e.creatives.length < 1) {
          e.error = {}, e.error = f.WRAPPER.NO_RESPONSE;
          return;
        }
        if (e.expectedAdType === w.LINEAR && e.creativeClass.linearAsArray[0].mediaFiles.length === 0 || e.expectedAdType === w.NON_LINEAR && e.creativeClass.nonLinear.length === 0) {
          e.error = {}, e.error = f.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          return;
        }
        e.expectedAdType === w.LINEAR ? (e.properCreative = et.getProperCreative(
          e.creativeClass.linearAsArray,
          this.environmentVars
        ), e.properCreative && (e.closedCaptions = e.properCreative.captions, e.icons = e.properCreative.icons)) : e.properCreative = et.getProperCreative(
          e.creativeClass.nonLinear,
          this.environmentVars
        ), e.properCreative || (e.error = {}, e.error = f.VAST.UNSUPPORTED_MIMETYPE);
      }
    });
  }
  /** @internal */
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = []);
  }
  /** @internal */
  extendWithSeparationClips() {
    if (this.adBreak.type !== w.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: t
    } = yi(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = t;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  /** @internal */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((t) => !t.hasError || t.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((t) => !t.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && e.adXML.querySelector(`ParserError[code="${f.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  /** @internal */
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  /** @internal */
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const t = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, i = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return t || i;
    });
  }
  // sort ads by ascending sequence number
  /** @internal */
  bySequence(e, t) {
    return e.sequence - t.sequence;
  }
}
const bt = class bt {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, t) {
    this.callbackOnDoneLoading = t, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, t) {
    this.callbackOnDoneLoading = t, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((i) => (this.saveInitialURLToTag(e, i), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), i), this.requestXML(i)));
  }
  /* c8 ignore stop */
  /** @internal */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let t = this.XMLDoc.querySelectorAll("VASTAdTagURI");
      if (this.XMLsToLoad = t.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let i = 0; i < this.XMLsToLoad; i++) {
        let s = (t[i].textContent || "").trim();
        this.walkDownAdWrappers(
          s,
          0,
          t[i].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((n) => {
          e(n);
        });
      }
    }
  }
  /** @internal */
  walkDownAdWrappers(e, t, i, r) {
    return new Promise((s, n) => {
      let d = i.querySelector("VASTAdTagURI");
      if (d.setAttribute("_loadStart", Date.now().toString()), d.setAttribute("_loadEnd", Date.now().toString()), Date.now() - r > this.wrapperChainTimeout)
        return se(i, f.WRAPPER.CHAIN_TIMEOUT), n(), e;
      if (t >= this.maxWrapperDepth)
        return se(
          i,
          f.WRAPPER.LIMIT_REACHED
        ), n(), e;
      if (this.isInsecureURL(e))
        return se(i, f.SESSION.MIXED_CONTENT), n(), e;
      if (this.hasSessionTimeoutError)
        return n(), e;
      let h, u;
      this.loadURL(e, !0).then((N) => {
        let x = N.querySelector("VASTAdTagURI");
        h = ((x || {}).textContent || "").trim(), h && (u = x.parentNode), this.addContentToWrapperNode(i, N), d.setAttribute("_loadEnd", Date.now().toString()), s([h, u]);
      });
    }).then((s) => {
      let [n, d] = s;
      return n ? this.walkDownAdWrappers(n, t + 1, d, r) : e;
    });
  }
  /** @internal */
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  /** @internal */
  loadURL(e, t = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = t, new Promise((i) => {
      new Ct().get(e, (r, s) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let n = s || document.createDocumentFragment(), d = n.querySelector("Ad") || n.documentElement || n;
          this.hasSessionTimeoutError = !0, se(d, f.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: V.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: s
          }), i(n);
        }
        if (!r && s && s.querySelector("parsererror")) {
          let n = document.createDocumentFragment();
          se(n, f.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: V.REASON.XML_PARSING_ERROR,
            xmlResponse: s
          }), i(n);
        }
        if (!r && s && s.documentElement.nodeName.toUpperCase() === "VAST") {
          const n = s.querySelector("VAST");
          if (n && n.querySelectorAll(":scope > *").length === 0) {
            let d = document.createDocumentFragment();
            se(d, f.WRAPPER.NO_RESPONSE), i(d);
          }
        }
        if (r && !s) {
          let n = document.createDocumentFragment();
          a.debug.warn(
            this.NAME + " XHR Request Error",
            r.code,
            r.description
          ), se(n, r), i(n);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  /** @internal */
  isInsecureURL(e) {
    return this.blockInsecureURL && !zt(e);
  }
  /* c8 ignore stop */
  /** @internal */
  setAttributeToTag(e, t, i) {
    if (i) {
      let r = i.querySelector("VAST");
      r && r.setAttribute(e, t);
    }
  }
  /** @internal */
  saveInitialURLToTag(e, t) {
    this.setAttributeToTag("_initialURL", e, t);
  }
  /** @internal */
  saveInitialTimestampToTag(e, t, i) {
    this.setAttributeToTag("_loadStart", e, i), this.setAttributeToTag("_loadEnd", t, i);
  }
  /** @internal */
  addContentToWrapperNode(e, t) {
    let i = document.createElement("_VASTAdTagURIContent");
    i.appendChild(t.firstElementChild), e.appendChild(i);
  }
};
bt.EVENT = {
  PARSED: "AdTagService::parsed"
};
let Rt = bt;
class Wt {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function t(n, d) {
      const h = e[n];
      return !h || h.length <= 0 ? (a.debug.info(d), []) : h;
    }
    const i = (n, d) => {
      const h = e.creatives;
      if (h && h.length !== 0) {
        const u = h.find(
          (N) => N.type === n
        );
        if (u && u.variations && u.variations.length > 0)
          return u.variations;
      }
      return a.debug.info(d), [];
    };
    function r(n) {
      return n.charAt(0).toUpperCase() + n.slice(1);
    }
    const s = (n) => {
      var h, u;
      if (e.isLinear) {
        const N = e.properCreative && e.properCreative.selectedMediaFile;
        return N ? N[n] : -1;
      }
      const d = (u = (h = e.creativesArray) == null ? void 0 : h.nonLinearCreative[0]) == null ? void 0 : u.variations[0];
      if (d && e.isExpanded) {
        const N = `expanded${r(n)}`;
        return d[N] === -1 ? d[n] : d[N];
      }
      return d ? d[n] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return t("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return t("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return i(Be.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function n(h, u) {
          return u === 0 || !h.parentElement ? h : n(h.parentElement, u - 1);
        }
        function d(h) {
          const u = n(h, 3), N = u.getAttributeNames().find((x) => x.toLowerCase() === "adid");
          return {
            adId: u.getAttribute(N) || null,
            id: u.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let h = null;
          if (e.isSIMID ? h = "InteractiveCreativeFile" : e.isVPAID ? h = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (h = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), h) {
            const u = e.adXML.querySelector(h);
            return d(u);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const h = e.properCreative.variations[0].selectedResource.type, u = e.properCreative.variations[0].selectedResource.creativeType, N = e.adXML.querySelector(
            `${h}[creativeType="${u}"]`
          );
          return d(N);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var n;
        return !e.isLinear && ((n = e.creativesArray) != null && n.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (a.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return t("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== "IFrameResource";
        } catch (n) {
          return !1;
        }
      },
      get height() {
        return s("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (a.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const n = e.properCreative;
        return n && n.length !== 0 ? n : (a.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return i(Be.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var n;
        return !e.isLinear && ((n = e.creativesArray) != null && n.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Nulll is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return t("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(n) {
        e.volume = n;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return s("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return t("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class Pi {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, t) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return t.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return t.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return t.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return t.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class Jt {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, t, i) {
    this.consentAPI = e, this.callback = t, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = i, this.NAME = "TCFAPI::", a.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, t) {
    this.consentAPI(e, this.version, (i) => {
      this.onConsentData(i, t);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, t) {
    this.consentDataInfo = e[t], this.gdprAppliesBoolean = e.gdprApplies, a.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class _i extends Jt {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, t) {
    super(e, t, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class Mi extends Jt {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, t) {
    super(e, t, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class wi {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const t = window.top;
      t && (this.tcfAPI = t.__tcfapi, this.cmpAPI = t.__cmp);
    } catch (t) {
      a.debug.warn(`${this.NAME}Ctor No window?`, t);
    }
    this.hasTCF() ? this.api = new Mi(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new _i(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : a.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    a.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function Lt(l) {
  if (typeof l != "object" || l === null)
    return l;
  const e = /* @__PURE__ */ Object.create(null);
  for (const t of Object.keys(l)) {
    const i = l[t];
    Qt(i) || (e[t] = Lt(l[t]));
  }
  return e;
}
function ki(l) {
  const e = document.implementation.createDocument(null, "VAST", null);
  return e.documentElement.setAttribute("version", "3.0"), l.forEach((t) => {
    const i = e.createElement("Ad"), r = e.createElement("Wrapper"), s = e.createElement("VASTAdTagURI");
    s.appendChild(e.createTextNode(t)), r.appendChild(s), i.appendChild(r), e.documentElement.appendChild(i);
  }), e;
}
function Vi(l) {
  let e = l;
  if (e.originConfig = Lt(l), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let t = e.urls[0];
    e.urls = [];
    for (let i = 0; i < e.repeat; i++)
      e.urls.push(t.replace("[count]", (i + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = ki(e.urls)), e.requested = !1, e;
}
const jt = "AdBreakValidation";
function Ui(l) {
  var r, s;
  if (!l || typeof l != "object" || Array.isArray(l) || Object.keys(l).length === 0)
    return a.debug.warn(jt + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof l.tag == "string" || Array.isArray(l.tag)) && l.tag.length > 0, t = ((s = (r = l.response) == null ? void 0 : r.length) != null ? s : 0) > 0, i = l[F.CLOSER] || l[F.DIVIDER] || l[F.OPENER];
  return !e && !t && !i ? (a.debug.warn(jt + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function pe(l) {
  "@babel/helpers - typeof";
  return pe = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(e) {
    return typeof e;
  } : function(e) {
    return e && typeof Symbol == "function" && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e;
  }, pe(l);
}
function Fi(l, e, t, i, r) {
  var s = s || {};
  (function(n) {
    var d = {
      globalConfig: l,
      clientConfig: e,
      clientAPIs: t,
      utilsReady: i,
      onFailure: r
    };
    (function() {
      function h(c) {
        c = [(typeof globalThis == "undefined" ? "undefined" : pe(globalThis)) == "object" && globalThis, c, (typeof window == "undefined" ? "undefined" : pe(window)) == "object" && window, (typeof self == "undefined" ? "undefined" : pe(self)) == "object" && self, (typeof global == "undefined" ? "undefined" : pe(global)) == "object" && global];
        for (var A = 0; A < c.length; ++A) {
          var g = c[A];
          if (g && g.Math == Math) return g;
        }
        throw Error("Cannot find global object");
      }
      var u = h(this);
      function N(c) {
        var A = 0;
        return function() {
          return A < c.length ? {
            done: !1,
            value: c[A++]
          } : {
            done: !0
          };
        };
      }
      var x = typeof Object.defineProperties == "function" ? Object.defineProperty : function(c, A, g) {
        return c == Array.prototype || c == Object.prototype || (c[A] = g.value), c;
      };
      function B(c, A) {
        if (A) e: {
          var g = u;
          c = c.split(".");
          for (var D = 0; D < c.length - 1; D++) {
            var L = c[D];
            if (!(L in g)) break e;
            g = g[L];
          }
          c = c[c.length - 1], D = g[c], A = A(D), A != D && A != null && x(g, c, {
            configurable: !0,
            writable: !0,
            value: A
          });
        }
      }
      B("Symbol", function(c) {
        function A(L) {
          if (this instanceof A) throw new TypeError("Symbol is not a constructor");
          return new g("jscomp_symbol_" + (L || "") + "_" + D++, L);
        }
        function g(L, y) {
          this.j = L, x(this, "description", {
            configurable: !0,
            writable: !0,
            value: y
          });
        }
        if (c) return c;
        g.prototype.toString = function() {
          return this.j;
        };
        var D = 0;
        return A;
      }), B("Symbol.iterator", function(c) {
        if (c) return c;
        c = Symbol("Symbol.iterator");
        for (var A = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), g = 0; g < A.length; g++) {
          var D = u[A[g]];
          typeof D == "function" && typeof D.prototype[c] != "function" && x(D.prototype, c, {
            configurable: !0,
            writable: !0,
            value: function() {
              return H(N(this));
            }
          });
        }
        return c;
      });
      function H(c) {
        return c = {
          next: c
        }, c[Symbol.iterator] = function() {
          return this;
        }, c;
      }
      function Q(c) {
        var A = typeof Symbol != "undefined" && Symbol.iterator && c[Symbol.iterator];
        return A ? A.call(c) : {
          next: N(c)
        };
      }
      function C(c, A) {
        return Object.prototype.hasOwnProperty.call(c, A);
      }
      B("WeakMap", function(c) {
        function A(E) {
          if (this.h = (p += Math.random() + 1).toString(), E) {
            E = Q(E);
            for (var m; !(m = E.next()).done; ) m = m.value, this.set(m[0], m[1]);
          }
        }
        function g() {
        }
        function D(E) {
          var m = pe(E);
          return m === "object" && E !== null || m === "function";
        }
        function L(E) {
          if (!C(E, T)) {
            var m = new g();
            x(E, T, {
              value: m
            });
          }
        }
        function y(E) {
          var m = Object[E];
          m && (Object[E] = function(R) {
            return R instanceof g ? R : (Object.isExtensible(R) && L(R), m(R));
          });
        }
        if (function() {
          if (!c || !Object.seal) return !1;
          try {
            var E = Object.seal({}), m = Object.seal({}), R = new c([[E, 2], [m, 3]]);
            return R.get(E) != 2 || R.get(m) != 3 ? !1 : (R.delete(E), R.set(m, 4), !R.has(E) && R.get(m) == 4);
          } catch (b) {
            return !1;
          }
        }()) return c;
        var T = "$jscomp_hidden_" + Math.random();
        y("freeze"), y("preventExtensions"), y("seal");
        var p = 0;
        return A.prototype.set = function(E, m) {
          if (!D(E)) throw Error("Invalid WeakMap key");
          if (L(E), !C(E, T)) throw Error("WeakMap key fail: " + E);
          return E[T][this.h] = m, this;
        }, A.prototype.get = function(E) {
          return D(E) && C(E, T) ? E[T][this.h] : void 0;
        }, A.prototype.has = function(E) {
          return D(E) && C(E, T) && C(E[T], this.h);
        }, A.prototype.delete = function(E) {
          return D(E) && C(E, T) && C(E[T], this.h) ? delete E[T][this.h] : !1;
        }, A;
      }), B("Map", function(c) {
        function A() {
          var p = {};
          return p.c = p.next = p.head = p;
        }
        function g(p, E) {
          var m = p.b;
          return H(function() {
            if (m) {
              for (; m.head != p.b; ) m = m.c;
              for (; m.next != m.head; ) return m = m.next, {
                done: !1,
                value: E(m)
              };
              m = null;
            }
            return {
              done: !0,
              value: void 0
            };
          });
        }
        function D(p, E) {
          var m = E && pe(E);
          m == "object" || m == "function" ? y.has(E) ? m = y.get(E) : (m = "" + ++T, y.set(E, m)) : m = "p_" + E;
          var R = p.g[m];
          if (R && C(p.g, m)) for (p = 0; p < R.length; p++) {
            var b = R[p];
            if (E !== E && b.key !== b.key || E === b.key) return {
              id: m,
              list: R,
              index: p,
              a: b
            };
          }
          return {
            id: m,
            list: R,
            index: -1,
            a: void 0
          };
        }
        function L(p) {
          if (this.g = {}, this.b = A(), this.size = 0, p) {
            p = Q(p);
            for (var E; !(E = p.next()).done; ) E = E.value, this.set(E[0], E[1]);
          }
        }
        if (function() {
          if (!c || typeof c != "function" || !c.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var p = Object.seal({
              x: 4
            }), E = new c(Q([[p, "s"]]));
            if (E.get(p) != "s" || E.size != 1 || E.get({
              x: 4
            }) || E.set({
              x: 4
            }, "t") != E || E.size != 2) return !1;
            var m = E.entries(), R = m.next();
            return R.done || R.value[0] != p || R.value[1] != "s" ? !1 : (R = m.next(), !(R.done || R.value[0].x != 4 || R.value[1] != "t" || !m.next().done));
          } catch (b) {
            return !1;
          }
        }()) return c;
        var y = /* @__PURE__ */ new WeakMap();
        L.prototype.set = function(p, E) {
          p = p === 0 ? 0 : p;
          var m = D(this, p);
          return m.list || (m.list = this.g[m.id] = []), m.a ? m.a.value = E : (m.a = {
            next: this.b,
            c: this.b.c,
            head: this.b,
            key: p,
            value: E
          }, m.list.push(m.a), this.b.c.next = m.a, this.b.c = m.a, this.size++), this;
        }, L.prototype.delete = function(p) {
          return p = D(this, p), p.a && p.list ? (p.list.splice(p.index, 1), p.list.length || delete this.g[p.id], p.a.c.next = p.a.next, p.a.next.c = p.a.c, p.a.head = null, this.size--, !0) : !1;
        }, L.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = A(), this.size = 0;
        }, L.prototype.has = function(p) {
          return !!D(this, p).a;
        }, L.prototype.get = function(p) {
          return (p = D(this, p).a) && p.value;
        }, L.prototype.entries = function() {
          return g(this, function(p) {
            return [p.key, p.value];
          });
        }, L.prototype.keys = function() {
          return g(this, function(p) {
            return p.key;
          });
        }, L.prototype.values = function() {
          return g(this, function(p) {
            return p.value;
          });
        }, L.prototype.forEach = function(p, E) {
          for (var m = this.entries(), R; !(R = m.next()).done; ) R = R.value, p.call(E, R[1], R[0], this);
        }, L.prototype[Symbol.iterator] = L.prototype.entries;
        var T = 0;
        return L;
      }), B("Object.is", function(c) {
        return c || function(A, g) {
          return A === g ? A !== 0 || 1 / A === 1 / g : A !== A && g !== g;
        };
      }), B("Array.prototype.includes", function(c) {
        return c || function(A, g) {
          var D = this;
          D instanceof String && (D = String(D));
          var L = D.length;
          for (g = g || 0, 0 > g && (g = Math.max(g + L, 0)); g < L; g++) {
            var y = D[g];
            if (y === A || Object.is(y, A)) return !0;
          }
          return !1;
        };
      }), B("String.prototype.includes", function(c) {
        return c || function(A, g) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (A instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(A, g || 0) !== -1;
        };
      }), B("Array.from", function(c) {
        return c || function(A, g, D) {
          g = g != null ? g : function(p) {
            return p;
          };
          var L = [], y = typeof Symbol != "undefined" && Symbol.iterator && A[Symbol.iterator];
          if (typeof y == "function") {
            A = y.call(A);
            for (var T = 0; !(y = A.next()).done; ) L.push(g.call(D, y.value, T++));
          } else for (y = A.length, T = 0; T < y; T++) L.push(g.call(D, A[T], T));
          return L;
        };
      }), function() {
        function c() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function A() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function g(T) {
          return T == "True" || T == "true" || T == 1 || T == "1" || T == 1;
        }
        function D() {
          var T = function() {
            var R = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), b = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), Te = R.slice(0, R.length / 2).split("").reverse().join("");
            return R = R.slice(R.length / 2).split("").reverse().join(""), b + Te + b + R + b;
          }(), p = function(R) {
            var b = 0, Te;
            if (R.length == 0) return b;
            var ve = 0;
            for (Te = R.length; ve < Te; ve++) b = (b << 5) - b + R.charCodeAt(ve), b |= 0;
            return Math.abs(b);
          }(T).toString();
          p = (p + p.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), T = btoa(T).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var E = "", m = 0; m < p.length; m++) E += T.charAt(p[m]);
          return E || "zork";
        }
        function L(T, p) {
          return T = Math.round(Math.abs(T)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, T);
        }
        c.prototype.getItem = function(T) {
          return this.i[T] || this.client[T] || this.f[T];
        }, c.prototype.l = function(T) {
          this.f = T.embed, this.global = T.global, this.client = T.client, this.i = T.customer;
        };
        var y = null;
        y = new c(), function(T) {
          function p(S, I, Y) {
            var X = {
              homad_url_prefix_alias: "",
              homad_track_key: "*" + encodeURIComponent(S) + "*",
              homad_track_value: "*" + encodeURIComponent(I.toString()) + "*"
            }, W = Y ? null : function() {
              p(S, I, !0);
            };
            Y = Y ? E(!0) : m(), Xe(Y, null, W, X);
          }
          function E(S) {
            return S = S ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + S.slice(S.length - 2).join(".") + "/[hash]/").replace("[hash]", A(L()));
          }
          function m() {
            if (ie && ie.server) {
              var S = ie.server[Math.floor(Math.random() * ie.server.length)] + "";
              return S.replace("[hash]", A(L()));
            }
            return E(!1);
          }
          function R() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(I) {
              try {
                I.pause();
              } catch (Y) {
              }
              I.parentNode.removeChild(I);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(I) {
              I.parentNode.removeChild(I);
            }), window.self != window.top) for (var S = window.document; S.hasChildNodes(); ) S.removeChild(S.lastChild);
            Ee.get("setTimeout")(R, Math.round(1e3 + 100 * Math.random()));
          }
          function b(S) {
            return Re && clearTimeout(Re), p("stats_embed_penalty", S), R(), !1;
          }
          function Te() {
            Ae && Ae.enabled === !1 || ie && ie.enabled === !1 || ue && ue.enabled === !1 ? clearTimeout(Re) : b("load_main");
          }
          function ve() {
            Xe(ue.src.toString(), function(S) {
              ue.src.toString() === S.responseURL ? (S = rt(S.responseText), ue.data = S, ue.enabled = g(S.enabled), Te()) : b("redirect_customer");
            }, function() {
              ue.data = {}, ue.enabled = void 0, Te();
            });
          }
          function _t() {
            var S = ie.src;
            typeof S == "string" ? Xe(S.toString(), function(I) {
              S.toString() === I.responseURL ? (I = rt(I.responseText), ie.data = I, ie.enabled = g(I.enabled), ue.src = I.config, ve()) : b("redirect_client");
            }, function() {
              ie.data = {}, ie.enabled = void 0, ve();
            }) : (ie.data = typeof S == "function" ? S() : S, ve());
          }
          function ei() {
            Xe(Ae.src.toString(), function(S) {
              Ae.src.toString() === S.responseURL ? (S = rt(S.responseText), Ae.data = S, Ae.enabled = g(S.enabled), _t()) : b("redirect_global");
            }, function() {
              Ae.data = {}, Ae.enabled = void 0, _t();
            });
          }
          function ti(S) {
            clearTimeout(Re);
            var I = new S();
            I.init(y.f.globalConfig, y.f.clientConfig, !0, function() {
              y.f.utilsReady(I);
            }, function() {
              b("utils_init");
            }, y.f);
          }
          function it(S) {
            var I = Mt.shift();
            I ? !window[D()] || S ? ii(I) : S || clearTimeout(Re) : ei();
          }
          function Xe(S, I, Y, X) {
            X = X === void 0 ? null : X;
            var W = new XMLHttpRequest();
            if (W.onreadystatechange = function() {
              I && W.readyState == 4 && W.status == 200 && I(W), Y && W.readyState == 4 && W.status != 200 && Y(W);
            }, X) {
              var je = "", nt;
              for (nt in X) je += "&" + nt + "=" + encodeURIComponent(X[nt]);
              je = je.substr(1), W.open("POST", S, !0), W.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), W.send(je);
            } else W.open("GET", S, !0), W.send();
          }
          function ii(S) {
            var I = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("script") : Ee.get("createElement")("script"), Y;
            if (I.setAttribute("data-info", We), I.src = S, I.onload = function(W) {
              W.currentTarget.getAttribute("id") === D() ? st() ? (W = Y[We.split("").reverse().join("")], ti(W)) : clearTimeout(Re) : Mt.length ? it(!0) : b("main_redirect");
            }, I.onerror = function() {
              it(!0);
            }, window[D()] || (window[D()] = L(5 + Math.round(5 * Math.random()))), st()) {
              var X = document.createElement.toString().indexOf("native code") !== -1 ? document.createElement("iframe") : Ee.get("createElement")("iframe");
              if (!X || X.nodeName.toLowerCase() !== "iframe" || !X.nodeType) return b("utils_iframe");
              X.style.display = "none", X.onload = function() {
                if (Y = X.contentWindow, Y[We] = T, X.contentWindow.document.body.appendChild(I) !== I) return b("utils_script");
              }, document.body.appendChild(X);
            } else document.head.appendChild(I);
          }
          function rt(S) {
            var I = Ee.get("JSON");
            try {
              var Y = I.parse(S);
            } catch (X) {
              Y = {};
            }
            return Y;
          }
          function st() {
            return y.f.utilsReady != null;
          }
          var We = L(10 + Math.round(10 * Math.random()));
          window[We] = T, y = new c(), y.l({
            embed: T
          }), y.f.version = "20230601_1407";
          var Re = 0, ri = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], si = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], Mt = st() ? si : ri, Ae = {
            src: T.globalConfig,
            enabled: void 0,
            data: null
          }, ie = {
            src: T.clientConfig,
            enabled: void 0,
            data: null
          }, ue = {
            src: null,
            enabled: void 0,
            data: null
          }, Ee = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var S = document.createElement("iframe");
              S.style.display = "none", document.body.appendChild(S);
              var I = S.contentWindow;
            } else document.head ? (S = document.createElement("iframe"), S.style.display = "none", document.head.appendChild(S), I = S.contentWindow) : I = window;
            Ee.set("JSON", I.JSON), Ee.set("createElement", I.document.createElement.bind(document)), Ee.set("setTimeout", I.setTimeout.bind(window)), S && S.parentNode && S.parentNode.removeChild(S);
          })(), function() {
            Re = Ee.get("setTimeout")(function() {
              b("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), it();
        }(d);
      }();
    })();
  }).bind(s)(s);
}
let z = null, $ = null;
const M = class M extends Se {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, t) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: w.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = z = t, this.environmentVars = {}, this.error = null, this.initialURLHandler = t.urlhandler ? t.urlhandler : ce, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(o.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = V.EventDispatcher.addEventListener(
      o.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = z.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  /** @internal */
  initializeHOMAD(e) {
    const t = new ge();
    t.setFromObject(this.environmentVars.vastMacros), t.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(He)), $ = new V(this.config.adReinsertion, t);
    let i = (s) => {
      a.debug.info(M.NAME + "initializeHOMAD - Utils ready.", s), a.debug.info(M.NAME + "initializeHOMAD - Set vendor API.", s), $.setVendorAPI(s), $.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), $.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = s;
    }, r = (s) => {
      a.debug.warn(M.NAME + "initializeHOMAD Penalty"), i = () => {
      }, $.vendorAPI ? (a.debug.warn("initializeHOMAD - Penalty during ad playback."), oe.call(this, f.SESSION.AD_REINSERTION_PENALTY)) : (a.debug.warn("initializeHOMAD - Error.", s), oe.call(this, f.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(o.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const s = e.adReinsertion.homad.setup;
      Fi(
        s.globalConfig,
        s.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (n) => {
          i(n);
        },
        (n) => {
          r(n);
        }
      );
    }
  }
  /** @internal */
  forceHOMADActivation() {
    this.error && this.error.code === f.SETUP.AD_REINSERTION_PENALTY.code || ($.setReinsertionReason({
      reason: V.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), $.enable(
      () => {
        a.debug.info(
          M.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(o.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        a.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, t = {}) {
    this.adBreak = e, this.environmentVars = t, this.error = null;
    let i = null;
    return this.rejectSlotChanges ? (oe.call(this, f.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : Ui(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = _e(z.timeouts, t.timeouts), this.environmentVars.omidServiceWindow = t.omidServiceWindow || this.config.adVerification.serviceWindow, a.debug.info(M.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((r, s) => {
      this.adBreak.type || (this.adBreak.type = w.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === w.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === w.NON_LINEAR && !this.environmentVars.adContainer && a.debug.warn(M.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, i = super.addEventListener(o.ON_AD_MANIFEST_LOAD_ERROR, () => (a.debug.info(M.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), s(this.error))), super.addEventListener(o.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), i && i(), this.rejectSlotChanges = !1, r("ok")));
      const n = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        a.debug.info(
          M.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), oe.call(this, f.SESSION.TIMEOUT), this.dispatchEvent(o.ON_AD_MANIFEST_LOAD_ERROR);
      }, n * 1e3), this.parse(this.adBreak);
    })) : (oe.call(this, f.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, t) {
    let i = "HOMADUtils.corroborate - ", r = "Utils not ready.";
    return new Promise((s, n) => {
      if (!z.adReinsertion.homad.utils)
        throw a.debug.info(i + r), new Error(i + r);
      z.adReinsertion.homad.utils.corroborate(t).then(() => {
        a.debug.info(i + "resolved."), s();
      }).catch((d) => {
        a.debug.info(i + "rejected.", d), n(d);
      });
    });
  }
  /** @internal */
  onAdReinsertionActivation(e) {
    return new Promise((t, i) => {
      if (!z.adReinsertion.homad.setup.activationCallback)
        return t();
      let r = z.adReinsertion.homad.setup.activationCallback.bind(this), s = !1, n = setTimeout(() => (s = !0, t()), V.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), d = "onAdReinsertionActivation ";
      try {
        r(e).then(() => {
          if (clearTimeout(n), a.debug.info(d + "approved."), !s)
            return t();
        }, (h) => {
          if (clearTimeout(n), a.debug.warn(d + "declined.", typeof h), h && h.stack && h.message)
            return $.disable(), t();
          if (!s)
            return $.disable(), i();
        });
      } catch (h) {
        return clearTimeout(n), a.debug.warn(d + "failed. Error in activationCallback:", h), s = !0, $.disable(), t();
      }
    });
  }
  /** @internal */
  setupEnrichmentAndTCF() {
    const e = new ge();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(He)), this.environmentVars.vastMacros.GDPRCONSENT || new wi(e), e;
  }
  /** @internal */
  restartAdSlot() {
    a.debug.info(M.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), z.urlhandler = Ze, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : a.debug.warn(M.NAME + "What to do next?");
    }).catch((e) => {
      a.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  /** @internal */
  parse(e) {
    const t = Vi(e);
    a.debug.info(M.NAME + "parse - Start parsing the ad slot", t);
    const i = this.setupEnrichmentAndTCF();
    $ = new V(this.config.adReinsertion, i);
    let r = JSON.parse(JSON.stringify(z.timeouts));
    const s = {
      adReinsertion: $,
      blockInsecureURL: z.blockInsecureURL,
      enrichment: i,
      maxWrapperDepth: z.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: t.response ? t.responseXML : null,
      timeouts: r,
      urlhandler: z.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: _e({}, r),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let n = null, d = this.adBreak;
    if (typeof t == "object" && (d = t), d.urls.length === 1 && (n = d.urls[0], s.response = null), n || s.response) {
      let h = new Rt(s);
      n ? h.requestURL(d.urls[0], this.onXMLLoadDone.bind(this, s)) : h.requestFinalXML(s.response, this.onXMLLoadDone.bind(this, s));
    } else
      a.debug.warn(
        M.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], s);
  }
  /** @internal */
  onXMLLoadDone(e, t) {
    this.rawXMLDocument = t, this.rawAdSlotModel = new Oi(t), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  /** @internal */
  handleParserResponse(e, t) {
    let i = t || {};
    if (!t) {
      let d = xe;
      i.adReinsertion = new V(d.adReinsertion, new ge()), i.timeouts = d.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let r = new bi(
      e,
      z,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = r.adSlotModel, this.adSlotBuffet = r.adSlotBuffet, this.sequenceData = r.sequenceData;
    const s = r.hasSessionTimeoutError, n = () => {
      if (!r.hasValidAds || s) {
        oe.call(this, s ? f.SESSION.TIMEOUT : f.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(o.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new gt(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(o.ON_AD_MANIFEST_LOADED);
    };
    if (i.adReinsertion.reinsertionReason && !i.adReinsertion.isActive) {
      a.debug.info(
        M.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        i.adReinsertion.reinsertionReason
      ), i.adReinsertion.enable(
        () => {
          i.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (d) => {
          a.debug.info(
            M.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            d
          ), n();
        }
      );
      return;
    }
    n();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      a.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      a.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      a.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === w.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(o.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(o.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const t = vt;
      this.slot = new t(this.currentAd, this.player, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(o.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const i = (r) => {
        this.dispatchEvent(r.type);
      };
      Object.values(o).forEach((r) => {
        this.slot.addEventListener(r, i), this.slot.adSlotController.addEventListener(r, i);
      }), this.slot.deliverNextAd();
    };
    this.adBreak.type === w.LINEAR ? (a.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((t) => {
      a.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      a.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  /** @internal */
  resetErrorWarning() {
    const e = [
      f.WARNING.TRACKER_LOAD_FAILED.code,
      f.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let t = 0; t < this.adSlotModelList.length; t++)
      e.indexOf(this.adSlotModelList[t].error.code) !== -1 && (this.adSlotModelList[t].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === w.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((t) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(M.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(o.ON_AD_SLOT_COMPLETE), t())), this.slot.stop().then(() => {
        e();
      }, (i) => {
        a.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", i), e();
      });
    });
  }
  /** @internal */
  resetContent() {
    a.debug.info(M.NAME + "Reset content.");
    let e = {
      code: f.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, t = !1, i = this.player.restoreContentState.bind(this.player), s = setTimeout(() => {
      t = !0, a.debug.error(M.NAME + "resetContent - timeout"), oe.call(this, e), this.dispatchEvent(o.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    i().then(() => {
      t || (clearTimeout(s), a.debug.info(M.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (n) => {
      t || (clearTimeout(s), a.debug.error(
        M.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        n
      ), e.message = "SessionError: Reset content failed.", oe.call(this, e), this.dispatchEvent(o.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  /** @internal */
  closeAdSlot() {
    $ && z.adReinsertion.homad.setup.enableSessionCoverage !== !0 && ($.disable(), z.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(M.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, t) {
    this.slot && this.slot.adSlotController.onResizeAd(e, t);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  clickThrough(e = !1) {
    if (this.slot)
      try {
        if (new Wt(this.slot.adSlotController.currentAd.hasClickThrough))
          return this.slot.adSlotController.onClickThrough(e);
      } catch (t) {
      }
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, t = !1) {
    if (this.slot)
      return this.dispatchEvent(o.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, t);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {number} reason The reason code corresponding to the cause of the failure.
   */
  /** @internal */
  verificationNotExecuted(e, t) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, t);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const t = this.ad.companions.filter((i) => i.id === e).shift();
    t && (this.dispatchEvent(o.ON_COMPANION_CREATIVE_VIEW), t.creativeViewTracker.length > 0 && (a.debug.table("Request companion creativeView trackers.", t.creativeViewTracker), this.slot.adSlotController.callTrackers(t.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, t = !0) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    if (i) {
      this.dispatchEvent(o.ON_COMPANION_CLICKED), i.clickTracker.length > 0 && (a.debug.table("Request companion click trackers.", i.clickTracker), this.slot.adSlotController.callTrackers(i.clickTracker));
      let r = i.clickThroughURL;
      if (r) {
        let s = this.slot.currentAd.enrichment.apply(r);
        if (!t) {
          const n = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(s, n);
        }
        return s;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot.play();
  }
  dispatchEvent(e) {
    return a.debug.info(M.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI | object} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new Wt(this.adSlotController.currentAd) : (a.debug.warn("There is no loaded ad."), {});
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot | object } Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new Pi(this.adSlotController, this.sequenceData) : (a.debug.warn("There is no loaded ad."), {});
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return $t.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
M.NAME = "AdSAPI::", M.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let Nt = M;
const Pe = class Pe {
  constructor(e, t) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = t;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (a.debug.info(Pe.NAME + "AdSlotAPI ready"), this.adSlotAPI = new Nt(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (a.debug.info(Pe.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (a.debug.info(Pe.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new Et(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
Pe.NAME = "MainCtlr::";
let It = Pe;
var Zt = /* @__PURE__ */ ((l) => (l.XHR = "xhr", l.JSONP = "jsonp", l))(Zt || {});
const Kt = "4.0", Gt = ["4.0"], Pt = class Pt {
  /**
   * Checks if the provided player facade has a valid handshake version.
   *
   * @internal
   * @param {Object} playerFacade - The player facade object with a handshakeVersion method.
   * @param {string} [facadeVersion=FACADE_VERSION] - The expected facade version.
   * @param {string[]} [supportedFacadeVersions=SUPPORTED_FACADE_VERSIONS] - An array of supported facade versions.
   * @returns {boolean} True if the handshake is valid, otherwise false.
   */
  hasValidHandshake(e, t = Kt, i = Gt) {
    if (!e.handshakeVersion)
      return !1;
    const r = e.handshakeVersion(t);
    return i.includes(r);
  }
  /**
   * Checks whether a `playerFacade` instance implements all expected functions and properties of `FacadeBase`.
   *
   * @internal
   * @param {PlayerFacade} playerFacade - The `playerFacade` instance to be checked.
   * @param {typeof FacadeBase} Facade - The class from which `playerFacade` is expected to implement.
   * @returns {boolean} - True if the implementation is correct, otherwise false.
   */
  hasValidFacadeImplementation(e, t = oi) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new t())).filter((s) => !(s in e)).length <= 0;
  }
  /**
   * Establishes a connection between the core and the provided player facade to control the audio/video player.
   *
   * @internal
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @returns {void} This function does not return a value but sets the 'error' property on failure.
   */
  validate(e) {
    if (!e) {
      this.error = f.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = f.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = f.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, t) {
    let i = _e(xe, t);
    return new Promise((r, s) => {
      this.validate(e);
      function n(d) {
        a.debug.critical("init - error", d), s(d);
      }
      Object.keys(this.initError).length > 0 ? n(this.initError) : r(new It(i, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return Zt;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return w;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return F;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return Lt(xe);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return He;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return o;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(o);
  }
  get LOGLEVEL() {
    return he;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    a.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return a.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return a.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return Kt;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return Gt;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.5.6";
  }
};
Pt.NAME = "Core::";
let tt = Pt;
const xi = new tt();
typeof window != "undefined" && (window.smartclientcore = xi);
typeof exports == "object" && (exports = {
  smartclientcore: tt
});
export {
  oi as FacadeBase,
  xi as default
};
