var tt = /* @__PURE__ */ ((A) => (A[A.SILENT = 0] = "SILENT", A[A.ERROR = 1] = "ERROR", A[A.NORMAL = 2] = "NORMAL", A[A.VERBOSE = 3] = "VERBOSE", A))(tt || {}), Oe = /* @__PURE__ */ ((A) => (A[A.CRITICAL = 0] = "CRITICAL", A[A.ERROR = 1] = "ERROR", A[A.INFO = 2] = "INFO", A[A.TABLE = 3] = "TABLE", A[A.WARN = 4] = "WARN", A))(Oe || {});
let Tt = tt.SILENT;
const Ri = "[OIS_DEBUG]", zs = {
  [tt.ERROR]: [Oe.CRITICAL, Oe.ERROR],
  [tt.NORMAL]: [Oe.INFO, Oe.TABLE, Oe.WARN],
  [tt.SILENT]: [],
  [tt.VERBOSE]: [Oe.CRITICAL, Oe.ERROR, Oe.INFO, Oe.TABLE, Oe.WARN]
};
function Kt() {
}
class c {
  /**
   * Sets the logging level for debug outputs.
   * @param {LOGLEVEL} level - The logging level, one of
   *  `LOGLEVEL.SILENT`, `LOGLEVEL.ERROR`, `LOGLEVEL.NORMAL`, or `LOGLEVEL.VERBOSE`.
   */
  static set logLevel(e) {
    Tt = e;
  }
  /**
   * Gets the current logging level.
   * @returns {number} - The current logging level.
   */
  static get logLevel() {
    return Tt;
  }
  /**
   * Checks whether a specific log type should be logged based on the logging level.
   * @internal
   * @param {LOGTYPE} type - The type of log (e.g., 'CRITICAL', 'INFO', 'ERROR', 'TABLE', or 'WARN').
   * @param {LOGLEVEL} level - The current logging level.
   * @returns {boolean} - `true` if the log type should be logged, otherwise `false`.
   */
  static shouldLog(e, i) {
    return i !== tt.SILENT && zs[i].includes(e);
  }
  /**
   * Provides methods for logging debug outputs.
   */
  static get debug() {
    return {
      critical: (this.shouldLog(Oe.CRITICAL, Tt) ? console.error : Kt).bind(console, Ri),
      info: (this.shouldLog(Oe.INFO, Tt) ? console.info : Kt).bind(console, Ri),
      error: (this.shouldLog(Oe.ERROR, Tt) ? console.error : Kt).bind(console, Ri),
      table: (this.shouldLog(Oe.TABLE, Tt) ? console.table : Kt).bind(console),
      warn: (this.shouldLog(Oe.WARN, Tt) ? console.warn : Kt).bind(console, Ri)
    };
  }
}
const Qs = "4.0";
class Js {
  constructor() {
    this.currentContentSource = {
      // eslint-disable-next-line no-undefined
      currentTime: void 0,
      // eslint-disable-next-line no-undefined
      progressive: void 0
    }, this.PLAYER_EVENT_MAP = {};
  }
  /**
   * Sets up a function that will be called whenever the specified event is delivered to the video player.
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   *
   * _*Note:*
   *
   * The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
   * events for non-HTML5 video players. The key represents the event from the custom player, while the value
   * corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
   * FacadeBase!
   */
  addEventListener(e, i) {
  }
  /**
   * Requests the ad playhead position from the video player.
   * @returns {Number} Total time in seconds.
   */
  // @ts-ignore: method return implemented over playerReference
  getAdCurrentTime() {
  }
  /**
   * Requests the ad-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getAdDuration() {
  }
  /**
   * Requests the current playhead position from the video player.
   * @returns {Number} Current time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentCurrentTime() {
  }
  /**
   * Requests the content-duration from the video player.
   * @returns {Number} Total time in seconds. _*Note:* The time can include milliseconds (3.1234)
   */
  // @ts-ignore: method return implemented over playerReference
  getContentDuration() {
  }
  /**
   * @returns {CurrentContentSource} SourceObject - Current content source and playhead progress
   */
  // @ts-ignore: method return implemented over playerReference
  getCurrentContentSource() {
  }
  /**
   * Requests the latest status of the video player, site, and other external factors.
   * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
   * @returns {EnvironmentVars} Object describing surrounding conditions and the expected ad properties.
   */
  // @ts-ignore: method return implemented over playerReference
  getEnvironmentVars(e) {
  }
  /**
   * Requests the player element.
   * @returns {HTMLAudioElement|HTMLVideoElement|null} The video or audio element or null.
   *
   * _*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerElement() {
  }
  /**
   * Requests the current size and viewMode from the video player.
   * @returns {ElementSize} Current player dimension specs
   */
  // @ts-ignore: method return implemented over playerReference
  getPlayerSize() {
  }
  /**
   * Requests the current size and viewMode from the viewport that surrounds the video player.
   * @returns {ElementSize} The dimension specs of the element
   */
  // @ts-ignore: method return implemented over playerReference
  getViewportSize() {
  }
  /**
   * Requests the current volume level from the video player.
   * @returns {Number} The current volume level between 0-1
   */
  // @ts-ignore: method return implemented over playerReference
  getVolume() {
  }
  /**
   * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
   * are supported.
   * @param {string} apiFacadeVersion - Required API version
   * @returns {string} Supported API version
   */
  handshakeVersion(e) {
    return Qs;
  }
  /**
   * Requests the video player to mute playback.
   * @returns {Promise} Resolves if the video player has been muted
   */
  // @ts-ignore: method return implemented over playerReference
  mute() {
  }
  /**
   * Requests the video player to unmute playback.
   * @returns {Promise} Resolves if the video player has been unmuted
   */
  // @ts-ignore: method return implemented over playerReference
  unmute() {
  }
  /**
   * Requests the current screen state from the video player.
   * @returns {Boolean} Fullscreen state
   */
  // @ts-ignore: method return implemented over playerReference
  isFullscreen() {
  }
  /**
   * Requests the current muted state from the video player.
   * @returns {Boolean} Muted state
   */
  // @ts-ignore: method return implemented over playerReference
  isMuted() {
  }
  /**
   * Requests the current pause state from the video player.
   * @returns {Boolean} Paused state
   */
  // @ts-ignore: method return implemented over playerReference
  isPaused() {
  }
  /**
   * Requests the video player to load and play the specified media file.
   * @param {string} url - The URI of the media file to be played.
   * @param {Boolean} autoPlay - Whether the requested media file starts playback immediately.
   * @param {Boolean} disableSeeking - Whether the requested source can be seeked back and forth.
   * @returns {Promise<void|number>} That resolves if the player accepts the media file request. If an error occurs, the
   *  Promise may reject with an optional error code.
   */
  // @ts-ignore: method return implemented over playerReference
  load(e, i = !0, r = !1) {
  }
  /**
   * Requests the video player to pause playback.
   * @returns {Promise} Resolves if the video player has been paused
   */
  // @ts-ignore: method return implemented over playerReference
  pause() {
  }
  /**
   * Requests the video player to start (resume) playback.
   * @returns {Promise} Resolves if the video player has been resumed
   */
  // @ts-ignore: method return implemented over playerReference
  play() {
  }
  /**
   * Removes an event listener from the video player that has been registered with `addEventListener()`
   * _*Note:* The event listener to be removed must match with the listener that has been added._
   * @param {string} type - A case-sensitive string representing the player event type to listen for.
   * @param {Function} callback - The function which receives a notification when an event of the specified type occurs.
   */
  removeEventListener(e, i) {
  }
  /**
   * restoreContentState is called right after the ad playback has finished.
   * Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.
   *
   * _*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.
   * @returns {Promise} Resolves if the player accepts the play request; otherwise, rejects.
   */
  // @ts-ignore: method return implemented over playerReference
  restoreContentState() {
  }
  /**
   * saveContentState is called right before the ad playback should begin. Notes the current playback state for
   *  later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.
   *
   * _*Note:* Promise.resolve() without the source and the current time of the content will not work.
   * @returns {Promise} Resolves with the current content source and playhead progress for VAST tracking enrichment.
   */
  // @ts-ignore: method return implemented over playerReference
  saveContentState() {
  }
  /**
   * Requests the video player to change the playhead position to the specified time.
   * @param {Number} offset - Requested playhead position
   * @returns {Promise} Resolves if the video player has finished seeking to the specified position
   */
  // @ts-ignore: method return implemented over playerReference
  seek(e) {
  }
  /**
   * Requests the video player to change the volume.
   * @param {Number} volume - Requested volume level between 0-1
   * @returns {Promise} Resolves if the video player accepted the volume change request
   */
  // @ts-ignore: method return implemented over playerReference
  setVolume(e) {
  }
}
var ae = /* @__PURE__ */ ((A) => (A.LINEAR = "linear", A.NON_LINEAR = "nonlinear", A))(ae || {});
class G {
  /**
   * Converts a time duration string into the equivalent time in seconds.
   *
   * @param {string} durationString - The time duration string in the format 'HH:MM:SS' to be converted.
   * @returns {number|null} The time duration in seconds or null if the input is invalid.
   */
  static convertTimeStringToSeconds(e) {
    const i = (/* @__PURE__ */ new Date(`1970-01-01T${e}Z`)).getTime();
    return isNaN(i) ? null : i / 1e3;
  }
  /**
   * Returns the most nested child within an Element (NodeTree) that matches the specified selector,
   * or group of selectors. If no matches are found, `null is returned.
   * (identically to the `Element` method `querySelector()`)
   *
   * @param {Element} baseElement - A DOM object that is scanned for an element that matches the specified selectors.
   * @param {string} selectors - A `DOMString` containing one or more selectors to match.
   * This string must be a valid CSS selector string.
   *
   * @returns {HTMLElement|null} - An HTMLElement object representing the element that matches
   * the specified set of CSS selectors, or null is returned if there are no matches.
   */
  static getMostNestedElement(e, i) {
    const r = Array.from(e.querySelectorAll(i));
    let s = -1, l = null;
    return r.forEach((h) => {
      let m = 0, E = h;
      for (; E.parentNode !== e; )
        m++, E = E.parentNode;
      m > s && (s = m, l = h);
    }), l;
  }
  /**
   * Creates a new Array with unique elements in it.
   *
   * @param {Array} array - The array to be cleaned of duplicates.
   * @param {string} uniqueValue - The property to search for duplicates in the array.
   * @returns {Array} - An array with unique elements defined by uniqueValue.
   */
  static getUnique(e, i) {
    const r = e.map((l) => l[i]);
    return e.filter((l, h) => !r.includes(l[i], h + 1));
  }
  /**
   * This function trims a string and returns it, unless the string is empty, null, or contains only the value 'null'.
   *
   * @param {string} resultString - The string to be checked.
   * @returns {string|null} The trimmed string or null if the string is empty, null, or 'null'.
   */
  static trim(e) {
    return e && e.trim().length !== 0 && e !== "null" ? e.trim() : null;
  }
}
class Zs {
  constructor(e) {
    this.adSourceXML = e, this.adSource = this.adSourceXML.querySelector("AdTagURI, VASTAdData, VASTData, CustomAdData");
  }
  get allowMultipleAds() {
    return this.adSourceXML.getAttribute("allowMultipleAds") === "true";
  }
  get followRedirects() {
    return this.adSourceXML.getAttribute("followRedirects") === "true";
  }
  get id() {
    return this.adSourceXML.getAttribute("id");
  }
  /**
   * @returns {*} An adTagURI or otherwise XML representing a VAST response or any custom XML
   */
  get source() {
    return this.adSource.nodeName.includes("AdTagURI") ? G.trim(this.adSource.textContent) : this.adSource.firstElementChild ? this.adSource.firstElementChild.outerHTML : G.trim(this.adSource.textContent);
  }
  get templateType() {
    return this.adSource.getAttribute("templateType");
  }
  // lowerCase for kepler and web
  get type() {
    return this.adSource.nodeName.toLowerCase();
  }
}
const Nt = class Nt {
  constructor(e, i = {}) {
    this.isRequested = !1, this.adBreakXML = e, this.publisherSpecs = i, this.hasBreakPosition = this.getBreakPosition(), this.extensionList = this.getExtensions(), this.multiMidroll = !1, this.separationClipsObj = this.getSeparationClips(), this.trackerList = this.getTrackers(), this.error = this.getError() || {
      // Use undefined since isNaN(null) in hasError would return true
      code: void 0,
      // eslint-disable-line no-undefined
      message: "",
      timestamp: null
    };
  }
  mapStringToAdType(e) {
    switch (e) {
      // Not supported for InStream
      // case 'display':
      // 	return AD_TYPE.DISPLAY;
      case "nonlinear":
        return ae.NON_LINEAR;
      default:
        return ae.LINEAR;
    }
  }
  /**
   * @internal
   */
  queryElements(e) {
    return Array.from(this.adBreakXML.querySelectorAll(e));
  }
  /**
   * @returns {AdSource} - Object representing the data or an URL to request the data or `null`
   */
  get adSource() {
    const e = this.adBreakXML.querySelector(":scope > AdSource");
    return e ? new Zs(e) : null;
  }
  /**
   * Optional attribute
   * @returns {string} the identifier for the AdBreak or an empty string
   */
  get breakId() {
    return this.adBreakXML.getAttribute("breakId") || null;
  }
  /**
   * Indicates the position of the ad break within the underlying video/audio content
   * that the ad is playing within.
   * @returns {number} the position
   */
  get breakPosition() {
    return this.hasBreakPosition;
  }
  get breakType() {
    var e;
    return (e = this.adBreakXML.getAttribute("breakType")) != null ? e : "";
  }
  get extensions() {
    return this.extensionList;
  }
  /**
   * Simple getter to check whether the adBreak can be delivered or not.
   * @returns {boolean} true if the adBreak is corrupted
   */
  get hasError() {
    return !isNaN(this.error.code);
  }
  get prefetchOffset() {
    return this.publisherSpecs[Nt.POSITION[this.breakPosition]] && this.publisherSpecs[Nt.POSITION[this.breakPosition]].prefetchOffset ? Math.abs(this.publisherSpecs[Nt.POSITION[this.breakPosition]].prefetchOffset) : 0;
  }
  /**
   * @returns {Number} Time in seconds after the AdBreak should be repeated
   */
  get repeatAfter() {
    const e = G.convertTimeStringToSeconds(
      this.adBreakXML.getAttribute("repeatAfter") || null
    ) || -1;
    return e !== -1 ? e : -1;
  }
  get requested() {
    return this.isRequested;
  }
  set requested(e) {
    this.isRequested = e;
  }
  get separationClips() {
    return this.separationClipsObj;
  }
  get timeOffset() {
    const e = this.adBreakXML.getAttribute("timeOffset");
    return e === "0%" ? "start" : e === "100%" ? "end" : e;
  }
  get trackingEvents() {
    return this.trackerList;
  }
  /**
   * AdBreak type property used by the core.
   * Note: We do not support mixed types as suggested by the VMAP standard (see VMAP 1.0.1 Chapter 2.4)
   * `
   * @returns {string} AdBreak type
   */
  get type() {
    const e = this.breakType.split(",")[0];
    return this.mapStringToAdType(e);
  }
  /**
   * Returns one of the following values:
   * - 1 for pre-roll
   * - 2 for mid-roll
   * - 3 for post-roll
   * - 4 for standalone  (in accordance with OM for Web, overlays are considered to be standalone)
   * - 0 for none of the above/other
   * @returns {number} The break position number according to IAB VAST BREAKPOSITION macro values
   */
  /** @internal */
  getBreakPosition() {
    return this.type === ae.NON_LINEAR ? 4 : this.timeOffset === "start" || this.timeOffset === "0%" || G.convertTimeStringToSeconds(this.timeOffset) === 0 ? 1 : this.timeOffset === "end" || this.timeOffset === "100%" ? 3 : 2;
  }
  /**
   * @returns {Array} list of all found VMAP Extensions
   */
  /** @internal */
  getExtensions() {
    return this.queryElements(":scope > Extensions > Extension").map(
      (e) => ({
        extensionXML: e,
        type: e.getAttribute("type") || ""
      })
    );
  }
  /**
   * @returns {Object} list of tracking objects by event name
   */
  /** @internal */
  getTrackers() {
    const e = {};
    return this.queryElements(":scope > TrackingEvents > Tracking").forEach(
      (i) => {
        const r = i.getAttribute("event"), s = i.textContent.trim();
        s && (e[r] = e[r] || [], e[r].push({ url: s }));
      }
    ), e;
  }
  /** @internal */
  getSeparationClips() {
    return this.publisherSpecs[Nt.POSITION[this.breakPosition]] || {};
  }
  getError() {
    const e = this.adBreakXML.querySelector("ParserError");
    return e ? {
      code: parseInt(e.getAttribute("code"), 10),
      message: e.getAttribute("message"),
      timestamp: null
    } : null;
  }
};
Nt.POSITION = [
  "unsupported",
  "preroll",
  "midroll",
  "postroll",
  "overlay"
];
let ei = Nt;
class eo {
  constructor(e, i) {
    this.adSlotList = [], this.midrollHasSameTimeOffset = !1, this.createAdSlotList(e, i);
  }
  createAdSlotList(e, i) {
    let s = [...(e.documentElement || e).querySelectorAll(":scope > *")];
    this.adSlotList = s.map((m) => new ei(m, i));
    let l = {}, h = [];
    if (this.adSlotList.forEach((m, E) => {
      m.breakPosition === 2 && m.timeOffset !== null && (l[m.timeOffset] = (l[m.timeOffset] || 0) + 1, l[m.timeOffset] > 1 && (m.multiMidroll = !0, h.length === 0 && (this.adSlotList[E - 1].multiMidroll = !0, this.adSlotList[E - 1].adBreakXML.setAttribute(
        "type",
        this.adSlotList[E - 1].adSource.type
      ), this.adSlotList[E - 1].adBreakXML.setAttributeNS(
        null,
        "allowMultipleAds",
        this.adSlotList[E].adSource.allowMultipleAds.toString()
      ), h.push(this.adSlotList[E - 1].adBreakXML.cloneNode(!0)), this.midrollHasSameTimeOffset = !0), this.adSlotList[E].multiMidroll = !0, m.adBreakXML.setAttribute("type", this.adSlotList[E].adSource.type), m.adBreakXML.setAttributeNS(
        null,
        "allowMultipleAds",
        this.adSlotList[E].adSource.allowMultipleAds.toString()
      ), h.push(m.adBreakXML.cloneNode(!0))));
    }), this.midrollHasSameTimeOffset) {
      let m = [];
      for (let S = 0; S < h.length; S++)
        if (h[S].getAttribute("type").includes("adtaguri")) {
          let M = document.createElementNS(null, "Ad");
          M.setAttribute("sequence", (S + 1).toString());
          let Q = document.createElementNS(null, "Wrapper");
          Q.setAttributeNS(
            null,
            "fallbackOnNoAd",
            h[S].getAttribute("allowMultipleAds")
          );
          let Z = document.createElementNS(null, "VASTAdTagURI");
          Z.textContent = h[S].querySelector("AdTagURI").textContent.trim(), Q.appendChild(Z), M.appendChild(Q), m.push(M);
        } else
          h[S].querySelector("Ad").setAttribute("sequence", (S + 1).toString()), m.push(h[S].querySelector("Ad"));
      let E = null;
      for (let S = 0; S < this.adSlotList.length; S++) {
        if (!this.adSlotList[S].multiMidroll)
          continue;
        if (this.adSlotList[S].adBreakXML.hasAttribute("type") && this.adSlotList[S].adBreakXML.getAttribute("type").includes("adtaguri") && (E = document.createElementNS(null, "VASTAdData")), this.adSlotList[S].adBreakXML.querySelector("Ad") || E) {
          if (E) {
            this.adSlotList[S].adBreakXML.querySelector("AdTagURI").remove();
            let Q = this.adSlotList[S].adBreakXML.querySelector("AdSource");
            const Z = document.createElementNS(null, "VAST");
            m.forEach((se) => {
              Z.appendChild(se);
            }), E.appendChild(Z), Q.appendChild(E);
          } else {
            this.adSlotList[S].adBreakXML.querySelector("Ad").remove();
            const Q = this.adSlotList[S].adBreakXML.querySelector("VAST");
            m.forEach((Z) => {
              Q.appendChild(Z);
            });
          }
          this.adSlotList[S].multiMidroll = !1, this.adSlotList[S] = new ei(this.adSlotList[S].adBreakXML, this.adSlotList[S].publisherSpecs);
          break;
        }
      }
      this.adSlotList = this.adSlotList.filter((S) => {
        if (!S.multiMidroll)
          return S;
      });
    }
  }
  getAdPlaylist() {
    return this.adSlotList;
  }
  get hasPlayableAdBreaks() {
    return !!this.adSlotList.filter((i) => !i.hasError && i.adSource).shift();
  }
}
class gt {
  constructor() {
    this.listeners = {};
  }
  /**
   * Adds an event listener for the given type.
   * @param {string} type - The type of the event to listen for.
   * @param {Function} listener - The function to call when the event is dispatched.
   * @returns {Function} A function that can be called to remove the listener.
   */
  addEventListener(e, i) {
    const r = this.listeners[e] || (this.listeners[e] = []);
    return r.includes(i) || r.push(i), () => {
      this.removeEventListener(e, i);
    };
  }
  /**
   * Dispatches an event of the given type with the given data.
   * @param {string} type - The type of the event to dispatch.
   */
  dispatchEvent(e) {
    const i = this.listeners[e];
    if (!i)
      return;
    const r = {
      type: e,
      timestamp: Date.now(),
      issuer: "smartclip"
    };
    for (let s = 0; s < i.length; s++)
      i[s].call(this, r);
  }
  /**
   * Checks whether an event listener has been added for the given type and listener function.
   * @param {string} type - The type of the event to check for the listener.
   * @param {Function} listener - The listener function to check for.
   * @returns {boolean} True if the listener has been added for the given type, false otherwise.
   */
  hasEventListener(e, i) {
    const r = this.listeners[e];
    return r && r.indexOf(i) !== -1;
  }
  /**
   * Removes an event listener for the given type.
   * @param {string} type - The type of the event to remove the listener for.
   * @param {Function} listener - The listener function to remove.
   */
  removeEventListener(e, i) {
    const r = this.listeners[e];
    if (r) {
      const s = r.indexOf(i);
      s !== -1 && r.splice(s, 1);
    }
  }
}
const w = {
  // == IAB Errors with Creative
  CREATIVE: {
    // The video player received an ad type that it was not expecting and/or cannot display.
    EXPECTED_DIFFERENT_ADTYPE: {
      code: 200,
      message: "Trafficking error. Video player received an ad type that it was not expecting and/or cannot display"
    },
    EXPECTED_DIFFERENT_LINEARITY: {
      code: 201,
      message: "Video player expecting different linearity"
    }
  },
  // == smartclip Errors with the current ad-break session
  SESSION: {
    AD_REINSERTION_DECLINED: {
      code: 200200,
      message: "AdReinsertion usage declined by the vendor"
    },
    // Invalid AdBreak definition.
    MANIFEST_SETUP_CORRUPT: {
      code: 200201,
      message: "Invalid AdBreak definition"
    },
    // An ad-break has already been started. Shut down the current ad-break by calling `stopAdSlot`.
    ALREADY_STARTED: {
      code: 200202,
      message: "An ad-break has already been started"
    },
    // Unknown Manifest Loading Error.
    MANIFEST_LOAD_FAILED: {
      code: 200203,
      message: "Unknown Manifest Loading Error"
    },
    // The manifest couldn't be loaded in time.
    TIMEOUT: {
      code: 200204,
      message: "The manifest couldn't be loaded in time"
    },
    MIXED_CONTENT: {
      code: 200205,
      message: "Mixed Content = The request has been blocked and must be served over HTTPS"
    },
    // Restoring the content after an ad-break failed.
    NOT_RESTORABLE: {
      code: 200206,
      message: "Restoring the content after an ad-break failed"
    },
    // AdReinsertion timeout - not included for the moment!
    AD_REINSERTION_TIMEOUT: {
      code: 200207,
      message: "AdReinsertion failed at runtime"
    },
    // AdReinsertion failed at runtime
    AD_REINSERTION_PENALTY: {
      code: 200208,
      message: "AdReinsertion failed at runtime"
    }
  },
  // == smartclip Errors with the setup initialization
  SETUP: {
    NO_FACADE: {
      code: 200100,
      message: "No facade was handed over"
    },
    INCORRECT_FACADE: {
      code: 200101,
      message: "The facade implementation is incorrect"
    },
    INVALID_HANDSHAKE: {
      code: 200102,
      message: "Handshake validation failed"
    },
    AD_REINSERTION_PENALTY: {
      code: 200103,
      message: "AdReinsertion initialization failed"
    }
  },
  // == IAB Errors with SIMID creative
  SIMID: {
    GENERAL_ERROR: {
      code: 902,
      message: "General InteractiveCreativeFile error code"
    }
  },
  // == IAB Errors with linear VAST tag
  VAST: {
    GENERAL_ERROR: {
      code: 400,
      message: "General Linear error. Video player is unable to display the Linear Ad"
    },
    FILE_NOT_FOUND: {
      code: 401,
      message: "File not found. Unable to find Linear/MediaFile from URI"
    },
    TIMEOUT: {
      code: 402,
      message: "Timeout of MediaFile URI"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 403,
      message: "Couldn't find MediaFile that is supported by this video player based on the attributes of the MediaFile element"
    },
    MEDIAFILE_DISPLAY_ERROR: {
      code: 405,
      message: "Problem displaying MediaFile"
    }
  },
  // == IAB Errors with non-linear VAST tag
  VAST_NONLINEAR: {
    GENERAL_ERROR: {
      code: 500,
      message: "General NonLinearAds error"
    },
    DISPLAY_ERROR: {
      code: 501,
      message: "Unable to display NonLinear Ad because creative dimensions do not align with creative display area (i.e., creative dimension too large)"
    },
    FILE_NOT_FOUND: {
      code: 502,
      message: "Unable to fetch NonLinearAds/NonLinear resource"
    },
    UNSUPPORTED_MIMETYPE: {
      code: 503,
      message: "Could not find NonLinearresource with supported type."
    },
    // == custom descriptions
    TIMEOUT: {
      // FILE_NOT_FOUND in time
      code: 502,
      message: "Timeout of Resource URI"
    }
  },
  /**
   * Please group error codes by type, and provide a short text as comment above the code
   *
   * Overview of error codes:
   * - https://wiki.iabtechlab.com/?title=VAST_Error_Code_Troubleshooting_Matrix
   * - https://support.google.com/dfp_premium/answer/4442429
   * - https://www.jwplayer.com/blog/vast-errors/ (grouped)
   */
  VMAP: {
    UNDEFINED: {
      code: 900,
      message: "Undefined error"
    },
    INVALID_SCHEMA: {
      code: 1e3,
      message: "VMAP schema validation error"
    },
    UNSUPPORTED_RESPONSE: {
      code: 1001,
      message: "Version of response not supported"
    },
    PARSE_ERROR: {
      code: 1002,
      message: "Parsing error"
    },
    UNSUPPORTED_TYPE: {
      code: 1003,
      message: "AdBreak type not supported"
    },
    DOCUMENT_ERROR: {
      code: 1004,
      message: "General ad response document error"
    },
    UNSUPPORTED_TEMPLATE: {
      code: 1005,
      message: "Ad response template type not supported"
    },
    EXTRACTION_ERROR: {
      code: 1006,
      message: "Ad response document extraction or parsing error"
    },
    TIMEOUT: {
      code: 1007,
      message: "Ad response document retrieval timeout"
    },
    RESPONSE: {
      code: 1008,
      message: "Ad response document retrieval error (e.g., HTTP server)"
    },
    /* Non-standard codes (also used by the IMA) */
    NO_ADBREAKS: {
      code: 200300,
      message: "The response does not contain any valid ads"
    }
  },
  // == IAB Errors with linear VPAID creative
  // General VPAID error. Creative doesn't initialize.
  VPAID: {
    GENERAL_ERROR: {
      code: 901,
      message: "General VPAID error"
    }
  },
  // == smartclip Warnings with the current ad-break session
  WARNING: {
    // Unknown Tracker Loading Error
    TRACKER_LOAD_FAILED: {
      code: 200400,
      message: "Unknown tracker loading error"
    },
    // The tracker couldn't be loaded in time.
    TRACKER_TIMEOUT: {
      code: 200401,
      message: "The tracker couldn't be loaded in time"
    }
  },
  // == IAB Errors with Wrapper
  WRAPPER: {
    // Same error code as TIMEOUT, but related to the whole request chain for a single branch of Wrappers
    CHAIN_TIMEOUT: {
      code: 301,
      message: "Wrapper chain timeout reached"
    },
    // Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element
    TIMEOUT: {
      code: 301,
      message: "Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. Includes request errors such as invalid URI, unreachable or request timeout for URI, and security or other exceptions related to requesting a VAST URI"
    },
    // Wrapper limit reached, as defined by the video player
    LIMIT_REACHED: {
      code: 302,
      message: "Wrapper limit reached, as defined by the video player. Too many Wrapper responses have been received with no InLine response"
    },
    // No Ads VAST response after one or more Wrappers. When working with third-party networks,
    //  the fill-rate can be less than 100%. If so, this is an expected error
    NO_RESPONSE: {
      code: 303,
      message: "No ads VAST response after one or more Wrappers. Also includes number of empty VAST responses from fallback"
    }
  },
  // == IAB Errors with the Tag
  XML: {
    INVALID_XML: {
      code: 100,
      message: "XML parsing error"
    },
    INVALID_SCHEMA: {
      code: 101,
      message: "VAST schema validation error"
    }
  }
};
let tr = null, ir = null, Ft = 0, Rn = null, rr = null;
const qe = class qe {
  constructor(e, i) {
    this.enrichment = i, this.reasonData = null, e && e.homad && (Rn = e), this.enrichment.set("BLOCKED", Ft, "blocked");
  }
  get isActive() {
    return Ft === 1;
  }
  get vendorAPI() {
    return rr;
  }
  setVendorAPI(e) {
    !rr && e && (rr = e);
  }
  get reinsertionReason() {
    return this.reasonData;
  }
  setReinsertionReason(e) {
    this.reasonData = e;
  }
  /**
   * @param {function} callback that HOMAD may use to decide whether they take responsibility
   * @returns {void}
   */
  setCorroborationCallback(e) {
    ir = e;
  }
  /**
   * @param {function} callback that publishers may use to accept or decline activating the ad reinsertion
   * @returns {void}
   */
  setActivationCallback(e) {
    tr = e;
  }
  /**
   * @param {Function} success There are reason why ad-reinsertion should be enabled. See `AdReinsertionModel.REASON`
   * @param {Function} failure Data that might help understanding the error, e.g. `xhr` status
   * @returns {void}
   */
  enable(e, i) {
    if (c.debug.warn("AdReinsertionModel: Trying to activate AdReinsertion."), !Rn.homad.enabled) {
      let l = new Error("AdReinsertionModel: HOMAD not enabled by the publisher.");
      i(l);
      return;
    }
    if (!this.vendorAPI) {
      c.debug.warn("AdReinsertionModel: HOMAD enabled but not loaded."), requestAnimationFrame(() => {
        this.enable(e, i);
      });
      return;
    }
    if (!this.vendorAPI.isEnabled || !this.vendorAPI.isActive) {
      let l = new Error("AdReinsertionModel: Fallback not activated.");
      l = w.SESSION.AD_REINSERTION_DECLINED, i(l);
      return;
    }
    if (!ir) {
      i("HOMAD corroboration callback not set.");
      return;
    }
    let r = this.reasonData.reason, s = this.reasonData;
    ir(r, s).then(() => {
      Ft !== qe.STATUS.IS_BLOCKED ? tr ? tr(r).then((l) => {
        c.debug.info(
          ">> AdReinsertion success: Activation has been approved by the publisher."
        ), this.enrichment.set(
          "BLOCKED",
          qe.STATUS.IS_BLOCKED,
          "blocked"
        ), Ft = qe.STATUS.IS_BLOCKED, e();
      }).catch((l) => {
        c.debug.info(
          ">> AdReinsertion error: Activation has been declined by the publisher."
        ), this.disable(), i("AdReinsertion request declined by publisher.", l);
      }) : (c.debug.warn(
        ">> AdReinsertion warning: Activation callback not set. Activation will be approved by default."
      ), this.enrichment.set(
        "BLOCKED",
        qe.STATUS.IS_BLOCKED,
        "blocked"
      ), Ft = qe.STATUS.IS_BLOCKED, e()) : (c.debug.info(">> AdReinsertion has been enabled already. success."), e());
    }, (l) => {
      this.disable(), i("AdReinsertion request declined by HOMAD.", l);
    });
  }
  disable() {
    Ft = 0, this.enrichment.set("BLOCKED", qe.STATUS.IS_OPEN, "blocked");
  }
};
qe.REASON = {
  XHR_TIMEOUT: 201e3,
  XHR_UNEXPECTED_STATUS: 201001,
  XHR_ERROR: 201002,
  XML_PARSING_ERROR: 201003,
  WRAPPER_CHAIN_TIMEOUT: 201004,
  AD_SLOT_TIMEOUT: 201005,
  XHR_PROMISE_ERROR: 201006,
  MEDIAFILE_TIMEOUT: 201010,
  MEDIAFILE_LOAD_ERROR: 201013,
  FORCE_ACTIVATION: 201020
}, qe.STATUS = {
  IS_BLOCKED: 1,
  IS_OPEN: 0
}, qe.TIMEOUT = {
  ACTIVATION_CALLBACK_RESPONSE: 250
}, qe.EventDispatcher = new gt();
let le = qe;
class be {
  /*
  	 Returns current OS as String
  	 Used in EnrichmentModel
  
  	 based on https://stackoverflow.com/a/19883965
  	 */
  static operatingSystem() {
    return navigator.platform;
  }
  static userAgent() {
    return navigator.userAgent;
  }
  static screenResolution() {
    return {
      height: be.screenHeight(),
      width: be.screenWidth()
    };
  }
  static screenWidth() {
    return window.screen.width;
  }
  static screenHeight() {
    return window.screen.height;
  }
  static domain() {
    return window.location.href.split("/")[2];
  }
  /**
   * returns true if we are inside an IFrame
   *
   * @return {boolean} inside an IFrame
   */
  static isIF() {
    return window !== top;
  }
  /**
   * returns true if we are inside an friendly iframe
   *
   * @return {boolean} inside an friendly iframe
   */
  static isFIF() {
    return be.isIF() && window.frameElement !== null;
  }
  /**
   * returns true if were in a friendly IFrame, or in no frame at all
   * used by the URLEnrichment flag AllowInSwipe
   *
   * @returns {boolean} inside friendly IFrame, or no IFrame at all
   */
  static isFriendlyIFrameOrNoFrame() {
    return !be.isIF() || be.isFIF();
  }
}
function to() {
  return Math.round(Math.random() * 89999999) + 1e7;
}
function _i(A) {
  return encodeURIComponent(A).replace(/[!'()*]/g, (e) => "%" + e.charCodeAt(0).toString(16));
}
function io() {
  const A = /* @__PURE__ */ new Date(), e = A.toISOString();
  let i = A.getTimezoneOffset() / 60, r = i < 0 ? "-" : "+" + ("0" + Math.abs(i)).slice(-2);
  return e.replace("Z", r);
}
function ro(A, e, i) {
  if (A.indexOf(e) === -1)
    return A;
  {
    const r = new RegExp(`\\[${e}+(\\|\\d+){0,1}\\]`, "ig");
    let s = /\d+/.test(A) ? parseInt(A.match(/\|(\d+)]/)[1], 10) : 0;
    return A.replace(
      r,
      s === 0 ? _i(i) : _i(i).substring(0, s)
    );
  }
}
function Di(A) {
  let e = !Number.isFinite(A) || A < 0 ? 0 : A;
  const i = /* @__PURE__ */ new Date(0);
  return i.setSeconds(e), i.toISOString().substring(11, 19) + ".000";
}
function Un() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (A) => {
    let e = Math.random() * 16 | 0;
    return (A === "x" ? e : e & 3 | 8).toString(16);
  });
}
class Et {
  constructor() {
    this.macroMap = /* @__PURE__ */ new Map(), this.setDefaultMacros();
  }
  // macro iab overview
  // https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
  // APIFRAMEWORKS - if a new API is supported, changes are required here
  // https://github.com/InteractiveAdvertisingBureau/AdCOM/blob/master/AdCOM%20v1.0%20FINAL.md#list_apiframeworks
  // required
  // CACHEBUSTER, ERRORCODE, REASON, LIMITADTRACKING, TIMESTAMP
  // required (if OM is supported) + for App/Web is supported, otherwise Optional.
  // OMIDPARTNER + APPBUNDLE, PAGEURL
  setDefaultMacros() {
    this.set("ADCATEGORIES", -1, "adcategories"), this.set("ADCOUNT", -1, "adcount"), this.set("ADPLAYHEAD", -1, "adplayhead"), this.set("ADSERVINGID", -1, "adservingid"), this.set("ADTYPE", -1, "adtype"), this.set("ALLOWINSWIPE", -1, ["allowinswipe"], be.isFriendlyIFrameOrNoFrame), this.set("APIFRAMEWORKS", [2, 7, 8, 9], "apiframeworks"), this.set("APPBUNDLE", -1, "appbundle"), this.set("ASSETURI", -1, "asseturi"), this.set("BLOCKED", 0, "blocked"), this.set("BLOCKEDADCATEGORIES", -1, "blockedadcategories"), this.set("BREAKPOSITION", -1, "breakposition"), this.set("CACHEBUSTER", -1, ["cachebusting", "cachebuster", "rand(om|num)"], to), this.set("CLICKPOS", -1, "clickpos"), this.set("CLICKTYPE", -1, "clicktype"), this.set("CLIENTUA", -1, "clientua"), this.set("CONTENTID", -1, "contentid"), this.set("CONTENTURI", -1, "contenturi"), this.set("CONTENTPLAYHEAD", -1, "contentplayhead", Di), this.set("DEVICEIP", -1, "deviceip"), this.set("DEVICEUA", be.userAgent(), "deviceua"), this.set("DOMAIN", be.domain(), "domain"), this.set("ERRORCODE", 0, "errorcode"), this.set("EXTENSIONS", -1, "extensions"), this.set("FIF", -1, "fif", be.isFIF), this.set("GDPRCONSENT", -1, "gdprconsent"), this.set("IFA", -1, "ifa"), this.set("IDFAID", -1, "idfaid", () => this.macroMap.get("IFA")), this.set("IFATYPE", -1, "ifatype"), this.set("INVENTORYSTATE", -1, "inventoryState"), this.set("LATLONG", -1, "latlong"), this.set("LIMITADTRACKING", -1, "limitadtracking"), this.set("MEDIAMIME", -1, "mediamime"), this.set("MEDIAPLAYHEAD", 0, "mediaplayhead", Di), this.set("OS", be.operatingSystem(), "os"), this.set("OMIDPARTNER", "Smartcliptv/7.5.6", "omidpartner"), this.set("PAGETITLE", document.title, "pagetitle"), this.set("PAGEURL", document.URL, "pageurl"), this.set("PLACEMENTTYPE", -1, "placementtype"), this.set("PLAYERCAPABILITIES", -1, "playercapabilities"), this.set("PLAYERSIZE", {}, ["playersize"], this.getResolution), this.set("PLAYERWIDTH", -1, ["player_width", "playerwidth"], () => this.getPlayerDimension("width")), this.set("PLAYERHEIGHT", -1, ["player_height", "playerheight"], () => this.getPlayerDimension("height")), this.set("PLAYERSTATE", -1, "playerstate"), this.set("PODSEQUENCE", -1, "podsequence"), this.set("REASON", -1, "reason"), this.set("REGULATIONS", -1, "regulations"), this.set(
      "SCREENRES",
      be.screenResolution(),
      ["screen_res", "screenres"],
      this.getResolution
    ), this.set("SCREENHEIGHT", be.screenHeight(), "screenheight"), this.set("SCREENWIDTH", be.screenWidth(), "screenwidth"), this.set("SERVERSIDE", 0, "serverside"), this.set("SERVERUA", -1, "serverua"), this.set("TIMESTAMP", -1, "timestamp", io), this.set("TRANSACTIONID", Un(), "transactionid"), this.set(
      "UNIVERSALADID",
      -1,
      "universaladid",
      (e) => Array.isArray(e) ? e.map((i) => i.idRegistry + " " + i.idValue) : e
    ), this.set("VASTVERSIONS", [2, 3, 5, 6, 7, 8, 11, 12, 13, 14], "vastversions"), this.set("VERIFICATIONVENDORS", -1, "verificationvendors");
  }
  /** @internal */
  getPlayerDimension(e) {
    var r;
    return ((r = this.macroMap.get("PLAYERSIZE").value) == null ? void 0 : r[e]) || 0;
  }
  /** @internal */
  getResolution(e) {
    const i = parseInt((e == null ? void 0 : e.width) || "0", 10), r = parseInt((e == null ? void 0 : e.height) || "0", 10);
    return `${i},${r}`;
  }
  /** @internal */
  getMacros(e = !1) {
    let i = {};
    return this.macroMap.forEach((r, s) => {
      const l = e ? `[${s}]` : s;
      i[l] = this.get(s, !0);
    }), i;
  }
  /**
   * Returns all macros as defined by the IAB and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getMacroList() {
    return this.getMacros();
  }
  /**
   * Returns all macros as defined by the IAB, but surrounded by square brackets,
   *  and its encoded values.
   * @returns {Object} list of macro value pairs
   */
  getIABMacroList() {
    return this.getMacros(!0);
  }
  /**
   * Key and Value have to be set everytime,
   * macroToReplace needs to be set at least once
   * transformFunction is a function to be called each time the macro is replaced,
   * so you can set a value like this
   *      set('size', {width:w, height:h}, ['WxH'], function(obj){return obj.width+'x'+obj.height;}
   * while on updating the value only
   *      set('size', {width:w, height:h});
   * is needed
   *
   * @param {String} key reference key
   * @param {*} value usually a string, however transformFunction can make this a string
   * @param {(String|String[])} [macroToReplace] the macro to replace
   * @param {Function} [transformFunction] value will sent through this function on each apply call
   * @return {EnrichmentModel} to set() functions can be chained
   */
  set(e, i, r, s) {
    let l = this.macroMap.get(e) || {}, h = r || l.macroList;
    return l.value = i, h ? Array.isArray(h) ? l.macroList = h : l.macroList = [h] : l.macroList = [e.toLowerCase()], s && (l.transform = s), this.macroMap.set(e, l), this;
  }
  get(e, i = !1) {
    if (!e)
      return null;
    let r = this.macroMap.get(e + "");
    if (!r)
      return null;
    let s = r.value;
    return r.transform && (s = r.transform(s)), i ? Array.isArray(s) ? s.map((l) => _i(String(l))).join(",") : _i(String(s)) : s;
  }
  setFromObject(e) {
    e && Object.keys(e).forEach((i) => {
      let r = e[i];
      switch (typeof r) {
        case "string":
        case "object":
          r = r.length === 0 ? "-1" : r;
          break;
      }
      this.set(i.toUpperCase(), r, "");
    });
  }
  /**
   * Does replace all occurrences of macro replacement strings with values.
   * @param {string} inputString - This is most likely a URL
   * @returns {string|*} - Enriched URL
   */
  apply(e) {
    if (!e)
      return e + "";
    let i = e + "";
    return this.macroMap.forEach((r, s) => {
      let l = this.get(s, !0) + "";
      r.macroList.map((h) => {
        i = this.replaceMacroWithValue(i, h, l);
      });
    }), i;
  }
  replaceMacroWithValue(e, i, r) {
    let s = e.replace(this.getRegExp(i), r);
    return ro(s, "[" + i, r);
  }
  getRegExp(e) {
    let i = "[\\[](" + e + ")[\\]]";
    return new RegExp(i, "gi");
  }
}
class Li {
  xdrRequest() {
    return typeof window != "undefined" && window.XDomainRequest ? window.XDomainRequest : null;
  }
  static supported() {
    return !!new Li().xdrRequest();
  }
  get(e, i, r) {
    if (this.xdrRequest()) {
      let s = new XMLHttpRequest();
      s.open("GET", e), s.timeout = i.timeout || 0, s.withCredentials = i.withCredentials !== !1, s.onload = () => {
        let l = new DOMParser().parseFromString(s.responseText, "text/xml");
        r(null, l);
      }, s.onerror = () => {
        r(new Error("Error loading the XML document"));
      }, s.send();
    } else
      r(new Error("XDomainRequest is not supported"));
  }
}
class no {
  /**
   * Fetches an image from the specified URL.
   * @param {string} url - URL of the image to be fetched.
   * @param {object} options - Timeout options from the configuration.
   * @param {number} options.timeouts.adRequest - Timeout duration for the image request in seconds.
   * @param {Function} callback - A callback function that expects one parameter `xhrError` to handle errors.
   */
  static getAsImage(e, i, r) {
    let s = !1;
    const l = i.timeouts.adRequest * 1e3, h = setTimeout(() => {
      s = !0;
      let M = new Error("ImageURLHandler: Tracking request timeout.");
      M.code = w.WARNING.TRACKER_TIMEOUT.code, M.description = w.WARNING.TRACKER_TIMEOUT.message, M.type = "AdWarning", r(M);
    }, l);
    let m = new Image();
    m.src = "";
    const E = () => {
      clearTimeout(h), !s && r(null);
    }, S = (M) => {
      E();
    };
    return m.onerror = S, m.onload = E, m.src = e, m;
  }
}
function Sr(A) {
  if (typeof A != "string")
    return A;
  let e = null;
  if (DOMParser)
    e = new DOMParser().parseFromString(A, "text/xml");
  else if (ActiveXObject) {
    let i = new ActiveXObject("Microsoft.XMLDOM");
    i.loadXML(A), e = i;
  }
  return e;
}
const nr = " Response contains neither 'responseXML' nor 'responseText'", Ie = class Ie {
  /**
   * Creates and returns a new XMLHttpRequest object with CORS support.
   *
   * @returns {XMLHttpRequest | null} A new XMLHttpRequest object with CORS support, or null if the browser doesn't
   *  support CORS.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new Ie().xhrRequest();
  }
  /**
   * Performs an asynchronous HTTP GET request using XMLHttpRequest.
   *
   * @param {string} url - URL to make the GET request to.
   * @param {XHROptions} options - Additional options for the request. (timeout etc.)
   * @param {Function} callback - The callback function to handle the response.
   * @returns {void}
   */
  getAsXHR(e, i, r) {
    let s, l = r.timeouts.adRequest * 1e3, m = setTimeout(() => {
      s.onreadystatechange = s.onerror = () => {
        c.debug.info(Ie.NAME + ": Ignoring XHR state changes after timeout error", e);
      };
      let E = new Error(Ie.NAME + ": Request timeout");
      E.code = w.WRAPPER.TIMEOUT.code;
      let S = r.timeouts ? r.timeouts.errorMessage : null;
      E.message = S || w.WRAPPER.TIMEOUT.message, r.adReinsertion.setReinsertionReason({
        reason: r.isWrapper ? le.REASON.WRAPPER_CHAIN_TIMEOUT : le.REASON.XHR_TIMEOUT,
        xhr: s,
        xhrError: E
      }), i(E, null);
    }, l);
    try {
      s = this.xhrRequest(), s.withCredentials = r.withCredentials !== !1, s.overrideMimeType && s.overrideMimeType("text/xml"), s.onreadystatechange = () => {
        if (s.readyState === 1) {
          s.send();
          return;
        }
        if (s.readyState === 4)
          if (clearTimeout(m), s.status === 200) {
            let E = s.responseXML;
            if (!E && s.responseText && (E = Sr(s.responseText)), !E) {
              c.debug.info(Ie.NAME + nr);
              let S = new Error(Ie.NAME + nr);
              S.code = r.isWrapper ? w.WRAPPER.NO_RESPONSE.code : w.XML.INVALID_XML.code, S.message = "XHR Response Error:" + nr, r.adReinsertion.setReinsertionReason({
                reason: le.REASON.XHR_ERROR,
                xhr: s,
                xhrError: S
              }), i(S, null);
              return;
            }
            i(null, E);
          } else {
            s.onreadystatechange = s.onerror = () => {
              c.debug.info(Ie.NAME + "Ignoring XHR state changes after status error", s.readyState, s.status, e);
            };
            let E = new Error(Ie.NAME + s.statusText);
            E.code = r.isWrapper ? w.WRAPPER.TIMEOUT.code : w.XML.INVALID_XML.code, E.message = `XHR Status Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
              reason: le.REASON.XHR_UNEXPECTED_STATUS,
              xhr: s,
              xhrError: E
            }), i(E, null);
          }
      }, s.open("GET", e), s.onerror = () => {
        clearTimeout(m), c.debug.info(Ie.NAME + ": XHR Error.", s.readyState, s.status, e);
        let E = new Error(Ie.NAME + s.statusText);
        E.code = w.WRAPPER.TIMEOUT.code, E.message = `XHR Error (${s.status}): ${s.statusText}`, r.adReinsertion.setReinsertionReason({
          reason: le.REASON.XHR_UNEXPECTED_STATUS,
          xhr: s,
          xhrError: E
        }), i(E, null);
      };
    } catch (E) {
      clearTimeout(m);
      let S = new Error(`${Ie.NAME}: Request error.`);
      S.code = w.WRAPPER.TIMEOUT.code, S.message = `XHR Request Error: ${E}`, r.adReinsertion.setReinsertionReason({
        reason: le.REASON.XHR_ERROR,
        xhr: null,
        xhrError: S
      }), i(S, null);
    }
  }
  get(e, i, r) {
    c.debug.info(`${Ie.NAME}: XHR get with timeout ${r.timeouts.adRequest} sec: ${e}`), r.issuer && r.issuer === Ie.ISSUER.TRACKING ? no.getAsImage(e, r, i) : this.getAsXHR(e, i, r);
  }
};
Ie.ISSUER = {
  TRACKING: "TrackingURLHandler",
  TAG: "URLHandler"
}, Ie.NAME = "XHRURLHandler";
let ot = Ie;
ot.DEFAULT_TIMEOUT = 4;
function Mi(A, e) {
  if (A.indexOf("//") === 0) {
    let i = location.protocol;
    return (i === "about:" || i === "file:") && (i = "https:"), i + A;
  }
  return A.indexOf("://") === -1 ? e.slice(0, e.lastIndexOf("/")) + "/" + A : A;
}
const ti = {
  adRequestMethod: "xhr",
  adVerification: {
    accessMode: "full",
    disabled: !1,
    omidServiceWindow: null,
    playerHandles: !1,
    serviceWindow: window.top,
    sessionCleanupDelay: 3,
    timeoutScriptLoad: 1,
    vendorWhitelist: []
  },
  adReinsertion: {
    homad: {
      enabled: !1,
      setup: {
        globalConfig: "",
        clientConfig: "",
        activationCallback: () => {
        },
        enableSessionCoverage: !1,
        forceActivation: !1
      }
    }
  },
  adSourceSelector: null,
  blockInsecureURL: !0,
  maxWrapperDepth: 10,
  playerHandlesNonLinear: !1,
  shareVideoElementWithVPAID: !0,
  skipOffset: -1,
  timeouts: {
    adRequest: 1,
    adRequestChain: 2,
    adSlotRequest: 4,
    contentRequest: 3,
    nonlinearMaxDuration: 10,
    videoRequest: 3,
    vpaidReadiness: 3,
    vpaidRequest: 1
  },
  trackImpressionOnStart: !1,
  trackSkippedQuartiles: !1,
  viewability: {
    area: 50,
    time: 2
  }
};
class yr {
  constructor() {
    this.issuer = ot.ISSUER.TAG;
  }
  get(e, i, r) {
    if (!i)
      return null;
    let s = r, l = e;
    s || (s = ti, s.enrichment = new Et()), s.issuer = this.issuer, s.enrichment = s.enrichment || new Et(), l = s.enrichment.apply(l), l && l.indexOf("//") === 0 && (l = Mi(l, ""));
    let h = s.urlhandler;
    if (s.response) {
      let m = s.response;
      i(null, Sr(m));
    } else return h && h.supported() ? new h().get(l, i, s) : ot.supported() ? new ot().get(l, i, s) : Li.supported() ? new Li().get(l, i, s) : i();
    return null;
  }
}
const Qt = class Qt extends yr {
  constructor() {
    super(), this.issuer = ot.ISSUER.TRACKING;
  }
  track(e, i, r) {
    e && e.length > 0 && Array.isArray(e) ? this.getMultiple(e, i, r) : c.debug.info(Qt.NAME + "track - without trackers:", e);
  }
  getMultiple(e, i, r) {
    e.forEach((s) => {
      s.requested = !0, s.url && super.get(s.url, (i || this.onResponse).bind(this, s), r);
    });
  }
  // Error declaration in lib.es5.d.ts
  onResponse(e, i) {
    i && c.debug.warn(Qt.NAME + "onResponse failed:", i.name, i, e);
  }
};
Qt.NAME = "TrackingUrlHandler::";
let ii = Qt;
const p = {
  // Single Ad Events
  ON_AD_CLICKED: "AdClickThru",
  // clickThroughUrl
  ON_AD_CREATIVE_VIEW: "AdCreativeView",
  ON_AD_ERROR: "AdError",
  ON_AD_FIRST_QUARTILE: "AdVideoFirstQuartile",
  ON_AD_IMPRESSION: "AdImpression",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_MANIFEST_LOAD_ERROR: "AdTagLoadFailed",
  ON_AD_MID_POINT: "AdVideoMidpoint",
  ON_AD_MUTED: "AdMuted",
  ON_AD_PAUSED: "AdPaused",
  ON_AD_PLAYBACK_START: "AdVideoStart",
  ON_AD_PLAYBACK_FINISHED: "AdVideoComplete",
  ON_AD_PLAYING: "AdPlaying",
  ON_AD_PROGRESS: "AdProgress",
  ON_AD_REWIND: "AdRewind",
  ON_AD_SIZE_CHANGED: "AdSizeChanged",
  ON_AD_SKIPPABLE_STATE_CHANGE: "AdSkippableStateChange",
  ON_AD_SKIPPED: "AdSkipped",
  ON_AD_START: "AdStart",
  ON_AD_STARTED: "AdStarted",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_THIRD_QUARTILE: "AdVideoThirdQuartile",
  ON_AD_UNMUTED: "AdUnmuted",
  ON_AD_VOLUME_CHANGED: "AdVolumeChanged",
  ON_ENTER_FULLSCREEN: "EnterFullscreen",
  // replaced by playerExpand since VAST 4.1
  ON_EXIT_FULLSCREEN: "LeaveFullscreen",
  // replaced by playerCollapse since VAST 4.1
  ON_PLAYER_EXPAND: "PlayerExpand",
  ON_PLAYER_COLLAPSE: "PlayerCollapse",
  ON_CLOSED_CAPTIONS_DETECTED: "ClosedCaptionsDetected",
  ON_COMPANIONS_DETECTED: "CompanionsDetected",
  ON_EXTENSIONS_DETECTED: "ExtensionsDetected",
  ON_ICONS_DETECTED: "IconsDetected",
  ON_NONLINEAR_DETECTED: "NonLinearDetected",
  ON_VERIFICATION_DETECTED: "AdVerificationDetected",
  ON_COMPANION_CREATIVE_VIEW: "CompanionCreativeView",
  ON_COMPANION_CLICKED: "CompanionClickThru",
  ON_ICON_CLICKED: "IconClickThru",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_FINISHED: "AdOverlayViewFinished",
  ON_AD_NONLINEAR_STOPPED: "AdOverlayViewStopped",
  // Single VMAP Events
  ON_AD_PLAYLIST_LOADED: "AdPlaylistLoaded",
  ON_AD_PLAYLIST_LOAD_ERROR: "AdPlaylistLoadError",
  ON_AD_PLAYLIST_START: "AdPlaylistStart",
  ON_AD_PLAYLIST_STARTED: "AdPlaylistStarted",
  ON_AD_PLAYLIST_STOPPED: "AdPlaylistStopped",
  ON_AD_PLAYLIST_COMPLETE: "AdPlaylistComplete",
  // Multiple Ads Events
  ON_AD_SLOT_START: "AdSlotStart",
  ON_AD_SLOT_STARTED: "AdSlotStarted",
  ON_AD_SLOT_STOPPED: "AdSlotStopped",
  ON_AD_SLOT_COMPLETE: "AdSlotComplete",
  ON_AD_SLOT_DURATION_CHANGE: "AdSlotDurationChange",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "AdViewable",
  ON_AD_NOT_VIEWABLE: "AdNotViewable",
  ON_AD_VIEWABLE_STATE_CHANGE: "AdViewStateChange",
  ON_AD_VIEWABLE_UNDETERMINED: "AdViewUndetermined",
  // Custom Events
  ON_AD_WARNING: "AdWarning",
  ON_AD_REINSERTION_ACTIVATION: "AdReinsertionActivation",
  ON_AD_REINSERTION_PENALTY: "AdReinsertionPenalty",
  ON_GENERAL_ERROR: "GeneralError",
  ON_PLAYBACK_FINISHED: "PlaybackFinished",
  ON_SIMID_ERROR: "SIMIDError",
  ON_VPAID_CLEANUP: "VPAIDCleanup"
}, Ut = {
  ON_AD_CLICKED: "clickTracking",
  // clickThroughUrl
  ON_AD_ERROR: "error",
  ON_AD_STOPPED: "AdStopped",
  ON_AD_LINEARITY_CHANGE: "AdLinearChange",
  // isLinear
  ON_AD_MANIFEST_LOADED: "AdTagParsed",
  ON_AD_LOADED: "AdLoaded",
  // numAds
  ON_AD_SKIPPED: "skip",
  ON_AD_PLAYBACK_START: "start",
  ON_AD_FIRST_QUARTILE: "firstQuartile",
  ON_AD_MID_POINT: "midpoint",
  ON_AD_THIRD_QUARTILE: "thirdQuartile",
  ON_AD_PLAYBACK_FINISHED: "complete",
  ON_AD_PROGRESS: "progress",
  ON_AD_REWIND: "rewind",
  ON_AD_MUTED: "mute",
  ON_AD_UNMUTED: "unmute",
  ON_ENTER_FULLSCREEN: "fullscreen",
  ON_EXIT_FULLSCREEN: "exitFullscreen",
  ON_PLAYER_EXPAND: "playerExpand",
  ON_PLAYER_COLLAPSE: "playerCollapse",
  ON_AD_IMPRESSION: "impression",
  ON_AD_CREATIVE_VIEW: "creativeView",
  ON_AD_PAUSED: "pause",
  ON_AD_PLAYING: "resume",
  // viewableImpressionEvents
  ON_AD_VIEWABLE: "viewable",
  ON_AD_NOT_VIEWABLE: "notViewable",
  ON_AD_VIEWABLE_UNDETERMINED: "viewUndetermined",
  // NonLinear Ad Metrics
  ON_AD_NONLINEAR_STOPPED: "overlayViewDuration",
  // VMAP
  ON_AD_BREAK_START: "breakStart",
  ON_AD_BREAK_END: "breakEnd",
  ON_AD_BREAK_ERROR: "error"
}, Ct = class Ct {
  constructor(e, i, r) {
    this.player = i, this.config = r, this.adSlotAPI = e, this.eventHandlers = [], this.currentAdBreak = null, this.environmentVars = null, Ct.ERROR_CODE_MAP[w.SESSION.MANIFEST_LOAD_FAILED.code] = 1008, Ct.ERROR_CODE_MAP[w.SESSION.TIMEOUT.code] = 1007;
  }
  initAdSlot(e, i = {}) {
    e.requested = !0, c.debug.info(
      ve.NAME + "initAdSlot - Request core to init AdBreak",
      e.breakId,
      e.breakType,
      e.type
    ), this.currentAdBreak = e, this.environmentVars = i;
    const r = e.adSource.type.indexOf("adtaguri") > -1 ? "tag" : "response";
    let s = {};
    return s.adBreakPosition = e.breakPosition, s.type = e.type, s[r] = e.adSource.source, s = Object.assign(s, e.separationClips), this.currentAdBreak.enrichment = new Et(), this.currentAdBreak.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAdBreak.enrichment.set("BREAKPOSITION", e.breakPosition), this.currentAdBreak.adReinsertion = new le(
      this.config.adReinsertion,
      this.currentAdBreak.enrichment
    ), this.on(), new Promise((l, h) => {
      this.adSlotAPI.initAdSlot(s, i).then(() => {
        c.debug.info(
          ve.NAME + "initAdSlot - Initialized ad slot with adBreak",
          e.breakId
        ), l(e);
      }).catch((m) => {
        c.debug.warn(ve.NAME + "initAdSlot - Could not init ad slot", m), h(m);
      });
    });
  }
  startAdSlot() {
    let e = this.currentAdBreak;
    c.debug.info(
      ve.NAME + "startAdSlot",
      e.breakId,
      e.timeOffset,
      e.prefetchOffset,
      this.player.getContentCurrentTime()
    ), this.adSlotAPI.startAdSlot();
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    const e = [
      this.adSlotAPI.addEventListener(p.ON_AD_SLOT_START, () => {
        this.trackEvent(Ut.ON_AD_BREAK_START);
      }),
      this.adSlotAPI.addEventListener(p.ON_AD_SLOT_STOPPED, () => {
        this.trackEvent(Ut.ON_AD_BREAK_END);
      }),
      // Remove listeners. The AdPlaylistController creates a separate instance with each AdBreak
      this.adSlotAPI.addEventListener(p.ON_AD_SLOT_STOPPED, () => {
        this.off();
      }),
      /** Error Handling */
      this.adSlotAPI.addEventListener(p.ON_AD_MANIFEST_LOAD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Ct.ERROR_CODE_MAP[this.adSlotAPI.error.code] || this.adSlotAPI.error.code
        ), this.trackEvent(Ut.ON_AD_BREAK_ERROR);
      }),
      // Ad execution errors should report the same error code in VMAP that was reported for the VAST ad
      this.adSlotAPI.addEventListener(p.ON_AD_ERROR, () => {
        this.currentAdBreak.enrichment.set(
          "ERRORCODE",
          Object.keys(this.adSlotAPI.ad).length > 0 ? this.adSlotAPI.ad.error.code : this.adSlotAPI.error.code
        ), this.trackEvent(Ut.ON_AD_BREAK_ERROR);
      })
    ];
    this.eventHandlers = this.eventHandlers.concat(e), c.debug.info(
      ve.NAME + "on - Subscribed to ad slot events. Current list",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      ve.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    ), this.eventHandlers.forEach((e) => {
      e();
    }), this.eventHandlers = [];
  }
  /** @internal */
  trackEvent(e) {
    let i = this.currentAdBreak.trackingEvents[e];
    this.callTrackers(i);
  }
  /** @internal */
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(
        ve.NAME + "callTrackers - Request without URIs",
        e
      );
      return;
    }
    this.currentAdBreak.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    const i = {
      adReinsertion: this.currentAdBreak.adReinsertion,
      enrichment: this.currentAdBreak.enrichment,
      // @ts-expect-error: No values will be assigned if environmentVars is undefined or null!
      timeouts: Object.assign(this.config.timeouts, this.environmentVars.timeouts),
      urlhandler: this.config.urlhandler
    };
    new ii().track(e, (r, s) => {
      s && c.debug.warn(ve.NAME + "callTrackers - failed:", s, r);
    }, i);
  }
};
Ct.ERROR_CODE_MAP = {}, Ct.NAME = "AdBreakCtrl::";
let ar = Ct;
const ke = {
  ON_ENDED: "ended",
  ON_LOADED_DATA: "loadeddata",
  ON_TIME_UPDATED: "timeupdate",
  ON_PLAY: "playerPlay",
  ON_PAUSED: "playerPause",
  ON_VOLUME_CHANGED: "volumeChanged",
  ON_ERROR: "error"
}, sr = "Content - Scan for AdBreaks to play", de = class de extends gt {
  /**
   *
   * @param {AdPlaylist} playlist
   * @param {Object} config - smartclientcore.SCHEME.GLOBAL_CONFIG
   */
  constructor(e, i) {
    super(), this.adBreakController = null, this.adPlaylist = e.getAdPlaylist(), this.adSlotAPI = null, this.contentDuration = 1 / 0, this.contentFinished = !1, this.playlistComplete = !1, this.eventHandlers = [], this.config = i, this.player = null, this.playableAdBreaks = [], this.postroll = this.adPlaylist.filter((r) => {
      if (r.timeOffset === "end")
        return r;
    }), this.isSeeking = void 0;
  }
  setAdsAPI(e) {
    this.adSlotAPI = e;
  }
  setPlayer(e) {
    this.player = e;
  }
  dispatchFinishedEvents() {
    super.dispatchEvent(p.ON_AD_PLAYLIST_STOPPED), super.dispatchEvent(p.ON_AD_PLAYLIST_COMPLETE);
  }
  waitForAdSlotComplete() {
    this.adSlotAPI.addEventListener(p.ON_AD_SLOT_COMPLETE, () => {
      this.dispatchFinishedEvents();
    });
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `0`, `"start"`, `"0%"`.
   *
   * Note: Most likely we do not know any times from the content at this point in time.
   * @returns {Promise<void>}
   */
  beforeContent() {
    return this.contentFinished = !1, c.debug.info(
      de.NAME + "before" + sr + "."
    ), super.dispatchEvent(p.ON_AD_PLAYLIST_STARTED), this.requestAdBreak(0).then(() => {
      this.deliverAdBreak(), this.startContent();
    }).catch((e) => {
      c.debug.info(
        de.NAME + "requestAdBreak - Found no matching AdBreak.",
        e
      ), this.startContent();
    });
  }
  startContent() {
    this.adSlotAPI.addEventListener(p.ON_AD_SLOT_COMPLETE, () => {
      this.on();
    }), this.contentFinished = !1, this.contentDuration = this.player.getContentDuration(), c.debug.info(
      de.NAME + "start" + sr + " during content playback."
    ), this.on();
  }
  /**
   * This triggers all AdSlots that have an AdBreak with `timeOffset` equally to `this.player.getContentDuration()`,
   * `"end"`, `"100%"`.
   * @returns {Promise<void>}
   */
  afterContent() {
    return this.contentFinished = !0, c.debug.info(
      de.NAME + "after" + sr + "."
    ), this.playlistComplete ? Promise.resolve() : this.playableAdBreaks.length > 0 ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.deliverAdBreak(), Promise.resolve()) : (this.postroll && (this.playlistComplete = !0, this.dispatchFinishedEvents()), Promise.resolve());
  }
  stop() {
    this.off(), this.dispatchFinishedEvents();
  }
  /**
   * Walks through the adPlaylist and requests the AdBreak that matches the current playback progress
   *  with the given current offset and initializes the ad slot controller for it.
   *
   * @param {number} currentOffset - The current offset for which to request the AdBreak.
   * @returns {Promise<void>} A Promise that resolves when the AdBreak has been successfully initialized and added to
   *  the list of playable AdBreaks.
   * @throws {string} If no AdBreak can be found for the given current offset or if initialization of the AdBreak fails.
   */
  requestAdBreak(e) {
    if (this.player && this.isSeeking && this.postroll.length > 0 && e >= this.contentDuration - this.postroll[0].prefetchOffset && (this.isSeeking = !1, this.postroll = null, this.adPlaylist.forEach((s) => {
      s.timeOffset !== "end" && (s.requested = !0);
    }), this.requestAdBreak(e)), this.player && this.isSeeking || this.playlistComplete)
      return Promise.resolve();
    let i = this.find(e), r = i.shift();
    return i.forEach((s) => {
      s.requested = !0;
    }), r && this.playableAdBreaks.length && (r.requested = !0), new Promise((s, l) => {
      r && !r.requested ? (this.adBreakController = new ar(this.adSlotAPI, this.player, this.config), this.adBreakController.initAdSlot(r, this.player.getEnvironmentVars(r.type)).then((h) => {
        c.debug.info(
          de.NAME + "requestAdBreak - Initialized AdBreak",
          h.timeOffset
        ), this.contentFinished ? (this.playlistComplete = !0, this.waitForAdSlotComplete(), this.adBreakController.startAdSlot()) : this.playableAdBreaks.push(h), s();
      }).catch((h) => {
        c.debug.warn(
          de.NAME + "requestAdBreak - Failed to initialize ",
          r.timeOffset,
          h
        ), l(h);
      })) : l(
        de.NAME + "requestAdBreak - Could not find an AdBreak with timeOffset " + e
      );
    });
  }
  deliverAdBreak() {
    if (this.playableAdBreaks.length !== 0 && this.isExecutableAdBreak(
      this.playableAdBreaks[0],
      this.player.getContentCurrentTime(),
      de.PROCESS.DELIVERY
    )) {
      let e = this.playableAdBreaks.shift();
      this.duplicateAdBreak(e), c.debug.info(de.NAME + "deliverAdBreak - Start AdBreak", e.timeOffset), this.adBreakController.startAdSlot();
    }
  }
  find(e) {
    const i = e;
    return this.adPlaylist.filter((r) => {
      if (r.requested)
        return !1;
      let s = i;
      return r.prefetchOffset > 0 && (s += r.prefetchOffset), this.isExecutableAdBreak(r, s);
    });
  }
  /**
   * Checks if an ad break is executable based on the current time and process type.
   * @param {Object} adBreak - The adBreak to check.
   * @param {number} currentTime - The current playback time in seconds.
   * @param {string} [process=AdPlaylistController.PROCESS.TYPE] - The process type DELIVERY/REQUEST.
   * @returns {boolean} Returns true if the ad break is executable, false otherwise.
   */
  isExecutableAdBreak(e, i, r = de.PROCESS.REQUEST) {
    function s(h, m) {
      var S;
      const E = h - m;
      return (S = e.publisherSpecs) != null && S.strictOffsets ? E >= 0 && E <= de.STRICT_OFFSET_THRESHOLD : E >= 0;
    }
    if (e.timeOffset.indexOf("%") > -1) {
      const h = this.contentDuration * parseFloat(e.timeOffset) / 100;
      return s(i, h);
    }
    if (e.timeOffset === "start" || this.contentFinished && e.timeOffset === "end" && r === de.PROCESS.DELIVERY)
      return !0;
    if (e.timeOffset === "end" && !e.requested && r === de.PROCESS.REQUEST)
      return i - this.contentDuration >= 0;
    const l = G.convertTimeStringToSeconds(e.timeOffset);
    return l !== null && s(i, l);
  }
  /**
   * Duplicates the specified ad break and adds it to the ad playlist at a specified time offset.
   * @param {Object} adBreak - The ad break to duplicate.
   * @returns {void}
   */
  duplicateAdBreak(e) {
    if (e.repeatAfter <= 0)
      return;
    const r = this.player.getContentCurrentTime() + e.repeatAfter;
    let s = e.adBreakXML.cloneNode(!0);
    s.setAttribute("timeOffset", Di(r)), this.adPlaylist.push(new ei(s, e.publisherSpecs)), c.debug.info(
      de.NAME + "duplicateAdBreak - Updated adPlaylist",
      this.adPlaylist.slice(0)
    );
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.off();
    let e = Date.now(), i = 0, r = 0;
    this.addPlayerEventListener(ke.ON_TIME_UPDATED, () => {
      if (this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear)
        return;
      const s = this.player.getContentCurrentTime(), l = s - i, h = (Date.now() - e) / 1e3;
      l > h + 0.075 || l > 2 ? (this.isSeeking = !0, r = 0) : r >= de.NOF_REQUIRED_UPDATES_TO_UNSEEK && (this.isSeeking = !1), r = Math.min(
        r + 1,
        de.NOF_REQUIRED_UPDATES_TO_UNSEEK
      ), i = s, e = Date.now(), this.requestAdBreak(this.player.getContentCurrentTime()).catch(() => {
      }), this.deliverAdBreak();
    }), this.addPlayerEventListener(ke.ON_ENDED, () => {
      this.adSlotAPI.slot && this.adSlotAPI.ad.isLinear || this.afterContent();
    }), c.debug.info(
      de.NAME + "on - Subscribed to player and core events.",
      this.eventHandlers
    );
  }
  off() {
    c.debug.info(
      de.NAME + "off - Unsubscribe event listeners. Current list",
      this.eventHandlers
    ), this.eventHandlers.forEach((e) => {
      e();
    }), this.eventHandlers = [];
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventHandlers.push(r), r;
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
};
de.NAME = "AdPlaylistCtrl::", de.PROCESS = {
  REQUEST: "AdPlaylistController::request",
  DELIVERY: "AdPlaylistController::delivery"
}, de.STRICT_OFFSET_THRESHOLD = 2, de.NOF_REQUIRED_UPDATES_TO_UNSEEK = 4;
let ve = de;
const so = "HomadXHRUrlHandler", Nn = ": Response contains neither 'responseXML' nor 'responseText'", jt = class jt {
  /**
   * Creates an XMLHttpRequest object.
   * @returns {XMLHttpRequest|null} An XMLHttpRequest object if the browser supports it, or null if it does not.
   */
  xhrRequest() {
    let e = new XMLHttpRequest();
    return "withCredentials" in e ? e : null;
  }
  static supported() {
    return !!new jt().xhrRequest();
  }
  /**
   * @internal
   * @param url
   * @param options
   * @param callback - Method that expects two parameters `xhrError` and `responseXML` (in that order!)
   *
   */
  getAsXHR(e, i, r) {
    function s(E) {
      i(E, null);
    }
    function l(E) {
      if (r.issuer && r.issuer === ot.ISSUER.TRACKING) {
        i(null, null);
        return;
      }
      let S = E.responseXML;
      if (!S && E.responseText && (S = Sr(E.responseText)), !S) {
        let M = new Error(so + Nn);
        M.code = w.XML.INVALID_XML.code, M.description = "HOMAD Response Error" + Nn, i(M, null);
        return;
      }
      i(null, S);
    }
    if (!r.adReinsertion) {
      let E = new Error("AdReinsertion setup omitted. HomadXHRURLHandler not activated.");
      E.code = w.WRAPPER.TIMEOUT.code, E.description = "HOMAD Activation Error: AdReinsertion setup omitted (publisher-side).", s(E);
      return;
    }
    const h = r.adReinsertion.vendorAPI.stuffAdTag(e);
    let m = r.adReinsertion.vendorAPI.getUrlRequest(h);
    m.data.homad_macros = JSON.stringify(r.enrichment.getIABMacroList()), c.debug.info(
      jt.NAME + "getAsXHR - Provide VAST Macro List" + m.data.homad_macros
    ), r.adReinsertion.vendorAPI.loadFile(m, (E) => {
      l(E);
    }, (E) => {
      let S, M = "HOMADUtils XHR";
      E.timedOut ? (S = new Error("HomadUtilsURLHandler: Request timeout."), S.code = w.WRAPPER.TIMEOUT.code, S.description = `${M} Timeout Error ${r.timeouts.errorMessage || w.WRAPPER.TIMEOUT.message}`) : (S = new Error("HomadUtilsURLHandler: " + E.statusText), S.code = w.XML.INVALID_XML.code, S.description = `${M} Status Error (${E.status}): ${E.statusText}`), s(S);
    }, !1, !1, !1, r.timeouts.adRequest * 1e3);
  }
  get(e, i, r = {}) {
    r.timeouts || (r.timeouts = ti.timeouts), c.debug.info(`${jt.NAME}: Get with timeout ${r.timeouts.adRequest} sec: ${e}`), this.getAsXHR(e, i, r);
  }
};
jt.NAME = "HomadUrlHandler::";
let bi = jt;
function jn(A) {
  return window.location.protocol === "https:" && !A.startsWith("http://") || window.location.protocol !== "https:";
}
function He(A, e) {
  let i = document.createElement("ParserError");
  i.setAttribute("code", e.code.toString()), i.setAttribute("message", e.message), A.appendChild(i);
}
const Jt = class Jt {
  constructor(e) {
    e.urlRequestObserver.requestTime = Date.now(), this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackLoadingDone = null, this.maxWrapperDept = e.maxWrapperDepth | 10, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3;
  }
  /**
   * Takes XML document and immediately returns it
   * This is just a loop through function that might touch the XML if needed
   * @param vmapDoc
   * @param callbackOnDoneLoading
   * @returns {Promise<void>}
   */
  requestXML(e, i) {
    this.callbackLoadingDone = i, this.returnVMAP(e);
  }
  /**
   * Takes URL and loads it
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param url
   * @param callbackOnDoneLoading
   * @returns {void|Promise<void>}
   */
  requestURL(e, i) {
    if (c.debug.info(Jt.NAME + "requestURL", e), this.callbackLoadingDone = i, this.isInsecureURL(e)) {
      let r = document.createDocumentFragment();
      return He(r, w.SESSION.MIXED_CONTENT), this.returnVMAP(r);
    }
    return this.loadURL(e).then((r) => {
      this.returnVMAP(r);
    });
  }
  returnVMAP(e) {
    let i = e, r = document.createDocumentFragment();
    e.querySelectorAll("VMAP").length > 0 && e.querySelectorAll("AdBreak").length === 0 && (He(r, w.VMAP.NO_ADBREAKS), i = r), e.querySelectorAll("VMAP").length === 0 && e.querySelectorAll("ParserError").length === 0 && (He(r, w.VMAP.DOCUMENT_ERROR), i = r), this.callbackLoadingDone(i);
  }
  /** @internal */
  loadURL(e) {
    return this.urlHandlerOptions.response = null, new Promise((i) => {
      new yr().get(e, (r, s) => {
        if (!r && s && s.querySelector("parsererror")) {
          let l = document.createDocumentFragment();
          He(l, w.VMAP.EXTRACTION_ERROR), i(l);
        }
        if (r && !s) {
          let l = document.createDocumentFragment();
          c.debug.warn(Jt.NAME + "loadURL - XHR Request Error", r), He(l, r), i(l);
        } else
          i(s);
      }, this.urlHandlerOptions);
    });
  }
  /** @internal */
  isInsecureURL(e) {
    return this.blockInsecureURL && !jn(e);
  }
};
Jt.NAME = "VMAPReqService::";
let lr = Jt;
function Bn(A) {
  if (!A || typeof A != "object")
    return !1;
  try {
    return A.self === A;
  } catch (e) {
    return !0;
  }
}
function qt(A, ...e) {
  for (const i of e)
    if (i)
      for (const r in i)
        Object.prototype.hasOwnProperty.call(i, r) && i[r] !== null && (Bn(i[r]) ? A[r] = i[r] : typeof A[r] == "object" && typeof i[r] == "object" ? A[r] = qt(A[r], i[r]) : A[r] = i[r]);
  return A;
}
function qn() {
  return this.error || null;
}
function Je(A) {
  this.error = {
    code: A.code,
    message: A.message,
    timestamp: Date.now()
  };
}
let Cn = null;
const Tr = class Tr extends gt {
  /**
   * @param {Object} playerFacade extended from FacadeBase
   * @param {Object} adsAPI is a reference to the session AdSlotAPI
   */
  constructor(e, i) {
    super(), this.player = e, this.config = i.config, c.debug.info(ve.NAME + "Create AdPlaylistAPI with", i.config), this.environmentVars = i.environmentVars, this.vmapSetup = null, this.adPlaylist = null, this.adPlaylistController = null, this.adSlotAPI = i, this.rawVMAPXML = null, this.error = null, this.timeouts = this.config.timeouts;
  }
  /**
   * Starts requesting a VMAP from the ad server
   *
   * @param {AdPlaylistSetup} playlistSpecs - Ad configuration for the upcoming content video.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break.
   *  https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
   * @returns {Promise<String|Error>} Resolves if loading the VMAP has been completed
   */
  initAdPlaylist(e, i = {}) {
    this.environmentVars = Object.assign(this.environmentVars, i), c.debug.info(ve.NAME + "initAdPlaylist - with", e, this.environmentVars), this.vmapSetup = e, this.timeouts = qt(this.timeouts, this.environmentVars.timeouts), this.error = null, e.response && e.response.length > 0 && (this.vmapSetup.responseXML = new DOMParser().parseFromString(
      e.response,
      "text/xml"
    ));
    let r = null;
    this.adSlotAPI.environmentVars = this.environmentVars;
    const s = this.adSlotAPI.setupEnrichmentAndTCF();
    Cn = new le(this.config.adReinsertion, s);
    const l = {
      adReinsertion: Cn,
      blockInsecureURL: this.config.blockInsecureURL,
      enrichment: s,
      response: this.vmapSetup.responseXML,
      timeouts: this.timeouts,
      urlhandler: this.config.urlhandler,
      withCredentials: !0,
      urlRequestObserver: {
        originTimeouts: qt({}, this.timeouts),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    return new Promise((h, m) => {
      r = this.addEventListener(p.ON_AD_PLAYLIST_LOAD_ERROR, () => m(this.errorAPI)), this.addEventListener(p.ON_AD_PLAYLIST_LOADED, () => (r(), this.adPlaylistController = new ve(this.adPlaylist, this.config), this.adPlaylistController.setPlayer(this.player), this.adPlaylistController.setAdsAPI(this.adSlotAPI), h("ok")));
      let E = new lr(
        l
      );
      e.tag ? E.requestURL(e.tag, this.onXMLLoadDone.bind(this, l)) : E.requestXML(l.response, this.onXMLLoadDone.bind(this, l));
    });
  }
  // any - options.adReinsertion get overwritten with AdReinsertionModel, was before a setup object
  /**
   * @internal
   */
  onXMLLoadDone(e, i) {
    this.rawVMAPXML = i, this.adPlaylist = new eo(i, this.vmapSetup);
    let r = this.adPlaylist.getAdPlaylist();
    c.debug.info(ve.NAME + "onXMLLoadDone and vmap parsed.", i), c.debug.table(r);
    const s = () => {
      if (!this.adPlaylist.hasPlayableAdBreaks) {
        const l = i.querySelector("ParserError"), h = l ? {
          code: parseInt(l.getAttribute("code"), 10),
          message: l.getAttribute("message")
        } : this.error = w.VMAP.NO_ADBREAKS;
        Je.call(this, h), super.dispatchEvent(p.ON_AD_PLAYLIST_LOAD_ERROR);
        return;
      }
      super.dispatchEvent(p.ON_AD_PLAYLIST_LOADED);
    };
    if (e.adReinsertion.reinsertionReason) {
      c.debug.info(
        ve.NAME + "onXMLLoadDone - Found reason to enable AdReinsertion",
        e.adReinsertion.reinsertionReason
      ), e.adReinsertion.enable(
        () => {
          e.adReinsertion.setReinsertionReason(null), c.debug.info(
            ve.NAME + "enable - Override default URLHandler with HOMADURLHandler."
          ), this.config.urlhandler = bi, this.initAdPlaylist(this.vmapSetup, this.environmentVars.vastMacros).catch(() => {
            s();
          });
        },
        // ERROR.SESSION.AD_REINSERTION_DECLINED
        (l) => {
          c.debug.info(ve.NAME + "enable - AdReinsertion remains disabled.", l), Je.call(this, l), s();
        }
      );
      return;
    }
    s();
  }
  /**
   * Starts playback and monitoring of the content and automatically inserts ad-slots
   * based on the `timeOffset` values of each VMAP AdBreak.
   * AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.
   *
   * @returns {Promise} Resolves if the playback started
   */
  startAdPlaylist() {
    return super.dispatchEvent(p.ON_AD_PLAYLIST_START), Object.keys(p).forEach((e) => {
      this.adPlaylistController.addEventListener(p[e], (i) => {
        super.dispatchEvent(i.type);
      });
    }), new Promise((e, i) => {
      this.adPlaylistController.beforeContent().then(() => {
        e();
      }).catch(
        /* c8 ignore start: The method beforeContent always resolves and must not prevent
        	the start of the content. It only catches runtime errors that might occur. */
        (r) => {
          i(r);
        }
        /* c8 ignore stop */
      );
    });
  }
  /**
   * Immediately stops monitoring content playback.
   * AdBreaks that have already started remain until they complete. If necessary, they must be canceled
   * via the `AdSlotAPI.stopAdSlot()`.
   *
   * @returns {Promise<void>} - Whether the ad slot could be closed and cleaned up or not.
   */
  stopAdPlaylist() {
    return this.adPlaylistController.stop(), Promise.resolve();
  }
  dispose() {
    return this.stopAdPlaylist(), Promise.resolve();
  }
  /**
   * Requests details about the most recent error that has occurred on the AdPlaylistAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return qn.call(this);
  }
  /**
   * Returns the VMAP that has been collected for the current (content) session
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this
   */
  get rawVMAP() {
    return this.rawVMAPXML;
  }
};
Tr.NAME = "AdPlaylAPI::";
let dr = Tr;
var ue = /* @__PURE__ */ ((A) => (A.CLOSER = "closer", A.DIVIDER = "divider", A.OPENER = "opener", A.COMMERCIAL = "commercial", A.SPONSORED = "sponsored", A))(ue || {});
class oo {
  constructor(e) {
    this.totalCommercialsDurationArray = [-1], this.totalCommercialsCurrentTimeNumber = -1, this.currentTimeOffsetNumber = 0, e && this.setManifest(e);
  }
  setManifest(e) {
    e && (this.adSlotManifest = e, this.collectCommercialsDuration());
  }
  /**
   * Does collect and summarize the duration of all commercial ads.
   * The result can change at runtime after receiving real duration values for a specific ad
   * @returns {void}
   */
  /** @internal */
  collectCommercialsDuration() {
    this.totalCommercialsDurationArray = [0];
    for (let e = 0; e < this.adSlotManifest.length; e++) {
      let i = this.adSlotManifest[e];
      !i.isLinear || i.variant !== ue.COMMERCIAL || this.totalCommercialsDurationArray.push(i.duration);
    }
    this.totalCommercialsDurationArray.reduce((e, i) => e + i) === 0 && (this.totalCommercialsDurationArray = [-1]), console.log(
      "AdSloDel::AdSlotTimes.totalCommercialsDuration initial",
      this.totalCommercialsDurationArray.reduce((e, i) => e + i)
    );
  }
  get totalCommercialsDuration() {
    return this.totalCommercialsDurationArray.reduce((e, i) => e + i);
  }
  // Note: `set...` means we "add" these seconds to the existing duration
  setTotalCommercialsDuration(e) {
    this.totalCommercialsDurationArray[0] === -1 ? this.totalCommercialsDurationArray[0] = e : this.totalCommercialsDurationArray.push(e);
  }
  get totalCommercialsCurrentTime() {
    return this.totalCommercialsCurrentTimeNumber;
  }
  setCommercialsCurrentTime(e) {
    this.totalCommercialsCurrentTimeNumber = e;
  }
  get currentTimeOffset() {
    return this.currentTimeOffsetNumber;
  }
  setCurrentTimeOffset(e) {
    this.currentTimeOffsetNumber = e;
  }
}
const ne = {
  CLICK_THRU: "Creative:clickThru",
  COLLAPSE_NONLINEAR: "Creative:collapseNonlinear",
  EXPAND_NONLINEAR: "Creative:expandNonlinear",
  FATAL_ERROR: "Creative:fatalError",
  GET_MEDIA_STATE: "Creative:getMediaState",
  LOG: "Creative:log",
  READY: "Creative:ready",
  REPORT_TRACKING: "Creative:reportTracking",
  REQUEST_CHANGE_AD_DURATION: "Creative:requestChangeAdDuration",
  REQUEST_FULL_SCREEN: "Creative:requestFullScreen",
  REQUEST_PAUSE: "Creative:requestPause",
  REQUEST_PLAY: "Creative:requestPlay",
  REQUEST_RESIZE: "Creative:requestResize",
  REQUEST_SKIP: "Creative:requestSkip",
  REQUEST_STOP: "Creative:requestStop",
  REQUEST_VIDEO_LOCATION: "Creative:requestVideoLocation",
  REQUEST_VOLUME: "Creative:requestVolume"
}, Qe = {
  DURATION_CHANGE: "Media:durationchange",
  ENDED: "Media:ended",
  ERROR: "Media:error",
  PAUSE: "Media:pause",
  PLAY: "Media:play",
  PLAYING: "Media:playing",
  SEEKED: "Media:seeked",
  SEEKING: "Media:seeking",
  TIME_UPDATE: "Media:timeupdate",
  VOLUME_CHANGE: "Media:volumechange"
}, et = {
  AD_SKIPPED: "Player:adSkipped",
  AD_STOPPED: "Player:adStopped",
  FATAL_ERROR: "Player:fatalError",
  INIT: "Player:init",
  LOG: "Player:log",
  START_CREATIVE: "Player:startCreative"
}, Ye = {
  CREATE_SESSION: "createSession",
  REJECT: "reject",
  RESOLVE: "resolve"
}, Zt = class Zt extends c {
  /** playerElement is needed for multiple instances support
   * @param {Element} playerElement where the simid ad get played
   */
  constructor(e) {
    super(), this.listeners = {}, this.eventsThatRequireResponse = [
      ne.CLICK_THRU,
      ne.GET_MEDIA_STATE,
      ne.READY,
      ne.REPORT_TRACKING,
      ne.REQUEST_CHANGE_AD_DURATION,
      ne.REQUEST_FULL_SCREEN,
      ne.REQUEST_PAUSE,
      ne.REQUEST_PLAY,
      ne.REQUEST_RESIZE,
      ne.REQUEST_SKIP,
      ne.REQUEST_STOP,
      ne.REQUEST_VIDEO_LOCATION,
      ne.REQUEST_VOLUME,
      et.AD_SKIPPED,
      et.AD_STOPPED,
      et.FATAL_ERROR,
      et.INIT,
      et.START_CREATIVE,
      Ye.CREATE_SESSION
    ], this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.target = e.ownerDocument.defaultView, this.target.addEventListener(
      "message",
      this.receiveMessage.bind(this),
      !1
    ), this.resolutionListeners = {};
  }
  /* Reverts this protocol to its original state */
  reset() {
    this.listeners = {}, this.sessionId = "", this.nextMessageId = 1, this.resolutionListeners = {};
  }
  /**
   * Sends a message using post message.
   * Returns a promise that will resolve or reject after the message receives a response.
   * @param {string} messageType The name of the message
   * @param {?Object} messageArgs The arguments for the message, may be null.
   * @return {!Promise} Promise that will be fulfilled when client resolves or rejects.
   */
  sendMessage(e, i) {
    const r = this.nextMessageId++, s = e === Ye.CREATE_SESSION ? e : "SIMID:" + e, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: s,
      timestamp: Date.now(),
      args: i
    };
    return this.eventsThatRequireResponse.includes(e) ? new Promise((h, m) => {
      this.addResolveRejectListener(r, h, m), this.target.postMessage(JSON.stringify(l), "*");
    }) : new Promise((h, m) => {
      this.target.postMessage(JSON.stringify(l), "*"), h();
    });
  }
  /**
   * Adds a listener for a given message.
   */
  addListener(e, i) {
    this.listeners[e] ? this.listeners[e].push(i) : this.listeners[e] = [i];
  }
  /**
   * Sets up a listener for resolve/reject messages.
   * @internal
   */
  addResolveRejectListener(e, i, r) {
    const s = (l) => {
      const h = l.type, m = l.args.value;
      h === "resolve" && i(m), h === "reject" && r(m);
    };
    this.resolutionListeners[e] = s.bind(this);
  }
  /**
   * Receives messages from either the player or creative.
   */
  receiveMessage(e) {
    if (!e || !e.data)
      return;
    let i;
    try {
      i = JSON.parse(e.data);
    } catch (E) {
      return;
    }
    const r = i.sessionId, s = i.type, l = this.sessionId === "" && s === Ye.CREATE_SESSION, h = this.sessionId === r;
    if (!(!(l || h) || s === null)) {
      if (Object.values(Ye).includes(s))
        this.handleProtocolMessage(i);
      else if (s.startsWith("SIMID:")) {
        const E = s.substring(6), S = this.listeners[E];
        S && S.forEach((M) => {
          M(i);
        });
      }
    }
  }
  /**
   * Handles incoming messages specifically for the protocol
   * @param {!Object} data Data passed back from the message
   * @internal
   */
  handleProtocolMessage(e) {
    const i = e.type;
    switch (i) {
      case Ye.CREATE_SESSION:
        this.sessionId = e.sessionId, this.resolve(e, {});
        const r = this.listeners[i];
        r && r.forEach((m) => {
          m(e);
        });
        break;
      case Ye.RESOLVE:
      // intentional fallthrough
      case Ye.REJECT:
        const l = e.args.messageId, h = this.resolutionListeners[l];
        h && (h(e), delete this.resolutionListeners[l]);
        break;
    }
  }
  /**
   * Resolves an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  resolve(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Ye.RESOLVE,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Rejects an incoming message.
   * @param {!Object} incomingMessage the message that is being resolved.
   * @param {!Object} outgoingArgs Any arguments that are part of the resolution.
   */
  reject(e, i) {
    const r = this.nextMessageId++, s = {
      messageId: e.messageId,
      value: i
    }, l = {
      sessionId: this.sessionId,
      messageId: r,
      type: Ye.REJECT,
      timestamp: Date.now(),
      args: s
    };
    this.target.postMessage(JSON.stringify(l), "*");
  }
  /**
   * Creates a new session.
   * @return {!Promise} The promise from the create session message.
   */
  createSession() {
    const e = () => {
      c.debug.info(Zt.NAME + "createSession resolve");
    }, i = () => {
      c.debug.info(Zt.NAME + "createSession reject");
    };
    this.generateSessionId(), this.sendMessage(Ye.CREATE_SESSION, {}).then(
      e,
      i
    );
  }
  /**
   * Sets the session ID, this should only be used on session creation.
   * @internal
   */
  generateSessionId() {
    const e = new Uint8Array(16);
    window.crypto.getRandomValues(e), e[6] = e[6] & 15 | 64, e[8] = e[8] & 63 | 128;
    let i = "", r;
    for (r = 0; r < 16; r++)
      i += (r === 4 || r === 6 || r === 8 || r === 10 ? "-" : "") + e[r].toString(16);
    this.sessionId = i;
  }
  setMessageTarget(e) {
    this.target = e;
  }
};
Zt.NAME = "SIMIDPtl::";
let ur = Zt;
function mt(A, e) {
  let i = document.createElement(A);
  return Object.keys(e || {}).forEach((r) => {
    i.setAttribute(r, e[r]);
  }), i;
}
const Ni = {
  PLAYBACK_AREA_UNUSABLE: 1102,
  EXPAND_NOT_POSSIBLE: 1105
}, _n = {
  UNSUPPORTED_TIME: 1202,
  VIDEO_COULD_NOT_LOAD: 1206
}, Rt = {
  MEDIA_PLAYBACK_COMPLETE: 2,
  PLAYER_INITATED: 3,
  CREATIVE_INITIATED: 4,
  NON_LINEAR_DURATION_COMPLETE: 5
}, zt = 0, or = -2, ao = !0, Me = class Me {
  /**
   * Sets up the creative iframe and starts listening for messages
   * from the creative.
   * @param {Object} adSlotController. - contains all current ad information.
   */
  constructor(e) {
    this.adSlotController = e, this.currentAd = e.currentAd, this.creativeAsset = e.currentAd.properCreative.selectedCreativeFile, this.mediaAsset = e.currentAd.properCreative.selectedMediaFile, this.playerFacade = e.player, this.loadedSource = null, this.simidProtocol = new ur(this.playerFacade.getPlayerElement()), this.addListeners(), this.initializationPromise = null, this.videoTrackingEvents = /* @__PURE__ */ new Map(), this.isLinearAd = this.mediaAsset.linearity === "linear", this.nonLinearStartTime = null, this.requestedDuration = zt, this.resolveSessionCreatedPromise = null, this.sessionCreatedPromise = new Promise((i) => {
      this.resolveSessionCreatedPromise = i;
    }), this.resolveInitializationPromise = null, this.rejectInitializationPromise = null, this.requestedDuration = zt, this.nonLinearDimensions = null, this.initializationPromise = new Promise((i, r) => {
      this.resolveInitializationPromise = i, this.rejectInitializationPromise = r;
    }), this.IFrame = null, this.trackEventsOnAdVideoElement();
  }
  /**
   * Initializes an ad. This should be called before an ad plays.
   * Creates an iframe with the creative in it, then uses a promise
   * to call init on the creative as soon as the creative initializes
   * a session.
   */
  initializeAd() {
    if (!this.isLinearAd && !this.isValidDimensions(this.getNonlinearDimensions())) {
      c.debug.info(
        Me.NAME + "initializeAd - nonLinear ad with bigger dimensions than the player."
      );
      return;
    }
    this.IFrame = this.createIFrame(), this.isLinearAd || this.displayNonlinearCreative(), this.initializationPromise.catch((e) => {
      this.onAdInitializedFailed(e);
    }), this.sessionCreatedPromise.then(() => {
      this.sendInitMessage(), this.initializationPromise.then(() => {
        this.startCreativePlayback();
      });
    });
  }
  addContainer(e) {
    this.container = mt("div", {
      id: "container--simid"
    }), e.parentNode && e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  /**
   * Sets up an iframe for holding the simid element.
   *
   * @return {!Element} The iframe where the simid element lives.
   * @internal
   */
  createIFrame() {
    this.addContainer(this.playerFacade.getPlayerElement());
    const e = document.createElement("iframe");
    return c.debug.info(Me.NAME + "createSimidIframe with", this.creativeAsset), e.src = this.creativeAsset.fileURL, e.style.display = "none", this.container.appendChild(e), this.simidProtocol.setMessageTarget(e.contentWindow), e;
  }
  /**
   * Listens to all relevant messages from the SIMID add.
   * @internal
   */
  addListeners() {
    this.simidProtocol.addListener(Ye.CREATE_SESSION, this.onSessionCreated.bind(this)), this.simidProtocol.addListener(ne.CLICK_THRU, this.onReqClickThu.bind(this)), this.simidProtocol.addListener(ne.REQUEST_FULL_SCREEN, this.onReqFullScreen.bind(this)), this.simidProtocol.addListener(ne.REQUEST_PLAY, this.onReqPlay.bind(this)), this.simidProtocol.addListener(ne.REQUEST_PAUSE, this.onReqPause.bind(this)), this.simidProtocol.addListener(ne.FATAL_ERROR, this.onCreativeFatalError.bind(this)), this.simidProtocol.addListener(ne.REQUEST_SKIP, this.onReqSkip.bind(this)), this.simidProtocol.addListener(ne.REQUEST_STOP, this.onReqStop.bind(this)), this.simidProtocol.addListener(
      ne.REQUEST_CHANGE_AD_DURATION,
      this.onReqChangeAdDuration.bind(this)
    ), this.simidProtocol.addListener(ne.GET_MEDIA_STATE, this.onGetMediaState.bind(this)), this.simidProtocol.addListener(ne.LOG, this.onReceiveCreativeLog.bind(this)), this.simidProtocol.addListener(ne.EXPAND_NONLINEAR, this.onExpandResize.bind(this)), this.simidProtocol.addListener(ne.COLLAPSE_NONLINEAR, this.onCollapse.bind(this)), this.simidProtocol.addListener(ne.REQUEST_RESIZE, this.onReqResize.bind(this));
  }
  /**
   * Resolves the session created promise.
   * @internal
   */
  onSessionCreated() {
    this.resolveSessionCreatedPromise();
  }
  /**
   * Destroys the existing simid iframe.
   * @internal
   */
  destroyIFrame() {
    this.IFrame && (this.IFrame.parentNode.remove(), this.IFrame = null, this.simidProtocol.reset());
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.removeEventListener(e, i);
    this.videoTrackingEvents.clear();
  }
  /**
   * Returns the full dimensions of an element within the player div.
   * @internal
   * @return {!Object}
   */
  getFullDimensions() {
    const e = this.playerFacade.getPlayerSize().boundingRect;
    return {
      x: 0,
      y: 0,
      width: e.width,
      height: e.height
    };
  }
  /**
   * Checks whether the input dimensions are valid and fit in the player window.
   * @internal
   * @param {!Object} dimensions A dimension that contains x, y, width & height fields.
   * @return {boolean}
   */
  isValidDimensions(e) {
    const i = this.playerFacade.getPlayerSize().boundingRect, r = parseInt(e.y, 10) + parseInt(e.height, 10) <= i.height, s = parseInt(e.x, 10) + parseInt(e.width, 10) <= i.width;
    return r && s;
  }
  /**
   * Returns the specified dimensions of the non-linear creative.
   * @internal
   * @return {!Object}
   */
  getNonlinearDimensions() {
    return this.nonLinearDimensions ? this.nonLinearDimensions : {
      // nonLinear ad-container is over playerControls!
      height: this.currentAd.properCreative.selectedMediaFile.height,
      width: this.currentAd.properCreative.selectedMediaFile.width,
      x: this.playerFacade.getPlayerSize().boundingRect.x + 100,
      y: this.playerFacade.getPlayerSize().boundingRect.y
    };
  }
  pause() {
    this.playerFacade.pause();
  }
  play() {
    this.playerFacade.play();
  }
  /**
   * Validates and displays the non-linear creative.
   * @internal
   */
  displayNonlinearCreative() {
    const e = this.getNonlinearDimensions();
    if (!this.isValidDimensions(e)) {
      c.debug.info("Unable to play a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size.");
      return;
    }
    this.setIFrameDimensions(e), this.IFrame.style.position = "absolute", this.play(), this.requestedDuration = this.currentAd.duration;
  }
  /**
   * Changes the simid iframe dimensions to the given dimensions.
   * @internal
   * @param {!Object} resizeDimensions A dimension that contains an x,y,width & height fields.
   */
  setIFrameDimensions(e) {
    c.debug.info(Me.NAME + "resize", e), this.IFrame.style.height = e.height, this.IFrame.style.width = e.width, this.IFrame.style.left = `${e.x}px`, this.IFrame.style.top = `${e.y}px`, this.adSlotController.dispatchEvent(p.ON_AD_SIZE_CHANGED);
  }
  resolve(e) {
    this.simidProtocol.resolve(e);
  }
  reject(e, i) {
    this.simidProtocol.reject(e, i);
  }
  /**
   * The creative wants to expand the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onExpandResize(e) {
    if (this.isLinearAd) {
      const i = {
        errorCode: Ni.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, i), c.debug.info(i.message);
    } else {
      const i = this.getFullDimensions();
      this.setIFrameDimensions(i), this.pause(), this.resolve(e);
    }
  }
  /**
   * The creative wants to collapse the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player
   */
  onCollapse(e) {
    const i = this.getNonlinearDimensions();
    if (this.isLinearAd) {
      const r = {
        message: "Cannot collapse linear ads."
      };
      this.reject(e, r), c.debug.info(r.message);
    } else if (this.isValidDimensions(i))
      this.setIFrameDimensions(i), this.IFrame.style.position = "absolute", this.play(), this.resolve(e);
    else {
      const r = {
        message: "Unable to collapse to dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.info(r.message);
    }
  }
  /**
   * The creative wants to resize the ad.
   * @param {!Object} incomingMessage Message sent from the creative to the player.
   */
  onReqResize(e) {
    let i = "onRequestResize - error:";
    if (this.isLinearAd) {
      const r = {
        errorCode: Ni.EXPAND_NOT_POSSIBLE,
        message: "Linear resize not yet supported."
      };
      this.reject(e, r), c.debug.error(Me.NAME + i, r.message);
    } else if (this.isValidDimensions(e.args.creativeDimensions))
      this.nonLinearDimensions = e.args.creativeDimensions, this.setIFrameDimensions(e.args.creativeDimensions), this.resolve(e);
    else {
      const r = {
        errorCode: Ni.EXPAND_NOT_POSSIBLE,
        message: "Unable to resize a non-linear ad with dimensions bigger than the player. Please modify dimensions to a smaller size."
      };
      this.reject(e, r), c.debug.error(Me.NAME + i, r.message);
    }
  }
  /**
   * Initializes the SIMID creative with all data it needs.
   * @internal
   */
  sendInitMessage() {
    const e = this.getFullDimensions(), i = this.isLinearAd ? this.getFullDimensions() : this.getNonlinearDimensions(), r = {
      videoDimensions: e,
      creativeDimensions: i,
      fullscreen: !1,
      fullscreenAllowed: !0,
      variableDurationAllowed: !0,
      skippableState: "adHandles",
      // This player does not render a skip button.
      siteUrl: document.location.host,
      appId: "",
      // This is not relevant on desktop
      useragent: "",
      // This should be filled in for sdks and players
      deviceId: "",
      // This should be filled in on mobile
      muted: this.playerFacade.isMuted(),
      volume: this.playerFacade.volume
    }, s = {
      adParameters: this.creativeAsset.adParameters,
      // These values should be populated from the VAST response.
      adId: this.currentAd.id,
      creativeId: "",
      adServingId: "",
      clickThroughUrl: this.currentAd.clickThroughURL,
      duration: 0
    };
    this.isLinearAd || (s.duration = this.currentAd.duration);
    const l = {
      environmentData: r,
      creativeData: s
    };
    this.simidProtocol.sendMessage(et.INIT, l).then((m) => {
      this.resolveInitializationPromise(m), c.debug.info(Me.NAME + "session created");
    }).catch((m) => {
      this.rejectInitializationPromise(m);
    });
  }
  /**
   * Called once the creative responds positively to being initialized.
   * @internal
   */
  startCreativePlayback() {
    this.showIFrame(), this.isLinearAd ? this.adSlotController.dispatchEvent(p.ON_AD_STARTED) : (this.nonLinearStartTime = this.playerFacade.getContentCurrentTime(), this.play()), c.debug.info(Me.NAME + "startCreativePlayback"), this.simidProtocol.sendMessage(et.START_CREATIVE);
  }
  /**
   * Pauses content video and plays linear ad.
   * @internal
   */
  /**
   * Called if the creative responds with reject after the player
   * initializes the ad.
   * @param {!Object} data
   * @internal
   */
  onAdInitializedFailed(e) {
    this.setError(w.SESSION.MANIFEST_LOAD_FAILED), this.adSlotController.dispatchEvent(p.ON_SIMID_ERROR), this.adSlotController.cancelAdWithError(), c.debug.error(Me.NAME + "onAdInitializedFailed", JSON.stringify(e)), this.destroyIframeAndResumeContent();
  }
  /** @internal */
  hideIFrame() {
    this.IFrame.style.display = "none";
  }
  /** @internal */
  showIFrame() {
    this.IFrame.style.bottom = "0", this.IFrame.style.display = "block", this.IFrame.style.height = "100%", this.IFrame.style.left = "0", this.IFrame.style.position = "absolute", this.IFrame.style.width = "100%";
  }
  /**
   * Disables or enables stop, skip, and fatal error buttons
   *  depending on if the ad is showing.
   * @internal
   * @param {boolean} controlState If buttons should be disabled or enabled
   */
  setCreativeControlsState(e) {
    document.querySelectorAll(".ad_request").forEach((r) => {
      r.disabled = e;
    });
  }
  /**
   * Tracks the events on the ad video element specified by the simid spec
   * @internal
   */
  trackEventsOnAdVideoElement() {
    this.videoTrackingEvents.set("ended", this.videoComplete.bind(this)), this.videoTrackingEvents.set("error", () => {
      this.simidProtocol.sendMessage(
        Qe.ERROR,
        {
          error: w.SIMID.GENERAL_ERROR.code,
          message: w.SIMID.GENERAL_ERROR.message
        }
      ), this.currentAd.error = w.SIMID.GENERAL_ERROR, this.adSlotController.cancelAdWithError();
    }), this.videoTrackingEvents.set("pause", () => {
      this.simidProtocol.sendMessage(Qe.PAUSE);
    }), this.videoTrackingEvents.set("play", () => {
      this.simidProtocol.sendMessage(Qe.PLAY);
    }), this.videoTrackingEvents.set("playing", () => {
      this.simidProtocol.sendMessage(Qe.PLAYING);
    }), this.videoTrackingEvents.set("seeked", () => {
      this.simidProtocol.sendMessage(Qe.SEEKED);
    }), this.videoTrackingEvents.set("seeking", () => {
      this.simidProtocol.sendMessage(Qe.SEEKING);
    }), this.videoTrackingEvents.set(ke.ON_TIME_UPDATED, () => {
      this.simidProtocol.sendMessage(
        Qe.TIME_UPDATE,
        { currentTime: this.playerFacade.getAdCurrentTime() }
      ), this.compareAdAndReqDurations(), this.simidProtocol.sendMessage(
        Qe.DURATION_CHANGE,
        { duration: this.playerFacade.getAdDuration() }
      ), this.nonLinearStartTime !== null && this.playerFacade.getContentCurrentTime() - this.nonLinearStartTime > this.requestedDuration && this.stopAd(Rt.NON_LINEAR_DURATION_COMPLETE);
    }), this.videoTrackingEvents.set("volumechange", () => {
      this.simidProtocol.sendMessage(
        Qe.VOLUME_CHANGE,
        { volume: this.playerFacade.getVolume() }
      );
    });
    for (let [e, i] of this.videoTrackingEvents)
      this.playerFacade.addEventListener(e, i);
  }
  /**
   * Stops the ad and destroys the ad iframe.
   * @param {number} reason The reason the ad will stop.
   */
  stopAd(e = Rt.PLAYER_INITATED) {
    this.IFrame && (this.hideIFrame(), this.loadedSource = null, this.simidProtocol.sendMessage(et.AD_STOPPED).then(() => {
      c.debug.info(Me.NAME + "stopAd-destroy reason", e), this.destroyIframeAndResumeContent();
    }));
  }
  /**
   * Skips the ad and destroys the ad iframe.
   */
  skipAd() {
    this.hideIFrame(), this.simidProtocol.sendMessage(et.AD_SKIPPED).then(() => this.destroyIframeAndResumeContent()), this.adSlotController.dispatchEvent(p.ON_AD_SKIPPED), this.loadedSource = null;
  }
  /**
   * Removes the simid ad entirely and resumes video playback.
   * @internal
   */
  destroyIframeAndResumeContent() {
    this.destroyIFrame(), this.setCreativeControlsState(ao), this.adSlotController.dispatchEvent(p.ON_AD_STOPPED);
  }
  /** The creative wants to go full screen. */
  onReqFullScreen(e) {
    c.debug.info(Me.NAME + "onReqFullScreen", e);
    let i;
    this.IFrame && (i = this.IFrame.mozRequestFullScreen || this.IFrame.msRequestFullscreen || this.IFrame.requestFullscreen || this.IFrame.webkitRequestFullscreen);
    let r = i == null ? void 0 : i();
    r ? r.then(() => this.resolve(e)) : this.resolve(e);
  }
  onReqClickThu(e) {
    e.args && e.args.playerHandles && this.pause(), this.adSlotController.onClickThrough(!1);
  }
  /** The creative wants to play video. */
  onReqPlay(e) {
    if (this.isLinearAd) {
      if (this.loadedSource === this.mediaAsset.fileURL)
        return this.play(), this.simidProtocol.resolve(e, {});
      this.playerFacade.load(this.mediaAsset.fileURL).then(() => (this.loadedSource = this.mediaAsset.fileURL, this.simidProtocol.resolve(e, {}))).catch(() => {
        const i = {
          errorCode: _n.VIDEO_COULD_NOT_LOAD,
          message: "The SIMID media could not be loaded."
        };
        this.reject(e, i);
      });
    } else {
      const i = {
        errorCode: Ni.PLAYBACK_AREA_UNUSABLE,
        message: "Non linear ads do not play video."
      };
      this.reject(e, i);
    }
  }
  /** The creative wants to pause video. */
  onReqPause(e) {
    this.pause(), this.resolve(e);
  }
  /** The creative wants to stop with a fatal error. */
  onCreativeFatalError(e) {
    this.resolve(e), this.stopAd(Rt.CREATIVE_INITIATED);
  }
  /** The creative wants to skip this ad. */
  onReqSkip(e) {
    this.resolve(e), this.skipAd();
  }
  /** The creative wants to stop the ad early. */
  onReqStop(e) {
    this.resolve(e), this.stopAd(Rt.CREATIVE_INITIATED);
  }
  /**
   * The player must implement sending tracking pixels from the creative.
   * This sample implementation does not show how to send tracking pixels or
   * replace macros. That should be done using the players standard workflow.
   */
  onReportTracking(e) {
    const i = e.args.trackingUrls;
    c.debug.info(Me.NAME + "onReportTracking -  Creative has asked the player to send a ping."), c.debug.table(i);
  }
  /**
   * Called when video playback is complete.
   * @internal
   */
  videoComplete() {
    if (this.simidProtocol.sendMessage(Qe.ENDED), this.requestedDuration === zt && this.stopAd(Rt.MEDIA_PLAYBACK_COMPLETE), this.requestedDuration !== zt && this.requestedDuration !== or) {
      const e = (this.requestedDuration - this.playerFacade.getAdDuration()) * 1e3;
      setTimeout(() => {
        this.stopAd(Rt.CREATIVE_INITIATED);
      }, e);
    }
  }
  /**
   * Called when creative requests a change in duration of ad.
   * @internal
   */
  onReqChangeAdDuration(e) {
    const i = e.args.duration;
    if (i !== or && i < 0) {
      const r = {
        errorCode: _n.UNSUPPORTED_TIME,
        message: "A negative duration is not valid."
      };
      this.simidProtocol.reject(e, r);
    } else
      this.requestedDuration = i, this.compareAdAndReqDurations(), this.resolve(e);
  }
  /**
   * Compares the duration of the ad with the requested change duration.
   * If request duration is the same as the ad duration, ad ends as normal.
   * If request duration is unlimited, ad stays on screen until user closes ad.
   * If request duration is shorter, the ad stops early.
   * @internal
   */
  compareAdAndReqDurations() {
    this.requestedDuration === zt || this.requestedDuration === or || this.playerFacade.getAdCurrentTime() >= this.requestedDuration && (c.debug.info("Creative requested a duration shorter than the ad", this.requestedDuration), this.stopAd(Rt.CREATIVE_INITIATED));
  }
  /**
   * Sets the error of the ad that can occur during the player process.
   * @param errorObject contains VAST error code and message.
   */
  setError(e) {
    this.currentAd.error = {
      code: e.code,
      message: e.message,
      timestamp: Date.now()
    };
  }
  onGetMediaState(e) {
    const i = {
      currentSrc: this.playerFacade.getCurrentContentSource(),
      currentTime: this.playerFacade.getContentCurrentTime(),
      duration: this.playerFacade.getContentDuration(),
      ended: this.playerFacade.getContentCurrentTime() >= this.playerFacade.getContentDuration(),
      muted: this.playerFacade.isMuted(),
      paused: this.playerFacade.paused,
      volume: this.playerFacade.getVolume(),
      fullscreen: this.playerFacade.isFullscreen()
    };
    this.simidProtocol.resolve(e, i);
  }
  onReceiveCreativeLog(e) {
    e.args.message;
  }
  sendLog(e) {
    const i = {
      message: e
    };
    this.simidProtocol.sendMessage(et.LOG, i);
  }
};
Me.NAME = "SIMIDPly::";
let hr = Me;
function Dn(A) {
  return A.height >= 0 ? A.y + A.height : A.y;
}
function Ln(A) {
  return A.width >= 0 ? A.x : A.x + A.width;
}
function Mn(A) {
  return A.width >= 0 ? A.x + A.width : A.x;
}
function bn(A) {
  return A.height >= 0 ? A.y : A.y + A.height;
}
function lo(A, e) {
  let i = 0, r = {
    bottom: Math.min(Dn(A), Dn(e)),
    height: 0,
    left: Math.max(Ln(A), Ln(e)),
    right: Math.min(Mn(A), Mn(e)),
    top: Math.max(bn(A), bn(e)),
    width: 0
  };
  r.width = r.right - r.left, r.height = r.bottom - r.top;
  let s = A.width * A.height, l = r.width * r.height;
  return l > 0 && (i = l / s), i;
}
class uo {
  /**
   * @param {Object} adSlotController to get adSlotEvents and control the viewability process with them and
   *  currentAd.config includes area and time as setup
   * area - how many pixels in percent of the ad should be visible from the viewer
   * time - how long the viewer must have seen the ad
   * @param {Object} playerFacade to get rectangle over size function from player and viewport
   */
  constructor(e, i) {
    this.adSlotController = e, this.interval = null, this.notViewableDispatched = !1, this.playerFacade = i, this.removeEventHandlers = [], this.startAdTime = null, this.viewabilityConfig = this.adSlotController.currentAd.config.viewability, this.viewabilityFinished = !1, this.addEventListeners();
  }
  addEventListeners() {
    this.removeEventListeners(), Object.keys(p).forEach((e) => {
      let i = this.adSlotController.addEventListener(p[e], this.handleAdEvent.bind(this));
      this.removeEventHandlers.push(i);
    });
  }
  removeEventListeners() {
    this.removeEventHandlers.forEach((e) => {
      e();
    }), this.removeEventHandlers = [];
  }
  handleAdEvent(e) {
    switch (e.type) {
      case p.ON_AD_PAUSED:
        clearInterval(this.interval);
        break;
      case p.ON_AD_PLAYING:
      case p.ON_AD_STARTED:
        this.startAdTime = null, this.notViewableDispatched = !1, this.adVisibilityControl(), clearInterval(this.interval), this.interval = setInterval(() => {
          this.adVisibilityControl();
        }, 250);
        break;
      case p.ON_AD_PLAYBACK_FINISHED:
      case p.ON_AD_SKIPPED:
      case p.ON_AD_STOPPED:
        clearInterval(this.interval), !this.viewabilityFinished && !this.notViewableDispatched && (this.notViewableDispatched = !0, this.adSlotController.dispatchEvent(p.ON_AD_NOT_VIEWABLE)), this.adSlotController.viewability = null;
        break;
    }
  }
  adVisibilityControl() {
    let e = this.playerFacade.getPlayerSize(), i = this.playerFacade.getViewportSize();
    if (e.boundingRect.height === 0 && e.boundingRect.width === 0 || i.boundingRect.height === 0 && i.boundingRect.width === 0) {
      this.removeEventListeners(), this.adSlotController.dispatchEvent(p.ON_AD_VIEWABLE_UNDETERMINED);
      return;
    }
    let r = lo(e.boundingRect, i.boundingRect) * 100;
    r > this.viewabilityConfig.area ? this.startAdTime === null && this.adSlotController.currentAd ? (this.startAdTime = Date.now(), this.adSlotController.currentAd.viewability = {
      state: !0,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(p.ON_AD_VIEWABLE_STATE_CHANGE)) : Date.now() - this.startAdTime > this.viewabilityConfig.time * 1e3 && !this.viewabilityFinished && (c.debug.info("[Viewability] tracker time reached", Date.now()), this.viewabilityFinished = !0, this.adSlotController.dispatchEvent(p.ON_AD_VIEWABLE)) : (this.startAdTime !== null && (this.adSlotController.currentAd.viewability = {
      state: !1,
      threshold: this.viewabilityConfig.area,
      value: r
    }, this.adSlotController.dispatchEvent(p.ON_AD_VIEWABLE_STATE_CHANGE)), this.startAdTime = null);
  }
}
function ho(A, e, i) {
  return new Promise((r) => {
    let s = mt("iframe", {
      id: A,
      style: e
    });
    s.onload = () => {
      let l = mt("script", {
        type: "text/javascript"
      });
      l.innerHTML = "var inDapIF = true;", s.contentDocument.body.appendChild(l);
      let h = mt("style", {});
      h.innerHTML = "html,body{margin:0;}", s.contentDocument.body.appendChild(h), r(s);
    }, i.insertBefore(s, i.firstChild);
  });
}
const $ = class $ extends gt {
  // ms
  constructor(e, i) {
    super(), this.callbacks = null, this.currentAd = i, this.config = i.config, this.container = null, this.durationTime = 0, this.debugTiming = [], this.debugTiming.push({
      event: "constructor",
      time: Date.now()
    }), this.defaultElementStyle = "position:absolute;top:0;left:0;width:100%;height:100%;", this.defaultIFrameStyle = "position:absolute;top:0;left:0;width:0;height:0;overflow:hidden;border:none;visibility:hidden;", this.friendlyIFrame = null, this.height = e.getBoundingClientRect().height, this.log = c.logLevel === tt.NORMAL || c.logLevel === tt.VERBOSE, this.progressInterval = 0, this.remaining = 0, this.resource = i.isLinear ? i.properCreative.selectedMediaFile : i.properCreative.variations[0], this.slot = mt("div", {
      id: "container--vpaid__slot",
      style: this.defaultElementStyle + "overflow:hidden;"
    }), this.videoElement = e, this.videoSlot = null, this.width = e.getBoundingClientRect().width, this.vpaidAd = null, this.vpaidScript = null, this.width = e.getBoundingClientRect().width, this.addContainer(e), ho(
      "container--vpaid__iframe",
      this.defaultIFrameStyle,
      this.container
    ).then((r) => {
      this.friendlyIFrame = r, this.debugTiming.push({
        event: "addFriendlyIFrame.done",
        time: Date.now()
      }), this.addSlots(), this.load();
    });
  }
  addContainer(e) {
    this.container = mt("div", {
      id: "container--vpaid",
      style: this.defaultElementStyle + "z-index:100;"
    }), e.parentNode.insertBefore(this.container, e.nextSibling);
  }
  addSlots() {
    this.debugTiming.push({
      event: "addSlots.start",
      time: Date.now()
    }), this.config.shareVideoElementWithVPAID || (this.videoSlot = mt("video", {
      id: "container--vpaid__videoslot",
      style: this.defaultElementStyle
    }), this.videoSlot.muted = !0, this.friendlyIFrame.contentDocument.body.appendChild(this.videoSlot)), this.friendlyIFrame.contentDocument.body.appendChild(this.slot), this.debugTiming.push({
      event: "addSlots.done",
      time: Date.now()
    });
  }
  load() {
    this.debugTiming.push({
      event: "vpaidScriptLoad.start",
      time: Date.now()
    }), this.vpaidScript = mt("script", {
      type: "text/javascript",
      src: this.currentAd.isLinear ? this.resource.fileURL : this.resource.selectedResource.resource
    }), this.timeoutScriptLoadTimer = setTimeout(() => {
      this.guardScriptLoadFail();
    }, this.config.timeouts.vpaidRequest * 1e3), this.vpaidScript.onload = () => {
      clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.done -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.getVPAIDAd() && this.isValidHandshake() && (this.subscribeToVPAIDAd(), this.initAd());
    }, this.vpaidScript.onerror = (e) => {
      c.debug.warn($.NAME + "load - Creative loading error.", e), clearTimeout(this.timeoutScriptLoadTimer), this.debugTiming.push({
        event: "vpaidScriptLoad.failed -- maxTime:" + this.config.timeouts.vpaidRequest,
        time: Date.now()
      }), this.currentAd.error = w.VAST.FILE_NOT_FOUND, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest failed", this.config.timeouts.vpaidRequest, "");
    }, this.friendlyIFrame.contentDocument.body.appendChild(this.vpaidScript);
  }
  getVPAIDAd() {
    let e = this.friendlyIFrame.contentWindow.getVPAIDAd;
    return e && typeof e == "function" ? (this.vpaidAd = e(), c.debug.info(
      $.NAME + "getVPAIDAd - available properties - preHandshake:",
      Object.keys(this.vpaidAd)
    ), !0) : (c.debug.info($.NAME + "getVPAIDAd - not implemented - not a valid VPAID creative"), !1);
  }
  isValidHandshake() {
    if (this.functionExistsOnVPAIDAd("handshakeVersion")) {
      let e = this.vpaidAd.handshakeVersion("2.0") + "", i = parseInt(e.split(".")[0], 10);
      return c.debug.info(
        $.NAME + "isValidHandshake -- handshakeVersion:",
        e,
        "majorVersion:",
        i
      ), c.debug.info(
        $.NAME + "getVPAIDAd - available properties - afterHandshake:",
        Object.keys(this.vpaidAd)
      ), i <= 2;
    }
    return !1;
  }
  getCreativeData() {
    return { AdParameters: this.resource.adParameters };
  }
  getEnvironmentVars() {
    return {
      slot: this.slot,
      videoSlot: this.config.shareVideoElementWithVPAID ? this.videoElement : this.videoSlot
    };
  }
  initAd() {
    this.debugTiming.push({
      event: "initAd.start",
      time: Date.now()
    }), c.debug.info(
      $.NAME + "initAd -- this.config.shareVideoElementWithVPAID",
      this.config.shareVideoElementWithVPAID
    ), this.functionExistsOnVPAIDAd("initAd") && (this.timeoutAdLoadedTimer = setTimeout(() => {
      this.guardAdLoadedFail();
    }, this.config.timeouts.vpaidReadiness * 1e3), c.debug.info(
      $.NAME + "initAd",
      "WxH:",
      this.width + "x" + this.height,
      "viewMode:",
      this.config.viewMode,
      "bitrate:",
      this.config.bitrate,
      "creativeData:",
      this.getCreativeData(),
      "environmentVars:",
      this.getEnvironmentVars()
    ), this.vpaidAd.initAd(
      this.width,
      this.height,
      this.config.viewMode,
      this.config.bitrate,
      this.getCreativeData(),
      this.getEnvironmentVars()
    ));
  }
  functionExistsOnVPAIDAd(e) {
    return this.vpaidAd && this.vpaidAd[e] && typeof this.vpaidAd[e] == "function";
  }
  subscribeToVPAIDAd() {
    this.callbacks = {
      AdStarted: this.onStartAd,
      AdStopped: this.onStopAd,
      AdSkipped: this.onSkipAd,
      AdLoaded: this.onAdLoaded,
      AdLinearChange: this.onAdLinearChange,
      AdSizeChange: this.onAdSizeChange,
      AdExpandedChange: this.onAdExpandedChange,
      AdSkippableStateChange: this.onAdSkippableStateChange,
      AdDurationChange: this.onAdDurationChange,
      AdRemainingTimeChange: this.onAdRemainingTimeChange,
      // VPAID 1.1
      AdVolumeChange: this.onAdVolumeChange,
      AdImpression: this.onAdImpression,
      AdClickThru: this.onAdClickThru,
      AdInteraction: this.onAdInteraction,
      AdVideoStart: this.onAdVideoStart,
      AdVideoFirstQuartile: this.onAdVideoFirstQuartile,
      AdVideoMidpoint: this.onAdVideoMidpoint,
      AdVideoThirdQuartile: this.onAdVideoThirdQuartile,
      AdVideoComplete: this.onAdVideoComplete,
      AdUserAcceptInvitation: this.onAdUserAcceptInvitation,
      AdUserMinimize: this.onAdUserMinimize,
      AdUserClose: this.onAdUserClose,
      AdPaused: this.onAdPaused,
      AdPlaying: this.onAdPlaying,
      AdError: this.onAdError,
      AdLog: this.onAdLog
    };
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.vpaidAd.subscribe(this.callbacks[e], e, this);
  }
  unsubscribeFromVPAIDAd() {
    for (let e in this.callbacks)
      this.callbacks.hasOwnProperty(e) && this.functionExistsOnVPAIDAd("unsubscribe") && this.vpaidAd.unsubscribe(this.callbacks[e], e, this);
  }
  // time between loading $vpaidScript and getting server response
  guardScriptLoadFail() {
    c.debug.info($.NAME + "guardScriptLoadFail - script didn't load"), clearTimeout(this.timeoutScriptLoadTimer), this.vpaidScript.onload = null, this.vpaidScript.onerror = null, this.currentAd.error = w.VAST.TIMEOUT, this.currentAd.error.message = "Timeout of VPAID resource URI.", this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidRequest timeout", this.config.timeouts.vpaidRequest, "");
  }
  // guards time between initAd and receiving adLoaded
  guardAdLoadedFail() {
    c.debug.info($.NAME + "guardAdLoadedFail"), clearTimeout(this.timeoutAdLoadedTimer), this.currentAd.error = w.VPAID.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.onAdError("vpaidReadiness timeout", this.config.timeouts.vpaidReadiness, "");
  }
  cleanUp() {
    clearInterval(this.progressInterval), this.progressInterval = 0, c.debug.info($.NAME + "cleanup"), this.dispatchEvent(p.ON_VPAID_CLEANUP), this.unsubscribeFromVPAIDAd(), this.removeContainer();
  }
  removeContainer() {
    this.container.parentNode && this.container.parentNode.removeChild(this.container);
  }
  onAdLoaded() {
    c.debug.info($.NAME + "onAdLoaded"), this.debugTiming.push({
      event: "initAd.done - in onAdLoaded() -- maxTime:" + this.config.timeouts.vpaidReadiness,
      time: Date.now()
    }), clearTimeout(this.timeoutAdLoadedTimer), this.dispatchEvent(p.ON_AD_LOADED), this.functionExistsOnVPAIDAd("startAd") && (this.friendlyIFrame.setAttribute("style", "position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;border:none;"), this.vpaidAd.startAd());
  }
  //called from outside, to make the vpaid pause
  pause() {
    c.debug.info($.NAME + "pause"), this.functionExistsOnVPAIDAd("pauseAd") && this.vpaidAd.pauseAd();
  }
  //called from outside, to make the vpaid play
  play() {
    c.debug.info($.NAME + "pause"), this.functionExistsOnVPAIDAd("resumeAd") && this.vpaidAd.resumeAd();
  }
  //called from outside, to make the vpaid change volume
  setVolume(e) {
    c.debug.info($.NAME + "setVolume", e), this.functionExistsOnVPAIDAd("setAdVolume") && this.vpaidAd.setAdVolume(e);
  }
  //called from outside, to make the vpaid adjust its size
  resizeAd(e, i, r) {
    c.debug.info($.NAME + "resizeAd", e, i, r), this.functionExistsOnVPAIDAd("resizeAd") && this.vpaidAd.resizeAd(e, i, r);
  }
  onStartAd() {
    c.debug.info($.NAME + "onStartAd"), this.dispatchEvent(p.ON_AD_STARTED), this.debugTiming.push({
      event: "onStartAd",
      time: Date.now()
    }), this.logTimings();
  }
  onAdImpression(e, i, r) {
    c.debug.info($.NAME + "onAdImpression", e, i, r), this.dispatchEvent(p.ON_AD_IMPRESSION);
  }
  onAdVideoStart(e, i, r) {
    c.debug.info($.NAME + "onAdVideoStart", e, i, r), this.dispatchEvent(p.ON_AD_PLAYBACK_START), this.onAdRemainingTimeChange(), this.progressInterval = setInterval(this.onAdRemainingTimeChange.bind(this), $.TIMEUPDATE_INTERVAL), setTimeout(() => {
      this.remaining <= 0 && (c.debug.warn($.NAME + "onAdRemainingTimeChange - Ad didn't update times after 10 tries.Stop monitoring ad progress."), clearInterval(this.progressInterval), this.progressInterval = 0);
    }, $.TIMEUPDATE_INTERVAL * 10);
  }
  onAdVideoFirstQuartile(e, i, r) {
    c.debug.info($.NAME + "onAdVideoFirstQuartile", e, i, r), this.dispatchEvent(p.ON_AD_FIRST_QUARTILE);
  }
  onAdVideoMidpoint(e, i, r) {
    c.debug.info($.NAME + "onAdVideoMidpoint", e, i, r), this.dispatchEvent(p.ON_AD_MID_POINT);
  }
  onAdVideoThirdQuartile(e, i, r) {
    c.debug.info($.NAME + "onAdVideoThirdQuartile", e, i, r), this.dispatchEvent(p.ON_AD_THIRD_QUARTILE);
  }
  onAdVideoComplete(e, i, r) {
    c.debug.info($.NAME + "onAdVideoComplete", e, i, r), clearInterval(this.progressInterval), this.onAdRemainingTimeChange(), this.currentAd.playbackComplete = !0, this.dispatchEvent(p.ON_AD_PLAYBACK_FINISHED);
  }
  onAdDurationChange(e, i, r) {
    c.debug.info($.NAME + "onAdDurationChange", e, i, r), this.getAllProperties();
  }
  onStopAd(e, i, r) {
    c.debug.info($.NAME + "::onStopAd()", e, i, r), this.dispatchEvent(p.ON_AD_STOPPED), this.cleanUp();
  }
  onAdError(e, i, r) {
    c.debug.info($.NAME + "onAdError", e, i, r), this.currentAd.error = this.currentAd.error === null ? w.VPAID.GENERAL_ERROR : this.currentAd.error, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(p.ON_AD_ERROR), this.cleanUp();
  }
  onSkipAd(e, i, r) {
    this.dispatchEvent(p.ON_AD_SKIPPED), c.debug.info($.NAME + "onSkipAd", e, i, r), this.cleanUp();
  }
  onAdLinearChange() {
    this.dispatchEvent(p.ON_AD_LINEARITY_CHANGE);
  }
  onAdSizeChange() {
    this.functionExistsOnVPAIDAd("getAdWidth") && this.functionExistsOnVPAIDAd("getAdHeight") && c.debug.info(
      $.NAME + "onAdSizeChange",
      this.vpaidAd.getAdWidth(),
      this.vpaidAd.getAdHeight()
    ), this.dispatchEvent(p.ON_AD_SIZE_CHANGED);
  }
  onAdExpandedChange(e, i, r) {
    c.debug.info($.NAME + "onAdExpandedChange", e, i, r);
  }
  onAdSkippableStateChange(e, i, r) {
    c.debug.info($.NAME + "onAdSkippableStateChange", e, i, r), this.dispatchEvent(p.ON_AD_SKIPPABLE_STATE_CHANGE);
  }
  /**
   * Deprecated with VPAID 2.0. Players have to use internal logic to update the progress UI.
   * @returns {void}
   * @deprecated
   */
  onAdRemainingTimeChange() {
    this.functionExistsOnVPAIDAd("getAdDuration") && (this.durationTime = this.vpaidAd.getAdDuration()), this.functionExistsOnVPAIDAd("getAdRemainingTime") && (this.remaining = this.vpaidAd.getAdRemainingTime()), this.dispatchEvent(p.ON_AD_PROGRESS);
  }
  onAdVolumeChange(e, i, r) {
    c.debug.info($.NAME + "onAdVolumeChange", e, i, r);
  }
  /**
   * See VPAID 2.0 specs: How to handle click throughs
   *
   * @param {string} url - Optional. The landing page URI.
   * @param {string} id - Optional. Unused.
   * @param {Boolean} playerHandles - Optional. Whether the core should open the landing page or not.
   *   defaulting to false.
   * @returns {void}
   */
  onAdClickThru(e = null, i = null, r = !1) {
    c.debug.info($.NAME + "onAdClickThru - creative handles click", !r), r === !0 && (c.debug.info($.NAME + "onAdClickThru - open landing page", e, i), this.currentAd.clickThroughURL = e || this.currentAd.clickThroughURL, this.currentAd.handleClickThrough = r), this.dispatchEvent(p.ON_AD_CLICKED);
  }
  onAdInteraction(e, i, r) {
    c.debug.info($.NAME + "onAdInteraction", e, i, r);
  }
  onAdUserAcceptInvitation(e, i, r) {
    c.debug.info($.NAME + "onAdUserAcceptInvitation", e, i, r);
  }
  onAdUserMinimize(e, i, r) {
    c.debug.info($.NAME + "onAdUserMinimize", e, i, r);
  }
  onAdUserClose(e, i, r) {
    c.debug.info($.NAME + "onAdUserClose", e, i, r);
  }
  onAdPaused(e, i, r) {
    c.debug.info($.NAME + "onAdPaused", e, i, r);
  }
  onAdPlaying(e, i, r) {
    c.debug.info($.NAME + "onAdPlaying", e, i, r), this.dispatchEvent(p.ON_AD_PLAYING);
  }
  onAdLog(e, i, r) {
    c.debug.info($.NAME + "onAdLog", e, i, r);
  }
  get duration() {
    return this.durationTime || 0;
  }
  get remainingTime() {
    return this.remaining || 0;
  }
  //Debug -- Start
  /* istanbul ignore next */
  getAllProperties() {
    if (!this.log)
      return;
    let e = Object.keys(this.vpaidAd);
    for (let i in e)
      e.hasOwnProperty(i) && e[i].indexOf("getAd") === 0 && c.debug.info(
        $.NAME + "--vpaidAd." + e[i] + "()",
        this.vpaidAd[e[i]]()
      );
  }
  /* istanbul ignore next */
  logTimings() {
    this.log && (this.debugTiming.map((e, i, r) => {
      i === 0 ? e.delta = 0 : e.delta = r[i].time - r[i - 1].time;
    }), c.debug.table(this.debugTiming));
  }
  //Debug -- End
};
$.NAME = "VPAIDBridge::", $.TIMEUPDATE_INTERVAL = 250;
let cr = $;
const ri = {
  // these MimeTypes will be used if desireMimeTypes remains unset from publisher side - don't change sequence!
  VPAID: "application/javascript",
  SIMID: "text/html",
  MP4: "video/mp4",
  WEBM: "video/webm",
  OGG: "video/ogg",
  MP3: "audio/mpeg"
}, xe = class xe extends gt {
  /**
   * @param {adPod} adPod - AdSlotManifest Defines the adSlot
   * @param {adBuffet} adBuffet - AdSlotManifest Defines the adSlot buffet ads
   * @param {EnvironmentVars} envVars Used for passing implementation-specific runtime variables.
   * @param {PlayerFacade} player
   */
  constructor(e, i, r, s) {
    super(), this.adCount = 0, this.adDuration = 1 / 0, this.currentViewMode = xe.VIEW_MODE.NORMAL, this.environmentVars = r, this.eventCallbacks = [], this.eventKeys = Object.keys(p), this.eventTypes = Object.values(p), this.nonLinearView = null, this.player = s, this.progressTracker = null, this.properCreative = null, this.replacedCounter = 0, this.requestedTrackingEvents = [], this.simidPlayer = null, this.viewability = null, this.vpaidPlayer = null, this.prepare(e, i);
  }
  prepare(e, i) {
    this.manifest = e.slice(0), this.buffet = (i || []).slice(0), this.adSlotTimes = new oo(this.manifest), this.currentAd = null, this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    });
  }
  updateAdSettings() {
    this.properCreative = this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile : this.currentAd.properCreative.variations[0], this.currentAd.isExpanded = !1, this.currentAd.isSkippable = !1, this.currentAd.isVPAID = this.properCreative.isVPAID, this.currentAd.isSIMID = !!this.currentAd.properCreative.selectedCreativeFile, this.currentAd.isInteractive = this.currentAd.isVPAID || this.currentAd.isSIMID, this.currentAd.isVPAID && (this.currentAd.config.bitrate = this.environmentVars.desiredBitrate || 500, this.currentAd.config.viewMode = "dynamic"), this.currentAd.isLinear && (this.currentAd.skipOffsetValue = this.currentAd.skipOffset === -1 ? this.currentAd.config.skipOffset : this.currentAd.skipOffsetValue), this.currentAd.isLinear ? (this.currentAd.enrichment.setFromObject(this.environmentVars.vastMacros), this.currentAd.enrichment.set("ADTYPE", this.currentAd.adType), this.currentAd.enrichment.set("ASSETURI", this.properCreative.fileURL)) : (this.currentAd.enrichment.set("ADTYPE", "hybrid"), this.currentAd.enrichment.set("ASSETURI", this.properCreative.selectedResource.resource.fileURL), this.currentAd.enrichment.set(
      "MEDIAMIME",
      this.environmentVars.desiredMimeTypes || Object.values(ri)
    ), this.currentAd.properCreative.variations[0].displayDuration = this.getMinimalDurationTime()), [ue.COMMERCIAL, ue.SPONSORED].includes(this.currentAd.variant) ? this.currentAd.enrichment.set("ADCOUNT", this.adCount += 1) : this.currentAd.enrichment.set("ADCOUNT", -1), this.currentAd.enrichment.set("ADSERVINGID", this.currentAd.adServingId), this.currentAd.enrichment.set("BLOCKED", this.currentAd.adReinsertion.isActive ? 1 : 0), this.currentAd.enrichment.set("ERRORCODE", 0), isNaN(this.currentAd.sequence) || this.currentAd.enrichment.set("PODSEQUENCE", this.currentAd.currentPodSequencing + this.replacedCounter), this.currentAd.enrichment.set("UNIVERSALADID", this.currentAd.universalAdIds);
  }
  startViewability() {
    this.viewability = null, this.currentAd.adTrackers.viewable && (this.viewability = new uo(this, this.player));
  }
  getAd() {
    if (this.progressTracker = null, this.currentAd = this.manifest.length > 0 ? this.manifest.shift() : null, !this.currentAd)
      return null;
    if (this.eventCallbacks.forEach((i) => {
      i();
    }), this.eventCallbacks = [], Object.keys(p).forEach((i) => {
      const r = this.addEventListener(p[i], (s) => {
        this.trackEvent(s.type);
      });
      this.eventCallbacks.push(r);
    }), this.currentAd.hasError)
      return this.currentAd.trackingEvents = this.currentAd.adTrackers, this.currentAd;
    if (this.currentAd.config.adSourceSelector) {
      let i = null;
      const r = new Promise((l) => {
        i = setTimeout(l, 250, null);
      }), s = this.currentAd.isLinear ? "mediaFiles" : "variations";
      if (this.currentAd.properCreative && this.currentAd.properCreative[s].length) {
        let l = this.currentAd.isLinear ? this.currentAd.properCreative[s] : this.currentAd.properCreative[s][0].resources;
        const h = this.currentAd.config.adSourceSelector(
          l
        ).then((m) => m === null || Object.keys(m).length === 0 ? null : m);
        Promise.race([r, h]).then((m) => {
          m === null && this.cancelAd(), this.currentAd.isLinear ? this.currentAd.properCreative.selectedMediaFile = m : this.currentAd.properCreative.selectedResource = m, this.updateAdSettings();
        }).catch(() => {
          this.cancelAd();
        });
      } else
        clearTimeout(i), this.cancelAd();
    } else {
      this.updateAdSettings();
      const i = this.currentAd.isLinear ? this.currentAd.properCreative.creativeTrackers : this.currentAd.properCreative.variations[0].creativeTrackers;
      this.currentAd.trackingEvents = Object.assign({}, this.currentAd.adTrackers, i);
    }
    const e = this.addEventListener(p.ON_AD_ERROR, this.setTotalCommercialsDuration);
    return this.eventCallbacks.push(e), this.currentAd;
  }
  applyBuffetAd() {
    if (!this.currentAd.replaced && this.currentAd.fallbackOnNoAd && this.buffet.length > 0) {
      let e = this.buffet.shift();
      if (e.adCount = this.adCount + 1, this.replacedCounter += 1, e.currentClip = this.currentAd.currentClip, e.currentCommercial = this.currentAd.currentCommercial, c.debug.info(xe.NAME + "applyBuffetAd - Insert at runtime", e), this.currentAd.replaced = !0, this.manifest.replaced = 1, this.manifest.unshift(e), e.variant === ue.COMMERCIAL) {
        let i = e.duration;
        this.currentAd.isLinear || (i += this.currentAd.duration), c.debug.info(
          xe.NAME + "applyBuffetAd - adjust totalCommercialsDuration after replace",
          i
        ), this.adSlotTimes.setTotalCommercialsDuration(i), this.setTotalCommercialsDuration(), c.debug.info(xe.NAME + "deliver buffetAd", this.manifest);
      }
    }
  }
  callTrackers(e) {
    if (!e || e.length < 1) {
      c.debug.info(xe.NAME + "callTrackers - Request without URIs", e);
      return;
    }
    const i = {
      adReinsertion: this.currentAd.adReinsertion,
      enrichment: this.currentAd.enrichment,
      timeouts: this.currentAd.config.timeouts,
      urlhandler: this.currentAd.config.urlhandler
    };
    this.currentAd.enrichment.set("PLAYERSIZE", this.player.getPlayerSize().boundingRect);
    let r = this.currentAd;
    new ii().track(e, (s, l) => {
      l && (c.debug.warn(xe.NAME + "callTrackers failed:", l, s), r.error = l.code ? l : w.WARNING.TRACKER_LOAD_FAILED, r.error.message = `${r.error.message}: ${JSON.stringify(s)}`, this.dispatchEvent(p.ON_AD_WARNING));
    }, i);
  }
  // async canceling ad (adSourceSelector way)
  cancelAd() {
    if (this.currentAd.isLinear && this.currentAd.type === ae.NON_LINEAR) {
      this.currentAd.error = w.CREATIVE.EXPECTED_DIFFERENT_ADTYPE, this.dispatchEvent(p.ON_AD_ERROR);
      return;
    }
    this.cancelAdWithError();
  }
  cancelAdWithError() {
    this.currentAd.error || (this.currentAd.error = {}, this.currentAd.error = w.VAST.UNSUPPORTED_MIMETYPE), c.debug.info(xe.NAME + "Canceling ad with error", this.currentAd), this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(p.ON_AD_ERROR), this.applyBuffetAd();
  }
  // only called in nonlinear cases
  getMinimalDurationTime() {
    return this.currentAd.minSuggestedDuration > 0 ? Math.min(this.currentAd.minSuggestedDuration, this.currentAd.config.timeouts.nonlinearMaxDuration) : this.currentAd.config.timeouts.nonlinearMaxDuration;
  }
  onClickThrough(e) {
    this.dispatchEvent(p.ON_AD_CLICKED);
    let i = this.currentAd.enrichment.apply(this.currentAd.clickThroughURL);
    if (i && i.indexOf("//") === 0 && (i = Mi(i, "")), !e) {
      const r = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(i, r);
    }
    return i;
  }
  onIconView(e) {
    if (this.currentAd && this.currentAd.icons[e]) {
      let i = this.currentAd.icons[e].creativeViewTracker;
      this.callTrackers(i);
    }
  }
  /**
   * Called by the AdSlotAPI for each ad that is going to start for another time
   */
  onRewind() {
    this.dispatchEvent(p.ON_AD_REWIND);
  }
  onVerificationNotExecuted(e, i) {
    if (this.currentAd && this.currentAd.adVerifications) {
      let r = this.currentAd.adVerifications.filter((h) => h.vendor === e)[0];
      if (!r || !r.tracking.verificationNotExecuted)
        return;
      let s = r.tracking.verificationNotExecuted, l = parseInt(i, 10);
      i && isFinite(l) && l >= 1 && l <= 3 && this.currentAd.enrichment.set("REASON", l), s && s.length > 0 && this.callTrackers(s);
    }
  }
  setTotalCommercialsDuration() {
    if (this.currentAd.variant === ue.COMMERCIAL) {
      const e = this.currentAd.duration * -1;
      c.debug.info(xe.NAME + "setTotalCommercialsDuration - decrease", e), this.adSlotTimes.setTotalCommercialsDuration(e), this.dispatchEvent(p.ON_AD_SLOT_DURATION_CHANGE);
      return;
    }
    this.currentAd.replaced === !0 && this.dispatchEvent(p.ON_AD_SLOT_DURATION_CHANGE);
  }
  onAdSkippableStateChange() {
    this.currentAd.adSkippableStateChangeSent || (this.currentAd.adSkippableStateChangeSent = !0, this.currentAd.isSkippable = !0, this.dispatchEvent(p.ON_AD_SKIPPABLE_STATE_CHANGE));
  }
  onIconClickThrough(e, i) {
    if (!this.currentAd.icons[e])
      return null;
    let r = this.currentAd.icons[e].clickTracker;
    this.callTrackers(r);
    let s = this.currentAd.enrichment.apply(this.currentAd.icons[e].clickThroughURL);
    if (!i) {
      const l = this.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
      window.open(s, l);
    }
    return s;
  }
  onResizeAd(e, i) {
    this.currentAd && (i !== this.currentViewMode && (this.currentViewMode = i, i === xe.VIEW_MODE.FULLSCREEN ? (this.dispatchEvent(p.ON_ENTER_FULLSCREEN), this.dispatchEvent(p.ON_PLAYER_EXPAND)) : (this.dispatchEvent(p.ON_EXIT_FULLSCREEN), this.dispatchEvent(p.ON_PLAYER_COLLAPSE))), this.currentAd.isVPAID ? this.vpaidPlayer.resizeAd(e.width, e.height, i) : this.dispatchEvent(p.ON_AD_SIZE_CHANGED));
  }
  onSkip() {
    this.currentAd.variant === ue.COMMERCIAL && (this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + this.currentAd.duration), this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime)), this.adDuration = 1 / 0, this.dispatchEvent(p.ON_AD_SKIPPED);
  }
  // called on VPAID ON_AD_SKIPPABLE_STATE_CHANGE
  timeupdate() {
    if (!this.currentAd)
      return;
    let e = this.currentAd.isVPAID ? this.vpaidPlayer.duration - this.vpaidPlayer.remainingTime : this.player.getAdCurrentTime();
    if (this.adDuration = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.player.getAdDuration(), !(!this.currentAd || isNaN(this.adDuration) || !isNaN(this.adDuration) && this.adDuration <= 0 || Object.keys(this.currentAd).length < 1)) {
      if (this.currentAd.enrichment.set("ADPLAYHEAD", Di(e)), this.currentAd.variant === ue.COMMERCIAL) {
        const i = this.adDuration - this.currentAd.duration;
        if (i && Number.isFinite(i)) {
          let r = i;
          this.currentAd.isLinear || (r = this.currentAd.isVPAID ? this.vpaidPlayer.duration : this.getMinimalDurationTime()), this.adSlotTimes.setTotalCommercialsDuration(r);
        }
        e >= this.adDuration ? (this.adSlotTimes.setCurrentTimeOffset(this.adSlotTimes.totalCommercialsCurrentTime), this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset)) : this.adSlotTimes.setCommercialsCurrentTime(this.adSlotTimes.currentTimeOffset + e);
      }
      if (this.currentAd.duration = this.adDuration, this.currentAd.currentTime = e, this.currentAd.remainingTime = this.adDuration - e, [ue.COMMERCIAL, ue.SPONSORED].includes(this.currentAd.variant) && Number.isFinite(this.currentAd.skipOffset) && this.currentAd.skipOffset > -1 && e >= this.currentAd.skipOffset && this.onAdSkippableStateChange(), this.currentAd) {
        if (!this.progressTracker && this.currentAd.properCreative && this.currentAd.properCreative.creativeTrackers && this.currentAd.properCreative.creativeTrackers.progress && (this.progressTracker = this.currentAd.properCreative.creativeTrackers.progress), this.progressTracker && this.progressTracker.forEach((s) => {
          let l = s.offset;
          l.indexOf("%") > -1 && (l = parseInt(l, 10) / 100 * this.adDuration), e >= parseInt(l, 10) && !s.requested && this.dispatchEvent(p.ON_AD_PROGRESS);
        }), this.currentAd.isVPAID || !this.currentAd.isLinear)
          return;
        let i = [], r = [];
        e >= this.adDuration && i.push(p.ON_AD_PLAYBACK_FINISHED), e >= this.adDuration / (4 / 3) && i.push(p.ON_AD_THIRD_QUARTILE), e >= this.adDuration / 2 && i.push(p.ON_AD_MID_POINT), e >= this.adDuration / 4 && i.push(p.ON_AD_FIRST_QUARTILE), e && i.push(p.ON_AD_PLAYBACK_START), r.push(i[0]), this.currentAd.config.trackSkippedQuartiles && (r = i);
        for (let s = r.length - 1; s >= 0; s--)
          this.requestedTrackingEvents.filter((h) => h === r[s]).shift() || (this.dispatchEvent(r[s]), this.currentAd.isSIMID && this.requestedTrackingEvents.push(r[s]));
      }
    }
  }
  trackEvent(e) {
    const i = this.eventKeys[this.eventTypes.indexOf(e)], r = Ut[i], s = this.player.getAdCurrentTime(), l = this.player.getAdDuration();
    if (this.requestedTrackingEvents.push(e), this.currentAd && this.currentAd.trackingEvents && this.currentAd.trackingEvents[r]) {
      let h = this.currentAd.trackingEvents[r];
      e === p.ON_AD_PROGRESS && (h = h.filter((m) => {
        let E = m.offset;
        return E.indexOf("%") > -1 && (E = parseInt(E, 10) / 100 * l), s >= parseInt(E, 10) && !m.requested;
      })), this.callTrackers(h);
    }
  }
  loadAdSIMID() {
    this.simidPlayer = new hr(this), this.simidPlayer.initializeAd();
  }
  loadAdVPAID() {
    this.vpaidPlayer = new cr(this.player.getPlayerElement(), this.currentAd), this.currentAd.isLinear ? [
      p.ON_AD_CLICKED,
      p.ON_AD_LOADED,
      p.ON_AD_STARTED,
      p.ON_AD_IMPRESSION,
      p.ON_AD_PLAYING,
      p.ON_AD_PLAYBACK_START,
      p.ON_AD_FIRST_QUARTILE,
      p.ON_AD_MID_POINT,
      p.ON_AD_THIRD_QUARTILE,
      p.ON_AD_PLAYBACK_FINISHED,
      p.ON_AD_STOPPED,
      p.ON_AD_SKIPPED,
      p.ON_AD_ERROR,
      p.ON_AD_PROGRESS,
      p.ON_AD_SIZE_CHANGED,
      p.ON_AD_SKIPPABLE_STATE_CHANGE,
      p.ON_VPAID_CLEANUP
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.vpaidEventHandler(i));
      }
    ) : [
      p.ON_AD_LINEARITY_CHANGE,
      p.ON_AD_SKIPPED,
      p.ON_AD_STOPPED
    ].map(
      (e) => {
        this.vpaidPlayer.addEventListener(e, (i) => this.nonLinearVpaidEventHandler(i));
      }
    );
  }
  nonLinearVpaidEventHandler(e) {
    if (this.vpaidPlayer.functionExistsOnVPAIDAd("getAdLinear"))
      switch (e.type) {
        case p.ON_AD_LINEARITY_CHANGE:
          this.vpaidPlayer.vpaidAd.getAdLinear() ? (c.debug.info("::NonLinearHandler - Ad change linear mode"), this.player.saveContentState()) : this.player.restoreContentState();
          break;
        case p.ON_AD_SKIPPED:
        case p.ON_AD_STOPPED:
          this.vpaidPlayer.vpaidAd.getAdLinear() && this.player.restoreContentState();
          break;
      }
  }
  vpaidEventHandler(e) {
    let i;
    switch (e.type) {
      // there's no creative view event in vpaid, so we send it when impression is triggered
      case p.ON_AD_LOADED:
      //onStartAd
      case p.ON_AD_STARTED:
      //onStartAd
      case p.ON_AD_IMPRESSION:
      case p.ON_AD_PLAYING:
      //onAdPlaying()
      case p.ON_AD_PLAYBACK_START:
      //onVideoStart()
      case p.ON_AD_FIRST_QUARTILE:
      case p.ON_AD_MID_POINT:
      case p.ON_AD_THIRD_QUARTILE:
      case p.ON_AD_PLAYBACK_FINISHED:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case p.ON_AD_CLICKED:
        i = !this.currentAd.handleClickThrough, this.onClickThrough(i);
        break;
      case p.ON_AD_SKIPPABLE_STATE_CHANGE:
        this.onAdSkippableStateChange();
        break;
      case p.ON_AD_PROGRESS:
        this.timeupdate();
        break;
      case p.ON_AD_SIZE_CHANGED:
        this.dispatchEvent(e.type);
        break;
      case p.ON_AD_SKIPPED:
        this.requestedTrackingEvents.push(e.type), this.onSkip();
        break;
      case p.ON_AD_ERROR:
        this.requestedTrackingEvents.push(e.type), this.dispatchEvent(e.type);
        break;
      case p.ON_AD_STOPPED:
        this.dispatchEvent(e.type);
        break;
      case p.ON_VPAID_CLEANUP:
        this.dispatchEvent(e.type);
        break;
    }
  }
  // nonLinear part
  stop() {
    c.debug.info("[NonLinearAdSlotDelivery] Stop AdSlot."), this.nonLinearView.stop(), this.nonLinearView = null;
  }
};
xe.NAME = "AdSloCtrl::", xe.VIEW_MODE = {
  FULLSCREEN: "fullscreen",
  NORMAL: "normal"
};
let pr = xe;
var ft = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : {};
function co(A) {
  return A && A.__esModule && Object.prototype.hasOwnProperty.call(A, "default") ? A.default : A;
}
var Hn = {};
(function(A) {
  (function(e, i, r) {
    if (typeof r == "object" && typeof r.nodeName != "string")
      i(e, r);
    else {
      let E = function(S) {
        for (var M in S)
          S.hasOwnProperty(M) && (S[M] = E(S[M]));
        return Object.freeze(S);
      };
      var r = {}, s = ["1.5.6-iab144"], l = "default";
      l && s.push(l), i(e, r);
      for (var h in r)
        r.hasOwnProperty(h) && (Object.getOwnPropertyDescriptor(e, h) == null && Object.defineProperty(e, h, {
          value: {}
        }), s.forEach(function(S) {
          if (Object.getOwnPropertyDescriptor(e[h], S) == null) {
            var M = E(r[h]);
            Object.defineProperty(e[h], S, {
              get: function() {
                return M;
              },
              enumerable: !0
            });
          }
        }));
    }
  })(ft, function(e, i) {
    var r = r || {};
    r.scope = {}, r.createTemplateTagFirstArg = function(a) {
      return a.raw = a;
    }, r.createTemplateTagFirstArgWithRaw = function(a, u) {
      return a.raw = u, a;
    }, r.arrayIteratorImpl = function(a) {
      var u = 0;
      return function() {
        return u < a.length ? { done: !1, value: a[u++] } : { done: !0 };
      };
    }, r.arrayIterator = function(a) {
      return { next: r.arrayIteratorImpl(a) };
    }, r.makeIterator = function(a) {
      var u = typeof Symbol != "undefined" && Symbol.iterator && a[Symbol.iterator];
      if (u)
        return u.call(a);
      if (typeof a.length == "number")
        return r.arrayIterator(a);
      throw Error(String(a) + " is not an iterable or ArrayLike");
    }, r.arrayFromIterator = function(a) {
      for (var u, g = []; !(u = a.next()).done; )
        g.push(u.value);
      return g;
    }, r.arrayFromIterable = function(a) {
      return a instanceof Array ? a : r.arrayFromIterator(r.makeIterator(a));
    }, r.ASSUME_ES5 = !1, r.ASSUME_NO_NATIVE_MAP = !1, r.ASSUME_NO_NATIVE_SET = !1, r.SIMPLE_FROUND_POLYFILL = !1, r.ISOLATE_POLYFILLS = !1, r.FORCE_POLYFILL_PROMISE = !1, r.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION = !1, r.objectCreate = r.ASSUME_ES5 || typeof Object.create == "function" ? Object.create : function(a) {
      var u = function() {
      };
      return u.prototype = a, new u();
    }, r.defineProperty = r.ASSUME_ES5 || typeof Object.defineProperties == "function" ? Object.defineProperty : function(a, u, g) {
      return a == Array.prototype || a == Object.prototype || (a[u] = g.value), a;
    }, r.getGlobal = function(a) {
      a = [typeof globalThis == "object" && globalThis, a, typeof window == "object" && window, typeof self == "object" && self, typeof ft == "object" && ft];
      for (var u = 0; u < a.length; ++u) {
        var g = a[u];
        if (g && g.Math == Math)
          return g;
      }
      throw Error("Cannot find global object");
    }, r.global = r.getGlobal(this), r.IS_SYMBOL_NATIVE = typeof Symbol == "function" && typeof Symbol("x") == "symbol", r.TRUST_ES6_POLYFILLS = !r.ISOLATE_POLYFILLS || r.IS_SYMBOL_NATIVE, r.polyfills = {}, r.propertyToPolyfillSymbol = {}, r.POLYFILL_PREFIX = "$jscp$", r.polyfill = function(a, u, g, y) {
      u && (r.ISOLATE_POLYFILLS ? r.polyfillIsolated(a, u, g, y) : r.polyfillUnisolated(a, u, g, y));
    }, r.polyfillUnisolated = function(a, u, g, y) {
      for (g = r.global, a = a.split("."), y = 0; y < a.length - 1; y++) {
        var _ = a[y];
        if (!(_ in g))
          return;
        g = g[_];
      }
      a = a[a.length - 1], y = g[a], u = u(y), u != y && u != null && r.defineProperty(g, a, { configurable: !0, writable: !0, value: u });
    }, r.polyfillIsolated = function(a, u, g, y) {
      var _ = a.split(".");
      a = _.length === 1, y = _[0], y = !a && y in r.polyfills ? r.polyfills : r.global;
      for (var ce = 0; ce < _.length - 1; ce++) {
        var pe = _[ce];
        if (!(pe in y))
          return;
        y = y[pe];
      }
      _ = _[_.length - 1], g = r.IS_SYMBOL_NATIVE && g === "es6" ? y[_] : null, u = u(g), u != null && (a ? r.defineProperty(r.polyfills, _, { configurable: !0, writable: !0, value: u }) : u !== g && (r.propertyToPolyfillSymbol[_] === void 0 && (g = 1e9 * Math.random() >>> 0, r.propertyToPolyfillSymbol[_] = r.IS_SYMBOL_NATIVE ? r.global.Symbol(_) : r.POLYFILL_PREFIX + g + "$" + _), r.defineProperty(y, r.propertyToPolyfillSymbol[_], { configurable: !0, writable: !0, value: u })));
    }, r.getConstructImplementation = function() {
      function a() {
        function g() {
        }
        return Reflect.construct(g, [], function() {
        }), new g() instanceof g;
      }
      if (r.TRUST_ES6_POLYFILLS && typeof Reflect != "undefined" && Reflect.construct) {
        if (a())
          return Reflect.construct;
        var u = Reflect.construct;
        return function(g, y, _) {
          return g = u(g, y), _ && Reflect.setPrototypeOf(g, _.prototype), g;
        };
      }
      return function(g, y, _) {
        return _ === void 0 && (_ = g), _ = r.objectCreate(_.prototype || Object.prototype), Function.prototype.apply.call(g, _, y) || _;
      };
    }, r.construct = { valueOf: r.getConstructImplementation }.valueOf(), r.underscoreProtoCanBeSet = function() {
      var a = { a: !0 }, u = {};
      try {
        return u.__proto__ = a, u.a;
      } catch (g) {
      }
      return !1;
    }, r.setPrototypeOf = r.TRUST_ES6_POLYFILLS && typeof Object.setPrototypeOf == "function" ? Object.setPrototypeOf : r.underscoreProtoCanBeSet() ? function(a, u) {
      if (a.__proto__ = u, a.__proto__ !== u)
        throw new TypeError(a + " is not extensible");
      return a;
    } : null, r.inherits = function(a, u) {
      if (a.prototype = r.objectCreate(u.prototype), a.prototype.constructor = a, r.setPrototypeOf) {
        var g = r.setPrototypeOf;
        g(a, u);
      } else
        for (g in u)
          if (g != "prototype")
            if (Object.defineProperties) {
              var y = Object.getOwnPropertyDescriptor(u, g);
              y && Object.defineProperty(a, g, y);
            } else
              a[g] = u[g];
      a.superClass_ = u.prototype;
    }, r.getRestArguments = function() {
      for (var a = Number(this), u = [], g = a; g < arguments.length; g++)
        u[g - a] = arguments[g];
      return u;
    }, r.polyfill("Reflect", function(a) {
      return a || {};
    }, "es6", "es3"), r.polyfill("Reflect.construct", function(a) {
      return r.construct;
    }, "es6", "es3"), r.polyfill("Reflect.setPrototypeOf", function(a) {
      if (a)
        return a;
      if (r.setPrototypeOf) {
        var u = r.setPrototypeOf;
        return function(g, y) {
          try {
            return u(g, y), !0;
          } catch (_) {
            return !1;
          }
        };
      }
      return null;
    }, "es6", "es5"), r.initSymbol = function() {
    }, r.polyfill("Symbol", function(a) {
      if (a)
        return a;
      var u = function(ce, pe) {
        this.$jscomp$symbol$id_ = ce, r.defineProperty(this, "description", { configurable: !0, writable: !0, value: pe });
      };
      u.prototype.toString = function() {
        return this.$jscomp$symbol$id_;
      };
      var g = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", y = 0, _ = function(ce) {
        if (this instanceof _)
          throw new TypeError("Symbol is not a constructor");
        return new u(g + (ce || "") + "_" + y++, ce);
      };
      return _;
    }, "es6", "es3"), r.polyfill("Symbol.iterator", function(a) {
      if (a)
        return a;
      a = Symbol("Symbol.iterator");
      for (var u = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), g = 0; g < u.length; g++) {
        var y = r.global[u[g]];
        typeof y == "function" && typeof y.prototype[a] != "function" && r.defineProperty(y.prototype, a, { configurable: !0, writable: !0, value: function() {
          return r.iteratorPrototype(r.arrayIteratorImpl(this));
        } });
      }
      return a;
    }, "es6", "es3"), r.iteratorPrototype = function(a) {
      return a = { next: a }, a[Symbol.iterator] = function() {
        return this;
      }, a;
    }, r.iteratorFromArray = function(a, u) {
      a instanceof String && (a += "");
      var g = 0, y = !1, _ = { next: function() {
        if (!y && g < a.length) {
          var ce = g++;
          return { value: u(ce, a[ce]), done: !1 };
        }
        return y = !0, { done: !0, value: void 0 };
      } };
      return _[Symbol.iterator] = function() {
        return _;
      }, _;
    }, r.polyfill("Array.prototype.keys", function(a) {
      return a || function() {
        return r.iteratorFromArray(this, function(u) {
          return u;
        });
      };
    }, "es6", "es3"), r.owns = function(a, u) {
      return Object.prototype.hasOwnProperty.call(a, u);
    }, r.polyfill("Object.values", function(a) {
      return a || function(u) {
        var g = [], y;
        for (y in u)
          r.owns(u, y) && g.push(u[y]);
        return g;
      };
    }, "es8", "es3"), r.checkEs6ConformanceViaProxy = function() {
      try {
        var a = {}, u = Object.create(new r.global.Proxy(a, { get: function(g, y, _) {
          return g == a && y == "q" && _ == u;
        } }));
        return u.q === !0;
      } catch (g) {
        return !1;
      }
    }, r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS = !1, r.ES6_CONFORMANCE = r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS && r.checkEs6ConformanceViaProxy(), r.polyfill("WeakMap", function(a) {
      function u() {
        if (!a || !Object.seal)
          return !1;
        try {
          var b = Object.seal({}), k = Object.seal({}), z = new a([[b, 2], [k, 3]]);
          return z.get(b) != 2 || z.get(k) != 3 ? !1 : (z.delete(b), z.set(k, 4), !z.has(b) && z.get(k) == 4);
        } catch (nt) {
          return !1;
        }
      }
      function g() {
      }
      function y(b) {
        var k = typeof b;
        return k === "object" && b !== null || k === "function";
      }
      function _(b) {
        if (!r.owns(b, pe)) {
          var k = new g();
          r.defineProperty(b, pe, { value: k });
        }
      }
      function ce(b) {
        if (!r.ISOLATE_POLYFILLS) {
          var k = Object[b];
          k && (Object[b] = function(z) {
            return z instanceof g ? z : (Object.isExtensible(z) && _(z), k(z));
          });
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var pe = "$jscomp_hidden_" + Math.random();
      ce("freeze"), ce("preventExtensions"), ce("seal");
      var ht = 0, F = function(b) {
        if (this.id_ = (ht += Math.random() + 1).toString(), b) {
          b = r.makeIterator(b);
          for (var k; !(k = b.next()).done; )
            k = k.value, this.set(k[0], k[1]);
        }
      };
      return F.prototype.set = function(b, k) {
        if (!y(b))
          throw Error("Invalid WeakMap key");
        if (_(b), !r.owns(b, pe))
          throw Error("WeakMap key fail: " + b);
        return b[pe][this.id_] = k, this;
      }, F.prototype.get = function(b) {
        return y(b) && r.owns(b, pe) ? b[pe][this.id_] : void 0;
      }, F.prototype.has = function(b) {
        return y(b) && r.owns(b, pe) && r.owns(b[pe], this.id_);
      }, F.prototype.delete = function(b) {
        return y(b) && r.owns(b, pe) && r.owns(b[pe], this.id_) ? delete b[pe][this.id_] : !1;
      }, F;
    }, "es6", "es3"), r.MapEntry = function() {
    }, r.polyfill("Map", function(a) {
      function u() {
        if (r.ASSUME_NO_NATIVE_MAP || !a || typeof a != "function" || !a.prototype.entries || typeof Object.seal != "function")
          return !1;
        try {
          var F = Object.seal({ x: 4 }), b = new a(r.makeIterator([[F, "s"]]));
          if (b.get(F) != "s" || b.size != 1 || b.get({ x: 4 }) || b.set({ x: 4 }, "t") != b || b.size != 2)
            return !1;
          var k = b.entries(), z = k.next();
          return z.done || z.value[0] != F || z.value[1] != "s" ? !1 : (z = k.next(), !(z.done || z.value[0].x != 4 || z.value[1] != "t" || !k.next().done));
        } catch (nt) {
          return !1;
        }
      }
      if (r.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS) {
        if (a && r.ES6_CONFORMANCE)
          return a;
      } else if (u())
        return a;
      var g = /* @__PURE__ */ new WeakMap(), y = function(F) {
        if (this.data_ = {}, this.head_ = pe(), this.size = 0, F) {
          F = r.makeIterator(F);
          for (var b; !(b = F.next()).done; )
            b = b.value, this.set(b[0], b[1]);
        }
      };
      y.prototype.set = function(F, b) {
        F = F === 0 ? 0 : F;
        var k = _(this, F);
        return k.list || (k.list = this.data_[k.id] = []), k.entry ? k.entry.value = b : (k.entry = { next: this.head_, previous: this.head_.previous, head: this.head_, key: F, value: b }, k.list.push(k.entry), this.head_.previous.next = k.entry, this.head_.previous = k.entry, this.size++), this;
      }, y.prototype.delete = function(F) {
        return F = _(this, F), F.entry && F.list ? (F.list.splice(F.index, 1), F.list.length || delete this.data_[F.id], F.entry.previous.next = F.entry.next, F.entry.next.previous = F.entry.previous, F.entry.head = null, this.size--, !0) : !1;
      }, y.prototype.clear = function() {
        this.data_ = {}, this.head_ = this.head_.previous = pe(), this.size = 0;
      }, y.prototype.has = function(F) {
        return !!_(this, F).entry;
      }, y.prototype.get = function(F) {
        return (F = _(this, F).entry) && F.value;
      }, y.prototype.entries = function() {
        return ce(this, function(F) {
          return [F.key, F.value];
        });
      }, y.prototype.keys = function() {
        return ce(this, function(F) {
          return F.key;
        });
      }, y.prototype.values = function() {
        return ce(this, function(F) {
          return F.value;
        });
      }, y.prototype.forEach = function(F, b) {
        for (var k = this.entries(), z; !(z = k.next()).done; )
          z = z.value, F.call(b, z[1], z[0], this);
      }, y.prototype[Symbol.iterator] = y.prototype.entries;
      var _ = function(F, b) {
        var k = b && typeof b;
        k == "object" || k == "function" ? g.has(b) ? k = g.get(b) : (k = "" + ++ht, g.set(b, k)) : k = "p_" + b;
        var z = F.data_[k];
        if (z && r.owns(F.data_, k))
          for (F = 0; F < z.length; F++) {
            var nt = z[F];
            if (b !== b && nt.key !== nt.key || b === nt.key)
              return { id: k, list: z, index: F, entry: nt };
          }
        return { id: k, list: z, index: -1, entry: void 0 };
      }, ce = function(F, b) {
        var k = F.head_;
        return r.iteratorPrototype(function() {
          if (k) {
            for (; k.head != F.head_; )
              k = k.previous;
            for (; k.next != k.head; )
              return k = k.next, { done: !1, value: b(k) };
            k = null;
          }
          return { done: !0, value: void 0 };
        });
      }, pe = function() {
        var F = {};
        return F.previous = F.next = F.head = F;
      }, ht = 0;
      return y;
    }, "es6", "es3");
    var s = "omid_message_guid", l = "omid_message_method", h = "omid_message_version", m = "omid_message_args", E = function(a, u, g, y) {
      this.guid = a, this.method = u, this.version = g, this.args = y;
    };
    E.isValidSerializedMessage = function(a) {
      return !!a && a[s] !== void 0 && a[l] !== void 0 && a[h] !== void 0 && typeof a[s] == "string" && typeof a[l] == "string" && typeof a[h] == "string" && (a[m] === void 0 || a[m] !== void 0);
    }, E.deserialize = function(a) {
      return new E(a[s], a[l], a[h], a[m]);
    }, E.prototype.serialize = function() {
      var a = {};
      return a = (a[s] = this.guid, a[l] = this.method, a[h] = this.version, a), this.args !== void 0 && (a[m] = this.args), a;
    };
    var S = { AdEventType: { SESSION_START: "sessionStart", SESSION_FINISH: "sessionFinish" }, MediaEventType: { LOADED: "loaded", START: "start", FIRST_QUARTILE: "firstQuartile", MIDPOINT: "midpoint", THIRD_QUARTILE: "thirdQuartile", COMPLETE: "complete", PAUSE: "pause", RESUME: "resume", BUFFER_START: "bufferStart", BUFFER_FINISH: "bufferFinish", SKIPPED: "skipped", VOLUME_CHANGE: "volumeChange", PLAYER_STATE_CHANGE: "playerStateChange", AD_USER_INTERACTION: "adUserInteraction" }, ImpressionType: { DEFINED_BY_JAVASCRIPT: "definedByJavaScript" }, ErrorType: { GENERIC: "generic" }, AccessMode: { FULL: "full" }, Environment: { APP: "app", WEB: "web" }, CreativeType: { DEFINED_BY_JAVASCRIPT: "definedByJavaScript" }, CommunicationType: { NONE: "NONE", DIRECT: "DIRECT", POST_MESSAGE: "POST_MESSAGE" }, MessageMethod: { IDENTIFY_SERVICE_WINDOW: "identifyServiceWindow" } }, M = function(a) {
      this.to = a, this.communicationType_ = S.CommunicationType.NONE;
    };
    M.prototype.sendMessage = function(a, u) {
    }, M.prototype.handleMessage = function(a, u) {
      this.onMessage && this.onMessage(a, u);
    }, M.prototype.serialize = function(a) {
      return JSON.stringify(a);
    }, M.prototype.deserialize = function(a) {
      return JSON.parse(a);
    }, M.prototype.isDirectCommunication = function() {
      return this.communicationType_ === S.CommunicationType.DIRECT;
    }, M.prototype.isCrossOrigin = function() {
    };
    function Q(a, u) {
      if (!u)
        throw Error("Value for " + a + " is undefined, null or blank.");
      if (typeof u != "string" && !(u instanceof String))
        throw Error("Value for " + a + " is not a string.");
      if (u.trim() === "")
        throw Error("Value for " + a + " is empty string.");
    }
    function Z(a, u) {
      if (u == null)
        throw Error("Value for " + a + " is undefined or null");
    }
    function se(a, u) {
      if (u == null)
        throw Error(a + " must not be null or undefined.");
      if (typeof u != "number" || isNaN(u))
        throw Error("Value for " + a + " is not a number");
    }
    function me(a, u, g, y) {
      if (se(a, u), u < g || u > y)
        throw Error("Value for " + a + " is outside the range [" + g + "," + y + "]");
    }
    function W() {
      return typeof i == "undefined" ? null : i;
    }
    function N(a, u) {
      return a && (a[u] || (a[u] = {}));
    }
    function O(a, u, g) {
      (g = g === void 0 ? W() : g) && (a = a.split("."), a.slice(0, a.length - 1).reduce(N, g)[a[a.length - 1]] = u);
    }
    var L = function(a, u) {
      Q("Partner.name", a), Q("Partner.version", u), this.name = a, this.version = u;
    };
    O("OmidSessionClient.Partner", L);
    var X = function(a, u, g, y) {
      y = y === void 0 ? S.AccessMode.FULL : y, Q("VerificationScriptResource.resourceUrl", a), this.resourceUrl = a, this.vendorKey = u, this.verificationParameters = g, this.accessMode = y;
    };
    X.prototype.toJSON = function() {
      return { accessMode: this.accessMode, resourceUrl: this.resourceUrl, vendorKey: this.vendorKey, verificationParameters: this.verificationParameters };
    }, O("OmidSessionClient.VerificationScriptResource", X);
    var Y = function(a, u) {
      Q("UniversalAdId.value", a), Q("UniversalAdId.idRegistry", u), this.value = a, this.idRegistry = u;
    };
    Y.prototype.toSerialisedValue = function() {
      return this.value + "; " + this.idRegistry;
    }, O("OmidSessionClient.UniversalAdId", Y);
    var K = function(a, u, g, y, _) {
      g = g === void 0 ? null : g, y = y === void 0 ? null : y, _ = _ === void 0 ? null : _, Z("Context.partner", a), this.partner = a, this.verificationScriptResources = u, this.videoElement = this.slotElement = null, this.contentUrl = g, this.customReferenceData = y, this.underEvaluation = !1, this.serviceWindow = null, this.universalAdId = _;
    };
    K.prototype.setVideoElement = function(a) {
      Z("Context.videoElement", a), this.videoElement = a;
    }, K.prototype.setSlotElement = function(a) {
      Z("Context.slotElement", a), this.slotElement = a;
    }, K.prototype.setServiceWindow = function(a) {
      Z("Context.serviceWindow", a), this.serviceWindow = a;
    }, O("OmidSessionClient.Context", K);
    var U = {};
    function D() {
      if (typeof e != "undefined" && e)
        return e;
      if (typeof ft != "undefined" && ft)
        return ft;
      if (typeof window != "undefined" && window)
        return window;
      if (typeof globalThis != "undefined" && globalThis)
        return globalThis;
      var a = Function("return this")();
      if (a)
        return a;
      throw Error("Could not determine global object context.");
    }
    U.omidGlobal = D();
    var T = { ROOT: "omidSessionInterface", AD_EVENTS: "adEvents", MEDIA_EVENTS: "mediaEvents" }, P = { sessionError: "reportError" }, j = Object.keys(S.MediaEventType).map(function(a) {
      return S.MediaEventType[a];
    }), J = ["impressionOccurred"], Te = function(a) {
      a = a === void 0 ? U.omidGlobal : a, this.interfaceRoot_ = a[T.ROOT];
    };
    Te.prototype.isSupported = function() {
      return this.interfaceRoot_ != null;
    }, Te.prototype.sendMessage = function(a, u, g) {
      if (a == "registerSessionObserver" && (g = [u]), P[a] && (a = P[a]), u = this.interfaceRoot_, 0 <= J.indexOf(a) && (u = u[T.AD_EVENTS]), 0 <= j.indexOf(a) && (u = u[T.MEDIA_EVENTS]), u = u[a], !u)
        throw Error("Unrecognized method name: " + a + ".");
      u.apply(null, r.arrayFromIterable(g));
    };
    function Re() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(a) {
        var u = 16 * Math.random() | 0;
        return a = a === "y" ? (u & 3 | 8).toString(16) : u.toString(16), a;
      });
    }
    function at() {
      var a = r.getRestArguments.apply(0, arguments);
      Dt(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(r.arrayFromIterable(a))))();
      }, function() {
        return console.error.apply(console, r.arrayFromIterable(a));
      });
    }
    function Dt(a, u) {
      typeof jasmine != "undefined" && jasmine ? a() : typeof console != "undefined" && console && console.error && u();
    }
    var $e = { Version: "1.5.6-iab144" }, it = 3;
    function Fe(a) {
      return /\d+\.\d+\.\d+(-.*)?/.test(a);
    }
    function vt(a, u) {
      a = a.split("-")[0].split("."), u = u.split("-")[0].split(".");
      for (var g = 0; g < it; g++) {
        var y = parseInt(a[g], 10), _ = parseInt(u[g], 10);
        if (y > _)
          break;
        if (y < _)
          return !1;
      }
      return !0;
    }
    var Ge = "1.0.3";
    function lt(a, u) {
      return Fe(a) && vt(a, Ge) ? u : JSON.stringify(u);
    }
    function rt(a, u) {
      return Fe(a) && vt(a, Ge) ? u || [] : u && typeof u == "string" ? JSON.parse(u) : [];
    }
    var Ue = { SESSION_SERVICE: "SessionService." };
    function Lt(a) {
      return Ee(a, Ue.SESSION_SERVICE);
    }
    function Ee(a, u) {
      return u + a;
    }
    function dt(a) {
      return a != null && typeof a.top != "undefined" && a.top != null;
    }
    function Pe(a) {
      if (a === U.omidGlobal)
        return !1;
      try {
        if (typeof a.location.hostname == "undefined")
          return !0;
        Se(a);
      } catch (u) {
        return !0;
      }
      return !1;
    }
    function Se(a) {
      return a.x === "" || a.x !== "";
    }
    function Ne(a) {
      return typeof a == "undefined" && typeof window != "undefined" && window && (a = window), dt(a) ? a : U.omidGlobal;
    }
    function je(a) {
      return dt(a) ? a.top : U.omidGlobal;
    }
    var V = function(a) {
      M.call(this, a), this.communicationType_ = S.CommunicationType.DIRECT, this.handleExportedMessage = V.prototype.handleExportedMessage.bind(this);
    };
    r.inherits(V, M), V.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.handleExportedMessage(a.serialize(), this);
    }, V.prototype.handleExportedMessage = function(a, u) {
      E.isValidSerializedMessage(a) && this.handleMessage(E.deserialize(a), u);
    }, V.prototype.isCrossOrigin = function() {
      return !1;
    };
    var B = function(a, u) {
      u = u === void 0 ? U.omidGlobal : u, M.call(this, u);
      var g = this;
      this.communicationType_ = S.CommunicationType.POST_MESSAGE, a.addEventListener("message", function(y) {
        if (typeof y.data == "object") {
          var _ = y.data;
          E.isValidSerializedMessage(_) && (_ = E.deserialize(_), y.source && g.handleMessage(_, y.source));
        }
      });
    };
    r.inherits(B, M), B.isCompatibleContext = function(a) {
      return !!(a && a.addEventListener && a.postMessage);
    }, B.prototype.sendMessage = function(a, u) {
      if (u = u === void 0 ? this.to : u, !u)
        throw Error("Message destination must be defined at construction time or when sending the message.");
      u.postMessage(a.serialize(), "*");
    }, B.prototype.isCrossOrigin = function() {
      return this.to ? Pe(this.to) : !0;
    };
    var H = { OMID_PRESENT_FRAME_NAME: "omid_v1_present", OMID_PRESENT_FRAME_NAME_WEB: "omid_v1_present_web", OMID_PRESENT_FRAME_NAME_APP: "omid_v1_present_app", getEnvironmentIframeName: function(a) {
      var u = {};
      return (u[S.Environment.APP] = H.OMID_PRESENT_FRAME_NAME_APP, u[S.Environment.WEB] = H.OMID_PRESENT_FRAME_NAME_WEB, u)[a];
    } };
    function he(a, u) {
      try {
        return a.frames && !!a.frames[u];
      } catch (g) {
        return !1;
      }
    }
    H.isOmidPresent = function(a) {
      return [H.OMID_PRESENT_FRAME_NAME, H.OMID_PRESENT_FRAME_NAME_WEB, H.OMID_PRESENT_FRAME_NAME_APP].some(function(u) {
        return he(a, u);
      });
    }, H.getOmidEnvironment = function(a) {
      for (var u = r.makeIterator(Object.values(S.Environment)), g = u.next(); !g.done; g = u.next()) {
        g = g.value;
        var y = H.getEnvironmentIframeName(g);
        if (he(a, y))
          return g;
      }
      return null;
    };
    function ie(a, u) {
      a.document.write('<iframe style="display:none" id="' + (u + '" name="' + u + '" sandbox></iframe>'));
    }
    H.declareOmidPresence = function(a, u) {
      a.frames && a.document && ![H.OMID_PRESENT_FRAME_NAME, H.OMID_PRESENT_FRAME_NAME_WEB, H.OMID_PRESENT_FRAME_NAME_APP].some(function(g) {
        return !!a.frames[g];
      }) && (a.document.body == null && H.isMutationObserverAvailable_(a) ? H.registerMutationObserver_(a, u) : (u = H.getEnvironmentIframeName(u), a.document.body ? (H.appendPresenceIframe_(a, H.OMID_PRESENT_FRAME_NAME), H.appendPresenceIframe_(a, u)) : (ie(
        a,
        H.OMID_PRESENT_FRAME_NAME
      ), ie(a, u))));
    }, H.appendPresenceIframe_ = function(a, u) {
      var g = a.document.createElement("iframe");
      g.id = u, g.name = u, g.style.display = "none", g.sandbox = "", a.document.body.appendChild(g);
    }, H.isMutationObserverAvailable_ = function(a) {
      return "MutationObserver" in a;
    }, H.registerMutationObserver_ = function(a, u) {
      var g = new MutationObserver(function(y) {
        y.forEach(function(_) {
          _.addedNodes[0].nodeName === "BODY" && (_ = H.getEnvironmentIframeName(u), H.appendPresenceIframe_(a, H.OMID_PRESENT_FRAME_NAME), H.appendPresenceIframe_(a, _), g.disconnect());
        });
      });
      g.observe(a.document.documentElement, { childList: !0 });
    };
    var ut = ["omid", "v1_SessionServiceCommunication"];
    function St(a, u) {
      return u.reduce(function(g, y) {
        return g && g[y];
      }, a);
    }
    function si(a, u, g, y) {
      if (!Pe(u))
        try {
          var _ = St(u, g);
          if (_)
            return new V(_);
        } catch (ce) {
        }
      return y(u) ? new B(a, u) : null;
    }
    function Be(a, u, g, y) {
      u = r.makeIterator(u);
      for (var _ = u.next(); !_.done; _ = u.next())
        if (_ = si(a, _.value, g, y))
          return _;
      return null;
    }
    function oi(a, u, g) {
      g = g === void 0 ? H.isOmidPresent : g;
      var y = [a, je(a)];
      return u && y.unshift(u), Be(a, y, ut, g);
    }
    var ee = function(a, u, g) {
      Z("AdSession.context", a), this.adSessionId_ = Re(), this.context_ = a, this.impressionOccurred_ = !1;
      var y = this.context_.serviceWindow || void 0;
      this.communication_ = u || oi(Ne(), y), this.sessionInterface_ = g || new Te(), this.isSessionRunning_ = this.hasMediaEvents_ = this.hasAdEvents_ = !1, this.impressionType_ = this.creativeType_ = null, this.creativeLoaded_ = !1, this.callbackMap_ = {}, this.communication_ && (this.communication_.onMessage = this.handleInternalMessage_.bind(this)), this.setClientInfo_(), this.injectVerificationScripts_(a.verificationScriptResources), this.sendSlotElement_(a.slotElement), this.sendVideoElement_(a.videoElement), this.sendContentUrl_(a.contentUrl), this.watchSessionEvents_();
    };
    ee.prototype.getAdSessionId = function() {
      return this.adSessionId_;
    }, ee.prototype.setCreativeType = function(a) {
      if (a === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined with value " + S.CreativeType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.creativeType_ && this.creativeType_ !== S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type cannot be redefined");
      if (this.creativeType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setCreativeType", a, this.adSessionId_), this.creativeType_ = a;
    }, ee.prototype.setImpressionType = function(a) {
      if (a === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined with value " + S.ImpressionType.DEFINED_BY_JAVASCRIPT);
      if (this.impressionOccurred_)
        throw Error("Impression has already occurred");
      if (this.creativeLoaded_)
        throw Error("Creative has already loaded");
      if (this.impressionType_ && this.impressionType_ !== S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type cannot be redefined");
      if (this.impressionType_ === void 0)
        throw Error("Native integration is using OMID 1.2 or earlier");
      this.sendOneWayMessage("setImpressionType", a, this.adSessionId_), this.impressionType_ = a;
    }, ee.prototype.isSupported = function() {
      return !!this.communication_ || this.sessionInterface_.isSupported();
    }, ee.prototype.isSendingElementsSupported_ = function() {
      return this.communication_ ? this.communication_.isDirectCommunication() : this.sessionInterface_.isSupported();
    }, ee.prototype.registerSessionObserver = function(a) {
      this.sendMessage("registerSessionObserver", a, this.adSessionId_);
    }, ee.prototype.start = function() {
      var a = { customReferenceData: this.context_.customReferenceData, underEvaluation: this.context_.underEvaluation };
      this.context_.universalAdId && (a.universalAdId = this.context_.universalAdId.toSerialisedValue()), this.sendOneWayMessage("startSession", a, this.adSessionId_);
    }, ee.prototype.finish = function() {
      this.sendOneWayMessage("finishSession", this.adSessionId_);
    }, ee.prototype.error = function(a, u) {
      this.sendOneWayMessage("sessionError", a, u, this.adSessionId_);
    }, ee.prototype.registerAdEvents = function() {
      if (this.hasAdEvents_)
        throw Error("AdEvents already registered.");
      this.hasAdEvents_ = !0, this.sendOneWayMessage("registerAdEvents", this.adSessionId_);
    }, ee.prototype.registerMediaEvents = function() {
      if (this.hasMediaEvents_)
        throw Error("MediaEvents already registered.");
      this.hasMediaEvents_ = !0, this.sendOneWayMessage("registerMediaEvents", this.adSessionId_);
    }, ee.prototype.sendOneWayMessage = function(a) {
      var u = r.getRestArguments.apply(1, arguments);
      this.sendMessage.apply(this, [a, null].concat(r.arrayFromIterable(u)));
    }, ee.prototype.sendMessage = function(a, u) {
      var g = r.getRestArguments.apply(2, arguments);
      this.communication_ ? this.sendInternalMessage_(a, u, g) : this.sessionInterface_.isSupported() && this.sendInterfaceMessage_(a, u, g);
    }, ee.prototype.sendInternalMessage_ = function(a, u, g) {
      var y = Re();
      u && (this.callbackMap_[y] = u), a = new E(y, Lt(a), $e.Version, lt($e.Version, g)), this.communication_.sendMessage(a);
    }, ee.prototype.handleInternalMessage_ = function(a, u) {
      u = a.method;
      var g = a.guid;
      if (a = a.args, u === "response" && this.callbackMap_[g]) {
        var y = rt($e.Version, a);
        this.callbackMap_[g].apply(this, y);
      }
      u === "error" && window.console && at(a);
    }, ee.prototype.sendInterfaceMessage_ = function(a, u, g) {
      try {
        this.sessionInterface_.sendMessage(a, u, g);
      } catch (y) {
        at("Failed to communicate with SessionInterface with error:"), at(y);
      }
    }, ee.prototype.assertSessionRunning = function() {
      if (!this.isSessionRunning_)
        throw Error("Session not started.");
    }, ee.prototype.impressionOccurred = function() {
      if (this.creativeType_ === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.impressionOccurred_ = !0;
    }, ee.prototype.creativeLoaded = function() {
      if (this.creativeType_ === S.CreativeType.DEFINED_BY_JAVASCRIPT)
        throw Error("Creative type has not been redefined");
      if (this.impressionType_ === S.ImpressionType.DEFINED_BY_JAVASCRIPT)
        throw Error("Impression type has not been redefined");
      this.creativeLoaded_ = !0;
    }, ee.prototype.setClientInfo_ = function() {
      this.sendOneWayMessage("setClientInfo", $e.Version, this.context_.partner.name, this.context_.partner.version, this.adSessionId_);
    }, ee.prototype.injectVerificationScripts_ = function(a) {
      a && (a = a.map(function(u) {
        return u.toJSON();
      }), this.sendOneWayMessage("injectVerificationScriptResources", a, this.adSessionId_));
    }, ee.prototype.sendSlotElement_ = function(a) {
      this.sendElement_(a, "setSlotElement");
    }, ee.prototype.sendVideoElement_ = function(a) {
      this.sendElement_(a, "setVideoElement");
    }, ee.prototype.sendElement_ = function(a, u) {
      a && (this.isSendingElementsSupported_() ? this.sendOneWayMessage(u, a, this.adSessionId_) : this.error(S.ErrorType.GENERIC, "Session Client " + u + " called when communication is cross-origin"));
    }, ee.prototype.sendContentUrl_ = function(a) {
      a && this.sendOneWayMessage("setContentUrl", a, this.adSessionId_);
    }, ee.prototype.setElementBounds = function(a) {
      Z("AdSession.elementBounds", a), this.sendOneWayMessage("setElementBounds", a, this.adSessionId_);
    }, ee.prototype.watchSessionEvents_ = function() {
      var a = this;
      this.registerSessionObserver(function(u) {
        u.type === S.AdEventType.SESSION_START && (a.isSessionRunning_ = !0, a.creativeType_ = u.data.creativeType, a.impressionType_ = u.data.impressionType), u.type === S.AdEventType.SESSION_FINISH && (a.isSessionRunning_ = !1);
      });
    }, O("OmidSessionClient.AdSession", ee);
    var Ht = function(a, u, g, y) {
      this.isSkippable = a, this.skipOffset = u, this.isAutoPlay = g, this.position = y;
    };
    Ht.prototype.toJSON = function() {
      return { isSkippable: this.isSkippable, skipOffset: this.skipOffset, isAutoPlay: this.isAutoPlay, position: this.position };
    };
    var $t = function(a) {
      Z("AdEvents.adSession", a), this.adSessionId_ = a.getAdSessionId();
      try {
        a.registerAdEvents(), this.adSession = a;
      } catch (u) {
        throw Error("AdSession already has an ad events instance registered");
      }
    };
    $t.prototype.impressionOccurred = function() {
      this.adSession.assertSessionRunning(), this.adSession.impressionOccurred(), this.adSession.sendOneWayMessage("impressionOccurred", this.adSessionId_);
    }, $t.prototype.loaded = function(a) {
      a = a === void 0 ? null : a, this.adSession.creativeLoaded(), a = a ? a.toJSON() : null, this.adSession.sendOneWayMessage("loaded", a, this.adSessionId_);
    }, O("OmidSessionClient.AdEvents", $t);
    var ge = function(a) {
      Z("MediaEvents.adSession", a), this.adSessionId_ = a.getAdSessionId();
      try {
        a.registerMediaEvents(), this.adSession = a;
      } catch (u) {
        throw Error("AdSession already has a media events instance registered");
      }
    };
    ge.prototype.start = function(a, u) {
      se("MediaEvents.start.duration", a), me("MediaEvents.start.mediaPlayerVolume", u, 0, 1), this.adSession.sendOneWayMessage("start", a, u, this.adSessionId_);
    }, ge.prototype.firstQuartile = function() {
      this.adSession.sendOneWayMessage("firstQuartile", this.adSessionId_);
    }, ge.prototype.midpoint = function() {
      this.adSession.sendOneWayMessage("midpoint", this.adSessionId_);
    }, ge.prototype.thirdQuartile = function() {
      this.adSession.sendOneWayMessage("thirdQuartile", this.adSessionId_);
    }, ge.prototype.complete = function() {
      this.adSession.sendOneWayMessage("complete", this.adSessionId_);
    }, ge.prototype.pause = function() {
      this.adSession.sendOneWayMessage("pause", this.adSessionId_);
    }, ge.prototype.resume = function() {
      this.adSession.sendOneWayMessage("resume", this.adSessionId_);
    }, ge.prototype.bufferStart = function() {
      this.adSession.sendOneWayMessage("bufferStart", this.adSessionId_);
    }, ge.prototype.bufferFinish = function() {
      this.adSession.sendOneWayMessage("bufferFinish", this.adSessionId_);
    }, ge.prototype.skipped = function() {
      this.adSession.sendOneWayMessage("skipped", this.adSessionId_);
    }, ge.prototype.volumeChange = function(a) {
      me("MediaEvents.volumeChange.mediaPlayerVolume", a, 0, 1), this.adSession.sendOneWayMessage("volumeChange", a, this.adSessionId_);
    }, ge.prototype.playerStateChange = function(a) {
      Z("MediaEvents.playerStateChange.playerState", a), this.adSession.sendOneWayMessage("playerStateChange", a, this.adSessionId_);
    }, ge.prototype.adUserInteraction = function(a) {
      Z("MediaEvents.adUserInteraction.interactionType", a), this.adSession.sendOneWayMessage("adUserInteraction", a, this.adSessionId_);
    }, O("OmidSessionClient.MediaEvents", ge);
    var ai = function(a, u) {
      Q("OmidVersion.semanticVersion", a), Q("OmidVersion.apiLevel", u);
    };
    O("OmidSessionClient.OmidVersion", ai);
    function li(a) {
      var u = Ne();
      new B(u).onMessage = function(g, y) {
        g.method === S.MessageMethod.IDENTIFY_SERVICE_WINDOW && a(y);
      };
    }
    O("OmidSessionClient.listenForServiceWindow", li), O("OmidSessionClient.VastProperties", Ht);
    var we = { VerificationVendorId: { OTHER: 1, MOAT: 2, DOUBLEVERIFY: 3, INTEGRAL_AD_SCIENCE: 4, PIXELATE: 5, NIELSEN: 6, COMSCORE: 7, MEETRICS: 8, GOOGLE: 9, HUMAN: 10 } };
    function di(a) {
      for (var u = r.makeIterator(Mt.keys()), g = u.next(); !g.done; g = u.next()) {
        g = g.value;
        for (var y = r.makeIterator(Mt.get(g)), _ = y.next(); !_.done; _ = y.next())
          if (_.value.test(a))
            return g;
      }
      return we.VerificationVendorId.OTHER;
    }
    var Mt = /* @__PURE__ */ new Map([[we.VerificationVendorId.DOUBLEVERIFY, [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.doubleverify\.com\/.*$/, /^(https?:\/\/|\/\/)?c\.[\w\-]+\.com\/vfw\/dv\/.*$/, /^(https?:\/\/|\/\/)?(www\.)?[\w]+\.tv\/r\/s\/d\/.*$/, /^(https?:\/\/|\/\/)?(\w\.?)+\.dv\.tech\/.*$/]], [we.VerificationVendorId.INTEGRAL_AD_SCIENCE, [
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.adsafeprotected\.com\/.*$/
    ]], [we.VerificationVendorId.PIXELATE, [/^https?:\/\/(q|cdn)\.adrta\.com\/s\/.*\/(aa|aanf)\.js.*$/, /^https:\/\/cdn\.rta247\.com\/s\/.*\/(aa|aanf)\.js.*$/]], [we.VerificationVendorId.NIELSEN, []], [we.VerificationVendorId.COMSCORE, [
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.voicefive\.com\/.*$/,
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.measuread\.com\/.*$/,
      /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.scorecardresearch\.com\/.*$/
    ]], [we.VerificationVendorId.MEETRICS, [/^(https?:\/\/|\/\/)?s418\.mxcdn\.net\/bb-serve\/omid-meetrics.*\.js$/]], [we.VerificationVendorId.GOOGLE, [/^(https?:\/\/|\/\/)?pagead2\.googlesyndication\.com\/.*$/, /^(https?:\/\/|\/\/)?www\.googletagservices\.com\/.*$/]], [
      we.VerificationVendorId.HUMAN,
      [/^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\.script\.ac\/.*$/, /^(https?:\/\/|\/\/)?[-a-zA-Z0-9.]+\/(2|ag|static)\/[a-zA-Z0-9.]*\/analytics.js.*$/]
    ]]);
    O("OmidSessionClient.verificationVendorIdForScriptUrl", di), O("OmidSessionClient.VerificationVendorId", we.VerificationVendorId), we.verificationVendorIdForScriptUrl = di;
  }, A);
})(Hn);
const po = /* @__PURE__ */ co(Hn), Ci = {
  ERROR_RESOURCE_REJECTED: 1,
  // or OM disabled by publisher
  ERROR_VERIFICATION_NOT_SUPPORTED: 2
}, re = class re {
  // TODO: Possible to make a currentAdRuntime interface?
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(e, i) {
    if (this.ad = e, this.adSlotDelivery = i, this.sessionClient = po.OmidSessionClient, this.removeEventHandlers = [], this.video = i.player.getPlayerElement(), !this.sessionClient) {
      c.debug.warn(re.NAME + "const. - no sessionClient available!");
      return;
    }
    if (this.CONTENT_URL = i.player.getCurrentContentSource(), this.OMSDK_SERVICE_WINDOW = e.config.adVerification.serviceWindow, this.internalOmidConfig = e.config.adVerification, this.verifications = this.filterVerifications(
      e.adVerifications,
      this.internalOmidConfig.vendorWhitelist
    ), !this.verifications || this.verifications.length === 0) {
      c.debug.info(
        re.NAME + "verification(s) found after application of the allow-list is/are 0"
      );
      return;
    }
    if (c.debug.info(
      re.NAME,
      this.verifications.length,
      "verification(s) found after initial"
    ), c.debug.table(this.verifications), this.internalOmidConfig.disabled) {
      c.debug.warn(
        re.NAME + "adVerification - disabled by publisher (config.adVerification.disabled)."
      ), this.verifications.forEach((r) => {
        this.trackError(
          r.tracking.verificationNotExecuted,
          Ci.ERROR_RESOURCE_REJECTED
        );
      });
      return;
    }
    if (this.internalOmidConfig.playerHandles) {
      c.debug.info(re.NAME + "playerHandles is true");
      return;
    }
    if (e.isVPAID && !e.config.shareVideoElementWithVPAID) {
      c.debug.info(
        re.NAME + " VPAID ad with shareVideoElementWithVPAID set to false is not supported!"
      );
      return;
    }
    this.initOMIDJS() && this.addEventListeners();
  }
  createVastProperties() {
    return new this.sessionClient.VastProperties(
      this.ad.skipOffset > -1,
      // skippable
      this.ad.skipOffset,
      !0,
      // autoplay
      re.POSITION_MAP[this.ad.adBreakPosition]
    );
  }
  /**
   * Filters ad verifications based on the vendor whitelist.
   *
   * @param {Array} adVerifications - An array of ad verifications to be filtered.
   * @param {Array} vendorAllowList - An array of allowed vendors.
   * @return {Array} The filtered ad verifications.
   */
  /** @internal */
  filterVerifications(e, i) {
    return !e || e.length === 0 ? e : e.filter((r) => {
      const s = !i || i.length === 0 || i.includes(r.vendor);
      if (!s)
        return this.trackError(r.tracking.verificationNotExecuted, Ci.ERROR_RESOURCE_REJECTED), !1;
      if (i)
        return !0;
      const l = r.javascriptResource ? r.javascriptResource.apiFramework.toLowerCase() === "omid" : !1;
      return !i && !l ? (s && this.trackError(
        r.tracking.verificationNotExecuted,
        Ci.ERROR_VERIFICATION_NOT_SUPPORTED
      ), !1) : !0;
    });
  }
  /** @internal */
  initOMIDJS() {
    if (this.adSession = this.createAdSession(), this.adSession.impressionType_ || this.adSession.setImpressionType(this.ad.config.trackImpressionOnStart ? re.IMPRESSION_TYPE.RENDER : re.IMPRESSION_TYPE.LOADED), this.adSession.creativeType_ || this.adSession.setCreativeType(this.ad.adType), c.debug.info(re.NAME + "initOMIDJS", this.adSession), !this.adSession.isSupported())
      return c.debug.error(re.NAME + "isSupported - session not supported, call all error trackers and tear down"), this.verifications.map((i) => {
        this.trackError(
          i.tracking.verificationNotExecuted,
          Ci.ERROR_VERIFICATION_NOT_SUPPORTED
        );
      }), !1;
    this.adEvents = new this.sessionClient.AdEvents(this.adSession);
    const e = () => {
      const i = this.createVastProperties();
      this.adEvents.loaded(i), this.video.removeEventListener("canplaythrough", e);
    };
    return this.video.addEventListener("canplaythrough", e), this.mediaEvents = new this.sessionClient.MediaEvents(this.adSession), this.adSession.start(), !0;
  }
  /** @internal */
  createAdSession() {
    let e = new this.sessionClient.Partner(re.PARTNER_NAME, re.PARTNER_VERSION), i = this.verifications.map((s) => (c.debug.info(
      re.NAME + "VerificationScriptResource",
      "omidScriptURL:",
      Mi(s.javascriptResource.url, s.javascriptResource.url),
      "vendor:",
      s.vendor,
      "verification params:",
      s.verificationParameters,
      "accessMode:",
      this.internalOmidConfig.accessMode
    ), new this.sessionClient.VerificationScriptResource(
      Mi(s.javascriptResource.url, s.javascriptResource.url),
      s.vendor,
      s.verificationParameters,
      this.internalOmidConfig.accessMode
    ))), r = new this.sessionClient.Context(e, i, this.CONTENT_URL);
    return r.underEvaluation = !0, r.setVideoElement(this.video), r.setServiceWindow(this.OMSDK_SERVICE_WINDOW), r.supportsLoadedEvent = !0, new this.sessionClient.AdSession(r);
  }
  addEventListeners() {
    this.removeEventListeners(), Object.keys(p).forEach((e) => {
      let i = this.adSlotDelivery.adSlotController.addEventListener(
        p[e],
        this.handleAdEvent.bind(this)
      );
      this.removeEventHandlers.push(i);
    });
  }
  /** @internal */
  removeEventListeners() {
    this.removeEventHandlers.forEach((e) => {
      e();
    }), this.removeEventHandlers = [];
  }
  /** @internal */
  handleAdEvent(e) {
    switch (this.forwardEventToOMSDK(e.type), e.type) {
      case p.ON_AD_ERROR:
        this.adSession.error("generic", this.ad.error.code), this.removeEventListeners(), c.debug.info(re.NAME + "handleAdEvent AdError -- call adSession.error"), setTimeout(() => {
          this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
      case p.ON_AD_SKIPPED:
      case p.ON_AD_STOPPED:
        this.removeEventListeners(), setTimeout(() => {
          c.debug.info(re.NAME + "handleAdEvent " + e.type + " -- call adSession.finish"), this.adSession.finish();
        }, this.ad.config.adVerification.sessionCleanupDelay * 1e3);
        break;
    }
  }
  /** @internal */
  forwardEventToOMSDK(e) {
    let i = "forwardEventToOMSDK";
    if (c.debug.info(re.NAME + i, e), !this.adEvents) {
      c.debug.warn(re.NAME + i + " - adEvents not set, happens when adSession is not supported");
      return;
    }
    let r;
    switch (e) {
      case p.ON_AD_STARTED:
        r = this.createVastProperties(), this.adEvents.start(r);
        break;
      case p.ON_AD_PLAYBACK_START:
        this.mediaEvents.start(
          this.ad.duration,
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case p.ON_AD_IMPRESSION:
        this.adEvents.impressionOccurred();
        break;
      // general video progression events
      case p.ON_AD_FIRST_QUARTILE:
        this.mediaEvents.firstQuartile();
        break;
      case p.ON_AD_MID_POINT:
        this.mediaEvents.midpoint();
        break;
      case p.ON_AD_THIRD_QUARTILE:
        this.mediaEvents.thirdQuartile();
        break;
      case p.ON_AD_PLAYBACK_FINISHED:
        this.mediaEvents.complete();
        break;
      // -- playback controls --
      case p.ON_AD_PAUSED:
        this.mediaEvents.pause();
        break;
      case p.ON_AD_PLAYING:
        this.mediaEvents.resume();
        break;
      case p.ON_AD_VOLUME_CHANGED:
        this.mediaEvents.volumeChange(
          this.ad.volume,
          // mediaPlayerVolume
          this.ad.volume,
          // videoPlayerVolume
          1
          // deviceVolume not detectable, assuming 1
        );
        break;
      case p.ON_AD_SKIPPED:
        this.mediaEvents.skipped();
        break;
      case p.ON_AD_CLICKED:
        this.mediaEvents.adUserInteraction("click");
        break;
      case p.ON_ENTER_FULLSCREEN:
        this.mediaEvents.playerStateChange("fullscreen");
        break;
      case p.ON_EXIT_FULLSCREEN:
        this.mediaEvents.playerStateChange("normal");
        break;
      case p.ON_PLAYER_EXPAND:
        this.mediaEvents.playerStateChange("expanded");
        break;
      case p.ON_PLAYER_COLLAPSE:
        this.mediaEvents.playerStateChange("collapsed");
        break;
    }
  }
  /** @internal */
  trackError(e, i) {
    c.debug.info(
      re.NAME + "trackError - errorReason",
      i,
      "errorTracker",
      e
    ), this.ad.enrichment.set("REASON", i, "reason");
    const r = {
      adReinsertion: this.ad.adReinsertion,
      enrichment: this.ad.enrichment,
      timeouts: this.ad.config.timeouts,
      urlhandler: this.ad.config.urlhandler
    };
    new ii().track(e, null, r);
  }
};
re.IMPRESSION_TYPE = {
  AUDIBLE: "audible",
  LOADED: "loaded",
  OTHER: "other",
  PIXEL: "onePixel",
  RENDER: "beginToRender",
  UNSPECIFIED: "unspecified",
  VIEWABLE: "viewable"
}, re.PARTNER_NAME = "Smartcliptv", re.PARTNER_VERSION = "7.5.6", re.POSITION_MAP = [
  "standalone",
  "preroll",
  "midroll",
  "postroll",
  "standalone"
  // equals breakPosition 'overlay' in VAST
], re.NAME = "OMID::";
let fr = re;
const At = class At extends gt {
  constructor(e, i) {
    super(), this.adSlotController = e.adSlotController, this.adSlotDelivery = e, this.publisherAdContainer = i, this.adContainer = null, this.ad = null, this.asset = null, this.adDisplayTime = {
      currentTime: 0,
      duration: 0,
      offset: 0
    }, this.cleanupTimer = [];
  }
  /**
   * @param {asset} asset VASTNonLinear - contains parameters and a list of VASTCreativeResources
   * @returns {Promise<void>} Resolves if the asset has been loaded and shown to the audience.
   */
  init(e) {
    return this.asset = e, this.adDisplayTime.duration = e.displayDuration, this.createAdContainer(), this.createNonLinearElement(), new Promise((i) => {
      this.render(), i();
    });
  }
  /** @internal */
  createAdContainer() {
    const e = "display:none; pointer-events:none; position:absolute; width:100%; height:100%; top:0; left:0;";
    this.adContainer = document.createElement("div"), this.adContainer.setAttribute("style", e);
  }
  /**
   * Defines the container that surrounds the advertiser's asset, depending on the resource type.
   * - the ad has to appear in the upper centered position
   * - the container holds tracking and interaction data
   * @internal
   * @returns {void}
   */
  /** @internal */
  createNonLinearElement() {
    let e = {
      attributes: {},
      style: {}
    };
    this.asset.scalable ? (e.style.width = "100%", e.style.height = "100%", e.style["object-fit"] = "contain", e.style["object-position"] = "bottom") : (e.style.width = parseInt(this.asset.width, 10) + "px", e.style.height = parseInt(this.asset.height, 10) + "px"), e.style.position = "absolute", e.style.bottom = "0", e.style.right = "50%", e.style.transform = "translateX(50%)", e.attributes.style = JSON.stringify(e.style), e.attributes.style = e.attributes.style.substring(1, JSON.stringify(e.style).length - 1), e.attributes.style = e.attributes.style.replace(/\"/ig, "").replace(/\,/ig, ";") + ";", e.attributes.src = this.asset.selectedResource.resource, this.ad = e;
  }
  /** @internal */
  render() {
    let e;
    switch (this.asset.selectedResource.type) {
      case "StaticResource":
        e = "img";
        break;
      default:
        e = "iframe";
        break;
    }
    let i = document.createElement(e);
    for (let r in this.ad.attributes)
      this.ad.attributes[r] && i.setAttribute(r, this.ad.attributes[r]);
    i.style.pointerEvents = "auto", i.onload = this.onStartAd.bind(this), e === "iframe" ? (i.style.border = "0", i.setAttribute("scrolling", "no"), i.setAttribute("margin", "0"), i.setAttribute("allowtransparency", "true")) : (i.style.cursor = "pointer", i.addEventListener("click", this.onClick.bind(this))), this.adContainer.appendChild(i), this.publisherAdContainer.appendChild(this.adContainer);
  }
  stop() {
    this.cleanupTimer.forEach((e) => {
      clearTimeout(e);
    }), this.adContainer && this.adContainer.parentNode === this.publisherAdContainer && this.publisherAdContainer.removeChild(this.adContainer);
  }
  pause() {
    c.debug.info(At.NAME + "pause"), this.cleanupTimer.forEach((e) => {
      clearTimeout(e);
    }), this.adDisplayTime.currentTime += (Date.now() - this.adDisplayTime.offset) / 1e3;
  }
  play() {
    c.debug.info(At.NAME + "play - start or resume"), this.adDisplayTime.offset = Date.now();
    const e = this.adDisplayTime.duration - this.adDisplayTime.currentTime;
    c.debug.info(At.NAME + "play - remove ad in", e, "seconds.");
    const i = setTimeout(this.onStopAd.bind(this), e * 1e3);
    this.cleanupTimer.push(i);
  }
  onStartAd() {
    c.debug.info(At.NAME + "onStartAd"), this.adContainer.style.display = "block", this.dispatchEvent(p.ON_AD_LOADED), this.dispatchEvent(p.ON_AD_STARTED), this.dispatchEvent(p.ON_AD_IMPRESSION), this.dispatchEvent(p.ON_AD_CREATIVE_VIEW), this.play();
  }
  onStopAd() {
    c.debug.info(At.NAME + "onStopAd"), this.dispatchEvent(p.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(p.ON_AD_STOPPED), this.stop();
  }
  onClick() {
    this.adSlotController.onClickThrough(this.asset);
  }
};
At.NAME = "NonLinear::";
let Ar = At;
const Ze = class Ze extends gt {
  // TODO: jsDoc, (BaseAd + extend)
  constructor(e, i, r) {
    super(), this.adSlotController = r, this.adSlotHasStarted = !1, this.currentAd = e, this.eventCallbacks = [], this.player = i;
  }
  getRemoveHandlerForAdSlotControllerEvent(e, i) {
    return this.adSlotController.addEventListener(e, i);
  }
  addPlayerEventListener(e, i) {
    this.player.addEventListener(e, i);
    const r = () => this.removePlayerEventListener(e, i);
    return this.eventCallbacks.push(r), () => this.player.removeEventListener(e, i);
  }
  removePlayerEventListener(e, i) {
    this.player.removeEventListener(e, i);
  }
  cleanAndDeliveryNextAd() {
    this.currentAd = null, this.deliverNextAd();
  }
  addVpaidListeners() {
    const e = () => {
      if (this.currentAd.isVPAID) {
        c.debug.info(
          Ze.NAME + "Wait for a finished event from the VPAID player.",
          this.currentAd
        );
        const r = () => {
          this.currentAd.replaced ? (i(), this.deliverNextAd()) : (S(), this.cleanAndDeliveryNextAd());
        }, s = () => {
          this.saveStartVolumeVPAID();
        }, l = () => {
          this.adSlotController.applyBuffetAd();
        }, h = this.getRemoveHandlerForAdSlotControllerEvent(
          p.ON_AD_STARTED,
          s
        ), m = this.getRemoveHandlerForAdSlotControllerEvent(
          p.ON_AD_ERROR,
          l
        ), E = this.getRemoveHandlerForAdSlotControllerEvent(
          p.ON_VPAID_CLEANUP,
          r
        ), S = () => {
          h(), m(), E();
        };
      }
    }, i = this.getRemoveHandlerForAdSlotControllerEvent(
      p.ON_AD_START,
      e
    );
  }
  controlPlayback(e) {
    this.currentAd && (this.currentAd.isVPAID ? e(this.adSlotController.vpaidPlayer) : this.currentAd.isLinear ? e(this.player) : e(this.adSlotController.nonLinearView));
  }
  deliverOrHOMAD(e, i) {
    this.currentAd.adReinsertion.isActive === !1 ? this.deliverNextAd() : this.activateHOMAD(e, i);
  }
  pause() {
    this.controlPlayback((e) => e.pause());
  }
  play() {
    this.controlPlayback((e) => e.play());
  }
  /**
   * Activates player and ad event listeners.
   */
  on() {
    this.addPlayerEventListener(ke.ON_TIME_UPDATED, () => {
      this.adSlotController.timeupdate();
    }), this.addPlayerEventListener(ke.ON_PAUSED, () => {
      this.currentAd.isPaused = !0, this.player.getAdCurrentTime() > 0 && this.player.getAdCurrentTime() < this.player.getAdDuration() && this.adSlotController.dispatchEvent(p.ON_AD_PAUSED);
    }), this.addPlayerEventListener(ke.ON_PLAY, () => {
      this.currentAd.isPaused = !1, this.player.getAdCurrentTime() > 0 && this.adSlotController.dispatchEvent(p.ON_AD_PLAYING);
    }), this.addPlayerEventListener(ke.ON_VOLUME_CHANGED, () => {
      this.currentAd && (isNaN(this.currentAd.volume) || (this.currentAd.volume === 0 && this.player.getVolume() > 0 ? this.adSlotController.dispatchEvent(p.ON_AD_UNMUTED) : this.currentAd.volume > 0 && this.player.getVolume() === 0 && this.adSlotController.dispatchEvent(p.ON_AD_MUTED)), this.currentAd.volume = this.player.getVolume(), this.adSlotController.dispatchEvent(p.ON_AD_VOLUME_CHANGED));
    }), this.getRemoveHandlerForAdSlotControllerEvent(p.ON_AD_START, this.saveStartVolume), super.addEventListener(p.ON_AD_STARTED, () => {
      this.removeDeliverNextAdEventHandler = this.addPlayerEventListener(ke.ON_ENDED, () => {
        this.adSlotController.timeupdate(), this.adSlotController.dispatchEvent(p.ON_AD_STOPPED), c.debug.info(Ze.NAME + "Received ended event from the video player.", this.currentAd), this.cleanAndDeliveryNextAd();
      });
    }), this.addVpaidListeners(), this.addPlayerEventListener(ke.ON_ERROR, () => {
      c.debug.info(
        Ze.NAME + "on - Player sent error event"
      );
    });
  }
  /** @internal */
  saveStartVolume() {
    this.currentAd && this.player && (this.currentAd.volume = this.player.getVolume());
  }
  /** @internal */
  saveStartVolumeVPAID() {
    this.adSlotController.vpaidPlayer.setVolume(this.player.getVolume());
  }
  stop() {
    return new Promise((e) => (this.adSlotHasStarted && (this.removeDeliverNextAdEventHandler && this.removeDeliverNextAdEventHandler(), this.adSlotHasStarted && (this.adSlotHasStarted = !1, this.dispatchEvent(p.ON_AD_SLOT_STOPPED)), this.eventCallbacks.forEach((i) => {
      i();
    }), this.eventCallbacks = []), e()));
  }
  deliverNextAd() {
    var r;
    const e = this;
    (e.currentAd === null || e.currentAd.replaced) && (e.currentAd = e.adSlotController.getAd()), c.debug.info(Ze.NAME + "deliver ad:", e.currentAd), clearTimeout(e.loadPendingTimeout);
    function i() {
      if (e.adSlotController.requestedTrackingEvents = [], e.adSlotController.startViewability(), e.adSlotController.dispatchEvent(p.ON_AD_START), e.deployConcurrentAssets(), e.removeDeliverNextAdEventHandler && e.removeDeliverNextAdEventHandler(), e.removeImpressionOnStartHandler && e.removeImpressionOnStartHandler(), e.currentAd.isSIMID && e.adSlotController.loadAdSIMID(), e.currentAd.isVPAID)
        e.adSlotController.loadAdVPAID();
      else {
        const s = e.currentAd.config.trackImpressionOnStart ? p.ON_AD_PLAYBACK_START : p.ON_AD_STARTED;
        e.removeImpressionOnStartHandler = e.addEventListener(s, () => {
          e.adSlotController.dispatchEvent(p.ON_AD_IMPRESSION), e.adSlotController.dispatchEvent(p.ON_AD_CREATIVE_VIEW);
        });
        let l = e.currentAd.isLinear ? e.currentAd.properCreative.selectedMediaFile : e.currentAd.properCreative.variations[0];
        e.loadAd(l);
      }
    }
    if (e.adSlotHasStarted || (e.dispatchEvent(p.ON_AD_SLOT_STARTED), e.adSlotHasStarted = !0, e.on()), (r = e.currentAd) != null && r.hasError) {
      e.cancelAdWithError();
      return;
    }
    e.currentAd === null ? e.stop() : i();
  }
  cancelAdWithError() {
    this.adSlotController.cancelAd(), this.currentAd = null, this.deliverNextAd();
  }
  /** @internal */
  deployConcurrentAssets() {
    const e = this.currentAd.creatives.filter((i) => i.type === "companion" && i.hasCompanionResources);
    e && e.length > 0 && this.dispatchEvent(p.ON_COMPANIONS_DETECTED), this.currentAd.extensions && this.currentAd.extensions.length > 0 && this.dispatchEvent(p.ON_EXTENSIONS_DETECTED), this.currentAd.icons && Object.keys(this.currentAd.icons).length > 0 && this.dispatchEvent(p.ON_ICONS_DETECTED), this.currentAd.closedCaptions && this.currentAd.closedCaptions.length > 0 && this.dispatchEvent(p.ON_CLOSED_CAPTIONS_DETECTED), this.currentAd.config.adVerification.disabled || new fr(this.currentAd, this), this.currentAd.adVerifications && this.currentAd.adVerifications.length > 0 && this.dispatchEvent(p.ON_VERIFICATION_DETECTED);
  }
  /** @internal */
  activateHOMAD(e, i) {
    this.currentAd.adReinsertion.setReinsertionReason({
      reason: e,
      source: i,
      error: this.currentAd.error
    }), this.currentAd.adReinsertion.enable(
      () => {
        this.currentAd.isLinear && (this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(p.ON_AD_ERROR)), le.EventDispatcher.dispatchEvent(p.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        this.deliverNextAd();
      }
    );
  }
  loadAd(e) {
    if (this.currentAd.isLinear) {
      let i = "Load MediaFile ", r = e.fileURL, s = !1;
      clearTimeout(this.loadPendingTimeout);
      let l = (h) => {
        s = !0, c.debug.error("VideoProxy load timeout.", h), this.currentAd.error = w.VAST.TIMEOUT, this.deliverOrHOMAD(le.REASON.MEDIAFILE_TIMEOUT, r);
      };
      this.loadPendingTimeout = setTimeout(
        l.bind(this),
        this.currentAd.config.timeouts.videoRequest * 1e3
      ), c.debug.info(Ze.NAME + i + "from URI", r), this.player.load(r, !0).then(() => {
        clearTimeout(this.loadPendingTimeout), !s && (c.debug.info(Ze.NAME + i + "success."), this.adSlotController.dispatchEvent(p.ON_AD_LOADED), this.dispatchEvent(p.ON_AD_STARTED));
      }, (h) => {
        if (clearTimeout(this.loadPendingTimeout), s)
          return;
        c.debug.error(Ze.NAME + i + "failed", h);
        const m = {
          [w.VAST.GENERAL_ERROR.code]: w.VAST.GENERAL_ERROR,
          [w.VAST.FILE_NOT_FOUND.code]: w.VAST.FILE_NOT_FOUND,
          [w.VAST.UNSUPPORTED_MIMETYPE.code]: w.VAST.UNSUPPORTED_MIMETYPE
        };
        this.currentAd.error = m[h] || w.VAST.MEDIAFILE_DISPLAY_ERROR, this.deliverOrHOMAD(le.REASON.MEDIAFILE_LOAD_ERROR, r);
      });
    } else {
      let i, r = !1, s = "loadAd - NonLinear ";
      if (clearTimeout(this.loadPendingTimeout), this.currentAd.config.playerHandlesNonLinear) {
        this.addPlayerEventListener(ke.ON_LOADED_DATA, () => {
          this.dispatchEvent(p.ON_AD_STARTED), this.dispatchEvent(p.ON_AD_IMPRESSION), this.dispatchEvent(p.ON_AD_CREATIVE_VIEW);
        }), this.addPlayerEventListener(ke.ON_ENDED, () => {
          this.dispatchEvent(p.ON_AD_NONLINEAR_STOPPED), this.dispatchEvent(p.ON_AD_STOPPED);
        });
        return;
      }
      this.loadPendingTimeout = setTimeout((l) => {
        r = !0, c.debug.error(s + " timeout.", l), this.currentAd.error = w.VAST_NONLINEAR.TIMEOUT, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(p.ON_AD_ERROR), this.deliverOrHOMAD(le.REASON.MEDIAFILE_TIMEOUT, e);
      }, this.currentAd.config.timeouts.videoRequest * 1e3), this.adSlotController.environmentVars.adContainer ? (c.debug.info(
        s + "- Using publisher adContainer",
        this.adSlotController.environmentVars.adContainer
      ), i = this.adSlotController.environmentVars.adContainer) : (c.debug.warn(s + "- Publisher adContainer not specified. Using the video elements parent element as a fallback."), i = this.player.getPlayerElement().parentNode), this.adSlotController.nonLinearView = new Ar(this, i), [
        p.ON_AD_STARTED,
        p.ON_AD_IMPRESSION,
        p.ON_AD_CREATIVE_VIEW,
        p.ON_AD_NONLINEAR_STOPPED,
        p.ON_AD_STOPPED
      ].map((l) => {
        const h = this.adSlotController.nonLinearView.addEventListener(
          l,
          (m) => {
            this.dispatchEvent(m.type), m.type === p.ON_AD_STOPPED && this.cleanAndDeliveryNextAd();
          }
        );
        this.eventCallbacks.push(h);
      }), this.addPlayerEventListener(ke.ON_PLAY, this.play.bind(this)), this.addPlayerEventListener(ke.ON_PAUSED, this.pause.bind(this)), this.adSlotController.nonLinearView.init(e).then(() => {
        clearTimeout(this.loadPendingTimeout), !r && c.debug.info(s + "Request complete");
      }, (l) => {
        clearTimeout(this.loadPendingTimeout), !r && (c.debug.error("loadAd - VideoProxy load failed", l), this.currentAd.error = w.VAST_NONLINEAR.GENERAL_ERROR, this.currentAd.enrichment.set("ERRORCODE", this.currentAd.error.code), this.dispatchEvent(p.ON_AD_ERROR), this.deliverOrHOMAD(le.REASON.MEDIAFILE_LOAD_ERROR, e));
      });
    }
  }
  getCurrentAd() {
    return this.currentAd;
  }
  onSkip() {
    this.adSlotController.onSkip(), this.cleanAndDeliveryNextAd();
  }
};
Ze.NAME = "AdSloDel::";
let mr = Ze;
class Ir {
  getResources() {
    return this.resources;
  }
  constructor(e, i) {
    var r, s, l, h;
    this.adParameters = ((s = (r = i.querySelector("AdParameters")) == null ? void 0 : r.textContent) == null ? void 0 : s.trim()) || null, this.apiFramework = i.getAttribute("apiFramework") || null, this.clickThroughURL = ((h = (l = i.querySelector(e + "ClickThrough")) == null ? void 0 : l.textContent) == null ? void 0 : h.trim()) || null, this.clickTracker = this.getClickTracker(e, i), this.resources = this.parseResources(i);
  }
  /**
   * Parse StaticResource, HTMLResource and IFrameResource into array of resources
   * @param {Element} container (parent element) of the resource file nodes
   * @returns {Array} Array of resources with their attributes and contents parsed into properties
   */
  parseResources(e) {
    let i = [], r = e.querySelectorAll(
      "HTMLResource, IFrameResource, StaticResource"
    );
    for (let s = 0; s < r.length; s++)
      i.push({
        creativeType: r[s].getAttribute("creativeType"),
        resource: G.trim(r[s].textContent || ""),
        type: r[s].nodeName
      });
    return i;
  }
  getClickTracker(e, i) {
    let r = [];
    return [].slice.call(i.querySelectorAll(e + "ClickTracking")).forEach((s) => {
      r.push({
        url: G.trim(s.textContent),
        id: s.getAttribute("id")
      });
    }), r;
  }
}
class fo extends Ir {
  constructor(e, i, r) {
    var s;
    super(e, r), this.adSlotId = r.getAttribute("adSlotId") || "", this.altText = G.trim(((s = r.querySelector("AltText")) == null ? void 0 : s.textContent) || ""), this.assetHeight = r.getAttribute("assetHeight") || "", this.assetWidth = r.getAttribute("assetWidth") || "", this.companionXML = r, this.creativeViewTracker = i, this.expandedHeight = r.getAttribute("expandedHeight") || "", this.expandedWidth = r.getAttribute("expandedWidth") || "", this.hasCreative = super.getResources().length > 0, this.height = r.getAttribute("height"), this.id = r.getAttribute("id") || Un(), this.pxratio = r.getAttribute("pxratio") || "1", this.renderingMode = r.getAttribute("renderingMode") || "default", this.width = r.getAttribute("width");
  }
}
function Ae(A, e) {
  const i = (A == null ? void 0 : A.getAttribute(e)) || -1;
  let r = -1;
  return typeof i == "string" && (r = parseInt(i, 10)), isNaN(i) ? -1 : r;
}
class Ao extends Ir {
  constructor(e, i, r) {
    var s;
    super(e, r), this.altText = G.trim(((s = r.querySelector("AltText")) == null ? void 0 : s.textContent) || ""), this.creativeViewTracker = i, this.duration = Ae(r, "duration"), this.hasCreative = super.getResources().length > 0, this.height = G.trim(r.getAttribute("height")), this.hoverText = r.getAttribute("hoverText") || null, this.offset = G.convertTimeStringToSeconds(r.getAttribute("offset")), this.program = r.getAttribute("program") || "unknown", this.pxratio = Ae(r, "pxratio"), this.width = r.getAttribute("width"), this.xPosition = r.getAttribute("xPosition"), this.yPosition = r.getAttribute("yPosition");
  }
}
class mo extends Ir {
  constructor(e, i, r) {
    const s = Ae(r, "expandedHeight"), l = Ae(r, "expandedWidth"), h = Ae(r, "height"), m = r.getAttribute("id"), E = r.getAttribute("maintainAspectRatio") !== "false", S = G.convertTimeStringToSeconds(
      r.getAttribute("minSuggestedDuration")
    ), M = r.getAttribute("scalable") !== "false", Q = Ae(r, "width");
    super(e, r), this.creativeTrackers = i, this.displayDuration = null, this.expandedHeight = s, this.expandedWidth = l, this.height = h, this.id = m, this.maintainAspectRatio = E, this.minSuggestedDuration = S != null ? S : -1, this.scalable = M, this.selectedResource = {
      creativeType: null,
      resource: null,
      type: ""
    }, this.width = Q;
  }
}
var ni = ((A) => (A.COMPANION = "companion", A[A.LINEAR = ae.LINEAR] = "LINEAR", A[A.NON_LINEAR = ae.NON_LINEAR] = "NON_LINEAR", A))(ni || {});
class Eo {
  constructor(e) {
    this.adXML = e, this.linearObject = this.getLinear(), this.nonLinearCreative = this.getNonLinear();
  }
  // collects all types of linear, nonLinear and companions - so ad.creatives.length can be checked
  get allTypesAsArray() {
    let e = this.linear, i = this.companion, r = e.mediaFiles.interactive, s = this.nonLinearCreative, l = e.mediaFiles.streaming, h = e.mediaFiles.vpaid, m = [];
    return m = m.concat(
      ...h,
      ...l,
      ...r,
      ...s,
      ...i
    ), m;
  }
  //CreativeSourceSelector expects mediafiles to be an array of creatives
  //FIXME it'd be more clean to rewrite CreateSourceSelector however that'd break all tests currently
  // to use vpaid, streaming and so on instead of "reparsing"/filter them for vpaid and others again
  get linearAsArray() {
    let e = this.linear;
    return [{
      captions: e.captions,
      creativeTrackers: e.creativeTrackers,
      icons: e.icons,
      mediaFiles: [].concat(
        e.mediaFiles.interactive,
        e.mediaFiles.streaming,
        e.mediaFiles.vpaid
      )
    }];
  }
  get linear() {
    return this.linearObject;
  }
  createEmptyElement(e) {
    return document.createElement(e);
  }
  /** @internal */
  getLinear() {
    let e = this.adXML.querySelector("InLine > Creatives > Creative > Linear") || this.createEmptyElement("Inline"), i = e.querySelector("MediaFiles") || this.createEmptyElement("MediaFiles");
    return {
      captions: this.getClosedCaptionCreatives(e),
      creativeTrackers: this.getTrackers("Linear Tracking"),
      icons: this.getIndustryIcons(),
      mediaFiles: {
        interactive: this.getInteractiveCreatives(e),
        streaming: this.getStreamingCreatives(i),
        vpaid: this.getVPAIDCreatives(e)
      }
    };
  }
  getVPAIDCreatives(e) {
    var l;
    let i = [], r = e.querySelectorAll('MediaFile[apiFramework="VPAID"]'), s = e.querySelector("AdParameters");
    for (let h = 0; h < r.length; h++)
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: "VPAID",
        bitrate: Ae(r[h], "bitrate"),
        fileURL: G.trim(r[h].textContent),
        height: Ae(r[h], "height"),
        linearity: ae.LINEAR,
        mimeType: r[h].getAttribute("type"),
        width: Ae(r[h], "width")
      });
    return i;
  }
  getStreamingCreatives(e) {
    let i = [], r = e.querySelectorAll('MediaFile:not([apiFramework="VPAID"])');
    for (let s = 0; s < r.length; s++)
      i.push({
        apiFramework: r[s].getAttribute("apiFramework"),
        bitrate: Ae(r[s], "bitrate"),
        fileURL: G.trim(r[s].textContent),
        height: Ae(r[s], "height"),
        linearity: ae.LINEAR,
        mimeType: r[s].getAttribute("type"),
        width: Ae(r[s], "width")
      });
    return i;
  }
  getInteractiveCreatives(e) {
    var l;
    const i = [], r = e.querySelectorAll("InteractiveCreativeFile"), s = e.querySelector("AdParameters");
    for (let h = 0; h < r.length; h++) {
      const m = r[h], E = m.getAttribute("variableDuration");
      i.push({
        adParameters: ((l = s == null ? void 0 : s.textContent) == null ? void 0 : l.trim()) || null,
        apiFramework: m.getAttribute("apiFramework"),
        delivery: m.getAttribute("delivery"),
        fileURL: G.trim(m.textContent),
        linearity: ae.LINEAR,
        mimeType: m.getAttribute("type"),
        variableDuration: E ? !!E.match("true") : !1
      });
    }
    return i;
  }
  getClosedCaptionCreatives(e) {
    let i = [], r = e.querySelector("ClosedCaptionFiles");
    if (r) {
      let s = r.querySelectorAll("ClosedCaptionFile");
      for (let l = 0; l < s.length; l++)
        i.push({
          fileURL: s[l].textContent,
          // en, en-US, zh-TW
          language: s[l].getAttribute("language"),
          linearity: ae.LINEAR,
          // text/srt, text/vtt, application/ttml+xml
          type: s[l].getAttribute("type")
        });
    }
    return i;
  }
  getCreativeViewTrackers(e, i) {
    const r = [];
    return [...e.querySelectorAll(i)].forEach((s) => {
      r.push({
        url: G.trim(s.textContent)
      });
    }), r;
  }
  getIndustryIcons() {
    const e = {};
    let i = this.adXML.querySelectorAll("Creatives > Creative > Linear Icon");
    for (let r = 0; r < i.length; r++) {
      const s = i[r].getAttribute("program") || "unknown", l = this.getCreativeViewTrackers(i[r], "IconViewTracking"), h = new Ao("Icon", l, i[r]);
      e[s] = h;
    }
    return e;
  }
  get nonLinear() {
    return this.nonLinearCreative;
  }
  /** @internal */
  getNonLinear() {
    let e = this.adXML.querySelectorAll("InLine > Creatives > Creative > NonLinearAds");
    return this.getNonLinearCreatives(e[0]);
  }
  getNonLinearCreatives(e) {
    if (!e || e.children.length === 0)
      return [];
    c.debug.info("[VASTAdCreatives] Get NonLinear Creatives from.", e);
    let i = e.querySelectorAll("NonLinear"), r = [{
      type: ni.NON_LINEAR,
      universalAdId: {},
      variations: []
    }];
    for (let s = 0; s < i.length; s++) {
      const l = new mo(
        "NonLinear",
        this.getTrackers("NonLinearAds Tracking"),
        i[s]
      );
      r[s].variations.push(l);
    }
    return r;
  }
  get companion() {
    const e = this.adXML.querySelectorAll("Creatives > Creative > CompanionAds");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      i[r] = {
        hasCompanionResources: !1,
        required: null,
        type: ni.COMPANION,
        variations: []
      };
      const s = e[r].querySelectorAll("Companion");
      for (let l = 0; l < s.length; l++)
        if (s[l].hasChildNodes()) {
          const h = this.getCreativeViewTrackers(
            s[l],
            "Tracking[event=creativeView]"
          );
          let m = new fo(
            "Companion",
            h,
            s[l]
          );
          i[r].hasCompanionResources = m.resources.length > 0, i[r].required = e[r].getAttribute("required"), i[r].variations.push(m);
        }
    }
    return i.reverse();
  }
  /**
   * @returns {Object} Object with tracker arrays for all specified tracking events
   */
  /** @internal */
  getTrackers(e) {
    const i = {}, r = Array.from(this.adXML.querySelectorAll("ClickTracking, " + e));
    for (let s = 0; s < r.length; s++) {
      const l = r[s], h = l.nodeName.charAt(0).toLowerCase() + l.nodeName.slice(1), m = l.getAttribute("event") || h, E = l.getAttribute("offset"), S = {
        offset: "",
        url: G.trim(l.textContent)
      };
      if (m === Ut.ON_AD_PROGRESS && E) {
        const M = G.convertTimeStringToSeconds(E);
        S.offset = typeof M == "number" ? M.toString() : E;
      }
      i[m] = i[m] || [], i[m].push(S);
    }
    return i;
  }
}
class go extends c {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(), this.adXML = e, this.rawXML = i instanceof Document ? i.documentElement : i, this.adTrackerList = this.getRootTracker(), this.error = {
      // eslint-disable-next-line no-undefined
      code: void 0,
      message: "",
      timestamp: null
    }, this.extensionsArray = this.getExtensions();
  }
  /**
  * @private
  */
  getElementsSortedByDepth(e) {
    return e.sort((i, r) => {
      const s = Number(Object.keys(i));
      return Number(Object.keys(r)) - s;
    }).map((i) => Object.values(i)[0]);
  }
  /**
   * @private
   */
  getNodeDepth(e) {
    let i = 0, r = e.parentElement;
    for (; r; )
      i++, r = r.parentElement;
    return { [i]: e };
  }
  /**
   * @private
   */
  getWrapperAndInLineCreative() {
    let e = [];
    const i = this.adXML.querySelectorAll("Ad > Wrapper");
    let r = [];
    return i.forEach((l) => {
      let h = l.querySelectorAll("Wrapper > Creatives > Creative");
      h.length > 0 ? h.forEach((m) => {
        r.push(m);
      }) : e.push(l);
    }), r.length > 0 && r.forEach((l) => {
      e.push(l);
    }), this.adXML.querySelectorAll("InLine > Creatives > Creative").forEach((l) => {
      e.push(l);
    }), e;
  }
  /**
   * Used to provide the ad server’s unique identifier for the creative.
   * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
   */
  get adIds() {
    let e = [];
    this.wrappers.length > 0 ? e = this.getWrapperAndInLineCreative() : this.adXML.querySelectorAll("Creative").forEach((h) => {
      e.push(h);
    });
    let i = [];
    e.forEach((l) => {
      i.push(this.getNodeDepth(l));
    });
    const r = this.getElementsSortedByDepth(i);
    let s = [];
    return r.forEach((l) => {
      const h = l.getAttributeNames().find((m) => m.toLowerCase() === "adid");
      s.push(l.getAttribute(h) || null);
    }), s;
  }
  /**
   * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
   */
  get adType() {
    return (G.getMostNestedElement(this.adXML, "Ad") || this.adXML).getAttribute("adType") || "video";
  }
  /**
   * @returns {string|null} The name of the advertiser.
   */
  get advertiser() {
    const e = this.adXML.querySelector("InLine Advertiser");
    return G.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {array|null} AdVerification
   *
   * The element is used to contain one or more <Verification> elements,
   *  which are used to initiate a controlled container where code can be
   *  executed for collecting data to verify ad viewability details.
   */
  get adVerifications() {
    const e = this.adXML.querySelectorAll("AdVerifications > Verification");
    let i = [];
    for (let r = 0; r < e.length; r++) {
      const s = e[r], l = s.getAttribute("vendor") || "", h = s.querySelector("JavaScriptResource"), m = this.getNodeContentsAsText(
        s.querySelector("VerificationParameters") || document.createElement("div")
      ), E = this.getTrackerNodesAsURLArray(
        s.querySelector("TrackingEvents") || document.createElement("div")
      );
      if (l && l.length > 0 && h) {
        const S = {
          javascriptResource: {
            url: G.trim(this.getNodeContentsAsText(h)),
            apiFramework: h.getAttribute("apiFramework") || "",
            browserOptional: h.getAttribute("browserOptional") === "true" || !1
          },
          tracking: E,
          vendor: l,
          verificationParameters: m
        };
        i.push(S);
      }
    }
    return i.length > 0 ? G.getUnique(i, "vendor") : [];
  }
  /**
   * @returns {Boolean} True if the current ad wrapper has been specified as allowMultipleAds
   */
  get allowMultipleAds() {
    let e = G.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("allowMultipleAds") ? e.getAttribute("allowMultipleAds") === "true" : !1;
  }
  /**
   * @returns {Array} <Creatives>
   *
   * The <Creatives>(plural) element is a container for one or more <Creative>(singular) element used
   *  to provide creative files for the ad. For an InLine ad, the <Creatives>element nests all the files
   *  necessary for executing and tracking the ad.
   */
  get creatives() {
    return this.creativeClass.allTypesAsArray;
  }
  get creativeClass() {
    return this.creativesArray ? this.creativesArray : (this.creativesArray = new Eo(this.adXML), this.creativesArray);
  }
  /**
   * @returns {string|null} A brief description of the campaign or placement,
   *  defined by the ad serving party.
   */
  get description() {
    const e = this.adXML.querySelector("InLine Description");
    return G.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * The list of all found <Extension> nodes
   * @returns {Array<Extension>} list
   */
  get extensions() {
    return this.extensionsArray;
  }
  /**
   * @returns {Boolean} false if the current ad wrapper has been specified as fallbackOnNoAd is false default true
   */
  get fallbackOnNoAd() {
    let e = G.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackOnNoAd") ? e.getAttribute("fallbackOnNoAd") !== "false" : !0;
  }
  /**
   * @returns {string} from attribute of fallbackType, defaulting to the IAB standard BuffetAd replacement method
   */
  get fallbackType() {
    let e = G.getMostNestedElement(this.adXML, "Wrapper");
    return e && e.hasAttribute("fallbackType") ? e.getAttribute("fallbackType") : "replace";
  }
  /**
   * @returns {string|null|Array<string|null>} Used to identify the ad server that provides the creative.
   */
  get id() {
    let e = [];
    this.wrappers.length > 0 && this.adXML.querySelectorAll("Ad > Wrapper").forEach((l) => {
      const h = l.parentElement.getAttribute("id");
      e.push(h);
    });
    let i = null, r = G.getMostNestedElement(this.adXML, "Ad");
    return r && r.hasAttribute("id") && (i = r.id), e.length > 0 ? (e.push(i), e.reverse()) : this.adXML.getAttribute("id") || null;
  }
  /**
   * Ad server’s unique identifier for the creative.
   *
   * @returns {Array<string|null>} A string used to identify the ad server that provides the creative.
   */
  get ids() {
    let e = [];
    this.wrappers.length > 0 ? e = this.getWrapperAndInLineCreative() : this.adXML.querySelectorAll("Creative").forEach((h) => {
      e.push(h);
    });
    let i = [];
    e.forEach((l) => {
      i.push(this.getNodeDepth(l));
    });
    let r = [];
    return this.getElementsSortedByDepth(i).forEach((l) => {
      r.push(l.getAttribute("id") || null);
    }), r;
  }
  /**
   * @returns {string|null} The purpose of this id is to greatly reduce the amount of work required
   *  to compare impression-level data across multiple systems.
   */
  get adServingId() {
    const e = this.adXML.querySelector("InLine AdServingId");
    return G.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object|null} Real-time bidding (RTB) pricing data including model and currency.
   *  The core doesn't handle RTB, so this is for informational purposes only.
   */
  get pricing() {
    let e = this.adXML.querySelector("InLine Pricing") || G.getMostNestedElement(this.adXML, "Wrapper Pricing");
    return e && e !== this.adXML ? {
      value: this.getNodeContentsAsText(e),
      model: e.getAttribute("model"),
      currency: e.getAttribute("currency")
    } : null;
  }
  /**
   * @returns {string|null} URI to any resource file having to do with collecting survey data.
   */
  get survey() {
    const e = this.adXML.querySelector("InLine Survey");
    return G.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Descriptive name for the ad serving system.
   */
  get system() {
    const e = this.adXML.querySelector("InLine AdSystem");
    return G.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {string|null} Title for the ad, defined by the ad serving party.
   */
  get title() {
    const e = this.adXML.querySelector("InLine AdTitle");
    return G.trim((e == null ? void 0 : e.textContent) || "");
  }
  /**
   * @returns {Object} Object with tracker arrays for impression and error
   */
  get adTrackers() {
    return this.adTrackerList;
  }
  /**
   * @returns {Array} List of Wrapper objects, starting with the first Wrapper up to the Inline tag.
   */
  get wrappers() {
    const e = [];
    this.rawXML && this.rawXML.hasAttribute("_initialURL") && e.push({
      loadStart: new Date(Ae(this.rawXML, "_loadStart")).toISOString(),
      loadEnd: new Date(Ae(this.rawXML, "_loadEnd")).toISOString(),
      loadTime: Ae(this.rawXML, "_loadEnd") - Ae(this.rawXML, "_loadStart"),
      url: this.rawXML.getAttribute("_initialURL")
    });
    const i = this.adXML.querySelectorAll("VASTAdTagURI");
    for (let r = 0; r < i.length; r++)
      e.push({
        loadStart: new Date(Ae(i[r], "_loadStart")).toISOString(),
        loadEnd: new Date(Ae(i[r], "_loadEnd")).toISOString(),
        loadTime: Ae(i[r], "_loadEnd") - Ae(i[r], "_loadStart"),
        url: G.trim(i[r].textContent)
      });
    return e;
  }
  /**
   * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of 4.1.
   * Media players should not fail if this attribute is present, but should always use the Content
   *  as the source of truth for the creative ID value
   *
   * Content/"idValue" A string identifying the unique creative identifier.
   * Default value is “unknown” idRegistry A string used to identify the URL for the registry website
   *  where the unique creative ID is cataloged. Default value is “unknown.
   *
   * @returns {Object} UniversalAdId
   */
  get universalAdId() {
    const e = this.adXML.querySelectorAll("Creative UniversalAdId"), i = e[e.length - 1];
    return i ? this.extractUniversalAdIdInfo(i) : { idRegistry: "unknown", idValue: "unknown" };
  }
  /**
   * VAST 4.2 allows multiple UniversalAdId nodes to be provided
   *
   * @returns {Array} List of all Universal Ad IDs
   */
  get universalAdIds() {
    let e = [];
    const i = this.adXML.querySelectorAll("Creative UniversalAdId");
    for (let r = 0; r < i.length; r++)
      e.push(this.extractUniversalAdIdInfo(i[r]));
    return e;
  }
  /**
   * Returns all VAST Extensions (no CreativeExtensions)
   *
   * @internal
   * @returns {Array} Extensions
   */
  /** @internal */
  getExtensions() {
    let e = [];
    if (this.adXML) {
      const i = this.adXML.querySelectorAll("Extensions > Extension");
      for (let r = 0; r < i.length; r++)
        e.push({
          extensionXML: i[r],
          type: i[r].getAttribute("type")
        });
    }
    return e;
  }
  /** @internal */
  getNodeContentsAsText(e) {
    var i;
    return ((i = e == null ? void 0 : e.textContent) == null ? void 0 : i.trim()) || "";
  }
  /** @internal */
  extractUniversalAdIdInfo(e) {
    return {
      idRegistry: e.getAttribute("idRegistry") || null,
      idValue: this.getNodeContentsAsText(e) || G.trim(
        e.getAttribute("idValue") || "unknown"
      )
    };
  }
  /**
   * Note: TrackingEvents moved to the creative level
   * @internal
   * @returns {Object} Object with tracker arrays for error, impression and viewableImpression
   */
  getRootTracker() {
    const e = {};
    if (this.adXML) {
      const i = [...this.adXML.querySelectorAll(
        "Error, Impression, NotViewable, Viewable, ViewUndetermined"
      )];
      this.adXML.nodeName === "Error" && i.push(this.adXML), i.forEach((r) => {
        const s = r.nodeName.charAt(0).toLowerCase() + r.nodeName.slice(1), l = this.getNodeContentsAsText(r);
        l && l.length > 0 && (e[s] = e[s] || [], e[s].push({
          url: l
        }));
      });
    }
    return e;
  }
  /**
   * Extracts tracking event nodes from a provided DOM element and returns them as an array of objects with URLs.
   *
   * @param {Element} trackingEventsNode - DOM element containing tracking event nodes.
   * @returns {Object} Object with tracking events as keys, each containing an array of objects with URL properties.
   */
  getTrackerNodesAsURLArray(e) {
    const i = {};
    return e && Array.from(e.querySelectorAll("Tracking")).forEach((r) => {
      const s = this.getNodeContentsAsText(r), l = r.getAttribute("event");
      s && s.length > 0 && l !== null && (i[l] || (i[l] = []), i[l].push({
        url: s
      }));
    }), i;
  }
}
class _t extends go {
  /**
   * This model represents the Object-notation of a single <Ad> node.
   *
   * @param {Element} adTag a single root Ad node from the VAST response
   * @param {Document} xmlDoc the full VAST response
   */
  constructor(e, i) {
    super(e, i), this.adXML = e, this.adSkippableStateChange = !1, this.isLinearBoolean = this.adXML.querySelectorAll("Creative Linear").length >= 1 || !1, this.isSkippableBoolean = !1, this.sequencePosition = this.adXML.getAttribute("sequence") || NaN, this.skipOffsetValue = this.parseSkipOffsetToNumber(), this.deepestClickThroughURL = this.getClickThroughURL(), this.linearDuration = this.getDuration(), this.variantExtensionType = this.getVariant(
      G.getMostNestedElement(
        this.adXML,
        'Extension[type="sxp"] variant, Extension[name="SXP"] AdInfo'
      )
    ), this.replaced = !1, this.error = this.getError();
  }
  /** @internal */
  mapStringToVariant(e) {
    switch (e.toUpperCase()) {
      // only vast specific variants!
      case "BUMPER":
      case "SPONSORED":
        return ue.SPONSORED;
      default:
        return ue.COMMERCIAL;
    }
  }
  /** @internal */
  parseSkipOffsetToNumber() {
    var i;
    const e = G.convertTimeStringToSeconds(
      ((i = this.adXML.querySelector("InLine Linear")) == null ? void 0 : i.getAttribute("skipoffset")) || "0"
    );
    return typeof e == "number" ? e : -1;
  }
  /**
   * @returns {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   */
  get adSkippableStateChangeSent() {
    return this.adSkippableStateChange;
  }
  /**
   * @param {boolean} state whether the ON_AD_SKIPPABLE_STATE_CHANGE has been sent or not
   * @returns {void}
   */
  set adSkippableStateChangeSent(e) {
    this.adSkippableStateChange = e;
  }
  /**
   * Simple getter to check whether the ad can be delivered or not.
   * @returns {boolean} true if the ad is corrupted
   */
  get hasError() {
    return this.error !== null;
  }
  /**
   * The landing page URL
   * @returns {string} url
   */
  get clickThroughURL() {
    return this.deepestClickThroughURL;
  }
  /**
   * The url might be updated at runtime from VPAID creatives
   * @param {string} url The landing page URL
   * @returns {void}
   */
  set clickThroughURL(e) {
    this.deepestClickThroughURL = e;
  }
  /**
   * Time value for the duration of the Linear ad
   * @returns {number} in seconds
   */
  get duration() {
    return this.linearDuration;
  }
  /**
   * The duration might be updated at runtime after receiving the video's metadata.
   * @param {number} time Video duration in seconds
   * @returns {void}
   */
  set duration(e) {
    this.linearDuration = e;
  }
  /**
   @returns {Boolean} True if the current ad is linear
   */
  get isLinear() {
    return this.isLinearBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isLinear(e) {
    this.isLinearBoolean = e;
  }
  /**
   * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending on the
   * current progress. The following conditions must have been met:
   *  - the ad has specified a `skipoffset`
   *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
   *  - the current playhead time is equal or greater than the `skipoffset`
   *
   * @returns {Boolean} True if the current Linear has attribute skipoffset.
   */
  get isSkippable() {
    return this.isSkippableBoolean;
  }
  /**
   * @param value {Boolean}
   */
  set isSkippable(e) {
    this.isSkippableBoolean = e;
  }
  /**
   * @returns {number} Representing the numerical order in which each sequenced creative within an ad should play
   */
  get sequence() {
    return parseFloat(this.sequencePosition);
  }
  set sequence(e) {
    this.sequencePosition = e;
  }
  /**
   * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
   *     skippable.
   */
  get skipOffset() {
    return this.skipOffsetValue;
  }
  /**
   * @param {number} seconds The playback time after an ad can be skipped. The value might be updated with publisher
   *     settings.
   */
  set skipOffset(e) {
    this.skipOffsetValue = e;
  }
  /**
   * The ad variant, based on data we get from the SXP VAST Extension.
   * If omitted, the variant defaults to AD_VARIANT.COMMERCIAL
   *
   * @returns {string} variant of the ad
   */
  get variant() {
    return this.variantExtensionType;
  }
  /**
   * @param value {string}
   */
  set variant(e) {
    this.variantExtensionType = e;
  }
  /**
   * @internal
   * @param {Node} variantElement - The XML node that has the variant information for this ad.
   * @returns {string} variant - The normalized name based on the `AD_VARIANT` name.
   */
  /** @internal */
  getVariant(e) {
    if (e === null)
      return ue.COMMERCIAL;
    let i = ue.COMMERCIAL;
    return e.nodeName === "AdInfo" && (i = this.mapStringToVariant(e.getAttribute("variant") || "")), e.nodeName === "variant" && e.textContent && (i = this.mapStringToVariant(e.textContent.trim())), i;
  }
  /** @internal */
  getDuration() {
    var i, r;
    const e = ((r = (i = G.getMostNestedElement(this.adXML, "Linear Duration")) == null ? void 0 : i.textContent) == null ? void 0 : r.trim()) || _t.FALLBACK_LINEAR_DURATION;
    return G.convertTimeStringToSeconds(e);
  }
  /**
   * Description object of the most recent ad error.
   *
   * @returns {Object} <error>
   */
  /** @internal */
  getError() {
    function e(r) {
      if (r.parentNode)
        return r.parentNode.querySelector(":scope > parsererror");
    }
    const i = this.adXML.querySelector("parsererror") || e(this.adXML);
    return i ? {
      code: Ae(i, "code"),
      message: i.getAttribute("message") || "",
      timestamp: null
    } : this.flagCappedAds();
  }
  /** @internal */
  flagCappedAds() {
    return this.adXML.querySelector("InLine") && this.adXML.nodeName !== "Error" ? null : {
      code: w.WRAPPER.NO_RESPONSE.code,
      message: w.WRAPPER.NO_RESPONSE.message,
      timestamp: null
    };
  }
  /** @internal */
  getClickThroughURL() {
    const e = this.isLinear ? "VideoClicks ClickThrough" : "NonLinearClickThrough", i = G.getMostNestedElement(this.adXML, e);
    return G.trim((i == null ? void 0 : i.textContent) || "");
  }
}
_t.FALLBACK_LINEAR_DURATION = "00:00:20";
class vo {
  /**
   * Creates an instance of AdSlotModel.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  constructor(e) {
    this.adList = [], this.handleXMLDoc(e);
  }
  /**
   * Handles the provided XML document to extract and create Ad instances.
   *
   * @param {Document} xmlDoc - The XML document containing ad information.
   */
  /** @internal */
  handleXMLDoc(e) {
    let i = e.querySelector("parsererror"), r = e.querySelectorAll(":root > *"), s;
    if (!(e.querySelector("html") && i)) {
      if (e.querySelector("html")) {
        s = document.createElement("VAST");
        const l = new _t(s, e);
        this.adList.push(l);
        return;
      }
      if (e instanceof DocumentFragment && i) {
        s = document.createElement("VAST"), s.appendChild(i);
        const l = new _t(s, e);
        this.adList.push(l);
      }
      for (let l = 0; l < r.length; l++) {
        const h = new _t(r[l], e);
        this.adList.push(h);
      }
    }
  }
  /**
   * Gets the list of ads in the playlist.
   *
   * @returns {Ad[]} - The list of ads. Empty when no ad.
   */
  getAdList() {
    return this.adList;
  }
}
function So(A, e) {
  const i = Object.values(ri);
  let r = [];
  const s = document.createElement("video"), l = document.createElement("audio");
  let h = i;
  return e && e.length > 0 && (r = e, h = e), h.filter((E) => !("canPlayType" in s) || E === "application/javascript" || s.canPlayType(E) !== "" || l.canPlayType(E) !== "" ? r.push(E) : !1), (r.length <= 0 || r.length === 1 && r[0] === "application/javascript") && (r = h), A.filter((E) => r.find((S) => E.mimeType === S));
}
class Pi {
  static getProperCreative(e, i) {
    if (!e || e.length < 1)
      return null;
    let r = e.slice(0);
    return e[0].type === ae.NON_LINEAR ? Io.select(r, i) : yo.select(r, i);
  }
  /**
   * Removes VPAID media files from unwanted vendors.
   * @param {Array} creativeFiles represents all available MediaFiles from an ad
   * @param {Array} vendorWhiteList specifies a list of accepted VPAID vendors.
   * Each String has to represent an unique identifier that can be found within the creative media file URL, most
   *  likely the domain name.
   * @returns {Array} Revised mediaFileList
   */
  static removeUnwantedVPAIDVendors(e, i = []) {
    return e.filter((r) => r.isVPAID ? this.isFriendlyVendorHost(r.fileURL, i) : !0);
  }
  static isFriendlyVendorHost(e, i = []) {
    return !i || i && i.length === 0 ? !0 : i.some((r) => {
      if (!r.includes("."))
        return !1;
      try {
        const s = new URL(e).hostname;
        return new RegExp(`(^|\\.)${r.replace(".", "\\.")}$`).test(s);
      } catch (s) {
        return !1;
      }
    });
  }
}
class yo {
  static select(e, i) {
    return e.forEach((s) => {
      s.selectedCreativeFile = null, s.selectedMediaFile = null;
      let l = s.mediaFiles || [];
      l.map((m) => {
        var E;
        !s.selectedCreativeFile && m.apiFramework && (m.isSIMID = (m.apiFramework + "").toUpperCase() === "SIMID", s.selectedCreativeFile = m.isSIMID ? m : null), (E = s.selectedCreativeFile) != null && E.isSIMID && (m.isSIMID = !0), m.isVPAID = (m.apiFramework + "").toUpperCase() === "VPAID";
      }), l = Pi.removeUnwantedVPAIDVendors(
        l,
        i.desiredVPAIDVendors
      );
      let h = So(l, i.desiredMimeTypes);
      s.selectedMediaFile = this.selectMediaFile(
        h,
        i.desiredBitrate || 1e3,
        i.desiredMimeTypes || []
      );
    }), e.filter((s) => !!s.selectedMediaFile).shift();
  }
  /**
   * @param {Array} mediaFileList represents all available MediaFiles from an ad.
   * @param {number} bitrate indicates the desired bitrate in kilobits per second (kbps).
   * @param {Array} desiredMimeTypes represents the favorite mediaFiles in a certain order.
   * @returns {Array} Revised mediaFileList with favored desiredMimeType.
   */
  /** @internal */
  static selectMediaFile(e, i, r) {
    let s = e.filter((m) => m.isSIMID), l = e.filter((m) => m.isVPAID);
    if (s.length > 0)
      return s[0];
    if (l.length > 0)
      return l[0];
    let h = [];
    for (let m = 0; m < r.length; ) {
      if (m > 0 && h.length > 0) {
        e = h;
        break;
      }
      e.filter((E) => {
        E.mimeType === r[m] && h.push(E);
      }), m++;
    }
    return this.selectMediaFileByBitrate(e, i);
  }
  // mediafile returned has smaller or same bitrate as requested one
  /** @internal */
  static selectMediaFileByBitrate(e, i) {
    let r = e.filter((l) => !l.isVPAID).sort((l, h) => h.bitrate - l.bitrate), s = r.filter((l) => l.bitrate <= i);
    return s.length > 0 ? s.shift() : r.pop() || e.shift();
  }
}
class Io {
  static select(e, i) {
    return e.forEach((s) => {
      const l = s.variations;
      l.map((h) => {
        h.selectedResource = null, (h.apiFramework + "").toUpperCase() === "VPAID" && (h.isVPAID = !0, h.resources = h.resources.filter((m) => Pi.isFriendlyVendorHost(
          m.resource,
          i.desiredVPAIDVendors
        )));
      }), l.forEach((h) => {
        h.resources.length <= 0 ? h.hasCreative = !1 : h.selectedResource = h.resources[0];
      }), s.variations = l.filter((h) => !!h.selectedResource);
    }), e.filter((s) => s.variations.length > 0).shift();
  }
}
const Pn = {
  HLS: "application/x-mpegURL",
  PROGRESSIVE: "video/mp4",
  MP4: "video/mp4",
  DASH: "application/dash+xml",
  WEBM: "video/webm",
  OGG: "video/ogg"
};
function Oo(A, e, i, r) {
  let s = A;
  const l = i, h = r, m = e, E = {
    DIVIDER: ue.DIVIDER,
    CLOSER: ue.CLOSER,
    OPENER: ue.OPENER
  };
  function S(se) {
    let me = [], W = {
      adParameters: null,
      creativeTrackers: {},
      duration: _t.FALLBACK_LINEAR_DURATION,
      icons: [],
      mediaFiles: [],
      supportedMediaFiles: [],
      skinDelay: NaN,
      type: ae.LINEAR,
      universalAdId: ["unknown", "unknown"]
    };
    for (let N in se)
      if (Object.prototype.hasOwnProperty.call(se, N) && Object.prototype.hasOwnProperty.call(Pn, N.toUpperCase())) {
        let O = se[N];
        if (typeof O == "string" && O.length > 0) {
          let L = {
            apiFramework: "",
            bitrate: 500,
            deliveryType: "progressive",
            fileURL: O,
            height: 360,
            id: "",
            isSIMID: !1,
            isVPAID: !1,
            maintainAspectRatio: !0,
            maxBitrate: 5e3,
            mimeType: Pn[N.toUpperCase()],
            minBitrate: 0,
            scalable: !0,
            width: 640
          };
          W.mediaFiles.push(L);
        }
      }
    return W.supportedMediaFiles = W.mediaFiles, me.push(W), me;
  }
  function M() {
    Object.keys(E).forEach((se) => {
      if (l && Object.prototype.hasOwnProperty.call(l, E[se])) {
        const me = l[E[se]];
        if (!m && !me.forcePlay)
          return;
        let W = {};
        W.adTrackers = [], W.creatives = S(me), W.id = W.adId = E[se], W.isLinear = !0, W.variant = E[se], W.properCreative = W.creatives[0], W.properCreative.selectedMediaFile = W.properCreative.supportedMediaFiles[0], W.config = h, W.enrichment = new Et(), W.adReinsertion = new le(h.adReinsertion, W.enrichment), W.expectedAdType = l.type, W.isPaused = !0;
        let N = [];
        switch (E[se]) {
          case E.DIVIDER:
            if (s.forEach((O, L) => {
              L > 0 && O.variant !== s[L - 1].variant && N.push({
                offset: L,
                ad: W
              });
            }), l[E[se]].forcePlay && N.length === 0) {
              s[0].variant === ue.SPONSORED ? s.unshift(W) : s.push(W);
              break;
            }
            N.forEach((O, L) => {
              const X = O.offset + L;
              s.splice(X, 0, O.ad);
            });
            break;
          case E.CLOSER:
            s.push(W);
            break;
          case E.OPENER:
            s.unshift(W);
            break;
        }
      }
    });
  }
  let Q = {
    totalCommercials: 0,
    totalClips: 0,
    totalPlayableClips: 0,
    totalPlayableCommercials: 0
  };
  function Z() {
    let se = 0, me = 0, W = 0;
    const N = s.length;
    s.forEach((O, L) => {
      O.variant === ue.COMMERCIAL ? (O.currentCommercial = me += 1, (O.fallbackOnNoAd || !O.fallbackOnNoAd) && O.hasError && (se += 1), O.currentPodSequencing = me - se) : (O.fallbackOnNoAd || !O.fallbackOnNoAd) && O.hasError && (W += 1), O.variant !== ue.COMMERCIAL && (O.currentCommercial = -1), O.sequence = L + 1, O.currentClip = L + 1;
    }), Q = {
      totalClips: N,
      totalPlayableClips: N - se - W,
      totalCommercials: me,
      totalPlayableCommercials: me - se
    };
  }
  return M(), Z(), { enrichedManifest: s, sequenceData: Q };
}
function wn(A) {
  let e = A;
  for (let i = 0; i < e.length; i++) {
    let s = e[i].extensions;
    s == null || s.forEach((l) => {
      typeof l.extensionXML == "string" && (l.extensionXML = new DOMParser().parseFromString(l.extensionXML, "application/xml").getElementsByTagName("Extension").item(0));
    });
  }
  return e;
}
class To {
  constructor(e, i, r, s) {
    this.adBreak = s, this.adList = e, this.adSlotBuffetList = [], this.adSlotModelList = [], this.config = i, this.environmentVars = r, this.NAME = "AdSltModGen::", this.decorateAdList(), this.createAdSlotModel(), this.extendWithSeparationClips(), wn(this.adSlotModelList), this.adSlotBuffetList = wn(this.adSlotBuffetList), c.debug.info(this.NAME + "adPod", this.adSlotModelList), c.debug.info(this.NAME + "adBuffet", this.adSlotBuffetList);
  }
  /** @internal */
  applyBuffetAd() {
    if (this.adSlotBuffetList.length > 0) {
      let e = this.adSlotModelList.filter((i) => i).sort(this.bySequence).reverse();
      for (let i = e.length - 1; i >= 0; i--) {
        const r = e[i];
        if (r.fallbackOnNoAd && this.adSlotBuffetList.length > 0) {
          let s = this.adSlotBuffetList.shift();
          s.sequence = r.sequence + 0.1, this.adSlotModelList.splice(r.sequence - 1, 0, s);
        }
      }
    }
  }
  /** @internal */
  decorateAdList() {
    this.adList.forEach((e) => {
      if (e.adBreakPosition = this.adBreak.adBreakPosition, e.config = this.config, e.enrichment = new Et(), e.enrichment.setFromObject(e.publisherMacros), e.expectedAdType = this.adBreak.type, e.publisherMacros = this.environmentVars.vastMacros, e.adReinsertion = new le(e.config.adReinsertion, e.enrichment), e.isPaused = !0, !e.hasError) {
        if (e.creatives.length < 1) {
          e.error = {}, e.error = w.WRAPPER.NO_RESPONSE;
          return;
        }
        if (e.expectedAdType === ae.LINEAR && e.creativeClass.linearAsArray[0].mediaFiles.length === 0 || e.expectedAdType === ae.NON_LINEAR && e.creativeClass.nonLinear.length === 0) {
          e.error = {}, e.error = w.CREATIVE.EXPECTED_DIFFERENT_LINEARITY;
          return;
        }
        e.expectedAdType === ae.LINEAR ? (e.properCreative = Pi.getProperCreative(
          e.creativeClass.linearAsArray,
          this.environmentVars
        ), e.properCreative && (e.closedCaptions = e.properCreative.captions, e.icons = e.properCreative.icons)) : e.properCreative = Pi.getProperCreative(
          e.creativeClass.nonLinear,
          this.environmentVars
        ), e.properCreative || (e.error = {}, e.error = w.VAST.UNSUPPORTED_MIMETYPE);
      }
    });
  }
  /** @internal */
  createAdSlotModel() {
    this.getPodAdList().length > 0 ? (this.adSlotModelList = this.getPodAdList(), this.adSlotBuffetList = this.getBuffetAdList(), this.hasPlayableAds || this.applyBuffetAd()) : (this.adSlotModelList = this.adList, this.adSlotBuffetList = []);
  }
  /** @internal */
  extendWithSeparationClips() {
    if (this.adBreak.type !== ae.LINEAR)
      return;
    const {
      enrichedManifest: e,
      sequenceData: i
    } = Oo(
      this.adSlotModelList,
      this.hasPlayableAds,
      this.adBreak,
      this.config
    );
    this.adSlotModelList = e, this.sequenceInfo = i;
  }
  /**
   * We deliver ads that are either playable or at least trackable. So both states are considered valid.
   *
   * @returns {boolean} Whether we have found one or more deliverable ads.
   */
  /** @internal */
  get hasValidAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError || i.hasError).shift();
  }
  /**
   * The separation clip feature is applied to all adSlots that have at least one playable ad.
   * Note that playable doesn't include trackable ads!
   *
   * @returns {boolean} Whether we have found one or more playable ads.
   */
  get hasPlayableAds() {
    return !!this.adSlotModelList.filter((i) => !i.hasError).shift();
  }
  get hasSessionTimeoutError() {
    return this.adList.some((e) => e.adXML && e.adXML.querySelector(`ParserError[code="${w.SESSION.TIMEOUT.code}"]`));
  }
  get adSlotModel() {
    return this.adSlotModelList;
  }
  get adSlotBuffet() {
    return this.adSlotBuffetList;
  }
  get sequenceData() {
    return this.sequenceInfo;
  }
  /** @internal */
  getPodAdList() {
    return this.adList.filter((e) => !isNaN(e.sequence)).sort(this.bySequence);
  }
  /** @internal */
  getBuffetAdList() {
    return this.adList.filter((e) => {
      const i = isNaN(e.sequence) && this.environmentVars.prefetchBuffetAds, r = isNaN(e.sequence) && !this.environmentVars.prefetchBuffetAds && !e.hasError;
      return i || r;
    });
  }
  // sort ads by ascending sequence number
  /** @internal */
  bySequence(e, i) {
    return e.sequence - i.sequence;
  }
}
const Rr = class Rr {
  constructor(e) {
    this.adReinsertion = e.adReinsertion, this.adSlotTimeout = e.timeouts.adSlotRequest * 1e3, this.blockInsecureURL = e.blockInsecureURL || !1, this.callbackOnDoneLoading = null, this.hasSessionTimeoutError = !1, this.initialTimestamp = Date.now().toString(), this.maxWrapperDepth = e.maxWrapperDepth, this.urlHandlerOptions = e, this.wrapperChainTimeout = e.timeouts.adRequestChain * 1e3, this.NAME = "AdTagSvc", this.XMLsToLoad = 0, this.XMLDoc = null, e.adRequestObserver.requestTime = Date.now();
  }
  /**
   * Takes XML document and fetches all the URLs
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @param XMLDoc
   * @param callbackOnDoneLoading
   * @returns {*|Promise<unknown>}
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestFinalXML(e, i) {
    this.callbackOnDoneLoading = i, this.requestXML(e);
  }
  /* c8 ignore start - no unitTests */
  /**
   * Takes URL and loads all wrappers, if needed
   * On resolve the final XMLDoc of the aggregated files will be returned
   * @returns {*|Promise<unknown>}
   * @param url
   * @param callbackOnDoneLoading
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  requestURL(e, i) {
    this.callbackOnDoneLoading = i, this.initialTimestamp = Date.now().toString(), this.loadURL(e).then((r) => (this.saveInitialURLToTag(e, r), this.saveInitialTimestampToTag(this.initialTimestamp, Date.now().toString(), r), this.requestXML(r)));
  }
  /* c8 ignore stop */
  /** @internal */
  requestXML(e) {
    this.XMLDoc = e, this.loadAllWrapperURLs(() => {
      --this.XMLsToLoad <= 0 && this.onAllAdWrappersWalked();
    });
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  loadAllWrapperURLs(e) {
    if (this.XMLDoc !== null && typeof this.XMLDoc.querySelectorAll == "function") {
      let i = this.XMLDoc.querySelectorAll("VASTAdTagURI");
      if (this.XMLsToLoad = i.length, this.XMLsToLoad === 0) {
        e();
        return;
      }
      for (let r = 0; r < this.XMLsToLoad; r++) {
        let l = (i[r].textContent || "").trim();
        this.walkDownAdWrappers(
          l,
          0,
          i[r].parentNode,
          Date.now()
        ).then(() => {
          e();
        }).catch((h) => {
          e(h);
        });
      }
    }
  }
  /** @internal */
  walkDownAdWrappers(e, i, r, s) {
    return new Promise((l, h) => {
      let m = r.querySelector("VASTAdTagURI");
      if (m.setAttribute("_loadStart", Date.now().toString()), m.setAttribute("_loadEnd", Date.now().toString()), Date.now() - s > this.wrapperChainTimeout)
        return He(r, w.WRAPPER.CHAIN_TIMEOUT), h(), e;
      if (i >= this.maxWrapperDepth)
        return He(
          r,
          w.WRAPPER.LIMIT_REACHED
        ), h(), e;
      if (this.isInsecureURL(e))
        return He(r, w.SESSION.MIXED_CONTENT), h(), e;
      if (this.hasSessionTimeoutError)
        return h(), e;
      let E, S;
      this.loadURL(e, !0).then((M) => {
        let Q = M.querySelector("VASTAdTagURI");
        E = ((Q || {}).textContent || "").trim(), E && (S = Q.parentNode), this.addContentToWrapperNode(r, M), m.setAttribute("_loadEnd", Date.now().toString()), l([E, S]);
      });
    }).then((l) => {
      let [h, m] = l;
      return h ? this.walkDownAdWrappers(h, i + 1, m, s) : e;
    });
  }
  /** @internal */
  onAllAdWrappersWalked() {
    this.callbackOnDoneLoading(this.XMLDoc);
  }
  /** @internal */
  loadURL(e, i = !1) {
    return this.urlHandlerOptions.response = null, this.urlHandlerOptions.isWrapper = i, new Promise((r) => {
      new yr().get(e, (s, l) => {
        if (Date.now() - parseInt(this.initialTimestamp, 10) > this.adSlotTimeout) {
          let h = l || document.createDocumentFragment(), m = h.querySelector("Ad") || h.documentElement || h;
          this.hasSessionTimeoutError = !0, He(m, w.SESSION.TIMEOUT), this.adReinsertion.setReinsertionReason({
            reason: le.REASON.AD_SLOT_TIMEOUT,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && l.querySelector("parsererror")) {
          let h = document.createDocumentFragment();
          He(h, w.XML.INVALID_XML), this.adReinsertion.setReinsertionReason({
            reason: le.REASON.XML_PARSING_ERROR,
            xmlResponse: l
          }), r(h);
        }
        if (!s && l && l.documentElement.nodeName.toUpperCase() === "VAST") {
          const h = l.querySelector("VAST");
          if (h && h.querySelectorAll(":scope > *").length === 0) {
            let m = document.createDocumentFragment();
            He(m, w.WRAPPER.NO_RESPONSE), r(m);
          }
        }
        if (s && !l) {
          let h = document.createDocumentFragment();
          c.debug.warn(
            this.NAME + " XHR Request Error",
            s.code,
            s.description
          ), He(h, s), r(h);
        } else
          r(l);
      }, this.urlHandlerOptions);
    });
  }
  /* c8 ignore start - no unitTests */
  /** @internal */
  isInsecureURL(e) {
    return this.blockInsecureURL && !jn(e);
  }
  /* c8 ignore stop */
  /** @internal */
  setAttributeToTag(e, i, r) {
    if (r) {
      let s = r.querySelector("VAST");
      s && s.setAttribute(e, i);
    }
  }
  /** @internal */
  saveInitialURLToTag(e, i) {
    this.setAttributeToTag("_initialURL", e, i);
  }
  /** @internal */
  saveInitialTimestampToTag(e, i, r) {
    this.setAttributeToTag("_loadStart", e, r), this.setAttributeToTag("_loadEnd", i, r);
  }
  /** @internal */
  addContentToWrapperNode(e, i) {
    let r = document.createElement("_VASTAdTagURIContent");
    r.appendChild(i.firstElementChild), e.appendChild(r);
  }
};
Rr.EVENT = {
  PARSED: "AdTagService::parsed"
};
let Er = Rr;
class Vn {
  // to not leak currentAd into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - use 'that' instead of 'this' in the getters
  // - mind to use commas between getters
  constructor(e) {
    if (!e)
      return {};
    function i(h, m) {
      const E = e[h];
      return !E || E.length <= 0 ? (c.debug.info(m), []) : E;
    }
    const r = (h, m) => {
      const E = e.creatives;
      if (E && E.length !== 0) {
        const S = E.find(
          (M) => M.type === h
        );
        if (S && S.variations && S.variations.length > 0)
          return S.variations;
      }
      return c.debug.info(m), [];
    };
    function s(h) {
      return h.charAt(0).toUpperCase() + h.slice(1);
    }
    const l = (h) => {
      var E, S;
      if (e.isLinear) {
        const M = e.properCreative && e.properCreative.selectedMediaFile;
        return M ? M[h] : -1;
      }
      const m = (S = (E = e.creativesArray) == null ? void 0 : E.nonLinearCreative[0]) == null ? void 0 : S.variations[0];
      if (m && e.isExpanded) {
        const M = `expanded${s(h)}`;
        return m[M] === -1 ? m[h] : m[M];
      }
      return m ? m[h] : -1;
    };
    return {
      /**
       * @returns {string|null} An ad server-defined identifier string for the ad.
       */
      get adId() {
        return e.adXML ? e.id : null;
      },
      /**
       * Provide the ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} adId(s) of the ad creative node(s) in the creatives node.
       */
      get adIds() {
        return e.adXML ? e.adIds : [null];
      },
      /**
       * @return {string|null} a unique or pseudo-unique (long enough to be unique when combined with
       * timestamp data) GUID
       */
      get adServingId() {
        return e.adXML ? e.adServingId : null;
      },
      /**
       * The value of this property is an Array that provides ad verifications for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_AD_VERIFICATIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<AdVerification>} List of all ad verifications.
       */
      get adVerifications() {
        return i("adVerifications", "There are no ad verifications along with this ad.");
      },
      /**
       * The value of this property is an Array that provides closed captions for the `<MediaFile>` element.
       * The video player should request this value whenever it receives the **ON_CLOSED_CAPTIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<ClosedCaption>} List of all closed captions.
       */
      get closedCaptions() {
        return i("closedCaptions", "There are no Closed Captions along with this ad.");
      },
      /**
       * The value of this property is an Array that provides ad companion details for each `<CompanionAd>`
       *  element. The video player should request this value whenever it receives the `ON_COMPANIONS_DETECTED`
       *  event.
       *
       * @returns {Array.<CompanionAd>} List of all companion ads.
       */
      get companions() {
        return r(ni.COMPANION, "There are no companions available.");
      },
      /**
       * Retrieves the creative identifiers for the current ad.
       * @returns {CreativeIds} An object containing the IDs of the creative nodes.
       * @property CreativeIds.adId - The unique ad server identifiers for the creative nodes.
       * @property CreativeIds.id - The ad server-defined identifiers for the creative nodes.
       */
      get creativeIds() {
        function h(E, S) {
          return S === 0 || !E.parentElement ? E : h(E.parentElement, S - 1);
        }
        function m(E) {
          const S = h(E, 3), M = S.getAttributeNames().find((Q) => Q.toLowerCase() === "adid");
          return {
            adId: S.getAttribute(M) || null,
            id: S.getAttribute("id")
          };
        }
        if (e.isLinear && e.adXML) {
          let E = null;
          if (e.isSIMID ? E = "InteractiveCreativeFile" : e.isVPAID ? E = 'MediaFile[type="application/javascript"]' : e.properCreative && e.properCreative.selectedMediaFile && (E = `MediaFile[bitrate="${e.properCreative.selectedMediaFile.bitrate}"]`), E) {
            const S = e.adXML.querySelector(E);
            return m(S);
          }
        } else if (e.properCreative && e.properCreative.variations) {
          const E = e.properCreative.variations[0].selectedResource.type, S = e.properCreative.variations[0].selectedResource.creativeType, M = e.adXML.querySelector(
            `${E}[creativeType="${S}"]`
          );
          return m(M);
        }
        return null;
      },
      get currentTime() {
        return e.currentTime || -1;
      },
      get duration() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.creativesArray.nonLinearCreative[0].variations[0].displayDuration : e.duration;
      },
      /**
       * Requests details about the most recent error that has occurred with the current ad.
       * @returns {AdError} Description object of the most recent ad error
       */
      get error() {
        return !e.error || !e.error.code ? (c.debug.info("The ad seems to have no error."), {
          code: -1,
          timestamp: Date.now(),
          message: "No error."
        }) : {
          code: e.error.code,
          timestamp: Date.now(),
          message: e.error.message
        };
      },
      /**
       * The value of this property is an Array that provides ad extension details for the
       *  `<Extensions>` element.
       * The video player should request this value whenever it receives the **ON_EXTENSIONS_DETECTED**
       *  add-on event.
       * @returns {Array.<Extension>} List of all extensions.
       */
      get extensions() {
        return i("extensions", "There is no VAST extension available.");
      },
      /**
       * Returns whether the current ad has a ClickThrough target (URL) or not.
       * Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.
       * @returns {boolean} - true if the current ad contains a ClickThrough URL.
       */
      get hasClickThrough() {
        if (e.isLinear)
          return !!e.clickThroughURL;
        try {
          return !!e.properCreative.variations[0].clickThroughURL && e.properCreative.variations[0].resources[0].type !== "IFrameResource";
        } catch (h) {
          return !1;
        }
      },
      get height() {
        return l("height");
      },
      /**
       * The value of this property is an Object that provides ad icon details for the `<Icon>` element.
       * The video player should request this value whenever it receives the **ON_ICONS_DETECTED** add-on event.
       * @returns { { [key: string]: IconProgram } | {} } Object of all industry icons.
       */
      get icons() {
        return !e.icons || Object.keys(e.icons).length <= 0 ? (c.debug.info("There are no Industry Icons along with this ad."), {}) : e.icons;
      },
      /**
       * Ad server’s unique identifier for the creative.
       * @returns {Array<string|null>} id(s) of the ad creative node(s) in the creatives node.
       */
      get ids() {
        return e.adXML ? e.ids : [null];
      },
      get isExpanded() {
        return e.isExpanded || !1;
      },
      /**
       * Returns whether the current ad is interactive (most likely by using __VPAID__) or not.
       * @returns {boolean} - true if the current ad has been specified as interactive.
       */
      get isInteractive() {
        return e.isInteractive || !1;
      },
      get isLinear() {
        return e.isLinear;
      },
      /**
       * Note: Up to version 4.x the `isSkippable` flag was used to check whether the ad can be skipped, depending
       * on the current progress. The following conditions must have been met:
       *  - the ad has specified a `skipoffset`
       *  - the parsed time of `skipoffset` is equal or greater than 0 seconds
       *  - the current playhead time is equal or greater than the `skipoffset`
       *
       * @returns {boolean} - true if the current Linear has attribute skipoffset.
       */
      get isSkippable() {
        return e.isSkippable;
      },
      /**
       * The value of this property is an Object that provides the linear ad detail for the current `<Linear>`
       *  element.
       * @returns { AdCreative | {}} with details about the linear ad.
       */
      get linear() {
        const h = e.properCreative;
        return h && h.length !== 0 ? h : (c.debug.info("There are no linear ads available."), {});
      },
      /**
       * The list outlines the various VAST macros and their current values.
       * @returns { [key: string]: any } Snapshot of the VAST Macros.
       */
      get macroList() {
        return e.enrichment ? e.enrichment.getMacroList() : {};
      },
      /**
       * The value of this property is an Array that provides ad nonLinear details for each `<NonLinearAds>`
       *  element.
       *
       * @returns {Array.<NonLinearAds>} List of all nonLinear ads.
       */
      get nonLinear() {
        return r(ni.NON_LINEAR, "There are no nonLinearAds available.");
      },
      get remainingTime() {
        var h;
        return !e.isLinear && ((h = e.creativesArray) != null && h.nonLinearCreative.length) ? e.duration - e.currentTime : e.remainingTime || e.duration || -1;
      },
      /**
       * @returns {number} Representing the playback time after a linear ad can be skipped. Defaulting to -1, not
       *  skippable.
       */
      get skipOffset() {
        return e.skipOffset;
      },
      /**
       * @returns {string|null} Title for the ad, defined by the ad serving party.
       */
      get title() {
        return e.title;
      },
      /**
       * @returns {string} The type of ad as specified by the ad-server (since VAST 4.1)
       */
      get type() {
        return e.adType;
      },
      /**
       * Note: VAST 4.0 had an attribute “idValue” that was a duplicate of the node value and so was removed as of
       *  4.1. Media players should not fail if this attribute is present, but should always use the Content as
       *  the source of truth for the creative ID value
       *
       * Content/"idValue" A string identifying the unique creative identifier.
       * Default value is “unknown” idRegistry*A string used to identify the URL for the registry website
       *  where the unique creative ID is cataloged. Default value is “unknown.
       *
       * _*Note:* Nulll is only the case if it is a request in the separationClip case._
       * @returns {Object | null} UniversalAdId
       */
      get universalAdId() {
        return e.adXML ? e.universalAdId : null;
      },
      /**
       * VAST 4.2 allows multiple UniversalAdId nodes to be provided
       *
       * _*Note:* Null is only the case if it is a request in the separationClip case._
       * @returns {Array | null} List of all Universal Ad IDs
       */
      get universalAdIds() {
        return e.adXML ? e.universalAdIds : null;
      },
      /**
       * @returns {string} variant of the ad (closer, divider, commercial, sponsored, opener).
       */
      get variant() {
        return e.variant;
      },
      /**
       * The value of this property is an Array that provides details for each `<Verification>` element.
       * The video player may request this value whenever it receives the **ON_VERIFICATIONS_DETECTED** add-on
       *  event, depending on whether the player takes care of the Open Measurement.
       * @returns {Array.<AdVerification>} List of all ad verification vendors (if configured, whitelisted
       *  vendors only)
       */
      get verifications() {
        return i("adVerifications", "There is no AdVerification vendor available.");
      },
      /**
       * Contains information about the visibility status, the corresponding threshold value and the
       * current visibility value.
       * @returns {Object} Overview about the status of visibility.
       */
      get viewability() {
        return e.viewability ? e.viewability : {};
      },
      set volume(h) {
        e.volume = h;
      },
      get volume() {
        return e.volume || -1;
      },
      get width() {
        return l("width");
      },
      /**
       * The value of this property is an Array of Objects whereas each Object represents the details for a
       *  Wrapper response. The video player may request this value whenever it requires more insights to a chain
       *  of ad server responses.
       * @returns {Array.<Object>} List of Wrapper objects, starting with the initial request up to the last
       *  Wrapper before the Inline tag.
       */
      get wrappers() {
        return i("wrappers", "The ad was not part of a wrapper chain.");
      }
    };
  }
}
class Ro {
  // to not leak the adSlot into public available API we have to define it in this "closure"
  // as with ES6 there's no good way to keep variables private yet
  // neither weakmaps nor symbols really help
  // pitfalls:
  // - mind to use commas between getters
  constructor(e, i) {
    return e.currentAd ? {
      /**
       * @returns {number} - of the current clip.
       */
      get currentClip() {
        return e.currentAd.currentClip;
      },
      /**
       * @returns {number} - of the current commercial.
       */
      get currentCommercial() {
        return e.currentAd.currentCommercial;
      },
      /**
       * @returns {number} - of the total commercials.
       */
      get totalCommercials() {
        return i.totalCommercials;
      },
      /**
       * @returns {number} - of the total time of commercials played.
       */
      get totalCommercialsCurrentTime() {
        return e.adSlotTimes.totalCommercialsCurrentTime;
      },
      /**
       * @returns {number} - of the total duration of playable commercials.
       */
      get totalCommercialsDuration() {
        return e.adSlotTimes.totalCommercialsDuration;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalClips() {
        return i.totalClips;
      },
      /**
       * @returns {number} - of the total playable clips.
       */
      get totalPlayableClips() {
        return i.totalPlayableClips + (e.manifest.replaced || 0);
      },
      /**
       * @returns {number} - of the total playable commercials.
       */
      get totalPlayableCommercials() {
        return i.totalPlayableCommercials + (e.manifest.replaced || 0);
      }
    } : {};
  }
}
class $n {
  /**
   * Creates an instance of TCFAPIBase.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   * @param {number} version - The version of the TCFAPI.
   */
  constructor(e, i, r) {
    this.consentAPI = e, this.callback = i, this.consentDataInfo = void 0, this.gdprAppliesBoolean = void 0, this.version = r, this.NAME = "TCFAPI::", c.debug.warn(`${this.NAME}Ctor - api found at`, this.consentAPI);
  }
  /**
   * Retrieves consent data using the specified API method.
   * @param {string} apiMethodName - The name of the API method to be called.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  getConsent(e, i) {
    this.consentAPI(e, this.version, (r) => {
      this.onConsentData(r, i);
    });
  }
  /**
   * Callback function triggered on consent data retrieval.
   * @param {any} eventData - The event data received from the consent API.
   * @param {string} eventDataKey - The key to extract consent data from the received event data.
   */
  onConsentData(e, i) {
    this.consentDataInfo = e[i], this.gdprAppliesBoolean = e.gdprApplies, c.debug.info(`${this.NAME}onConsentData, eventData:`, e), this.callback();
  }
  /**
   * Getter for consent data.
   * @type {undefined | string}
   */
  get consentData() {
    return this.consentDataInfo;
  }
  /**
   * Getter for GDPR applies boolean.
   * @type {undefined | boolean}
   */
  get gdprApplies() {
    return this.gdprAppliesBoolean;
  }
}
class No extends $n {
  /**
   * Creates an instance of TCFAPI__CMP.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 1);
  }
  /**
   * Retrieves consent data using the 'getConsentData' method.
   */
  getConsent() {
    super.getConsent("getConsentData", "consentData");
  }
}
class Co extends $n {
  /**
   * Creates an instance of TCFAPI__TCF.
   * @param {any} apiRef - The reference to the consent API.
   * @param {Function} onConsentCallback - The callback function to be invoked on consent data retrieval.
   */
  constructor(e, i) {
    super(e, i, 2);
  }
  /**
   * Retrieves consent data with the first addEventListener method for version 2.2, if no result, try 'getTCData'
   * method for version 2.0.
   */
  getConsent() {
    super.getConsent("addEventListener", "tcString"), this.consentData === void 0 && super.getConsent("getTCData", "tcString");
  }
}
class _o {
  constructor(e) {
    this.enrichment = e, this.NAME = "TCFAPI::";
    try {
      const i = window.top;
      i && (this.tcfAPI = i.__tcfapi, this.cmpAPI = i.__cmp);
    } catch (i) {
      c.debug.warn(`${this.NAME}Ctor No window?`, i);
    }
    this.hasTCF() ? this.api = new Co(this.tcfAPI, this.setMacro.bind(this)) : this.hasCMP() && (this.api = new No(this.cmpAPI, this.setMacro.bind(this))), this.api ? this.api.getConsent() : c.debug.warn(`${this.NAME}Ctor Site w/o API support`);
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  isFunction(e) {
    return typeof e == "function";
  }
  get consentData() {
    return (this.api || {}).consentData;
  }
  get gdprApplies() {
    return (this.api || {}).gdprApplies;
  }
  hasTCF() {
    return this.isFunction(this.tcfAPI);
  }
  hasCMP() {
    return this.isFunction(this.cmpAPI);
  }
  setMacro() {
    c.debug.info(
      `${this.NAME}setMacro consentData`,
      this.api.consentData,
      "gdprApplies",
      this.api.gdprApplies
    ), this.enrichment && this.api.gdprApplies && (this.enrichment.set("GDPRCONSENT", this.api.consentData), this.enrichment.set("REGULATIONS", "GDPR"));
  }
}
function Or(A) {
  if (typeof A != "object" || A === null)
    return A;
  const e = /* @__PURE__ */ Object.create(null);
  for (const i of Object.keys(A)) {
    const r = A[i];
    Bn(r) || (e[i] = Or(A[i]));
  }
  return e;
}
function Do(A) {
  const e = document.implementation.createDocument(null, "VAST", null);
  return e.documentElement.setAttribute("version", "3.0"), A.forEach((i) => {
    const r = e.createElement("Ad"), s = e.createElement("Wrapper"), l = e.createElement("VASTAdTagURI");
    l.appendChild(e.createTextNode(i)), s.appendChild(l), r.appendChild(s), e.documentElement.appendChild(r);
  }), e;
}
function Lo(A) {
  let e = A;
  if (e.originConfig = Or(A), Array.isArray(e.tag) ? e.urls = e.tag : e.urls = e.tag ? [e.tag] : [], e.response && (e.responseXML = new DOMParser().parseFromString(e.response, "text/xml")), e.repeat = e.repeat && e.repeat > 1 ? e.repeat : 1, e.repeat > 1) {
    let i = e.urls[0];
    e.urls = [];
    for (let r = 0; r < e.repeat; r++)
      e.urls.push(i.replace("[count]", (r + 1).toString()));
  }
  return e.urls.length > 0 && !e.responseXML && (e.responseXML = Do(e.urls)), e.requested = !1, e;
}
const xn = "AdBreakValidation";
function Mo(A) {
  var s, l;
  if (!A || typeof A != "object" || Array.isArray(A) || Object.keys(A).length === 0)
    return c.debug.warn(xn + ": Setup Error: No adBreak definition."), !1;
  const e = (typeof A.tag == "string" || Array.isArray(A.tag)) && A.tag.length > 0, i = ((l = (s = A.response) == null ? void 0 : s.length) != null ? l : 0) > 0, r = A[ue.CLOSER] || A[ue.DIVIDER] || A[ue.OPENER];
  return !e && !i && !r ? (c.debug.warn(xn + ": Incomplete setup: No tag, response or separationClip provided."), !1) : !0;
}
function bo(A, e, i, r, s) {
  var l = l || {};
  (function(h) {
    var m = {
      globalConfig: A,
      clientConfig: e,
      clientAPIs: i,
      utilsReady: r,
      onFailure: s
    };
    (function() {
      function E(N) {
        N = [typeof globalThis == "object" && globalThis, N, typeof window == "object" && window, typeof self == "object" && self, typeof global == "object" && global];
        for (var O = 0; O < N.length; ++O) {
          var L = N[O];
          if (L && L.Math == Math) return L;
        }
        throw Error("Cannot find global object");
      }
      var S = E(this);
      function M(N) {
        var O = 0;
        return function() {
          return O < N.length ? { done: !1, value: N[O++] } : { done: !0 };
        };
      }
      var Q = typeof Object.defineProperties == "function" ? Object.defineProperty : function(N, O, L) {
        return N == Array.prototype || N == Object.prototype || (N[O] = L.value), N;
      };
      function Z(N, O) {
        if (O) e: {
          var L = S;
          N = N.split(".");
          for (var X = 0; X < N.length - 1; X++) {
            var Y = N[X];
            if (!(Y in L)) break e;
            L = L[Y];
          }
          N = N[N.length - 1], X = L[N], O = O(X), O != X && O != null && Q(L, N, { configurable: !0, writable: !0, value: O });
        }
      }
      Z("Symbol", function(N) {
        function O(Y) {
          if (this instanceof O) throw new TypeError("Symbol is not a constructor");
          return new L("jscomp_symbol_" + (Y || "") + "_" + X++, Y);
        }
        function L(Y, K) {
          this.j = Y, Q(this, "description", { configurable: !0, writable: !0, value: K });
        }
        if (N) return N;
        L.prototype.toString = function() {
          return this.j;
        };
        var X = 0;
        return O;
      }), Z("Symbol.iterator", function(N) {
        if (N) return N;
        N = Symbol("Symbol.iterator");
        for (var O = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), L = 0; L < O.length; L++) {
          var X = S[O[L]];
          typeof X == "function" && typeof X.prototype[N] != "function" && Q(X.prototype, N, { configurable: !0, writable: !0, value: function() {
            return se(M(this));
          } });
        }
        return N;
      });
      function se(N) {
        return N = { next: N }, N[Symbol.iterator] = function() {
          return this;
        }, N;
      }
      function me(N) {
        var O = typeof Symbol != "undefined" && Symbol.iterator && N[Symbol.iterator];
        return O ? O.call(N) : { next: M(N) };
      }
      function W(N, O) {
        return Object.prototype.hasOwnProperty.call(N, O);
      }
      Z("WeakMap", function(N) {
        function O(T) {
          if (this.h = (D += Math.random() + 1).toString(), T) {
            T = me(T);
            for (var P; !(P = T.next()).done; ) P = P.value, this.set(P[0], P[1]);
          }
        }
        function L() {
        }
        function X(T) {
          var P = typeof T;
          return P === "object" && T !== null || P === "function";
        }
        function Y(T) {
          if (!W(T, U)) {
            var P = new L();
            Q(T, U, { value: P });
          }
        }
        function K(T) {
          var P = Object[T];
          P && (Object[T] = function(j) {
            return j instanceof L ? j : (Object.isExtensible(j) && Y(j), P(j));
          });
        }
        if (function() {
          if (!N || !Object.seal) return !1;
          try {
            var T = Object.seal({}), P = Object.seal({}), j = new N([[T, 2], [P, 3]]);
            return j.get(T) != 2 || j.get(P) != 3 ? !1 : (j.delete(T), j.set(P, 4), !j.has(T) && j.get(P) == 4);
          } catch (J) {
            return !1;
          }
        }()) return N;
        var U = "$jscomp_hidden_" + Math.random();
        K("freeze"), K("preventExtensions"), K("seal");
        var D = 0;
        return O.prototype.set = function(T, P) {
          if (!X(T)) throw Error("Invalid WeakMap key");
          if (Y(T), !W(T, U)) throw Error("WeakMap key fail: " + T);
          return T[U][this.h] = P, this;
        }, O.prototype.get = function(T) {
          return X(T) && W(T, U) ? T[U][this.h] : void 0;
        }, O.prototype.has = function(T) {
          return X(T) && W(
            T,
            U
          ) && W(T[U], this.h);
        }, O.prototype.delete = function(T) {
          return X(T) && W(T, U) && W(T[U], this.h) ? delete T[U][this.h] : !1;
        }, O;
      }), Z("Map", function(N) {
        function O() {
          var D = {};
          return D.c = D.next = D.head = D;
        }
        function L(D, T) {
          var P = D.b;
          return se(function() {
            if (P) {
              for (; P.head != D.b; ) P = P.c;
              for (; P.next != P.head; ) return P = P.next, { done: !1, value: T(P) };
              P = null;
            }
            return { done: !0, value: void 0 };
          });
        }
        function X(D, T) {
          var P = T && typeof T;
          P == "object" || P == "function" ? K.has(T) ? P = K.get(T) : (P = "" + ++U, K.set(T, P)) : P = "p_" + T;
          var j = D.g[P];
          if (j && W(D.g, P)) for (D = 0; D < j.length; D++) {
            var J = j[D];
            if (T !== T && J.key !== J.key || T === J.key) return { id: P, list: j, index: D, a: J };
          }
          return {
            id: P,
            list: j,
            index: -1,
            a: void 0
          };
        }
        function Y(D) {
          if (this.g = {}, this.b = O(), this.size = 0, D) {
            D = me(D);
            for (var T; !(T = D.next()).done; ) T = T.value, this.set(T[0], T[1]);
          }
        }
        if (function() {
          if (!N || typeof N != "function" || !N.prototype.entries || typeof Object.seal != "function") return !1;
          try {
            var D = Object.seal({ x: 4 }), T = new N(me([[D, "s"]]));
            if (T.get(D) != "s" || T.size != 1 || T.get({ x: 4 }) || T.set({ x: 4 }, "t") != T || T.size != 2) return !1;
            var P = T.entries(), j = P.next();
            return j.done || j.value[0] != D || j.value[1] != "s" ? !1 : (j = P.next(), !(j.done || j.value[0].x != 4 || j.value[1] != "t" || !P.next().done));
          } catch (J) {
            return !1;
          }
        }()) return N;
        var K = /* @__PURE__ */ new WeakMap();
        Y.prototype.set = function(D, T) {
          D = D === 0 ? 0 : D;
          var P = X(this, D);
          return P.list || (P.list = this.g[P.id] = []), P.a ? P.a.value = T : (P.a = { next: this.b, c: this.b.c, head: this.b, key: D, value: T }, P.list.push(P.a), this.b.c.next = P.a, this.b.c = P.a, this.size++), this;
        }, Y.prototype.delete = function(D) {
          return D = X(this, D), D.a && D.list ? (D.list.splice(D.index, 1), D.list.length || delete this.g[D.id], D.a.c.next = D.a.next, D.a.next.c = D.a.c, D.a.head = null, this.size--, !0) : !1;
        }, Y.prototype.clear = function() {
          this.g = {}, this.b = this.b.c = O(), this.size = 0;
        }, Y.prototype.has = function(D) {
          return !!X(this, D).a;
        }, Y.prototype.get = function(D) {
          return (D = X(this, D).a) && D.value;
        }, Y.prototype.entries = function() {
          return L(this, function(D) {
            return [D.key, D.value];
          });
        }, Y.prototype.keys = function() {
          return L(this, function(D) {
            return D.key;
          });
        }, Y.prototype.values = function() {
          return L(this, function(D) {
            return D.value;
          });
        }, Y.prototype.forEach = function(D, T) {
          for (var P = this.entries(), j; !(j = P.next()).done; ) j = j.value, D.call(T, j[1], j[0], this);
        }, Y.prototype[Symbol.iterator] = Y.prototype.entries;
        var U = 0;
        return Y;
      }), Z("Object.is", function(N) {
        return N || function(O, L) {
          return O === L ? O !== 0 || 1 / O === 1 / L : O !== O && L !== L;
        };
      }), Z("Array.prototype.includes", function(N) {
        return N || function(O, L) {
          var X = this;
          X instanceof String && (X = String(X));
          var Y = X.length;
          for (L = L || 0, 0 > L && (L = Math.max(L + Y, 0)); L < Y; L++) {
            var K = X[L];
            if (K === O || Object.is(K, O)) return !0;
          }
          return !1;
        };
      }), Z("String.prototype.includes", function(N) {
        return N || function(O, L) {
          if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
          if (O instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
          return (this + "").indexOf(O, L || 0) !== -1;
        };
      }), Z("Array.from", function(N) {
        return N || function(O, L, X) {
          L = L != null ? L : function(D) {
            return D;
          };
          var Y = [], K = typeof Symbol != "undefined" && Symbol.iterator && O[Symbol.iterator];
          if (typeof K == "function") {
            O = K.call(O);
            for (var U = 0; !(K = O.next()).done; ) Y.push(L.call(X, K.value, U++));
          } else for (K = O.length, U = 0; U < K; U++) Y.push(L.call(X, O[U], U));
          return Y;
        };
      }), function() {
        function N() {
          this.f = {}, this.global = {}, this.client = {}, this.i = {};
        }
        function O() {
          return "abcdef123456789abcdef123456789abcdef123456789".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, 40);
        }
        function L(U) {
          return U == "True" || U == "true" || U == 1 || U == "1" || U == 1;
        }
        function X() {
          var U = function() {
            var j = (navigator.appCodeName + navigator.appName + navigator.appVersion + navigator.userAgent + navigator.platform + (navigator.language || navigator.m || "x")).split(" ").join(""), J = Math.max(Math.round(Date.now() / 1e3 / 60), Math.round((Date.now() / 1e3 + 10) / 60)).toString(), Te = j.slice(0, j.length / 2).split("").reverse().join("");
            return j = j.slice(j.length / 2).split("").reverse().join(""), J + Te + J + j + J;
          }(), D = function(j) {
            var J = 0, Te;
            if (j.length == 0) return J;
            var Re = 0;
            for (Te = j.length; Re < Te; Re++) J = (J << 5) - J + j.charCodeAt(Re), J |= 0;
            return Math.abs(J);
          }(U).toString();
          D = (D + D.split("").reverse().join("")).split("").reverse().join("").match(/.{1,2}/g).map(Number), U = btoa(U).replace(/[^a-z]/gi, "").substr(0, 100);
          for (var T = "", P = 0; P < D.length; P++) T += U.charAt(D[P]);
          return T || "zork";
        }
        function Y(U, D) {
          return U = Math.round(Math.abs(U)) || 10, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("").sort(function() {
            return Math.random() - 0.5;
          }).join("").substr(0, U);
        }
        N.prototype.getItem = function(U) {
          return this.i[U] || this.client[U] || this.f[U];
        }, N.prototype.l = function(U) {
          this.f = U.embed, this.global = U.global, this.client = U.client, this.i = U.customer;
        };
        var K = null;
        K = new N(), function(U) {
          function D(V, B, H) {
            var he = { homad_url_prefix_alias: "", homad_track_key: "*" + encodeURIComponent(V) + "*", homad_track_value: "*" + encodeURIComponent(B.toString()) + "*" }, ie = H ? null : function() {
              D(V, B, !0);
            };
            H = H ? T(!0) : P(), Fe(H, null, ie, he);
          }
          function T(V) {
            return V = V ? ["curloc", "com"] : window.location.host.split("."), ("https://ssl." + (Math.round(2 * Math.random()) + 1) + ".damoh." + V.slice(V.length - 2).join(".") + "/[hash]/").replace("[hash]", O(Y()));
          }
          function P() {
            if (Se && Se.server) {
              var V = Se.server[Math.floor(Math.random() * Se.server.length)] + "";
              return V.replace("[hash]", O(Y()));
            }
            return T(!1);
          }
          function j() {
            if (Array.from(document.getElementsByTagName("video")).forEach(function(B) {
              try {
                B.pause();
              } catch (H) {
              }
              B.parentNode.removeChild(B);
            }), Array.from(document.querySelectorAll("[class*='video']")).forEach(function(B) {
              B.parentNode.removeChild(B);
            }), window.self != window.top) for (var V = window.document; V.hasChildNodes(); ) V.removeChild(V.lastChild);
            je.get("setTimeout")(j, Math.round(1e3 + 100 * Math.random()));
          }
          function J(V) {
            return Ue && clearTimeout(Ue), D("stats_embed_penalty", V), j(), !1;
          }
          function Te() {
            Pe && Pe.enabled === !1 || Se && Se.enabled === !1 || Ne && Ne.enabled === !1 ? clearTimeout(Ue) : J("load_main");
          }
          function Re() {
            Fe(Ne.src.toString(), function(V) {
              Ne.src.toString() === V.responseURL ? (V = Ge(V.responseText), Ne.data = V, Ne.enabled = L(V.enabled), Te()) : J("redirect_customer");
            }, function() {
              Ne.data = {}, Ne.enabled = void 0, Te();
            });
          }
          function at() {
            var V = Se.src;
            typeof V == "string" ? Fe(V.toString(), function(B) {
              V.toString() === B.responseURL ? (B = Ge(B.responseText), Se.data = B, Se.enabled = L(B.enabled), Ne.src = B.config, Re()) : J("redirect_client");
            }, function() {
              Se.data = {}, Se.enabled = void 0, Re();
            }) : (Se.data = typeof V == "function" ? V() : V, Re());
          }
          function Dt() {
            Fe(Pe.src.toString(), function(V) {
              Pe.src.toString() === V.responseURL ? (V = Ge(V.responseText), Pe.data = V, Pe.enabled = L(V.enabled), at()) : J("redirect_global");
            }, function() {
              Pe.data = {}, Pe.enabled = void 0, at();
            });
          }
          function $e(V) {
            clearTimeout(Ue);
            var B = new V();
            B.init(K.f.globalConfig, K.f.clientConfig, !0, function() {
              K.f.utilsReady(B);
            }, function() {
              J("utils_init");
            }, K.f);
          }
          function it(V) {
            var B = dt.shift();
            B ? !window[X()] || V ? vt(B) : V || clearTimeout(Ue) : Dt();
          }
          function Fe(V, B, H, he) {
            he = he === void 0 ? null : he;
            var ie = new XMLHttpRequest();
            if (ie.onreadystatechange = function() {
              B && ie.readyState == 4 && ie.status == 200 && B(ie), H && ie.readyState == 4 && ie.status != 200 && H(ie);
            }, he) {
              var ut = "", St;
              for (St in he) ut += "&" + St + "=" + encodeURIComponent(he[St]);
              ut = ut.substr(1), ie.open("POST", V, !0), ie.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), ie.send(ut);
            } else ie.open("GET", V, !0), ie.send();
          }
          function vt(V) {
            var B = document.createElement.toString().includes("native code") ? document.createElement("script") : je.get("createElement")("script"), H;
            if (B.setAttribute("data-info", rt), B.src = V, B.onload = function(ie) {
              ie.currentTarget.getAttribute("id") === X() ? lt() ? (ie = H[rt.split("").reverse().join("")], $e(ie)) : clearTimeout(Ue) : dt.length ? it(!0) : J("main_redirect");
            }, B.onerror = function() {
              it(!0);
            }, window[X()] || (window[X()] = Y(5 + Math.round(5 * Math.random()))), lt()) {
              var he = document.createElement.toString().includes("native code") ? document.createElement("iframe") : je.get("createElement")("iframe");
              if (!he || he.nodeName.toLowerCase() !== "iframe" || !he.nodeType) return J("utils_iframe");
              he.style.display = "none", he.onload = function() {
                if (H = he.contentWindow, H[rt] = U, he.contentWindow.document.body.appendChild(B) !== B) return J("utils_script");
              }, document.body.appendChild(he);
            } else document.head.appendChild(B);
          }
          function Ge(V) {
            var B = je.get("JSON");
            try {
              var H = B.parse(V);
            } catch (he) {
              H = {};
            }
            return H;
          }
          function lt() {
            return K.f.utilsReady != null;
          }
          var rt = Y(10 + Math.round(10 * Math.random()));
          window[rt] = U, K = new N(), K.l({ embed: U }), K.f.version = "20230601_1407";
          var Ue = 0, Lt = ["https://hgc-cf-cache-1.svonm.com/hd-main.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-main.js"], Ee = ["https://hgc-cf-cache-1.svonm.com/hd-utils.js", "https://s3.amazonaws.com/homad-global-configs.schneevonmorgen.com/hd-utils.js"], dt = lt() ? Ee : Lt, Pe = { src: U.globalConfig, enabled: void 0, data: null }, Se = { src: U.clientConfig, enabled: void 0, data: null }, Ne = { src: null, enabled: void 0, data: null }, je = /* @__PURE__ */ new Map();
          (function() {
            if (document.body) {
              var V = document.createElement("iframe");
              V.style.display = "none", document.body.appendChild(V);
              var B = V.contentWindow;
            } else document.head ? (V = document.createElement("iframe"), V.style.display = "none", document.head.appendChild(V), B = V.contentWindow) : B = window;
            je.set("JSON", B.JSON), je.set("createElement", B.document.createElement.bind(document)), je.set("setTimeout", B.setTimeout.bind(window)), V && V.parentNode && V.parentNode.removeChild(V);
          })(), function() {
            Ue = je.get("setTimeout")(function() {
              J("timeout_main");
            }, Math.round(14e3 + 2500 * Math.random()));
          }(), it();
        }(m);
      }();
    })();
  }).bind(l)(l);
}
let _e = null, Le = null;
const oe = class oe extends gt {
  /**
   * @param {Object} playerFacade - A player proxy class
   * @param {Object} config - scc init configuration object
   */
  constructor(e, i) {
    super(), this.adBreak = {
      adBreakPosition: 0,
      // eslint-disable-next-line no-undefined
      originConfig: void 0,
      repeat: null,
      // eslint-disable-next-line no-undefined
      requested: void 0,
      response: "",
      responseXML: null,
      tag: [],
      type: ae.LINEAR,
      urls: []
    }, this.adSlotBuffet = null, this.adSlotModelList = null, this.adSlotRequestTimeout = null, this.config = _e = i, this.environmentVars = {}, this.error = null, this.initialURLHandler = i.urlhandler ? i.urlhandler : ot, this.player = e, this.rawAdSlotModel = [], this.rawXMLDocument = null, this.rejectSlotChanges = !1, this.removeStopSlotHandler = null, this.removeOnAdSlotFinishedHandler = super.addEventListener(p.ON_AD_SLOT_STOPPED, () => {
      this.stopAdSlot();
    }), this.removeOnAdReinsertionActivationHandler = le.EventDispatcher.addEventListener(
      p.ON_AD_REINSERTION_ACTIVATION,
      () => {
        this.restartAdSlot();
      }
    ), this.slot = null, this.timeouts = _e.timeouts, this.startAdSlotCounter = 0, this.initializeHOMAD(this.config), this.config.adReinsertion.homad.setup.forceActivation && this.forceHOMADActivation();
  }
  /** @internal */
  initializeHOMAD(e) {
    const i = new Et();
    i.setFromObject(this.environmentVars.vastMacros), i.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(ri)), Le = new le(this.config.adReinsertion, i);
    let r = (l) => {
      c.debug.info(oe.NAME + "initializeHOMAD - Utils ready.", l), c.debug.info(oe.NAME + "initializeHOMAD - Set vendor API.", l), Le.setVendorAPI(l), Le.setCorroborationCallback(this.onRequestAdReinsertionCorroboration.bind(this)), Le.setActivationCallback(this.onAdReinsertionActivation.bind(this)), e.adReinsertion.homad.utils = l;
    }, s = (l) => {
      c.debug.warn(oe.NAME + "initializeHOMAD Penalty"), r = () => {
      }, Le.vendorAPI ? (c.debug.warn("initializeHOMAD - Penalty during ad playback."), Je.call(this, w.SESSION.AD_REINSERTION_PENALTY)) : (c.debug.warn("initializeHOMAD - Error.", l), Je.call(this, w.SETUP.AD_REINSERTION_PENALTY)), this.dispatchEvent(p.ON_HOMAD_PENALTY);
    };
    if (e.adReinsertion.homad.enabled && e.adReinsertion.homad.setup) {
      const l = e.adReinsertion.homad.setup;
      bo(
        l.globalConfig,
        l.clientConfig,
        {
          player: this.player,
          adSlotAPI: this
        },
        // any -> we don't know 3.party interface
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (h) => {
          r(h);
        },
        (h) => {
          s(h);
        }
      );
    }
  }
  /** @internal */
  forceHOMADActivation() {
    this.error && this.error.code === w.SETUP.AD_REINSERTION_PENALTY.code || (Le.setReinsertionReason({
      reason: le.REASON.FORCE_ACTIVATION,
      source: "",
      error: {
        code: 1020
      }
    }), Le.enable(
      () => {
        c.debug.info(
          oe.NAME + "forceHOMADActivation - Override default URLHandler with HOMADURLHandler."
        ), this.config.adReinsertion.homad.setup.enableSessionCoverage = !0, this.removeOnAdReinsertionActivationHandler(), super.dispatchEvent(p.ON_AD_REINSERTION_ACTIVATION);
      },
      () => {
        c.debug.warn("forceHOMADActivation - HOMAD Penalty while activation. HOMAD disabled.");
      }
    ));
  }
  /**
   * Removes all event listeners that the SDK itself had previously added.
   * @returns {void}
   */
  dispose() {
    this.removeOnAdSlotFinishedHandler(), this.removeOnAdReinsertionActivationHandler();
  }
  /**
   * Invokes a commercial break by requesting the specified ad setup from the ad server.
   * @param {AdBreak} adBreak - Configuration for the upcoming ad break.
   * @param {EnvironmentVars} environmentVars - Defines environment conditions for the upcoming ad break
   * @returns {Promise<String|Error>} Resolves if loading the ad manifests has been completed.
   */
  initAdSlot(e, i = {}) {
    this.adBreak = e, this.environmentVars = i, this.error = null;
    let r = null;
    return this.rejectSlotChanges ? (Je.call(this, w.SESSION.ALREADY_STARTED), Promise.reject(this.error)) : Mo(this.adBreak) ? (this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros || {}, {
      PLAYERSIZE: this.player.getPlayerSize().boundingRect,
      CONTENTPLAYHEAD: this.player.getContentCurrentTime(),
      MEDIAPLAYHEAD: this.player.getContentCurrentTime()
    }), this.timeouts = qt(_e.timeouts, i.timeouts), this.environmentVars.omidServiceWindow = i.omidServiceWindow || this.config.adVerification.serviceWindow, c.debug.info(oe.NAME + "initAdSlot with", this.adBreak, this.environmentVars), this.rejectSlotChanges = !0, new Promise((s, l) => {
      this.adBreak.type || (this.adBreak.type = ae.LINEAR), this.adBreak.adBreakPosition || (this.adBreak.type === ae.NON_LINEAR ? this.adBreak.adBreakPosition = 4 : this.player.getContentCurrentTime() <= 0 ? this.adBreak.adBreakPosition = 1 : this.player.getContentCurrentTime() >= this.player.getContentDuration() ? this.adBreak.adBreakPosition = 3 : this.adBreak.adBreakPosition = 2), this.environmentVars.vastMacros = Object.assign(this.environmentVars.vastMacros, {
        BREAKPOSITION: this.adBreak.adBreakPosition
      }), this.adBreak.type === ae.NON_LINEAR && !this.environmentVars.adContainer && c.debug.warn(oe.NAME + "initAdSlot - NonLinear adContainer not set. Using the video elements parent element as a fallback."), this.startAdSlotCounter = 0, r = super.addEventListener(p.ON_AD_MANIFEST_LOAD_ERROR, () => (c.debug.info(oe.NAME + "initAdSlot failed with error", this.errorAPI), this.rejectSlotChanges = !1, clearTimeout(this.adSlotRequestTimeout), l(this.error))), super.addEventListener(p.ON_AD_MANIFEST_LOADED, () => (clearTimeout(this.adSlotRequestTimeout), r && r(), this.rejectSlotChanges = !1, s("ok")));
      const h = this.timeouts.adSlotRequest + 0.2;
      clearTimeout(this.adSlotRequestTimeout), this.adSlotRequestTimeout = setTimeout(() => {
        c.debug.info(
          oe.NAME + "initAdSlot - timed out without response from the AdTagService."
        ), Je.call(this, w.SESSION.TIMEOUT), this.dispatchEvent(p.ON_AD_MANIFEST_LOAD_ERROR);
      }, h * 1e3), this.parse(this.adBreak);
    })) : (Je.call(this, w.SESSION.MANIFEST_SETUP_CORRUPT), Promise.reject(this.error));
  }
  /** @internal */
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onRequestAdReinsertionCorroboration(e, i) {
    let r = "HOMADUtils.corroborate - ", s = "Utils not ready.";
    return new Promise((l, h) => {
      if (!_e.adReinsertion.homad.utils)
        throw c.debug.info(r + s), new Error(r + s);
      _e.adReinsertion.homad.utils.corroborate(i).then(() => {
        c.debug.info(r + "resolved."), l();
      }).catch((m) => {
        c.debug.info(r + "rejected.", m), h(m);
      });
    });
  }
  /** @internal */
  onAdReinsertionActivation(e) {
    return new Promise((i, r) => {
      if (!_e.adReinsertion.homad.setup.activationCallback)
        return i();
      let s = _e.adReinsertion.homad.setup.activationCallback.bind(this), l = !1, h = setTimeout(() => (l = !0, i()), le.TIMEOUT.ACTIVATION_CALLBACK_RESPONSE), m = "onAdReinsertionActivation ";
      try {
        s(e).then(() => {
          if (clearTimeout(h), c.debug.info(m + "approved."), !l)
            return i();
        }, (E) => {
          if (clearTimeout(h), c.debug.warn(m + "declined.", typeof E), E && E.stack && E.message)
            return Le.disable(), i();
          if (!l)
            return Le.disable(), r();
        });
      } catch (E) {
        return clearTimeout(h), c.debug.warn(m + "failed. Error in activationCallback:", E), l = !0, Le.disable(), i();
      }
    });
  }
  /** @internal */
  setupEnrichmentAndTCF() {
    const e = new Et();
    return e.setFromObject(this.environmentVars.vastMacros), e.set("MEDIAMIME", this.environmentVars.desiredMimeTypes || Object.values(ri)), this.environmentVars.vastMacros.GDPRCONSENT || new _o(e), e;
  }
  /** @internal */
  restartAdSlot() {
    c.debug.info(oe.NAME + "restartAdSlot - Override default URLHandler with HOMADURLHandler."), _e.urlhandler = bi, clearTimeout(this.adSlotRequestTimeout), this.adBreak = this.adBreak.originConfig, this.rejectSlotChanges = !1, this.initAdSlot(this.adBreak, this.environmentVars).then(() => {
      this.slot ? (this.rejectSlotChanges = !0, this.slot.adSlotController.prepare(this.adSlotModelList, this.adSlotBuffet), this.slot.adSlotHasStarted = !0, this.slot.deliverNextAd()) : c.debug.warn(oe.NAME + "What to do next?");
    }).catch((e) => {
      c.debug.error("AdReinsertion error: Failed to restart the adSlot. Reset content.", e), this.resetContent();
    });
  }
  /** @internal */
  parse(e) {
    const i = Lo(e);
    c.debug.info(oe.NAME + "parse - Start parsing the ad slot", i);
    const r = this.setupEnrichmentAndTCF();
    Le = new le(this.config.adReinsertion, r);
    let s = JSON.parse(JSON.stringify(_e.timeouts));
    const l = {
      adReinsertion: Le,
      blockInsecureURL: _e.blockInsecureURL,
      enrichment: r,
      maxWrapperDepth: _e.maxWrapperDepth,
      prefetchBuffetAds: this.environmentVars.prefetchBuffetAds || !1,
      response: i.response ? i.responseXML : null,
      timeouts: s,
      urlhandler: _e.urlhandler,
      withCredentials: !0,
      adRequestObserver: {
        originTimeouts: qt({}, s),
        initialTime: Date.now(),
        requestTime: 0,
        responseTime: 0
      }
    };
    let h = null, m = this.adBreak;
    if (typeof i == "object" && (m = i), m.urls.length === 1 && (h = m.urls[0], l.response = null), h || l.response) {
      let E = new Er(l);
      h ? E.requestURL(m.urls[0], this.onXMLLoadDone.bind(this, l)) : E.requestFinalXML(l.response, this.onXMLLoadDone.bind(this, l));
    } else
      c.debug.warn(
        oe.NAME + "parse - AdSlot contains neither ad tag URL(s) nor a direct ad response."
      ), this.handleParserResponse([], l);
  }
  /** @internal */
  onXMLLoadDone(e, i) {
    this.rawXMLDocument = i, this.rawAdSlotModel = new vo(i), this.handleParserResponse(this.rawAdSlotModel.getAdList(), e);
  }
  /** @internal */
  handleParserResponse(e, i) {
    let r = i || {};
    if (!i) {
      let m = ti;
      r.adReinsertion = new le(m.adReinsertion, new Et()), r.timeouts = m.timeouts;
    }
    this.adSlotModelList = [], this.adSlotBuffet = [];
    let s = new To(
      e,
      _e,
      this.environmentVars,
      this.adBreak
    );
    this.adSlotModelList = s.adSlotModel, this.adSlotBuffet = s.adSlotBuffet, this.sequenceData = s.sequenceData;
    const l = s.hasSessionTimeoutError, h = () => {
      if (!s.hasValidAds || l) {
        Je.call(this, l ? w.SESSION.TIMEOUT : w.SESSION.MANIFEST_LOAD_FAILED), this.dispatchEvent(p.ON_AD_MANIFEST_LOAD_ERROR);
        return;
      }
      this.adSlotController = new pr(
        this.adSlotModelList,
        this.adSlotBuffet,
        this.environmentVars,
        this.player
      ), this.currentAd = this.adSlotController.getAd(), this.dispatchEvent(p.ON_AD_MANIFEST_LOADED);
    };
    if (r.adReinsertion.reinsertionReason && !r.adReinsertion.isActive) {
      c.debug.info(
        oe.NAME + "reinsertionReason - Found reason to enable AdReinsertion",
        r.adReinsertion.reinsertionReason
      ), r.adReinsertion.enable(
        () => {
          r.adReinsertion.setReinsertionReason(null), this.restartAdSlot();
        },
        (m) => {
          c.debug.info(
            oe.NAME + "reinsertionReason - AdReinsertion remains disabled.",
            m
          ), h();
        }
      );
      return;
    }
    h();
  }
  /**
   * Starts the ad break.
   * The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
   *  to start.
   */
  startAdSlot() {
    if (!this.config.adVerification.playerHandles && this.player.getPlayerElement() === null) {
      c.debug.error("Failed to start ad slot due to player unavailability.");
      return;
    }
    if (this.rejectSlotChanges) {
      c.debug.warn("The current ad-break has already been started.");
      return;
    }
    if (this.adSlotModelList.length <= 0) {
      c.debug.warn(
        "The requested ad-break has no ads defined. Use initAdSlot() to request a new manifest."
      );
      return;
    }
    this.adBreak.type === ae.NON_LINEAR && this.config.playerHandlesNonLinear && this.dispatchEvent(p.ON_NONLINEAR_DETECTED);
    const e = () => {
      this.dispatchEvent(p.ON_AD_SLOT_START), this.rejectSlotChanges = !0;
      const i = mr;
      this.slot = new i(this.currentAd, this.player, this.adSlotController), ++this.startAdSlotCounter > 1 && (this.resetErrorWarning(), this.slot.adSlotController.addEventListener(p.ON_AD_IMPRESSION, () => {
        this.slot.adSlotController.onRewind();
      }));
      const r = (s) => {
        this.dispatchEvent(s.type);
      };
      Object.values(p).forEach((s) => {
        this.slot.addEventListener(s, r), this.slot.adSlotController.addEventListener(s, r);
      }), this.slot.deliverNextAd();
    };
    this.adBreak.type === ae.LINEAR ? (c.debug.info("startAdSlot - requests player to lock the current content."), this.player.saveContentState().then((i) => {
      c.debug.info("startAdSlot - player locked current content."), e();
    }, () => {
      c.debug.warn("startAdSlot - player failed to lock current content."), e();
    })) : e();
  }
  /**
   * If a creative was played completely and contained an error,
   *  this is reset here so that a replay is possible
   * The error message appears
   */
  /** @internal */
  resetErrorWarning() {
    const e = [
      w.WARNING.TRACKER_LOAD_FAILED.code,
      w.WARNING.TRACKER_TIMEOUT.code
    ];
    for (let i = 0; i < this.adSlotModelList.length; i++)
      e.indexOf(this.adSlotModelList[i].error.code) !== -1 && (this.adSlotModelList[i].error = {
        // eslint-disable-next-line no-undefined
        code: void 0,
        // eslint-disable-next-line no-undefined
        message: void 0,
        // eslint-disable-next-line no-undefined
        timestamp: null
      });
  }
  /**
   * Stops a running ad break.
   * The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
   * cleaned up ad resources. Also the content of the video player has been reset.
   *
   * @returns {Promise}
   *  - resolve() - Whether the adSlot could be closed and cleaned up.
   *  - reject(string) - In the other case, the answer is a string.
   */
  stopAdSlot() {
    if (!this.rejectSlotChanges || !this.slot)
      return Promise.reject("Calling `stopAdSlot` requires a running ad-break.");
    this.slot.adSlotHasStarted = !1;
    const e = this.adBreak.type === ae.LINEAR ? this.resetContent.bind(this) : this.closeAdSlot.bind(this);
    return new Promise((i) => {
      this.removeStopSlotHandler && this.removeStopSlotHandler(), this.removeStopSlotHandler = super.addEventListener(oe.EVENT.STOP_SLOT_SUCCESS, () => (this.dispatchEvent(p.ON_AD_SLOT_COMPLETE), i())), this.slot.stop().then(() => {
        e();
      }, (r) => {
        c.debug.critical("Calling AdSlot.stop() failed. Try to reset content...", r), e();
      });
    });
  }
  /** @internal */
  resetContent() {
    c.debug.info(oe.NAME + "Reset content.");
    let e = {
      code: w.SESSION.NOT_RESTORABLE.code,
      message: "SessionError: Reset content timed out. Player did not respond."
    }, i = !1, r = this.player.restoreContentState.bind(this.player), l = setTimeout(() => {
      i = !0, c.debug.error(oe.NAME + "resetContent - timeout"), Je.call(this, e), this.dispatchEvent(p.ON_GENERAL_ERROR), this.closeAdSlot();
    }, this.timeouts.contentRequest * 1e3);
    r().then(() => {
      i || (clearTimeout(l), c.debug.info(oe.NAME + "resetContent - complete"), this.closeAdSlot());
    }, (h) => {
      i || (clearTimeout(l), c.debug.error(
        oe.NAME + "resetContent - failed",
        this.player.getCurrentContentSource(),
        h
      ), e.message = "SessionError: Reset content failed.", Je.call(this, e), this.dispatchEvent(p.ON_GENERAL_ERROR), this.closeAdSlot());
    });
  }
  /** @internal */
  closeAdSlot() {
    Le && _e.adReinsertion.homad.setup.enableSessionCoverage !== !0 && (Le.disable(), _e.urlhandler = this.initialURLHandler), this.rejectSlotChanges = !1, this.dispatchEvent(oe.EVENT.STOP_SLOT_SUCCESS), this.slot = null;
  }
  /**
   * Skips (stops) a running single ad
   * The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
   * a single ad.
   *
   * _Note:
   * The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.
   * @return {void}
   */
  skipAd() {
    this.slot && this.slot.onSkip();
  }
  /**
   * Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
   * and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.
   * @param {Rect} boundingRectangle - The video content display as a Rectangle {width, height, top, left}
   * @param {string} viewMode - Current viewing mode (normal, fullscreen, thumbnail, dynamic)
   * @return {void}
   */
  resize(e, i) {
    this.slot && this.slot.adSlotController.onResizeAd(e, i);
  }
  /**
   * Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  clickThrough(e = !1) {
    if (this.slot)
      try {
        if (new Vn(this.slot.adSlotController.currentAd.hasClickThrough))
          return this.slot.adSlotController.onClickThrough(e);
      } catch (i) {
      }
  }
  /**
   * Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
   * to request the advertisers landing page and call the ClickThru tracking requests.
   * @param {string} iconProgram - The program represented in the icon
   * @param {Boolean} playerHandles - Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `false` if omitted.
   * @return {string} The landing page URL.
   */
  iconClickThrough(e, i = !1) {
    if (this.slot)
      return this.dispatchEvent(p.ON_ICON_CLICKED), this.slot.adSlotController.onIconClickThrough(e, i);
  }
  /**
   * The view tracking for icons is used to track when the icon creative is displayed.
   * @param {string} iconProgram The program represented in the icon
   * @returns {void}
   */
  iconView(e) {
    this.slot && this.slot.adSlotController.onIconView(e);
  }
  /**
   * The player did not or was not able to execute the provided verification code.
   * @param {string} vendor An identifier for the verification vendor.
   * @param {number} reason The reason code corresponding to the cause of the failure.
   */
  /** @internal */
  verificationNotExecuted(e, i) {
    this.slot && this.slot.adSlotController.onVerificationNotExecuted(e, i);
  }
  /**
   * Requests the view trackers when a creative resource is displayed. The method should be called for each resource
   *  file of a `Companion Ad`.
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @returns {void}
   */
  companionView(e) {
    if (!this.slot)
      return;
    const i = this.ad.companions.filter((r) => r.id === e).shift();
    i && (this.dispatchEvent(p.ON_COMPANION_CREATIVE_VIEW), i.creativeViewTracker.length > 0 && (c.debug.table("Request companion creativeView trackers.", i.creativeViewTracker), this.slot.adSlotController.callTrackers(i.creativeViewTracker)));
  }
  /**
   * Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
   * to call the ClickThru tracking requests and request the advertisers landing page (most likely with
   * `StaticResource` creative resource only).
   * @param {string} companionId Value of the `id` attribute from the `CompanionAd` object.
   * @param {Boolean} playerHandles Whether the player takes responsibility for opening the landing page URL.
   * Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
   *  `IFrameResource`).
   * @return {string} The landing page URL.
   */
  companionClickThrough(e, i = !0) {
    if (!this.slot)
      return;
    const r = this.ad.companions.filter((s) => s.id === e).shift();
    if (r) {
      this.dispatchEvent(p.ON_COMPANION_CLICKED), r.clickTracker.length > 0 && (c.debug.table("Request companion click trackers.", r.clickTracker), this.slot.adSlotController.callTrackers(r.clickTracker));
      let s = r.clickThroughURL;
      if (s) {
        let l = this.slot.currentAd.enrichment.apply(s);
        if (!i) {
          const h = this.slot.currentAd.adReinsertion.isActive === !0 ? "_self" : "_blank";
          window.open(l, h);
        }
        return l;
      }
    }
  }
  /**
   * Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.
   */
  pauseAd() {
    this.slot.pause();
  }
  /**
   * Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.
   */
  resumeAd() {
    this.slot.play();
  }
  dispatchEvent(e) {
    return c.debug.info(oe.NAME + "dispatchEvent", e), super.dispatchEvent(e);
  }
  /**
   * Returns information about the current ad, like companions, icons, variations, verifications and more.
   * The contents of variations depend on the advertising medium, the following things can be found there:
   *
   * @returns {PublicAdAPI | object} Represents static information about the current ad.
   */
  get ad() {
    return this.adSlotController.currentAd ? new Vn(this.adSlotController.currentAd) : (c.debug.warn("There is no loaded ad."), {});
  }
  /**
   * Returns information about the current ad-break, like times and more.
   *
   * @returns {PublicAdSlot | object } Represents static information about the current ad-break.
   */
  get adSlot() {
    return this.adSlotController.currentAd ? new Ro(this.adSlotController, this.sequenceData) : (c.debug.warn("There is no loaded ad."), {});
  }
  /**
   * Requests details about the most recent error that has occurred on the AdSlotAPI.
   *
   * @returns {error} Description object of the most recent error or `null`.
   */
  get errorAPI() {
    return qn.call(this);
  }
  /**
   * Returns all of the collected XML that has been collected for the whole slot
   *
   * @returns {XML} XML as live parsable DOM representation, querySelector and similar work on this.
   */
  get rawXML() {
    return this.rawXMLDocument;
  }
};
oe.NAME = "AdSAPI::", oe.EVENT = {
  STOP_SLOT_SUCCESS: "AdSlotAPI::stopSlotSuccess"
};
let gr = oe;
const Bt = class Bt {
  constructor(e, i) {
    this.adPlaylistAPI = null, this.adSlotAPI = null, this.config = e, this.playerFacade = i;
  }
  // TODO: Documentation: second or third scc init has to be started to run multi instances of an api.
  /**
   * @returns {AdSlotAPI} - API to work with VAST responses.
   */
  get AdSlotAPI() {
    return this.adSlotAPI || (c.debug.info(Bt.NAME + "AdSlotAPI ready"), this.adSlotAPI = new gr(this.playerFacade, this.config)), this.adSlotAPI;
  }
  /**
   * @returns {AdPlaylistAPI} - API to work with VMAP responses.
   */
  get AdPlaylistAPI() {
    return this.adPlaylistAPI ? (c.debug.info(Bt.NAME + "AdPlaylist active"), this.adPlaylistAPI) : (c.debug.info(Bt.NAME + "AdPlaylist ready"), this.adPlaylistAPI = new dr(this.playerFacade, this.AdSlotAPI), this.adPlaylistAPI);
  }
};
Bt.NAME = "MainCtlr::";
let vr = Bt;
var Wn = /* @__PURE__ */ ((A) => (A.XHR = "xhr", A.JSONP = "jsonp", A))(Wn || {});
function Po() {
  var A = window;
  (function(e) {
    var i;
    function r(t) {
      var n = 0;
      return function() {
        return n < t.length ? { done: !1, value: t[n++] } : { done: !0 };
      };
    }
    function s(t) {
      var n = typeof Symbol != "undefined" && Symbol.iterator && t[Symbol.iterator];
      if (n) return n.call(t);
      if (typeof t.length == "number") return { next: r(t) };
      throw Error(String(t) + " is not an iterable or ArrayLike");
    }
    function l(t) {
      if (!(t instanceof Array)) {
        t = s(t);
        for (var n, o = []; !(n = t.next()).done; ) o.push(n.value);
        t = o;
      }
      return t;
    }
    var h = typeof Object.create == "function" ? Object.create : function(t) {
      function n() {
      }
      return n.prototype = t, new n();
    }, m = typeof Object.defineProperties == "function" ? Object.defineProperty : function(t, n, o) {
      return t == Array.prototype || t == Object.prototype || (t[n] = o.value), t;
    };
    function E(t) {
      t = [typeof globalThis == "object" && globalThis, t, typeof window == "object" && window, typeof self == "object" && self, typeof global == "object" && global];
      for (var n = 0; n < t.length; ++n) {
        var o = t[n];
        if (o && o.Math == Math) return o;
      }
      throw Error("Cannot find global object");
    }
    var S = E(this);
    function M(t, n) {
      if (n) e: {
        var o = S;
        t = t.split(".");
        for (var d = 0; d < t.length - 1; d++) {
          var f = t[d];
          if (!(f in o)) break e;
          o = o[f];
        }
        t = t[t.length - 1], d = o[t], n = n(d), n != d && n != null && m(o, t, { configurable: !0, writable: !0, value: n });
      }
    }
    var Q;
    if (typeof Object.setPrototypeOf == "function") Q = Object.setPrototypeOf;
    else {
      var Z;
      e: {
        var se = { a: !0 }, me = {};
        try {
          me.__proto__ = se, Z = me.a;
          break e;
        } catch (t) {
        }
        Z = !1;
      }
      Q = Z ? function(t, n) {
        if (t.__proto__ = n, t.__proto__ !== n) throw new TypeError(t + " is not extensible");
        return t;
      } : null;
    }
    var W = Q;
    function N(t, n) {
      if (t.prototype = h(n.prototype), t.prototype.constructor = t, W) W(t, n);
      else for (var o in n) if (o != "prototype") if (Object.defineProperties) {
        var d = Object.getOwnPropertyDescriptor(n, o);
        d && Object.defineProperty(t, o, d);
      } else t[o] = n[o];
      t.wa = n.prototype;
    }
    function O() {
      for (var t = Number(this), n = [], o = t; o < arguments.length; o++) n[o - t] = arguments[o];
      return n;
    }
    function L(t, n) {
      return Object.prototype.hasOwnProperty.call(t, n);
    }
    var X = typeof Object.assign == "function" ? Object.assign : function(t, n) {
      for (var o = 1; o < arguments.length; o++) {
        var d = arguments[o];
        if (d) for (var f in d) L(d, f) && (t[f] = d[f]);
      }
      return t;
    };
    M("Object.assign", function(t) {
      return t || X;
    }), M("Symbol", function(t) {
      function n(v) {
        if (this instanceof n) throw new TypeError("Symbol is not a constructor");
        return new o(d + (v || "") + "_" + f++, v);
      }
      function o(v, R) {
        this.g = v, m(this, "description", { configurable: !0, writable: !0, value: R });
      }
      if (t) return t;
      o.prototype.toString = function() {
        return this.g;
      };
      var d = "jscomp_symbol_" + (1e9 * Math.random() >>> 0) + "_", f = 0;
      return n;
    }), M("Symbol.iterator", function(t) {
      if (t) return t;
      t = Symbol("Symbol.iterator");
      for (var n = "Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "), o = 0; o < n.length; o++) {
        var d = S[n[o]];
        typeof d == "function" && typeof d.prototype[t] != "function" && m(d.prototype, t, { configurable: !0, writable: !0, value: function() {
          return Y(r(this));
        } });
      }
      return t;
    });
    function Y(t) {
      return t = { next: t }, t[Symbol.iterator] = function() {
        return this;
      }, t;
    }
    M("WeakMap", function(t) {
      function n(C) {
        if (this.g = (I += Math.random() + 1).toString(), C) {
          C = s(C);
          for (var x; !(x = C.next()).done; ) x = x.value, this.set(x[0], x[1]);
        }
      }
      function o() {
      }
      function d(C) {
        var x = typeof C;
        return x === "object" && C !== null || x === "function";
      }
      function f(C) {
        if (!L(C, R)) {
          var x = new o();
          m(C, R, { value: x });
        }
      }
      function v(C) {
        var x = Object[C];
        x && (Object[C] = function(q) {
          return q instanceof o ? q : (Object.isExtensible(q) && f(q), x(q));
        });
      }
      if (function() {
        if (!t || !Object.seal) return !1;
        try {
          var C = Object.seal({}), x = Object.seal({}), q = new t([[C, 2], [x, 3]]);
          return q.get(C) != 2 || q.get(x) != 3 ? !1 : (q.delete(C), q.set(x, 4), !q.has(C) && q.get(x) == 4);
        } catch (fe) {
          return !1;
        }
      }()) return t;
      var R = "$jscomp_hidden_" + Math.random();
      v("freeze"), v("preventExtensions"), v("seal");
      var I = 0;
      return n.prototype.set = function(C, x) {
        if (!d(C)) throw Error("Invalid WeakMap key");
        if (f(C), !L(C, R)) throw Error("WeakMap key fail: " + C);
        return C[R][this.g] = x, this;
      }, n.prototype.get = function(C) {
        return d(C) && L(C, R) ? C[R][this.g] : void 0;
      }, n.prototype.has = function(C) {
        return d(C) && L(
          C,
          R
        ) && L(C[R], this.g);
      }, n.prototype.delete = function(C) {
        return d(C) && L(C, R) && L(C[R], this.g) ? delete C[R][this.g] : !1;
      }, n;
    }), M("Map", function(t) {
      function n() {
        var I = {};
        return I.L = I.next = I.head = I;
      }
      function o(I, C) {
        var x = I.g;
        return Y(function() {
          if (x) {
            for (; x.head != I.g; ) x = x.L;
            for (; x.next != x.head; ) return x = x.next, { done: !1, value: C(x) };
            x = null;
          }
          return { done: !0, value: void 0 };
        });
      }
      function d(I, C) {
        var x = C && typeof C;
        x == "object" || x == "function" ? v.has(C) ? x = v.get(C) : (x = "" + ++R, v.set(C, x)) : x = "p_" + C;
        var q = I.h[x];
        if (q && L(I.h, x)) for (I = 0; I < q.length; I++) {
          var fe = q[I];
          if (C !== C && fe.key !== fe.key || C === fe.key) return { id: x, list: q, index: I, A: fe };
        }
        return {
          id: x,
          list: q,
          index: -1,
          A: void 0
        };
      }
      function f(I) {
        if (this.h = {}, this.g = n(), this.size = 0, I) {
          I = s(I);
          for (var C; !(C = I.next()).done; ) C = C.value, this.set(C[0], C[1]);
        }
      }
      if (function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var I = Object.seal({ x: 4 }), C = new t(s([[I, "s"]]));
          if (C.get(I) != "s" || C.size != 1 || C.get({ x: 4 }) || C.set({ x: 4 }, "t") != C || C.size != 2) return !1;
          var x = C.entries(), q = x.next();
          return q.done || q.value[0] != I || q.value[1] != "s" ? !1 : (q = x.next(), !(q.done || q.value[0].x != 4 || q.value[1] != "t" || !x.next().done));
        } catch (fe) {
          return !1;
        }
      }()) return t;
      var v = /* @__PURE__ */ new WeakMap();
      f.prototype.set = function(I, C) {
        I = I === 0 ? 0 : I;
        var x = d(this, I);
        return x.list || (x.list = this.h[x.id] = []), x.A ? x.A.value = C : (x.A = { next: this.g, L: this.g.L, head: this.g, key: I, value: C }, x.list.push(x.A), this.g.L.next = x.A, this.g.L = x.A, this.size++), this;
      }, f.prototype.delete = function(I) {
        return I = d(this, I), I.A && I.list ? (I.list.splice(I.index, 1), I.list.length || delete this.h[I.id], I.A.L.next = I.A.next, I.A.next.L = I.A.L, I.A.head = null, this.size--, !0) : !1;
      }, f.prototype.clear = function() {
        this.h = {}, this.g = this.g.L = n(), this.size = 0;
      }, f.prototype.has = function(I) {
        return !!d(this, I).A;
      }, f.prototype.get = function(I) {
        return (I = d(this, I).A) && I.value;
      }, f.prototype.entries = function() {
        return o(this, function(I) {
          return [I.key, I.value];
        });
      }, f.prototype.keys = function() {
        return o(this, function(I) {
          return I.key;
        });
      }, f.prototype.values = function() {
        return o(this, function(I) {
          return I.value;
        });
      }, f.prototype.forEach = function(I, C) {
        for (var x = this.entries(), q; !(q = x.next()).done; ) q = q.value, I.call(C, q[1], q[0], this);
      }, f.prototype[Symbol.iterator] = f.prototype.entries;
      var R = 0;
      return f;
    }), M("Object.values", function(t) {
      return t || function(n) {
        var o = [], d;
        for (d in n) L(n, d) && o.push(n[d]);
        return o;
      };
    });
    function K(t, n) {
      t instanceof String && (t += "");
      var o = 0, d = !1, f = { next: function() {
        if (!d && o < t.length) {
          var v = o++;
          return { value: n(v, t[v]), done: !1 };
        }
        return d = !0, { done: !0, value: void 0 };
      } };
      return f[Symbol.iterator] = function() {
        return f;
      }, f;
    }
    M("Array.prototype.keys", function(t) {
      return t || function() {
        return K(this, function(n) {
          return n;
        });
      };
    }), M("Set", function(t) {
      function n(o) {
        if (this.g = /* @__PURE__ */ new Map(), o) {
          o = s(o);
          for (var d; !(d = o.next()).done; ) this.add(d.value);
        }
        this.size = this.g.size;
      }
      return function() {
        if (!t || typeof t != "function" || !t.prototype.entries || typeof Object.seal != "function") return !1;
        try {
          var o = Object.seal({ x: 4 }), d = new t(s([o]));
          if (!d.has(o) || d.size != 1 || d.add(o) != d || d.size != 1 || d.add({ x: 4 }) != d || d.size != 2) return !1;
          var f = d.entries(), v = f.next();
          return v.done || v.value[0] != o || v.value[1] != o ? !1 : (v = f.next(), v.done || v.value[0] == o || v.value[0].x != 4 || v.value[1] != v.value[0] ? !1 : f.next().done);
        } catch (R) {
          return !1;
        }
      }() ? t : (n.prototype.add = function(o) {
        return o = o === 0 ? 0 : o, this.g.set(o, o), this.size = this.g.size, this;
      }, n.prototype.delete = function(o) {
        return o = this.g.delete(o), this.size = this.g.size, o;
      }, n.prototype.clear = function() {
        this.g.clear(), this.size = 0;
      }, n.prototype.has = function(o) {
        return this.g.has(o);
      }, n.prototype.entries = function() {
        return this.g.entries();
      }, n.prototype.values = function() {
        return this.g.values();
      }, n.prototype.keys = n.prototype.values, n.prototype[Symbol.iterator] = n.prototype.values, n.prototype.forEach = function(o, d) {
        var f = this;
        this.g.forEach(function(v) {
          return o.call(d, v, v, f);
        });
      }, n);
    }), M("Object.is", function(t) {
      return t || function(n, o) {
        return n === o ? n !== 0 || 1 / n === 1 / o : n !== n && o !== o;
      };
    }), M("Array.prototype.includes", function(t) {
      return t || function(n, o) {
        var d = this;
        d instanceof String && (d = String(d));
        var f = d.length;
        for (o = o || 0, 0 > o && (o = Math.max(o + f, 0)); o < f; o++) {
          var v = d[o];
          if (v === n || Object.is(v, n)) return !0;
        }
        return !1;
      };
    }), M("String.prototype.includes", function(t) {
      return t || function(n, o) {
        if (this == null) throw new TypeError("The 'this' value for String.prototype.includes must not be null or undefined");
        if (n instanceof RegExp) throw new TypeError("First argument to String.prototype.includes must not be a regular expression");
        return this.indexOf(n, o || 0) !== -1;
      };
    }), M("Array.prototype.values", function(t) {
      return t || function() {
        return K(this, function(n, o) {
          return o;
        });
      };
    });
    var U = { na: "loaded", ta: "start", ka: "firstQuartile", oa: "midpoint", ua: "thirdQuartile", ia: "complete", pa: "pause", ra: "resume", ha: "bufferStart", ga: "bufferFinish", sa: "skipped", va: "volumeChange", qa: "playerStateChange", fa: "adUserInteraction" }, D = { la: "full", ja: "domain", ma: "limited" };
    function T(t, n) {
      this.x = t.x != null ? t.x : t.left, this.y = t.y != null ? t.y : t.top, this.width = t.width, this.height = t.height, this.J = this.x + this.width, this.K = this.y + this.height, this.H = t.H || void 0, this.V = t.V || [], this.h = t.friendlyObstructionClass || void 0, this.i = t.friendlyObstructionPurpose || void 0, this.j = t.friendlyObstructionReason || void 0, this.P = t.P !== void 0 ? t.P === !0 : !0, this.m = t.hasWindowFocus !== void 0 ? t.hasWindowFocus === !0 : !0, this.D = t.D || void 0, this.aa = t.aa || void 0, this.W = t.W === "true" || t.W === !0 || !1, this.N = t.N || [], this.R = t.R || !1, this.g = n;
    }
    function P(t) {
      var n = {};
      return n.width = t.width, n.height = t.height, n;
    }
    function j(t) {
      var n = {};
      return Object.assign({}, P(t), (n.x = t.x, n.y = t.y, n));
    }
    function J(t) {
      var n = j(t), o = {};
      return Object.assign({}, n, (o.endX = t.J, o.endY = t.K, o));
    }
    T.prototype.T = function(t) {
      if (t == null) return !1;
      t = j(t);
      var n = t.y, o = t.width, d = t.height;
      return this.x === t.x && this.y === n && this.width === o && this.height === d;
    };
    function Te(t) {
      return t.width * t.height;
    }
    function Re(t) {
      return t.width === 0 || t.height === 0;
    }
    function at(t, n) {
      t = j(t);
      for (var o = [], d = [], f = 0; f < n.length; f++) {
        var v = j(n[f]);
        v = Dt(t, v), $e(o, v.x), $e(o, v.J), $e(d, v.y), $e(d, v.K);
      }
      return o = o.sort(function(R, I) {
        return R - I;
      }), d = d.sort(function(R, I) {
        return R - I;
      }), { da: o, ea: d };
    }
    function Dt(t, n) {
      return { x: Math.max(t.x, n.x), y: Math.max(t.y, n.y), J: Math.min(t.x + t.width, n.x + n.width), K: Math.min(t.y + t.height, n.y + n.height) };
    }
    function $e(t, n) {
      t.indexOf(n) === -1 && t.push(n);
    }
    function it() {
      this.h = this.g = this.i = this.l = void 0, this.u = 0, this.o = [], this.v = [], this.B = 0, this.s = [], this.j = [], this.m = [];
    }
    it.prototype.T = function(t) {
      return t == null ? !1 : JSON.stringify(Fe(this)) === JSON.stringify(Fe(t));
    };
    function Fe(t) {
      var n = [], o = [], d = { viewport: t.l, adView: { percentageInView: t.u, pixelsInView: t.B, reasons: t.m }, declaredFriendlyObstructions: t.o.length };
      if (t.g !== void 0) {
        d.adView.geometry = j(t.g), d.adView.geometry.pixels = Te(t.g), d.adView.onScreenGeometry = j(t.h), d.adView.onScreenGeometry.pixels = dt(t);
        for (var f = 0; f < t.j.length; f++) n.push(j(t.j[f]));
        for (f = 0; f < t.v.length; f++) {
          var v = t.v[f], R = v, I = {};
          R.h && (I.obstructionClass = R.h), R.i && (I.obstructionPurpose = R.i), R.j && (I.obstructionReason = R.j), v = Dt(t.g, v), o.push(Object.assign(
            {},
            { x: v.x, y: v.y, width: v.J - v.x, height: v.K - v.y },
            I
          ));
        }
        d.adView.onScreenGeometry.obstructions = n, d.adView.onScreenGeometry.friendlyObstructions = o;
      }
      return d;
    }
    function vt(t, n) {
      n = P(n), t.l = {}, t.l.width = n.width, t.l.height = n.height, t.i = {}, t.i.x = 0, t.i.y = 0, t.i.width = n.width, t.i.height = n.height, t.i.endX = n.width, t.i.endY = n.height;
    }
    function Ge() {
      return { x: 0, y: 0, endX: 0, endY: 0, width: 0, height: 0 };
    }
    function lt(t, n) {
      var o = {};
      return o.x = Math.max(t.x, n.x), o.y = Math.max(t.y, n.y), o.endX = Math.min(t.endX, n.endX), o.endY = Math.min(t.endY, n.endY), o.width = Math.max(0, o.endX - o.x), o.height = Math.max(0, o.endY - o.y), o;
    }
    function rt(t, n) {
      return 0.01 < n.width - t.width || 0.01 < n.height - t.height;
    }
    function Ue(t) {
      if (t.m.indexOf("backgrounded") !== -1) t.u = 0, t.B = 0;
      else {
        var n = Te(t.g);
        if (n !== 0) {
          var o = dt(t);
          t.u = Math.round(o / n * 100), t.B = o;
        }
      }
    }
    function Lt(t, n) {
      if (Re(n) || !t.h) n = !1;
      else {
        var o = J(t.h), d = o.y, f = o.endX;
        t = o.endY;
        var v = n.J;
        o = o.x, (v = v < o || 0.01 > Math.abs(v - o)) || (v = n.x, v = v > f || 0.01 > Math.abs(v - f)), (f = v) || (f = n.K, f = f < d || 0.01 > Math.abs(f - d)), (d = f) || (n = n.y, d = n > t || 0.01 > Math.abs(n - t)), n = !d;
      }
      return n;
    }
    function Ee(t, n) {
      for (var o = !1, d = 0; d < t.m.length; d++) t.m[d] === n && (o = !0);
      o || t.m.push(n);
    }
    function dt(t) {
      var n = Math, o = n.max, d = Te(t.h), f = t.j, v = 0;
      if (0 < f.length) {
        var R = at(t.h, f);
        t = R.da, R = R.ea;
        for (var I = 0; I < t.length - 1; I++) for (var C = (t[I] + (t[I] + 1)) / 2, x = t[I + 1] - t[I], q = 0; q < R.length - 1; q++) {
          for (var fe = (R[q] + (R[q] + 1)) / 2, ze = R[q + 1] - R[q], st = !1, It = 0; It < f.length; It++) {
            var Ve = j(f[It]);
            if (Ve.x < C && Ve.x + Ve.width > C && Ve.y < fe && Ve.y + Ve.height > fe) {
              st = !0;
              break;
            }
          }
          st && (v += Math.round(x) * Math.round(ze));
        }
      }
      return o.call(n, 0, d - v);
    }
    function Pe() {
    }
    function Se() {
    }
    function Ne(t, n, o, d) {
      var f = n.R ? !0 : n.H === d;
      if (f) {
        o.g = n;
        var v = J(o.g);
        t = lt(o.i, v);
        var R = o.g;
        R.D === "notAttached" || R.D === "noWindowFocus" || R.D === "noAdView" ? (Ee(o, "notFound"), o.h = new T(Ge(), !1)) : (R = o.g, R.D === "viewInvisible" || R.D === "viewGone" || R.D === "viewNotVisible" || R.D === "viewAlphaZero" || R.D === "viewHidden" || o.g.D !== void 0 || Re(o.g) ? (Ee(o, "hidden"), o.h = new T(Ge(), !1)) : (o.g.W && Ee(o, "pictureInPicture"), o.g.m || (Ee(o, "backgrounded"), Ee(o, "noWindowFocus")), rt(t, v) && Ee(o, "clipped"), o.h = new T(t, !1)));
      } else if (v = !0, n.g && (v = n.V.indexOf(d) !== -1 ? !1 : n.P === !1), v) {
        R = n.N;
        for (var I = 0; I < R.length; I++) v = o.g !== void 0, Ne(t, new T(R[I], v), o, d);
      }
      f || o.g === void 0 || (n.g ? n.V.indexOf(d) !== -1 ? o.o.push(n) : o.s.push(n) : (f = J(n), d = J(o.h), j(o.h), !Re(o.h) && n.P && (n = lt(d, f), rt(n, d) && (Ee(o, "clipped"), o.h = new T(n, !1)))));
    }
    function je() {
      this.g = /* @__PURE__ */ new Map(), this.h = null;
    }
    function V() {
      return B || (B = new je()), B;
    }
    var B = null;
    function H(t, n) {
      this.y = this.x = 0, this.width = t, this.height = n;
    }
    function he() {
      this.H = null, this.i = { apiVersion: "1.0", accessMode: "limited", environment: "web", omidJsInfo: { omidImplementer: "omsdk", serviceVersion: "1.5.6-iab144" }, adSessionType: "html", supports: ["clid", "vlid"] }, this.C = null, this.B = "foregrounded", this.s = this.j = "none", this.o = this.l = this.m = this.G = this.h = this.g = this.M = this.v = null, this.u = /* @__PURE__ */ new Map();
    }
    var ie = function() {
      if (typeof e != "undefined" && e) return e;
      if (typeof global != "undefined" && global) return global;
      if (typeof window != "undefined" && window) return window;
      if (typeof globalThis != "undefined" && globalThis) return globalThis;
      var t = Function("return this")();
      if (t) return t;
      throw Error("Could not determine global object context.");
    }();
    function ut(t) {
      if (t === ie) return !1;
      try {
        if (typeof t.location.hostname == "undefined") return !0;
      } catch (n) {
        return !0;
      }
      return !1;
    }
    function St() {
      var t = e;
      if (t == null || typeof t.top == "undefined" || t.top == null) return null;
      try {
        var n = t.top;
        return ut(n) ? null : n.location.href;
      } catch (o) {
        return null;
      }
    }
    function si(t, n) {
      this.g = t, this.h = n;
    }
    S.Object.defineProperties(si.prototype, { event: { configurable: !0, enumerable: !0, get: function() {
      return this.g;
    } }, origin: { configurable: !0, enumerable: !0, get: function() {
      return this.h;
    } } });
    function Be() {
      var t = O.apply(0, arguments);
      ee(function() {
        throw new (Function.prototype.bind.apply(Error, [null, "Could not complete the test successfully - "].concat(l(t))))();
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function oi() {
      var t = O.apply(0, arguments);
      ee(function() {
      }, function() {
        return console.error.apply(console, l(t));
      });
    }
    function ee(t, n) {
      typeof jasmine != "undefined" && jasmine ? t() : typeof console != "undefined" && console && console.error && n();
    }
    function Ht(t) {
      this.g = t, this.m = [], this.i = [], this.j = [], this.l = [], this.o = {};
    }
    function $t(t, n) {
      if (t.g !== void 0 && t.g.H && li(t, n) !== !1) {
        var o = n.event;
        t.j.filter(function(d) {
          return d.type === o.type;
        }).forEach(function(d) {
          t.h(d.I, o);
        });
      }
    }
    function ge(t, n) {
      t.m.push(n), $t(t, n);
    }
    function ai(t, n, o) {
      t.g !== void 0 && t.g.H && t.m.filter(function(d) {
        return d.event.type === n && li(t, d);
      }).map(function(d) {
        return d.event;
      }).forEach(function(d) {
        t.h(o.I, d);
      });
    }
    function li(t, n) {
      var o = n.event.type, d = Object.values(U).indexOf(o) !== -1 && o !== "volumeChange";
      return o === "impression" || o === "loaded" && t.g.h ? n.origin === t.g.s : d ? n.origin === t.g.j : !0;
    }
    function we(t, n, o) {
      Object.keys(U).forEach(function(d) {
        d = U[d];
        var f = { type: d, U: o, I: n };
        t.j.push(f), ai(t, d, f);
      });
    }
    function di(t, n, o, d) {
      var f = { ba: o, U: d, I: n };
      t.l.push(f), t.i.forEach(function(v) {
        var R = z(v);
        v.event.type === "sessionStart" && u(t, R, f), t.h(f.I, R);
      });
    }
    function Mt(t, n, o) {
      var d = k(t, "sessionError", "native", { errorType: n, message: o });
      t.i.push(d), t.l.forEach(function(f) {
        t.h(f.I, d.event);
      });
    }
    function a(t, n) {
      if (t.o = Object.assign(t.o, n), n = t.g.i, n !== void 0) {
        n = Object.assign({}, F(ht(t, b(t, { context: n }), !0)), { supportsLoadedEvent: !!t.g.h || t.g.g == "video" }), Object.assign(n, { pageUrl: St(), contentUrl: t.g.C });
        var o = k(t, "sessionStart", "native", n);
        t.i.push(o), t.l.forEach(function(d) {
          var f = z(o);
          u(t, f, d), t.h(d.I, f);
        }, t), y(t);
      }
    }
    function u(t, n, o) {
      o.ba && (n.data.verificationParameters = t.o[o.ba]), o.U && (o = t.g.u.get(o.U)) && (n.data.verificationParameters = o.verificationParameters, n.data.context.accessMode = o.accessMode, o.accessMode === "full" && (t.g.l && (n.data.context.videoElement = t.g.l), t.g.m && (n.data.context.slotElement = t.g.m)));
    }
    function g(t) {
      var n = k(t, "sessionFinish", "native");
      t.i.push(n), t.l.forEach(function(o) {
        t.h(o.I, n.event);
      });
    }
    Ht.prototype.h = function(t) {
      var n = O.apply(1, arguments);
      try {
        t.apply(null, l(n));
      } catch (o) {
        oi(o);
      }
    };
    function y(t) {
      var n = t.m.filter(function(v) {
        return !!(Object.values(U).includes(v.event.type) && t.g.g == "video" && v.origin === t.g.j || v.event.type == "loaded" && t.g.g == "display" && v.origin === t.g.s);
      }).map(function(v) {
        return v.event;
      }), o = t.g.H || "", d = {};
      n = s(n);
      for (var f = n.next(); !f.done; d = { F: d.F }, f = n.next()) {
        if (d.F = f.value, d.F.adSessionId || (d.F.adSessionId = o), d.F.type == "loaded") {
          if (!t.g.h && t.g.g == "display") continue;
          d.F.data = ht(t, b(t, d.F.data));
        }
        t.j.filter(/* @__PURE__ */ function(v) {
          return function(R) {
            return R.type === v.F.type;
          };
        }(d)).forEach(/* @__PURE__ */ function(v) {
          return function(R) {
            return R.I(v.F);
          };
        }(d));
      }
    }
    function _(t, n) {
      e: {
        n = new Set(n), t = s(t.m.concat(t.i));
        for (var o = t.next(); !o.done; o = t.next()) if (o = o.value, n.has(o.event.type) && o.origin != "javascript") {
          n = !0;
          break e;
        }
        n = !1;
      }
      return n ? (Be("Event owner cannot be registered after its events have already been published."), !1) : !0;
    }
    function ce(t) {
      var n = t.g.s;
      return n != "none" && n != "javascript" ? (Be("Impression event is owned by " + (t.g.s + ", not javascript.")), !1) : !0;
    }
    function pe(t) {
      var n = t.g.j;
      return n != "none" && n != "javascript" ? (Be("Media events are owned by " + (t.g.j + ", not javascript.")), !1) : !0;
    }
    function ht(t, n, o) {
      return o = o === void 0 ? !1 : o, n = Object.assign({}, n), t.g.g && Object.assign(n, { mediaType: t.g.g }), t.g.h && (o || t.g.h !== "definedByJavaScript") && Object.assign(n, { creativeType: t.g.h }), n;
    }
    function F(t) {
      var n = V().h;
      return n ? Object.assign({}, t, { lastActivity: n }) : t;
    }
    function b(t, n) {
      return t.g.G ? Object.assign({}, n, { impressionType: t.g.G }) : n;
    }
    function k(t, n, o, d) {
      return new si({ adSessionId: t.g.H || "", timestamp: (/* @__PURE__ */ new Date()).getTime(), type: n, data: d }, o);
    }
    function z(t) {
      t = t.event;
      var n = t.data ? Object.assign({}, t.data) : void 0;
      return t.type === "sessionStart" && (n.context = Object.assign({}, n.context)), { adSessionId: t.adSessionId, timestamp: t.timestamp, type: t.type, data: n };
    }
    function nt(t, n, o) {
      n !== "start" && n !== "volumeChange" || (o && o.deviceVolume) != null || (o.deviceVolume = t.g.v);
    }
    function Cr(t, n, o) {
      if (o && (n === "start" || n === "volumeChange")) {
        n = o.videoPlayerVolume;
        var d = o.mediaPlayerVolume;
        n != null ? (Object.assign(o, { mediaPlayerVolume: n }), t.g.M = n) : d != null && (Object.assign(o, { videoPlayerVolume: d }), t.g.M = d);
      }
    }
    function Xn(t, n) {
      this.h = t, this.g = n;
    }
    function Vi() {
      var t;
      this.g = t = t === void 0 ? e : t;
    }
    Vi.prototype.setInterval = function(t, n) {
      return ui(this, "setInterval")(t, n);
    }, Vi.prototype.clearInterval = function(t) {
      ui(this, "clearInterval")(t);
    };
    function Yn(t, n) {
      ui(t, "clearTimeout")(n);
    }
    function ui(t, n) {
      return t.g && t.g[n] ? t.g[n] : xi(t, n);
    }
    function Gn(t, n, o, d) {
      if (t.g.document && t.g.document.body) {
        var f = t.g.document.createElement("img");
        f.width = 1, f.height = 1, f.style.display = "none", f.src = n, o && f.addEventListener("load", function() {
          return o();
        }), d && f.addEventListener("error", function() {
          return d();
        }), t.g.document.body.appendChild(f);
      } else xi(t, "sendUrl")(n, o, d);
    }
    function xi(t, n) {
      if (t.g && t.g.omidNative && t.g.omidNative[n]) return t.g.omidNative[n].bind(t.g.omidNative);
      throw Error('Native interface method "' + n + '" not found.');
    }
    function _r(t) {
      return !(!t || !t.tagName || t.tagName.toLowerCase() !== "iframe");
    }
    function Ke(t, n, o, d, f) {
      this.j = t, this.ca = n, this.X = o, this.i = d, this.$ = f, this.h = null, this.g = this.m = this.M = void 0, this.Z = !0, this.o = void 0, hi(this);
    }
    function hi(t) {
      if (!t.h) {
        var n;
        e: {
          if ((n = t.j.document) && n.getElementsByClassName && (n = n.getElementsByClassName("omid-element"))) {
            if (n.length == 1) {
              n = n[0];
              break e;
            }
            1 < n.length && t.Z && (Mt(t.X, "generic", "More than one element with 'omid-element' class name."), t.Z = !1);
          }
          n = null;
        }
        if (n && n.tagName && n.tagName.toLowerCase() === "video") t.i.l = n;
        else if (n && n.tagName) t.i.m = n;
        else return;
        ci(t);
      }
    }
    function ci(t) {
      t.i.l ? (t.h = t.i.l, t.s()) : t.i.m && (t.h = t.i.m, _r(t.h) ? t.i.o && t.s() : t.s());
    }
    function Wt(t) {
      t.g && (_r(t.h) ? t.i.o && (t.S(), Dr(t)) : (t.S(), Dr(t)));
    }
    Ke.prototype.v = function() {
      this.o && (this.j.document.removeEventListener("visibilitychange", this.o), this.o = void 0);
    }, Ke.prototype.s = function() {
      var t = this;
      this.o || (this.o = function() {
        t.i.B = t.j.document.hidden ? "backgrounded" : "foregrounded", Wt(t);
      }, this.j.document.addEventListener("visibilitychange", this.o), this.o());
    };
    function Dr(t) {
      if (t.M) {
        t.i.S = t.M, t = t.ca;
        var n = t.g.S, o = t.g.O;
        if (n && !n.T(o)) {
          o = Fe(n);
          var d = t.h;
          d.g.h != "audio" && ge(d, k(d, "geometryChange", "native", o)), t.g.O = n;
        }
      }
    }
    function Lr(t) {
      if (t.g && t.i.o) {
        var n = new T(t.i.o, !1), o = t.g.x;
        return t = t.g.y, n.x += o, n.y += t, n.J += o, n.K += t, n.P = !0, n;
      }
    }
    function bt(t, n, o, d, f, v) {
      Ke.call(this, t, o, d, f, v), this.u = n, this.l = void 0;
    }
    N(bt, Ke), bt.prototype.v = function() {
      this.l !== void 0 && (this.$.clearInterval(this.l), this.l = void 0), Ke.prototype.v.call(this);
    }, bt.prototype.s = function() {
      var t = this;
      Ke.prototype.s.call(this), this.h == null ? this.l = void 0 : this.l === void 0 && (this.l = this.$.setInterval(function() {
        return Mr(t);
      }, 200), Mr(this));
    }, bt.prototype.S = function() {
      if (this.m) {
        var t = Lr(this);
        if (t) {
          this.g.R = !1, t.R = !0;
          for (var n = !1, o = 0; o < this.g.N.length; o++) if (this.g.N[o].R) {
            this.g.N[o] = t, n = !0;
            break;
          }
          n || this.g.N.push(t);
        } else this.g.R = !0;
        n = this.u, o = this.i.B;
        var d = this.i.H, f = this.O();
        t = new it();
        var v = new T(this.m, !1);
        if (vt(t, v), Ne(n, v, t, d), f) if (v.aa) Ee(t, "backgrounded"), Ee(t, "noOutputDevice");
        else if (o === "backgrounded") Ee(t, "backgrounded");
        else if (t.g !== void 0) {
          for (n = 0; n < t.o.length; n++) Lt(t, t.o[n]) && t.v.push(t.o[n]);
          for (n = 0; n < t.s.length; n++) {
            if (o = Lt(t, t.s[n])) {
              e: {
                for (o = t.s[n], d = 0; d < t.j.length; d++) if (t.j[d].T(o)) {
                  o = !0;
                  break e;
                }
                o = !1;
              }
              o = !o;
            }
            o && (Ee(t, "obstructed"), t.j.push(t.s[n]));
          }
          Ue(t);
        } else Ee(t, "notFound");
        else t.m = ["unmeasurable"], t.l = void 0, t.u = 0, t.j = [], t.g && (n = t.g, o = {}, n = new T((o.x = 0, o.y = 0, o.width = n.width, o.height = n.height, o), n.g), t.g = n), t.h = Ge();
        this.M = t;
      }
    }, bt.prototype.O = function() {
      return br(this);
    };
    function Mr(t) {
      if (t.l !== void 0) {
        if (br(t)) {
          var n = t.j.top;
          n = new T(new H(n.innerWidth, n.innerHeight), !1);
        } else n = new T(new H(0, 0), !1);
        var o = t.h.getBoundingClientRect();
        (o.x == null || isNaN(o.x)) && (o.x = o.left), (o.y == null || isNaN(o.y)) && (o.y = o.top), o = new T(o, !1), n.T(t.m) && o.T(t.g) || (t.g = o, t.g.P = !0, t.m = n, t.m.N.push(t.g), Wt(t));
      }
    }
    function br(t) {
      try {
        var n = t.j.top;
        return 0 <= n.innerHeight && 0 <= n.innerWidth;
      } catch (o) {
      }
      return !1;
    }
    function Pt(t, n, o, d, f, v) {
      Ke.call(this, t, o, d, f, v), this.C = this.u = this.B = this.l = void 0, this.Y = !1, this.G = void 0;
    }
    N(Pt, Ke), Pt.prototype.v = function() {
      this.l && this.l.disconnect(), Pr(this), Ke.prototype.v.call(this);
    }, Pt.prototype.s = function() {
      if (Ke.prototype.s.call(this), this.h && (this.l || (this.l = Kn(this)), wr(this), Vr(this.h) && zn(this), this.i.B === "backgrounded")) {
        var t = pi(new H(0, 0));
        this.G = this.g = this.m = t, Wt(this);
      }
    }, Pt.prototype.S = function() {
      if (this.g && this.G) {
        var t = Lr(this);
        if (t) {
          var n = t, o = this.G, d = Math.max(t.x, o.x), f = Math.max(t.y, o.y), v = Math.min(t.J, o.J);
          t = Math.min(t.K, o.K), v <= d || t <= f ? d = null : (o = {}, d = new T((o.x = d, o.y = f, o.width = Math.abs(v - d), o.height = Math.abs(t - f), o), !1)), d || (d = new T({ x: 0, y: 0, width: 0, height: 0 }, !1));
        } else n = this.g, d = this.G;
        f = new it(), this.m && vt(f, this.m), (v = this.i.B == "backgrounded") && Ee(f, "backgrounded"), f.g = n, f.h = d, Ue(f), this.Y ? !v && Re(f.g) ? Ee(f, "hidden") : v || f.u === 100 || Ee(f, "clipped") : Ee(
          f,
          "viewport"
        ), this.M = f;
      }
    }, Pt.prototype.O = function() {
      return !0;
    };
    function Pr(t) {
      t.B && (t.B.disconnect(), t.B = void 0), t.u && (t.u.disconnect(), t.u = void 0), t.C && ((0, t.j.removeEventListener)("resize", t.C), t.C = void 0);
    }
    function wr(t) {
      t.l && t.h && (t.l.unobserve(t.h), t.l.observe(t.h));
    }
    function Vr(t) {
      return t = t.getBoundingClientRect(), t.width == 0 || t.height == 0;
    }
    function Kn(t) {
      return new t.j.IntersectionObserver(function(n) {
        try {
          if (n.length) {
            for (var o, d = n[0], f = 1; f < n.length; f++) n[f].time > d.time && (d = n[f]);
            o = d, t.m = pi(o.rootBounds), t.g = pi(o.boundingClientRect), t.G = pi(o.intersectionRect), t.Y = !!o.isIntersecting, Wt(t);
          }
        } catch (v) {
          t.v(), Mt(t.X, "generic", "Problem handling IntersectionObserver callback: " + v.message);
        }
      }, { root: null, rootMargin: "0px", threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1] });
    }
    function zn(t) {
      t.j.ResizeObserver ? t.B || (t.B = Qn(t, function() {
        return ki(t);
      }), t.B.observe(t.h)) : (t.C || (t.C = function() {
        return ki(t);
      }, (0, t.j.addEventListener)("resize", t.C)), t.u || (t.u = new MutationObserver(function() {
        return ki(t);
      }), t.u.observe(t.h, { childList: !1, attributes: !0, subtree: !1 })));
    }
    function ki(t) {
      t.h && !Vr(t.h) && (wr(t), Pr(t));
    }
    function Qn(t, n) {
      return new t.j.ResizeObserver(n);
    }
    function pi(t) {
      if (t && t.x !== null && t.y !== null && t.width !== null && t.height !== null) return new T(t, !1);
    }
    function Fi(t) {
      if (typeof t == "object" && typeof t.webOSSystem == "object") return t.webOSSystem;
    }
    function fi(t) {
      return typeof Fi(t) == "object";
    }
    function wt(t) {
      if (typeof t == "object" && typeof t.tizen == "object") return t.tizen;
    }
    function yt(t) {
      return typeof wt(t) == "object";
    }
    function Jn(t, n) {
      this.h = t, this.g = n;
    }
    function Ui() {
      return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(t) {
        var n = 16 * Math.random() | 0;
        return t === "y" ? (n & 3 | 8).toString(16) : n.toString(16);
      });
    }
    function Zn(t, n) {
      var o = o === void 0 ? ie : o;
      this.i = t, this.g = o, this.j = n, this.h = [];
    }
    function xr(t) {
      if (!t.g || !t.g.document) throw Error("OMID Service Script is not running within a window.");
      var n = t.h;
      t.h = [], n.forEach(function(o) {
        try {
          var d = o.accessMode, f = typeof d == "string" && Object.values(D).indexOf(d) !== -1 ? o.accessMode : null, v = f ? f == "domain" ? "limited" : f : "limited";
          o.accessMode = v;
          e: {
            var R = o.resourceUrl, I = t.g.location.origin;
            try {
              var C = new URL(R, I);
              break e;
            } catch (ze) {
            }
            try {
              C = new URL(R);
              break e;
            } catch (ze) {
            }
            C = null;
          }
          if (d = C) {
            var x = Ui();
            es(t, x, d, v);
            var q = o.vendorKey, fe = o.verificationParameters;
            q = q === void 0 ? "" : q, fe = fe === void 0 ? "" : fe, q && typeof q == "string" && q !== "" && fe && typeof fe == "string" && fe !== "" && (t.i.o[q] = fe), t.j.u.set(x, o);
          }
        } catch (ze) {
          oi("OMID verification script " + o.resourceUrl + " failed to load: " + ze);
        }
      });
    }
    function es(t, n, o, d) {
      var f = t.g.document, v = f.createElement("iframe");
      if (v.id = "omid-verification-script-frame-" + n, v.style.display = "none", d == "full") {
        var R = function() {
          var I = v.contentWindow;
          I.omidVerificationProperties = { serviceWindow: t.g, injectionSource: "web", injectionId: n }, I = I.document;
          var C = I.createElement("script");
          C.src = o.href, I.head.appendChild(C), v.removeEventListener("load", R);
        };
        v.addEventListener("load", R);
      } else d == "limited" && (v.srcdoc = `<html><head>
<script type="text/javascript">window['omidVerificationProperties'] = {
'serviceWindow': window.parent,
'injectionSource': 'web',
'injectionId': '` + (n + `',
};<\/script>
<script type="text/javascript" src="`) + o.href + `"><\/script>
</head><body></body></html>`, v.sandbox = "allow-scripts");
      f.body.appendChild(v), V().g.set(n, v);
    }
    function ji(t, n) {
      var o = window, d = this;
      if (fi(o)) if (o) if (o.WebOSServiceBridge) {
        this.i = t, this.h = n, this.g = new o.WebOSServiceBridge(), this.g.onservicecallback = function(f) {
          try {
            var v = JSON.parse(f);
            if (v && v.errorCode) d.error(f);
            else if (!v) d.error("No object recieved from webOS bridge");
            else if (!Ai(d, f, v, "volumeStatus", "object")) {
              var R = v.volumeStatus;
              Ai(d, f, R, "muteStatus", "boolean") || Ai(d, f, R, "volume", "number") || Ai(d, f, R, "maxVolume", "number") || (0 >= R.maxVolume ? d.error("Invalid max volume status.") : d.i(R.muteStatus ? 0 : R.volume / R.maxVolume));
            }
          } catch (I) {
            d.error(I);
          }
        };
        try {
          this.g.call("luna://com.webos.service.audio/master/getVolume", '{"subscribe":true}');
        } catch (f) {
          this.error(f);
        }
      } else this.h("No WebOSServiceBridge on windowContext");
      else this.h("No window context");
    }
    ji.prototype.stop = function() {
      this.g && this.g.cancel && this.g.cancel(), this.g = null;
    }, ji.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function Ai(t, n, o, d, f) {
      return typeof o[d] === f ? !1 : (t.error('Unexpected formatting on message from webOS bridge: "' + n + '". Expected "' + d + '" to be of type "' + f + '" but was of type "' + typeof o[d] + '".'), !0);
    }
    function kr(t) {
      return yt(t) ? typeof wt(t).tvinputdevice == "object" : !1;
    }
    function mi(t, n) {
      var o = window, d = this;
      if (o) if (this.validate(o)) {
        this.h = n;
        var f = wt(o).tvaudiocontrol;
        this.g = void 0, n = function() {
          var v = f.isMute() ? 0 : f.getVolume() / 100;
          (d.g === void 0 || d.g != v) && (d.g = v, t(d.g));
        }, n(), this.i = o.setInterval(n, 200), this.j = o;
      } else n("Invalid Tizen window context");
      else n("No window context");
    }
    mi.prototype.stop = function() {
      this.i !== void 0 && typeof this.j.clearInterval == "function" && this.j.clearInterval(this.i), this.h = this.g = this.i = void 0;
    }, mi.prototype.validate = function(t) {
      return yt(t) && kr(t) && typeof wt(t).tvaudiocontrol == "object" && typeof t.setInterval == "function" && typeof t.clearInterval == "function";
    }, mi.prototype.error = function(t) {
      this.stop(), this.h && this.h(t);
    };
    function Fr(t, n, o, d, f) {
      var v = this;
      this.g = t, this.i = n, this.h = o, this.l = d, this.o = f, this.m = !1, Bi(this, function(R) {
        if (R.type === "sessionStart") {
          v.m = !0;
          try {
            xr(v.l);
          } catch (I) {
            Be(I.message);
          }
        }
        R.type === "sessionFinish" && (v.m = !1);
      });
    }
    function Bi(t, n, o, d) {
      di(t.i, n, o, d);
    }
    i = Fr.prototype, i.setSlotElement = function(t) {
      t && t.tagName ? (this.g.m = t, this.h && ci(this.h)) : Be("setSlotElement called with a non-HTMLElement.  It will be ignored.");
    }, i.setElementBounds = function(t) {
      this.g.o = t, this.h && ci(this.h), this.h && Wt(this.h);
    }, i.error = function(t, n) {
      Mt(this.i, t, n);
    }, i.injectVerificationScriptResources = function(t) {
      var n = this.l;
      if (n.h.push.apply(n.h, l(t)), this.m) try {
        xr(this.l);
      } catch (o) {
        Be(o.message);
      }
    }, i.setCreativeType = function(t, n) {
      n = n === void 0 ? null : n, (!this.g.g || this.g.h) && (this.g.h = t, t == "video" || t == "audio" ? this.g.g = "video" : t == "htmlDisplay" || t == "nativeDisplay" ? this.g.g = "display" : t == "definedByJavaScript" && n && (this.g.g = n == "none" ? "display" : "video"));
    }, i.setImpressionType = function(t) {
      (!this.g.g || this.g.h) && (this.g.G = t);
    }, i.setClientInfo = function(t, n, o) {
      var d = this.g.i || {};
      return d.omidJsInfo = Object.assign({}, d.omidJsInfo, { sessionClientVersion: t, partnerName: n, partnerVersion: o }), this.g.i = d, this.g.i.omidJsInfo.serviceVersion;
    };
    function ts(t) {
      if (yt(window) || fi(window)) {
        var n = function(d) {
          if (t.g.v !== d && t.i.g.j !== "none" && typeof d == "number" && !isNaN(d)) {
            t.g.v = d;
            var f = t.o, v = f.g.M;
            v != null && (d = f.h, f = { mediaPlayerVolume: v, deviceVolume: f.g.v }, nt(d, "volumeChange", f), Cr(d, "volumeChange", f), ge(d, k(d, "volumeChange", "native", f)));
          }
        }, o = function(d) {
          Be(d);
        };
        fi(window) ? t.j = new ji(n, o) : yt(window) && (t.j = new mi(n, o));
      }
    }
    function Ur(t, n) {
      if (!n) return t.g;
      for (var o = s(t.h.values()), d = o.next(); !d.done; d = o.next()) if (d = d.value, d.g.u.has(n)) return d;
      return t.g;
    }
    function De(t, n) {
      return n == null ? t.g : t.h.get(n) || t.g;
    }
    function qi(t) {
      var n = new he(), o = new Ht(n), d = new Pe(), f = new Se(), v = new Xn(o, n);
      t = t.i;
      var R = e;
      return d = R ? R.IntersectionObserver && (R.MutationObserver || R.ResizeObserver) ? new Pt(R, d, v, o, n, t) : new bt(R, f, v, o, n, t) : null, new Fr(n, o, d, new Zn(o, n), new Jn(o, n));
    }
    function Vt(t, n, o, d) {
      this.h = t, this.method = n, this.version = o, this.g = d;
    }
    function jr(t) {
      return !!t && t.omid_message_guid !== void 0 && t.omid_message_method !== void 0 && t.omid_message_version !== void 0 && typeof t.omid_message_guid == "string" && typeof t.omid_message_method == "string" && typeof t.omid_message_version == "string" && (t.omid_message_args === void 0 || t.omid_message_args !== void 0);
    }
    function Br(t) {
      return new Vt(t.omid_message_guid, t.omid_message_method, t.omid_message_version, t.omid_message_args);
    }
    function qr(t) {
      var n = {};
      return n = (n.omid_message_guid = t.h, n.omid_message_method = t.method, n.omid_message_version = t.version, n), t.g !== void 0 && (n.omid_message_args = t.g), n;
    }
    function Hr(t) {
      this.i = t;
    }
    function xt(t) {
      this.i = t, this.handleExportedMessage = xt.prototype.j.bind(this);
    }
    N(xt, Hr), xt.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.handleExportedMessage(qr(t), this);
    }, xt.prototype.j = function(t, n) {
      jr(t) && this.g && this.g(Br(t), n);
    };
    function Ei(t) {
      return Hi(t, "SessionService.");
    }
    function Hi(t, n) {
      return (t = t.match(new RegExp("^" + n + "(.*)"))) && t[1];
    }
    function $i(t, n) {
      this.h = t, this.i = n;
    }
    $i.prototype.g = function(t) {
      var n = O.apply(1, arguments);
      e: switch (t) {
        case "registerSessionObserver":
          var o = n.slice(1);
          break e;
        default:
          o = n;
      }
      return this.h("SessionService." + t, this.j.bind(this, t, n), o);
    }, $i.prototype.j = function(t, n, o) {
      switch (t) {
        case "registerSessionObserver":
          t = s(n).next().value, t(o);
      }
    };
    function te(t, n) {
      return t.g.bind(t, n);
    }
    function is(t, n) {
      n = n === void 0 ? ie : n, n.omidSessionInterface == null && (t = { setSessionClientWindow: t.i, setClientInfo: te(t, "setClientInfo"), registerSessionObserver: te(t, "registerSessionObserver"), startAdSession: te(t, "startSession"), finishAdSession: te(t, "finishSession"), reportError: te(t, "sessionError"), registerAdEvents: te(t, "registerAdEvents"), registerMediaEvents: te(t, "registerMediaEvents"), injectVerificationScriptResources: te(t, "injectVerificationScriptResources"), setSlotElement: te(t, "setSlotElement"), setVideoElement: te(
        t,
        "setVideoElement"
      ), setElementBounds: te(t, "setElementBounds"), setCreativeType: te(t, "setCreativeType"), setImpressionType: te(t, "setImpressionType"), setContentUrl: te(t, "setContentUrl"), adEvents: { impressionOccurred: te(t, "impressionOccurred"), loaded: te(t, "loaded") }, mediaEvents: {
        start: te(t, "start"),
        firstQuartile: te(t, "firstQuartile"),
        midpoint: te(t, "midpoint"),
        thirdQuartile: te(t, "thirdQuartile"),
        complete: te(t, "complete"),
        pause: te(t, "pause"),
        resume: te(t, "resume"),
        bufferStart: te(t, "bufferStart"),
        bufferFinish: te(t, "bufferFinish"),
        skipped: te(t, "skipped"),
        volumeChange: te(t, "volumeChange"),
        playerStateChange: te(t, "playerStateChange"),
        adUserInteraction: te(t, "adUserInteraction")
      } }, t.mediaEvents.loaded = t.adEvents.loaded, t.videoEvents = t.mediaEvents, Object.freeze(t), Object.defineProperty(n, "omidSessionInterface", { value: t, writable: !1 }));
    }
    function gi(t, n) {
      this.i = n = n === void 0 ? ie : n;
      var o = this;
      t.addEventListener("message", function(d) {
        if (typeof d.data == "object") {
          var f = d.data;
          jr(f) && d.source && o.g && o.g(Br(f), d.source);
        }
      });
    }
    N(gi, Hr), gi.prototype.h = function(t, n) {
      if (n = n === void 0 ? this.i : n, !n) throw Error("Message destination must be defined at construction time or when sending the message.");
      n.postMessage(qr(t), "*");
    };
    function $r() {
      this.g = nn;
    }
    i = $r.prototype, i.registerSessionObserver = function(t, n) {
      Bi(De(this.g, t), n);
    }, i.setSlotElement = function(t, n) {
      De(this.g, t).setSlotElement(n);
    }, i.setElementBounds = function(t, n) {
      De(this.g, t).setElementBounds(n);
    }, i.error = function(t, n, o) {
      De(this.g, t).error(n, o);
    };
    function ye(t, n, o, d) {
      t = De(t.g, n), o == "impression" ? ce(t.i) && (o = t.i, d = (d = o.g.O) ? Fe(d) : null, d = ht(o, b(o, d)), ge(o, k(o, "impression", "javascript", d)), t.h && hi(t.h)) : (o == "loaded" ? (n = d, n = n === void 0 ? null : n, pe(t.i) && (d = t.i, d.g.h || d.g.g != "display") && (n = k(d, "loaded", "javascript", ht(d, b(d, n === void 0 ? null : n))), ge(d, n))) : pe(t.i) && (n = t.i, nt(n, o, d), Cr(n, o, d), ge(n, k(n, o, "javascript", d))), ["loaded", "start"].includes(o) && t.h && hi(t.h));
    }
    i.injectVerificationScriptResources = function(t, n) {
      De(this.g, t).injectVerificationScriptResources(n);
    }, i.setCreativeType = function(t, n, o) {
      o = o === void 0 ? null : o, De(this.g, t).setCreativeType(n, o);
    }, i.setImpressionType = function(t, n) {
      De(this.g, t).setImpressionType(n);
    }, i.setClientInfo = function(t, n, o, d) {
      var f = this.g;
      if (t == null) t = f.g;
      else {
        var v = [].concat(l(f.h.values())).includes(f.g) ? qi(f) : f.g;
        f.h.set(t, v), t = v;
      }
      return t.setClientInfo(n, o, d);
    };
    function Wr(t) {
      t = t.split("-")[0].split(".");
      for (var n = ["1", "0", "3"], o = 0; 3 > o; o++) {
        var d = parseInt(t[o], 10), f = parseInt(n[o], 10);
        if (d > f) break;
        if (d < f) return !1;
      }
      return !0;
    }
    function Xr(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && Wr(t) ? n : JSON.stringify(n);
    }
    function Yr(t, n) {
      return /\d+\.\d+\.\d+(-.*)?/.test(t) && Wr(t) ? n || [] : n && typeof n == "string" ? JSON.parse(n) : [];
    }
    function Wi() {
      var t = ls, n = this, o = o === void 0 ? e : o;
      this.g = t, this.h = o, this.j = new xt(), this.h.omid = this.h.omid || {}, this.h.omid.v1_SessionServiceCommunication = this.j, this.i = o && o.addEventListener && o.postMessage ? new gi(o) : null, this.m = null, this.j.g = this.l.bind(this), this.i && (this.i.g = this.o.bind(this)), this.s = new $i(function(d, f, v) {
        try {
          Kr(n, d, f, v);
        } catch (R) {
          Be(zr(R));
        }
      }, function(d) {
        n.m = d;
        var f = Ui();
        n.i.h(new Vt(f, "identifyServiceWindow", "1.5.6-iab144"), d);
      }), is(this.s, this.h);
    }
    Wi.prototype.l = function(t, n) {
      Ei(t.method) != null && Gr(this, t, n, this.j);
    }, Wi.prototype.o = function(t, n) {
      if (Ei(t.method) != null) {
        if (!this.m || n !== this.m) return Be("Unrecognized session client window. Cross-origin session clients must register via the setSessionClientWindow API. See https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/iframes.html#om-sdk-js-session-client"), !1;
        Gr(this, t, n, this.i);
      }
    };
    function Gr(t, n, o, d) {
      function f() {
        var C = new Vt(v, "response", I, Xr(I, O.apply(0, arguments)));
        d.h(C, o);
      }
      var v = n.h, R = n.method, I = n.version;
      n = Yr(I, n.g);
      try {
        Kr(t, R, f, n);
      } catch (C) {
        d.h(new Vt(v, "error", I, zr(C)), o);
      }
    }
    function Kr(t, n, o, d) {
      if (Ei(n) != null) switch (Ei(n)) {
        case "registerAdEvents":
          var f = s(d).next().value, v = De(t.g.g, f).i;
          _(v, ["impression"]) && ce(v) && (v.g.s = "javascript");
          break;
        case "registerMediaEvents":
          var R = s(d).next().value, I = De(t.g.g, R).i;
          _(I, Object.values(U)) && pe(I) && (I.g.j = "javascript");
          break;
        case "registerSessionObserver":
          var C = s(d).next().value;
          t.g.registerSessionObserver(C, o);
          break;
        case "setSlotElement":
          var x = s(d), q = x.next().value, fe = x.next().value;
          t.g.setSlotElement(fe, q);
          break;
        case "setVideoElement":
          var ze = s(d), st = ze.next().value, It = ze.next().value, Ve = De(t.g.g, It);
          st && st.tagName && st.tagName.toLowerCase() === "video" ? (Ve.g.l = st, Ve.h && ci(Ve.h)) : Be("setVideoElement called with a non-HTMLVideoElement. It will be ignored.");
          break;
        case "setElementBounds":
          var Si = s(d), Yi = Si.next().value, Gi = Si.next().value;
          t.g.setElementBounds(Gi, Yi);
          break;
        case "startSession":
          var Xt = s(d), We = Xt.next().value, yi = Xt.next().value, Xe = t.h;
          if (We != null && typeof We == "object") {
            var Yt = We.customReferenceData, Ce = We.underEvaluation, sn = We.universalAdId;
            typeof Yt == "string" || (Yt = void 0), typeof Ce == "boolean" || (Ce = !1);
            var ct = { customReferenceData: Yt, underEvaluation: Ce };
            if (typeof sn == "string" && (ct.universalAdId = sn), fi(Xe)) {
              var on = Fi(Xe), Ii;
              typeof on == "object" && (Ii = on.identifier), ct.app = { appId: Ii && typeof Ii == "string" ? Ii : void 0 };
              e: {
                var an = Fi(Xe);
                if (typeof an == "object") {
                  try {
                    var ln = JSON.parse(an.deviceInfo);
                  } catch (Ks) {
                    var Ki = void 0;
                    break e;
                  }
                  Ki = { deviceType: ln.modelName || "Unknown", osVersion: ln.platformVersion || "Unknown", os: "webOS" };
                } else Ki = void 0;
              }
              ct.deviceInfo = Ki, ct.deviceCategory = "ctv";
            } else if (yt(Xe)) {
              e: {
                if (yt(Xe)) {
                  try {
                    var dn = wt(Xe).application.getCurrentApplication().appInfo.id;
                  } catch (Ks) {
                    var zi = void 0;
                    break e;
                  }
                  if (typeof dn == "string") {
                    zi = dn;
                    break e;
                  }
                }
                zi = void 0;
              }
              if (ct.app = { appId: zi }, yt(Xe)) {
                var Oi = wt(Xe).systeminfo;
                if (typeof Oi == "object" && typeof Oi.getCapability == "function")
                  var ds = Oi.getCapability("http://tizen.org/system/model_name"), us = Oi.getCapability("http://tizen.org/feature/platform.version");
                var un = { deviceType: ds || "Unknown", osVersion: us || "Unknown", os: "tizen" };
              } else un = void 0;
              ct.deviceInfo = un, kr(Xe) && (ct.deviceCategory = "ctv");
            }
            We = ct;
          } else We = null;
          if (We == null) break;
          var Ot = We, Qi = Qi === void 0 ? null : Qi, pt = De(t.g.g, yi), hn = pt.g.i;
          hn.sessionOwner || (hn.sessionOwner = "javascript");
          var hs = yi || Ui();
          pt.g.H = hs, Ot.canMeasureVisibility = pt.h.O();
          var Ji = pt.g;
          Ot.contentUrl !== void 0 && (Ji.C = Ot.contentUrl, Ot.contentUrl = void 0);
          var cn = Ji.i || {};
          Ot.omidJsInfo = Object.assign({}, cn.omidJsInfo || {}, Ot.omidJsInfo || {});
          var cs = Object.assign({}, cn, Ot);
          Ji.i = cs, a(pt.i, Qi), pt.h && hi(pt.h), ts(pt);
          break;
        case "finishSession":
          var ps = s(d).next().value, pn = t.g, Gt = De(pn.g, ps), fn = pn.g;
          fn.g = qi(fn), g(Gt.i), Gt.h.v(), Gt.j && (Gt.j.stop(), Gt.j = null);
          break;
        case "impressionOccurred":
          var fs = s(d).next().value;
          ye(t.g, fs, "impression");
          break;
        case "loaded":
          var An = s(d), kt = An.next().value, mn = An.next().value;
          if (kt) {
            var En = { skippable: kt.isSkippable, autoPlay: kt.isAutoPlay, position: kt.position };
            kt.isSkippable && (En.skipOffset = kt.skipOffset), ye(t.g, mn, "loaded", En);
          } else ye(t.g, mn, "loaded");
          break;
        case "start":
          var Zi = s(d), As = Zi.next().value, ms = Zi.next().value, Es = Zi.next().value;
          ye(t.g, Es, "start", { duration: As, mediaPlayerVolume: ms });
          break;
        case "firstQuartile":
          var gs = s(d).next().value;
          ye(t.g, gs, "firstQuartile");
          break;
        case "midpoint":
          var vs = s(d).next().value;
          ye(t.g, vs, "midpoint");
          break;
        case "thirdQuartile":
          var Ss = s(d).next().value;
          ye(t.g, Ss, "thirdQuartile");
          break;
        case "complete":
          var ys = s(d).next().value;
          ye(t.g, ys, "complete");
          break;
        case "pause":
          var Is = s(d).next().value;
          ye(t.g, Is, "pause");
          break;
        case "resume":
          var Os = s(d).next().value;
          ye(t.g, Os, "resume");
          break;
        case "bufferStart":
          var Ts = s(d).next().value;
          ye(t.g, Ts, "bufferStart");
          break;
        case "bufferFinish":
          var Rs = s(d).next().value;
          ye(t.g, Rs, "bufferFinish");
          break;
        case "skipped":
          var Ns = s(d).next().value;
          ye(t.g, Ns, "skipped");
          break;
        case "volumeChange":
          var gn = s(d), Cs = gn.next().value, _s = gn.next().value;
          ye(t.g, _s, "volumeChange", { mediaPlayerVolume: Cs });
          break;
        case "playerStateChange":
          var vn = s(d), Ds = vn.next().value, Ls = vn.next().value;
          ye(t.g, Ls, "playerStateChange", { state: Ds });
          break;
        case "adUserInteraction":
          var Sn = s(d), Ms = Sn.next().value, bs = Sn.next().value;
          ye(t.g, bs, "adUserInteraction", { interactionType: Ms });
          break;
        case "setClientInfo":
          var Ti = s(d), Ps = Ti.next().value, ws = Ti.next().value, Vs = Ti.next().value, xs = Ti.next().value, ks = t.g.setClientInfo(xs, Ps, ws, Vs);
          o(ks);
          break;
        case "injectVerificationScriptResources":
          var yn = s(d), Fs = yn.next().value, Us = yn.next().value;
          t.g.injectVerificationScriptResources(Us, Fs);
          break;
        case "setCreativeType":
          var In = s(d), js = In.next().value, Bs = In.next().value;
          t.g.setCreativeType(Bs, js);
          break;
        case "setImpressionType":
          var On = s(d), qs = On.next().value, Hs = On.next().value;
          t.g.setImpressionType(Hs, qs);
          break;
        case "setContentUrl":
          var Tn = s(d), $s = Tn.next().value, Ws = Tn.next().value;
          De(t.g.g, Ws).g.C = $s;
          break;
        case "sessionError":
          var er = s(d), Xs = er.next().value, Ys = er.next().value, Gs = er.next().value;
          t.g.error(Gs, Xs, Ys);
      }
    }
    function zr(t) {
      return `
        name: ` + t.name + `
        message: ` + t.message + `
        filename: ` + t.filename + `
        lineNumber: ` + t.lineNumber + `
        columnNumber: ` + t.columnNumber + `
        stack: ` + t.stack + `
        toString(): ` + t.toString();
    }
    function Xi() {
      var t = nn, n = rn, o = this, d = d === void 0 ? ie : d;
      this.j = t, this.g = n, this.l = {}, this.m = {}, this.i = new xt(), d.omid = d.omid || {}, d.omid.v1_VerificationServiceCommunication = this.i, this.h = null, d && d.addEventListener && d.postMessage && (this.h = new gi(d)), this.i.g = function(f, v) {
        Jr(o, f, v, o.i);
      }, this.h && (this.h.g = function(f, v) {
        o.h && Jr(o, f, v, o.h);
      });
    }
    function Qr(t) {
      t({ adSessionId: "", timestamp: (/* @__PURE__ */ new Date()).getTime(), type: "sessionError", data: { errorType: "generic", message: "Registration to session events is only allowed for verification clients injected by the OM-SDK service itself. Please note that in a future release registration in this manner will be rejected." } });
    }
    function rs(t, n, o, d) {
      t = Ur(t.j, d), d !== void 0 && t.g.u.has(d) ? (t = t.i, n === "media" || n === "video" ? we(t, o, d) : (o = { type: n, U: d, I: o }, t.j.push(o), ai(t, n, o))) : Qr(o);
    }
    function ns(t, n, o, d) {
      t = Ur(t.j, d), d !== void 0 && t.g.u.has(d) ? Bi(t, n, o, d) : Qr(n);
    }
    function ss(t, n, o, d) {
      Gn(t.g, n, o, d);
    }
    Xi.prototype.setInterval = function(t, n) {
      return this.g.setInterval(t, n);
    }, Xi.prototype.clearInterval = function(t) {
      this.g.clearInterval(t);
    };
    function os(t, n, o, d) {
      xi(t.g, "downloadJavaScriptResource")(n, o, d);
    }
    function Jr(t, n, o, d) {
      function f() {
        var Ce = new Vt(v, "response", I, Xr(I, O.apply(0, arguments)));
        d.h(Ce, o);
      }
      var v = n.h, R = n.method, I = n.version;
      if (n = Yr(I, n.g), Hi(R, "VerificationService.") != null) {
        R = Hi(R, "VerificationService.");
        try {
          switch (R) {
            case "addEventListener":
              var C = s(n), x = C.next().value, q = C.next().value || Zr(o);
              rs(t, x, f, q);
              break;
            case "addSessionListener":
              var fe = s(n), ze = fe.next().value, st = fe.next().value || Zr(o);
              ns(t, f, ze, st);
              break;
            case "sendUrl":
              var It = s(n).next().value;
              ss(t, It, function() {
                return f(!0);
              }, function() {
                return f(!1);
              });
              break;
            case "setTimeout":
              var Ve = s(n), Si = Ve.next().value, Yi = Ve.next().value;
              t.l[Si] = ui(t.g, "setTimeout")(f, Yi);
              break;
            case "clearTimeout":
              var Gi = s(n).next().value;
              Yn(t.g, t.l[Gi]);
              break;
            case "setInterval":
              var Xt = s(n), We = Xt.next().value, yi = Xt.next().value;
              t.m[We] = t.setInterval(f, yi);
              break;
            case "clearInterval":
              var Xe = s(n).next().value;
              t.clearInterval(t.m[Xe]);
              break;
            case "injectJavaScriptResource":
              var Yt = s(n).next().value;
              os(t, Yt, function(Ce) {
                return f(!0, Ce);
              }, function() {
                return f(!1);
              });
              break;
            case "getVersion":
              f("1.5.6-iab144");
          }
        } catch (Ce) {
          d.h(new Vt(
            v,
            "error",
            I,
            `
              name: ` + Ce.name + `
              message: ` + Ce.message + `
              filename: ` + Ce.filename + `
              lineNumber: ` + Ce.lineNumber + `
              columnNumber: ` + Ce.columnNumber + `
              stack: ` + Ce.stack + `
              toString(): ` + Ce.toString() + `
          `
          ), o);
        }
      }
    }
    function Zr(t) {
      for (var n = V().g, o = s(n.keys()), d = o.next(); !d.done; d = o.next()) {
        d = d.value;
        var f = n.get(d);
        if (f) {
          if (f.contentWindow === t) return d;
          try {
            if (f.contentWindow.Object.prototype.isPrototypeOf(t)) return d;
          } catch (v) {
          }
        }
      }
    }
    function en(t) {
      var n = {};
      return (n.app = "omid_v1_present_app", n.web = "omid_v1_present_web", n)[t];
    }
    function tn(t, n) {
      t.document.write('<iframe style="display:none" id="' + (n + '" name="' + n + '" sandbox></iframe>'));
    }
    function vi(t, n) {
      var o = t.document.createElement("iframe");
      o.id = n, o.name = n, o.style.display = "none", o.sandbox = "", t.document.body.appendChild(o);
    }
    function as(t, n) {
      var o = new MutationObserver(function(d) {
        d.forEach(function(f) {
          f.addedNodes[0].nodeName === "BODY" && (f = en(n), vi(t, "omid_v1_present"), vi(t, f), o.disconnect());
        });
      });
      o.observe(t.document.documentElement, { childList: !0 });
    }
    var rn = new Vi(), nn = new function() {
      this.i = rn, this.h = /* @__PURE__ */ new Map(), this.g = qi(this);
    }(), ls = new $r();
    new Xi(), new Wi(), function(t, n) {
      t.frames && t.document && !["omid_v1_present", "omid_v1_present_web", "omid_v1_present_app"].some(function(o) {
        return !!t.frames[o];
      }) && (t.document.body == null && "MutationObserver" in t ? as(t, n) : (n = en(n), t.document.body ? (vi(t, "omid_v1_present"), vi(t, n)) : (tn(t, "omid_v1_present"), tn(t, n))));
    }(ie, "web");
  }).call(A, A);
}
const kn = "4.0", Fn = ["4.0"], Nr = class Nr {
  constructor() {
    this.OmidServiceClient = Po();
  }
  /** @internal */
  detectOMID(e) {
    const i = "omid_v1_present", r = window;
    let s = !1;
    try {
      const l = e.omidServiceWindow;
      s = l.frames ? !!l.frames[i] : !1;
    } catch (l) {
      c.debug.warn("detectOMID: Publisher-Service could not be recognized.", l);
    }
    s || (c.debug.info("detectOMID: Publisher-Service not present. Using internal service."), e.omidServiceWindow = r);
  }
  /**
   * Checks if the provided player facade has a valid handshake version.
   *
   * @internal
   * @param {Object} playerFacade - The player facade object with a handshakeVersion method.
   * @param {string} [facadeVersion=FACADE_VERSION] - The expected facade version.
   * @param {string[]} [supportedFacadeVersions=SUPPORTED_FACADE_VERSIONS] - An array of supported facade versions.
   * @returns {boolean} True if the handshake is valid, otherwise false.
   */
  /** @internal */
  hasValidHandshake(e, i = kn, r = Fn) {
    if (!e.handshakeVersion)
      return !1;
    const s = e.handshakeVersion(i);
    return r.includes(s);
  }
  /**
   * Checks whether a `playerFacade` instance implements all expected functions and properties of `FacadeBase`.
   *
   * @internal
   * @param {PlayerFacade} playerFacade - The `playerFacade` instance to be checked.
   * @param {typeof FacadeBase} Facade - The class from which `playerFacade` is expected to implement.
   * @returns {boolean} - True if the implementation is correct, otherwise false.
   */
  /** @internal */
  hasValidFacadeImplementation(e, i = Js) {
    return Object.getOwnPropertyNames(Object.getPrototypeOf(new i())).filter((l) => !(l in e)).length <= 0;
  }
  /**
   * Establishes a connection between the core and the provided player facade to control the audio/video player.
   *
   * @internal
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @returns {void} This function does not return a value but sets the 'error' property on failure.
   */
  /** @internal */
  validate(e) {
    if (!e) {
      this.error = w.SETUP.NO_FACADE;
      return;
    }
    if (!this.hasValidHandshake(e)) {
      this.error = w.SETUP.INVALID_HANDSHAKE;
      return;
    }
    if (!this.hasValidFacadeImplementation(e)) {
      this.error = w.SETUP.INCORRECT_FACADE;
      return;
    }
    this.error = {};
  }
  /**
   * Sets up a new core instance with the given configuration, as specified in Global Configuration.
   * Returns a promise that either resolves with the APIs or rejects with a facade error.
   *
   * @param {PlayerFacade} playerFacade - The player facade object to establish a connection with.
   * @param {config} config - Basic configuration for the APIs (core instance)
   * @returns {Promise<MainController|Error>} Resolves with MainController - Reject with Error (Facade failure)
   */
  init(e, i) {
    let r = qt(ti, i);
    return new Promise((s, l) => {
      this.validate(e), this.detectOMID(r.adVerification);
      function h(m) {
        c.debug.critical("init - error", m), l(m);
      }
      Object.keys(this.initError).length > 0 ? h(this.initError) : s(new vr(r, e));
    });
  }
  /**
   * @returns {number} Ad request methods
   */
  get AD_REQUEST_METHOD() {
    return Wn;
  }
  /**
   * @returns {Object} Ad types
   */
  get AD_TYPE() {
    return ae;
  }
  /**
   * @returns {Object} Ad variants
   */
  get AD_VARIANT() {
    return ue;
  }
  /**
   * @returns {Object} the default config.
   */
  get CONFIG() {
    return Or(ti);
  }
  /**
   * @returns {Object} the default mimetypes.
   */
  get DEFAULT_MIMETYPES() {
    return ri;
  }
  /**
   * @returns {Object} List of event types as ENUMs
   */
  get EVENT() {
    return p;
  }
  /**
   * @returns {Array} List of event types
   */
  get EVENTS() {
    return Object.values(p);
  }
  get LOGLEVEL() {
    return tt;
  }
  /**
   * Set the log level.
   * @param {LOGLEVEL} level - The log level to set. ( SILENT - 0, ERROR - 1, NORMAL - 2, VERBOSE - 3)
   * @returns {void}
   */
  set debugLevel(e) {
    c.logLevel = e;
  }
  /**
   * Get the current log level.
   * @returns {number} Returns '0' by default, or the value set by the 'debugLevel' setter.
   */
  get debugLevel() {
    return c.logLevel;
  }
  /**
   * Get the debug log object.
   * @returns {Object} Debug log object with log functions.
   */
  get debugger() {
    return c.debug;
  }
  /**
   * @returns {string} Facade version string
   */
  get facadeVersion() {
    return kn;
  }
  /**
   * @returns {Object} InitError object
   */
  get initError() {
    return this.error;
  }
  /**
   * @returns {Array} Array of supported Facades by version
   */
  get supportedFacadeVersions() {
    return Fn;
  }
  /**
   * @returns {string} smartclientcore version string
   */
  get version() {
    return "7.5.6";
  }
};
Nr.NAME = "Core::";
let wi = Nr;
const wo = new wi();
typeof window != "undefined" && (window.smartclientcore = wo);
typeof exports == "object" && (exports = {
  smartclientcore: wi
});
export {
  Js as FacadeBase,
  wo as default
};
