[> Documentation-Index](index.md)

# smartclientcore - Static API

The **static API** can be used to create a instances of the smartclientcore with the video player.
It is available from the global namespace on the `window` object.


## Table of contents
- [Methods](#methods)
- [Properties](#properties)
  
## Methods
### init(player : PlayerFacade, config : [Config](setup-config.md)) : smartclientcore
Sets up a new smartclientcore instance for the given video player.

#### Setup Error - Codes Table
| Code | Description                                                                                                                                                                                                            |
|------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 60   | Missing PlayerFacade - The specified `Facade` is empty.                                                                                                                                                                |
| 61   | Invalid facade definition - Missing API points.                                                                                                                                                                        |
| 62   | PlayerFacade Handshake - Invalid facade version or missing handshake.                                                                                                                                                  |
| 63   | Ad Reinsertion usage declined by the vendor.                                                                                                                                                                           |
| 64   | Ad Reinsertion Penalty - AdReinsertion initialization failed, either due to a invalid [configuration](setup-config.md#adreinsertion) or issues that must be answered by the AdReinsertion vendor.                      |
| 65   | Ad Reinsertion Initialization Timeout - AdReinsertion initialization took too long, either caused by the [timeout limitation](setup-config.md#timeouts) or issues that must be answered by the AdReinsertion vendor.   |                                                                                                                                                                               |

#### How to catch init errors

```javascript

// We won't create the entire configuration from scratch, we'll use the default object...
let config = smartclientcore.CONFIG;
let playerFacade = new PlayerFacade();

// ... and only adjust selected properties.
config.adReinsertion = {
	homad: {
		enabled: true,
		setup: {
			globalConfig: 'https://example.com/global_config.json',
			clientConfig: 'https://example.com/client_config.json',
			enableSessionCoverage: false,
			activationCallback: (_reason) => {
				return new Promise((resolve, reject) => {
					
					// The reason for activating HOMAD sounds reasonable?
					resolve();
					
					// otherwise
					//reject();
				});
			}
		}
	}
};

// Requests the mainController for the given configuration or fails with error from Setup Error - Codes Table.
smartclientcore.init(playerFacade, config).then((mainController) => {
	
    // get adSlotAPI over the mainController
    let adSlotAPI = mainController.AdSlotAPI;
    let adPlaylistAPI = mainController.AdPlaylistAPI;
});

// Returns an error object with code and message if an error occurred when setting up the initialization.
smartclientcore.initError;
```
<sub>Sample code :: How to catch setup errors.</sub>

## Properties
### AD_REQUEST_METHOD
Declaration of ad request methods as ENUMs.

### AD_TYPE
Declaration of ad types as ENUMs that can be used with requesting an ad slot.

### CONFIG
Default configuration.

### DEFAULT_MIMETYPES
Declaration of default mimetypes as ENUMs that can be used.

### EVENT: Object
Declaration of events as ENUMs that occur during playback of a single ad or multiple ads delivery.
See [smartclientcore - Ad Events](events.md) for more details.

### EVENTS: Array
List of event names as defined in the EVENT object.

### debugLevel: Getter/Setter
The getter provides information about the current status of the debug level and the setter can be set to **normal, 
error, silent and verbose**.

### initError: Object
Returns an error object with code and message if an error occurred when setting up the initialization.

### supportedFacadeVersion: String
Returns the version number for the supported Facade interface.

### version: String
Returns the version number for the smartclientcore.
