[**smartclientcore**](README.md) • **Docs**

***

[smartclientcore](modules.md) / [apis/AdSlotAPI](apis/AdSlotAPI/README.md) / AdSlotAPI

# Class: AdSlotAPI

## Extends

- `EventDispatcher`

## Constructors

<a id="constructors" name="constructors"></a>

### new AdSlotAPI()

> **new AdSlotAPI**(`playerFacade`, `config`): [`AdSlotAPI`](apis/AdSlotAPI/classes/AdSlotAPI.md)

#### Parameters

• **playerFacade**: [`PlayerFacade`](constants/interfaces/interfaces/PlayerFacade.md)

A player proxy class

• **config**: [`URLConfig`](constants/interfaces/interfaces/URLConfig.md)

scc init configuration object

#### Returns

[`AdSlotAPI`](apis/AdSlotAPI/classes/AdSlotAPI.md)

#### Overrides

`EventDispatcher.constructor`

## Properties

<a id="adbreak" name="adbreak"></a>

### adBreak

> **adBreak**: [`AdBreakSetup`](constants/interfaces/interfaces/AdBreakSetup.md)

***

<a id="config" name="config"></a>

### config

> **config**: [`URLConfig`](constants/interfaces/interfaces/URLConfig.md)

***

<a id="environmentvars" name="environmentvars"></a>

### environmentVars

> **environmentVars**: [`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md)

***

<a id="error" name="error"></a>

### error

> **error**: `any`

***

<a id="event" name="event"></a>

### EVENT

> `static` **EVENT**: `object`

#### Index Signature

 \[`key`: `string`\]: `string`

***

<a id="name" name="name"></a>

### NAME

> `static` **NAME**: `string` = `'AdSAPI::'`

## Accessors

<a id="ad" name="ad"></a>

### ad

> `get` **ad**(): `object` \| [`PublicAdAPI`](constants/interfaces/interfaces/PublicAdAPI.md)

Returns information about the current ad, like companions, icons, variations, verifications and more.
The contents of variations depend on the advertising medium, the following things can be found there:

#### Returns

`object` \| [`PublicAdAPI`](constants/interfaces/interfaces/PublicAdAPI.md)

Represents static information about the current ad.

***

<a id="adslot" name="adslot"></a>

### adSlot

> `get` **adSlot**(): `object` \| [`PublicAdSlotAPI`](constants/interfaces/interfaces/PublicAdSlotAPI.md)

Returns information about the current ad-break, like times and more.

#### Returns

`object` \| [`PublicAdSlotAPI`](constants/interfaces/interfaces/PublicAdSlotAPI.md)

Represents static information about the current ad-break.

***

<a id="errorapi" name="errorapi"></a>

### errorAPI

> `get` **errorAPI**(): `null` \| [`ErrorStatus`](constants/interfaces/interfaces/ErrorStatus.md)

Requests details about the most recent error that has occurred on the AdSlotAPI.

#### Returns

`null` \| [`ErrorStatus`](constants/interfaces/interfaces/ErrorStatus.md)

Description object of the most recent error or `null`.

***

<a id="rawxml" name="rawxml"></a>

### rawXML

> `get` **rawXML**(): `null` \| `Document`

Returns all of the collected XML that has been collected for the whole slot

#### Returns

`null` \| `Document`

XML as live parsable DOM representation, querySelector and similar work on this.

## Methods

<a id="addeventlistener" name="addeventlistener"></a>

### addEventListener()

> **addEventListener**(`type`, `listener`): () => `void`

Adds an event listener for the given type.

#### Parameters

• **type**: `string`

The type of the event to listen for.

• **listener**: [`EventHandler`](constants/interfaces/interfaces/EventHandler.md)

The function to call when the event is dispatched.

#### Returns

`Function`

A function that can be called to remove the listener.

##### Returns

`void`

#### Inherited from

`EventDispatcher.addEventListener`

***

<a id="clickthrough" name="clickthrough"></a>

### clickThrough()

> **clickThrough**(`playerHandles`): `any`

Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
to request the advertisers landing page and call the ClickThru tracking requests.

#### Parameters

• **playerHandles**: `boolean` = `false`

Whether the player takes responsibility for opening the landing page URL.
Defaulting to `false` if omitted.

#### Returns

`any`

The landing page URL.

***

<a id="companionclickthrough" name="companionclickthrough"></a>

### companionClickThrough()

> **companionClickThrough**(`companionId`, `playerHandles`): `any`

Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
to call the ClickThru tracking requests and request the advertisers landing page (most likely with
`StaticResource` creative resource only).

#### Parameters

• **companionId**: `string`

Value of the `id` attribute from the `CompanionAd` object.

• **playerHandles**: `boolean` = `true`

Whether the player takes responsibility for opening the landing page URL.
Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,
 `IFrameResource`).

#### Returns

`any`

The landing page URL.

***

<a id="companionview" name="companionview"></a>

### companionView()

> **companionView**(`companionId`): `void`

Requests the view trackers when a creative resource is displayed. The method should be called for each resource
 file of a `Companion Ad`.

#### Parameters

• **companionId**: `string`

Value of the `id` attribute from the `CompanionAd` object.

#### Returns

`void`

***

<a id="dispatchevent" name="dispatchevent"></a>

### dispatchEvent()

> **dispatchEvent**(`type`): `void`

Dispatches an event of the given type with the given data.

#### Parameters

• **type**: `string`

The type of the event to dispatch.

#### Returns

`void`

#### Overrides

`EventDispatcher.dispatchEvent`

***

<a id="dispose" name="dispose"></a>

### dispose()

> **dispose**(): `void`

Removes all event listeners that the SDK itself had previously added.

#### Returns

`void`

***

<a id="haseventlistener" name="haseventlistener"></a>

### hasEventListener()

> **hasEventListener**(`type`, `listener`): `boolean`

Checks whether an event listener has been added for the given type and listener function.

#### Parameters

• **type**: `string`

The type of the event to check for the listener.

• **listener**: [`EventHandler`](constants/interfaces/interfaces/EventHandler.md)

The listener function to check for.

#### Returns

`boolean`

True if the listener has been added for the given type, false otherwise.

#### Inherited from

`EventDispatcher.hasEventListener`

***

<a id="iconclickthrough" name="iconclickthrough"></a>

### iconClickThrough()

> **iconClickThrough**(`iconProgram`, `playerHandles`): `undefined` \| `null` \| `string`

Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
to request the advertisers landing page and call the ClickThru tracking requests.

#### Parameters

• **iconProgram**: `string`

The program represented in the icon

• **playerHandles**: `boolean` = `false`

Whether the player takes responsibility for opening the landing page URL.
Defaulting to `false` if omitted.

#### Returns

`undefined` \| `null` \| `string`

The landing page URL.

***

<a id="iconview" name="iconview"></a>

### iconView()

> **iconView**(`iconProgram`): `void`

The view tracking for icons is used to track when the icon creative is displayed.

#### Parameters

• **iconProgram**: `string`

The program represented in the icon

#### Returns

`void`

***

<a id="initadslot" name="initadslot"></a>

### initAdSlot()

> **initAdSlot**(`adBreak`, `environmentVars`): `Promise`\<`string`\>

Invokes a commercial break by requesting the specified ad setup from the ad server.

#### Parameters

• **adBreak**: [`AdBreakSetup`](constants/interfaces/interfaces/AdBreakSetup.md)

Configuration for the upcoming ad break.

• **environmentVars**: `object` \| [`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md) = `{}`

Defines environment conditions for the upcoming ad break

#### Returns

`Promise`\<`string`\>

Resolves if loading the ad manifests has been completed.

***

<a id="pausead" name="pausead"></a>

### pauseAd()

> **pauseAd**(): `void`

Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.

#### Returns

`void`

***

<a id="removeeventlistener" name="removeeventlistener"></a>

### removeEventListener()

> **removeEventListener**(`type`, `listener`): `void`

Removes an event listener for the given type.

#### Parameters

• **type**: `string`

The type of the event to remove the listener for.

• **listener**: [`EventHandler`](constants/interfaces/interfaces/EventHandler.md)

The listener function to remove.

#### Returns

`void`

#### Inherited from

`EventDispatcher.removeEventListener`

***

<a id="resize" name="resize"></a>

### resize()

> **resize**(`boundingRectangle`, `viewMode`): `void`

Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.

#### Parameters

• **boundingRectangle**: [`Rect`](constants/interfaces/interfaces/Rect.md)

The video content display as a Rectangle {width, height, top, left}

• **viewMode**: `string`

Current viewing mode (normal, fullscreen, thumbnail, dynamic)

#### Returns

`void`

***

<a id="resumead" name="resumead"></a>

### resumeAd()

> **resumeAd**(): `void`

Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.

#### Returns

`void`

***

<a id="skipad" name="skipad"></a>

### skipAd()

> **skipAd**(): `void`

Skips (stops) a running single ad
The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
a single ad.

_Note:
The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.

#### Returns

`void`

***

<a id="startadslot" name="startadslot"></a>

### startAdSlot()

> **startAdSlot**(): `void`

Starts the ad break.
The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
 to start.

#### Returns

`void`

***

<a id="stopadslot" name="stopadslot"></a>

### stopAdSlot()

> **stopAdSlot**(): `Promise`\<`void`\>

Stops a running ad break.
The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
cleaned up ad resources. Also the content of the video player has been reset.

#### Returns

`Promise`\<`void`\>

- resolve() - Whether the adSlot could be closed and cleaned up.
 - reject(string) - In the other case, the answer is a string.
