[**smartclientcore**](README.md) • **Docs**

***

[smartclientcore](modules.md) / [vmap/api/AdPlaylistAPI](vmap/api/AdPlaylistAPI/README.md) / AdPlaylistAPI

# Class: AdPlaylistAPI

## Extends

- `EventDispatcher`

## Constructors

<a id="constructors" name="constructors"></a>

### new AdPlaylistAPI()

> **new AdPlaylistAPI**(`playerFacade`, `adsAPI`): [`AdPlaylistAPI`](vmap/api/AdPlaylistAPI/classes/AdPlaylistAPI.md)

#### Parameters

• **playerFacade**: [`PlayerFacade`](constants/interfaces/interfaces/PlayerFacade.md)

extended from FacadeBase

• **adsAPI**: [`AdSlotAPI`](apis/AdSlotAPI/classes/AdSlotAPI.md)

is a reference to the session AdSlotAPI

#### Returns

[`AdPlaylistAPI`](vmap/api/AdPlaylistAPI/classes/AdPlaylistAPI.md)

#### Overrides

`EventDispatcher.constructor`

## Properties

<a id="config" name="config"></a>

### config

> **config**: [`URLConfig`](constants/interfaces/interfaces/URLConfig.md)

***

<a id="environmentvars" name="environmentvars"></a>

### environmentVars

> **environmentVars**: [`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md)

***

<a id="error" name="error"></a>

### error

> **error**: `any`

***

<a id="name" name="name"></a>

### NAME

> `static` **NAME**: `string` = `'AdPlaylAPI::'`

## Accessors

<a id="errorapi" name="errorapi"></a>

### errorAPI

> `get` **errorAPI**(): `null` \| [`ErrorStatus`](constants/interfaces/interfaces/ErrorStatus.md)

Requests details about the most recent error that has occurred on the AdPlaylistAPI.

#### Returns

`null` \| [`ErrorStatus`](constants/interfaces/interfaces/ErrorStatus.md)

Description object of the most recent error or `null`.

***

<a id="rawvmap" name="rawvmap"></a>

### rawVMAP

> `get` **rawVMAP**(): `null` \| `Document`

Returns the VMAP that has been collected for the current (content) session

#### Returns

`null` \| `Document`

XML as live parsable DOM representation, querySelector and similar work on this

## Methods

<a id="addeventlistener" name="addeventlistener"></a>

### addEventListener()

> **addEventListener**(`type`, `listener`): () => `void`

Adds an event listener for the given type.

#### Parameters

• **type**: `string`

The type of the event to listen for.

• **listener**: [`EventHandler`](constants/interfaces/interfaces/EventHandler.md)

The function to call when the event is dispatched.

#### Returns

`Function`

A function that can be called to remove the listener.

##### Returns

`void`

#### Inherited from

`EventDispatcher.addEventListener`

***

<a id="dispatchevent" name="dispatchevent"></a>

### dispatchEvent()

> **dispatchEvent**(`type`): `void`

Dispatches an event of the given type with the given data.

#### Parameters

• **type**: `string`

The type of the event to dispatch.

#### Returns

`void`

#### Inherited from

`EventDispatcher.dispatchEvent`

***

<a id="dispose" name="dispose"></a>

### dispose()

> **dispose**(): `Promise`\<`void`\>

#### Returns

`Promise`\<`void`\>

***

<a id="haseventlistener" name="haseventlistener"></a>

### hasEventListener()

> **hasEventListener**(`type`, `listener`): `boolean`

Checks whether an event listener has been added for the given type and listener function.

#### Parameters

• **type**: `string`

The type of the event to check for the listener.

• **listener**: [`EventHandler`](constants/interfaces/interfaces/EventHandler.md)

The listener function to check for.

#### Returns

`boolean`

True if the listener has been added for the given type, false otherwise.

#### Inherited from

`EventDispatcher.hasEventListener`

***

<a id="initadplaylist" name="initadplaylist"></a>

### initAdPlaylist()

> **initAdPlaylist**(`playlistSpecs`, `environmentVars`): `Promise`\<`string`\>

Starts requesting a VMAP from the ad server

#### Parameters

• **playlistSpecs**: [`AdPlaylistSetup`](constants/interfaces/interfaces/AdPlaylistSetup.md)

Ad configuration for the upcoming content video.

• **environmentVars**: [`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md) = `{}`

Defines environment conditions for the upcoming ad break.
 https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html

#### Returns

`Promise`\<`string`\>

Resolves if loading the VMAP has been completed

***

<a id="removeeventlistener" name="removeeventlistener"></a>

### removeEventListener()

> **removeEventListener**(`type`, `listener`): `void`

Removes an event listener for the given type.

#### Parameters

• **type**: `string`

The type of the event to remove the listener for.

• **listener**: [`EventHandler`](constants/interfaces/interfaces/EventHandler.md)

The listener function to remove.

#### Returns

`void`

#### Inherited from

`EventDispatcher.removeEventListener`

***

<a id="startadplaylist" name="startadplaylist"></a>

### startAdPlaylist()

> **startAdPlaylist**(): `Promise`\<`void`\>

Starts playback and monitoring of the content and automatically inserts ad-slots
based on the `timeOffset` values of each VMAP AdBreak.
AdBreaks with a `timeOffset` equally to `0`, `"start"` or `"0%"` get requested immediately.

#### Returns

`Promise`\<`void`\>

Resolves if the playback started

***

<a id="stopadplaylist" name="stopadplaylist"></a>

### stopAdPlaylist()

> **stopAdPlaylist**(): `Promise`\<`void`\>

Immediately stops monitoring content playback.
AdBreaks that have already started remain until they complete. If necessary, they must be canceled
via the `AdSlotAPI.stopAdSlot()`.

#### Returns

`Promise`\<`void`\>

- Whether the ad slot could be closed and cleaned up or not.
