[**smartclientcore**](README.md) • **Docs**

***

[smartclientcore](modules.md) / [facade/FacadeBase](facade/FacadeBase/README.md) / FacadeBase

# Class: FacadeBase

## Constructors

<a id="constructors" name="constructors"></a>

### new FacadeBase()

> **new FacadeBase**(): [`FacadeBase`](facade/FacadeBase/classes/FacadeBase.md)

#### Returns

[`FacadeBase`](facade/FacadeBase/classes/FacadeBase.md)

## Properties

<a id="player_event_map" name="player_event_map"></a>

### PLAYER\_EVENT\_MAP

> **PLAYER\_EVENT\_MAP**: `Object`

***

<a id="currentcontentsource" name="currentcontentsource"></a>

### currentContentSource

> **currentContentSource**: [`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)

## Methods

<a id="addeventlistener" name="addeventlistener"></a>

### addEventListener()

> **addEventListener**(`type`, `callback`): `void`

Sets up a function that will be called whenever the specified event is delivered to the video player.

#### Parameters

• **type**: `string`

A case-sensitive string representing the player event type to listen for.

• **callback**: `Function`

The function which receives a notification when an event of the specified type occurs.

_*Note:*

The PLAYER_EVENT_MAP should be defined within the Facade (constructor) to allow mapping and usage of equivalent
events for non-HTML5 video players. The key represents the event from the custom player, while the value
corresponds to the standard HTML5 event. It must also be set for HTML5 players as this is no longer part of the
FacadeBase!

#### Returns

`void`

***

<a id="getadcurrenttime" name="getadcurrenttime"></a>

### getAdCurrentTime()

> **getAdCurrentTime**(): `number`

Requests the ad playhead position from the video player.

#### Returns

`number`

Total time in seconds.

***

<a id="getadduration" name="getadduration"></a>

### getAdDuration()

> **getAdDuration**(): `number`

Requests the ad-duration from the video player.

#### Returns

`number`

Total time in seconds. _*Note:* The time can include milliseconds (3.1234)

***

<a id="getcontentcurrenttime" name="getcontentcurrenttime"></a>

### getContentCurrentTime()

> **getContentCurrentTime**(): `number`

Requests the current playhead position from the video player.

#### Returns

`number`

Current time in seconds. _*Note:* The time can include milliseconds (3.1234)

***

<a id="getcontentduration" name="getcontentduration"></a>

### getContentDuration()

> **getContentDuration**(): `number`

Requests the content-duration from the video player.

#### Returns

`number`

Total time in seconds. _*Note:* The time can include milliseconds (3.1234)

***

<a id="getcurrentcontentsource" name="getcurrentcontentsource"></a>

### getCurrentContentSource()

> **getCurrentContentSource**(): [`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)

#### Returns

[`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)

SourceObject - Current content source and playhead progress

***

<a id="getenvironmentvars" name="getenvironmentvars"></a>

### getEnvironmentVars()

> **getEnvironmentVars**(`adBreakType`): [`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md)

Requests the latest status of the video player, site, and other external factors.

#### Parameters

• **adBreakType**: `string`

Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)

#### Returns

[`EnvironmentVars`](constants/interfaces/interfaces/EnvironmentVars.md)

Object describing surrounding conditions and the expected ad properties.

***

<a id="getplayerelement" name="getplayerelement"></a>

### getPlayerElement()

> **getPlayerElement**(): `null` \| `HTMLAudioElement` \| `HTMLVideoElement`

Requests the player element.

#### Returns

`null` \| `HTMLAudioElement` \| `HTMLVideoElement`

The video or audio element or null.

_*Note:* If the player takes care of the OM-SDK, config.adVerification.playerHandles = true ._

***

<a id="getplayersize" name="getplayersize"></a>

### getPlayerSize()

> **getPlayerSize**(): [`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

Requests the current size and viewMode from the video player.

#### Returns

[`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

Current player dimension specs

***

<a id="getviewportsize" name="getviewportsize"></a>

### getViewportSize()

> **getViewportSize**(): [`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

Requests the current size and viewMode from the viewport that surrounds the video player.

#### Returns

[`ElementSize`](constants/interfaces/interfaces/ElementSize.md)

The dimension specs of the element

***

<a id="getvolume" name="getvolume"></a>

### getVolume()

> **getVolume**(): `number`

Requests the current volume level from the video player.

#### Returns

`number`

The current volume level between 0-1

***

<a id="handshakeversion" name="handshakeversion"></a>

### handshakeVersion()

> **handshakeVersion**(`apiFacadeVersion`): `string`

Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player facade
are supported.

#### Parameters

• **apiFacadeVersion**: `string`

Required API version

#### Returns

`string`

Supported API version

***

<a id="isfullscreen" name="isfullscreen"></a>

### isFullscreen()

> **isFullscreen**(): `boolean`

Requests the current screen state from the video player.

#### Returns

`boolean`

Fullscreen state

***

<a id="ismuted" name="ismuted"></a>

### isMuted()

> **isMuted**(): `boolean`

Requests the current muted state from the video player.

#### Returns

`boolean`

Muted state

***

<a id="ispaused" name="ispaused"></a>

### isPaused()

> **isPaused**(): `boolean`

Requests the current pause state from the video player.

#### Returns

`boolean`

Paused state

***

<a id="load" name="load"></a>

### load()

> **load**(`url`, `autoPlay`, `disableSeeking`): `Promise`\<`void`\>

Requests the video player to load and play the specified media file.

#### Parameters

• **url**: `string`

The URI of the media file to be played.

• **autoPlay**: `boolean` = `true`

Whether the requested media file starts playback immediately.

• **disableSeeking**: `boolean` = `false`

Whether the requested source can be seeked back and forth.

#### Returns

`Promise`\<`void`\>

That resolves if the player accepts the media file request. If an error occurs, the
 Promise may reject with an optional error code.

***

<a id="mute" name="mute"></a>

### mute()

> **mute**(): `Promise`\<`void`\>

Requests the video player to mute playback.

#### Returns

`Promise`\<`void`\>

Resolves if the video player has been muted

***

<a id="pause" name="pause"></a>

### pause()

> **pause**(): `Promise`\<`void`\>

Requests the video player to pause playback.

#### Returns

`Promise`\<`void`\>

Resolves if the video player has been paused

***

<a id="play" name="play"></a>

### play()

> **play**(): `Promise`\<`void`\>

Requests the video player to start (resume) playback.

#### Returns

`Promise`\<`void`\>

Resolves if the video player has been resumed

***

<a id="removeeventlistener" name="removeeventlistener"></a>

### removeEventListener()

> **removeEventListener**(`type`, `callback`): `void`

Removes an event listener from the video player that has been registered with `addEventListener()`
_*Note:* The event listener to be removed must match with the listener that has been added._

#### Parameters

• **type**: `string`

A case-sensitive string representing the player event type to listen for.

• **callback**: `Function`

The function which receives a notification when an event of the specified type occurs.

#### Returns

`void`

***

<a id="restorecontentstate" name="restorecontentstate"></a>

### restoreContentState()

> **restoreContentState**(): `Promise`\<`void`\>

restoreContentState is called right after the ad playback has finished.
Resumes playback by restoring the last known playback state and communicates with the AdSlotAPI upon completion.

_*Note:* Check whether the content was really replaced by an ad. Otherwise, there should be nothing to do.

#### Returns

`Promise`\<`void`\>

Resolves if the player accepts the play request; otherwise, rejects.

***

<a id="savecontentstate" name="savecontentstate"></a>

### saveContentState()

> **saveContentState**(): `Promise`\<[`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)\>

saveContentState is called right before the ad playback should begin. Notes the current playback state for
 later use with `restoreContentState()` and communicates with the AdSlotAPI  upon completion.

_*Note:* Promise.resolve() without the source and the current time of the content will not work.

#### Returns

`Promise`\<[`CurrentContentSource`](constants/interfaces/interfaces/CurrentContentSource.md)\>

Resolves with the current content source and playhead progress for VAST tracking enrichment.

***

<a id="seek" name="seek"></a>

### seek()

> **seek**(`offset`): `Promise`\<`void`\>

Requests the video player to change the playhead position to the specified time.

#### Parameters

• **offset**: `number`

Requested playhead position

#### Returns

`Promise`\<`void`\>

Resolves if the video player has finished seeking to the specified position

***

<a id="setvolume" name="setvolume"></a>

### setVolume()

> **setVolume**(`volume`): `Promise`\<`void`\>

Requests the video player to change the volume.

#### Parameters

• **volume**: `number`

Requested volume level between 0-1

#### Returns

`Promise`\<`void`\>

Resolves if the video player accepted the volume change request

***

<a id="unmute" name="unmute"></a>

### unmute()

> **unmute**(): `Promise`\<`void`\>

Requests the video player to unmute playback.

#### Returns

`Promise`\<`void`\>

Resolves if the video player has been unmuted
