[> Documentation-Index](index.md)

# smartclientcore - Error Codes

If an error occurs while trying to load and serve an ad, the smartclientcore will replace the `[ERRORCODE]` macro within VAST `<Error>` URLs.


## Table of contents
- [Ad Error Codes](#ad-error-codes)
- [Ad Warning Codes](#ad-warning-codes)
- [Setup Error Codes](#setup-error-codes)
- [Ad-Slot Error Codes](#adslot-error-codes)
- [AdReinsertion Activation Reason Codes](#adreinsertion-activation-codes)

<a name="ad-error-codes"></a>

## Ad Error - Codes Table

List of error codes used by the smartclientcore. 

Codes with a leading star (*) have been introduced to highlight issues, that can be assigned to a specific reason 
but are not yet covered by a corresponding VAST error code (at the time of this writing, VAST 4.2). 

All other (unstarred) error codes are equal with the **[IAB VAST 4.2] Error Codes and Meanings**.

| Code | Description |
| ---- | ----------- | 
| 100  | XML parsing error. |
| 101  | VAST schema validation error. |
| *110 | Invalid XML received, no response or nonXML response - server answered with a status code. |
| 200  | Trafficking error. Media player received an Ad type that it was not expecting and/or cannot play. |
| 201  | Media player expecting different linearity. |
| 301  | Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element. (URI was either unavailable or reached a timeout as defined by the media player.) |
| 302  | Wrapper limit reached, as defined by the media player. Too many Wrapper responses have been received with no InLine response. |
| 303  | No VAST response after one or more Wrappers. |
| *310 | Mixed Content: The ad request has been blocked and must be served over HTTPS. |
| 400  | General Linear error. Media player is unable to display the Linear Ad. |
| 401  | File not found. Unable to find Linear/MediaFile from URI. |
| 402  | Timeout of MediaFile URI. |
| 403  | Couldn’t find MediaFile that is supported by this media player, based on the attributes of the MediaFile element. |
| 405  | Problem displaying MediaFile. Media player found a MediaFile with supported type but couldn’t display it. MediaFile may include: unsupported codecs, different MIME type than MediaFile@type, unsupported delivery method, etc. |
| 500  | General NonLinearAds error. |
| 501  | Unable to display NonLinearAd because creative dimensions do not align with creative display area (i.e. creative dimension too large). |
| 502  | Unable to fetch NonLinearAds/NonLinear resource. |
| 503  | Couldn’t find NonLinear resource with supported type. |
| 901  | General VPAID error. |
| 902  | General SIMID error. |


<a name="ad-warning-codes"></a>

## Ad Warning - Codes Table

During ad playback the smartclientcore may respond with one of the following error codes
to warn about non-critical issues that do not interrupt the delivery.

| Code | Description |
| ---- | ----------- |
| 50   | Unknown tracker loading error |
| 51   | Timeout of tracker request URIs |


<a name="setup-error-codes"></a>

## Setup Error - Codes Table

The smartclientcore responds with one of the following error codes if the initial setup fails. 
See [Static API Methods](plugin-static-api.md#methods) for more Details.

| Code | Description                                                                                                                                                                                                                 |
| ---- | ----------- |
| 60   | Invalid Setup - The specified `pluginSetup` does not match with the [GlobalConfig](setup-global-config.md) definition.                                                                                                      |
| 61   | Player API not available - The PlayerFacade has not been connected before starting the setup process.                                                                                                                       |
| 62   | Ad Reinsertion Penalty - AdReinsertion initialization failed, either due to a invalid [configuration](setup-global-config.md#adreinsertion) or issues that must be answered by the AdReinsertion vendor.                    |
| 63   | Ad Reinsertion Initialization Timeout - AdReinsertion initialization took too long, either caused by the [timeout limitation](setup-global-config.md#timeouts) or issues that must be answered by the AdReinsertion vendor. |
| 64   | Ad Reinsertion usage declined by the vendor.                                                                                                                                                                                |


<a name="adslot-error-codes"></a>

## Ad-Slot Error - Codes Table

The smartclientcore responds with one of the following error codes if the initialization 
or termination of an ad slot fails. 

| Code | Description |
| ---- | ----------- |
| 10   | An ad-slot has already been started. Shut down the current ad-slot by calling `stopAdSlot`. |
| 11   | Restoring the content failed. **The smartclientcore indicates the error by sending a `GeneralError` event.** |
| 20   | Invalid AdBreak definition. |
| 21   | Unknown Manifest Loading Error. |
| 22   | The manifest couldn't be loaded in time. |


<a name="adreinsertion-activation-codes"></a>

## AdReinsertion Activation Reason - Codes Table
| Code | Description |
| ---- | ----------- |
| 1000 | Timeout of ad-request URIs |
| 1001 | XHR request status is not 200 (ok)  |
| 1002 | General XHR request error, network issues  |
| 1003 | XML validation error  |
| 1004 | Timeout of wrapper request chain  |
| 1010 | Timeout of media file request URIs |
| 1013 | General load error of media file URIs |
| 1020 | General ad-reinsertion activation request |


[IAB VAST 4.2]: https://iabtechlab.com/standards/vast/
