# Migration Notes v5 to v6
_Last Modified on 2025-09-29T09:47:47.136Z_

## Table of contents
* [Introduction](#intro)
* [PlayerFacade](#facade)
* [Initialization](#init)
	* [VAST-only](#init+vast)
        * [connect](#vast+connect)
        * [request](#vast+request)
	* [VMAP + VAST](#init+vmap)
        * [connect](#vmap+connect)
        * [request](#vmap+request)
	* [Comparison v5 : v6](#init+comparison)
* [PublisherAPI -> AdSlotAPI](#adslotapi)
	* [Methods](#adslotapi+methods)
* [Removals](#removals)


<a name="intro"></a>

## Introduction
With version 6 of the **smartclientcore** there are now two ways to supply ads.
As in previous versions ads for a specific ad-slot can be requested or ad playlists can be requested,
which contain a collection of ads for the entire underlying content.

The **smartclientcore** introduces its second publisher API, the `AdPlaylistAPI` to work with VMAP responses. 
The former PublisherAPI has been renamed to `AdSlotAPI`, which keeps working with VAST responses.


<a name="facade"></a>

## PlayerFacade
No matter whether one wants to use VAST or VMAP and VAST together, three changes have to be made in the PlayerFacade.

* The **smartclientcore** version `6.1` first requires facade version `3.2` to properly prepare both of the publisher APIs.
* The `FacadeBase` interface has been extended with a new method `getEnvironmentVars()`. It is called whenever 
  it requires fresh data from the publisher. Up to v5 `EnvironmentVars` could only be defined once when 
  calling `PublisherAPI.initAdSlot()`.
* Since the **smartclientcore** can work with video and audio players, the method `getVideoElement` should be renamed to
 `getPlayerElement()`

```javascript
/**
 * Requests the player facade version (API version) to ensure the particular versions of `smartclientcore` and player
 * facade are supported.
 * @param {string} apiFacadeVersion - Required API version
 * @returns {string} Supported API version
 */
PlayerFacade.prototype.handshakeVersion = function (apiFacadeVersion) {
	return '3.2';
};

/**
 * Requests the latest status of the video player, site, and other external factors.
 * @param {string} adBreakType - Linearity of the upcoming ad slot. See [`AdBreak.type`](setup-sequential-config#adbreak+type)
 * @returns {EnvironmentVars} Description object of current states or `null`.
 */
PlayerFacade.prototype.getEnvironmentVars = function (adBreakType) {
	try {
		return this.environmentVars;
	} catch (error) {
		return {};
	}
};

/**
 * Requests the video player element
 * @returns {Element} The video element
 * @deprecated
 */
PlayerFacade.prototype.getVideoElement = function() {
	
	// deprecated method, use getPlayerElement instead
    return this.getPlayerElement();
}

/**
 * Requests the player element
 * @returns {Element} The video or audio element
 */
PlayerFacade.prototype.getPlayerElement = function() {
	return this.myPlayerElement;
}
```

<a name="init"></a>

## Initialization

As said in the beginning you now have two ways to use the **smartclientcore**.
Follow the next two steps if you only want to receive [VAST-AdTags](#init+vast)
(ideally zero changes have to be done).

If you instead want to receive VMAP documents see how to do this with the [AdPlaylistAPI](#init+vmap).

<a name="init+vast"></a>

### VAST-only usage

The following two steps should already look like your implementation and basically remain the same.
But keep in mind, that way you cannot receive VMAP ad-tags.

<a name="vast+connect"></a>

#### connect

Typically, in your `AdController` you connect with the **smartclientcore** like this.

```javascript
AdController.prototype.initSmartclientcore = function () {
	var that = this;
	
	window.smartclientcore
		.connect(this.playerFacade)
		.setup(this.globalConfig)
		.then(function (adSlotAPI) {
			that.adSlotAPI = adSlotAPI;
		});
};
```

<a name="vast+request"></a>

#### request

After connecting to the core you use the `AdSlotAPI` to call `initAdSlot` and then `startAdSlot`:

```javascript
that.adSlotAPI.initAdSlot(adBreak, that.environmentVars).then(function () {
    that.adSlotAPI.startAdSlot();
}, function (failure) {
    console.log('something went wrong while requesting VAST', failure);
});
```

<a name="init+vmap"></a>

### VMAP and VAST

The new VMAP partion of the smartclientcore introduces a new submodule `vmap`, that actually has the same methods to 
connect and initialize.

<a name="vmap+connect"></a>

#### connect

Aside of calling the methods on the submodule, the major difference is that calling `setup()`
now returns two publisher APIs  - an API for ad-playlists (VMAP) and the well known API for the ad-slot.

```javascript
AdController.prototype.initSmartclientcore = function () {
	var that = this;
	
	window.smartclientcore
		.vmap
		.connect(this.playerFacade)
		.setup(this.globalConfig)
		.then(function([adPlaylistAPI, adSlotAPI]) {
			that.adPlaylistAPI = adPlaylistAPI;
			that.adSlotAPI = adSlotAPI;
		});
};
```


<a name="vmap+request"></a>

#### request

Similar to VAST-only setups you initialize the ad server request (`initAdPlaylist()`) 
and process the ad server response (`startAdPlaylist()`).
Instead of providing the entire environmentVars as beforehand, you only supply the `vastMacros` property.
The other environmentVars are requested from the `PlayerFacade` at runtime (see [PlayerFacade](#facade)).

Think of all the required macros and set the optional ones. See [IAB-Page](https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html).
Implement it like this:

```javascript
var vastMacros = {};

this.adPlaylistAPI.initAdPlaylist(adBreak, vastMacros).then(function () {
    this.adPlaylistAPI.startAdPlaylist();
}, function (failure) {
    console.log('something went wrong while requesting VMAP', failure);
});
```


<a name="init+comparison"></a>

### Initialization comparison
| v5                                                                                                                                   | v6                                                                                                                                                                                                              |
|--------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `smartclientcore.connect(PlayerFacade)` to create a instance of the smartclientcore VAST implementation for the given `PlayerFacade` | `smartclientcore.connect(PlayerFacade)`, `PlayerFacade` must match the `FacadeBase` interface version `3.2`                                                                                                     |
| `setup(GlobalConfig)` to instantiate the `PublisherAPI`                                                                              | `setup(GlobalConfig)`, but the API has been renamed to `AdSlotAPI`                                                                                                                                              |
| n/a                                                                                                                                  | introduces `smartclientcore.vmap.connect(PlayerFacade)` to create an instance of the smartclientcore VMAP and VAST implementation for the given `PlayerFacade` (based upon `FacadeBase` interface version `3.2`) |
| n/a                                                                                                                                  | `setup(GlobalConfig)` to instantiate the `AdPlaylistAPI` and `AdSlotAPI`                                                                                                                                        |
| `setup()` parameter `globalConfig`                                                                                                   | `GlobalConfig.adVerification.OMID` nested properties moved to <code>[GlobalConfig.adVerification](setup-global-config.md#adverification)<code>                                                                  |
| `setup()` parameter `globalConfig`                                                                                                   | The `GlobalConfig.adVerification.nonOMID` property has been removed                                                                                                                                             |

<a name="adslotapi"></a>

## PublisherAPI -> AdSlotAPI

Now that the **smartclientcore** offers two publisher APIs, the former `PublisherAPI` has been renamed
to `AdSlotAPI`.

<a name="adslotapi+methods"></a>

### Methods
| v5 PublisherAPI | v6 AdSlotAPI  |
| --- | --- |
| `initAdSlot()` parameter `adBreak` | The <code>[AdBreak](setup-sequential-config.md#adbreak+breakposition)</code> introduces a new property `adBreakPosition` that defines the execution point within the timeline of the underlying content. |
| `initAdSlot()` parameter `environmentVars` | The <code>[EnvironmentVars](setup-sequential-config.md#environmentvars+vastmacros)</code> property `macro` has been renamed to `vastMacros`. |
| `stopAdSlot()` returns void | `stopAdSlot()` returns `Promise` |


<a name="removals"></a>

## Removals

### Events

The `EVENT.ON_HOMAD_ACTIVATION` is no longer triggered in response to resolving the `AdReinsertion.activationCallback`,
because things need to be updated _before_ AdReinsertion is activated. So once you resolve the `activationCallback`,
make sure to move all the logic related to bypassing AdBlockers away from the event and into the callback method.

### Initialization

Since v5.2 the `setup` method must be called from the **smartclientcore** instance, that is returned from calling `connect`.
Calls to `smartclientcore.setup()` are no longer caught but fail with a Runtime Error. 

### Configuration

Pre Open Measurement methods are no longer supported. Logic and setup options (`GlobalConfig.adVerification.nonOMID`)
have been removed.
