[> Documentation-Index](index.md)

# smartclientcore - Events


## Table of contents
- [Ad and Ad-Slot Events](#ad-events)
- [Ad Playlist Events](#ad-playlist-events)
- [Event Cycle](#event-cycle)
- EVENT list
  - [Ad](#event-list-ad)
  - [AdSlot](#event-list-adslot)
  - [AdPlaylist](#event-list-adplaylist)


<a name="ad-events"></a>

## Ad and Ad-Slot Events

All events are accessible via the `smartclientcore.EVENT` Object.
For a full list please consult the console output from `console.log(smartclientcore.EVENT)`.

Common attributes of the event parameter object:
- **type** - Event type, see [Ad EVENT list](#event-list-ad) and [AdSlot EVENT list](#event-list-adslot)
- **timestamp** - Current client time `Date.now()`.
- **issuer** - Always `smartclip`.


<a name="ad-playlist-events"></a>

## Ad Playlist Events

All playlist events are accessible via the `smartclientcore.vmap.EVENT` Object.
For a full list please consult the console output from `console.log(smartclientcore.vmap.EVENT)`.

Common attributes of the event parameter object:
- **type** - Event type, see [AdPlaylist EVENT list](#event-list-adplaylist)
- **timestamp** - Current client time `Date.now()`.
- **issuer** - Always `smartclip`.


<a name="event-cycle"></a>

## Event Cycle

| AdPlaylist | AdSlot | Ad |
| ------------- | ----------| ----------|
| vmap.EVENT.ON_AD_PLAYLIST_LOADED | | |
| vmap.EVENT.ON_AD_PLAYLIST_START | | |
| vmap.EVENT.ON_AD_PLAYLIST_STARTED | | |
| | EVENT.ON_AD_MANIFEST_LOADED | |
| | EVENT.ON_AD_SLOT_START | |
| | EVENT.ON_AD_SLOT_STARTED | |
| | | EVENT.ON_AD_START |
| | | EVENT.ON_COMPANIONS_DETECTED,<br />EVENT.ON_EXTENSIONS_DETECTED,<br />EVENT.ON_ICONS_DETECTED,<br />EVENT.ON_CLOSED_CAPTIONS_DETECTED,<br />EVENT.ON_VERIFICATION_DETECTED |
| | | EVENT.ON_AD_LOADED |
| | | EVENT.ON_AD_STARTED |
| | | EVENT.ON_AD_IMPRESSION |
| | | EVENT.ON_AD_CREATIVE_VIEW |
| | EVENT.ON_AD_SLOT_DURATION_CHANGE | EVENT.ON_AD_PLAYBACK_START |
| | | EVENT.ON_AD_FIRST_QUARTILE |
| | | EVENT.ON_AD_MID_POINT |
| | | EVENT.ON_AD_THIRD_QUARTILE |
| | | EVENT.ON_AD_PLAYBACK_FINISHED |
| | | EVENT.EVENT.ON_AD_STOPPED |
| | | _next ad_ |
| | EVENT.ON_AD_SLOT_STOPPED | |
| | EVENT.ON_AD_SLOT_COMPLETE | |
| | _another adSlot_ | |
| vmap.EVENT.ON_AD_PLAYLIST_STOPPED | | |
| vmap.EVENT.ON_AD_PLAYLIST_COMPLETE | | |

<a name="event-list-ad"></a>

## Ad EVENT list
**ON_AD_CLICKED**
 - Is fired when the user clicks on the ad.

**ON_AD_ERROR**
 - Is fired when requesting or parsing of the manifest failed, also when ad playback failed.
_Check `PublicAd.error` and the [Error Codes Table](errorcodes.md) for details._

**ON_AD_LINEARITY_CHANGE**
 - Is fired when a VPAID ad changes its linearity.

**ON_AD_VIEWABLE**
- Is fired when the conditions from `GlobalConfig.viewability` are met.

**ON_AD_NOT_VIEWABLE**
- Is fired when the conditions from `GlobalConfig.viewability` are not met.

**ON_AD_VIEWABLE_STATE_CHANGE**
- Is fired when viewability state changes. Changes in value can be taken from the `PublicAd.viewability`. [AdSlotAPI
 PublicAd](AdSlotAPI.md#PublicAd)

**ON_AD_VIEWABLE_UNDETERMINED**
- Is fired when no measurement is possible because viewport or player size is missing.

**ON_AD_LOADED**
 - Is fired once a creative is loaded and ready for display.
                        
**ON_AD_MANIFEST_LOADED**
 - Is fired in response to a call to `AdSlotAPI.initAdSlot()`. The ad manifest (VAST tag) has been loaded.

**ON_AD_MANIFEST_LOAD_ERROR**  
 - Is fired in response to a call to `AdSlotAPI.initAdSlot()`.
  The ad manifest (VAST tag) couldn't be  loaded due to network or timing issues.
                       
**ON_AD_PLAYBACK_FINISHED**
 - Is fired when the playback of a single ad has been finished and reached 100%.
                 
**ON_AD_SKIPPABLE_STATE_CHANGE**
 - When an ad unit only allows its creative to be skipped within a specific time frame, it can use the   
 `ON_AD_SKIPPABLE_STATE_CHANGE` event to prompt the video player to check the value of the `adInfo.skippable` property,   
which keeps the video player updated on when the ad can be skipped and when it cannot be skipped.
                 
**ON_AD_SKIPPED**
 - Is fired when an ad has been skipped.
               
**ON_AD_STARTED**
 - Is fired when the playback of an ad has been started.

**ON_AD_FIRST_QUARTILE**
 - Is fired when the playback of a single ad has reached 25%.

**ON_AD_IMPRESSION**
 - Is fired when the user-visible phase of the ad has begun.

**ON_AD_MID_POINT**
 - Is fired when the playback of a single ad has reached 50%.

**ON_AD_NONLINEAR_STOPPED**
 - Is fired when a single non-linear ad has been stopped.

**ON_AD_PAUSED**
 - Is fired when the playback of a single ad has been paused.

**ON_AD_PLAYBACK_START**
 - Is fired when the playback of a single ad has been started, 0%.

**ON_AD_PLAYING**
 - Is fired when the playback of a single ad has been resumed.

**ON_AD_THIRD_QUARTILE**
 - Is fired when the playback of a single ad has reached 75%.

**ON_AD_SIZE_CHANGED**
 - Is fired when an ad has changed its size to what was provided with the `resize()` method.

**ON_AD_STOPPED**  
**ON_AD_FINISHED (_deprecated_)**
 - Is fired when a single ad has been stopped.   
  _(!) Double-check the attribute adVariant to find out whether this is the last ad or see `ON_AD_SLOT_COMPLETE`._

**ON_COMPANION_CLICKED**
 - Is fired when the user clicks on a companion ad. Requires the video player to call
  `AdSlotAPI.companionClickThrough(companionId, playerHandles)`.
	
**ON_COMPANION_CREATIVE_VIEW**
 - Is fired when a companion ad has been placed and got visible. Requires the video player to call
  `AdSlotAPI.companionView(companionId)`.

**ON_COMPANIONS_DETECTED**
 - Is fired when a manifest contains `<Companion>` ads. Companion ads can be requested through the API property
  **ad.companions**. 

**ON_EXTENSIONS_DETECTED**
 - Is fired when a manifest contains `<Extension>` nodes. Extensions can be requested through the API property
  **ad.extensions**. 

**ON_HOMAD_PENALTY**
 - Is fired when the HOMAD initialization has failed (ex: wrong clientConfig) or when HOMAD detected issues while   
  requesting an ad.

**ON_ICONS_DETECTED**
 - Is fired when a manifest contains `<Icon>` nodes. Industry icons can be requested through the API property
  **ad.icons**. 

**ON_NONLINEAR_DETECTED**
- Is fired when `GlobalConfig.playerHandlesNonLinear` is true and manifest contains `<NonLinearAds>` nodes.
  **ad.nonLinear**.

**ON_VERIFICATION_DETECTED**
 - Is fired when a manifest contains `<Verification>` nodes. AdVerifications can be requested through the API property
  **ad.verifications**.


<a name="event-list-adslot"></a>

## AdSlot EVENT list
**ON_AD_SLOT_START**
 - Is fired when an ad-break has been requested.

**ON_AD_SLOT_STARTED**
 - Is fired when the playback of the first ad for the current ad-break has been started, most likely the OPENER.

**ON_AD_SLOT_DURATION_CHANGED**
 - Is fired when the overall duration of an ad-break has been changed.

**ON_AD_SLOT_STOPPED**  
**ON_AD_SLOT_FINISHED (_deprecated_)**
 - Is fired when the playback of all ads for the current ad-break has finished, most likely after the CLOSER.

**ON_AD_SLOT_COMPLETE**
 - Is fired when an ad-break has been finished, regardless whether the requested ad manifest contained valid ads or not.


<a name="event-list-adplaylist"></a>

## AdPlaylist EVENT list
**ON_AD_PLAYLIST_LOADED**
 - Is fired in response to a call to `AdPlaylistAPI.initAdPlaylist()`.
  The ad playlist (VMAP tag) has been loaded.

**ON_AD_PLAYLIST_LOAD_ERROR**
 - Is fired in response to a call to `AdPlaylistAPI.initAdPlaylist()`.
  The ad playlist (VMAP tag) couldn't be  loaded due to network or timing issues.

**ON_AD_PLAYLIST_START**
 - Is always fired in response to a call to `AdPlaylistAPI.startAdPlaylist()`.
  It is the very first event before the content or any ad has started playing. 

**ON_AD_PLAYLIST_STARTED**
 - Is fired when the AdPlaylist has started processing. If scheduled in the VMAP tag, the smartclientcore
  starts requesting the preroll position. Otherwise it requests the player (facade) to start the content right away.

**ON_AD_PLAYLIST_STOPPED**
 - Is fired when the processing of the AdPlaylist is finished. The playback of the content has stopped and 
  (if scheduled in the VMAP tag) the postroll position was also delivered.

**ON_AD_PLAYLIST_COMPLETE**
 - Is always fired at the end. The content as well as all ads have finished.
