# Changelog
_Last Modified on 2025-09-25T10:08:11.362Z_

## 6.7.0 - released 2025-09-29
### Changed
- Safeguard `AdSlotAPI` getter and method with slot access.


## 6.6.6 - released 2025-09-17
### Changed
- Securing `AdSlotAPI.clickThrough` requests via the `PublicAd.hasClickThrough`.


## 6.6.5 - released 2025-08-28
### Changed
- In the case of `Nonlinear` with `IFrameResource`, the `PublicAd.hasClickThrough` return always `false`.

### Fixed
- ClickThroughURL consider only linear ads.


## 6.6.4 - released 2025-07-22
### Added
- Extension of the package with an ECMA2017 build without polyfills.

### Fixed
- If present in an Ad-Playlist (VMAP), the preroll position should be always triggered, regardless of whether the user 
  starts the content from the beginning or from a specified offset (“Keep Watching”).


## 6.6.3 - released 2025-07-09
### Fixed
- `PublicAd.hasClickThrough` returns in nonlinear case only `false` or `undefined`.
- No delivery of pre-/postroll if 0% or 100% is specifying as `timeOffset`.
- With strict offset function, prefetch is no longer executed if you fast-forward directly into the `prefetchOffset`
  time range.


## 6.6.2 - released 2025-05-08
### Fixed
- Not all `PublicAd` id arrays are ordered from the inside out.
- `PublicAd.adId` returns all ad ids from a AdPod.


## 6.6.1 - released 2025-05-02
### Changed
- PublicAd returns an array with ids via adId if there is a wrapper chain.

### Fixed
- In the case of SIMID and VPAID, creativeIds is not available.


## 6.6.0 - released 2025-04-29
### Added
- New properties `PublicAd.adIds` and `PublicAd.ids`.


## 6.5.0 - released 2025-04-03
### Added
- New properties `PublicAd.adServingId`, `PublicAd.creativeIds`, `PublicAd.universalAdId` and `PublicAd.universalAdIds`.
- Second option for VMAP offset handling for VMAP via `AdPlaylistSetup.strictOffsets`.


## 6.4.11 - released 2024-12-10
### Changed
- The check for whitelisted VPAID vendors requires exact matches with fully qualified domain names (FQDN), including both second-level and top-level domains.


## 6.4.10 - released 2024-08-07
### Fixed
- HomadUrlHandler remains active when sessionCoverage is false.


## 6.4.9 - released 2024-03-26
### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.4.12.


## 6.4.8 - released 2023-10-24
### Fixed
- AdReinsertion: HomadURLHandler is treated as custom URL handler.


## 6.4.7 - released 2023-10-10
### Fixed
- SIMID: Determining the communication path via the IFrame itself is no longer possible.


## 6.4.6 - released 2023-09-27
### Fixed
- VMAP: If there is no postroll, the playlist event cycle is incomplete.


## 6.4.5 - released 2023-08-08
### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.4.8.

### Fixed
- The measurement rate for measuring viewability increases with each additional ad.


## 6.4.4 - released 2023-07-25
### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.4.7.
- Updated HOMAD utils.

### Fixed
- Custom URLHandler is lost after preroll delivery.
- Duplicate insertion of the omid script.
- Forced activation is possible if `homad.enabled` in `GlobalConfig` is `false`.


## 6.4.3 - released 2023-06-20
### Fixed
- After a viewability measurement and the `ON_AD_STOPPED` event a second viewability tracker was fired.


## 6.4.2 - released 2023-06-01
### Changed
- The `adSourceSelector` now makes the selection directly before the start of each ad.
- Open Measurement (OM) for Web Video has been updated to SDK version 1.4.4.

### Fixed
- Macro `OMIDPARTNER` contains only the partner name without version.
- The `PublicAd` viewability data associated with the `ON_AD_VIEWABLE_STATE_CHANGE` event is not updated in a timely
  manner.
- When delivering a non-linear ad, `PublicAd.duration` returns the duration of the content.


## 6.4.1 - released 2023-05-04
### Changed
- The measurement via the viewability status change now takes place over the entire ad runtime.   


## 6.4.0 - released 2023-04-20
### Added
- A new property has been added to `PublicAd` to provide information about the `viewability` of the ad.
  Changes are communicated by the `ON_AD_VIEWABLE_STATE_CHANGE` event.
- Extension of the `GlobalConfig` with `adSourceSelector`. This gives the publisher the opportunity to choose a
  mediaFile/resource himself.
- Throw `ON_AD_SKIPPABLE_STATE_CHANGE` event for sponsored clips.

### Changed
- Updating documentation sections on `trackImpressionOnStart` and `vendorWhitelist`.

### Fixed
- `PublicAd.duration` returns the duration of the content when a non-linear ad is played.
- Postroll is not delivered if `prefetchOffset` is undefined or 0.


## 6.3.4 - released 2023-03-23
### Fixed
- Fast-forward monitoring not working on various mobile devices.
- Skipping parts of the content was not detected.


## 6.3.3 - released 2023-03-14
### Added
- Support for VMAP with multiple midrolls that have the same `timeOffset`.

### Fixed
- Lack of workflow monitoring to trigger appropriate trackers for mobile SDKs.
- Missing event `ON_AD_STARTED` when executing a simid ad.
- Playback of VMAP in fast-forward case and priority that the first skipped midroll is played back.


## 6.3.2 - released 2023-02-16
### Fixed
- OMID verification executed regardless of vendor whitelist.


## 6.3.1 - released 2023-01-27
### Fixed
- The `PublicAd.isInteractive` always specifies `false` for VPAIDs.


## 6.3.0 - released 2023-01-19
### Added
- The `PublicAdSlot` class has been extended with the `totalPlayableClips` and `totalPlayableCommercials` properties.
  These can be used to retrieve the maximum number of playable ads and the number of playable ads with the variant
  `COMMERCIAL`.

### Changed
- The order of the `desiredMimeTypes` array can be used to prioritize media selection.


## 6.2.2 - released 2023-01-13
### Added
- Throw tracker for faulty omid vendor script.

### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.4.2.
- The documentation for the `adSlotAPI.dispose()` method was misinterpreted and has been corrected.
  It only refers to the removal of SDK listeners.

### Fixed
- macro `APIFRAMEWORKS` default values contains only OMID and VPAID.
- SIMID ad continues to play after clickThrough request.


## 6.2.1 - released 2022-12-20
### Added
- Support for SIMID ad with multiple instances when the player is in an iFrame.


## 6.2.0 - released 2022-11-03
### Added
- SIMID Ad Support.

### Fixed
- A complete tracker is now always triggered when the VPAID is completely played.


## 6.1.11 - released 2022-10-11
### Changed
- Further improvement measures.


## 6.1.10 - released 2022-09-22
### Added
- Extension of `GlobalConfig` with `playerHandlesNonLinear`, so that the own implementation with all NonLinear can be
  realized with other SDKs.

### Changed
- Extend documentation with info on `environmentVars.desiredBitrate`.

### Fixed
- Firefox does cancel sending XHR requests.
- Inaccurate distinction between notViewable and viewUndetermined tracking.
- No separation clip of type bumper although `forcePlay` is true.


## 6.1.9 - released 2022-09-05
### Fixed
- Erroneous progress when playing a non-linear/non-linear interactive ad (VPAID).
- Progress trackers were triggered when playing a NonLinearAd.
- Missing measurement of visible impressions at AdStart.
- Replacing an AdPod with an AdBuffet results in missing information under the PublicAdSlot properties.


## 6.1.8 - released 2022-08-12
### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.3.36 (publisher part).

### Fixed
- The attribute `id` on a single VAST-ad is always `null`.
- The attributes under `Companion` were not read in completely.
- The default value for `adVerification.timeoutScriptLoad` contained an incorrect value in the documentation.


## 6.1.7 - released 2022-07-19
### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.3.36


## 6.1.6 - released 2022-07-15
### Fixed
- in the omid verification process, the corresponding adType is now submitted
- incomplete description of properties that are nested under `PublicAd.linear` 
- the VAST attribute fallbackOnNoAd is no longer ignored

### Removed
- Custom macro `TECHVERSION` is no longer used


## 6.1.5 - released 2022-07-06
### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.3.35

### Fixed
- provides a correct progress when an empty wrapper of the pod sequence is replaced by a buffet ad

### Added
- ad `type` on PublicAd exposed (`video`, `audio` or `hybrid`)
- `PublicAd.linear` and `PublicAd.nonLinear` contains a list of all relevant collected information from the VAST
  response from the currently running ad.


## 6.1.4 - released 2022-05-10
### Changed
- Open Measurement (OM) for Web Video has been updated to SDK version 1.3.34
- changelog is now linked from the API documentation index page


## 6.1.3 - released 2022-04-13
### Changed
- the XHR request timeout is no longer guarded with the `XMLHttpRequest.timeout` 
  because Firefox uses this value to artificially delay the outgoing request by that time. 
- better differentiate request errors between the initial call (primary ad-server) and
  subsequent calls (secondary ad-server, Wrapper)  
  | request | error type | error code before | after |
  | ------- | ---------- | ----------------- | ----- |
  | initial | empty response | 100 | 100 |
  | subsequent | request failed | 100 | 301 |
  | subsequent | empty response | 100 | 303 |

### Added
- ViewableImpression measurement with the possibility to set the threshold `GlobalConfig.viewability.area`
  and the time period `GlobalConfig.viewability.time` via the config.

### Fixed
- all URLs without explicit or unexpected protocol (`//`, `about`, `file`) are forced to HTTPS
- VAST Macro values (Array, Boolean, Number) not properly encoded using AdReinsertion through HOMAD
- Samsung TV (generation 2015) never resolves `initAdSlot()`
- after playing a nonLinear interactive ad (VPAID), the content did not continue


## 6.1.2 - released 2022-03-16
### Changed
- The `UNIVERSALADID` macro is replaced with all UniversalAdIDs, using a comma to separate them.

### Added
- add APPBUNDLE to macros (required if OM for App is supported, otherwise optional)
- `PublicAd.info.universalAdIds` (plural) contains a list of all collected Universal Ad IDs from VAST responses. 
  The property `PublicAd.info.universalAdId` (singular) remains as before and contains the last Universal Ad ID,
  most likely the one found in the VAST response.

### Removed
- Custom macros `APPNAME` and `BUNDLEPACKAGE` are no longer used. Use `APPBUNDLE` instead.

### Fixed
- All macros that are marked as optional or deprecated should default to -1
- There are TV devices for which `localStorage` is not available, a safeguard has been added
- Replay of VPAID creatives throws exception
- The VPAID ClickThrough event parameters `url` and `playerHandles` are not considered
- By default, HOMAD AdReinsertion must be deactivated after each ad slot


## 6.1.1 - released 2022-02-14
### Added
- The AdReinsertion logic is enabled first after running into any request or display issues. Sometimes it makes sense
  to enable AdReinsertion from the beginning and through the entire video session (smartclientcore lifecycle)
  by turning on both, the **new** `GlobalConfig.adReinsertion.forceActivation` and the 
  `GlobalConfig.adReinsertion.sessionCoverage` flags.

### Changed
- The `ON_HOMAD_PENALTY` event and the associated cancellation of the content is no longer triggered when 
  the AdReinsertion activation is rejected by either HOMAD (`corroborationCallback`) or the publisher
  (`activationCallback`). There is probably a good reason to not enable AdReinsertion, but not to penal the user.


## 6.1.0 - released 2022-01-18
### Changed
- Event ENUM keys have been adjusted to match with the event name and are renamed from `*_FINISHED` to `*_STOPPED`.  
  This makes the ENUM keys `*_FINISHED` deprecated.
- The rejection of AdReinsertion by the provider triggered a general VPAID error (901). This has been changed to an
  AdReinsertion declined error (64). 

### Added
- VAST 4.1+ Audio Ad Support
- Whenever the duration of an ad and thus the entire ad-break changes, the `EVENT.ON_AD_SLOT_DURATION_CHANGE`
  is triggered and the `PublicAdSlot.totalCommercialsDuration` is updated accordingly.
- AdPlaylist progress events that can be found in `smartclientcore.vmap.EVENT`

### Fixed
- The OMID session always closes 1 second after the ad ends. The specified time in
  `GlobalConfig.adVerification.sessionCleanupDelay` is not taken into account.
- The ad-slot property `PublicAdSlot.totalCommercialsDuration` does not consider changes at runtime.
  Changes can be caused by duration values in VAST tags that do not match the actual duration of the media file
  or by faulty ads being replaced by a buffet ad.
- URL macro values that represent an array with several entries weren't properly encoded according to IAB 4.1 (Point 6.1)
- VPAID creatives immediately cancel the next spot in case they delay their `ended` player event
- The `AdPlaylistSetup` documentation is incomplete

### Deprecated
- Since the facade interface works with both media players for audio and video, the method `getPlayerElement` (new)
  should be used in favor of using `getVideoElement`


## 6.0.2 - released 2021-12-17
### Fixed
- Duplicate `AdImpression` event with VPAID creatives


## 6.0.1 - released 2021-11-01
### Fixed
- VPAID creatives immediately cancel the next spot in case the player delays the `ended` event a little
- VPAID errors caused by the creative at runtime get tracked with error code 0 instead of 900
- Refreshing the OMID impression type during a sequence of ads (ad-pod) throws an error within the IAB vendor scripts.
  The script execution stops


## 6.0.0 - released 2021-08-26
### Changed
- Start using the changelog format based on [Keep a Changelog](https://keepachangelog.com) 
- `supportedFacadeVersion` returned the current facade version only.
  It has been replaced by `facadeVersion` (current version) and `supportedFacadeVersions` (list of supported versions)
- Updates Open Measurement (OM) for Web Video to SDK version 1.3.22. It replaces the previously used ad verification 
  logic from OM v1.2 as well as other proprietary logic.
  The OM setup properties moved from `GlobalConfig.adVerification.OMID` to `GlobalConfig.adVerification`.
- Introduces `AdBreak.adBreakPosition` that is either set through the sequential config, read from the VMAP tag or
  calculated at runtime based on the current content progress.
- The `EnvironmentVars` object `macro` has been renamed to `vastMacros`.
- Replaces VAST macro `OMIDPARTNER` and `BREAKPOSITION` in ad tag requests and trackers.
  `BREAKPOSITION` is read from VMAP tags or with VAST tags it can be specified when calling `initAdSlot()` (see `AdBreak.adBreakPosition`)
- Calling `stopAdSlot()` on the `AdSlotAPI` (a.k.a. `PublisherAPI`) additionally returns a Promise
  after the initial state is restored. The event `EVENT.ON_AD_SLOT_COMPLETE` is triggered as before.
- Non-Linear display timer is synched with the content progress, pausing the content
  increases the Non-Linear display duration accordingly.

### Added
- The ad inventory can be defined through Video Multiple Ad Playlist (VMAP).
  The VMAP implementation complements the VAST capabilities. It supports tags that either contain
  the VAST ad definitions within the VMAP response or references VAST tags from another source.
- The VMAP implementation introduces a new API for publishers `AdPlaylistAPI`. To make clear what one can expect from each
  of the both "PublisherAPIs", the API names changed to `AdSlotAPI` (formerly known as `PublisherAPI`) and `AdPlaylistAPI`.
- Ability to delay the impression and creativeView trackers until the ad video starts replaying
  (see `GlobalConfig.trackImpressionOnStart`).
- Option to auto-complete viewthrough trackers that have been skipped due to missing progress updates or other reasons
  (see `GlobalConfig.trackSkippedQuartiles`).

### Removed
- `EVENT.ON_HOMAD_ACTIVATION` is no longer triggered in response to resolving the `AdReinsertion.activationCallback`.
- The static API method `setup` must not be used. In order to allow multiple instances,
  one has to call the `setup` method from the instance API that is returned from calling `connect`.
- The undocumented `EnvironmentVars` object `vastMacroValues` has been removed in favour of `vastMacros`.
- With several options to prefer MP4 or to block VPAID (see `EnvironmentVars.desiredMimeTypes` and
  `EnvironmentVars.desiredVPAIDVendors`), the flag `GlobalConfig.preferVPAID` has been removed.
  If nothing is limited through `EnvironmentVars` and the VAST response contains various media files,
  the default behavior selects VPAID over a non-interactive video first.
- Custom AdVerification methods are no longer supported. Logic and setup options (`GlobalConfig.adVerification.nonOMID`)
  have been removed.

### Fixed
- Non-linear attributes `scalable` and `maintainAspectRatio` are not interpreted
- OMID: session error does not finish the session
- AdVerifications that lack the vendor attribute stop script execution
- AdWarning `TRACKER_TIMEOUT` prevents an ad from being replayed
- Duplicate `creativeView` trackers with VAST responses that contain NonLinear and Companion together


## 5.2.4 - released 2021-03-12
### Bugfixes
- Separation clips are shown in case the ad slot has no playable ads


## 5.2.3 - released 2021-03-03
### Bugfixes
- HOMAD initialization callbacks not executed or triggered twice
- Ad slot delivery crashes with non-standard "No-Ad" responses (capped tag, empty tag)
- The timeout to safeguard the Ad Reinsertion initialization with HOMAD may be abused by AdBlockers.
  The config property `homadReadiness` is no longer considered.
- VPAID asset URLs were not tested for the hostname. The check could be bypassed
  if one of the `desiredVPAIDVendor` hosts is placed somewhere in the parameter chain of the asset URL.
- Initializing an ad-slot can trigger an `AdError` event without an error code. The event has been replaced 
  with the `AdTagLoadFailed` event and error codes 21 (network issues) and 22 (timeout). 
- ES3 polyfill for Spread Operator (ES2015) not working on some SmartTV devices


## 5.2.2 - released 2020-12-03
### Bugfixes
- `PublicAd.wrappers` Access to loading times of failed wrapper requests throws a  
  _RangeError: Invalid time value at Date.toISOString()_
- The AdVerification tracking events must not be considered mandatory
- Some `PublicAd` properties do not contain the expected data but the whole string representation of the current ad


## 5.2.1 - released 2020-11-16
### Bugfixes
- AdError on first position is applied to all other ads of an AdPod
- Closed Captions not available
- AdParameters not available


## 5.2.0 - released 2020-10-28
### Features
- Ads playlist (manifest) for the upcoming ad-break has changed to work with an XML-representation of received ad tags.
  Instead of converting everything into a JavaScript-representation the XML can be requested from `PublisherAPI.rawXML` 
- Connecting smartclientcore with multiple video player instances at the same time (Multi-Instance support)
- Introduces new timeouts to safeguard the Ad Reinsertion initialization with HOMAD (`homadReadiness`)
  and ad slot completion (`contentRequest`)
- Wrapper data has been extended to include loading times for the request chain, see `PublicAd.wrappers`
- Introduces Ad Error code `110` on top of the existing code `100` to better differentiate no ad-server responses
  (those remain `100`) from malformed (but valid) ad-server responses (becomes `110`).
  
### Bugfixes
- NonLinear creatives of type IFrameResource not clickable.
- Duplicate trackers with wrapper tags from unsafe hosts.

### Other
- Add-on itself can't trigger all known IAB VAST errors. Instead of just referring to the official IAB VAST
  error codes table, the list of actual supported error codes can now be found in the documentation.


## 5.1.4 - released 2020-07-24
### Other
- Updated HOMAD vendor module


## 5.1.3 - released 2020-07-21
### Bugfixes
- pod ads with MediaFile errors weren't replaced with buffet ads at playtime
- activating the ad reinsertion through HOMAD does no longer stop & restart   
 the current ad slot but only replaces the ads playlist


## 5.1.2 - released 2020-06-18
### Other
- extended release package with custom build (ES5) 


## 5.1.1 - released 2020-06-08
### Bugfixes
- progress updates weren't stopped in case a VPAID creative has been   
 skipped manually or has been canceled due to an error
- requests to the pause/resume methods failed with VPAID creatives
- the individual `skipOffset` values from a VAST tag have overridden the global setting in some edge cases

### Other
- the Changelog is exported to the release package


## 5.1.0 - released 2020-05-08
### Features
- Introduces a new ad request method to fetch ad tags as JSONP response

### Bugfixes
- HTTP requests issues (not related to network issues) have been handled as if they were timeout issue
- Fixes display and JS errors with NonLinear Ads of type IFrameResource


## 5.0.1 - released 2020-04-09
### Features
- Introduces `PublisherAPI.getViewportSize()`
- Supports the VAST `MEDIAMIME` macro 

### Other
- Increases test coverage with code branches to 100%
- Updated description for Facade `lockContent` and `releaseContent`
- The Facade `handshake` returns more precise information on what failed exactly


## 5.0.0 - released 2020-03-23
### Features
- Introduces AdBreak type `nonlinear`
- enables import of the `smartclientcore` as a ES6 module

### Bugfixes
- invalid values with VAST macros that may change at runtime (CONTENTPLAYHEAD, MEDIAPLAYHEAD, PLAYERSIZE)
- timeout of wrapper chains didn't trigger

### Other
- Renames all occurrences of SpotX 
- Removes deprecated properties and methods from the `PublisherAPI` and `FacadeBase` <sub>*</sub>

<sub>* _Facade API version has been raised to 3.0. Changes are outlined in the migration guide._</sub>

## 4.10.1 - released 2020-03-11
### Hotfixes
- VPAID Clicktrackers from Wrapper not fired


## 4.10.0 - released 2020-02-07
### Features
- Added support for GDPR Transparency & Consent Framework APIs <sub>*</sub>

<sub>* _Applicable with web environments that provide the corresponding APIs._</sub>


## 4.9.1 - released 2020-03-11
### Hotfixes
- VPAID Clicktrackers from Wrapper not fired


## 4.9.0 - released 2020-01-23
### Features
- Introduces a PublisherAPI method `dispose`, which should be called before   
 initializing a new instance of the smartclientcore
- Triggers the `rewind` tracker with ads that are played multiple times (restarted ad-slot)

### Bugfixes
- Updated docs with a passage about `environmentVars.timeouts` that enable ad-slot specific timeout settings
- Time changes with VPAID 2.0 were not monitored properly
- VPAID (embedded) didn't resize as expected
- Errors get caught when calling `startAdSlot` before the `initAdSlot` Promise has been resolved
- Exponentially increasing calls to the specified AdReinsertion activation and corroboration callbacks   
 when `sessionCoverage` is disabled (default)


## 4.8.2 - released 2019-12-13
### Bugfixes
- HOMAD activation with invalid MediaFiles


## 4.8.1 - released 2019-12-11
### Bugfixes
- `homad_macros` must include the surrounding square brackets (`[ERRORCODE]` vs `ERRORCODE`)
- A single invalid pod ad was replaced by two buffet ads
- HOMAD not activated with MediaFile timeouts and request errors
- tracking requests through HOMAD caused superfluous AdWarnings. Tracker responses must not be evaluated.


## 4.8.0 - released 2019-12-04
### Features
- Improved logic to replace invalid ads in a pod with stand-alone ads (buffet) at runtime, see `prefetchBuffetAds` 
- Introduces `PublicAd.wrappers` that contain qualified wrapper ad objects.  
  This makes `PublicAd.info.wrapperTags` deprecated.
- Introduces `FacadeBase` version 2.2 with new methods `lockContent` and `releaseContent` that both return Promises.  
  This makes `setCurrentContentSource` and `resetCurrentContentSource` deprecated.

### Bugfixes
- CompanionAds --> collect Tracking events from wrappers
- HOMAD duplicate calls to the same ad server URL after the AdReinsertion has been activated


## 4.7.0 - released 2019-11-29
 ### Features
 - Introduces AdReinsertion logic to bypass ad-blockers. As a first vendor we support HOMAD.
 
 
## 4.6.1 - Staging only, released 2019-11-28
### Bugfixes
- Calling the PublisherAPI's play/pause methods did not actively toggle the playback state
- Skipping an ad did not increase the `PublicAdSlot.totalCommercialsCurrentTime` with the skipped time


## 4.6.0 - released 2019-10-29
### Features
- Adds new methods to perform companion creative view and clickthrough tracking
- Extends`ComanionAds` with a list of `CompanionAdResource` (type, resource)
- Introduces a descriptive `AdError` Object that provides specific diagnostic information 

### Bugfixes
- Companion ads may include one or multiple creative resource files
- Skippable state changes with VPAID creative files


## 4.5.1 - released 2019-10-22
### Bugfixes
- Collecting error trackers from wrapper chains
- Triggers the companions detected event only with companion ads that have at least one valid resource
- Removes the skippable state change event with non-commercial ads


## 4.5.0 - released 2019-10-09
### Features
- Introduces AdBreak setup with direct AdResponse, see setup.md#AdBreak
- (Beta) Introduces AdReinsertion logic to bypass ad-blockers. As a first vendor we support HOMAD.

### Bugfixes
- Duplicate trackers with ad-servers that doesn't support cross origin resource sharing (CORS)
- Callback methods specified with the publisher config got lost after schema-validation


## 4.4.0 - released 2019-08-27
### Features
- Introduces the `PublicAdSlot`, a collection of data that describes the current ad slot.
- Ability to force separation clips even if the ad-server request fails or if the response contains no valid ads.

### Bugfixes
- Calculation of ad-slot timings considering separation clips
- wrapper error tracker not properly fired with empty responses (VAST error code 303)
- documentation updates
- `maxWrapperDepth` counts per fork within a chain of wrappers
