import { Document as LinkeDocument, DocumentFragment, DOMParser, parseHTML } from 'linkedom';

/*
 * Copyright 2022-2024 Amazon.com, Inc. or its affiliates. All rights reserved.
 *
 * AMAZON PROPRIETARY/CONFIDENTIAL
 *
 * You may not use this file except in compliance with the terms and
 * conditions set forth in the accompanying LICENSE.TXT file.
 *
 * THESE MATERIALS ARE PROVIDED ON AN "AS IS" BASIS. AMAZON SPECIFICALLY
 * DISCLAIMS, WITH RESPECT TO THESE MATERIALS, ALL WARRANTIES, EXPRESS,
 * IMPLIED, OR STATUTORY, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
 */
declare global {
    namespace globalThis {
      var gmedia: any;
      var document: any;
      var Document: any;
      var DocumentFragment: any;
    }
  }
  
  class MockElement {
    tagName: string;
    attributes: { [key: string]: string } = {};
    childNodes: MockElement[] = [];
  
    constructor(tagName: string) {
      this.tagName = tagName;
    }
  
    set textContent(value: string) {
      if (this.tagName === '#text') {
        this.textContent = value;
      }
       else {
        this.childNodes = [new MockElement('#text')];
        this.childNodes[0].textContent = value;
      }
    }
  
    get textContent(): string {
      if (this.tagName === '#text') {
        return this.textContent;
      }
      return this.childNodes.map(child => child.textContent).join('');
    }
  
    createTextNode(text: string) {
      return text;
    }
  }

  class Document {
    createElement = (name: string) => {
      const { document } = parseHTML('<!DOCTYPE html><html><body></body></html>');
      const htmlObject = document.createElement(name);
      return htmlObject;
    }

    // possible to put linkedom textNode directly?
    createTextNode = (text: string) => {
      const textNode = new MockElement('#text');
      textNode.textContent = text;
      return textNode;
    };

    createDocumentFragment = (namespaceURI: string | null, nodeName: string | null, doctype: any) => {
      const { document } = parseHTML('<!DOCTYPE html><html><body></body></html>');
      const htmlObject = document.createElement(nodeName);
      return htmlObject;
    };
  
    getElementsByTagName = (name: string) => {
      console.log(`document.getElementsByTagName ${name}`);
      return [global.gmedia];
    };
  
    implementation = {

      createDocument: (namespaceURI: string | null, nodeName: string | null, doctype: any) => {
        
        const html = (new DOMParser).parseFromString(`<${nodeName}/>`, 'text/html');
        return html;
      },
    };
  
    documentElement: MockElement | null = null;
  
    static install() {
      console.log('Installing Document polyfill');

      global.document = new Document();
      global.Document = LinkeDocument;
      global.DocumentFragment = DocumentFragment;
    }
  }
  
  export default Document;
