[> Documentation-Index](index.md) [> Setup Guide](setup.md)

# smartClientCore

## Sequential Config
- [AdBreak](#adbreak)
  - [adBreakPosition](#adbreak+breakposition)
  - [type](#adbreak+type)
  - [tag](#adbreak+tag)
  - [response](#adbreak+response)
  - [limit](#adbreak+limit)
  - [opener](#adbreak+opener)
  - [closer](#adbreak+closer)
  - [bumper](#adbreak+bumper)
- [EnvironmentVars](#environmentvars)
  - [desiredBitrate](#environmentvars+desiredbitrate)
  - [desiredMimeTypes](#environmentvars+desiredmimetypes)
  - [desiredVPAIDVendors](#environmentvars+desiredvpaidvendors)
  - [deviceType](#environmentvars+devicetype)
  - [deviceScreenWidth](#environmentvars+devicescreenwidth)
  - [macro](#environmentvars+macro)
  - [networkReachability](#environmentvars+networkreachability)
  - [prefetchBuffetAds](#environmentvars+prefetchbuffetads)
  - [timeouts](#environmentvars+timeouts)

<a name="adbreak"></a>

### adBreak : <code>AdBreak</code>
Setup for an ad-break that defines the sequence of commercial ads, sponsored ads and separation clips.

Commercial and sponsored ads (variant NORMAL and SPONSORED) are defined by the ad-server VAST manifest.

Separation clips (variant OPENER, CLOSER, BUMPER) are optional. They can be defined by the publisher. 
Most likely they depend on the upcoming TV show or editorial video.

<a name="adbreak+breakposition"></a>

#### adBreakPosition : <code>AdBreakPosition</code>
_Optional_. Defines the position of the ad break within the timeline of the underlying content.
One of the values listed in the table below is expected. If omitted, the position of a linear ad break will be
calculated from the content progress. A non-linear ad break is by default `4` regardless of the content progress.

| Value | Description |
| ----- | ----------- |
| `PREROLL` | for preroll, content currentTime = 0 |
| `MIDROLL` | for midroll, content 0 < currentTime < duration |
| `POSTROLL` | for postroll content currentTime = duration |
| `NON_LINEAR` | for overlay/non-linear and standalone (Outstream), `AdBreak.type = smartclientcore.AD_TYPE.NON_LINEAR` |
| `AUTO` | for none of the above/other |


<a name="adbreak+type"></a>

#### type : <code>String</code>
_Optional_. Specifies the desired linearity of the upcoming ad slot.
Possible values are `smartclientcore.AD_TYPE.LINEAR` (the default if omitted) and `smartclientcore.AD_TYPE.NON_LINEAR`.

<a name="adbreak+tag"></a>

#### tag : <code>string, Array&lt;String&gt;</code>
_Mandatory <sup>*</sup>_. Defines the ad-request URL(s) that return a VAST manifest. Allowed values are:
 - a single URL, ex. ad fill rate is ensured by the ad-server, a multiple ads ad-break is defined by the ad-server 
 - an Array of URLs, ex. use Waterfalling with unknown ad fill rates, manual multiple ads ad-break setup

<a name="adbreak+response"></a>

#### response : <code>String</code>
_Mandatory <sup>*</sup>_. Defines a VAST manifest directly as a String.

> _<sup>*</sup> One of the **tag** or **response** property is required but both are not supported. 
> If both have been specified, **tag** will get preferred._

```kotlin
adSlotAPI.initAdSlot(adBreak = AdBreak(tag = "https://adserver-1.com/tag-pre?type=vast3xml"))

// or...
adSlotAPI?.initAdSlot(adBreak = AdBreak(
                    response = """
                        <VAST version="4.0">
                            <Ad id="example-inline-tag">
                                <InLine>
                                    <!-- example code -->
                                </InLine>
                            </Ad>
                        </VAST>
                        """
                ))
```

<a name="adbreak+limit"></a>

#### limit : <code>Number</code>
_Optional and applicable with Waterfalling only_. Defines the maximum number of impressions to be delivered from a chain of ad-requests.

> _All SPONSORED ads are also counted as valid impression. The limit value should be increased accordingly_

```kotlin
adSlotAPI.initAdSlot(
    adBreak = AdBreak(
        tag = arrayOf(
            "https://adserver-1.com/tag-pre?type=vast3xml",
            "https://adserver-2.com/tag-pre?type=vast3xml",
            "https://fallback-adserver.com/tag-pre?type=vast3xml",
        ),
        limit = 2
    )
)
```

<a name="adbreak+opener"></a>

#### opener : <code>SeperationClip</code>
_Optional_. Applies to NORMAL and SPONSORED ads.
Intro video for the upcoming ad break, played before all other ads.

- **progressive : <code>String</code>** - _Mandatory_. An Array of objects to video files, used for progressive download.
 Multiple progressive files can be used, e.g. .mp4 and .webm files to support as many browsers as possible.
 
- **forcePlay : <code>Boolean</code>** - _Optional_. Defines whether the separation clip must be delivered with ads or always. Defaulting to `false`.

Other source properties are currently not supported nor required by the add-on. 
Future versions of the add-on may include streaming resources.

<a name="adbreak+closer"></a>

#### closer : <code>SeperationClip</code>
_Optional_. Applies to NORMAL and SPONSORED ads.
Outro video, played after all other ads.

- **progressive : <code>String</code>** - _Mandatory_. An Array of objects to video files, used for progressive download.
 Multiple progressive files can be used, e.g. .mp4 and .webm files to support as many browsers as possible.

- **forcePlay : <code>Boolean</code>** - _Optional_. Defines whether the separation clip must be delivered with ads or always. Defaulting to `false`.

Other source properties are neither supported nor required by the add-on.

<a name="adbreak+bumper"></a>

#### bumper : <code>SeperationClip</code>
_Optional_. Applies to NORMAL and SPONSORED ads.
Special intro video, played once when switching from commercial to sponsored ads or vice versa.
Not served if the ad-server response contains no ads of variant NORMAL or SPONSORED.

- **progressive : <code>String</code>** - _Mandatory_. An Array of objects to video files, used for progressive download.
 Multiple progressive files can be used, e.g. .mp4 and .webm files to support as many browsers as possible.

- **forcePlay : <code>Boolean</code>** - _Optional_. Defines whether the separation clip must be delivered with ads or always. Defaulting to `false`.

Other source properties are neither supported nor required by the add-on.

```kotlin
adSlotAPI.initAdSlot(
    adBreak = AdBreak(
        tag = "https://adserver-1.com/tag-pre?type=vast3xml",
        opener = SeparationClip(
            progressive = "https://yourpage.com/assets/opener-pre.mp4"
        )
    )
)
```

Example setup to play a static "Station Bumper"
```kotlin
adSlotAPI.initAdSlot(
    adBreak = AdBreak(
        opener = SeparationClip(
            progressive = "https://yourpage.com/assets/opener-pre.mp4",
            forcePlay: true
        )
    )
)
```

<a name="environmentvars"></a>

### environmentVars : <code>EnvironmentVars</code>

Used for passing implementation-specific runtime variables.

<a name="environmentvars+desiredbitrate"></a>

**desiredBitrate : <code>Number</code>** - _Optional_. Indicates the desired bitrate in kilobits per second (kbps). 
The player uses this information to select media files with an appropriate bitrate. Defaulting to `1000`. 

<a name="environmentvars+desiredmimetypes"></a>

**desiredMimeTypes : <code>Array&lt;String&gt;</code>** - _Optional_. Declaration of accepted media types (whitelist). 
Defaulting to types that the browser eventually is able to play. Types must be compliant with the [IANA Media Type standard]  
**_Note_**_: If set, this will override the plugin-internal media types._

<a name="environmentvars+desiredvpaidvendors"></a>

**desiredVPAIDVendors : <code>Array&lt;String&gt;</code>** - _Optional_. Declaration of accepted VPAID vendors (whitelist).
Each specified String has to represent an unique identifier that can be found within the creative media file URL, most likely the domain name.
If omitted, the plugin tries to deliver VPAID creatives from each vendor.  

<a name="environmentvars+devicetype"></a>

**deviceType : <code>String</code>** - _Optional_. Can be either `mobile`, `tablet`, `desktop` or `tv`. Defaulting to `null`.

<a name="environmentvars+devicescreenwidth"></a>

**deviceScreenSize : <code>Rect</code>** - _Optional_. Maximum size we can achieve when entering fullscreen.

<a name="environmentvars+macro"></a>

**vastMacros : <code>VastMacros</code>** - _Recommended_. A list of VAST macros to provide details about how and where the upcoming ad-break is shown.
Macro names must be compliant with the [VAST 4.x Macros].

```kotlin
Beispiel
```

<a name="environmentvars+networkreachability"></a>

**networkReachability : <code>String</code>** - _Optional_. Can be either `wwan`, `wifi` or `unreachable`. Defaulting to `null`.

<a name="environmentvars+prefetchbuffetads"></a>

**prefetchBuffetAds : <code>Boolean</code>** - _Optional_. In order to replace invalid ads in a pod of ads instantly at runtime,
buffet ads from wrapper responses must be loaded up-front. `prefetchBuffetAds` determines whether stand-alone ads (buffet) from 
wrapper tags will be loaded together with the pod of ads or not. Defaulting to `false` if omitted.

<a name="environmentvars+timeouts"></a>

**timeouts : <code>Timeouts</code>** - _Optional_. Definition of `timeouts` that replace global settings for the upcoming ad-break.
Take a look at section [Global Config timeouts](setup-global-config.md#timeouts) for relevant information.


[IANA Media Type standard]: https://www.iana.org/assignments/media-types/media-types.xhtml
[VAST 4.x Macros]: https://interactiveadvertisingbureau.github.io/vast/vast4macros/vast4-macros-latest.html
[OM SDK for Web Video]: https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKJS/#3-create-the-context
