[> Documentation-Index](index.md)

# __appname__ - Static API

The **static API** can be used to create and connect instances of the add-on with the video player.
It is available from the `tv.smartclip.smartclientcore` package.


## Table of contents
- [Methods](#methods)
- [Properties](#properties)
  
## Methods
### connect(player : PlayerFacade) : __appname__
Sets up a new add-on instance for the given video player.

### updateLastActivity()

Publish last activity.

Especially on Android TV, the app should signal to the SDK when a user interacts with app via manual input. This can be done like so:

SmartClientCore.updateLastActivity();

### setup(pluginSetup : [GlobalConfig](setup-global-config.md)) : AdSlotAPI(AdSlotAPI.md)>  
Configures the __appname__ instance with the given configuration, as specified in [Global Configuration](setup-global-config.md).
Returns [AdSlotAPI](AdSlotAPI.md) or throws [PluginError](AdSlotAPI.md#PluginError):

#### Setup Error - Codes Table
| Code | Description |
| ---- | ----------- |
| 60   | Invalid Setup - The specified `pluginSetup` does not match with the [GlobalConfig](setup-global-config.md) definition. |
| 61   | Player API not available - The PlayerFacade has not been connected before starting the setup process. |
| 62   | Ad Reinsertion Penalty - AdReinsertion initialization failed, either due to a invalid [configuration](setup-global-config.md#adreinsertion) or issues that must be answered by the AdReinsertion vendor. |
| 63   | Ad Reinsertion Initialization Timeout - AdReinsertion initialization took too long, either caused by the [timeout limitation](setup-global-config.md#timeouts) or issues that must be answered by the AdReinsertion vendor. |

#### How to catch Setup Errors
```kotlin
val videoViewFacade = VideoViewFacade(videoPlayer)
val globalConfig = GlobalConfig()

coreInstanceInterface = SmartClientCore.connect(videoViewFacade)?.apply {
	try {
		adSlotAPI = setup(globalConfig)
	} catch (failure: SetupException) {
		when (failure.code) {
			60 -> Log.i("[publisherModule]", "config not valid")
			61 -> Log.i("[publisherModule]", "Player API not available. Did you call `smartclientcore.connect(withYourPlayerFacade)` before?'")
			else -> Log.i("[publisherModule]", "Unknown setup error. ${failure.message}")
		}
	}
}
```
<sub>Sample code :: How to catch setup errors.</sub>

## Properties
### error: [PluginError](AdSlotAPI.md#PluginError)
Requests details about the most recent error that has occurred.

### supportedFacadeVersion: String
Returns the version number for the supported Facade interface.

## Enums
### tv.smartclip.smartclientcore.AD_TYPE
Declaration of ad types as ENUMs that can be used with requesting an ad slot.

### tv.smartclip.smartclientcore.EVENT: Enum
Declaration of events as ENUMs that occur during playback of a single ad or mutliple ads delivery.
See [__appname__ - Ad Events](events.md) for more details.

### EVENTS: Array
List of event names as defined in the EVENT enum.
