[> Documentation-Index](index.md)

## Classes

<dl>
<dt><a href="#AdSlotAPI">AdSlotAPI</a></dt>
<dd></dd>
</dl>

## Typedefs

<dl>
<dt><a href="#AdBreak">AdBreak</a> : <code>AdBreak</code></dt>
<dd><p>Definition of the upcoming ad slot.</p>
</dd>
<dt><a href="#EnvironmentVars">EnvironmentVars</a> : <code>EnvironmentVars</code></dt>
<dd><p>Used for passing implementation-specific runtime variables.</p>
</dd>
<dt><a href="#Wrapper">Wrapper</a> : <code>Array</code></dt>
<dd><p>List of URLs that have been requested during a chain of ad server requests.</p>
</dd>
<dt><a href="#UniversalAdID">UniversalAdID</a> : <code>UniversalAdID</code></dt>
<dd><p>A unique creative ID for the ad across multiple systems.</p>
</dd>
<dt><a href="#PublicAdSlot">PublicAdSlot</a> : <code>PublicAdSlot</code></dt>
<dd><p>Collection of data that describes the current ad slot.</p>
</dd>
<dt><a href="#PublicAd">PublicAd</a> : <code>PublicAd</code></dt>
<dd><p>Collection of data for the current running ad</p>
</dd>
<dt><a href="#AdInfo">AdInfo</a> : <code>AdInfo</code></dt>
<dd><p>Collection of data that describes the current video ad.</p>
</dd>
<dt><a href="#AdError">AdError</a> : <code>AdError</code></dt>
<dd><p>Description object of the most recent ad error or <code>null</code>.</p>
</dd>
<dt><a href="#Wrapper">Wrapper</a> : <code>Wrapper</code></dt>
<dd><p>Description object of a AdTag request.</p>
</dd>
<dt><a href="#CompanionAd">CompanionAd</a> : <code>CompanionAd</code></dt>
<dd><p>Secondary ads included in the VAST tag that accompany the video ad.</p>
</dd>
<dt><a href="#CompanionAdResource">CompanionAdResource</a> : <code>CompanionAdResource</code></dt>
<dd><p>Definition of a secondary ad by type.</p>
</dd>
<dt><a href="#Extension">Extension</a> : <code>Extension</code></dt>
<dd><p>Custom XML element that extends the video ad.</p>
</dd>
<dt><a href="#ClosedCaption">ClosedCaption</a> : <code>ClosedCaption</code></dt>
<dd><p>Subtitle files for the current creative in different languages</p>
</dd>
<dt><a href="#AdVerification">AdVerification</a> : <code>AdVerification</code></dt>
<dd><p>Object contains the executable and bootstrapping data required to run the
    measurement code for a single verification vendor.</p>
</dd>
<dt><a href="#PluginError">PluginError</a> : <code>PluginError</code></dt>
<dd><p>Description object of the most recent error or <code>null</code>.</p>
</dd>
</dl>

<a name="AdSlotAPI"></a>

## AdSlotAPI
**Kind**: global class  

* [AdSlotAPI](#AdSlotAPI)
    * [.ad](#AdSlotAPI+ad) ⇒ <code>[PublicAd](#PublicAd)</code>
    * [.adSlot](#AdSlotAPI+adSlot) ⇒ <code>[PublicAdSlot](#PublicAdSlot)</code>
    * [.error](#AdSlotAPI+error) ⇒ <code>[PluginError](#PluginError)</code>
    * [.rawXML](#AdSlotAPI+rawXML) ⇒ <code>String</code>
    * [.dispose()](#AdSlotAPI+dispose)
    * [.initAdSlot(adBreak: AdBreak, environmentVars: EnvironmentVars)](#AdSlotAPI+initAdSlot)
    * [.startAdSlot()](#AdSlotAPI+startAdSlot)
    * [.stopAdSlot()](#AdSlotAPI+stopAdSlot)
    * [.skipAd()](#AdSlotAPI+skipAd)
    * [.resize(size: ElementSize)](#AdSlotAPI+resize)
    * [.clickThrough(playerHandles: Boolean)](#AdSlotAPI+clickThrough) ⇒ <code>String</code>
    * [.iconClickThrough(iconProgram, playerHandles: Boolean)](#AdSlotAPI+iconClickThrough) ⇒ <code>String</code>
    * [.iconView(iconProgram)](#AdSlotAPI+iconView)
    * [.verificationNotExecuted(vendor, reason)](#AdSlotAPI+verificationNotExecuted)
    * [.companionView(companionId)](#AdSlotAPI+companionView)
    * [.companionClickThrough(companionId, playerHandles: Boolean)](#AdSlotAPI+companionClickThrough) ⇒ <code>String</code>
    * [.pauseAd()](#AdSlotAPI+pauseAd)
    * [.resumeAd()](#AdSlotAPI+resumeAd)

<a name="AdSlotAPI+ad"></a>

### adSlotAPI.ad ⇒ <code>[PublicAd](#PublicAd)</code>
Returns information about the current ad, like companions, icons, verifications and more.

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>[PublicAd](#PublicAd)</code> - Represents static information about the current ad  
<a name="AdSlotAPI+adSlot"></a>

### adSlotAPI.adSlot ⇒ <code>[PublicAdSlot](#PublicAdSlot)</code>
Returns information about the current ad-break, like times and more.

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>[PublicAdSlot](#PublicAdSlot)</code> - Represents static information about the current ad-break  
<a name="AdSlotAPI+error"></a>

### adSlotAPI.error ⇒ <code>[PluginError](#PluginError)</code>
Requests details about the most recent error that has occurred on the smartclientcore.

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>[PluginError](#PluginError)</code> - Description object of the most recent error or `null`.  
<a name="AdSlotAPI+rawXML"></a>

### adSlotAPI.rawXML ⇒ <code>String</code>
Returns the XML representation of the entire ad slot.

**Kind**: instance property of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>String</code> - XML as live parsable DOM representation, querySelector and similar work on this  
<a name="AdSlotAPI+dispose"></a>

### adSlotAPI.dispose()
Removes all event listeners.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+initAdSlot"></a>

### adSlotAPI.initAdSlot(adBreak, environmentVars)
Invokes a commercial break by requesting the specified ad setup from the ad server.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| adBreak | <code>[AdBreak](#AdBreak)</code> | Configuration for the upcoming ad break. |
| environmentVars | <code>[EnvironmentVars](#EnvironmentVars)</code> | Defines environment conditions for the upcoming ad break |

<a name="AdSlotAPI+startAdSlot"></a>

### adSlotAPI.startAdSlot()
Starts the ad break.
The add-on responds by sending an `ON_AD_SLOT_START` event notifying the video player the ad break is going
 to start.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+stopAdSlot"></a>

### adSlotAPI.stopAdSlot()
Stops a running ad break.
The add-on responds by sending an `ON_AD_SLOT_COMPLETE` event notifying the video player it has closed and
cleaned up ad resources. Also the content of the video player has been reset.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+skipAd"></a>

### adSlotAPI.skipAd()
Skips (stops) a running single ad
The add-on responds by sending the `ON_AD_SKIPPED` event notifying the video player it has closed and cleaned up
a single ad.

_Note:
The add-on does proceed with the next ad. Canceling the whole ad break requires calling `stopAdSlot()` instead.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+resize"></a>

### adSlotAPI.resize(size)
Following a resize of the video player, the video player calls `resize()` to allow the add-on to scale
and reposition itself within the display area. The add-on responds by sending an `ON_AD_SIZE_CHANGED` event.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| size | <code>ElementSize</code> | The video content display as a Rectangle  and current viewing mode (normal, fullscreen, thumbnail, dynamic) |

<a name="AdSlotAPI+clickThrough"></a>

### adSlotAPI.clickThrough(playerHandles) ⇒ <code>String</code>
Following a click on the ad, the video player calls `clickThrough()` to allow the add-on
to request the advertisers landing page and call the ClickThru tracking requests.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>string</code> - The landing page URL.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| playerHandles | <code>Boolean</code> | <code>false</code> | Whether the player takes responsibility for opening the landing page URL. Defaulting to `false` if omitted. |

<a name="AdSlotAPI+iconClickThrough"></a>

### adSlotAPI.iconClickThrough(iconProgram, playerHandles) ⇒ <code>String</code>
Following a click on an Industry Icon ad, the video player calls `iconClickThrough()` to allow the add-on
to request the advertisers landing page and call the ClickThru tracking requests.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>String</code> - The landing page URL.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| iconProgram | <code>String</code> |  | The program represented in the icon |
| playerHandles | <code>Boolean</code> | <code>false</code> | Whether the player takes responsibility for opening the landing page URL. Defaulting to `false` if omitted. |

<a name="AdSlotAPI+iconView"></a>

### adSlotAPI.iconView(iconProgram)
The view tracking for icons is used to track when the icon creative is displayed.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| iconProgram | <code>string</code> | The program represented in the icon |

<a name="AdSlotAPI+verificationNotExecuted"></a>

### adSlotAPI.verificationNotExecuted(vendor, reason)
The player did not or was not able to execute the provided verification code.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| vendor | <code>String</code> | An identifier for the verification vendor. |
| reason | <code>Number</code> | The reason code corresponding to the cause of the failure. |

<a name="AdSlotAPI+companionView"></a>

### adSlotAPI.companionView(companionId)
Requests the view trackers when a creative resource is displayed. The method should be called for each resource
 file of a `Companion Ad`.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  

| Param | Type | Description |
| --- | --- | --- |
| companionId | <code>String</code> | Value of the `id` attribute from the `CompanionAd` object. |

<a name="AdSlotAPI+companionClickThrough"></a>

### adSlotAPI.companionClickThrough(companionId, playerHandles) ⇒ <code>string</code>
Following a click on a Companion ad, the video player calls `companionClickThrough()` to allow the add-on
to call the ClickThru tracking requests and request the advertisers landing page (most likely with
`StaticResource` creative resource only).

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
**Returns**: <code>string</code> - The landing page URL.  

| Param | Type | Default | Description |
| --- | --- | --- | --- |
| companionId | <code>String</code> |  | Value of the `id` attribute from the `CompanionAd` object. |
| playerHandles | <code>Boolean</code> | <code>true</code> | Whether the player takes responsibility for opening the landing page URL. Defaulting to `true` since most companion creatives do handle clickthroughs by their own (`HTMLResource`,  `IFrameResource`). |

<a name="AdSlotAPI+pauseAd"></a>

### adSlotAPI.pauseAd()
Pauses the current ad break. The add-on responds by sending the `ON_AD_PAUSED` event.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdSlotAPI+resumeAd"></a>

### adSlotAPI.resumeAd()
Resumes the current ad break. The add-on responds by sending the `ON_AD_PLAYING` event.

**Kind**: instance method of <code>[AdSlotAPI](#AdSlotAPI)</code>  
<a name="AdBreak"></a>

## AdBreak : <code>AdBreak</code>
Definition of the upcoming ad slot.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| type | <code>string</code> | of the ad slot.  See [`AdBreak.type`](setup-sequential-config.md#adbreak+type) Defaulting to `linear`. |
| adBreakPosition | <code>number</code> | of the ad slot.  See [`AdBreak.adBreakPosition`](setup-sequential-config.md#adbreak+breakposition) |
| tag | <code>string</code> | AdRequest URL |
| response | <code>string</code> | direct VAST XML |
| opener | <code>string</code> |  |
| bumper | <code>string</code> |  |
| closer | <code>string</code> |  |

<a name="EnvironmentVars"></a>

## EnvironmentVars : <code>EnvironmentVars</code>
Used for passing implementation-specific runtime variables.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| desiredBitrate | <code>number</code> | Indicates the desired bitrate in kilobits per second (kbps). The player uses this  information to select Mediafiles with an appropriate bitrate. Defaulting to `null`. |
| desiredMimeTypes | <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code> | Declaration of accepted media types. Defaulting to types that the  browser eventually is able to play. Types must be compliant with the  [IANA Media Type standard](https://www.iana.org/assignments/media-types/media-types.xhtml) |
| desiredVPAIDVendors | <code>[ &#x27;Array&#x27; ].&lt;string&gt;</code> | Declaration of accepted VPAID vendors (whitelist). Each specified  String has to represent an unique identifier that can be found within the creative media file URL, most likely the  domain name. If omitted, the plugin tries to deliver VPAID creatives from each vendor. |
| deviceType | <code>string</code> | Can be either `mobile`, `tablet`, `desktop` or `tv`. Defaulting to `null`. |
| deviceScreenSize | <code>Dimension</code> | Maximum size we can achieve when entering fullscreen. |
| networkReachability | <code>string</code> | Can be either `wan`, `wifi` or `unreachable`. Defaulting to `null`. |
| macro | <code>Object</code> | as defined by the VAST 4.1 specification. |
| vastMacroValues | <code>Object</code> | See `EnvironmentVars.macro`. |
| prefetchBuffetAds | <code>boolean</code> | In order to replace invalid ads in a pod instantly at runtime, buffet ads from  wrapper responses must be loaded up-front. `prefetchBuffetAds` determines whether stand-alone ads (buffet) will be  loaded together with the pod of ads or not. Defaulting to `false` if omitted. |
| adContainer | <code>HTMLElement</code> | The element that should be used to deliver non-video creative files. Defaulting to `null` if omitted. |

<a name="Wrapper"></a>

## Wrapper : <code>Array</code>
List of URLs that have been requested during a chain of ad server requests.

**Kind**: global typedef  
<a name="UniversalAdID"></a>

## UniversalAdID : <code>UniversalAdID</code>
A unique creative ID for the ad across multiple systems.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| idRegistry | <code>string</code> | A string used to identify the URL for the registry website where the unique creative  ID is cataloged. Defaulting to `unknown`. |
| idValue | <code>string</code> | A string identifying the unique creative identifier. Defaulting to `unknown`. |

<a name="PublicAdSlot"></a>

## PublicAdSlot : <code>PublicAdSlot</code>
Collection of data that describes the current ad slot.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| currentClip | <code>number</code> | Index of the current ad, regardless of its variant. |
| totalClips | <code>number</code> | Total number of ads within the current ad break, regardless of variants. |
| currentCommercial | <code>number</code> | Index of the current ad of variant `COMMERCIAL`. Defaulting to -1 |
| totalCommercials | <code>number</code> | Total number of ads with variant `COMMERCIAL` within the current ad break |
| totalCommercialsDuration | <code>number</code> | Total duration of ads with variant `COMMERCIAL` within the current  ad break |
| totalCommercialsCurrentTime | <code>number</code> | Current time of all ads with variant `COMMERCIAL` within the current  ad break |

<a name="PublicAd"></a>

## PublicAd : <code>PublicAd</code>
Collection of data for the current running ad

**Kind**: global typedef  
**Properties**

| Name            | Type                                                                                                | Description                                                                                                                                                                                                                                                                                               |
|-----------------|-----------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| adId            | <code>string</code> &#124; <code>null</code> &#124; <code>[ Array&lt;string&#124;null&gt;</code>    | Value of the `id` attribute from the `VAST > Ad` node. In the Wrapper Chain case, the IDs go from the root to the origin.                                                                                                                                                                                 |
| adServingId     | <code>string</code> &#124; <code>null</code>                                                        | A unique or pseudo-unique (long enough to be unique when combined with timestamp  data) GUID.                                                                                                                                                                                                             |
| creativeIds     | <code>[CreativeIds](#CreativeIds)</code> &#124; <code>null</code>                                   | Key value pair from all creative ids (adId/id).                                                                                                                                                                                                                                                           |
| closedCaptions  | <code>[Array&lt;ClosedCaption&gt;](#ClosedCaption)</code>                                           | The value of this property is an Array of caption details for the  `<ClosedCaption>` element. The video player should request this value whenever it receives the  [`ON_CLOSED_CAPTIONS_DETECTED`](events.md#event-list) add-on event.                                                                    |
| companions      | <code>[Array&lt;CompanionAd&gt;](#CompanionAd)</code>                                               | The value of this property is an Array that provides ad companion details  for each `<Companion>` element. The video player should request this value whenever it receives the  [`ON_COMPANIONS_DETECTED`](events.md#event-list) event.                                                                   |
| currentTime     | <code>Number</code>                                                                                 | Current time of ad in seconds                                                                                                                                                                                                                                                                             |
| duration        | <code>Number</code>                                                                                 | Duration of current ad, given in seconds                                                                                                                                                                                                                                                                  |
| error           | <code>[Array&lt;AdError&gt;](#AdError)</code>                                                       | Description object of the most recent ad error.                                                                                                                                                                                                                                                           |
| extensions      | <code>[Array&lt;Extension&gt;](#Extension)</code>                                                   | The value of this property is an Array that provides ad extension details  for the `<Extensions>` element. The video player should request this value whenever it receives the  [`ON_EXTENSIONS_DETECTED`](events.md#event-list) add-on event.                                                            |
| hasClickThrough | <code>Boolean</code>                                                                                | Returns whether the current ad has a ClickThrough target (URL) or not. Note: In the case of `Nonlinear` with `IFrameResource`, the result is always `false`.                                                                                                                                              |
| height          | <code>Number</code>                                                                                 | Height of the ad in pixels, as given from AdTag                                                                                                                                                                                                                                                           |
| icons           | <code>[ Array&lt;Icon&gt;</code>                                                                    | The value of this property is an Object that provides ad icon details for the  `<Icon>` element. The video player should request this value whenever it receives the  [`ON_ICONS_DETECTED`](events.md#event-list) add-on event.                                                                           |
| ids             | <code>[ Array&lt;string &#124; null&gt;</code>                                                      | Creative ids collection. In the Wrapper Chain case, the IDs go from the root to the origin.                                                                                                                                                                                                               |                                                                                                                                                                                                                                                                                 |
| info            | <code>[Array&lt;AdInfo&gt;](#AdInfo)</code>                                                         | Collection of data that describes the current video ad.                                                                                                                                                                                                                                                   |
| isExpanded      | <code>Boolean</code>                                                                                | Indicates if the ad is currently in a expanded state                                                                                                                                                                                                                                                      |
| isInteractive   | <code>Boolean</code>                                                                                | Returns whether the current ad is interactive (most likely by using __VPAID__)  or *  not.                                                                                                                                                                                                                |
| isLinear        | <code>Boolean</code>                                                                                | Indicates whether the ad’s current mode of operation is linear or non-linear.                                                                                                                                                                                                                             |
| isSkippable     | <code>Boolean</code>                                                                                | If true, the ad can be skipped, based on AdTag skip delay and configurable skipp  offset. Changes of the state can be monitored by listening on `ON_AD_SKIPPABLE_STATE_CHANGE`                                                                                                                            |
| linear          | <code>[[ &#x27;Array&#x27; ].&lt;Linear&gt;](#Linear)</code>                                        | The value of this property is an Array that provides linear creative  details for each `<Linear>` element.                                                                                                                                                                                                |
| remainingTime   | <code>Number</code>                                                                                 | Remaining time of ad in seconds                                                                                                                                                                                                                                                                           |
| skipOffset      | <code>Number</code>                                                                                 | Time in seconds when ad will become skippable based on playback progress. Will return  -1 if ad won't become skippable.                                                                                                                                                                                   |
| universalAdId   | <code>[UniversalAdId](#UniversalAdId)</code> &#124; <code>null</code>                               | A unique creative identifier that is maintained across different ad systems.                                                                                                                                                                                                                              |
| universalAdIds  | <code>[[ &#x27;Array&#x27; ].&lt;UniversalAdId&gt;](#UniversalAdId)</code> &#124; <code>null</code> | A list of multiple creative identifiers that are maintained across  different ad systems.                                                                                                                                                                                                                 |
| verifications   | <code>[Array&lt;AdVerification&gt;](#AdVerification)</code>                                         | The value of this property is an Array that provides details for  each `<Verification>` element. The video player may request this value whenever it receives the  [`ON_VERIFICATIONS_DETECTED`](events.md#event-list) add-on event, depending on whether the player takes care of  the Open Measurement. |
| viewability     | <code>Object</code>                                                                                 | get information about the visibility status, the corresponding threshold value and the  current visibility value.                                                                                                                                                                                         |
| volume          | <code>Number</code>                                                                                 | get and set volume of the current running ad                                                                                                                                                                                                                                                              |
| width           | <code>Number</code>                                                                                 | Width of the ad in pixels, as given from AdTag                                                                                                                                                                                                                                                            |
| wrappers        | <code>[Array&lt;Wrapper&gt;](#Wrapper)</code>                                                       | List of Wrapper objects, starting with the initial request up to the last  requested tag URI.                                                                                                                                                                                                             |


<a name="AdInfo"></a>

## AdInfo : <code>AdInfo</code>
Collection of data that describes the current video ad.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| adId | <code>String</code> | Value of the `id` attribute from the `VAST > Ad` node |
| title | <code>String</code> | Value of the `VAST > Ad > AdTitle` node |
| variant | <code>String</code> | Ad variant, depending on the current schedule and VAST manifest. |
| skippable | <code>Boolean</code> | The default value for this property is `false`. When the ad reaches a point where it  can be skipped, the ad unit updates this property to true and sends the `ON_AD_SKIPPABLE_STATE_CHANGE` event. The video player can check this property at any time, but should always check it when the  `ON_AD_SKIPPABLE_STATE_CHANGE` event is received. |
| duration | <code>Number</code> | Total time of the current ad |
| currentTime | <code>Number</code> | Current time of the current ad |
| universalAdID | <code>[UniversalAdID](#UniversalAdID)</code> | A unique creative identifier that is maintained across different ad systems. |

<a name="AdError"></a>

## AdError : <code>AdError</code>
Description object of the most recent ad error or `null`.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| code | <code>Number</code> | Code according to [Ad Error - Codes Table](errocodes.md#ad-error-codes) Error Codes Table. |
| timestamp | <code>Number</code> | Current client time `Date.now()` |
| description | <code>String</code> | A human-readable string which provides specific diagnostic information to help the reader understand the error condition which occurred. |

<a name="Wrapper"></a>

## Wrapper : <code>Array</code>
Description object of a AdTag request.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| url | <code>String</code> | Tag URI |
| loadStart | <code>String</code> | Current client ISO time when starting the request. |
| loadEnd | <code>String</code> | Current client ISO time after receiving the response. |
| loadTime | <code>Number</code> | Time in milliseconds between loadStart and loadEnd |

<a name="CompanionAd"></a>

## CompanionAd : <code>CompanionAd</code>
Secondary ads included in the VAST tag that accompany the video ad.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| id | <code>String</code> | Value of the `id` attribute from the `Creative > CompanionAds > Companion` node |
| companionXML | <code>String</code> | Full <Companion> node. |
| resources | <code>[Array&lt;CompanionAdResource&gt;](#CompanionAdResource)</code> | The companion ad may contain one or more resources to represent  different versions of the creative for use in different environments. The media player can choose which resource to  use when more than one resource file is provided. |

<a name="CompanionAdResource"></a>

## CompanionAdResource : <code>CompanionAdResource</code>
Definition of a secondary ad by type.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| type | <code>String</code> | Type of the companion creative resource. Can be either `StaticResource`, `IFrameResource` or `HTMLResource` |
| resource | <code>String</code> | The asset URL to be loaded. |

<a name="Extension"></a>

## Extension : <code>Extension</code>
Custom XML element that extends the video ad.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| type | <code>String</code> | The MIME type of any code that might be included in the extension. Type should be compliant with the [IANA Media Type standard](https://www.iana.org/assignments/media-types/media-types.xhtml) |
| extensionXML | <code>XML</code> | Full <Extension> node. |

<a name="ClosedCaption"></a>

## ClosedCaption : <code>ClosedCaption</code>
Subtitle files for the current creative in different languages

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| fileURL | <code>String</code> | URL to the subtitle file |
| type | <code>String</code> | MIME type of the offered file |
| language | <code>String</code> | Language of the file that is provided |

<a name="AdVerification"></a>

## AdVerification : <code>AdVerification</code>
Object contains the executable and bootstrapping data required to run the
	measurement code for a single verification vendor.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| vendor | <code>String</code> | An identifier for the verification vendor. |
| verificationParameters | <code>String</code> | Information intended for bootstrapping the verification code and providing metadata about the current impression. The format of the string is up to the individual vendor. |
| javascriptResource | <code>JavascriptResource</code> | Object with `url`, `apiFramework` and `browserOptional` |
| tracking | <code>Array</code> | Array of single tracking elements, e.g. `verificationNotExecuted`. |

<a name="PluginError"></a>

## PluginError : <code>PluginError</code>
Description object of the most recent error or `null`.

**Kind**: global typedef  
**Properties**

| Name | Type | Description |
| --- | --- | --- |
| code | <code>Number</code> | A number which represents the general type of error that occurred. |
| timestamp | <code>Number</code> | Current client time `Date.now()` |
| message | <code>String</code> | A human-readable string which provides specific diagnostic information to help the reader understand the error condition which occurred. |

