[> Documentation-Index](index.md)

# smartClientCore
## Implementation Guide

### Player Prerequisite: The Player API

#### Player Prerequisites
Certainly your app already includes a Video Player. Otherwise you should take this step first.
Next steps assume that your content videos run smoothly and fulfill the following preconditions:
- remove existing build-in ads setup

#### Installing
The add-on is provided as a android-library file `__libname__.aar` that can be used in two ways:
- by creating a new module and importing the aar into that module
- adding it as dependency into your gradle build (recommended)

##### Using the new module import approach
To add this SDK to a project extract the zip archive's contents, create a new module in Android Studio and import the aar file (File → New → New Module → Import .JAR/.AAR Package).
Next select the aar file from the extracted archive and set a proper "Subproject name" to be used for the smartclip SDK (for example SmartClientCore).
The smartclip SDK is shipped as an aar library file. It is developed in Kotlin using Kotlin Coroutines.
These dependencies should be part of the app's classpath (see below).

Within the app's build.gradle dependency section add the smartclip SDK dependency (replace SmartClientCore with the module name defined when importing the aar file).

```kotlin
dependencies {
    ...
    implementation project(":SmartClientCore")
    ...
}
```

Also add dependencies for the used libraries:

```kotlin
dependencies {
    ...
    implementation "org.jetbrains.kotlinx:kotlinx-coroutines-android:1.4.2"
    ...
}
```

##### adding it as dependency
To add this SDK to a project extract the zip archive's contents, and copy the aar into your projects `libs` folder

Within the app's build.gradle dependency section add the smartclip SDK dependency

```kotlin
dependencies {
    ...
	implementation(files("libs/__libname__.aar"))
	...
}
```


#### Safeguarding the Video Player
In order to avoid unexpected calls to the player API, it is not only recommended but **mandatory to safeguard the player API 
with your own facade** (proxy). The facade interface has to match with the **[Facade and Video Player Interface]**.

Using the facade has two main reasons:
- provide a generic player interface the plugin can safely talk to
- capture and validate requests made by this add-on towards the player API

For your reference the __appname__ package contains a interface `AndroidFacadeInterface` that can be used by your custom player facade.


```kotlin

Example: MyPlayerFacade.kt - Step 1: Build your own Facade
===============================================================
package tv.smartclip.smartclientcore.example

import tv.smartclip.smartclientcore.lib.interfaces.AndroidFacadeInterface

const val FACADE_VERSION = "3.0"

class AndroidFacade: AndroidFacadeInterface {
    override fun handshakeVersion(apiFacade: String): String {
        return FACADE_VERSION
    }
	...
```

### Basic Initialization

```kotlin

Example: MainActivity.kt - Step 2: Creation and setup of the add-on
===============================================================
package tv.smartclip.smartclientcore.example

...
import kotlinx.coroutines.runBlocking
import tv.smartclip.smartclientcore.lib.SmartClientCore
import tv.smartclip.smartclientcore.lib.interfaces.AdBreak
import tv.smartclip.smartclientcore.lib.interfaces.EnvironmentVars
import tv.smartclip.smartclientcore.lib.interfaces.AdSlotAPIInterface

class MainActivity : AppCompatActivity() {
	...
	private val globalAdConfig = ""
	private val adSlotAPI: AdSlotAPIInterface? = null
	...
	fun setupSmartClientCore() {
		runBlocking {
			adSlotAPI = SmartClientCore.connect(AndroidFacade())?.setup(globalAdConfig)
		}

	}
	...
}
```

[Facade and Video Player Interface]:FacadeBase.md
