[> Documentation-Index](index.md)

# __appname__ - Ad Events


## Table of contents
- [Ad Events](#ad-events)
- [EVENT list](#event-list)
  
## Ad Events

All events are accessible via the `tv.smartclip.smartclientcore.EVENTS` Enum.

Common attributes of the event parameter object:
- **type** - Event type, see [EVENT list](#event-list)
- **timestamp** - Current client time `Date.now()`.
- **issuer** - Always `smartclip`.


### EVENT list
**ON_AD_CLICKED**
 - Is fired when the user clicks on the ad.

**ON_AD_ERROR**
 - Is fired when requesting or parsing of the manifest failed, also when ad playback failed.
_Check `PublicAd.error` and the [Error Codes Table](errorcodes.md) for details._

**ON_AD_FINISHED**
 - Is fired when a single ad has been stopped.   
 _(!) Double-check the attribute adVariant to find out whether this is the last ad or see `ON_AD_SLOT_COMPLETE`._

**ON_AD_LINEARITY_CHANGE**
 - Is fired when a VPAID ad changes its linearity.

**ON_AD_MANIFEST_LOADED**
 - Is fired in response to a call to `AdSlotAPI.initAdSlot()`. The ad manifest (VAST tag) has been loaded.

**ON_AD_MANIFEST_LOAD_ERROR**  
 - Is fired in response to a call to `AdSlotAPI.initAdSlot()`.
  The ad manifest (VAST tag) couldn't be  loaded due to network or timing issues.

**ON_AD_PLAYBACK_FINISHED**
 - Is fired when the playback of a single ad has been finished and reached 100%.

**ON_AD_SCHEDULED**
 - Is fired when an ad manifest (VAST tag) was parsed and the ads have been added onto the queue.

**ON_AD_SKIPPABLE_STATE_CHANGE**
 - When an ad unit only allows its creative to be skipped within a specific time frame, it can use the   
 `ON_AD_SKIPPABLE_STATE_CHANGE` event to prompt the video player to check the value of the `adInfo.skippable` property,   
which keeps the video player updated on when the ad can be skipped and when it cannot be skipped.

**ON_AD_SKIPPED**
 - Is fired when an ad has been skipped.

**ON_AD_STARTED**
 - Is fired when the playback of an ad has been started.

**ON_AD_FIRST_QUARTILE**
 - Is fired when the playback of a single ad has reached 25%.

**ON_AD_IMPRESSION**
 - Is fired when the user-visible phase of the ad has begun.

**ON_AD_MID_POINT**
 - Is fired when the playback of a single ad has reached 50%.

**ON_AD_PAUSED**
 - Is fired when the playback of a single ad has been paused.

**ON_AD_PLAYBACK_START**
 - Is fired when the playback of a single ad has been started, 0%.

**ON_AD_PLAYING**
 - Is fired when the playback of a single ad has been resumed.

**ON_AD_THIRD_QUARTILE**
 - Is fired when the playback of a single ad has reached 75%.

**ON_AD_SLOT_START**
 - Is fired when an ad-break has been requested.

**ON_AD_SLOT_STARTED**
 - Is fired when the playback of the first ad for the current ad-break has been started, most likely the OPENER.

**ON_AD_SLOT_FINISHED**
 - Is fired when the playback of all ads for the current ad-break has finished, most likely after the CLOSER.

**ON_AD_SLOT_COMPLETE**
 - Is fired when an ad-break has been finished, regardless whether the requested ad manifest contained valid ads or not.

**ON_AD_SIZE_CHANGED**
 - Is fired when the add-on has changed its size to what was provided with the `resize()` method.

**ON_COMPANION_CLICKED**
 - Is fired when the user clicks on a companion ad. Requires the video player to call
  `AdSlotAPI.companionClickThrough(companionId, playerHandles)`.
	
**ON_COMPANION_CREATIVE_VIEW**
 - Is fired when a companion ad has been placed and got visible. Requires the video player to call
  `AdSlotAPI.companionView(companionId)`.

**ON_COMPANIONS_DETECTED**
 - Is fired when a manifest contains `<Companion>` ads. Companion ads can be requested through the API property
  **ad.companions**. 

**ON_EXTENSIONS_DETECTED**
 - Is fired when a manifest contains `<Extension>` nodes. Extensions can be requested through the API property
  **ad.extensions**. 

**ON_ICONS_DETECTED**
 - Is fired when a manifest contains `<Icon>` nodes. Industry icons can be requested through the API property
  **ad.icons**. 

**ON_VERIFICATION_DETECTED**
 - Is fired when a manifest contains `<Verification>` nodes. AdVerifications can be requested through the API property
  **ad.verifications**. 

**ON_HOMAD_PENALTY**
 - Is fired when the HOMAD initialization has failed (ex: wrong clientConfig) or when HOMAD detected issues while   
  requesting an ad.
